/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/


var aCivilites = new Arbre("ComboListe/combo-civilites.tmpl", "ofc-Civ");

var globalClientId = "";
var modif = false;
var ofc_adresseContact = "";


function initialiser(type) {
	try {

		document.getElementById("bMenuContacts").collapsed=false;
		document.getElementById('onglets').selectedIndex=0;

		if(type=="N") {
			globalClientId = "";
			globalContactId = "";
			document.getElementById('ofc-bRechCompte').disabled = false;
			document.getElementById('bofc-Supprimer').disabled = true;
			initContact();
			initCompte();
			document.getElementById('ofc-chercherAdresse').disabled = true;
			setModif(false);
		}
		else {
			document.getElementById('bofc-Supprimer').disabled = false;
			document.getElementById('ofc-bRechCompte').disabled = true;
			document.getElementById('ofc-chercherAdresse').disabled = false;
			var qLoad = new QueryHttp("CRM/GestionContacts/loadContactClient.tmpl");
			qLoad.setParam("Contact_Id", globalContactId);
			var result = qLoad.execute();

			document.getElementById('ofc-Civ').value = result.responseXML.documentElement.getAttribute("Civilite");
			document.getElementById('ofc-Nom').value = result.responseXML.documentElement.getAttribute("Nom");
			document.getElementById('ofc-Prenom').value = result.responseXML.documentElement.getAttribute("Prenom");
			document.getElementById('ofc-Fonction').value = result.responseXML.documentElement.getAttribute("Fonction");
			document.getElementById('ofc-Relation').value = result.responseXML.documentElement.getAttribute("Relation");
			document.getElementById('ofc-tel1').value = result.responseXML.documentElement.getAttribute("Tel_1");
			document.getElementById('ofc-Fax').value = result.responseXML.documentElement.getAttribute("Fax");
			document.getElementById('ofc-Email').value = result.responseXML.documentElement.getAttribute("Email");
			document.getElementById('ofc-tel2').value = result.responseXML.documentElement.getAttribute("Tel_2");
			document.getElementById('ofc-Infos').value = result.responseXML.documentElement.getAttribute("Infos");
			document.getElementById('ofc-denomination').value = result.responseXML.documentElement.getAttribute("Denomination");
			document.getElementById('ofc-Adresse_1').value = result.responseXML.documentElement.getAttribute("Adresse_1");
			document.getElementById('ofc-Adresse_2').value = result.responseXML.documentElement.getAttribute("Adresse_2");
			document.getElementById('ofc-Adresse_3').value = result.responseXML.documentElement.getAttribute("Adresse_3");
			document.getElementById('ofc-Code_Postal').value = result.responseXML.documentElement.getAttribute("Code_Postal");
			document.getElementById('ofc-Ville').value = result.responseXML.documentElement.getAttribute("Ville");
			document.getElementById('ofc-Pays').value = result.responseXML.documentElement.getAttribute("Pays");
			document.getElementById("ofc-Actif").checked = result.responseXML.documentElement.getAttribute("Actif")=="true";
			document.getElementById("ofc-Principal").checked = result.responseXML.documentElement.getAttribute("Principal")=="true";
			document.getElementById("ofc-Principal").disabled = document.getElementById("ofc-Principal").checked;
			document.getElementById("ofc-crit-1").checked = result.responseXML.documentElement.getAttribute("Critere_1")=="true";
			document.getElementById("ofc-crit-2").checked = result.responseXML.documentElement.getAttribute("Critere_2")=="true";
			document.getElementById("ofc-crit-3").checked = result.responseXML.documentElement.getAttribute("Critere_3")=="true";
			document.getElementById("ofc-crit-4").checked = result.responseXML.documentElement.getAttribute("Critere_4")=="true";
			document.getElementById("ofc-crit-5").checked = result.responseXML.documentElement.getAttribute("Critere_5")=="true";
			ofc_adresseContact = result.responseXML.documentElement.getAttribute("Adresse_Id");

			globalClientId = result.responseXML.documentElement.getAttribute("Client_Id");
			remplirInfoCompteContact();
			initFicheTachesEvenements();
		}

  } catch (e) {
  	recup_erreur(e);
	}
}


function initContact() {
	try {

		document.getElementById('ofc-Civ').value = "0";
		document.getElementById('ofc-Nom').value = "";
		document.getElementById('ofc-Prenom').value = "";
		document.getElementById('ofc-Fonction').value = "";
		document.getElementById('ofc-Relation').value="O";
		document.getElementById('ofc-tel1').value = "";
		document.getElementById('ofc-Fax').value = "";
		document.getElementById('ofc-Email').value = "";
		document.getElementById('ofc-tel2').value = "";
		document.getElementById('ofc-Infos').value = "";
		document.getElementById("ofc-Actif").checked = true;
		document.getElementById('ofc-denomination').value = "";
		document.getElementById('ofc-Adresse_1').value = "";
		document.getElementById('ofc-Adresse_2').value = "";
		document.getElementById('ofc-Adresse_3').value = "";
		document.getElementById('ofc-Code_Postal').value = "";
		document.getElementById('ofc-Ville').value = "";
		document.getElementById('ofc-Pays').value = "";
		document.getElementById("ofc-Principal").checked = false;
		document.getElementById("ofc-Principal").disabled = false;
		document.getElementById("ofc-crit-1").checked = false;
		document.getElementById("ofc-crit-2").checked = false;
		document.getElementById("ofc-crit-3").checked = false;
		document.getElementById("ofc-crit-4").checked = false;
		document.getElementById("ofc-crit-5").checked = false;
		ofc_adresseContact = "";

	} catch (e) {
		recup_erreur(e);
	}
}


function initCompte() {
	try {

		document.getElementById("ofc-DenomCompte").value="";
		document.getElementById("ofc-adresse1-compte").value="";
		document.getElementById("ofc-adresse2-compte").value="";
		document.getElementById("ofc-adresse3-compte").value="";
		document.getElementById("ofc-CP-compte").value="";
		document.getElementById("ofc-Ville-compte").value="";
		document.getElementById("ofc-Tel-compte").value="";
		document.getElementById("ofc-Fax-compte").value="";
		document.getElementById("ofc-Mail-compte").value="";
		document.getElementById("ofc-Pays-compte").value="";

	} catch (e) {
		recup_erreur(e);
	}
}


function ofc_rechercherCompte() {
	try {

		var url = "chrome://opensi/content/crm/gestion_tache_evenement/popup-rechercheCompte.xul";
	  window.openDialog(url,'','chrome,modal,centerscreen', ofc_retourRechercherCompte);

	} catch (e) {
		recup_erreur(e);
	}
}


function ofc_retourRechercherCompte(clientId) {
	try {

		globalClientId = clientId;
		remplirInfoCompteContact();

	} catch (e) {
		recup_erreur(e);
	}
}


function remplirInfoCompteContact() {
	try {

		var qLoad = new QueryHttp("CRM/GestionComptes/loadProspect.tmpl");
		qLoad.setParam("Client_Id", globalClientId);
		var result = qLoad.execute();

		var contenu = result.responseXML.documentElement;

		document.getElementById("ofc-DenomCompte").value = contenu.getAttribute("Denomination");
		document.getElementById("ofc-adresse1-compte").value = contenu.getAttribute("Adresse_1");
		document.getElementById("ofc-adresse2-compte").value = contenu.getAttribute("Adresse_2");
		document.getElementById("ofc-adresse3-compte").value = contenu.getAttribute("Adresse_3");
		document.getElementById("ofc-CP-compte").value = contenu.getAttribute("Code_Postal");
		document.getElementById("ofc-Ville-compte").value = contenu.getAttribute("Ville");
		document.getElementById("ofc-Tel-compte").value = contenu.getAttribute("Tel");
		document.getElementById("ofc-Fax-compte").value = contenu.getAttribute("Fax");
		document.getElementById("ofc-Mail-compte").value = contenu.getAttribute("Email");
		document.getElementById("ofc-Pays-compte").value = contenu.getAttribute("Nom_Pays");

		document.getElementById('ofc-chercherAdresse').disabled = false;
		setModif(false);

	} catch (e) {
		recup_erreur(e);
	}
}


function ofcNouveau() {
	try {

		initialiser("N");

	} catch (e) {
		recup_erreur(e);
	}
}


function ofcEnregistrer() {
	try {

		var civilite = document.getElementById('ofc-Civ').value;
		var nom = document.getElementById('ofc-Nom').value;
		var prenom = document.getElementById('ofc-Prenom').value;
		var fonction = document.getElementById('ofc-Fonction').value;
		var relation = document.getElementById('ofc-Relation').value;
		var infos = document.getElementById('ofc-Infos').value;
		var tel1 = document.getElementById('ofc-tel1').value;
		var tel2 = document.getElementById('ofc-tel2').value;
		var fax = document.getElementById('ofc-Fax').value;
		var email = document.getElementById('ofc-Email').value;
		var actif = document.getElementById('ofc-Actif').checked;
		var principal = document.getElementById('ofc-Principal').checked;
		var critere1 = document.getElementById("ofc-crit-1").checked;
		var critere2 = document.getElementById("ofc-crit-2").checked;
		var critere3 = document.getElementById("ofc-crit-3").checked;
		var critere4 = document.getElementById("ofc-crit-4").checked;
		var critere5 = document.getElementById("ofc-crit-5").checked;

		if (isEmpty(nom)) { showWarning("Veuillez sp\u00E9cifier le nom du contact !"); }
		else if (!isEmpty(tel1) && !isPhone(tel1)) { showWarning("Le num\u00E9ro de t\u00E9l\u00E9phone 1 est invalide !"); }
		else if (!isEmpty(tel2) && !isPhone(tel2)) { showWarning("Le num\u00E9ro de t\u00E9l\u00E9phone 2 est invalide !"); }
		else if (!isEmpty(fax) && !isPhone(fax)) { showWarning("Le num\u00E9ro de fax est invalide !"); }
		else if (!isEmpty(email) && !isEmail(email)) { showWarning("L'adresse e-mail est invalide !"); }
		else if (isEmpty(globalClientId)) { showWarning("Veuillez s\u00E9lectionner un compte !"); }
		else if (principal && !actif) { showWarning("Un contact principal ne peut pas \u00EAtre d\u00E9sactiv\u00E9"); }
		else {

			var qSave = new QueryHttp("CRM/GestionContacts/saveContactClient.tmpl");

			qSave.setParam("Civilite", civilite);
			qSave.setParam("Nom", nom);
			qSave.setParam("Prenom", prenom);
			qSave.setParam("Fonction", fonction);
			qSave.setParam("Relation", relation);
			qSave.setParam("Tel_1", tel1);
			qSave.setParam("Tel_2", tel2);
			qSave.setParam("Fax", fax);
			qSave.setParam("Email", email);
			qSave.setParam("Commentaires", infos);
			qSave.setParam("Client_Id", globalClientId);
			qSave.setParam("Contact_Id", globalContactId);
			qSave.setParam('Adresse_Id', ofc_adresseContact);
			qSave.setParam("Actif", actif);
			qSave.setParam("Principal", principal);
			qSave.setParam("Critere_1", critere1);
			qSave.setParam("Critere_2", critere2);
			qSave.setParam("Critere_3", critere3);
			qSave.setParam("Critere_4", critere4);
			qSave.setParam("Critere_5", critere5);

			var result = qSave.execute();
			globalContactId = result.responseXML.documentElement.getAttribute("Contact_Id");

			document.getElementById("ofc-Principal").disabled = principal;
			document.getElementById('bofc-Supprimer').disabled = false;
			document.getElementById('ofc-bRechCompte').disabled = true;
			document.getElementById('ofc-tabFS').disabled = false;
			document.getElementById('ofc-tabTE').disabled = false;

			setModif(false);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function ofc_pressOnSupprimer() {
	try {

		if (window.confirm("Voulez-vous supprimer ce contact ?")) {
			var qDelete = new QueryHttp("CRM/GestionContacts/deleteContactClient.tmpl");
			qDelete.setParam("Contact_Id", globalContactId);
			var result = qDelete.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else  {
				document.getElementById('ofc-tabFS').disabled = true;
				document.getElementById('ofc-tabTE').disabled = true;
				initialiser("N");
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function setModif(bool) {
	try {

 		modif = bool;

		if (bool) {
			document.getElementById('ofc-tabFS').setAttribute('image', 'chrome://opensi/content/design/icones/modified.png');
		}
		else {
			document.getElementById('ofc-tabFS').setAttribute('image', null);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function ofc_rechercherAdresse() {
  try {

		var url = "chrome://opensi/content/crm/commun/popup-choixAdresse.xul";
    window.openDialog(url,'','chrome,modal,centerscreen', ofc_reporterAdresse, globalClientId, true);

	} catch (e) {
  	recup_erreur(e);
  }
}


function ofc_reporterAdresse(denomination, adr1, adr2, adr3, cp, ville, pays, code_pays, adresseId) {
  try {

		document.getElementById("ofc-denomination").value = denomination;
		document.getElementById("ofc-Adresse_1").value = adr1;
		document.getElementById("ofc-Adresse_2").value = adr2;
		document.getElementById("ofc-Adresse_3").value = adr3;
		document.getElementById("ofc-Code_Postal").value = cp;
		document.getElementById("ofc-Ville").value = ville;
	  document.getElementById("ofc-Pays").value = pays;

		ofc_adresseContact = adresseId;
		setModif(true);

	} catch (e) {
  	recup_erreur(e);
  }
}

