/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/arbres.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/verif.js");


var aTaches = new Arbre("CRM/GestionTachesEvenements/list-tache.tmpl", "listeTaches");
var aEvenements = new Arbre("CRM/GestionTachesEvenements/list-evenement.tmpl", "listeEvenements");

var qListTA = new QueryHttp("CRM/GestionTachesEvenements/getDataListTA.tmpl");
var qListEV = new QueryHttp("CRM/GestionTachesEvenements/getDataListEV.tmpl");

var pageCouranteTA;
var nbPagesTA;

var pageCouranteEV;
var nbPagesEV;

var gProfil;



var actionCour = "";
var globalTacheId = "";
var globalEventId = "";
var respTache;



function initGestionTacheEvenement() {
	try {

		gProfil = getProfil();

		if (gProfil.isDirection()) {
			document.getElementById("labelListeResponsable").collapsed = false;
			document.getElementById("listeResponsable").collapsed = false;
		}
		else {
			document.getElementById("labelListeResponsable").collapsed = true;
			document.getElementById("listeResponsable").collapsed = true;
		}

		var aResponsables = new Arbre("ComboListe/combo-responsables.tmpl", "listeResponsable");
		aResponsables.initTree(initResponsable);

		var aActions = new Arbre("ComboListe/combo-actionsTacheEvenement.tmpl", "listeActions");
		aActions.initTree();

		oft_listeAction.setParam("Type_Action", "T");
		oft_listeAction.initTree(setModifie(false));
		ofe_listeResponsable.initTree(setModifieEvent(false));
		ofe_listeAction.setParam("Type_Action", "E");
		ofe_listeAction.initTree(setModifieEvent(false));

		var tacheId = ParamValeur('tacheId');
		var eventId = ParamValeur('eventId');

		if (tacheId!="") {
			globalTacheId = tacheId;
			chargerTache("");
			document.getElementById('deck').selectedIndex = 1;
		}
		else if (eventId!="") {
			globalEventId = eventId;
			chargerEvenement("");
			document.getElementById('deck').selectedIndex = 2;
		}

	} catch(e) {
		recup_erreur(e);
	}
}


function initResponsable() {
	try {

		document.getElementById("listeResponsable").value = gProfil.getLoggedUser();

	} catch (e) {
		recup_erreur(e);
	}
}


function initCriteres() {
	try {

		document.getElementById("numCompte").value = "";
		document.getElementById("contact").value = "";
		document.getElementById("numClient").value = "";
		document.getElementById("intitule").value = "";
		document.getElementById("dateDebut").value = "";
		document.getElementById("dateFin").value = "";
		document.getElementById("listeActions").value = "";
		document.getElementById("listeEtats").value = "";
		document.getElementById("listeResponsable").value = gProfil.getLoggedUser();

		listerTaches();
		listerEvenements();

	} catch (e) {
		recup_erreur(e);
	}
}


function pressOnCritere(ev) {
  try {

		if (ev.keyCode==13) {
			listerTaches();
			listerEvenements();
    }

	} catch (e) {
  	recup_erreur(e);
  }
}


function listerTout() {
	try {

		listerTaches();
		listerEvenements();

	} catch (e) {
		recup_erreur(e);
	}
}



// GESTION DES TACHES


function listerTaches() {
	try {

		var responsable = document.getElementById("listeResponsable").value;
		var denomination = document.getElementById("numCompte").value;
		var contact = document.getElementById("contact").value;
		var numClient = document.getElementById("numClient").value;
		var intitule = document.getElementById("intitule").value;
		var etat = document.getElementById("listeEtats").value;
		var action = document.getElementById("listeActions").value;
		var dateDebut = document.getElementById("dateDebut").value;
		var dateFin = document.getElementById("dateFin").value;
		var nbLignesParPage = document.getElementById('nbLignesParPageTA').value;

		pageCouranteTA = 1;
		nbPagesTA = 1;
		document.getElementById('pageDebTA').value = 1;
		document.getElementById('pageFinTA').value = 1;
		document.getElementById('bPrecTA').disabled = true;
		document.getElementById('bSuivTA').disabled = true;

		document.getElementById('listeTaches').disabled = true;
		document.getElementById('bEditionCsvTA').disabled = true;
		aTaches.deleteTree();

		qListTA.setParam("Responsable", responsable);
		qListTA.setParam("Denomination", denomination);
		qListTA.setParam("Contact", contact);
		qListTA.setParam("Num_Client", numClient);
		qListTA.setParam("Intitule", intitule);
		qListTA.setParam("Etat", etat);
		qListTA.setParam("PAction", action);
		qListTA.setParam("Date_Debut", dateDebut);
		qListTA.setParam("Date_Fin", dateFin);
		qListTA.setParam("Nb_Lignes_Par_Page", nbLignesParPage);
		qListTA.setParam("Current_Page", pageCouranteTA);

		var result = qListTA.execute();

		var contenu = result.responseXML.documentElement;

		nbPagesTA = contenu.getAttribute("Nb_Pages");
		var listTacheId = contenu.getAttribute("List_Tache_Id");

		aTaches.setParam("List_Tache_Id", listTacheId);
		aTaches.initTree(initPaginationTA);

	} catch (e) {
		recup_erreur(e);
	}
}


function initPaginationTA() {
	try {

		document.getElementById('pageDebTA').value = pageCouranteTA;
		document.getElementById('pageFinTA').value = (nbPagesTA>0?nbPagesTA:1);
		document.getElementById('bPrecTA').disabled = (pageCouranteTA==1);
		document.getElementById('bSuivTA').disabled = (pageCouranteTA>=nbPagesTA); // peut se produire si nbPagesTA=0

		afterMajPaginationTA();

	} catch (e) {
		recup_erreur(e);
	}
}


function pressOnPagePrecTA() {
	try {

		pageCouranteTA--;
		majPaginationTA();

	} catch (e) {
		recup_erreur(e);
	}
}


function pressOnPageSuivTA() {
	try {

		pageCouranteTA++;
		majPaginationTA();

	} catch (e) {
		recup_erreur(e);
	}
}


function majPaginationTA() {
	try {

		document.getElementById('pageDebTA').value = pageCouranteTA;
		document.getElementById('bPrecTA').disabled = (pageCouranteTA==1);
		document.getElementById('bSuivTA').disabled = (pageCouranteTA==nbPagesTA);

		document.getElementById('listeTaches').disabled = true;
		document.getElementById('bEditionCsvTA').disabled = true;

		qListTA.setParam("Current_Page", pageCouranteTA);
		var result = qListTA.execute();
		var listTacheId = result.responseXML.documentElement.getAttribute("List_Tache_Id");

		aTaches.setParam("List_Tache_Id", listTacheId);
		aTaches.initTree(afterMajPaginationTA);

	} catch (e) {
		recup_erreur(e);
	}
}


function afterMajPaginationTA() {
	try {

		document.getElementById('listeTaches').disabled = false;
		document.getElementById('bEditionCsvTA').disabled = (aTaches.nbLignes()==0);

	} catch (e) {
		recup_erreur(e);
	}
}


function pressOnNouveauTache() {
	try {

		document.getElementById('deck').selectedIndex = 1;
		document.getElementById("bMenuTachesEvenements").collapsed = false;
		chargerTache("N");

	} catch (e) {
		recup_erreur(e);
	}
}


function pressOnListeTaches(ev) {
  try {

		if (ev.keyCode==13) {
			ouvrirTache();
    }

	} catch (e) {
  	recup_erreur(e);
  }
}


function ouvrirTache() {
  try {

		if (aTaches.isSelected()) {
			// ces lignes devraient tre dans une fonction chargerTache()
			globalTacheId = aTaches.getSelectedCellText('Tache_Id');
			chargerTache("U");

			//ofc_tacheId = aTaches.getSelectedCellText('colTacheId');
			//chargerTache();
			//document.getElementById('bMenuTaches').collapsed = false;
			document.getElementById('deck').selectedIndex = 1;
		}

	} catch (e) {
  	recup_erreur(e);
  }
}


function pressOnEditionCsvTA() {
	try {

		var responsable = document.getElementById("listeResponsable").value;
		var denomination = document.getElementById("numCompte").value;
		var contact = document.getElementById("contact").value;
		var numClient = document.getElementById("numClient").value;
		var intitule = document.getElementById("intitule").value;
		var etat = document.getElementById("listeEtats").value;
		var action = document.getElementById("listeActions").value;
		var dateDebut = document.getElementById("dateDebut").value;
		var dateFin = document.getElementById("dateFin").value;

		var qEditionCsv = new QueryHttp("CRM/GestionTachesEvenements/csvTache.tmpl");

		qEditionCsv.setParam("Responsable", responsable);
		qEditionCsv.setParam("Denomination", denomination);
		qEditionCsv.setParam("Contact", contact);
		qEditionCsv.setParam("Num_Client", numClient);
		qEditionCsv.setParam("Intitule", intitule);
		qEditionCsv.setParam("Etat", etat);
		qEditionCsv.setParam("PAction", action);
		qEditionCsv.setParam("Date_Debut", dateDebut);
		qEditionCsv.setParam("Date_Fin", dateFin);

		var result = qEditionCsv.execute();

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}
		else {
			var fichier = result.responseXML.documentElement.getAttribute('FichierCSV');

			var file = fileChooser("save", fichier);
			if (file!=null) {
				downloadFile(getDirBuffer()+ fichier, file);
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}





// GESTION DES EVENEMENTS


function listerEvenements() {
	try {

		var responsable = document.getElementById("listeResponsable").value;
		var denomination = document.getElementById("numCompte").value;
		var contact = document.getElementById("contact").value;
		var numClient = document.getElementById("numClient").value;
		var intitule = document.getElementById("intitule").value;
		var action = document.getElementById("listeActions").value;
		var dateDebut = document.getElementById("dateDebut").value;
		var dateFin = document.getElementById("dateFin").value;
		var nbLignesParPage = document.getElementById('nbLignesParPageEV').value;

		pageCouranteEV = 1;
		nbPagesEV = 1;
		document.getElementById('pageDebEV').value = 1;
		document.getElementById('pageFinEV').value = 1;
		document.getElementById('bPrecEV').disabled = true;
		document.getElementById('bSuivEV').disabled = true;

		document.getElementById('listeEvenements').disabled = true;
		document.getElementById('bEditionCsvEV').disabled = true;
		aEvenements.deleteTree();

		qListEV.setParam("Responsable", responsable);
		qListEV.setParam("Denomination", denomination);
		qListEV.setParam("Contact", contact);
		qListEV.setParam("Num_Client", numClient);
		qListEV.setParam("Intitule", intitule);
		qListEV.setParam("PAction", action);
		qListEV.setParam("Date_Debut", dateDebut);
		qListEV.setParam("Date_Fin", dateFin);
		qListEV.setParam("Lieu", "");
		qListEV.setParam("Nb_Lignes_Par_Page", nbLignesParPage);
		qListEV.setParam("Current_Page", pageCouranteEV);

		var result = qListEV.execute();

		var contenu = result.responseXML.documentElement;

		nbPagesEV = contenu.getAttribute("Nb_Pages");
		var listEvenementId = contenu.getAttribute("List_Evenement_Id");

		aEvenements.setParam("List_Evenement_Id", listEvenementId);
		aEvenements.initTree(initPaginationEV);

	} catch (e) {
		recup_erreur(e);
	}
}


function initPaginationEV() {
	try {

		document.getElementById('pageDebEV').value = pageCouranteEV;
		document.getElementById('pageFinEV').value = (nbPagesEV>0?nbPagesEV:1);
		document.getElementById('bPrecEV').disabled = (pageCouranteEV==1);
		document.getElementById('bSuivEV').disabled = (pageCouranteEV>=nbPagesEV); // peut se produire si nbPagesEV=0

		afterMajPaginationEV();

	} catch (e) {
		recup_erreur(e);
	}
}


function pressOnPagePrecEV() {
	try {

		pageCouranteEV--;
		majPaginationEV();

	} catch (e) {
		recup_erreur(e);
	}
}


function pressOnPageSuivEV() {
	try {

		pageCouranteEV++;
		majPaginationEV();

	} catch (e) {
		recup_erreur(e);
	}
}


function majPaginationEV() {
	try {

		document.getElementById('pageDebEV').value = pageCouranteEV;
		document.getElementById('bPrecEV').disabled = (pageCouranteEV==1);
		document.getElementById('bSuivEV').disabled = (pageCouranteEV==nbPagesEV);

		document.getElementById('listeEvenements').disabled = true;
		document.getElementById('bEditionCsvEV').disabled = true;

		qListEV.setParam("Current_Page", pageCouranteEV);
		var result = qListEV.execute();
		var listEvenementId = result.responseXML.documentElement.getAttribute("List_Evenement_Id");

		aEvenements.setParam("List_Evenement_Id", listEvenementId);
		aEvenements.initTree(afterMajPaginationEV);

	} catch (e) {
		recup_erreur(e);
	}
}


function afterMajPaginationEV() {
	try {

		document.getElementById('listeEvenements').disabled = false;
		document.getElementById('bEditionCsvEV').disabled = (aEvenements.nbLignes()==0);

	} catch (e) {
		recup_erreur(e);
	}
}


function pressOnNouveauEvenement() {
	try {

		document.getElementById("ofe-HeureDebut").value = "12:00";
		document.getElementById("ofe-HeureFin").value = "12:00";
		document.getElementById('deck').selectedIndex = 2;
		document.getElementById("bMenuTachesEvenements").collapsed = false;
		chargerEvenement("N");

	} catch (e) {
		recup_erreur(e);
	}
}


function pressOnListeEvenements(ev) {
  try {

		if (ev.keyCode==13) {
			ouvrirEvenement();
    }

	} catch (e) {
  	recup_erreur(e);
  }
}


function ouvrirEvenement() {
  try {

		if (aEvenements.isSelected()) {
			// ces lignes devraient tre dans une fonction chargerEvenement()
			globalEventId = aEvenements.getSelectedCellText('Evenement_Id');
			chargerEvenement("U");

			//ofc_evenementId = aEvenements.getSelectedCellText('colEvenementId');
			//chargerEvenement();
			//document.getElementById('bMenuEvenements').collapsed = false;
			document.getElementById('deck').selectedIndex = 2;
		}

	} catch (e) {
  	recup_erreur(e);
  }
}


function pressOnEditionCsvEV() {
	try {

		var responsable = document.getElementById("listeResponsable").value;
		var denomination = document.getElementById("numCompte").value;
		var contact = document.getElementById("contact").value;
		var numClient = document.getElementById("numClient").value;
		var intitule = document.getElementById("intitule").value;
		var action = document.getElementById("listeActions").value;
		var dateDebut = document.getElementById("dateDebut").value;
		var dateFin = document.getElementById("dateFin").value;

		var qEditionCsv = new QueryHttp("CRM/GestionTachesEvenements/csvEvenement.tmpl");

		qEditionCsv.setParam("Responsable", responsable);
		qEditionCsv.setParam("Denomination", denomination);
		qEditionCsv.setParam("Contact", contact);
		qEditionCsv.setParam("Num_Client", numClient);
		qEditionCsv.setParam("Intitule", intitule);
		qEditionCsv.setParam("PAction", action);
		qEditionCsv.setParam("Date_Debut", dateDebut);
		qEditionCsv.setParam("Date_Fin", dateFin);
		qEditionCsv.setParam("Lieu", "");

		var result = qEditionCsv.execute();

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}
		else {
			var fichier = result.responseXML.documentElement.getAttribute('FichierCSV');

			var file = fileChooser("save", fichier);
			if (file!=null) {
				downloadFile(getDirBuffer()+ fichier, file);
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function retourMenuPrincipal() {
	try {

		if (modification || modifie) {
			var modif1="Voulez vous enregistrer les modifications apport\u00E9es \u00E0  ";
			var modif2;
			if (actionCour=="T") {
				modif2="la t\u00E2che"
			}else if (actionCour=="E") {
				modif2="l'\u00E9v\u00E8nement";
			}

			if (window.confirm(modif1+modif2+" ?")) {
				if (actionCour=="T") {
					oftEnregistrer("menu");
				}
				else if (actionCour=="E") {
					ofeEnregistrer("menu");
				}
			}
			else {
				window.location = "chrome://opensi/content/crm/menu_principal.xul";
			}
		}
		else {
			window.location = "chrome://opensi/content/crm/menu_principal.xul";
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function chargerTache(string) {
	try {

		actionCour ="T";
		document.getElementById("oft-listeResponsable").disabled = !gProfil.isDirection();
		if (string=="N") {
			document.getElementById("oft-listeEtats").value = "N";
			document.getElementById("oft-DateT").value = "";
			document.getElementById("oft-HeureT").value = "12:00";
			document.getElementById("oft-listePriorite").value = "N";
			document.getElementById("oft-Intitule").value = "";
			document.getElementById("oft-listeAction").value = "";
			document.getElementById("oft-libelle").value = "";
			document.getElementById("boft-Supprimer").disabled=true;
			respTache = gProfil.getLoggedUser();
		}
		else {
			var qTache = new QueryHttp("CRM/GestionTachesEvenements/loadTache.tmpl")
			qTache.setParam("tacheId", globalTacheId);

			var result = qTache.execute();

			var dateCreation = result.responseXML.documentElement.getAttribute("Date_C");
			var dateModification = result.responseXML.documentElement.getAttribute("Date_M");
			var utilC = result.responseXML.documentElement.getAttribute("Createur");
			var utilM = result.responseXML.documentElement.getAttribute("Modificateur");

			document.getElementById("StatBaroft-Creation").label="T\u00E2che cr\u00E9e le "+dateCreation+" par "+utilC;
			document.getElementById("StatBaroft-Modification").label="Derni\u00E8re modification le "+dateModification+" par "+utilM;

			document.getElementById("oft-listeEtats").value = result.responseXML.documentElement.getAttribute("Etat");
			respTache = result.responseXML.documentElement.getAttribute("Responsable");
			document.getElementById("oft-DateT").value = result.responseXML.documentElement.getAttribute("Date");
			document.getElementById("oft-HeureT").value = result.responseXML.documentElement.getAttribute("Heure");
			document.getElementById("oft-listePriorite").value = result.responseXML.documentElement.getAttribute("Priorite");
			document.getElementById("oft-Intitule").value = result.responseXML.documentElement.getAttribute("Intitule");
			document.getElementById("oft-libelle").value = result.responseXML.documentElement.getAttribute("Libelle");
			document.getElementById("oft-listeAction").value = result.responseXML.documentElement.getAttribute("Action");

			globalTacheProspectId = result.responseXML.documentElement.getAttribute("Client_Id");
			globalTacheContactId = result.responseXML.documentElement.getAttribute("Contact_Id");

			if (!isEmpty(globalTacheContactId)) {
				remplirContact();
			}

			remplirInfoCompte();
			document.getElementById("bRechercherContact").disabled = false;
			document.getElementById("bMenuTachesEvenements").collapsed = false;
		}
		oft_listeResponsable.initTree(initoft_listeResponsable);

	} catch(e) {
		recup_erreur(e);
	}
}


function retourListeT_E() {
	try {

		if (modification || modifie) {
			var modif1="Voulez vous enregistrer les modifications apport\u00E9es \u00E0  ";
			var modif2;
			if (actionCour=="T") {
				modif2="la t\u00E2che"
			}
			else if (actionCour=="E") {
				modif2="l'\u00E9v\u00E8nement";
			}
			if (window.confirm(modif1+modif2+" ?")) {
				if (actionCour=="T") {
					oftEnregistrer("liste");
				}
				else if (actionCour=="E") {
					ofeEnregistrer("liste");
				}
			}
			else {
				window.location = "chrome://opensi/content/crm/gestion_tache_evenement/gestionTacheEvenement.xul";
			}
		}
		else {
			window.location = "chrome://opensi/content/crm/gestion_tache_evenement/gestionTacheEvenement.xul";
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function chargerEvenement(string) {
	try {

		actionCour = "E";
		document.getElementById("ofe-listeResponsable").disabled = !gProfil.isDirection();
		if (string=="N") {
			ofe_listeResponsable.initTree(initofe_listeResponsable);
			document.getElementById("ofe-DateDebut").value = "";
			document.getElementById("ofe-DateFin").value = "";
			document.getElementById("ofe-Intitule").value = "";
			document.getElementById("ofe-listeAction").value = "";
			document.getElementById("ofe-Lieu").value = "";
			document.getElementById("ofe-Libelle").value = "";
			document.getElementById("bofe-Supprimer").disabled=true;
		}
		else {
			var qLoad = new QueryHttp("CRM/GestionTachesEvenements/loadEvenement.tmpl");
			qLoad.setParam("eventId", globalEventId);

			var result = qLoad.execute();

			var dateCreation = result.responseXML.documentElement.getAttribute("Date_C");
			var dateModification = result.responseXML.documentElement.getAttribute("Date_M");
			var utilC = result.responseXML.documentElement.getAttribute("Createur");
			var utilM = result.responseXML.documentElement.getAttribute("Modificateur");

			document.getElementById("StatBarofe-Creation-event").label="Ev\u00E8nement cr\u00E9e le "+dateCreation+" par "+utilC;
			document.getElementById("StatBarofe-Modification-event").label="Derni\u00E8re modification le "+dateModification+" par "+utilM;

			document.getElementById("ofe-DateDebut").value = result.responseXML.documentElement.getAttribute("Date_Debut");
			document.getElementById("ofe-HeureDebut").value = result.responseXML.documentElement.getAttribute("Heure_Debut");
			document.getElementById("ofe-DateFin").value = result.responseXML.documentElement.getAttribute("Date_Fin");
			document.getElementById("ofe-HeureFin").value = result.responseXML.documentElement.getAttribute("Heure_Fin");
			document.getElementById("ofe-Intitule").value = result.responseXML.documentElement.getAttribute("Intitule");
			document.getElementById("ofe-listeAction").value = result.responseXML.documentElement.getAttribute("Action");
			document.getElementById("ofe-Lieu").value = result.responseXML.documentElement.getAttribute("Lieu");
			document.getElementById("ofe-Libelle").value = result.responseXML.documentElement.getAttribute("Libelle");
			document.getElementById("ofe-listeResponsable").value = result.responseXML.documentElement.getAttribute("Responsable");
			globalEvenementProspectId = result.responseXML.documentElement.getAttribute("Client_Id");
			globalEvenementContactId = result.responseXML.documentElement.getAttribute("Contact_Id");

			if (!isEmpty(globalEvenementContactId)) {
				remplirContactEvenement();
			}

			remplirInfoCompteEvent();

			document.getElementById("ofe-bRechercherContact").disabled = false;
			document.getElementById("bMenuTachesEvenements").collapsed = false;
		}
		setModifieEvent(false);

	} catch (e) {
		recup_erreur(e);
	}
}




function rechercherClient() {
	try {

		var url = "chrome://opensi/content/facturation/user/clients/popup-rechercheClient.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', retourRechercherClient);

	} catch (e) {
		recup_erreur(e);
  }
}


function retourRechercherClient(numClient) {
	try {

		document.getElementById('numClient').value = numClient;

	} catch (e) {
		recup_erreur(e);
	}
}


function rechercherCompte() {
	try {

		var url = "chrome://opensi/content/crm/gestion_tache_evenement/popup-rechercheCompte.xul";
    window.openDialog(url,'','chrome,modal,centerscreen', retourRechercherCompte);

	} catch (e) {
		recup_erreur(e);
  }
}


function retourRechercherCompte(clientId) {
	try {

		var qGetCompte = new QueryHttp("CRM/GestionComptes/loadProspect.tmpl")
		qGetCompte.setParam("Client_Id", clientId);
		var result = qGetCompte.execute();
		document.getElementById("numCompte").value = result.responseXML.documentElement.getAttribute("Denomination");

	} catch (e) {
		recup_erreur(e);
	}
}
