/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/


var oer_aBonRetour = new Arbre('Facturation/Affaires/list-ligneRetourClient.tmpl', 'oer-bonRetour');
var oer_aBonLivraison = new Arbre('Facturation/Affaires/list-articlesNonRetournesBL.tmpl', 'oer-bonLivraison');
var oer_aVersion = new Arbre("Facturation/Affaires/list-versionRetourClient.tmpl","oer-listeVersion");
var oer_aLangues = new Arbre("ComboListe/combo-langues.tmpl", "oer-langueDefaut");
var oer_aDepots = new Arbre('ComboListe/combo-depotsStock.tmpl', 'oer-depot');

var oer_retourId;
var oer_bonLivId;
var oer_mode;
var oer_clientId = "";
var oer_etatBon;
var oer_currentCodePaysLiv;
var oer_langueDefaut;
var oer_selDepotId;
var oer_typeLiv;
var oer_assujettiTVA;
var oer_actSuiviSerie;
var oer_actEmplacements;
var oer_specLCAREC;
var oer_modified = false;
var oer_currentDepotId = "";



function oer_init() {
  try {

		document.getElementById('oer-rowFax').collapsed = !gShowFax;

		oer_actSuiviSerie = gConfig.isActSuiviSerie();
		var actSuiviLot = gConfig.isActSuiviLot();
		var actNbPieces = gConfig.isActNbPieces();
		oer_actEmplacements = gConfig.isActEmplacements();
		oer_specLCAREC = gConfig.isSpecLCAREC();

		document.getElementById('oer-bConsultSerieLigne').collapsed = !oer_actSuiviSerie;

		if (!actSuiviLot) {
			document.getElementById('oer-colNumLotDev').collapsed = true;
			document.getElementById('oer-colNumLotDev').setAttribute('ignoreincolumnpicker', true);
			document.getElementById('oer-colDatePeremptionDev').collapsed = true;
			document.getElementById('oer-colDatePeremptionDev').setAttribute('ignoreincolumnpicker', true);
			document.getElementById('oer-colNumLotLiv').collapsed = true;
			document.getElementById('oer-colNumLotLiv').setAttribute('ignoreincolumnpicker', true);
			document.getElementById('oer-colDatePeremptionLiv').collapsed = true;
			document.getElementById('oer-colDatePeremptionLiv').setAttribute('ignoreincolumnpicker', true);
		}

		if (!actNbPieces) {
			document.getElementById('oer-colNbPiecesDev').collapsed = true;
			document.getElementById('oer-colNbPiecesDev').setAttribute('ignoreincolumnpicker', true);
			document.getElementById('oer-colNbPiecesLiv').collapsed = true;
			document.getElementById('oer-colNbPiecesLiv').setAttribute('ignoreincolumnpicker', true);
			document.getElementById('oer-rowNbPieces').collapsed = true;
		}

		var aPaysLiv = new Arbre("ComboListe/combo-pays.tmpl", "oer-codePaysLiv");
		aPaysLiv.initTree(oer_initPaysLiv);

		if (gReadOnly) {
			document.getElementById('oer-bEnregistrer').collapsed = true;
			document.getElementById('oer-bImporterLignes').collapsed = true;
			document.getElementById('oer-tabBon').setAttribute('tooltiptext', "Lecture seule");
		}

  } catch (e) {
  	recup_erreur(e);
  }
}


function oer_initPaysLiv() {
	try {

		document.getElementById('oer-codePaysLiv').value = "FR";

	} catch (e) {
    recup_erreur(e);
  }
}


function oer_chargerDepot(selection) {
	try {

		oer_selDepotId = selection;
		oer_aDepots.setParam("Selection", selection);
		oer_aDepots.setParam("Depot_Vente", false);
		oer_aDepots.setParam("Depot_Quarantaine", true);
		oer_aDepots.initTree(oer_initDepot);

	} catch (e) {
		recup_erreur(e);
	}
}


function oer_initDepot() {
	try {

		document.getElementById('oer-depot').value = oer_selDepotId;

	} catch (e) {
		recup_erreur(e);
	}
}


function oer_reinitialiser() {
	try {

		oer_mode = "C";
		oer_etatBon = "N";
		oer_clientId = "";
		oer_selDepotId = "";
		oer_typeLiv = "";
		oer_currentDepotId = "";
		document.getElementById('oer-deckBonRetour').selectedIndex = 0;
		document.getElementById('oer-tabBoxBon').selectedIndex = 0;
		document.getElementById('oer-numClient').value = "";
		document.getElementById('oer-labelLogin').value = "";
		document.getElementById('oer-rowLoginWeb').collapsed = true;
		document.getElementById('oer-refRetourWeb').value = "";
		document.getElementById('oer-rowRefRetourWeb').collapsed = true;
		document.getElementById('oer-raisonSociale').value = "";
		document.getElementById('oer-adresseFact').value = "";
		document.getElementById('oer-adresse2Fact').value = "";
		document.getElementById('oer-adresse3Fact').value = "";
		document.getElementById('oer-codePostalFact').value = "";
		document.getElementById('oer-villeFact').value = "";
		document.getElementById('oer-affaire').value = "";
		document.getElementById('oer-denominationLiv').value = "";
		document.getElementById('oer-adresse1Liv').value = "";
		document.getElementById('oer-adresse2Liv').value = "";
		document.getElementById('oer-adresse3Liv').value = "";
		document.getElementById('oer-codePostalLiv').value = "";
		document.getElementById('oer-villeLiv').value = "";
		document.getElementById('oer-codePaysLiv').value = "FR";
		document.getElementById('oer-civInterLiv').value = "0";
		document.getElementById('oer-nomInterLiv').value = "";
		document.getElementById('oer-prenomInterLiv').value = "";
		document.getElementById('oer-telInter1Liv').value = "";
		document.getElementById('oer-telInter2Liv').value = "";
		document.getElementById('oer-faxInterLiv').value = "";
		document.getElementById('oer-emailInterLiv').value = "";
		document.getElementById('oer-tabBon').setAttribute('image', gReadOnly?'chrome://opensi/content/design/icones/readonly.png':null);

		oer_aDepots.deleteTree();
		document.getElementById('oer-depot').value = "";

		document.getElementById('oer-tabVersionDocument').collapsed = true;
		oer_aVersion.deleteTree();

		document.getElementById('oer-tabBoxAdresses').selectedIndex = 1;

		document.getElementById('oer-numero').value = "";
		document.getElementById('oer-dateRetour').value = "";
		document.getElementById('oer-etat').value = "";
		document.getElementById('oer-dateReception').value = "";
		document.getElementById('oer-commentairesFin').value = "";
		document.getElementById('oer-commentairesInt').value = "";
		document.getElementById('oer-nbPieces').value = "";
		document.getElementById('oer-quantite').value = "";
		document.getElementById('oer-creation').value = "";
		document.getElementById('oer-modification').value = "";
		document.getElementById('oer-fiche').value = "";
		document.getElementById('oer-typeRetour').selectedIndex = -1;
		oer_modified = false;

		document.getElementById('oer-chercherAdrLiv').disabled = true;
		document.getElementById('oer-chercherInterLiv').disabled = true;
		document.getElementById('oer-bChoisirMentions').disabled = true;
		document.getElementById('oer-bAjouter').disabled = true;
		document.getElementById('oer-bToutAjouter').disabled = true;
		document.getElementById('oer-bEnlever').disabled = true;
		document.getElementById('oer-bToutEnlever').disabled = true;
		document.getElementById('oer-bEnregistrer').disabled = true;
		document.getElementById('oer-bValiderBR').disabled = true;
		document.getElementById('oer-bValiderReception').disabled = true;
		document.getElementById('oer-bAnnuler').disabled = true;
		document.getElementById('oer-bSupprimer').disabled = true;
		document.getElementById('oer-bVisualiser').disabled = true;

		document.getElementById('oer-denominationLiv').setAttribute('readonly', true);
		document.getElementById('oer-adresse1Liv').setAttribute('readonly', true);
		document.getElementById('oer-adresse2Liv').setAttribute('readonly', true);
		document.getElementById('oer-adresse3Liv').setAttribute('readonly', true);
		document.getElementById('oer-codePostalLiv').setAttribute('readonly', true);
		document.getElementById('oer-villeLiv').setAttribute('readonly', true);
		document.getElementById('oer-codePaysLiv').disabled = true;
		document.getElementById('oer-civInterLiv').disabled = true;
		document.getElementById('oer-nomInterLiv').setAttribute('readonly', true);
		document.getElementById('oer-prenomInterLiv').setAttribute('readonly', true);
		document.getElementById('oer-telInter1Liv').setAttribute('readonly', true);
		document.getElementById('oer-telInter2Liv').setAttribute('readonly', true);
		document.getElementById('oer-faxInterLiv').setAttribute('readonly', true);
		document.getElementById('oer-emailInterLiv').setAttribute('readonly', true);

		document.getElementById('oer-commentairesFin').disabled = true;
		document.getElementById('oer-commentairesInt').disabled = true;
		document.getElementById('oer-nbPieces').disabled = true;
		document.getElementById('oer-quantite').disabled = true;
		document.getElementById('oer-bonLivraison').disabled = true;
		document.getElementById('oer-depot').disabled = true;
		document.getElementById('oer-typeRetour').disabled = true;

		document.getElementById('oer-bOuvrirCommentairesCaches').disabled = true;

		document.getElementById('oer-bConsultSerieLigne').disabled = true;
		document.getElementById('oer-bImporterLignes').disabled = true;

		document.getElementById('oer-bVisualiser').collapsed = true;
		document.getElementById('oer-bValiderBR').collapsed = true;
		document.getElementById('oer-bValiderReception').collapsed = true;
		document.getElementById('oer-boxRangement').collapsed = true;
		document.getElementById('oer-colCodeEmplacementLiv').collapsed = true;
		document.getElementById('oer-colCodeEmplacementLiv').setAttribute("ignoreincolumnpicker", true);
		document.getElementById('oer-colZoneStockageLiv').collapsed = true;
		document.getElementById('oer-colZoneStockageLiv').setAttribute("ignoreincolumnpicker", true);

		oer_resetLigneEmplacementRG();

		oer_aBonRetour.deleteTree();
		oer_aBonLivraison.deleteTree();

	} catch (e) {
		recup_erreur(e);
	}
}


function oer_debloquerChamps() {
	try {

		document.getElementById('oer-chercherAdrLiv').disabled = false;
		document.getElementById('oer-chercherInterLiv').disabled = false;
		document.getElementById('oer-bChoisirMentions').disabled = false;
		document.getElementById('oer-bAjouter').disabled = false;
		document.getElementById('oer-bToutAjouter').disabled = false;
		document.getElementById('oer-bEnlever').disabled = false;

		document.getElementById('oer-denominationLiv').removeAttribute('readonly');
		document.getElementById('oer-adresse1Liv').removeAttribute('readonly');
		document.getElementById('oer-adresse2Liv').removeAttribute('readonly');
		document.getElementById('oer-adresse3Liv').removeAttribute('readonly');
		document.getElementById('oer-codePostalLiv').removeAttribute('readonly');
		document.getElementById('oer-villeLiv').removeAttribute('readonly');
		document.getElementById('oer-codePaysLiv').disabled = false;
		document.getElementById('oer-civInterLiv').disabled = false;
		document.getElementById('oer-nomInterLiv').removeAttribute('readonly');
		document.getElementById('oer-prenomInterLiv').removeAttribute('readonly');
		document.getElementById('oer-telInter1Liv').removeAttribute('readonly');
		document.getElementById('oer-telInter2Liv').removeAttribute('readonly');
		document.getElementById('oer-faxInterLiv').removeAttribute('readonly');
		document.getElementById('oer-emailInterLiv').removeAttribute('readonly');

		document.getElementById('oer-commentairesFin').disabled = false;
		document.getElementById('oer-commentairesInt').disabled = false;
		document.getElementById('oer-nbPieces').disabled = false;
		document.getElementById('oer-quantite').disabled = false;
		document.getElementById('oer-codePaysLiv').disabled = false;
		document.getElementById('oer-bonLivraison').disabled = false;
		document.getElementById('oer-bEnregistrer').disabled = false;
		document.getElementById('oer-bSupprimer').disabled = false;
		document.getElementById('oer-bValiderReception').disabled = false;
		document.getElementById('oer-depot').disabled = false;
		document.getElementById('oer-typeRetour').disabled = false;

		document.getElementById('oer-bAjouter').disabled = true;
		document.getElementById('oer-bEnlever').disabled = true;

	} catch (e) {
    recup_erreur(e);
  }
}


function oer_selectionArticleBonLiv() {
	try {

		if (oer_aBonLivraison.isSelected()) {
			document.getElementById('oer-nbPieces').value = oer_aBonLivraison.getSelectedCellText('oer-colNbPiecesDev');
			document.getElementById('oer-quantite').value = oer_aBonLivraison.getSelectedCellText('oer-colQuantiteDev');

			document.getElementById('oer-bAjouter').disabled = false;
			document.getElementById('oer-bEnlever').disabled = true;
			oer_aBonRetour.clearSelection();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oer_nouveauBon() {
  try {

		oer_aBonLivraison.clearParams();
		oer_reinitialiser();

		oer_mode = "C";
		oer_retourId = "";

		var qGet = new QueryHttp('Facturation/Affaires/getInfosBonLivraison.tmpl');
		qGet.setParam('Bon_Liv_Id', oer_bonLivId);
		var result = qGet.execute();

		var contenu = result.responseXML.documentElement;

		oer_assujettiTVA = contenu.getAttribute("Assujetti_TVA");
		oer_typeLiv = contenu.getAttribute('Type_Liv');
		oer_clientId = contenu.getAttribute('Client_Id');

		document.getElementById('oer-numClient').value = contenu.getAttribute('Num_Client');
		document.getElementById('oer-denominationLiv').value = contenu.getAttribute('Denomination_Liv');
		document.getElementById('oer-adresse1Liv').value = contenu.getAttribute('Adresse_1_Liv');
		document.getElementById('oer-adresse2Liv').value = contenu.getAttribute('Adresse_2_Liv');
		document.getElementById('oer-adresse3Liv').value = contenu.getAttribute('Adresse_3_Liv');
		document.getElementById('oer-codePostalLiv').value = contenu.getAttribute('Code_Postal_Liv');
		document.getElementById('oer-villeLiv').value = contenu.getAttribute('Ville_Liv');
		document.getElementById('oer-codePaysLiv').value = contenu.getAttribute('Code_Pays_Liv');

		document.getElementById('oer-civInterLiv').value = contenu.getAttribute("Civ_Inter_Liv");
		document.getElementById('oer-nomInterLiv').value = contenu.getAttribute("Nom_Inter_Liv");
		document.getElementById('oer-prenomInterLiv').value = contenu.getAttribute("Prenom_Inter_Liv");
		document.getElementById('oer-telInter1Liv').value = contenu.getAttribute("Tel_Inter_1_Liv");
		document.getElementById('oer-telInter2Liv').value = contenu.getAttribute("Tel_Inter_2_Liv");
		document.getElementById('oer-faxInterLiv').value = contenu.getAttribute("Fax_Inter_Liv");
		document.getElementById('oer-emailInterLiv').value = contenu.getAttribute("Email_Inter_Liv");

		oer_chargerDepot(contenu.getAttribute("Depot_Id"));

		oer_aBonRetour.deleteTree();
		oer_aBonLivraison.setParam("Bon_Liv_Id", oer_bonLivId);
		oer_aBonLivraison.initTree();
		document.getElementById('oer-bVisualiser').collapsed = false;

		oer_setModified(false);
		document.getElementById('oer-bSupprimer').collapsed = true;
		document.getElementById('oer-bAnnuler').collapsed = true;
		oer_debloquerChamps();

		document.getElementById('oer-bEnregistrer').disabled = false;
		document.getElementById('oer-bValiderBR').disabled = true;
		document.getElementById('oer-bVisualiser').disabled = true;
		document.getElementById('oer-corpsBL').collapsed = false;
		document.getElementById('oer-boxActions').collapsed = gReadOnly;

		document.getElementById('oer-affaire').value = ofa_numAffaire;

	} catch (e) {
  	recup_erreur(e);
  }
}


function oer_chargerBon() {
  try {

		oer_reinitialiser();
  	oer_aBonLivraison.setParam('Retour_Id', oer_retourId);
		oer_aBonRetour.setParam('Retour_Id', oer_retourId);

		document.getElementById('oer-bVisualiser').collapsed = false;

		oer_mode = "M";
		var qLoad = new QueryHttp('Facturation/Affaires/loadRetourClient.tmpl');
		qLoad.setParam("Retour_Id", oer_retourId);
		var result = qLoad.execute();
		var contenu = result.responseXML.documentElement;

		oer_assujettiTVA = contenu.getAttribute("Assujetti_TVA");
		oer_typeLiv = contenu.getAttribute('Type_Liv');
		oer_etatBon = contenu.getAttribute("Etat");
		ofa_affaireId = contenu.getAttribute("Affaire_Id");
		oer_bonLivId = contenu.getAttribute("Bon_Liv_Id");

		document.getElementById('oer-bAnnuler').disabled = (ofa_etatAffaire=="C" || (oer_etatBon!="E" && oer_etatBon!="V"));

		if (oer_etatBon=="V" || oer_etatBon=="E") {
			document.getElementById('oer-etat').value = (oer_etatBon=="V"?"Cl\u00F4tur\u00E9":"En attente");
			document.getElementById('oer-bSupprimer').collapsed = true;
			document.getElementById('oer-bAnnuler').collapsed = (ofa_etatAffaire=="C" || gReadOnly);
			document.getElementById('oer-corpsBL').collapsed = true;
			document.getElementById('oer-boxActions').collapsed = true;
		}
		else if (oer_etatBon=="A") {
			document.getElementById('oer-etat').value = "Annul\u00E9";
			document.getElementById('oer-bSupprimer').collapsed = true;
			document.getElementById('oer-bAnnuler').collapsed = true;
			document.getElementById('oer-corpsBL').collapsed = true;
			document.getElementById('oer-boxActions').collapsed = true;
		}
		else {
			document.getElementById('oer-etat').value = "Non valid\u00E9";
			document.getElementById('oer-bAnnuler').collapsed = true;
			document.getElementById('oer-bSupprimer').collapsed = gReadOnly;
			document.getElementById('oer-corpsBL').collapsed = false;
			document.getElementById('oer-boxActions').collapsed = gReadOnly;
			document.getElementById('oer-bImporterLignes').disabled = false;
		}

		var typeRetour = contenu.getAttribute("Type_Retour");
		document.getElementById('oer-bVisualiser').collapsed = (oer_etatBon=='N');
		document.getElementById('oer-bValiderBR').collapsed = (oer_etatBon!='N' || gReadOnly);
		document.getElementById('oer-bValiderReception').collapsed = (oer_etatBon!='E' || gReadOnly);
		document.getElementById('oer-boxRangement').collapsed = !oer_actEmplacements || (oer_etatBon!="E" && !(oer_etatBon=="N" && oer_specLCAREC)) || typeRetour=="S" || gReadOnly;

		if (!oer_actEmplacements || (oer_etatBon=="N" && !oer_specLCAREC) || typeRetour=="S") {
			document.getElementById('oer-colCodeEmplacementLiv').collapsed = true;
			document.getElementById('oer-colCodeEmplacementLiv').setAttribute("ignoreincolumnpicker", true);
			document.getElementById('oer-colZoneStockageLiv').collapsed = true;
			document.getElementById('oer-colZoneStockageLiv').setAttribute("ignoreincolumnpicker", true);
		}
		else {
			document.getElementById('oer-colCodeEmplacementLiv').collapsed = false;
			document.getElementById('oer-colCodeEmplacementLiv').removeAttribute("ignoreincolumnpicker");
			document.getElementById('oer-colZoneStockageLiv').collapsed = false;
			document.getElementById('oer-colZoneStockageLiv').removeAttribute("ignoreincolumnpicker");
		}

		document.getElementById('oer-dateReception').value = contenu.getAttribute("Date_Retour");
		document.getElementById('oer-raisonSociale').value = contenu.getAttribute("Denomination");
		document.getElementById('oer-adresseFact').value = contenu.getAttribute("Adresse_1");
		document.getElementById('oer-adresse2Fact').value = contenu.getAttribute("Adresse_2");
		document.getElementById('oer-adresse3Fact').value = contenu.getAttribute("Adresse_3");
		document.getElementById('oer-codePostalFact').value = contenu.getAttribute("Code_Postal");
		document.getElementById('oer-villeFact').value = contenu.getAttribute("Ville");
		oer_clientId = contenu.getAttribute("Client_Id");
		document.getElementById('oer-numClient').value = contenu.getAttribute("Num_Client");
		document.getElementById('oer-labelLogin').value = contenu.getAttribute("Login_Web");
		document.getElementById('oer-rowLoginWeb').collapsed = (contenu.getAttribute("Web")=="false");
		var refRetourWeb = contenu.getAttribute("Ref_Retour_Web");
		document.getElementById('oer-refRetourWeb').value = refRetourWeb;
		document.getElementById('oer-rowRefRetourWeb').collapsed = isEmpty(refRetourWeb);
		document.getElementById('oer-affaire').value = contenu.getAttribute("Num_Affaire");

		document.getElementById('oer-dateRetour').value = contenu.getAttribute("Date_Bon");
		document.getElementById('oer-denominationLiv').value = contenu.getAttribute("Denomination_Liv");
		document.getElementById('oer-adresse1Liv').value = contenu.getAttribute("Adresse_1_Liv");
		document.getElementById('oer-adresse2Liv').value = contenu.getAttribute("Adresse_2_Liv");
		document.getElementById('oer-adresse3Liv').value = contenu.getAttribute("Adresse_3_Liv");
		document.getElementById('oer-codePostalLiv').value = contenu.getAttribute("Code_Postal_Liv");
		document.getElementById('oer-villeLiv').value = contenu.getAttribute("Ville_Liv");
		document.getElementById('oer-codePaysLiv').value = contenu.getAttribute("Code_Pays_Liv");
		document.getElementById('oer-commentairesFin').value = contenu.getAttribute("Commentaires_Fin");
		document.getElementById('oer-commentairesInt').value = contenu.getAttribute("Commentaires_Int");
		document.getElementById('oer-numero').value = contenu.getAttribute("Num_Retour");
		document.getElementById('oer-typeRetour').value = typeRetour;

		document.getElementById('oer-civInterLiv').value = contenu.getAttribute("Civ_Inter_Liv");
		document.getElementById('oer-nomInterLiv').value = contenu.getAttribute("Nom_Inter_Liv");
		document.getElementById('oer-prenomInterLiv').value = contenu.getAttribute("Prenom_Inter_Liv");
		document.getElementById('oer-telInter1Liv').value = contenu.getAttribute("Tel_Inter_1_Liv");
		document.getElementById('oer-telInter2Liv').value = contenu.getAttribute("Tel_Inter_2_Liv");
		document.getElementById('oer-faxInterLiv').value = contenu.getAttribute("Fax_Inter_Liv");
		document.getElementById('oer-emailInterLiv').value = contenu.getAttribute("Email_Inter_Liv");

		oer_chargerDepot(contenu.getAttribute("Depot_Id"));
		oer_currentDepotId = contenu.getAttribute("Depot_Id");

		document.getElementById('oer-creation').setAttribute("label","Retour cr\u00E9\u00E9 le "+ contenu.getAttribute('Date_Creation') +" par "+ contenu.getAttribute('Login_Creation'));
		document.getElementById('oer-modification').setAttribute("label","Derni\u00E8re modification le "+ contenu.getAttribute('Date_Maj') +" par "+ contenu.getAttribute('Login_Maj'));
		document.getElementById('oer-fiche').setAttribute("label","Retour N\u00B0 "+ contenu.getAttribute('Num_Retour'));
		document.getElementById('oer-creation').collapsed = false;
		document.getElementById('oer-modification').collapsed = false;

		document.getElementById('oer-bOuvrirCommentairesCaches').disabled = false;

		oer_aBonRetour.initTree();

		if (oer_etatBon!='N') {
			document.getElementById('oer-tabVersionDocument').collapsed=false;
			oer_initVersion();
		}

		oer_setModified(false);
		if (oer_etatBon!='V' && oer_etatBon!='E' && oer_etatBon!='A') {
			oer_aBonLivraison.setParam("Bon_Liv_Id", oer_bonLivId);
			oer_aBonLivraison.initTree();
			oer_debloquerChamps();
			document.getElementById('oer-bToutEnlever').disabled = false;
		}
		else if (oer_etatBon=='E') {
			document.getElementById('oer-bValiderReception').disabled = false;
		}

	} catch (e) {
  	recup_erreur(e);
  }
}


function oer_editerCommentairesInternes() {
  try {

  	var url = "chrome://opensi/content/facturation/user/commun/popup-commentairesInternes.xul";
  	window.openDialog(url,'','chrome,modal,centerscreen', "RC", oer_retourId, gReadOnly);

	} catch (e) {
  	recup_erreur(e);
  }
}


function oer_editerCommentairesDocument() {
  try {

		var commentairesFin = document.getElementById('oer-commentairesFin').value;
		var commentairesInt = document.getElementById('oer-commentairesInt').value;
		var readOnly = (oer_etatBon!="N" || gReadOnly);

		var url = "chrome://opensi/content/facturation/user/commun/popup-commentairesDocument.xul";
  	window.openDialog(url,'','chrome,modal,centerscreen', oer_retourEditerCommentaires, "RC", oer_retourId, commentairesFin, commentairesInt, readOnly);

	} catch (e) {
    recup_erreur(e);
  }
}


function oer_retourEditerCommentaires(commentairesFin, commentairesInt) {
  try {

		document.getElementById('oer-commentairesFin').value = commentairesFin;
		document.getElementById('oer-commentairesInt').value = commentairesInt;

	} catch (e) {
    recup_erreur(e);
  }
}


function oer_enregistrerBon(rafraichir) {
  try {

  	var ok = false;

		var denomination = document.getElementById('oer-denominationLiv').value;
		var adresse1 = document.getElementById('oer-adresse1Liv').value;
		var adresse2 = document.getElementById('oer-adresse2Liv').value;
		var adresse3 = document.getElementById('oer-adresse3Liv').value;
		var codePostal = document.getElementById('oer-codePostalLiv').value;
		var ville = document.getElementById('oer-villeLiv').value;
		var codePays = document.getElementById('oer-codePaysLiv').value;
		var civInter = document.getElementById('oer-civInterLiv').value;
		var nomInter = document.getElementById('oer-nomInterLiv').value;
		var prenomInter = document.getElementById('oer-prenomInterLiv').value;
		var telInter1 = document.getElementById('oer-telInter1Liv').value;
		var telInter2 = document.getElementById('oer-telInter2Liv').value;
		var faxInter = document.getElementById('oer-faxInterLiv').value;
		var emailInter = document.getElementById('oer-emailInterLiv').value;
		var commentairesFin = document.getElementById('oer-commentairesFin').value;
		var commentairesInt = document.getElementById('oer-commentairesInt').value;
		var depot = document.getElementById('oer-depot').value;
		var typeRetour = document.getElementById('oer-typeRetour').value;

		if (isEmpty(denomination)) { showWarning("Veuillez indiquer la d\u00E9nomination du client !"); }
		else if (isEmpty(adresse1)) { showWarning("Veuillez indiquer l'adresse du client !"); }
		else if (isEmpty(ville)) { showWarning("Veuillez indiquer la ville du client !"); }
		else if (!isEmpty(telInter1) && !isPhone(telInter1)) { showWarning("T\u00E9l\u00E9phone 1 incorrect !"); }
		else if (!isEmpty(telInter2) && !isPhone(telInter2)) { showWarning("T\u00E9l\u00E9phone 2 incorrect !"); }
		else if (gShowFax && !isEmpty(faxInter) && !isPhone(faxInter)) { showWarning("Num\u00E9ro de fax incorrect !"); }
		else if (!isEmpty(emailInter) && !isEmail(emailInter)) { showWarning("Adresse e-mail incorrecte !"); }
		else if (isEmpty(depot)) { showWarning("Veuillez choisir un d\u00E9p\u00F4t de r\u00E9ception."); }
		else if (isEmpty(typeRetour) || document.getElementById('oer-typeRetour').selectedIndex==-1) { showWarning("Veuillez choisir un type de retour"); }
		else {
			var qSave;

			if (oer_mode=="C") {
				qSave = new QueryHttp("Facturation/Affaires/createRetourClient.tmpl");
				qSave.setParam("Bon_Liv_Id", oer_bonLivId);
			}
			else {
				qSave = new QueryHttp("Facturation/Affaires/updateRetourClient.tmpl");
				qSave.setParam("Retour_Id", oer_retourId);
			}

			qSave.setParam("Denomination", denomination);
			qSave.setParam("Adresse_1", adresse1);
			qSave.setParam("Adresse_2", adresse2);
			qSave.setParam("Adresse_3", adresse3);
			qSave.setParam("Code_Postal", codePostal);
			qSave.setParam("Ville", ville);
			qSave.setParam("Code_Pays", codePays);
			qSave.setParam("Civ_Inter", civInter);
			qSave.setParam("Nom_Inter", nomInter);
			qSave.setParam("Prenom_Inter", prenomInter);
			qSave.setParam("Tel_Inter_1", telInter1);
			qSave.setParam("Tel_Inter_2", telInter2);
			qSave.setParam("Fax_Inter", faxInter);
			qSave.setParam("Email_Inter", emailInter);
			qSave.setParam("Commentaires_Fin", commentairesFin);
			qSave.setParam("Commentaires_Int", commentairesInt);
			qSave.setParam("Depot_Id", depot);
			qSave.setParam("Type_Retour", typeRetour);

			var result = qSave.execute();

			if (oer_mode=="C") {
				oer_retourId = result.responseXML.documentElement.getAttribute("Retour_Id");
				if (rafraichir) {
					oer_chargerBon();
				}
			}
			else if (result.responseXML.documentElement.getAttribute("Reset_RG")=="true") {
				oer_aBonRetour.initTree();
			}

			oer_setModified(false);
			ok = true;
		}

		return ok;

	} catch (e) {
  	recup_erreur(e);
  }
}


function oer_supprimerBon() {
  try {

		if (window.confirm("Confirmez-vous la suppression de ce retour ?")) {
			var qDelete = new QueryHttp("Facturation/Affaires/deleteRetourClient.tmpl");
			qDelete.setParam("Retour_Id", oer_retourId);
			qDelete.execute();

			showMessage("Le retour a \u00E9t\u00E9 supprim\u00E9 avec succ\u00E8s !");

			retourFicheAffaire();
		}

	} catch (e) {
  	recup_erreur(e);
  }
}


function oer_toutTransferer() {
  try {

  	var ok = true;
		if (oer_mode=="C") {
			ok = oer_enregistrerBon(true);
		}
		if (ok) {
			var qAdd = new QueryHttp('Facturation/Affaires/addAllRC.tmpl');
			qAdd.setParam("Retour_Id", oer_retourId);
			qAdd.setParam("Bon_Liv_Id", oer_bonLivId);
			qAdd.execute();

			oer_aBonLivraison.initTree();
			oer_aBonRetour.initTree();

			document.getElementById('oer-nbPieces').value = "";
			document.getElementById('oer-quantite').value = "";

			document.getElementById('oer-bAjouter').disabled = true;
			document.getElementById('oer-bEnlever').disabled = true;
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oer_toutEnlever() {
  try {

  	var qRemove = new QueryHttp('Facturation/Affaires/removeAllRC.tmpl');
		qRemove.setParam("Retour_Id", oer_retourId);
		qRemove.execute();

		oer_aBonLivraison.initTree();
		oer_aBonRetour.initTree();

		document.getElementById('oer-nbPieces').value = "";
		document.getElementById('oer-quantite').value = "";

		document.getElementById('oer-bAjouter').disabled = true;
		document.getElementById('oer-bEnlever').disabled = true;

		document.getElementById("oer-bConsultSerieLigne").disabled = true;

	} catch (e) {
  	recup_erreur(e);
	}
}


function oer_ajouter() {
  try {

		if (oer_aBonLivraison.isSelected()) {

			var ligneBL = oer_aBonLivraison.getSelectedCellText('oer-colLigneIdDev');
			var qteRestante = oer_aBonLivraison.getSelectedCellText('oer-colQuantiteDev');
			var isSuiviSerie = oer_aBonLivraison.getSelectedCellText('oer-colSuiviSerieDev')=="true";
			var nbPiecesRestant = oer_aBonLivraison.getSelectedCellText('oer-colNbPiecesDev');
			if (isEmpty(nbPiecesRestant)) { nbPiecesRestant = 0; }

			var quantite = document.getElementById('oer-quantite').value;
			var nbPieces = document.getElementById('oer-nbPieces').value;
			if (isEmpty(nbPieces)) { nbPieces = 0; }

			if (isEmpty(quantite)) { showWarning("Veuillez entrer une quantit\u00E9 \u00E0 transf\u00E9rer !"); }
			else if (!checkQte(quantite)) { showWarning("Quantit\u00E9 incorrecte !"); }
			else if (!isPositiveOrNullInteger(nbPieces)) { showWarning("Nombre de pi\u00E8ces incorrect !");	}
			else if (parseFloat(qteRestante)-parseFloat(quantite)<0) { showWarning("La quantit\u00E9 \u00E0 transf\u00E9rer ne doit pas d\u00E9passer la quantit\u00E9 restant \u00E0 retourner !"); }
			else if (parseFloat(nbPiecesRestant)-parseFloat(nbPieces)<0) { showWarning("Le nb de pi\u00E8ces \u00E0 transf\u00E9rer ne doit pas d\u00E9passer le nb de pi\u00E8ces restant \u00E0 retourner !"); }
			else {

				var ok = true;

				if (oer_mode=="C") {
					ok = oer_enregistrerBon(true);
				}

				if (ok) {
					var qAdd = new QueryHttp('Facturation/Affaires/addLigneRC.tmpl');
					qAdd.setParam("Retour_Id", oer_retourId);
					qAdd.setParam("Ligne_BL", ligneBL);
					qAdd.setParam("Quantite", quantite);
					qAdd.setParam("Nb_Pieces", nbPieces);
					var result = qAdd.execute();

					var ligneRC = result.responseXML.documentElement.getAttribute('Ligne_Id');
					var quantiteRC = parseIntBis(result.responseXML.documentElement.getAttribute('Quantite'));

					oer_aBonLivraison.initTree();
					oer_aBonRetour.initTree();

					document.getElementById('oer-nbPieces').value = "";
					document.getElementById('oer-quantite').value = "";

					document.getElementById('oer-bAjouter').disabled = true;

					oer_checkNumSerieLigne(ligneRC, isSuiviSerie, quantiteRC);
				}
			}
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oer_enlever() {
  try {

		if (oer_aBonRetour.isSelected()) {
			var i = oer_aBonRetour.getCurrentIndex();
			var oer_ligneId = oer_aBonRetour.getCellText(i, 'oer-colLigneIdLiv');
			var oer_qteInit = oer_aBonRetour.getCellText(i, 'oer-colQuantiteLiv');
			var oer_quantite = document.getElementById('oer-quantite').value;
			var oer_nbPiecesInit = oer_aBonRetour.getCellText(i, 'oer-colNbPiecesLiv');
			if (isEmpty(oer_nbPiecesInit)) { oer_nbPiecesInit = 0; }
			var oer_nbPieces = document.getElementById('oer-nbPieces').value;
			if (isEmpty(oer_nbPieces)) { oer_nbPieces = 0; }

			if (isEmpty(oer_quantite)) { showWarning("Veuillez entrer une quantit\u00E9 \u00E0 enlever"); }
			else if (!checkQte(oer_quantite)) { showWarning("Quantit\u00E9 incorrecte !"); }
			else if (parseFloat(oer_qteInit)-parseFloat(oer_quantite)<0) { showWarning("La quantit\u00E9 \u00E0 enlever ne peut d\u00E9passer la quantit\u00E9 pr\u00E9sente dans le retour !"); }
			else if (!isPositiveOrNullInteger(oer_nbPieces)) { showWarning("Nombre de pi\u00E8ces incorrect !");	}
			else if ((parseFloat(oer_nbPiecesInit)-parseFloat(oer_nbPieces)<0)) { showWarning("Le nb de pi\u00E8ces \u00E0 enlever ne peut d\u00E9passer le nb de pi\u00E8ces pr\u00E9sent dans le retour !"); }
			else {
				var oer_qEnleverArticles = new QueryHttp('Facturation/Affaires/removeLigneRC.tmpl');
				oer_qEnleverArticles.setParam("Ligne_Id", oer_ligneId);
				oer_qEnleverArticles.setParam("QteInit", oer_qteInit);
				oer_qEnleverArticles.setParam("Quantite", oer_quantite);
				oer_qEnleverArticles.setParam("Nb_Pieces", oer_nbPieces);
				oer_qEnleverArticles.execute();

				oer_aBonLivraison.initTree();
				oer_aBonRetour.initTree();

				document.getElementById('oer-nbPieces').value = "";
				document.getElementById('oer-quantite').value = "";

				document.getElementById('oer-bEnlever').disabled = true;
				document.getElementById("oer-bConsultSerieLigne").disabled = true;
			}
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oer_demandeEnregistrement() {
  try {

		if (oer_modified) {
			if (window.confirm("Voulez-vous enregistrer les modifications apport\u00E9es au retour ?")) {
				oer_enregistrerBon(false);
			}
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oer_setModified(m) {
  try {

  	oer_modified = m && !gReadOnly;

		if (oer_modified) {
			document.getElementById('oer-tabBon').setAttribute('image', 'chrome://opensi/content/design/icones/modified.png');
			document.getElementById('oer-bValiderBR').disabled = true;
			document.getElementById('oer-bVisualiser').disabled = (oer_etatBon!='E');
		}
		else {
			document.getElementById('oer-tabBon').setAttribute('image', gReadOnly?'chrome://opensi/content/design/icones/readonly.png':null);
			document.getElementById('oer-bValiderBR').disabled = (oer_etatBon=='E');
			document.getElementById('oer-bVisualiser').disabled = false;
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oer_visualiserBon() {
  try {

		if (oer_aBonRetour.nbLignes()<=0) {
			showWarning("Le retour ne contient aucune ligne !");
		}
		else {
			document.getElementById("bRetourBonRetour").collapsed = false;
			document.getElementById("oer-deckBonRetour").selectedIndex = 1;

			var qLangueDefaut = new QueryHttp("Facturation/Commun/getLangueDefaut.tmpl");
			qLangueDefaut.setParam("Type_Doc", "RC");
			qLangueDefaut.setParam("Doc_Id", oer_retourId);
			var result = qLangueDefaut.execute();
			oer_langueDefaut = result.responseXML.documentElement.getAttribute("Langue_Id");
			oer_aLangues.setParam("Selection", oer_langueDefaut);
			oer_aLangues.initTree(oer_initLangue);
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oer_initLangue() {
	try {

		document.getElementById('oer-langueDefaut').value = oer_langueDefaut;
		oer_editerBon();

	} catch (e) {
		recup_erreur(e);
	}
}


function oer_editerBon() {
	try {

		var langue = document.getElementById('oer-langueDefaut').value;

		var oer_qGenPdf = new QueryHttp("Facturation/Affaires/pdfRetourClient.tmpl");
		oer_qGenPdf.setParam('Bon_Id', oer_retourId);
	  oer_qGenPdf.setParam('Langue', langue);
		var result = oer_qGenPdf.execute();
		var page = getDirPdf() + result.responseXML.documentElement.getAttribute('fichier');

		document.getElementById('oer-pdfBonRetour').setAttribute("src", page);

	} catch (e) {
		recup_erreur(e);
	}
}


function oer_validerBon() {
  try {

		var typeRetour = document.getElementById('oer-typeRetour').value;

		if (oer_aBonRetour.nbLignes()<=0) {
			showWarning("Le retour ne contient aucune ligne !");
		}
		else if (isEmpty(typeRetour) || document.getElementById('oer-typeRetour').selectedIndex==-1) {
			showWarning("Veuillez choisir un type de retour");
		}
		else {
			var isChecked = true;
			if (oer_actSuiviSerie) {
				var qCheck = new QueryHttp("Facturation/Retours_Clients/checkNumSerieRC.tmpl");
				qCheck.setParam("Retour_Id", oer_retourId);
				var result = qCheck.execute();
				var errors = new Errors(result);
				if (errors.hasNext()) {
					isChecked = false;
					errors.show();
				}
			}

			if (isChecked && window.confirm("Confirmez-vous la validation du retour ?\n(Attention le retour valid\u00E9 ne pourra plus \u00EAtre modifi\u00E9 !)")) {
				var qValid = new QueryHttp("Facturation/Affaires/validRetourClient.tmpl");
				qValid.setParam('Retour_Id', oer_retourId);
				qValid.execute();

				oer_chargerBon();
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}

function oer_validerReception() {
  try {

		if (window.confirm("Confirmez-vous la validation de la r\u00E9ception ?")) {
			var qValiderReception = new QueryHttp("Facturation/Affaires/receiveRetourClient.tmpl");
			qValiderReception.setParam('Retour_Id', oer_retourId);
			qValiderReception.execute();

			oer_chargerBon();

			var typeRetour = document.getElementById('oer-typeRetour').value;

			if (typeRetour=="R") {
				var qCheck = new QueryHttp("Facturation/Affaires/checkAvoirRetourPossible.tmpl");
				qCheck.setParam('Retour_Id', oer_retourId);

				var result = qCheck.execute();

				var possible = result.responseXML.documentElement.getAttribute("Possible")=="true";

				if (possible && window.confirm("Voulez-vous cr\u00E9er un avoir pour ce retour ?")) {

					var qTrans = new QueryHttp("Facturation/Affaires/transformRetourAvoir.tmpl");
					qTrans.setParam('Retour_Id', oer_retourId);

					result = qTrans.execute();

					var errors = new Errors(result);
					if (errors.hasNext()) {
						errors.show();
					}
					else {
						oea_avoirId = result.responseXML.documentElement.getAttribute("Avoir_Id");
						oea_chargerAvoir();
						document.getElementById('deck').selectedIndex = 6;
					}
				}
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oer_annulerBon() {
  try {

		if (window.confirm("Confirmez-vous l'annulation du retour ?")) {
			var qCancel = new QueryHttp("Facturation/Affaires/cancelRetourClient.tmpl");
			qCancel.setParam('Retour_Id', oer_retourId);
			qCancel.execute();

			showMessage("Le retour a \u00E9t\u00E9 annul\u00E9 !");

			oer_chargerBon();
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oer_rechercherAdrLiv() {
  try {

  	oer_currentCodePaysLiv = document.getElementById('oer-codePaysLiv').value;

		var url = "chrome://opensi/content/facturation/user/commun/popup-choixAdresse.xul";
    window.openDialog(url,'','chrome,modal,centerscreen', oer_reporterAdrLiv, oer_clientId, gReadOnly);

	} catch (e) {
  	recup_erreur(e);
  }
}


function oer_reporterAdrLiv(nom, adr1, adr2, adr3, cp, ville, pays, code_pays, contact_fact, contact_liv, contact_envoi, contact_devis, adresseId) {
  try {

  	if (oer_currentCodePaysLiv!=code_pays && !oer_assujettiTVA) {
  		showWarning("L'adresse choisie doit \u00EAtre dans le m\u00EAme pays que le pays de livraison actuel !");
  	}
		else {
			document.getElementById('oer-denominationLiv').value = nom;
			document.getElementById('oer-adresse1Liv').value = adr1;
			document.getElementById('oer-adresse2Liv').value = adr2;
			document.getElementById('oer-adresse3Liv').value = adr3;
			document.getElementById('oer-codePostalLiv').value = cp;
			document.getElementById('oer-villeLiv').value = ville;
		  document.getElementById('oer-codePaysLiv').value = code_pays;

			if (!isEmpty(contact_liv)) {
				var qLoad = new QueryHttp("Facturation/Clients/loadContactClient.tmpl");
		  	qLoad.setParam("Contact_Id", contact_liv);
		  	var result = qLoad.execute();
		  	var contenu = result.responseXML.documentElement;
		  	oer_reporterInterLiv(contenu.getAttribute("Civilite"),contenu.getAttribute("Nom"),contenu.getAttribute("Prenom"),contenu.getAttribute("Tel_1"),contenu.getAttribute("Tel_2"),contenu.getAttribute("Fax"),contenu.getAttribute("Email"));
		  }
			else {
				oer_setModified(true);
		  }
  	}

	} catch (e) {
  	recup_erreur(e);
  }
}


function oer_rechercherInterlocuteurLiv() {
  try {

		var url = "chrome://opensi/content/facturation/user/commun/popup-choixInter.xul";
    window.openDialog(url,'','chrome,modal,centerscreen', oer_reporterInterLiv, oer_clientId, gReadOnly);

	} catch (e) {
  	recup_erreur(e);
  }
}


function oer_reporterInterLiv(civ, nom, prenom, tel1, tel2, fax, email) {
  try {

		document.getElementById('oer-civInterLiv').value = civ;
		document.getElementById('oer-nomInterLiv').value = nom;
		document.getElementById('oer-prenomInterLiv').value = prenom;
		document.getElementById('oer-telInter1Liv').value = tel1;
		document.getElementById('oer-telInter2Liv').value = tel2;
		document.getElementById('oer-faxInterLiv').value = fax;
		document.getElementById('oer-emailInterLiv').value = email;

		oer_setModified(true);

	} catch (e) {
  	recup_erreur(e);
  }
}

function oer_choisirMentions() {
  try {

  	var ok = true;

  	if (oer_mode=="C") {
			ok = oer_enregistrerBon(true);
		}

		if (ok) {
			var url = "chrome://opensi/content/facturation/user/commun/popup-mentionsDocument.xul";
	    window.openDialog(url,'','chrome,modal,centerscreen', "RC", oer_retourId, gReadOnly);
		}

	} catch (e) {
  	recup_erreur(e);
  }
}


function oer_initVersion() {
	try {

		oer_aVersion.setParam("Retour_Id", oer_retourId);
		oer_aVersion.initTree();

	} catch (e) {
		recup_erreur(e);
	}
}


function oer_selectionLigneRC() {
	try {

	 	if (oer_aBonRetour.isSelected()) {
			document.getElementById('oer-nbPieces').value = oer_aBonRetour.getSelectedCellText('oer-colNbPiecesLiv');
			document.getElementById('oer-quantite').value = oer_aBonRetour.getSelectedCellText('oer-colQuantiteLiv');

			document.getElementById('oer-bEnlever').disabled = false;
	 		document.getElementById('oer-bAjouter').disabled = true;
			oer_aBonLivraison.clearSelection();

			var articleId = oer_aBonRetour.getSelectedCellText('oer-colArticleIdLiv');
			document.getElementById("oer-bConsultSerieLigne").disabled = isEmpty(articleId);

			if (!isEmpty(articleId) && !isEmpty(oer_currentDepotId)) {
				var codeEmplacement = oer_aBonRetour.getSelectedCellText("oer-colCodeEmplacementLiv");
				document.getElementById("oer-codeEmplacementRG").value = (codeEmplacement=="*"?"":codeEmplacement);
				document.getElementById("oer-bValiderRG").disabled = false;
				document.getElementById("oer-codeEmplacementRG").disabled = false;
				document.getElementById("oer-bRechercherEmplacementRG").disabled = false;
			}
			else {
				oer_resetLigneEmplacementRG();
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oer_checkNumSerieLigne(ligneId, isSuiviSerie, quantite) {
	try {

		if (oer_actSuiviSerie) {
			var qNbSerie = new QueryHttp("Facturation/Retours_Clients/getNbNumSerieLigneRC.tmpl");
			qNbSerie.setParam("Ligne_Id", ligneId);
			var resNS = qNbSerie.execute();
			var nb = parseIntBis(resNS.responseXML.documentElement.getAttribute("Nombre"));
			if ((isSuiviSerie && nb!=quantite) || nb>quantite) {
				var url = "chrome://opensi/content/facturation/user/commun/popup-numSerie.xul";
		    window.openDialog(url,'','chrome,modal,centerscreen', "S", "RCA", ligneId);
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oer_consulterNumSerie() {
	try {

		if (oer_aBonRetour.isSelected()) {
			var ligneId = oer_aBonRetour.getSelectedCellText('oer-colLigneIdLiv');
			var mode = (oer_etatBon=="A" || oer_etatBon=="V" || gReadOnly?"C":"S");
			var forfait = oer_aBonRetour.getSelectedCellText('oer-colTypeArticleLiv')=="F";
			var url = "chrome://opensi/content/facturation/user/commun/"+ (forfait?"popup-numSerieComposant.xul":"popup-numSerie.xul");
    	window.openDialog(url,'','chrome,modal,centerscreen', mode, "RCA", ligneId);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oer_envoyer() {
	try {

		var langue = document.getElementById('oer-langueDefaut').value;

		var url = "chrome://opensi/content/popup/popup-envoyerMail.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', "RC", oer_retourId, langue);

	}	catch (e) {
    recup_erreur(e);
  }
}


function oer_importLignes() {
  try {

	  var url = "chrome://opensi/content/facturation/user/affaires/popup-importerLignesRC.xul";
	  window.openDialog(url,'','chrome,modal,centerscreen', oer_retourImportLignes, oer_retourId);

  } catch (e) {
    recup_erreur(e);
  }
}


function oer_retourImportLignes() {
	try {

		oer_aBonLivraison.initTree();
		oer_aBonRetour.initTree();
		document.getElementById('oer-bAjouter').disabled = true;
		document.getElementById('oer-bEnlever').disabled = true;

	} catch (e) {
	  recup_erreur(e);
	}
}


// RANGEMENT


function oer_resetLigneEmplacementRG() {
	try {

		document.getElementById("oer-codeEmplacementRG").value = "";
		document.getElementById("oer-bValiderRG").disabled = true;
		document.getElementById("oer-codeEmplacementRG").disabled = true;
		document.getElementById("oer-bRechercherEmplacementRG").disabled = true;

	} catch (e) {
		recup_erreur(e);
	}
}


function oer_validerEmplacementRG() {
	try {

		if (oer_aBonRetour.isSelected()) {
			var ligneId = oer_aBonRetour.getSelectedCellText("oer-colLigneIdLiv");
			var codeEmplacement = document.getElementById("oer-codeEmplacementRG").value;

			if (isEmpty(codeEmplacement)) {
				showWarning("Emplacement incorrect");
			}
			else {
				var emplacementId = oer_getEmplacementId(codeEmplacement);

				if (isEmpty(emplacementId)) {
					showWarning("Emplacement inexistant");
				}
				else {
					var qSet = new QueryHttp("Facturation/Affaires/setEmplacementIdLigneRC.tmpl");
					qSet.setParam("Ligne_Id", ligneId);
					qSet.setParam("Emplacement_Id", emplacementId);

					var result = qSet.execute();

					var errors = new Errors(result);
					if (errors.hasNext()) {
						errors.show();
					}

					oer_aBonRetour.initTree();
					oer_resetLigneEmplacementRG();
				}
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oer_getEmplacementId(codeEmplacement) {
	try {

		var qGet = new QueryHttp("Facturation/Emplacements/getEmplacementId.tmpl");
		qGet.setParam("Depot_Id", oer_currentDepotId);
		qGet.setParam("Code_Emplacement", codeEmplacement);

		var result = qGet.execute();

		return result.responseXML.documentElement.getAttribute('Emplacement_Id');

	} catch (e) {
		recup_erreur(e);
	}
}


function oer_rechercherEmplacementRG() {
	try {

		var url = "chrome://opensi/content/facturation/user/emplacements/popup-rechercheEmplacement.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', oer_retourRechercherEmplacementRG, oer_currentDepotId);

	} catch (e) {
		recup_erreur(e);
	}
}


function oer_retourRechercherEmplacementRG(codeEmplacement, emplacementId) {
	try {

  	document.getElementById('oer-codeEmplacementRG').value = codeEmplacement;

	} catch (e) {
		recup_erreur(e);
	}
}
