/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/


var ofa_aResponsables = new Arbre("ComboListe/combo-responsables.tmpl", "ofa-responsable");
var ofa_aListeReglements = new Arbre("Facturation/Affaires/list-reglementsAffaire.tmpl", "ofa-listeReglements");
var ofa_aListeCommandes = new Arbre("Facturation/Affaires/list-commandeClientAffaire.tmpl", "ofa-listeCommandes");
var ofa_aListeBL = new Arbre("Facturation/Affaires/list-bonLivraisonAffaire.tmpl", "ofa-listeBL");
var ofa_aListeFacturesAvoirs = new Arbre("Facturation/Affaires/list-factureClientAffaire.tmpl", "ofa-listeFacturesAvoirs");

var ofa_affaireId = "";
var ofa_defModeFacturation;
var ofa_defFactAvantLiv;
var ofa_defPeriodeFacturation;
var ofa_defModeEnvoiFacture;
var ofa_listCommandeAFacturer;
var ofa_listBonLivraisonAFacturer;
var ofa_etatAffaire;
var ofa_numAffaire = "";
var ofa_modified;
var ofa_chargerResponsable;
var ofa_chargement;
var ofa_clientId = "";
var ofa_gestionResp;



function ofa_init() {
	try {

		document.getElementById('ofa-rowFax').collapsed = !gShowFax;

		document.getElementById('ofa-lblReadOnly').collapsed = !gReadOnly;

		if (gReadOnly) {
			document.getElementById('ofa-gbCommandes').setAttribute('flex', 45);
			document.getElementById('ofa-gbExpeditions').setAttribute('flex', 30);
			document.getElementById('ofa-gbFactures').setAttribute('flex', 25);
		}

		ofa_chargement = true;
		document.getElementById('ofa-boxBoutonsAffaire').collapsed = true;
		document.getElementById('ofa-boxBoutonsCommande').collapsed = true;
		document.getElementById('ofa-boxBoutonsBL').collapsed = true;
		document.getElementById('ofa-boxBoutonsFacture').collapsed = true;

		ofa_defModeFacturation = gConfig.getDefModeFacturation();
		ofa_defFactAvantLiv = gConfig.getDefFactAvantLiv();
		ofa_defPeriodeFacturation = gConfig.getDefPeriodeFacturation();
		ofa_defModeEnvoiFacture = gConfig.getDefModeEnvoiFacture();
		document.getElementById('ofa-chkSansLivraison').collapsed = !gConfig.isSpecSL();

		ofa_chargerResponsables(gProfil.getLoggedUser());
		ofa_gestionResp = gProfil.isGestionRespVente();

		var qInit = new QueryHttp("Facturation/Affaires/getInitAffaire.tmpl");
		var result = qInit.execute();

		document.getElementById("ofa-bNouveauOL").collapsed = result.responseXML.documentElement.getAttribute('Has_Logisticien')=="false";
		document.getElementById("ofa-bNouveauLF").collapsed = result.responseXML.documentElement.getAttribute('Has_FournDirect')=="false";

		if (!gProfil.isAccMWM()) {
			document.getElementById('ofa-colLastLocalisationER').collapsed = true;
			document.getElementById('ofa-colLastLocalisationER').setAttribute("ignoreincolumnpicker", true);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function ofa_chargerResponsables(selection) {
	try {

		ofa_chargerResponsable = selection;
		ofa_aResponsables.setParam("Selection", ofa_chargerResponsable);
		ofa_aResponsables.initTree(ofa_initResponsable);

	} catch (e) {
		recup_erreur(e);
	}
}


function ofa_initResponsable() {
  try {

		document.getElementById('ofa-responsable').value = ofa_chargerResponsable;

		if (ofa_chargement) {
			document.getElementById('ofa-boxBoutonsAffaire').collapsed = gReadOnly;
			document.getElementById('ofa-boxBoutonsCommande').collapsed = gReadOnly;
			document.getElementById('ofa-boxBoutonsBL').collapsed = gReadOnly;
			document.getElementById('ofa-boxBoutonsFacture').collapsed = gReadOnly;
			ofa_chargement = false;
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function ofa_reinitialiser() {
	try {

		ofa_etatAffaire = "";
		ofa_numAffaire = "";
		ofa_setModified(false);
		ofa_chargerResponsable = "";
		ofa_clientId = "";

		document.getElementById('ofa-modeFacturation').value = ofa_defModeFacturation;
		document.getElementById('ofa-factAvantLiv').checked = ofa_defFactAvantLiv;
		document.getElementById('ofa-chkSansLivraison').checked = false;
		document.getElementById('ofa-periodeFacturation').value = ofa_defPeriodeFacturation;
		document.getElementById('ofa-dateDebutPeriode').value = "";
		document.getElementById('ofa-dateDebutPeriode').collapsed = true;
		document.getElementById('ofa-modeEnvoiFacture').value = ofa_defModeEnvoiFacture;
		document.getElementById('ofa-numClient').value = "";
		document.getElementById('ofa-denomination').value = "";
		document.getElementById('ofa-tel1').value = "";
		document.getElementById('ofa-tel2').value = "";
		document.getElementById('ofa-fax').value = "";
		document.getElementById('ofa-email').value = "";
		document.getElementById('ofa-numAffaire').value="Affaire";
		document.getElementById('ofa-etatAvancement').value = "";
		document.getElementById('ofa-intitule').value = "";
		document.getElementById('ofa-commentaires').value = "";
		document.getElementById('ofa-creation').setAttribute("label","");
		document.getElementById('ofa-modification').setAttribute("label","");
		document.getElementById('ofa-fiche').setAttribute("label","");
		ofa_aResponsables.deleteTree();

		document.getElementById('ofa-intitule').disabled = true;
		document.getElementById('ofa-responsable').disabled = true;
		document.getElementById('ofa-modeFacturation').disabled = true;
		document.getElementById('ofa-factAvantLiv').disabled = true;
		document.getElementById('ofa-chkSansLivraison').disabled = true;
		document.getElementById('ofa-periodeFacturation').disabled = true;
		document.getElementById('ofa-dateDebutPeriode').disabled = true;
		document.getElementById('ofa-modeEnvoiFacture').disabled = true;
		document.getElementById('ofa-denomination').disabled = true;
		document.getElementById('ofa-tel1').disabled = true;
		document.getElementById('ofa-tel2').disabled = true;
		document.getElementById('ofa-fax').disabled = true;
		document.getElementById('ofa-email').setAttribute('readonly', true);
		document.getElementById('ofa-commentaires').disabled = true;
		document.getElementById('ofa-bRechercher').disabled = true;
		document.getElementById('ofa-bAnnuler').disabled = true;
		document.getElementById('ofa-bEnregistrer').disabled = true;
		document.getElementById('ofa-bNouvelleCommande').disabled = true;
		document.getElementById('ofa-bNouveauBL').disabled = true;
		document.getElementById('ofa-bNouveauOL').disabled = true;
		document.getElementById('ofa-bNouveauLF').disabled = true;
		document.getElementById('ofa-bNouveauRC').disabled = true;
		document.getElementById('ofa-bNouvelleFacture').disabled = true;
		document.getElementById('ofa-bNouvelAvoir').disabled = true;

		document.getElementById('ofa-nbCommandesEnCours').value = "0";
		document.getElementById('ofa-caHTCommandesEnCours').value = "0.00 \u20AC";
		document.getElementById('ofa-paHTCommandes').value = "0.00 \u20AC";
		document.getElementById('ofa-margeHTAffaire').value = "0.00 \u20AC";
		document.getElementById('ofa-tauxMarqueAffaire').value = "0.00 %";
		document.getElementById('ofa-tauxMargeAffaire').value = "0.00 %";
		document.getElementById('ofa-nbArticlesALivrer').value = "0";
		document.getElementById('ofa-nbArticlesDejaLivres').value = "0";
		document.getElementById('ofa-nbArticlesRestantALivrer').value = "0";
		document.getElementById('ofa-avancementAffaire').value = "0 %";
		document.getElementById('ofa-lblMargeHT').setAttribute("style", "color:black");
		document.getElementById('ofa-margeHTAffaire').setAttribute("style", "color:black");
		document.getElementById('ofa-lblTauxMarque').setAttribute("style", "color:black");
		document.getElementById('ofa-tauxMarqueAffaire').setAttribute("style", "color:black");
		document.getElementById('ofa-lblTauxMarge').setAttribute("style", "color:black");
		document.getElementById('ofa-tauxMargeAffaire').setAttribute("style", "color:black");
		document.getElementById('ofa-pictoMargeNegative').collapsed = true;

		document.getElementById('ofa-boxEncaissements').collapsed = true;
		document.getElementById('ofa-caTTCFacture').value = "";
		document.getElementById('ofa-caTTCPaye').value = "";
		document.getElementById('ofa-pourcCATTCPaye').value = "";
		document.getElementById('ofa-soldeAEncaisser').value = "";
		document.getElementById('ofa-pourcSoldeAEncaisser').value = "";
		document.getElementById('ofa-boxEncoursClient').collapsed = true;

		ofa_aListeReglements.deleteTree();
		ofa_aListeCommandes.deleteTree();
		ofa_aListeBL.deleteTree();
		ofa_aListeFacturesAvoirs.deleteTree();
	} catch (e) {
		recup_erreur(e);
	}
}


function ofa_nouvelleAffaire() {
	try {

		ofa_affaireId = "";

		ofa_reinitialiser();
		ofa_chargerResponsables(gProfil.getLoggedUser());

		var modeFacturation = document.getElementById('ofa-modeFacturation').value;

		document.getElementById('ofa-intitule').disabled = false;
		document.getElementById('ofa-responsable').disabled = !ofa_gestionResp;
		document.getElementById('ofa-modeFacturation').disabled = false;
		document.getElementById('ofa-factAvantLiv').disabled = (modeFacturation=="B");
		document.getElementById('ofa-chkSansLivraison').disabled = false;
		document.getElementById('ofa-periodeFacturation').disabled = false;
		document.getElementById('ofa-dateDebutPeriode').disabled = false;
		document.getElementById('ofa-modeEnvoiFacture').disabled = false;
		document.getElementById('ofa-denomination').disabled = false;
		document.getElementById('ofa-tel1').disabled = false;
		document.getElementById('ofa-tel2').disabled = false;
		document.getElementById('ofa-fax').disabled = false;
		document.getElementById('ofa-email').removeAttribute('readonly');
		document.getElementById('ofa-commentaires').disabled = false;
		document.getElementById('ofa-bRechercher').disabled = false;
		document.getElementById('ofa-bEnregistrer').disabled = false;

	} catch (e) {
		recup_erreur(e);
	}
}


function ofa_chargerAffaire() {
	try {

		ofa_reinitialiser();

		var qLoad = new QueryHttp("Facturation/Affaires/getAffaire.tmpl");
		qLoad.setParam("Affaire_Id", ofa_affaireId);
		var result = qLoad.execute();
		var contenu = result.responseXML.documentElement;

		ofa_clientId = contenu.getAttribute("Client_Id")
		document.getElementById('ofa-numClient').value = contenu.getAttribute("Num_Client");
		document.getElementById('ofa-denomination').value = contenu.getAttribute("Denomination");
		document.getElementById('ofa-tel1').value = contenu.getAttribute("Tel_1");
		document.getElementById('ofa-tel2').value = contenu.getAttribute("Tel_2");
		document.getElementById('ofa-fax').value = contenu.getAttribute("Fax");
		document.getElementById('ofa-email').value = contenu.getAttribute("Email");

		ofa_etatAffaire = contenu.getAttribute("Etat");
		var desactiver = (ofa_etatAffaire=="A" || ofa_etatAffaire=="C");
		var libelleEtat = "";
		if (ofa_etatAffaire=="N") { libelleEtat = "Non valid\u00E9e"; }
		else if (ofa_etatAffaire=="T") { libelleEtat = "En cours"; }
		else if (ofa_etatAffaire=="A") { libelleEtat = "Annul\u00E9e"; }
		else if (ofa_etatAffaire=="C") { libelleEtat = "Cl\u00F4tur\u00E9e"; }
		var modeFacturation = contenu.getAttribute("Mode_Facturation");
		var periodeFact = contenu.getAttribute("Periode_Facturation");
		var factAvantLiv = contenu.getAttribute("Fact_Avant_Liv")=="true";
		var sansLivraison = (contenu.getAttribute("Sans_Livraison")=="true");
		ofa_numAffaire = contenu.getAttribute("Num_Affaire");
		document.getElementById('ofa-numAffaire').value = "Affaire N\u00B0 "+ ofa_numAffaire;
		document.getElementById('ofa-etatAvancement').value = libelleEtat;
		document.getElementById('ofa-intitule').value = contenu.getAttribute("Intitule");
		ofa_chargerResponsables(contenu.getAttribute("Util_R"));
		document.getElementById('ofa-modeFacturation').value = modeFacturation;
		document.getElementById('ofa-factAvantLiv').checked = factAvantLiv;
		document.getElementById('ofa-chkSansLivraison').checked = sansLivraison;
		document.getElementById('ofa-periodeFacturation').value = periodeFact;
		document.getElementById('ofa-dateDebutPeriode').value = contenu.getAttribute("Date_Facturation");
		document.getElementById('ofa-dateDebutPeriode').collapsed = (periodeFact!="D");
		document.getElementById('ofa-modeEnvoiFacture').value = contenu.getAttribute("Mode_Envoi_Facture");
		document.getElementById('ofa-commentaires').value = contenu.getAttribute("Commentaires");
		document.getElementById('ofa-creation').setAttribute("label","Affaire cr\u00E9\u00E9e le "+ contenu.getAttribute('Date_Creation') +" par "+ contenu.getAttribute('Login_Createur'));
		document.getElementById('ofa-modification').setAttribute("label","Derni\u00E8re modification le "+ contenu.getAttribute('Date_Maj') +" par "+ contenu.getAttribute('Login_Maj'));
		document.getElementById('ofa-fiche').setAttribute("label","Affaire N\u00B0"+ ofa_numAffaire);

		document.getElementById('ofa-nbCommandesEnCours').value = contenu.getAttribute("Nb_Commandes_En_Cours");
		document.getElementById('ofa-caHTCommandesEnCours').value = contenu.getAttribute("CAHT_Commandes_En_Cours") +" \u20AC";
		document.getElementById('ofa-paHTCommandes').value = contenu.getAttribute("PAHT_Commandes") +" \u20AC";
		document.getElementById('ofa-margeHTAffaire').value = contenu.getAttribute("Marge_HT") +" \u20AC";
		document.getElementById('ofa-tauxMarqueAffaire').value = contenu.getAttribute("Taux_Marque") +" %";
		document.getElementById('ofa-tauxMargeAffaire').value = contenu.getAttribute("Taux_Marge") +" %";
		document.getElementById('ofa-nbArticlesALivrer').value = contenu.getAttribute("Nb_Articles_A_Livrer");
		document.getElementById('ofa-nbArticlesDejaLivres').value = contenu.getAttribute("Nb_Articles_Deja_Livres");
		document.getElementById('ofa-nbArticlesRestantALivrer').value = contenu.getAttribute("Nb_Articles_Restant_A_Livrer");
		document.getElementById('ofa-avancementAffaire').value = contenu.getAttribute("Avancement_Affaire") + " %";

		if (contenu.getAttribute("Marge_Negative")=="true") {
			document.getElementById('ofa-lblMargeHT').setAttribute("style", "color:red");
			document.getElementById('ofa-margeHTAffaire').setAttribute("style", "color:red");
			document.getElementById('ofa-lblTauxMarque').setAttribute("style", "color:red");
			document.getElementById('ofa-tauxMarqueAffaire').setAttribute("style", "color:red");
			document.getElementById('ofa-lblTauxMarge').setAttribute("style", "color:red");
			document.getElementById('ofa-tauxMargeAffaire').setAttribute("style", "color:red");
			document.getElementById('ofa-pictoMargeNegative').collapsed = false;
		}

		document.getElementById('ofa-boxEncaissements').collapsed = false;
		document.getElementById('ofa-caTTCFacture').value = contenu.getAttribute("CA_TTC_Facture");
		document.getElementById('ofa-caTTCPaye').value = contenu.getAttribute("CA_TTC_Paye");
		document.getElementById('ofa-pourcCATTCPaye').value = contenu.getAttribute("Pourc_CA_TTC_Paye");
		document.getElementById('ofa-soldeAEncaisser').value = contenu.getAttribute("Solde_A_Encaisser");
		document.getElementById('ofa-pourcSoldeAEncaisser').value = contenu.getAttribute("Pourc_Solde_A_Encaisser");
		document.getElementById('ofa-boxEncoursClient').collapsed = isEmpty(ofa_clientId);
		document.getElementById('ofa-encoursAutorise').value = contenu.getAttribute("Encours_Autorise") +" \u20AC";
		document.getElementById('ofa-encoursActuel').value = contenu.getAttribute("Encours_Actuel") +" \u20AC";

		ofa_aListeReglements.setParam("Affaire_Id", ofa_affaireId);
		ofa_aListeReglements.initTree();

		ofa_aListeCommandes.setParam("Affaire_Id", ofa_affaireId);
		ofa_aListeCommandes.initTree(ofa_initListeCommandes);

		document.getElementById('ofa-intitule').disabled = desactiver;
		document.getElementById('ofa-responsable').disabled = desactiver || !ofa_gestionResp;
		document.getElementById('ofa-modeEnvoiFacture').disabled = desactiver;
		document.getElementById('ofa-commentaires').disabled = desactiver;
		document.getElementById('ofa-bAnnuler').disabled = desactiver;
		document.getElementById('ofa-bEnregistrer').disabled = desactiver;
		document.getElementById('ofa-bNouvelleCommande').disabled = desactiver;

	} catch (e) {
		recup_erreur(e);
	}
}


function ofa_initListeCommandes() {
	try {

		ofa_activerRechercherClient();

		ofa_aListeBL.setParam("Affaire_Id", ofa_affaireId);
		ofa_aListeBL.initTree(ofa_initListeBL);

	} catch (e) {
		recup_erreur(e);
	}
}


function ofa_initListeBL() {
	try {

		ofa_aListeFacturesAvoirs.setParam("Affaire_Id", ofa_affaireId);
		ofa_aListeFacturesAvoirs.initTree(ofa_activerModeFacturation);

	} catch (e) {
		recup_erreur(e);
	}
}


function ofa_activerRechercherClient() {
	try {

		var desactiver = (ofa_etatAffaire=="A" || ofa_etatAffaire=="C" || ofa_aListeCommandes.nbLignes()>0);
		document.getElementById('ofa-bRechercher').disabled = desactiver;
		if (isEmpty(ofa_clientId) && !desactiver) {
			document.getElementById('ofa-denomination').disabled = false;
			document.getElementById('ofa-tel1').disabled = false;
			document.getElementById('ofa-tel2').disabled = false;
			document.getElementById('ofa-fax').disabled = false;
			document.getElementById('ofa-email').removeAttribute('readonly');
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function ofa_activerModeFacturation() {
	try {

		var desactiver = (ofa_etatAffaire=="A" || ofa_etatAffaire=="C" || ofa_aListeFacturesAvoirs.nbLignes()>0);
		var modeFacturation = document.getElementById('ofa-modeFacturation').value;
		var sansLivraison = document.getElementById('ofa-chkSansLivraison').checked;
		var periodeFact = document.getElementById('ofa-periodeFacturation').value;
		document.getElementById('ofa-modeFacturation').disabled = desactiver;
		document.getElementById('ofa-periodeFacturation').disabled = desactiver;
		document.getElementById('ofa-dateDebutPeriode').disabled = (desactiver || periodeFact!="D");
		document.getElementById('ofa-factAvantLiv').disabled = (desactiver || sansLivraison || modeFacturation=="B");
		document.getElementById('ofa-chkSansLivraison').disabled = (desactiver || ofa_aListeBL.nbLignes()>0 || modeFacturation=="B");

		ofa_activerBoutons();

	} catch (e) {
		recup_erreur(e);
	}
}


function ofa_pressOnSansLivraison() {
	try {

		var sansLivraison = (document.getElementById('ofa-chkSansLivraison').checked);
		document.getElementById('ofa-factAvantLiv').disabled = sansLivraison;
		if (sansLivraison) { document.getElementById('ofa-factAvantLiv').checked = true; }

	} catch (e) {
		recup_erreur(e);
	}
}


function ofa_pressOnPeriodeFacturation() {
	try {

		var periodeFact = document.getElementById('ofa-periodeFacturation').value;
		document.getElementById('ofa-dateDebutPeriode').collapsed = (periodeFact!="D");
		document.getElementById('ofa-dateDebutPeriode').disabled = (periodeFact!="D");

	} catch (e) {
		recup_erreur(e);
	}
}


function ofa_activerBoutons() {
	try {

		// Boutons nouveau BL / OL / LF

		var sansLivraison = document.getElementById('ofa-chkSansLivraison').checked;

		if (isEmpty(ofa_affaireId) || ofa_etatAffaire=="A" || ofa_etatAffaire=="C" || sansLivraison) {
			document.getElementById('ofa-bNouveauBL').disabled = true;
			document.getElementById('ofa-bNouveauOL').disabled = true;
			document.getElementById('ofa-bNouveauLF').disabled = true;
		}
		else {
			var qCheck = new QueryHttp("Facturation/Affaires/checkAffaireExpediable.tmpl");
			qCheck.setParam('Affaire_Id', ofa_affaireId);
			var result = qCheck.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				var expediable = result.responseXML.documentElement.getAttribute('Checked')=="true";
				document.getElementById('ofa-bNouveauBL').disabled = !expediable;
				document.getElementById('ofa-bNouveauOL').disabled = !expediable;
				document.getElementById('ofa-bNouveauLF').disabled = !expediable;
			}
		}

		// Bouton nouvelle facture

		var modeFacturation = document.getElementById('ofa-modeFacturation').value;

		if (isEmpty(ofa_affaireId) || ofa_etatAffaire=="A" || ofa_etatAffaire=="C" || modeFacturation=="A") {
			document.getElementById('ofa-bNouvelleFacture').disabled = true;
		}
		else {
			var qCheck = new QueryHttp("Facturation/Affaires/checkAffaireFacturable.tmpl");
			qCheck.setParam("Affaire_Id", ofa_affaireId);
			var result = qCheck.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				var facturable = result.responseXML.documentElement.getAttribute("Checked")=="true";
				document.getElementById('ofa-bNouvelleFacture').disabled = !facturable;
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function ofa_rechercherClient() {
	try {

		var url = "chrome://opensi/content/facturation/user/clients/popup-rechercheClient.xul";
    window.openDialog(url,'','chrome,modal,centerscreen', ofa_retourRechercherClient, true, true);

	} catch (e) {
		recup_erreur(e);
	}
}


function ofa_retourRechercherClient(numClient, clientId) {
	try {

		ofa_clientId = clientId;
		ofa_chargerCoord();

	} catch (e) {
		recup_erreur(e);
	}
}


function ofa_chargerCoord() {
  try {

		var qGet = new QueryHttp("Facturation/Clients/loadFicheClient.tmpl");
		qGet.setParam("Client_Id", ofa_clientId);
		var result = qGet.execute();
		var contenu = result.responseXML.documentElement;

		document.getElementById('ofa-numClient').value = contenu.getAttribute("Num_Client");
		document.getElementById('ofa-denomination').value = contenu.getAttribute("Denomination");
		document.getElementById('ofa-tel1').value = contenu.getAttribute("Tel_1");
		document.getElementById('ofa-tel2').value = contenu.getAttribute("Tel_2");
		document.getElementById('ofa-fax').value = contenu.getAttribute("Fax_1");
		document.getElementById('ofa-email').value = contenu.getAttribute("Email_1");
		ofa_chargerResponsables(contenu.getAttribute("Util_R"));

		document.getElementById('ofa-denomination').disabled = true;
		document.getElementById('ofa-tel1').disabled = true;
		document.getElementById('ofa-tel2').disabled = true;
		document.getElementById('ofa-fax').disabled = true;
		document.getElementById('ofa-email').setAttribute('readonly', true);

		var modeFacturation = contenu.getAttribute('Mode_Facturation');
		var factAvantLiv = contenu.getAttribute('Fact_Avant_Liv')=="true";

		document.getElementById('ofa-modeFacturation').value = modeFacturation;
		document.getElementById('ofa-factAvantLiv').checked = factAvantLiv;
		document.getElementById('ofa-chkSansLivraison').checked = false;
		document.getElementById('ofa-periodeFacturation').value = contenu.getAttribute('Periode_Facturation');
		document.getElementById('ofa-dateDebutPeriode').value = "";
		document.getElementById('ofa-dateDebutPeriode').collapsed = true;
		document.getElementById('ofa-modeEnvoiFacture').value = contenu.getAttribute('Mode_Envoi_Facture');

		document.getElementById('ofa-chkSansLivraison').disabled = (modeFacturation=="B");
		document.getElementById('ofa-factAvantLiv').disabled = (modeFacturation=="B");

		ofa_setModified(true);

	} catch (e) {
  	recup_erreur(e);
  }
}


function ofa_pressOnFichiers() {
	try {

		if (!isEmpty(ofa_affaireId)) {
	    var url = "chrome://opensi/content/facturation/user/commun/popup-fichiersAssocies.xul";
  	  window.openDialog(url,'','chrome,modal,centerscreen', "AFF", ofa_affaireId, gReadOnly);
    }
    else {
      showWarning("Vous devez enregistrer votre affaire !");
    }

	} catch (e) {
		recup_erreur(e);
	}
}


function ofa_pressOnEncours() {
	try {

    var url = "chrome://opensi/content/facturation/user/affaires/popup-detailEncoursClient.xul";
 	  window.openDialog(url,'','chrome,modal,centerscreen', ofa_clientId);

	} catch (e) {
		recup_erreur(e);
	}
}


function ofa_pressOnAnnuler() {
	try {

		if (window.confirm("Voulez-vous annuler l'affaire courante ?")) {
			var qCancel = new QueryHttp("Facturation/Affaires/annulerAffaire.tmpl");
			qCancel.setParam("Affaire_Id", ofa_affaireId);
			var result = qCancel.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				showWarning("L'affaire est annul\u00E9e");
				ofa_chargerAffaire();
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function ofa_enregistrerAffaire() {
	try {

		var ok = false;

		var denomination = document.getElementById('ofa-denomination').value;
		var tel1 = document.getElementById('ofa-tel1').value;
		var tel2 = document.getElementById('ofa-tel2').value;
		var fax = document.getElementById('ofa-fax').value;
		var email = document.getElementById('ofa-email').value;
		var modeFacturation = document.getElementById('ofa-modeFacturation').value;
		var factAvantLiv = document.getElementById('ofa-factAvantLiv').checked;
		var sansLivraison = document.getElementById('ofa-chkSansLivraison').checked;
		var periodeFacturation = document.getElementById('ofa-periodeFacturation').value;
		var dateDebutPeriode = document.getElementById('ofa-dateDebutPeriode').value;

		if (isEmpty(denomination)) { showWarning("Veuillez saisir la d\u00E9nomination du client !"); }
		else if (!isEmpty(tel1) && !isPhone(tel1) && !document.getElementById('ofa-tel1').disabled) { showWarning("T\u00E9l\u00E9phone 1 incorrect"); }
		else if (!isEmpty(tel2) && !isPhone(tel2) && !document.getElementById('ofa-tel2').disabled) { showWarning("T\u00E9l\u00E9phone 2 incorrect"); }
		else if (gShowFax && !isEmpty(fax) && !isPhone(fax) && !document.getElementById('ofa-fax').disabled) { showWarning("Fax incorrect"); }
		else if (!isEmpty(email) && !isEmail(email) && document.getElementById('ofa-email').getAttribute("readonly")!="true") { showWarning("L'adresse e-mail du client est incorrecte !"); }
		else if (modeFacturation=="B" && factAvantLiv) { showWarning("Le type de facturation par BL et le mode de facturation par commande sont incompatibles !"); }
		else if (sansLivraison && !factAvantLiv) { showWarning("Le mode de facturation ne peut \u00EAtre que par commande !"); }
		else if (periodeFacturation=="D" && !isDate(dateDebutPeriode)) { showWarning("La date de d\u00E9but de p\u00E9riode est incorrecte !"); }
		else {

			var qSave;

			if (isEmpty(ofa_affaireId)) {
				qSave = new QueryHttp("Facturation/Affaires/creerAffaire.tmpl");
			}
			else {
				qSave = new QueryHttp("Facturation/Affaires/modifierAffaire.tmpl");
				qSave.setParam("Affaire_Id", ofa_affaireId);
			}

			qSave.setParam("Client_Id", ofa_clientId);
			qSave.setParam("Denomination", denomination);
			qSave.setParam("Tel_1", tel1);
			qSave.setParam("Tel_2", tel2);
			qSave.setParam("Fax", fax);
			qSave.setParam("Email", email);
			qSave.setParam("Intitule", document.getElementById('ofa-intitule').value);
			qSave.setParam("Util_R", document.getElementById('ofa-responsable').value);
			qSave.setParam("Mode_Facturation", modeFacturation);
			qSave.setParam("Fact_Avant_Liv", factAvantLiv);
			qSave.setParam("Sans_Livraison", sansLivraison);
			qSave.setParam("Periode_Facturation", periodeFacturation);
			qSave.setParam("Date_Facturation", dateDebutPeriode);
			qSave.setParam("Mode_Envoi_Facture", document.getElementById('ofa-modeEnvoiFacture').value);
			qSave.setParam("Commentaires", document.getElementById('ofa-commentaires').value);
			var result = qSave.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				if (isEmpty(ofa_affaireId)) {
					ofa_affaireId = result.responseXML.documentElement.getAttribute("Affaire_Id");
				}

				ofa_setModified(false);
				ok = true;
			}
		}

		return ok;

	} catch (e) {
		recup_erreur(e);
	}
}


function ofa_pressOnEnregistrer() {
	try {

		var ok = ofa_enregistrerAffaire();
		if (ok) {
			ofa_chargerAffaire();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function ofa_pressOnListeCommandes() {
	try {

		if (ofa_aListeCommandes.isSelected()) {
			ofa_demandeEnregistrement();
			oec_commandeId = ofa_aListeCommandes.getSelectedCellText("ofa-colCommandeIdCC");
			oec_chargerCommande();
			document.getElementById('bRetourAffaire').collapsed = false;
			document.getElementById('deck').selectedIndex = 2;
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function ofa_pressOnNouvelleCommande() {
	try {

		ofa_demandeEnregistrement();
		oec_nouvelleCommande();
		document.getElementById('bRetourAffaire').collapsed = false;
		document.getElementById('deck').selectedIndex = 2;

	} catch (e) {
		recup_erreur(e);
	}
}


function ofa_selectOnListeBL() {
	try {

		if (ofa_aListeBL.isSelected()) {
			var i = ofa_aListeBL.getCurrentIndex();
			var typeDoc = ofa_aListeBL.getCellText(i, "ofa-colTypeDocER");
			var etat = ofa_aListeBL.getCellText(i, "ofa-colEtatER");
			var statutExpedition = ofa_aListeBL.getCellText(i, "ofa-colStatutExpeditionER");
			var retourPossible = ofa_aListeBL.getCellText(i, "ofa-colRetourPossibleER")=="true";
			var etatCommande = ofa_aListeBL.getCellText(i, "ofa-colEtatCommandeER");
			document.getElementById('ofa-bNouveauRC').disabled = (ofa_etatAffaire!="T" || typeDoc!="BL" || etat!="V" || statutExpedition=="P" || !retourPossible || etatCommande!="T");
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function ofa_pressOnListeBL() {
	try {

		if (ofa_aListeBL.isSelected()) {
			var i = ofa_aListeBL.getCurrentIndex();
			ofa_demandeEnregistrement();

			if (ofa_aListeBL.getCellText(i, "ofa-colTypeDocER")=="BL") {
				oeb_bonLivId = ofa_aListeBL.getCellText(i, "ofa-colDocIdER");
				oeb_typeExpedition = ofa_aListeBL.getCellText(i, "ofa-colTypeExpeditionER");
				oeb_fournisseurId = ofa_aListeBL.getCellText(i, "ofa-colFournisseurIdER");
				oeb_chargerBon();
				document.getElementById('bRetourAffaire').collapsed = false;
				document.getElementById('deck').selectedIndex = 3;
			}
			else {
				oer_retourId = ofa_aListeBL.getCellText(i, "ofa-colDocIdER");
				oer_chargerBon();
				document.getElementById('deck').selectedIndex = 7;
				document.getElementById('bRetourAffaire').collapsed = false;
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function ofa_pressOnNouvelleExpedition(typeExpedition) {
	try {

		document.activeElement.blur(); // ncessaire sinon cration possible de pleins d'expditions par la touche entre

		oeb_typeExpedition = typeExpedition;
		oeb_fournisseurId = "";

		var qGet = new QueryHttp("Facturation/Affaires/getExpediableAffaire.tmpl");
		qGet.setParam('Affaire_Id', ofa_affaireId);
		var result = qGet.execute();

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}
		else {
			var contenu = result.responseXML.documentElement;

			var listCommandeExpediable = contenu.getAttribute('List_Commande_Id');
			var conflit = contenu.getAttribute('Conflit')=="true";

			if (conflit) {				
				var url = "chrome://opensi/content/facturation/user/affaires/popup-choixCommandeAExpedier.xul";
  			window.openDialog(url,'','chrome,modal,centerscreen', ofa_retourChoixCommandeAExpedier, listCommandeExpediable);
  		}
  		else {
				ofa_demandeEnregistrement();
				oeb_commandeId = listCommandeExpediable;
				oeb_nouveauBon();
				document.getElementById('deck').selectedIndex = 3;
				document.getElementById('bRetourAffaire').collapsed = false;
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function ofa_retourChoixCommandeAExpedier(commandeId) {
	try {

		ofa_demandeEnregistrement();
		oeb_commandeId = commandeId;
		oeb_nouveauBon();
		document.getElementById('deck').selectedIndex = 3;
		document.getElementById('bRetourAffaire').collapsed = false;

	} catch (e) {
		recup_erreur(e);
	}
}


function ofa_pressOnNouveauRC() {
	try {

		if (ofa_aListeBL.isSelected() && ofa_aListeBL.getSelectedCellText("ofa-colTypeDocER")=="BL") {
			ofa_demandeEnregistrement();
			oer_bonLivId = ofa_aListeBL.getSelectedCellText("ofa-colDocIdER");
			oer_nouveauBon();
			document.getElementById('deck').selectedIndex = 7;
			document.getElementById('bRetourAffaire').collapsed = false;
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function ofa_pressOnListeFacturesAvoirs() {
	try {

		if (ofa_aListeFacturesAvoirs.isSelected()) {
			ofa_demandeEnregistrement();
			var typeDoc = ofa_aListeFacturesAvoirs.getSelectedCellText("ofa-colTypeDocFA");
			var docId = ofa_aListeFacturesAvoirs.getSelectedCellText("ofa-colDocIdFA");
			document.getElementById('bRetourAffaire').collapsed = false;

			if (typeDoc=="FC") {
				oef_factureId = docId;
				oef_chargerFacture();
				document.getElementById('deck').selectedIndex = 5;
			}
			else {
				oea_avoirId = docId;
				oea_chargerAvoir();
				document.getElementById('deck').selectedIndex = 6;
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function ofa_selectOnListeFacturesAvoirs() {
	try {

		if (ofa_aListeFacturesAvoirs.isSelected()) {
			var typeDoc = ofa_aListeFacturesAvoirs.getSelectedCellText("ofa-colTypeDocFA");
			var valide = ofa_aListeFacturesAvoirs.getSelectedCellText("ofa-colValideFA")=="true";
			document.getElementById('ofa-bNouvelAvoir').disabled = (ofa_etatAffaire=="A" || typeDoc!="FC" || !valide);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function ofa_pressOnNouvelleFacture() {
	try {

		document.activeElement.blur(); // ncessaire sinon cration possible de pleins de factures par la touche entre

		var modeFacturation = document.getElementById('ofa-modeFacturation').value;
		var factAvantLiv = document.getElementById('ofa-factAvantLiv').checked;

		ofa_listCommandeAFacturer = "";
		ofa_listBonLivraisonAFacturer = "";

		var qGet = new QueryHttp("Facturation/Affaires/getFacturableAffaire.tmpl");
		qGet.setParam('Affaire_Id', ofa_affaireId);
		var result = qGet.execute();

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}
		else {
			var contenu = result.responseXML.documentElement;

			var listCommandeFacturable = contenu.getAttribute('List_Commande_Id');
			var listBonLivraisonFacturable = contenu.getAttribute('List_Bon_Liv_Id');
			var conflit = contenu.getAttribute('Conflit')=="true";

			if (!isEmpty(listCommandeFacturable)) {
				// au moins une commande  facturer

				if (!conflit) {
					ofa_listCommandeAFacturer = listCommandeFacturable;
					ofa_listBonLivraisonAFacturer = listBonLivraisonFacturable;
				}
				else {
					if (factAvantLiv) {
						if (modeFacturation=="C") {
							var url = "chrome://opensi/content/facturation/user/affaires/popup-choixCommandeAFacturer.xul";
	  					window.openDialog(url,'','chrome,modal,centerscreen', ofa_retourChoixCommandeAFacturer, listCommandeFacturable);
						}
						else if (modeFacturation=="G") {
							var url = "chrome://opensi/content/facturation/user/affaires/popup-choixGroupeCommandeAFacturer.xul";
 							window.openDialog(url,'','chrome,modal,centerscreen', ofa_retourChoixGroupeCommandeAFacturer, listCommandeFacturable);
						}
					}
					else {
						if (modeFacturation=="B") {
							var url = "chrome://opensi/content/facturation/user/affaires/popup-choixBonLivraisonAFacturer.xul";
  						window.openDialog(url,'','chrome,modal,centerscreen', ofa_retourChoixBonLivraisonAFacturer, listBonLivraisonFacturable);
						}
						else if (modeFacturation=="C") {
							var url = "chrome://opensi/content/facturation/user/affaires/popup-choixCommandePaysAFacturer.xul";
 							window.openDialog(url,'','chrome,modal,centerscreen', ofa_retourChoixCommandePaysAFacturer, listCommandeFacturable, listBonLivraisonFacturable);
						}
						else if (modeFacturation=="G") {
							var url = "chrome://opensi/content/facturation/user/affaires/popup-choixGroupeCommandePaysAFacturer.xul";
 							window.openDialog(url,'','chrome,modal,centerscreen', ofa_retourChoixGroupeCommandePaysAFacturer, listCommandeFacturable, listBonLivraisonFacturable);
						}
					}
				}
			}
		}

		if (!isEmpty(ofa_listCommandeAFacturer) || !isEmpty(ofa_listBonLivraisonAFacturer)) {
			var qCreate = new QueryHttp("Facturation/Affaires/createFactureClient.tmpl");
			qCreate.setParam("Affaire_Id", ofa_affaireId);
			qCreate.setParam("List_Commande_Id", ofa_listCommandeAFacturer);
			qCreate.setParam("List_Bon_Liv_Id", ofa_listBonLivraisonAFacturer);

		  var result = qCreate.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				oef_factureId = result.responseXML.documentElement.getAttribute("Facture_Id");
				oef_chargerFacture();

				document.getElementById('bMenuAffaires').collapsed = false;
				document.getElementById('bRetourAffaire').collapsed = false;
				document.getElementById('deck').selectedIndex = 5;
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function ofa_retourChoixCommandeAFacturer(commandeId) {
	try {

		ofa_listCommandeAFacturer = commandeId;

	} catch (e) {
		recup_erreur(e);
	}
}


function ofa_retourChoixGroupeCommandeAFacturer(listCommandeId) {
	try {

		ofa_listCommandeAFacturer = listCommandeId;

	} catch (e) {
		recup_erreur(e);
	}
}


function ofa_retourChoixBonLivraisonAFacturer(bonLivId) {
	try {

		ofa_listBonLivraisonAFacturer = bonLivId;

	} catch (e) {
		recup_erreur(e);
	}
}


function ofa_retourChoixCommandePaysAFacturer(commandeId, listBonLivId) {
	try {

		ofa_listCommandeAFacturer = commandeId;
		ofa_listBonLivraisonAFacturer = listBonLivId;

	} catch (e) {
		recup_erreur(e);
	}
}


function ofa_retourChoixGroupeCommandePaysAFacturer(listCommandeId, listBonLivId) {
	try {

		ofa_listCommandeAFacturer = listCommandeId;
		ofa_listBonLivraisonAFacturer = listBonLivId;

	} catch (e) {
		recup_erreur(e);
	}
}


function ofa_pressOnNouvelAvoir() {
	try {

		if (window.confirm("Voulez-vous cr\u00E9er un avoir \u00E0 partir de cette facture ?")) {
			ofa_demandeEnregistrement();

			var qCheck = new QueryHttp("Facturation/Affaires/checkAvoirAffairePossible.tmpl");
			qCheck.setParam("Affaire_Id", ofa_affaireId);
			var result = qCheck.execute();
			if (result.responseXML.documentElement.getAttribute("Possible")=="true") {
				var currentIndex = ofa_aListeFacturesAvoirs.getCurrentIndex();
				var factId = ofa_aListeFacturesAvoirs.getCellText(currentIndex, 'ofa-colDocIdFA');

				var qTrans = new QueryHttp("Facturation/FacturesVente/transFactureAvoir.tmpl");
				qTrans.setParam("Facture_Id", factId);
				var result = qTrans.execute();

				oea_avoirId = result.responseXML.documentElement.getAttribute("Avoir_Id");
				oea_chargerAvoir();
				document.getElementById('deck').selectedIndex = 6;
				document.getElementById('bRetourAffaire').collapsed = false;
			}
			else {
				showWarning("Impossible de cr\u00E9er un avoir tant que les avoirs pr\u00E9c\u00E9dents ne sont pas valid\u00E9s !");
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function ofa_demandeEnregistrement() {
  try {

		if (ofa_modified) {
			if (window.confirm("Voulez-vous enregistrer les modifications apport\u00E9es \u00E0 l'affaire ?")) {
				ofa_enregistrerAffaire();
			}
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function ofa_setModified(m) {
  try {

  	ofa_modified = m && !gReadOnly;

  	if (ofa_modified) {
  		document.getElementById('ofa-lblAffaire').setAttribute('image', 'chrome://opensi/content/design/icones/modified.png');
  		document.getElementById('ofa-bNouveauBL').disabled = true;
			document.getElementById('ofa-bNouveauOL').disabled = true;
			document.getElementById('ofa-bNouveauLF').disabled = true;
  		document.getElementById('ofa-bNouvelleFacture').disabled = true;
  	}
  	else {
			document.getElementById('ofa-lblAffaire').setAttribute('image', null);
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function ofa_pressOnModeFacturation() {
	try {

		var modeFacturation = document.getElementById('ofa-modeFacturation').value;
		if (modeFacturation=="B") {
			document.getElementById('ofa-factAvantLiv').checked = false;
			document.getElementById('ofa-chkSansLivraison').checked = false;
		}
		document.getElementById('ofa-factAvantLiv').disabled = (modeFacturation=="B");
		document.getElementById('ofa-chkSansLivraison').disabled = (modeFacturation=="B");

	} catch (e) {
		recup_erreur(e);
	}
}
