/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/


jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/verif.js");

var ligneId;



function init() {
  try {

		ligneId = window.arguments[0];
		document.getElementById('prixAchat').value = window.arguments[1];

  } catch (e) {
    recup_erreur(e);
  }
}



function modifierPrixAchat() {
  try {

		var prixAchat = document.getElementById('prixAchat').value;

		if (isEmpty(prixAchat) || !isPositiveOrNull(prixAchat) || !checkDecimal(prixAchat,4)) {
			showWarning("Prix d'achat incorrect");
		}
		else {

			var qMaj = new QueryHttp("Facturation/Affaires/modifierPrixAchatBL.tmpl");
			qMaj.setParam("Ligne_Id", ligneId);
			qMaj.setParam("Prix_Achat", prixAchat);
			var result = qMaj.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}

			window.arguments[2]();
			window.close();
		}

	} catch (e) {
    recup_erreur(e);
  }
}
