/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/


var oom_aMouvements = new Arbre('Facturation/Mouvements_Stocks/list-mvtStock.tmpl', 'oom-listeMouvements');
var oom_qListMS = new QueryHttp("Facturation/Mouvements_Stocks/getDataListMS.tmpl");
var oom_aZones = new Arbre("ComboListe/combo-zonesStockage.tmpl", "oom-zoneStockage");

var oom_pageCourante;
var oom_nbPages;



function oom_initOngletMouvements() {
  try {

		var oom_aDepots = new Arbre("ComboListe/combo-depotsStock.tmpl", "oom-depot");
  	oom_aDepots.initTree(oom_chargerZones);

		oom_aMouvements.deleteTree();

		if (!gAccesCoutAchat) {
			document.getElementById('oom-colValorisation').setAttribute("ignoreincolumnpicker", true);
			document.getElementById('oom-colValorisationHF').setAttribute("ignoreincolumnpicker", true);
			document.getElementById('oom-colCumpPeriode').setAttribute("ignoreincolumnpicker", true);
		}

		if (!gActEmplacements) {
			document.getElementById('oom-bRechEmplacement').collapsed = true;
			document.getElementById('oom-lblFiltreZone').collapsed = true;
			document.getElementById('oom-zoneStockage').collapsed = true;
			document.getElementById('oom-itemTE').collapsed = true;
		}

  } catch (e) {
  	recup_erreur(e);
  }
}


function oom_chargerZones() {
	try {

		oom_aZones.setParam("Depot_Id", document.getElementById('oom-depot').value);
		oom_aZones.initTree(oom_initZoneStockage);

	} catch (e) {
		recup_erreur(e);
  }
}


function oom_initZoneStockage() {
	try {

		document.getElementById('oom-zoneStockage').value = "";

	} catch (e) {
		recup_erreur(e);
  }
}


function oom_initCriteres() {
	try {

		document.getElementById('oom-depot').value = "";
		document.getElementById('oom-zoneStockage').value = "";
		document.getElementById('oom-codeEmplacement').value = "";
		document.getElementById('oom-typeMvt').value = "";
		document.getElementById('oom-numPiece').value = "";
		document.getElementById('oom-libelle').value = "";
		document.getElementById('oom-sens').value = "";
		document.getElementById('oom-dateDebut').value = "";
		document.getElementById('oom-dateFin').value = "";

		oom_listerMouvements();

	} catch (e) {
		recup_erreur(e);
	}
}


function oom_listerMouvements() {
	try {

		var depotId = document.getElementById('oom-depot').value;
		var zoneStockage = document.getElementById('oom-zoneStockage').value;
		var codeEmplacement = document.getElementById('oom-codeEmplacement').value;
		var typeMvt = document.getElementById('oom-typeMvt').value;
		var numPiece = document.getElementById('oom-numPiece').value;
		var libelle = document.getElementById('oom-libelle').value;
		var sens = document.getElementById('oom-sens').value;
		var dateDebut = document.getElementById('oom-dateDebut').value;
		var dateFin = document.getElementById('oom-dateFin').value;
		var nbLignesParPage = document.getElementById('oom-nbLignesParPage').value;

		if (!isEmpty(dateDebut) && !isDate(dateDebut)) { showWarning("Date de d\u00E9but incorrecte !"); }
		else if (!isEmpty(dateFin) && !isDate(dateFin)) { showWarning("Date de fin incorrecte !"); }
		else if (!isEmpty(dateDebut) && !isEmpty(dateFin) && !isDateInterval(dateDebut, dateFin)) { showWarning("Plage de dates incorrecte !"); }
		else {

			oom_pageCourante = 1;
			oom_nbPages = 1;
			document.getElementById('oom-pageDeb').value = 1;
			document.getElementById('oom-pageFin').value = 1;
			document.getElementById('oom-bPrec').disabled = true;
			document.getElementById('oom-bSuiv').disabled = true;

			document.getElementById('oom-listeMouvements').disabled = true;
			document.getElementById('oom-bEditionCsv').disabled = true;
			oom_aMouvements.deleteTree();

			oom_qListMS.setParam("Depot_Id", depotId);
			oom_qListMS.setParam("Zone_Stockage", zoneStockage);
			oom_qListMS.setParam("Code_Emplacement", codeEmplacement);
			oom_qListMS.setParam("Type_Mvt", typeMvt);
			oom_qListMS.setParam("Num_Piece", numPiece);
			oom_qListMS.setParam("Libelle", libelle);
			oom_qListMS.setParam("Article_Id", ofa_articleId);
			oom_qListMS.setParam("Sens", sens);
			oom_qListMS.setParam("Date_Mvt_Debut", dateDebut);
			oom_qListMS.setParam("Date_Mvt_Fin", dateFin);
			oom_qListMS.setParam("Nb_Lignes_Par_Page", nbLignesParPage);
			oom_qListMS.setParam("Current_Page", oom_pageCourante);

			var result = oom_qListMS.execute();

			var contenu = result.responseXML.documentElement;

			oom_nbPages = contenu.getAttribute("Nb_Pages");
			var listMvtId = contenu.getAttribute("List_Mvt_Id");

			oom_aMouvements.setParam("List_Mvt_Id", listMvtId);
			oom_aMouvements.initTree(oom_initPagination);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oom_initPagination() {
	try {

		document.getElementById('oom-pageDeb').value = oom_pageCourante;
		document.getElementById('oom-pageFin').value = (oom_nbPages>0?oom_nbPages:1);
		document.getElementById('oom-bPrec').disabled = (oom_pageCourante==1);
		document.getElementById('oom-bSuiv').disabled = (oom_pageCourante>=oom_nbPages); // peut se produire si oom_nbPages=0

		oom_afterMajPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function oom_pressOnPagePrec() {
	try {

		oom_pageCourante--;
		oom_majPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function oom_pressOnPageSuiv() {
	try {

		oom_pageCourante++;
		oom_majPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function oom_majPagination() {
	try {

		document.getElementById('oom-pageDeb').value = oom_pageCourante;
		document.getElementById('oom-bPrec').disabled = (oom_pageCourante==1);
		document.getElementById('oom-bSuiv').disabled = (oom_pageCourante==oom_nbPages);

		document.getElementById('oom-listeMouvements').disabled = true;
		document.getElementById('oom-bEditionCsv').disabled = true;

		oom_qListMS.setParam("Current_Page", oom_pageCourante);
		var result = oom_qListMS.execute();
		var listMvtId = result.responseXML.documentElement.getAttribute("List_Mvt_Id");

		oom_aMouvements.setParam("List_Mvt_Id", listMvtId);
		oom_aMouvements.initTree(oom_afterMajPagination);

	} catch (e) {
		recup_erreur(e);
	}
}


function oom_afterMajPagination() {
	try {

		document.getElementById('oom-listeMouvements').disabled = false;
		document.getElementById('oom-bEditionCsv').disabled = (oom_aMouvements.nbLignes()==0);

	} catch (e) {
		recup_erreur(e);
	}
}


function oom_pressOnCritere(ev) {
  try {

		if (ev.keyCode==13) {
			oom_listerMouvements();
    }

	} catch (e) {
  	recup_erreur(e);
  }
}


function oom_pressOnEditionCsv() {
	try {

		var depotId = document.getElementById('oom-depot').value;
		var zoneStockage = document.getElementById('oom-zoneStockage').value;
		var codeEmplacement = document.getElementById('oom-codeEmplacement').value;
		var typeMvt = document.getElementById('oom-typeMvt').value;
		var numPiece = document.getElementById('oom-numPiece').value;
		var libelle = document.getElementById('oom-libelle').value;
		var sens = document.getElementById('oom-sens').value;
		var dateDebut = document.getElementById('oom-dateDebut').value;
		var dateFin = document.getElementById('oom-dateFin').value;

		if (!isEmpty(dateDebut) && !isDate(dateDebut)) { showWarning("Date de d\u00E9but incorrecte !"); }
		else if (!isEmpty(dateFin) && !isDate(dateFin)) { showWarning("Date de fin incorrecte !"); }
		else if (!isEmpty(dateDebut) && !isEmpty(dateFin) && !isDateInterval(dateDebut, dateFin)) { showWarning("Plage de dates incorrecte !"); }
		else {

			var qEditionCsv = new QueryHttp("Facturation/Mouvements_Stocks/csvMvtStock.tmpl");

			qEditionCsv.setParam("Depot_Id", depotId);
			qEditionCsv.setParam("Zone_Stockage", zoneStockage);
			qEditionCsv.setParam("Code_Emplacement", codeEmplacement);
			qEditionCsv.setParam("Type_Mvt", typeMvt);
			qEditionCsv.setParam("Num_Piece", numPiece);
			qEditionCsv.setParam("Libelle", libelle);
			qEditionCsv.setParam("Article_Id", ofa_articleId);
			qEditionCsv.setParam("Sens", sens);
			qEditionCsv.setParam("Date_Mvt_Debut", dateDebut);
			qEditionCsv.setParam("Date_Mvt_Fin", dateFin);

			var result = qEditionCsv.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				var fichier = result.responseXML.documentElement.getAttribute('FichierCSV');

				var file = fileChooser("save", fichier);
				if (file!=null) {
					downloadFile(getDirBuffer()+ fichier, file);
				}
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oom_rechercherEmplacement() {
	try {

		var url = "chrome://opensi/content/facturation/user/emplacements/popup-rechercheEmplacement.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', oom_retourRechercherEmplacement);

	} catch (e) {
		recup_erreur(e);
	}
}


function oom_retourRechercherEmplacement(codeEmplacement, emplacementId) {
	try {

  	document.getElementById('oom-codeEmplacement').value = codeEmplacement;
  	oom_listerMouvements();

	} catch (e) {
		recup_erreur(e);
	}
}
