	/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/


var oon_aComposants = new Arbre('Facturation/Articles/list-composantArticle.tmpl', 'oon-composants');

var oon_curComposantId = "";



function oon_initOngletNomenclature() {
	try {

		document.getElementById('oon-rowNomenclature').collapsed = gReadOnly;

		oon_aComposants.setParam('Article_Id', ofa_articleId);
		oon_aComposants.setParam('Explode', true);
		oon_aComposants.initTree();

		oon_annulerComposant();

		if (!gAccesCoutAchat) {
			document.getElementById('oon-colPrixAchat').setAttribute("ignoreincolumnpicker", true);
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oon_validerComposant() {
	try {

		if (ofa_modified) {
			showWarning("Vous devez enregistrer la fiche article avant de modifier la composition");
		}
		else {
			var refComposant = document.getElementById('oon-Reference').value;
    	var quantite = document.getElementById('oon-Quantite').value;

			if (isEmpty(quantite)) {
				showWarning("Veuillez sp\u00E9cifier une quantit\u00E9");
			}
			else if (!checkQte(quantite)) {
				showWarning("Quantit\u00E9 incorrecte");
			}
			else if (isEmpty(document.getElementById('oon-Designation').value)) {
				oon_rechercherReference();
			}
			else {
				var qSave;

				if (isEmpty(oon_curComposantId)) {
					qSave = new QueryHttp("Facturation/Articles/createComposantArticle.tmpl");
					qSave.setParam("Ref_Composant", refComposant);
				}
				else {
					qSave = new QueryHttp("Facturation/Articles/updateComposantArticle.tmpl");
					qSave.setParam("Composant_Id", oon_curComposantId);
				}

				qSave.setParam("Article_Id", ofa_articleId);
				qSave.setParam("Quantite", quantite);

				var result = qSave.execute();

				var errors = new Errors(result);
				if (errors.hasNext()) {
					errors.show();
				}
				else {
					oon_aComposants.initTree();
					oon_annulerComposant();

					if (result.responseXML.documentElement.getAttribute('Price_Update')=="true") {
						ofa_chargerArticle(true);
					}
				}
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oon_supprimerComposant() {
	try {

		if (ofa_modified) {
			showWarning("Vous devez enregistrer la fiche article avant de modifier la composition");
		}
		else {
			var qDelete = new QueryHttp("Facturation/Articles/deleteComposantArticle.tmpl");
			qDelete.setParam("Composant_Id", oon_curComposantId);
			qDelete.setParam("Article_Id", ofa_articleId);
    	var result = qDelete.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				oon_annulerComposant();
    		oon_aComposants.initTree();

				if (result.responseXML.documentElement.getAttribute('Price_Update')=="true") {
					ofa_chargerArticle(true);
				}
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oon_annulerComposant() {
	try {

		oon_curComposantId = "";
		document.getElementById('oon-Reference').value = "";
		document.getElementById('oon-Reference').disabled = false;
		document.getElementById('oon-Reference').focus();
		document.getElementById('oon-Designation').value = "";
		document.getElementById('oon-Quantite').value = 1;
		document.getElementById('oon-bSupprimer').disabled = true;
		document.getElementById('oon-bArticle').disabled = false;

	} catch (e) {
    recup_erreur(e);
  }
}


function oon_rechercherStock(reference) {
	try {

		var url = "chrome://opensi/content/facturation/user/articles/popup-rechercheArticle.xul";
    window.openDialog(url,'','chrome,modal,centerscreen', oon_retourRechercherStock, reference);

	} catch (e) {
    recup_erreur(e);
  }
}


function oon_retourRechercherStock(reference, articleId) {
	try {

		document.getElementById('oon-Reference').value = reference;
		document.getElementById('oon-Reference').disabled = true;
		oon_afficherDesignation(articleId);
		document.getElementById('oon-Quantite').focus();

	} catch (e) {
    recup_erreur(e);
  }
}


function oon_pressOnQuantite(ev) {
	try {

		if (ev.keyCode==13) {
			oon_validerComposant();
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oon_pressOnReference(ev) {
	try {

		if (ev.keyCode==13) {
			oon_rechercherReference();
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oon_rechercherReference() {
	try {

		var reference = document.getElementById('oon-Reference').value;

		var qSearch = new QueryHttp("Facturation/Articles/searchReference.tmpl");
		qSearch.setParam("Reference", reference);
		var result = qSearch.execute();

		var articleId = result.responseXML.documentElement.getAttribute("Article_Id");

		if (!isEmpty(articleId)) {
			document.getElementById('oon-Reference').value = result.responseXML.documentElement.getAttribute("Reference");
			document.getElementById('oon-Reference').disabled = true;
			document.getElementById('oon-Quantite').focus();
			oon_afficherDesignation(articleId);
		}
		else {
			oon_rechercherStock(reference);
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oon_afficherDesignation(articleId) {
	try {

		var qDesignation = new QueryHttp("Facturation/Articles/getDesignation.tmpl");
		qDesignation.setParam("Article_Id", articleId);
		var result = qDesignation.execute();
		document.getElementById('oon-Designation').value = result.responseXML.documentElement.getAttribute("Designation");

	} catch (e) {
		recup_erreur(e);
	}
}


function oon_ouvrirComposant() {
  try {

		if (oon_aComposants.isSelected()) {
			if (!isEmpty(oon_aComposants.getSelectedCellText('oon-colComposantId'))) {
				document.getElementById('oon-bSupprimer').disabled = false;
				document.getElementById('oon-Reference').disabled = true;
				document.getElementById('oon-bArticle').disabled = true;
				oon_curComposantId = oon_aComposants.getSelectedCellText('oon-colComposantId');
				document.getElementById("oon-Reference").value = oon_aComposants.getSelectedCellText('oon-colReference');
				document.getElementById("oon-Designation").value = oon_aComposants.getSelectedCellText('oon-colDesignation');
				document.getElementById("oon-Quantite").value = oon_aComposants.getSelectedCellText('oon-colQuantite');
			}
			else {
				oon_annulerComposant();
			}
		}

	} catch (e) {
  	recup_erreur(e);
	}
}

