/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/


var oop_aPotentiels = new Arbre('Facturation/Articles/list-potentielForfait.tmpl', 'oop-potentiels');



function oop_initOngletPotentielForfait() {
	try {

		oop_aPotentiels.setParam("Article_Id", ofa_articleId);
		oop_aPotentiels.initTree(oop_calculTotaux);

	} catch (e) {
		recup_erreur(e);
	}
}


function oop_calculTotaux() {
	try {

		var totalReel = 0;
		var totalReserve = 0;
		var totalDispo = 0;
		var totalAttendu = 0;
		var totalVirtuel = 0;

		for (var i=0; i<oop_aPotentiels.nbLignes(); i++) {

			totalReel += parseFloat(oop_aPotentiels.getCellText(i, "oop-colPotentielReel"));
			totalReserve += parseFloat(oop_aPotentiels.getCellText(i, "oop-colPotentielReserve"));
			totalDispo += parseFloat(oop_aPotentiels.getCellText(i, "oop-colPotentielDispo"));
			totalAttendu += parseFloat(oop_aPotentiels.getCellText(i, "oop-colPotentielAttendu"));
			totalVirtuel += parseFloat(oop_aPotentiels.getCellText(i, "oop-colPotentielVirtuel"));
		}

		var fqte = new NumberFormat("0.###", false);

		document.getElementById('oop-potentielReelTotal').value = fqte.format(totalReel);
		document.getElementById('oop-potentielReserveTotal').value = fqte.format(totalReserve);
		document.getElementById('oop-potentielDispoTotal').value = fqte.format(totalDispo);
		document.getElementById('oop-potentielAttenduTotal').value = fqte.format(totalAttendu);
		document.getElementById('oop-potentielVirtuelTotal').value = fqte.format(totalVirtuel);

		var qCumuls = new QueryHttp("Facturation/Articles/getCumulsPotentielForfait.tmpl");
		qCumuls.setParam("Article_Id", ofa_articleId);
		var result = qCumuls.execute();

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}
		else {
			var contenu = result.responseXML.documentElement;

			document.getElementById('oop-potentielReelCumul').value = contenu.getAttribute('Cumul_Reel');
			document.getElementById('oop-potentielReserveCumul').value = contenu.getAttribute('Cumul_Reserve');
			document.getElementById('oop-potentielDispoCumul').value = contenu.getAttribute('Cumul_Dispo');
			document.getElementById('oop-potentielAttenduCumul').value = contenu.getAttribute('Cumul_Attendu');
			document.getElementById('oop-potentielVirtuelCumul').value = contenu.getAttribute('Cumul_Virtuel');
		}

	} catch (e) {
		recup_erreur(e);
	}
}
