/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

var oor_aReferenceClient = new Arbre("Facturation/Articles/list-referenceClient.tmpl", "oor-listeReferences");

var oor_referenceId;



function oor_initOngletReferencesSpecifiques() {
	try {

		document.getElementById('oor-rowReferenceSpecifique').collapsed = gReadOnly;
		document.getElementById('oor-boxRAZ').collapsed = gReadOnly;

		oor_nouveauReferenceClient();

		oor_aReferenceClient.setParam("Article_Id", ofa_articleId);
		oor_aReferenceClient.initTree();

  } catch (e) {
    recup_erreur(e);
  }
}


function oor_nouveauReferenceClient() {
	try {

		oor_referenceId = "";

		document.getElementById("oor-numClient").value = "";
		document.getElementById("oor-refClient").value = "";
		document.getElementById("oor-bSupprimerReferenceClient").disabled = true;
		document.getElementById("oor-bRechercherClient").disabled = false;
		document.getElementById("oor-refClient").disabled = true;

		oor_aReferenceClient.clearSelection();

	} catch (e) {
		recup_erreur(e);
	}
}


function oor_enregistrerReferenceClient() {
	try {

		var numClient = document.getElementById("oor-numClient").value;
		var refClient = document.getElementById("oor-refClient").value;

		if (isEmpty(numClient)) {
			showWarning("Veuillez sp\u00E9cifier un n\u00B0 client");
		}
		else if (isEmpty(refClient)) {
			showWarning("Veuillez sp\u00E9cifier une r\u00E9f\u00E9rence client");
		}
		else {
			var qSave;

			if (isEmpty(oor_referenceId)) {
				qSave = new QueryHttp("Facturation/Articles/createReferenceClient.tmpl");
				qSave.setParam("Article_Id", ofa_articleId);
				qSave.setParam("Num_Client", numClient);
			}
			else {
				qSave = new QueryHttp("Facturation/Articles/updateReferenceClient.tmpl");
				qSave.setParam("Reference_Id", oor_referenceId);
			}

			qSave.setParam("Ref_Client", refClient);

			var result = qSave.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}

			oor_aReferenceClient.initTree();
			oor_nouveauReferenceClient();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oor_supprimerReferenceClient() {
	try {

		var qSup = new QueryHttp("Facturation/Articles/deleteReferenceClient.tmpl");
		qSup.setParam("Reference_Id", oor_referenceId);
		qSup.execute();

		oor_aReferenceClient.initTree();
		oor_nouveauReferenceClient();

	} catch (e) {
		recup_erreur(e);
	}
}


function oor_pressOnListeReferenceClient() {
	try {

		if (oor_aReferenceClient.isSelected()) {
			oor_referenceId = oor_aReferenceClient.getSelectedCellText("oor-colReferenceId");

			document.getElementById("oor-numClient").value = oor_aReferenceClient.getSelectedCellText("oor-colNumClient");
			document.getElementById("oor-refClient").value = oor_aReferenceClient.getSelectedCellText("oor-colRefClient");

			document.getElementById("oor-bSupprimerReferenceClient").disabled = false;
			document.getElementById("oor-bRechercherClient").disabled = true;

			document.getElementById("oor-refClient").disabled = false;
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oor_razReferenceClient() {
	try {

		if (window.confirm("Confirmez-vous la suppression de toutes les r\u00E9f\u00E9rences sp\u00E9cifiques li\u00E9es \u00E0 cet article ?")) {
			var qSup = new QueryHttp("Facturation/Articles/deleteReferenceClientByArticleId.tmpl");
			qSup.setParam("Article_Id", ofa_articleId);
			qSup.execute();

			oor_aReferenceClient.initTree();
			oor_nouveauReferenceClient();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oor_rechercherClient() {
	try {

		var url = "chrome://opensi/content/facturation/user/clients/popup-rechercheClient.xul";
		window.openDialog(url,'','chrome,modal,centerscreen',oor_retourRechercherClient);

	} catch (e) {
		recup_erreur(e);
	}
}


function oor_retourRechercherClient(numClient, clientId) {
	try {

  	document.getElementById('oor-numClient').value = numClient;
		document.getElementById("oor-refClient").disabled = false;

	} catch (e) {
		recup_erreur(e);
	}
}

