/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/


var ofc_aFamilles = new Arbre("ComboListe/combo-famillesClient.tmpl", "ofc-famille");
var ofc_aResponsables = new Arbre("ComboListe/combo-responsables.tmpl", "ofc-responsable");
var ofc_aDepots = new Arbre("Facturation/Clients/list-depotClient.tmpl", "ofc-listeDepots");
var ofc_aMentionsClient = new Arbre('Facturation/Clients/list-mentionClient.tmpl', 'ofc-listeMentions');
var ofc_aModesReglement = new Arbre("ComboListe/combo-modesReglement.tmpl", "ofc-modeReglement");
var ofc_aModalitesReg = new Arbre("ComboListe/combo-modalitesReglement.tmpl", "ofc-modaliteReg");
var ofc_aModesExpedition = new Arbre("ComboListe/combo-modesExpedition.tmpl", "ofc-modeExpedition");
var ofc_aPolesActivite = new Arbre("ComboListe/combo-polesActivite.tmpl", "ofc-poleActivite");
var ofc_aBanques = new Arbre('ComboListe/combo-banques.tmpl', 'ofc-banqueRemise');

var ofc_clientId;
var ofc_modified = false;
var ofc_mode;
var ofc_numerotationAuto;
var ofc_modeTarif;
var ofc_typePort;
var ofc_actSuiviSerie;
var ofc_numAutoCompteClient;
var ofc_droitAnonymisation;
var ofc_tmc;
var ofc_rmc;

var ofc_curFamille = "";
var ofc_curResponsable = "";
var ofc_curModeReglement = "";
var ofc_curModeExpedition = "";
var ofc_curModaliteReg = "";
var ofc_selPoleActivite;
var ofc_selBanqueId = "";

var ofc_defautPoleActivite;
var ofc_defautFactAvantLiv;
var ofc_defautModeEnvoiFacture;
var ofc_defautPeriodeFacturation;
var ofc_defautModeFacturation;
var ofc_defautBLChiffre;
var ofc_defautModeReglement;
var ofc_defautModaliteReg;



function ofc_init() {
  try {

		document.getElementById('ofc-lblReadOnly').collapsed = !gReadOnly;

		if (gReadOnly) {
			document.getElementById('ofc-colSelMention').setAttribute("editable", false);
		}

		ofc_modeTarif = gConfig.getModeTarif();
		ofc_tmc = gConfig.isSpecPVDTMC();
		ofc_rmc = gConfig.isSpecLCARMC();
		ofc_numerotationAuto = !isEmpty(gConfig.getFormatNC());
		ofc_actSuiviSerie = gConfig.isActSuiviSerie();
		ofc_numAutoCompteClient = gConfig.isNumAutoCompteClient();
		ofc_defautFactAvantLiv = gConfig.getDefFactAvantLiv();
		ofc_defautModeEnvoiFacture = gConfig.getDefModeEnvoiFacture();
		ofc_defautPeriodeFacturation = gConfig.getDefPeriodeFacturation();
		ofc_defautModeFacturation = gConfig.getDefModeFacturation();
		ofc_defautBLChiffre = gConfig.isBLChiffre();
		ofc_defautModeReglement = gConfig.getDefModeReglementC();
		ofc_defautModaliteReg = gConfig.getDefModaliteC();

		document.getElementById('ofc-grossiste').collapsed = !gConfig.isSpecLCAGGC();
		document.getElementById('ofc-appTarifClient').collapsed = !gConfig.isSpecLCAOTC();

		if (gConfig.isSpecTKPA()) {
			ofc_defautPoleActivite = gProfil.getPoleActivite();
		}
		else {
			ofc_defautPoleActivite = "";
		}

		ofc_droitAnonymisation = gProfil.isAnonymisationFC();
		document.getElementById('ofc-bloque').disabled = !gProfil.isGestionBloqueCli();

		var aPays = new Arbre("ComboListe/combo-pays.tmpl", "ofc-codePays");
		aPays.initTree(ofc_initPays);

		var aFormes = new Arbre("ComboListe/combo-formesJuridiques.tmpl", "ofc-formeJuridique");
		aFormes.initTree();

		var aTarifsVente = new Arbre("ComboListe/combo-tarifsVente.tmpl", "ofc-tarifId");
		aTarifsVente.initTree();

		if (ofc_modeTarif=="Q") {
			document.getElementById('ofc-rowTarifVente').collapsed = true;
		}

		var qGetCriteresActifs = new QueryHttp("CRM/GestionContacts/getCriteres.tmpl");
		var result = qGetCriteresActifs.execute();
		var contenu = result.responseXML.documentElement;

		var libCritere1 = contenu.getAttribute("Label_1");
		var libCritere2 = contenu.getAttribute("Label_2");
		var libCritere3 = contenu.getAttribute("Label_3");
		var libCritere4 = contenu.getAttribute("Label_4");
		var libCritere5 = contenu.getAttribute("Label_5");

		var actCritere1 = (contenu.getAttribute("Actif_1")=="true");
		var actCritere2 = (contenu.getAttribute("Actif_2")=="true");
		var actCritere3 = (contenu.getAttribute("Actif_3")=="true");
		var actCritere4 = (contenu.getAttribute("Actif_4")=="true");
		var actCritere5 = (contenu.getAttribute("Actif_5")=="true");

		document.getElementById("ooc-Critere_1").setAttribute("label", libCritere1);
		document.getElementById("ooc-Critere_2").setAttribute("label", libCritere2);
		document.getElementById("ooc-Critere_3").setAttribute("label", libCritere3);
		document.getElementById("ooc-Critere_4").setAttribute("label", libCritere4);
		document.getElementById("ooc-Critere_5").setAttribute("label", libCritere5);

		document.getElementById("ooc-Critere_1").collapsed = !actCritere1;
		document.getElementById("ooc-Critere_2").collapsed = !actCritere2;
		document.getElementById("ooc-Critere_3").collapsed = !actCritere3;
		document.getElementById("ooc-Critere_4").collapsed = !actCritere4;
		document.getElementById("ooc-Critere_5").collapsed = !actCritere5;

		document.getElementById("ooc-ColCritere1").setAttribute("tooltiptext", libCritere1);
		document.getElementById("ooc-ColCritere2").setAttribute("tooltiptext", libCritere2);
		document.getElementById("ooc-ColCritere3").setAttribute("tooltiptext", libCritere3);
		document.getElementById("ooc-ColCritere4").setAttribute("tooltiptext", libCritere4);
		document.getElementById("ooc-ColCritere5").setAttribute("tooltiptext", libCritere5);

		document.getElementById("ooc-ColCritere1").setAttribute("label", libCritere1);
		document.getElementById("ooc-ColCritere2").setAttribute("label", libCritere2);
		document.getElementById("ooc-ColCritere3").setAttribute("label", libCritere3);
		document.getElementById("ooc-ColCritere4").setAttribute("label", libCritere4);
		document.getElementById("ooc-ColCritere5").setAttribute("label", libCritere5);

		if (!actCritere1) {	document.getElementById("ooc-ColCritere1").setAttribute("ignoreincolumnpicker", true); }
		if (!actCritere2) {	document.getElementById("ooc-ColCritere2").setAttribute("ignoreincolumnpicker", true); }
		if (!actCritere3) {	document.getElementById("ooc-ColCritere3").setAttribute("ignoreincolumnpicker", true); }
		if (!actCritere4) {	document.getElementById("ooc-ColCritere4").setAttribute("ignoreincolumnpicker", true); }
		if (!actCritere5) {	document.getElementById("ooc-ColCritere5").setAttribute("ignoreincolumnpicker", true); }

		document.getElementById("ooc-ColCritere1").collapsed = !actCritere1;
		document.getElementById("ooc-ColCritere2").collapsed = !actCritere2;
		document.getElementById("ooc-ColCritere3").collapsed = !actCritere3;
		document.getElementById("ooc-ColCritere4").collapsed = !actCritere4;
		document.getElementById("ooc-ColCritere5").collapsed = !actCritere5;

		document.getElementById('ofc-boxMWMPicking').collapsed = !gProfil.isAccMWM();

	} catch (e) {
  	recup_erreur(e);
	}
}


function ofc_initPays() {
	try {

    document.getElementById('ofc-codePays').value = "FR";

	} catch (e) {
    recup_erreur(e);
  }
}


function ofc_selectFormeJuridique(formeJuridique) {
	try {

		var selected = false;
		var i = 0;
		var menulist = document.getElementById('ofc-formeJuridique');
		var items = menulist.getElementsByTagName("menuitem");
		while (!selected && i<items.length) {
			if (items[i].getAttribute("label")==formeJuridique) {
				menulist.selectedIndex = i;
				selected = true;
			}
			i++;
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function ofc_chargerFamilles(selection) {
	try {

		ofc_curFamille = selection;
		ofc_aFamilles.setParam("Selection", ofc_curFamille);
		ofc_aFamilles.initTree(ofc_initFamille);

	} catch (e) {
		recup_erreur(e);
	}
}


function ofc_initFamille() {
  try {

		document.getElementById('ofc-famille').value = ofc_curFamille;

	} catch (e) {
		recup_erreur(e);
	}
}


function ofc_chargerResponsables(selection) {
	try {

		ofc_curResponsable = selection;
		ofc_aResponsables.setParam("Selection", ofc_curResponsable);
		ofc_aResponsables.initTree(ofc_initResponsable);

	} catch (e) {
		recup_erreur(e);
	}
}


function ofc_initResponsable() {
  try {

		document.getElementById('ofc-responsable').value = ofc_curResponsable;

	} catch (e) {
  	recup_erreur(e);
	}
}


function ofc_chargerPolesActivite(selection) {
	try {

		ofc_selPoleActivite = selection;
		ofc_aPolesActivite.setParam("Selection", ofc_selPoleActivite);
		ofc_aPolesActivite.initTree(ofc_initPoleActivite);

	} catch (e) {
		recup_erreur(e);
	}
}


function ofc_initPoleActivite() {
  try {

		document.getElementById('ofc-poleActivite').value = ofc_selPoleActivite;

	} catch (e) {
  	recup_erreur(e);
	}
}


function ofc_chargerBanques(selection) {
	try {

		ofc_selBanqueId = selection;
		ofc_aBanques.setParam("Selection", ofc_selBanqueId);
		ofc_aBanques.initTree(ofc_initBanque);

	} catch (e) {
		recup_erreur(e);
	}
}


function ofc_initBanque() {
  try {

		document.getElementById('ofc-banqueRemise').value = ofc_selBanqueId;

	} catch (e) {
  	recup_erreur(e);
	}
}


function ofc_chargerModesExpedition(selection) {
	try {

		ofc_curModeExpedition = selection;
		ofc_aModesExpedition.setParam("Selection", ofc_curModeExpedition);
		ofc_aModesExpedition.initTree(ofc_initModeExpedition);

	} catch (e) {
		recup_erreur(e);
	}
}


function ofc_initModeExpedition() {
	try {

   	document.getElementById('ofc-modeExpedition').value = ofc_curModeExpedition;

	} catch (e) {
    recup_erreur(e);
  }
}


function ofc_chargerModesReglement(selection) {
	try {

		ofc_curModeReglement = selection;
		ofc_aModesReglement.setParam("Selection", ofc_curModeReglement);
		ofc_aModesReglement.initTree(ofc_initModeReglement);

	} catch (e) {
		recup_erreur(e);
	}
}


function ofc_initModeReglement() {
	try {

  	document.getElementById('ofc-modeReglement').value = ofc_curModeReglement;

	} catch (e) {
    recup_erreur(e);
  }
}


function ofc_chargerModalitesReg(selection) {
	try {

		ofc_curModaliteReg = selection;
		ofc_aModalitesReg.setParam("Selection", ofc_curModaliteReg);
		ofc_aModalitesReg.setParam("Type_Tiers", "C");
		ofc_aModalitesReg.initTree(ofc_initModaliteReg);

	} catch (e) {
		recup_erreur(e);
	}
}


function ofc_initModaliteReg() {
	try {

  	document.getElementById('ofc-modaliteReg').value = ofc_curModaliteReg;

	} catch (e) {
    recup_erreur(e);
  }
}


function ofc_ouvrirEditionListeFamille() {
	try {

		var url = "chrome://opensi/content/facturation/user/commun/popup-ajouterElementListe.xul?"+ cookie() +"&Type_Element=FCLIENT";
    window.openDialog(url,'','chrome,modal,centerscreen', ofc_chargerFamilles);

	} catch (e) {
		recup_erreur(e);
	}
}


function ofc_afficherFichiers() {
	try {

	  var url = "chrome://opensi/content/facturation/user/commun/popup-fichiersAssocies.xul";
  	window.openDialog(url,'','chrome,modal,centerscreen', "FCLI", ofc_clientId, gReadOnly);

	} catch (e) {
    recup_erreur(e);
  }
}


function ofc_initListeDepots() {
	try {

		ofc_aDepots.deleteTree();
		var revendeur = document.getElementById('ofc-revendeur').checked;

		if (!isEmpty(ofc_clientId) && revendeur) {
			ofc_aDepots.setParam("Client_Id", ofc_clientId);
			ofc_aDepots.initTree(ofc_initDepots);
		}
		else {
			document.getElementById('ofc-grpRevendeur').collapsed = true;
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function ofc_initDepots() {
	try {

		document.getElementById('ofc-grpRevendeur').collapsed = false;

	} catch (e) {
		recup_erreur(e);
	}
}


function ofc_selTypeClient(t) {
  try {

		switch(t) {
			case 'P':	document.getElementById('ofc-bcParticulier').collapsed = true;
								document.getElementById('ofc-rowFormeJuridique').collapsed = true;
								if (isEmpty(ofc_clientId)) {
									document.getElementById('ofc-assujettiTVA').checked = false;
								}
								break;
			case 'E':	document.getElementById('ofc-bcParticulier').collapsed = false;
								document.getElementById('ofc-rowFormeJuridique').collapsed = false;
								if (isEmpty(ofc_clientId)) {
									document.getElementById('ofc-assujettiTVA').checked = true;
								}
								break;
			case 'O': document.getElementById('ofc-bcParticulier').collapsed = false;
								document.getElementById('ofc-rowFormeJuridique').collapsed = true;
								if (isEmpty(ofc_clientId)) {
									document.getElementById('ofc-assujettiTVA').checked = false;
								}
								break;
			case 'A': document.getElementById('ofc-bcParticulier').collapsed = false;
								document.getElementById('ofc-rowFormeJuridique').collapsed = false;
								break;
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function ofc_changerNumClient() {
	try {

		var numClient = document.getElementById('ofc-numClient').value;

		var url = "chrome://opensi/content/facturation/user/clients/popup-changementNumClient.xul?"+ cookie();
		window.openDialog(url,'','chrome,modal,centerscreen', ofc_remplaceNumClient, ofc_clientId, numClient);

	} catch (e) {
		recup_erreur(e);
	}
}


function ofc_remplaceNumClient(newNumClient) {
	try {

		document.getElementById('ofc-numClient').value = newNumClient;
		document.getElementById('ofc-lblClient').value = "Fiche client "+ newNumClient;
		document.getElementById('ofc-document').setAttribute("label", "Client N\u00B0 "+ newNumClient +" - "+ document.getElementById('ofc-denomination').value);

	} catch (e) {
		recup_erreur(e);
	}
}


function ofc_getCompteCollectif() {
	try {

		var numCompte = document.getElementById('ofc-compteClient').value;

		if (!isEmpty(numCompte)) {
			var qGet = new QueryHttp("Compta/Comptes/loadCompte.tmpl");
			qGet.setParam("Num_Compte", numCompte);
			var result = qGet.execute();
			document.getElementById('ofc-collectif').value = result.responseXML.documentElement.getAttribute('Collectif');
		}
		else {
			document.getElementById('ofc-collectif').value = "";
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function ofc_rechercherCompte() {
	try {

    var url ="chrome://opensi/content/compta/user/comptes/popup-rechercheCompte.xul";
    window.openDialog(url,'','chrome,modal,centerscreen', ofc_retourRechercherCompte, "", "C", "CLIENT", "", false);

	} catch (e) {
		recup_erreur(e);
	}
}


function ofc_retourRechercherCompte(numCompte, compteId) {
	try {

		document.getElementById("ofc-compteClient").value = numCompte;
		ofc_getCompteCollectif();
		ofc_setModified(true);

	} catch (e) {
		recup_erreur(e);
	}
}


function ofc_pressOnModeFacturation() {
	try {

		var modeFacturation = document.getElementById('ofc-modeFacturation').value;
		if (modeFacturation=="B") {
			document.getElementById('ofc-factAvantLiv').checked = false;
		}
		document.getElementById('ofc-factAvantLiv').disabled = (modeFacturation=="B");

	} catch (e) {
		recup_erreur(e);
	}
}


function ofc_switchTypePort() {
	try {

		if (ofc_typePort=='P') {
			document.getElementById('ofc-bTypePort').setAttribute("class", "bIcoEuro");
			ofc_typePort = 'M';
		}
		else {
			document.getElementById('ofc-bTypePort').setAttribute("class", "bIcoPourcentage");
			ofc_typePort = 'P';
		}
		ofc_setModified(true);

	} catch (e) {
    recup_erreur(e);
  }
}


function ofc_pressOnFrancoPort() {
	try {

		var francoPort = document.getElementById('ofc-francoPort').checked;
		document.getElementById('ofc-montantFranco').disabled = !francoPort;
		if (!francoPort) {
			document.getElementById('ofc-montantFranco').value = "0.00";
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function ofc_initIHM() {
	try {

		document.getElementById('ofc-panneau').selectedIndex = 0;
		ofc_hideButtons(false);

		if (ofc_mode=="M" || ofc_numerotationAuto) {
			document.getElementById('ofc-numClient').setAttribute('readonly', true);
		}
		else {
			document.getElementById('ofc-numClient').removeAttribute('readonly');
		}

		document.getElementById('ofc-tabAdresses').collapsed = ofc_mode=="C";
		document.getElementById('ofc-tabContacts').collapsed = ofc_mode=="C";
		document.getElementById('ofc-tabBanques').collapsed = ofc_mode=="C" || !gProfil.isAccesBanqueCli();
		document.getElementById('ofc-tabStatistiques').collapsed = ofc_mode=="C";
		document.getElementById('ofc-tabTarifs').collapsed = ofc_mode=="C" || ofc_modeTarif=="Q";
		document.getElementById('ofc-tabMarques').collapsed = !ofc_tmc || ofc_mode=="C" || ofc_modeTarif=="Q";
		document.getElementById('ofc-tabRemises').collapsed = !ofc_rmc || ofc_mode=="C" || ofc_modeTarif=="Q";
		document.getElementById('ofc-tabReferences').collapsed = ofc_mode=="C";
		document.getElementById('ofc-tabWeb').collapsed = ofc_mode=="C" || !gSiteWeb;
		document.getElementById('ofc-tabNumSerie').collapsed = ofc_mode=="C" || !ofc_actSuiviSerie;

		document.getElementById('ofc-bSupprimer').collapsed = ofc_mode=="C" || gReadOnly;
		document.getElementById('ofc-bEnregistrer').collapsed = gReadOnly;
		document.getElementById('ofc-bAnonymiser').collapsed = ofc_mode=="C" || !ofc_droitAnonymisation || document.getElementById('ofc-typeClient').value!="P";
		document.getElementById('ofc-grpMentions').collapsed = ofc_mode=="C";
		document.getElementById('ofc-numClient').collapsed = ofc_mode=="C" && ofc_numerotationAuto;
		document.getElementById('ofc-lblAuto').collapsed = ofc_mode=="M" || !ofc_numerotationAuto;
		document.getElementById('ofc-bChgCodeClient').collapsed = ofc_mode=="C" || ofc_numerotationAuto || gReadOnly;
		document.getElementById('ofc-rowFichiers').collapsed = ofc_mode=="C";
		document.getElementById('ofc-bRechCompte').collapsed = ofc_mode=="C" && ofc_numAutoCompteClient || gReadOnly;
		document.getElementById('ofc-compteClient').collapsed = ofc_mode=="C" && ofc_numAutoCompteClient;
		document.getElementById('ofc-lblCpteAuto').collapsed = ofc_mode=="M" || !ofc_numAutoCompteClient;
		document.getElementById('ofc-bCreerFamille').collapsed = gReadOnly;

		ofc_setModified(false);

	} catch (e) {
		recup_erreur(e);
	}
}


function ofc_nouveauClient() {
  try {

		document.getElementById('ofc-deckClient').selectedIndex = 0;

		ofc_mode = "C";
		ofc_clientId = "";

		// onglet fiche signaltique
		document.getElementById('ofc-lblClient').value = "Fiche client";

		document.getElementById('ofc-numClient').value = "";
		document.getElementById('ofc-denomination').value = "";
		document.getElementById('ofc-civilite').value = "0";
		document.getElementById('ofc-nom').value = "";
		document.getElementById('ofc-prenom').value = "";
		document.getElementById('ofc-adresse1').value = "";
		document.getElementById('ofc-adresse2').value = "";
		document.getElementById('ofc-adresse3').value = "";
		document.getElementById('ofc-codePostal').value = "";
		document.getElementById('ofc-ville').value = "";
		document.getElementById('ofc-codePays').value = "FR";
		document.getElementById('ofc-tel1').value = "";
		document.getElementById('ofc-tel2').value = "";
		document.getElementById('ofc-tel3').value = "";
		document.getElementById('ofc-fax1').value = "";
		document.getElementById('ofc-fax2').value = "";
		document.getElementById('ofc-email1').value = "";
		document.getElementById('ofc-email2').value = "";
		document.getElementById('ofc-siteWeb').value = "";
		document.getElementById('ofc-comLibre').value = "";
		document.getElementById('ofc-codeCouleur').value = 2;
		document.getElementById('ofc-formeJuridique').value = "";
		document.getElementById('ofc-numTVAIntra').value = "";
		document.getElementById('ofc-numSIRET').value = "";
		document.getElementById('ofc-codeNAF').value = "";
		ofc_chargerPolesActivite(ofc_defautPoleActivite);
		document.getElementById('ofc-codeFournisseur').value = "";
		document.getElementById('ofc-indications').value = "";
		document.getElementById('ofc-actif').checked = true;
		document.getElementById('ofc-qualifHL').checked = true;
		document.getElementById('ofc-qualifWeb').checked = false;
		document.getElementById('ofc-revendeur').checked = false;
		document.getElementById('ofc-grossiste').checked = false;
		document.getElementById('ofc-bloque').checked = false;
		document.getElementById('ofc-typeClient').value = "E";
		ofc_selectFormeJuridique('SARL');
		ofc_chargerFamilles("");
		ofc_chargerResponsables(gProfil.getLoggedUser());
		ofc_initListeDepots();

		// onglet lments de gestion
		document.getElementById('ofc-compteClient').value = "";
		document.getElementById('ofc-collectif').value = "";
		document.getElementById('ofc-assujettiTVA').checked = false;
		document.getElementById('ofc-regimeTVA').value = "G";
		document.getElementById('ofc-tauxRemise').value = "0.00";
		document.getElementById('ofc-tauxEscompte').value = "0.00";
		document.getElementById('ofc-tarifId').selectedIndex = 0;
		document.getElementById('ofc-appTarifClient').checked = false;
		document.getElementById('ofc-nbEx').value = 1;
		document.getElementById('ofc-nbBon').value = 1;
		document.getElementById('ofc-modeFacturation').value = ofc_defautModeFacturation;
		document.getElementById('ofc-comFact').value = "";
		document.getElementById('ofc-encoursAuto').value = "0.00";
		document.getElementById('ofc-encoursFact').value = "0.00";
		document.getElementById('ofc-factAvantLiv').checked = ofc_defautFactAvantLiv;
		document.getElementById('ofc-periodeFacturation').value = ofc_defautPeriodeFacturation;
		document.getElementById('ofc-modeEnvoiFacture').value = ofc_defautModeEnvoiFacture;
		document.getElementById('ofc-envoiDetailFC').checked = false;
		document.getElementById('ofc-factAvantLiv').disabled = (ofc_defautModeFacturation=="B");
		document.getElementById('ofc-bonChiffre').checked = ofc_defautBLChiffre;
		document.getElementById('ofc-mwmControlePicking').checked = false;
		document.getElementById('ofc-francoPort').checked = false;
		document.getElementById('ofc-montantFranco').disabled = true;
		document.getElementById('ofc-montantFranco').value = "0.00";
		document.getElementById('ofc-fraisPort').value = "0.00";
		ofc_typePort = 'M';
		document.getElementById('ofc-bTypePort').setAttribute("class", "bIcoEuro");

		ofc_chargerBanques("");
		ofc_chargerModesExpedition("");
		ofc_chargerModesReglement(ofc_defautModeReglement);
		ofc_chargerModalitesReg(ofc_defautModaliteReg);
		ofc_aMentionsClient.deleteTree();
		ofc_selTypeClient('E');

		document.getElementById('ofc-creation').setAttribute("label", "");
		document.getElementById('ofc-modification').setAttribute("label", "");
		document.getElementById('ofc-document').setAttribute("label", "");

		ofc_initIHM();

	} catch (e) {
  	recup_erreur(e);
  }
}


function ofc_chargerClient() {
  try {

		document.getElementById('ofc-deckClient').selectedIndex = 0;

		ofc_mode = "M";

		var qLoad = new QueryHttp("Facturation/Clients/loadFicheClient.tmpl");
		qLoad.setParam('Client_Id', ofc_clientId);
		var result = qLoad.execute();

		var contenu = result.responseXML.documentElement;

		// onglet fiche signaltique
		document.getElementById('ofc-lblClient').value = "Fiche client "+ contenu.getAttribute('Num_Client');

		document.getElementById('ofc-numClient').value = contenu.getAttribute('Num_Client');
		document.getElementById('ofc-denomination').value = contenu.getAttribute('Denomination');
		document.getElementById('ofc-civilite').value = contenu.getAttribute('Civilite');
		document.getElementById('ofc-nom').value = contenu.getAttribute('Nom');
		document.getElementById('ofc-prenom').value = contenu.getAttribute('Prenom');
		document.getElementById('ofc-adresse1').value = contenu.getAttribute('Adresse_1');
		document.getElementById('ofc-adresse2').value = contenu.getAttribute('Adresse_2');
		document.getElementById('ofc-adresse3').value = contenu.getAttribute('Adresse_3');
		document.getElementById('ofc-codePostal').value = contenu.getAttribute('Code_Postal');
		document.getElementById('ofc-ville').value = contenu.getAttribute('Ville');
		document.getElementById('ofc-codePays').value = contenu.getAttribute('Code_Pays');
		document.getElementById('ofc-tel1').value = contenu.getAttribute('Tel_1');
		document.getElementById('ofc-tel2').value = contenu.getAttribute('Tel_2');
		document.getElementById('ofc-tel3').value = contenu.getAttribute('Tel_3');
		document.getElementById('ofc-fax1').value = contenu.getAttribute('Fax_1');
		document.getElementById('ofc-fax2').value = contenu.getAttribute('Fax_2');
		document.getElementById('ofc-email1').value = contenu.getAttribute('Email_1');
		document.getElementById('ofc-email2').value = contenu.getAttribute('Email_2');
		document.getElementById('ofc-siteWeb').value = contenu.getAttribute('Site_Web');
		document.getElementById('ofc-comLibre').value = contenu.getAttribute('Com_Libre');
		document.getElementById('ofc-codeCouleur').value = contenu.getAttribute('Code_Couleur');
		document.getElementById('ofc-formeJuridique').value = contenu.getAttribute('Forme_Juridique');
		document.getElementById('ofc-numTVAIntra').value = contenu.getAttribute('Num_TVA_Intra');
		document.getElementById('ofc-numSIRET').value = contenu.getAttribute('Num_SIRET');
		document.getElementById('ofc-codeNAF').value = contenu.getAttribute('Code_NAF');
		document.getElementById('ofc-codeFournisseur').value = contenu.getAttribute('Code_Fournisseur');
		document.getElementById('ofc-indications').value = contenu.getAttribute('Indications');
		document.getElementById('ofc-actif').checked = (contenu.getAttribute('Actif')=="true");
		document.getElementById('ofc-qualifHL').checked = (contenu.getAttribute('Qualif_HL')=="true");
		document.getElementById('ofc-qualifWeb').checked = (contenu.getAttribute('Qualif_Web')=="true");
		document.getElementById('ofc-revendeur').checked = (contenu.getAttribute('Revendeur')=="true");
		document.getElementById('ofc-grossiste').checked = (contenu.getAttribute('Grossiste')=="true");
		document.getElementById('ofc-bloque').checked = (contenu.getAttribute('Bloque')=="true");

		var typeClient = contenu.getAttribute('Type_Client');
		ofc_selTypeClient(typeClient);
		document.getElementById('ofc-typeClient').value = typeClient;

		ofc_chargerFamilles(contenu.getAttribute('Famille'));
		ofc_chargerResponsables(contenu.getAttribute('Util_R'));
		ofc_chargerPolesActivite(contenu.getAttribute('Pole_Activite'));

		ofc_initListeDepots();

		// onglet lments de gestion
		document.getElementById('ofc-compteClient').value = contenu.getAttribute('Compte_Client');
		document.getElementById('ofc-assujettiTVA').checked = (contenu.getAttribute('Assujetti_TVA')=="true");
		document.getElementById('ofc-regimeTVA').value = contenu.getAttribute('Regime_TVA');
		document.getElementById('ofc-tauxRemise').value = contenu.getAttribute('Taux_Remise');
		document.getElementById('ofc-tauxEscompte').value = contenu.getAttribute('Taux_Escompte');
		document.getElementById('ofc-tarifId').value = contenu.getAttribute('Tarif_Id');
		document.getElementById('ofc-appTarifClient').checked = contenu.getAttribute('App_Tarif_Client')=="true";
		document.getElementById('ofc-nbEx').value = contenu.getAttribute('Nb_Ex');
		document.getElementById('ofc-nbBon').value = contenu.getAttribute('Nb_Bon');
		document.getElementById('ofc-modeFacturation').value = contenu.getAttribute('Mode_Facturation');
		document.getElementById('ofc-comFact').value = contenu.getAttribute('Com_Fact');
		document.getElementById('ofc-encoursAuto').value = contenu.getAttribute('Encours_Auto');
		document.getElementById('ofc-encoursFact').value = contenu.getAttribute('Encours_Fact');
		document.getElementById('ofc-factAvantLiv').checked = contenu.getAttribute('Fact_Avant_Liv')=="true";
		document.getElementById('ofc-periodeFacturation').value = contenu.getAttribute('Periode_Facturation');
		document.getElementById('ofc-modeEnvoiFacture').value = contenu.getAttribute('Mode_Envoi_Facture');
		document.getElementById('ofc-envoiDetailFC').checked = contenu.getAttribute('Envoi_Detail_FC')=="true";
		document.getElementById('ofc-factAvantLiv').disabled = (contenu.getAttribute('Mode_Facturation')=="B");
		document.getElementById('ofc-bonChiffre').checked = (contenu.getAttribute('Bon_Chiffre')=="true");
		document.getElementById('ofc-mwmControlePicking').checked = (contenu.getAttribute('MWM_Controle_Picking')=="true");
		document.getElementById('ofc-codeRegroupement').value = contenu.getAttribute('Code_Regroupement');

		var francoPort = (contenu.getAttribute('Franco_Port')=="true");
		document.getElementById('ofc-francoPort').checked = francoPort;
		document.getElementById('ofc-montantFranco').value = contenu.getAttribute('Montant_Franco');
		document.getElementById('ofc-montantFranco').disabled = !francoPort;
		document.getElementById('ofc-fraisPort').value = contenu.getAttribute('Frais_Port');
		ofc_typePort = contenu.getAttribute('Type_Port');
		document.getElementById('ofc-bTypePort').setAttribute("class", ofc_typePort=="P"?"bIcoPourcentage":"bIcoEuro");

		ofc_getCompteCollectif();
		ofc_chargerBanques(contenu.getAttribute('Banque_Remise'));
		ofc_chargerModesExpedition(contenu.getAttribute('Mode_Expedition'));
		ofc_chargerModesReglement(contenu.getAttribute('Mode_Reg_Id'));
		ofc_chargerModalitesReg(contenu.getAttribute('Modalite_Id'));

		ofc_aMentionsClient.setParam("Client_Id", ofc_clientId);
		ofc_aMentionsClient.initTree();

		oot_initOngletTarifs();
		oor_initOngletReferences();
		oob_initOngletBanques();
		ooc_initOngletContacts();
		ooa_initOngletAdresses();
		oos_initOngletStatistiques();
		oon_initOngletNumSerie();
		oow_initOngletWeb();
		oom_initOngletMarques();
		oorm_initOngletRemises();

		document.getElementById('ofc-creation').setAttribute("label", "Client cr\u00E9\u00E9 le "+ contenu.getAttribute('Date_Creation') +" par "+ contenu.getAttribute('Login_Creation'));
		document.getElementById('ofc-modification').setAttribute("label", "Derni\u00E8re modification le "+ contenu.getAttribute('Date_Maj') +" par "+ contenu.getAttribute('Login_Maj'));
		document.getElementById('ofc-document').setAttribute("label", "Client N\u00B0 "+ contenu.getAttribute('Num_Client') +" - "+ contenu.getAttribute('Denomination'));

		ofc_initIHM();

	} catch (e) {
  	recup_erreur(e);
  }
}


function ofc_enregistrerClient() {
	try {

		// champs onglet fiche signaltique

		var numClient = document.getElementById('ofc-numClient').value;
		var denomination = document.getElementById('ofc-denomination').value;
		var civilite = document.getElementById('ofc-civilite').value;
		var nom = document.getElementById('ofc-nom').value;
		var prenom = document.getElementById('ofc-prenom').value;
		var adresse1 = document.getElementById('ofc-adresse1').value;
		var adresse2 = document.getElementById('ofc-adresse2').value;
		var adresse3 = document.getElementById('ofc-adresse3').value;
		var codePostal = document.getElementById('ofc-codePostal').value;
		var ville = document.getElementById('ofc-ville').value;
		var codePays = document.getElementById('ofc-codePays').value;
		var tel1 = document.getElementById('ofc-tel1').value;
		var tel2 = document.getElementById('ofc-tel2').value;
		var tel3 = document.getElementById('ofc-tel3').value;
		var fax1 = document.getElementById('ofc-fax1').value;
		var fax2 = document.getElementById('ofc-fax2').value;
		var email1 = document.getElementById('ofc-email1').value;
		var email2 = document.getElementById('ofc-email2').value;
		var siteWeb = document.getElementById('ofc-siteWeb').value;
		var comLibre = document.getElementById('ofc-comLibre').value;
		var codeCouleur = document.getElementById('ofc-codeCouleur').value;
		var formeJuridique = document.getElementById('ofc-formeJuridique').value;
		var numTVAIntra = document.getElementById('ofc-numTVAIntra').value;
		var numSIRET = document.getElementById('ofc-numSIRET').value;
		var codeNAF = document.getElementById('ofc-codeNAF').value;
		var famille = document.getElementById('ofc-famille').value;
		var poleActivite = document.getElementById('ofc-poleActivite').value;
		var actif = document.getElementById('ofc-actif').checked;
		var qualifHL = document.getElementById('ofc-qualifHL').checked;
		var qualifWeb = document.getElementById('ofc-qualifWeb').checked;
		var bloque = document.getElementById('ofc-bloque').checked;
		var revendeur = document.getElementById('ofc-revendeur').checked;
		var grossiste = document.getElementById('ofc-grossiste').checked;
		var responsable = document.getElementById('ofc-responsable').value;
		var codeFournisseur = document.getElementById('ofc-codeFournisseur').value;
		var indications = document.getElementById('ofc-indications').value;
		var typeClient = document.getElementById('ofc-typeClient').value;

		// champs onglet lments de gestion

    var compteClient = document.getElementById('ofc-compteClient').value;
		var modeReglement = document.getElementById('ofc-modeReglement').value;
		var modaliteReg = document.getElementById('ofc-modaliteReg').value;
		var assujettiTVA = document.getElementById('ofc-assujettiTVA').checked;
		var regimeTVA = document.getElementById('ofc-regimeTVA').value;
		var tauxRemise = document.getElementById('ofc-tauxRemise').value;
		var tauxEscompte = document.getElementById('ofc-tauxEscompte').value;
		var tarifId = document.getElementById('ofc-tarifId').value;
		var appTarifClient = document.getElementById('ofc-appTarifClient').checked;
		var nbEx = document.getElementById('ofc-nbEx').value;
		var modeExpedition = document.getElementById('ofc-modeExpedition').value;
		var banqueRemise = document.getElementById('ofc-banqueRemise').value;
		var nbBon = document.getElementById('ofc-nbBon').value;
		var bonChiffre = document.getElementById('ofc-bonChiffre').checked;
		var comFact = document.getElementById('ofc-comFact').value;
		var modeFacturation = document.getElementById('ofc-modeFacturation').value;
		var encoursAuto = document.getElementById('ofc-encoursAuto').value;
		var encoursFact = document.getElementById('ofc-encoursFact').value;
		var factAvantLiv = document.getElementById('ofc-factAvantLiv').checked;
		var periodeFacturation = document.getElementById('ofc-periodeFacturation').value;
		var modeEnvoiFacture = document.getElementById('ofc-modeEnvoiFacture').value;
		var envoiDetailFC = document.getElementById('ofc-envoiDetailFC').checked;
		var mwmControlePicking = document.getElementById('ofc-mwmControlePicking').checked;
		var francoPort = document.getElementById('ofc-francoPort').checked;
		var montantFranco = document.getElementById('ofc-montantFranco').value;
		var fraisPort = document.getElementById('ofc-fraisPort').value;
		var codeRegroupement = document.getElementById('ofc-codeRegroupement').value;

		if (ofc_mode=="C" && isEmpty(numClient) && !ofc_numerotationAuto) {
			showWarning("Veuillez sp\u00E9cifier un num\u00E9ro client (Onglet fiche signal\u00E9tique)");
		}
		else if (ofc_mode=="C" && ofc_existeClient(numClient) && !ofc_numerotationAuto) {
			showWarning("Le num\u00E9ro client '"+ numClient +"' est d\u00E9j\u00E0 utilis\u00E9 (Onglet fiche signal\u00E9tique)");
		}
		else if (ofc_mode=="C" && !isCleAlpha(numClient) && !ofc_numerotationAuto) {
			showWarning("Num\u00E9ro client invalide (Onglet fiche signal\u00E9tique)");
		}
		else if (typeClient!="P" && isEmpty(denomination)) { showWarning("Veuillez sp\u00E9cifier la d\u00E9nomination du client (Onglet fiche signal\u00E9tique)"); }
		else if (typeClient=="P" && isEmpty(nom)) { showWarning("Veuillez sp\u00E9cifier le nom du client (Onglet fiche signal\u00E9tique)"); }
		else if (isEmpty(adresse1)) { showWarning("Veuillez sp\u00E9cifier l'adresse du client (Onglet fiche signal\u00E9tique)"); }
		else if (isEmpty(ville)) { showWarning("Veuillez sp\u00E9cifier la ville du client (Onglet fiche signal\u00E9tique)"); }
		else if (isEmpty(responsable)) { showWarning("Veuillez sp\u00E9cifier le responsable du client (Onglet fiche signal\u00E9tique)"); }
		else if (!isEmpty(tel1) && !isPhone(tel1)) { showWarning("Num\u00E9ro de t\u00E9l\u00E9phone 1 incorrect (Onglet fiche signal\u00E9tique)"); }
		else if (!isEmpty(tel2) && !isPhone(tel2)) { showWarning("Num\u00E9ro de t\u00E9l\u00E9phone 2 incorrect (Onglet fiche signal\u00E9tique)"); }
		else if (!isEmpty(tel3) && !isPhone(tel3)) { showWarning("Num\u00E9ro de t\u00E9l\u00E9phone 3 incorrect (Onglet fiche signal\u00E9tique)"); }
		else if (!isEmpty(fax1) && !isPhone(fax1)) { showWarning("Num\u00E9ro de fax 1 incorrect (Onglet fiche signal\u00E9tique)"); }
		else if (!isEmpty(fax2) && !isPhone(fax2)) { showWarning("Num\u00E9ro de fax 2 incorrect (Onglet fiche signal\u00E9tique)"); }
		else if (!isEmpty(email1) && !isEmail(email1)) { showWarning("Adresse e-mail 1 incorrecte (Onglet fiche signal\u00E9tique)"); }
		else if (!isEmpty(email2) && !isEmail(email2)) { showWarning("Adresse e-mail 2 incorrecte (Onglet fiche signal\u00E9tique)"); }
		else if (!isEmpty(siteWeb) && !isWeb(siteWeb)) { showWarning("Site Web incorrect (Onglet fiche signal\u00E9tique)"); }
		else if (!isEmpty(numSIRET) && (numSIRET.length != 14 || !isDigitList(numSIRET))) { showWarning("Num\u00E9ro SIRET incorrect (Onglet fiche signal\u00E9tique)"); }
		else if (!isCleAlpha(codeRegroupement)) { showWarning("Code de regroupement incorrect (Onglet \u00E9l\u00E9ments de gestion)"); }
		else if (isEmpty(tauxRemise) || !isTaux(tauxRemise) || parseFloat(tauxRemise)>=100) { showWarning("Taux de remise incorrect (Onglet \u00E9l\u00E9ments de gestion)"); }
		else if (isEmpty(tauxEscompte) || !isTaux(tauxEscompte) || parseFloat(tauxEscompte)>=100) { showWarning("Taux d'escompte incorrect (Onglet \u00E9l\u00E9ments de gestion)"); }
		else if (isEmpty(encoursAuto) || !isPositiveOrNull(encoursAuto)) { showWarning("Encours total autoris\u00E9 incorrect (Onglet \u00E9l\u00E9ments de gestion)"); }
		else if (isEmpty(encoursFact) || !isPositiveOrNull(encoursFact)) { showWarning("Encours de facturation autoris\u00E9 incorrect (Onglet \u00E9l\u00E9ments de gestion)"); }
		else if (modeFacturation=="B" && factAvantLiv) { showWarning("Le type de facturation par BL et le mode de facturation par commande sont incompatibles (Onglet \u00E9l\u00E9ments de gestion)"); }
		else if (francoPort && !isPositiveOrNull(montantFranco)) { showWarning("Le montant du franco de port est incorrect (Onglet \u00E9l\u00E9ments de gestion)"); }
		else if (ofc_typePort=='P'?!isTaux(fraisPort):!isPositiveOrNull(fraisPort)) { showWarning("Le montant des frais de port est incorrect (Onglet \u00E9l\u00E9ments de gestion)"); }
		else {

			if (assujettiTVA && typeClient=="P") {
				showWarning("Attention : vous avez coch\u00E9 la case assujetti \u00E0 la tva bien que votre client soit un particulier");
			}
			else if (assujettiTVA && typeClient=="O") {
				showWarning("Attention : vous avez coch\u00E9 la case assujetti \u00E0 la tva bien que votre client soit un organisme public");
			}
			else if (!assujettiTVA && typeClient=="E") {
				showWarning("Attention : vous n'avez pas coch\u00E9 la case assujetti \u00E0 la tva bien que votre client soit une entreprise");
			}

			if (assujettiTVA && codePays!="FR" && isEmpty(numTVAIntra)) {
				var qZoneUE = new QueryHttp("Facturation/Commun/getZoneUEPays.tmpl");
				qZoneUE.setParam("Code_Pays", codePays);
				var result = qZoneUE.execute();
				if (result.responseXML.documentElement.getAttribute("Zone_UE")=="true") {
					showWarning("Attention : vous n'avez pas saisi le num\u00E9ro de tva intra-communautaire");
				}
			}

			var qSave;

			if (ofc_mode=="C") {
				qSave = new QueryHttp("Facturation/Clients/createFicheClient.tmpl");
			}
			else {
				qSave = new QueryHttp("Facturation/Clients/updateFicheClient.tmpl");
				qSave.setParam("Client_Id", ofc_clientId);
			}

			if (ofc_mode=="M" || !ofc_numerotationAuto) {
				qSave.setParam('Num_Client', numClient);
			}
			qSave.setParam("Denomination", denomination);
			qSave.setParam("Civilite", civilite);
			qSave.setParam("Nom", nom);
			qSave.setParam("Prenom", prenom);
			qSave.setParam("Adresse_1", adresse1);
			qSave.setParam("Adresse_2", adresse2);
			qSave.setParam("Adresse_3", adresse3);
			qSave.setParam("Code_Postal", codePostal);
			qSave.setParam("Ville", ville);
			qSave.setParam("Code_Pays", codePays);
			qSave.setParam("Tel_1", tel1);
			qSave.setParam("Tel_2", tel2);
			qSave.setParam("Tel_3", tel3);
			qSave.setParam("Fax_1", fax1);
			qSave.setParam("Fax_2", fax2);
			qSave.setParam("Email_1", email1);
			qSave.setParam("Email_2", email2);
			qSave.setParam("Site_Web", siteWeb);
			qSave.setParam("Com_Libre", comLibre);
			qSave.setParam("Code_Couleur", codeCouleur);
			qSave.setParam("Forme_Juridique", formeJuridique);
			qSave.setParam("Num_TVA_Intra", numTVAIntra);
			qSave.setParam("Num_SIRET", numSIRET);
			qSave.setParam("Code_NAF", codeNAF);
			qSave.setParam("Famille_Id", famille);
			qSave.setParam("Pole_Activite", poleActivite);
			qSave.setParam("Actif", actif);
			qSave.setParam("Qualif_HL", qualifHL);
			qSave.setParam("Qualif_Web", qualifWeb);
			qSave.setParam("Bloque", bloque);
			qSave.setParam("Revendeur", revendeur);
			qSave.setParam("Grossiste", grossiste);
			qSave.setParam("Util_R", responsable);
			qSave.setParam("Code_Fournisseur", codeFournisseur);
			qSave.setParam("Indications", indications);
			qSave.setParam("Type_Client", typeClient);

			qSave.setParam("Compte_Client", compteClient);
			qSave.setParam("Mode_Reg_Id", modeReglement);
			qSave.setParam("Modalite_Id", modaliteReg);
			qSave.setParam("Assujetti_TVA", assujettiTVA);
			qSave.setParam("Regime_TVA", regimeTVA);
			qSave.setParam("Taux_Remise", tauxRemise);
			qSave.setParam("Taux_Escompte", tauxEscompte);
			qSave.setParam("Tarif_Id", tarifId);
			qSave.setParam("App_Tarif_Client", appTarifClient);
			qSave.setParam("Nb_Ex", nbEx);
			qSave.setParam("Mode_Expedition", modeExpedition);
			qSave.setParam("Banque_Remise", banqueRemise);
			qSave.setParam("Nb_Bon", nbBon);
			qSave.setParam("Bon_Chiffre", bonChiffre);
			qSave.setParam("Com_Fact", comFact);
			qSave.setParam("Mode_Facturation", modeFacturation);
			qSave.setParam("Encours_Auto", encoursAuto);
			qSave.setParam("Encours_Fact", encoursFact);
			qSave.setParam("Fact_Avant_Liv", factAvantLiv);
			qSave.setParam("Periode_Facturation", periodeFacturation);
			qSave.setParam("Mode_Envoi_Facture", modeEnvoiFacture);
			qSave.setParam("Envoi_Detail_FC", envoiDetailFC);
			qSave.setParam("MWM_Controle_Picking", mwmControlePicking);
			qSave.setParam("Franco_Port", francoPort);
			qSave.setParam("Montant_Franco", montantFranco);
			qSave.setParam("Frais_Port", fraisPort);
			qSave.setParam("Type_Port", ofc_typePort);
			qSave.setParam("Code_Regroupement", codeRegroupement);

			var result = qSave.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				if (ofc_mode=="C") {
					ofc_clientId = result.responseXML.documentElement.getAttribute("Client_Id");
					ofc_chargerClient();
				}
				else {
					ooc_initOngletContacts();
					ooa_initOngletAdresses();
					ofc_initListeDepots();
					ofc_setModified(false);
				}
			}
		}

	} catch (e) {
  	recup_erreur(e);
  }
}


function ofc_supprimerClient() {
	try {

		var numClient = document.getElementById('ofc-numClient').value;

		if (window.confirm("Confirmez-vous la suppression du client "+ numClient +" ?")) {

			var qSupCli = new QueryHttp("Facturation/Clients/deleteFicheClient.tmpl");
			qSupCli.setParam('Client_Id', ofc_clientId);
			var result = qSupCli.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
    		showMessage("Le client a \u00E9t\u00E9 supprim\u00E9");
				retourMenuClients();
			}
		}

	} catch (e) {
  	recup_erreur(e);
  }
}


function ofc_existeClient(numClient) {
  try {

		var qExist = new QueryHttp("Facturation/Clients/existNumClient.tmpl");
		qExist.setParam('Num_Client', numClient);
		var result = qExist.execute();

  	return result.responseXML.documentElement.getAttribute('Exist')=="true";

  } catch (e) {
    recup_erreur(e);
  }
}


function ofc_hideButtons(b) {
	try {

		document.getElementById('ofc-buttons').collapsed = b;

	} catch (e) {
  	recup_erreur(e);
  }
}


function ofc_demandeEnregistrement() {
  try {

		if (ofc_modified) {
			if (window.confirm("Voulez-vous enregistrer les modifications apport\u00E9es \u00E0 la fiche client ?")) {
				ofc_enregistrerClient();
			}
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function ofc_setModified(m) {
  try {

  	ofc_modified = m && !gReadOnly;

		if (ofc_modified) {
			if (document.getElementById('ofc-panneau').selectedIndex==0) {
				document.getElementById('ofc-tabFiche').setAttribute('image', 'chrome://opensi/content/design/icones/modified.png');
			}
			else {
				document.getElementById('ofc-tabElements').setAttribute('image', 'chrome://opensi/content/design/icones/modified.png');
			}
		}
		else {
			document.getElementById('ofc-tabFiche').setAttribute('image', null);
			document.getElementById('ofc-tabElements').setAttribute('image', null);
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function ofc_clickOnMention(ev) {
	try {

		var col = ofc_aMentionsClient.getClickedCol(ev);

		if (col!=null && col.id=="ofc-colSelMention") {
			var idx = ofc_aMentionsClient.getClickedRowIndex(ev);

			ofc_tickMentionClient(idx);

			// dbut contournement bug HM - Tache redmine 11172
			for (var i=idx-1; i>=idx-3 && i>=0; i--) {
				ofc_tickMentionClient(i);
			}
			for (var i=idx+1; i<=idx+3 && i<ofc_aMentionsClient.nbLignes(); i++) {
				ofc_tickMentionClient(i);
			}
			// fin contournement bug
		}

	} catch (e) {
		recup_erreur(e);
  }
}


function ofc_tickMentionClient(idx) {
	try {

		var cocher = ofc_aMentionsClient.getCellValue(idx, "ofc-colSelMention");
		var mentionId = ofc_aMentionsClient.getCellText(idx, "ofc-colMentionId");

		var qTick = new QueryHttp("Facturation/Clients/saveMentionClient.tmpl");
		qTick.setParam("Client_Id", ofc_clientId);
		qTick.setParam("Mention_Id", mentionId);
		qTick.setParam("Cocher", cocher);

		qTick.execute();

	} catch (e) {
		recup_erreur(e);
  }
}


function ofc_anonymiserClient() {
	try {

		var numClient = document.getElementById('ofc-numClient').value;

		if (window.confirm("Confirmez-vous l'anonymisation des donn\u00E9es de la fiche client ?\nAttention cette op\u00E9ration est irr\u00E9versible.")) {

			var qAnoCli = new QueryHttp("Facturation/Clients/anonymizeFicheClient.tmpl");
			qAnoCli.setParam('Client_Id', ofc_clientId);
			var result = qAnoCli.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
    		showMessage("La fiche client a \u00E9t\u00E9 anonymis\u00E9e");
				retourMenuClients();
			}
		}

	} catch (e) {
  	recup_erreur(e);
  }
}
