/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

var ooa_currentAdr;
var ooa_aAdresses = new Arbre("Facturation/Clients/list-adresseClient.tmpl", "ooa-tree-adresses");
var ooa_aContactsFact = new Arbre("ComboListe/combo-contactsClient.tmpl", "ooa-Contact_Fact");
var ooa_aContactsLiv = new Arbre("ComboListe/combo-contactsClient.tmpl", "ooa-Contact_Liv");
var ooa_aContactsEnvoi = new Arbre("ComboListe/combo-contactsClient.tmpl", "ooa-Contact_Envoi");
var ooa_aContactsDevis = new Arbre("ComboListe/combo-contactsClient.tmpl", "ooa-Contact_Devis");



function ooa_initOngletAdresses() {
	try {

		document.getElementById('ooa-rowAdresse').collapsed = gReadOnly;

		var aPays = new Arbre("ComboListe/combo-pays.tmpl", "ooa-Code_Pays");
		aPays.initTree(ooa_initPaysAdr);

		ooa_aContactsFact.setParam("Client_Id", ofc_clientId);
		ooa_aContactsFact.initTree();

		ooa_aContactsLiv.setParam("Client_Id", ofc_clientId);
		ooa_aContactsLiv.initTree();

		ooa_aContactsEnvoi.setParam("Client_Id", ofc_clientId);
		ooa_aContactsEnvoi.initTree();

		ooa_aContactsDevis.setParam("Client_Id", ofc_clientId);
		ooa_aContactsDevis.initTree();

		ooa_aAdresses.setParam("Client_Id", ofc_clientId);
		ooa_aAdresses.initTree();
  	ooa_nouveauAdr();

	} catch (e) {
		recup_erreur(e);
  }
}


function ooa_initPaysAdr() {
	try {

    document.getElementById('ooa-Code_Pays').value = "FR";

	} catch (e) {
    recup_erreur(e);
  }
}


function ooa_nouveauAdr() {
	try {

		ooa_aAdresses.clearSelection();

		document.getElementById('ooa-Intitule').value = "";
		document.getElementById('ooa-Denomination').value = "";
		document.getElementById('ooa-Adresse_1').value = "";
		document.getElementById('ooa-Adresse_2').value = "";
		document.getElementById('ooa-Adresse_3').value = "";
		document.getElementById('ooa-Code_Postal').value = "";
		document.getElementById('ooa-Ville').value = "";
		ooa_initPaysAdr();
		document.getElementById('ooa-Defaut_Fact').checked = false;
		document.getElementById('ooa-Defaut_Liv').checked = false;
		document.getElementById('ooa-Defaut_Envoi').checked = false;
		document.getElementById('ooa-Defaut_Devis').checked = false;
		document.getElementById('ooa-Defaut_Fact').disabled = false;
		document.getElementById('ooa-Defaut_Liv').disabled = false;
		document.getElementById('ooa-Defaut_Envoi').disabled = false;
		document.getElementById('ooa-Defaut_Devis').disabled = false;
		document.getElementById('ooa-Principale').disabled = false;
		document.getElementById('ooa-Principale').checked = false;
		document.getElementById('ooa-Contact_Fact').value = "";
		document.getElementById('ooa-Contact_Liv').value = "";
		document.getElementById('ooa-Contact_Envoi').value = "";
		document.getElementById('ooa-Contact_Devis').value = "";

		document.getElementById('ooa-bNouveauAdr').collapsed = true;
		document.getElementById('ooa-bSupprimerAdr').collapsed = true;
		document.getElementById('ooa-bModifierAdr').collapsed = true;
		document.getElementById('ooa-bCreerAdr').collapsed = false;

	} catch (e) {
    recup_erreur(e);
  }
}


function ooa_enregistrerAdr(mode) {
  try {

		var intitule = document.getElementById('ooa-Intitule').value;
    var denomination = document.getElementById('ooa-Denomination').value;
		var adresse_1 = document.getElementById('ooa-Adresse_1').value;
		var adresse_2 = document.getElementById('ooa-Adresse_2').value;
		var adresse_3 = document.getElementById('ooa-Adresse_3').value;
		var code_postal = document.getElementById('ooa-Code_Postal').value;
		var ville = document.getElementById('ooa-Ville').value;
		var code_pays = document.getElementById('ooa-Code_Pays').value;
		var defaut_fact = document.getElementById('ooa-Defaut_Fact').checked;
		var defaut_liv = document.getElementById('ooa-Defaut_Liv').checked;
		var defaut_envoi = document.getElementById('ooa-Defaut_Envoi').checked;
		var defaut_devis = document.getElementById('ooa-Defaut_Devis').checked;
		var contact_fact = document.getElementById('ooa-Contact_Fact').value;
		var contact_liv = document.getElementById('ooa-Contact_Liv').value;
		var contact_envoi = document.getElementById('ooa-Contact_Envoi').value;
		var contact_devis = document.getElementById('ooa-Contact_Devis').value;
		var principale = document.getElementById('ooa-Principale').checked;

		if (isEmpty(denomination)) { showWarning("Veuillez sp\u00E9cifier la d\u00E9nomination"); }
		else if (isEmpty(adresse_1)) { showWarning("Veuillez sp\u00E9cifier l'adresse"); }
		else if (isEmpty(ville)) { showWarning("Veuillez sp\u00E9cifier la ville"); }
		else {

			var qSaveAdr;

			if (mode=="C") {
				qSaveAdr = new QueryHttp("Facturation/Clients/createAdresseClient.tmpl");
			}
			else {
				qSaveAdr = new QueryHttp("Facturation/Clients/updateAdresseClient.tmpl");
				qSaveAdr.setParam('Adresse_Id', ooa_currentAdr);
			}

			qSaveAdr.setParam('Client_Id', ofc_clientId);
			qSaveAdr.setParam('Intitule', intitule);
			qSaveAdr.setParam('Denomination', denomination);
			qSaveAdr.setParam('Adresse_1', adresse_1);
			qSaveAdr.setParam('Adresse_2', adresse_2);
			qSaveAdr.setParam('Adresse_3', adresse_3);
			qSaveAdr.setParam('Code_Postal', code_postal);
			qSaveAdr.setParam('Ville', ville);
			qSaveAdr.setParam('Code_Pays', code_pays);
			qSaveAdr.setParam('Defaut_Fact', defaut_fact);
			qSaveAdr.setParam('Defaut_Liv', defaut_liv);
			qSaveAdr.setParam('Defaut_Envoi', defaut_envoi);
			qSaveAdr.setParam('Defaut_Devis', defaut_devis);
			qSaveAdr.setParam('Contact_Fact', contact_fact);
			qSaveAdr.setParam('Contact_Liv', contact_liv);
			qSaveAdr.setParam('Contact_Envoi', contact_envoi);
			qSaveAdr.setParam('Contact_Devis', contact_devis);
			qSaveAdr.setParam('Principale', principale);

			var result = qSaveAdr.execute();

			document.getElementById('ooa-Defaut_Fact').disabled = defaut_fact;
			document.getElementById('ooa-Defaut_Liv').disabled = defaut_liv;
			document.getElementById('ooa-Defaut_Envoi').disabled = defaut_envoi;
			document.getElementById('ooa-Defaut_Devis').disabled = defaut_devis;
			document.getElementById('ooa-Principale').disabled = principale;

			if (principale) {
				document.getElementById('ofc-denomination').value = denomination;
				document.getElementById('ofc-adresse1').value = adresse_1;
				document.getElementById('ofc-adresse2').value = adresse_2;
				document.getElementById('ofc-adresse3').value = adresse_3;
				document.getElementById('ofc-codePostal').value = code_postal;
				document.getElementById('ofc-ville').value = ville;
				document.getElementById('ofc-codePays').value = code_pays;
			}

			if (mode=="C") {
				ooa_currentAdr = result.responseXML.documentElement.getAttribute('Adresse_Id');

				document.getElementById('ooa-bCreerAdr').collapsed = true;
				document.getElementById('ooa-bModifierAdr').collapsed = false;
				document.getElementById('ooa-bNouveauAdr').collapsed = false;
				document.getElementById('ooa-bSupprimerAdr').collapsed = false;
			}

			ooa_aAdresses.initTree();
		}

  } catch (e) {
    recup_erreur(e);
  }
}


function ooa_supprimerAdr() {
	try {

		var denomination = document.getElementById('ooa-Denomination').value;

		if (window.confirm("Confirmez-vous la suppression de l'adresse '"+ denomination +"' ?")) {

			var qSupAdr = new QueryHttp("Facturation/Clients/deleteAdresseClient.tmpl");
			qSupAdr.setParam('Adresse_Id', ooa_currentAdr);
			var result = qSupAdr.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				document.getElementById('ooa-bSupprimerAdr').collapsed = true;
				document.getElementById('ooa-bModifierAdr').collapsed = true;
				document.getElementById('ooa-bCreerAdr').collapsed = false;
				document.getElementById('ooa-bNouveauAdr').collapsed = true;

				ooa_aAdresses.initTree();
				ooa_nouveauAdr();
			}
		}

  } catch (e) {
  	recup_erreur(e);
  }
}


function ooa_chargerAdr() {
	try {

		if (ooa_aAdresses.isSelected()) {

			ooa_currentAdr = ooa_aAdresses.getSelectedCellValue('ooa-ColDenomination');

			document.getElementById('ooa-Intitule').value = ooa_aAdresses.getSelectedCellText('ooa-ColIntitule');
			document.getElementById('ooa-Denomination').value = ooa_aAdresses.getSelectedCellText('ooa-ColDenomination');
			document.getElementById('ooa-Adresse_1').value = ooa_aAdresses.getSelectedCellText('ooa-ColAdresse_1');
			document.getElementById('ooa-Adresse_2').value = ooa_aAdresses.getSelectedCellText('ooa-ColAdresse_2');
			document.getElementById('ooa-Adresse_3').value = ooa_aAdresses.getSelectedCellText('ooa-ColAdresse_3');
			document.getElementById('ooa-Code_Postal').value = ooa_aAdresses.getSelectedCellText('ooa-ColCode_Postal');
			document.getElementById('ooa-Ville').value = ooa_aAdresses.getSelectedCellText('ooa-ColVille');
			document.getElementById('ooa-Code_Pays').value = ooa_aAdresses.getSelectedCellText('ooa-ColCode_Pays');
			document.getElementById('ooa-Defaut_Fact').checked = (ooa_aAdresses.getSelectedCellText('ooa-ColDefaut_Fact')=="true");
			document.getElementById('ooa-Defaut_Liv').checked = (ooa_aAdresses.getSelectedCellText('ooa-ColDefaut_Liv')=="true");
			document.getElementById('ooa-Defaut_Envoi').checked = (ooa_aAdresses.getSelectedCellText('ooa-ColDefaut_Envoi')=="true");
			document.getElementById('ooa-Defaut_Devis').checked = (ooa_aAdresses.getSelectedCellText('ooa-ColDefaut_Devis')=="true");
			document.getElementById('ooa-Principale').checked = (ooa_aAdresses.getSelectedCellText('ooa-ColPrincipale')=="true");
			document.getElementById('ooa-Defaut_Fact').disabled = document.getElementById('ooa-Defaut_Fact').checked;
			document.getElementById('ooa-Defaut_Liv').disabled = document.getElementById('ooa-Defaut_Liv').checked;
			document.getElementById('ooa-Defaut_Envoi').disabled = document.getElementById('ooa-Defaut_Envoi').checked;
			document.getElementById('ooa-Defaut_Devis').disabled = document.getElementById('ooa-Defaut_Devis').checked;
			document.getElementById('ooa-Principale').disabled = document.getElementById('ooa-Principale').checked;
			document.getElementById('ooa-Contact_Fact').value = ooa_aAdresses.getSelectedCellText('ooa-ColContact_Fact');
			document.getElementById('ooa-Contact_Liv').value = ooa_aAdresses.getSelectedCellText('ooa-ColContact_Liv');
			document.getElementById('ooa-Contact_Envoi').value = ooa_aAdresses.getSelectedCellText('ooa-ColContact_Envoi');
			document.getElementById('ooa-Contact_Devis').value = ooa_aAdresses.getSelectedCellText('ooa-ColContact_Devis');

			document.getElementById('ooa-bSupprimerAdr').collapsed = false;
			document.getElementById('ooa-bModifierAdr').collapsed = false;
			document.getElementById('ooa-bNouveauAdr').collapsed = false;
			document.getElementById('ooa-bCreerAdr').collapsed = true;
		}

 	} catch (e) {
    recup_erreur(e);
  }
}
