/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

var oot_aPrixClient = new Arbre("Facturation/Clients/list-prixClient.tmpl", "oot-listeTarifs");

var oot_prixId;
var oot_arrondiHT;
var oot_arrondiTTC;



function oot_initOngletTarifs() {
	try {

		document.getElementById('oot-rowTarifSpecifique').collapsed = gReadOnly;
		document.getElementById('oot-bRAZ').collapsed = gReadOnly;
		document.getElementById('oot-bTraitementLot').collapsed = gReadOnly;

		oot_nouveauPrixClient();

		oot_aPrixClient.setParam("Client_Id", ofc_clientId);
		oot_aPrixClient.initTree();

  } catch (e) {
    recup_erreur(e);
  }
}


function oot_nouveauPrixClient() {
	try {

		oot_prixId = "";

		document.getElementById("oot-reference").value = "";
		document.getElementById("oot-pourcentagePV").value = "";
		document.getElementById("oot-prixHT").value = "";
		document.getElementById("oot-prixTTC").value = "";
		document.getElementById("oot-tauxMarque").value = "";
		document.getElementById("oot-tauxMarge").value = "";
		document.getElementById("oot-dateFin").value = "";
		document.getElementById("oot-bSupprimerPrixClient").disabled = true;
		document.getElementById("oot-bRechercherArticle").disabled = false;
		document.getElementById("oot-pourcentagePV").disabled = true;
		document.getElementById("oot-prixHT").disabled = true;
		document.getElementById("oot-prixTTC").disabled = true;
		document.getElementById("oot-tauxMarque").disabled = true;
		document.getElementById("oot-tauxMarge").disabled = true;
		document.getElementById("oot-dateFin").disabled = true;

		document.getElementById('oot-prixRevient').value = "";
		document.getElementById('oot-tauxTVA').value = "";
		document.getElementById('oot-tarifClient').value = "";
		document.getElementById('oot-basePrixHT').value = "";
		document.getElementById('oot-basePrixTTC').value = "";

		oot_aPrixClient.clearSelection();

	} catch (e) {
		recup_erreur(e);
	}
}


function oot_enregistrerPrixClient() {
	try {

		var reference = document.getElementById("oot-reference").value;
		var pourcentagePV = document.getElementById("oot-pourcentagePV").value;
		var prixHT = document.getElementById("oot-prixHT").value;
		var prixTTC = document.getElementById("oot-prixTTC").value;
		var tauxMarque = document.getElementById("oot-tauxMarque").value;
		var tauxMarge = document.getElementById("oot-tauxMarge").value;
		var dateFin = document.getElementById("oot-dateFin").value;

		if (isEmpty(reference)) {
			showWarning("Veuillez sp\u00E9cifier une r\u00E9f\u00E9rence article");
		}
		else if (isEmpty(prixHT) || !isPositiveOrNull(prixHT) || !checkNumber(prixHT,14,4)) {
			showWarning("Prix de vente HT incorrect");
		}
		else if (isEmpty(prixTTC) || !isPositiveOrNull(prixTTC) || !checkNumber(prixTTC,14,4)) {
			showWarning("Prix de vente TTC incorrect");
		}
		else if (!isEmpty(pourcentagePV) && (parseFloat(pourcentagePV)<-100 || !checkNumber(pourcentagePV,12,4))) {
			showWarning("Pourcentage sur prix de vente incorrect");
		}
		else if (!isEmpty(tauxMarque) && (parseFloat(tauxMarque)>=100 || !checkNumber(tauxMarque,12,6))) {
			showWarning("Taux de marque incorrect");
		}
		else if (!isEmpty(tauxMarge) && !checkNumber(tauxMarge,12,4)) {
			showWarning("Taux de marge incorrect");
		}
		else if (!isEmpty(dateFin) && !isDate(dateFin)) {
			showWarning("Date de fin de validit\u00E9 incorrecte");
		}
		else {
			var qSave;

			if (isEmpty(oot_prixId)) {
				qSave = new QueryHttp("Facturation/Clients/createPrixClient.tmpl");
				qSave.setParam("Client_Id", ofc_clientId);
				qSave.setParam("Reference", reference);
			}
			else {
				qSave = new QueryHttp("Facturation/Clients/updatePrixClient.tmpl");
				qSave.setParam("Prix_Id", oot_prixId);
			}

			qSave.setParam("Pourcentage_PV", pourcentagePV);
			qSave.setParam("Prix_HT", prixHT);
			qSave.setParam("Prix_TTC", prixTTC);
			qSave.setParam("Taux_Marque", tauxMarque);
			qSave.setParam("Taux_Marge", tauxMarge);
			qSave.setParam("Date_Fin", dateFin);

			var result = qSave.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}

			oot_aPrixClient.initTree();
			oot_nouveauPrixClient();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oot_supprimerPrixClient() {
	try {

		var qDelete = new QueryHttp("Facturation/Clients/deletePrixClient.tmpl");
		qDelete.setParam("Prix_Id", oot_prixId);
		qDelete.execute();

		oot_aPrixClient.initTree();
		oot_nouveauPrixClient();

	} catch (e) {
		recup_erreur(e);
	}
}


function oot_pressOnListePrixClient() {
	try {

		if (oot_aPrixClient.isSelected()) {
			oot_prixId = oot_aPrixClient.getSelectedCellText("oot-colPrixId");

			document.getElementById("oot-reference").value = oot_aPrixClient.getSelectedCellText("oot-colReference");
			document.getElementById("oot-pourcentagePV").value = oot_aPrixClient.getSelectedCellText("oot-colPourcentagePV");
			document.getElementById("oot-prixHT").value = oot_aPrixClient.getSelectedCellText("oot-colPrixHT");
			document.getElementById("oot-prixTTC").value = oot_aPrixClient.getSelectedCellText("oot-colPrixTTC");
			document.getElementById("oot-tauxMarque").value = oot_aPrixClient.getSelectedCellText("oot-colTauxMarque");
			document.getElementById("oot-tauxMarge").value = oot_aPrixClient.getSelectedCellText("oot-colTauxMarge");
			document.getElementById("oot-dateFin").value = oot_aPrixClient.getSelectedCellText("oot-colDateFin");

			document.getElementById("oot-bSupprimerPrixClient").disabled = false;
			document.getElementById("oot-bRechercherArticle").disabled = true;

			var articleId = oot_aPrixClient.getSelectedCellText("oot-colArticleId");
			oot_chargerInfosTarifSpecifique(articleId);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oot_razPrixClient() {
	try {

		if (window.confirm("Confirmez-vous la suppression de tous les tarifs sp\u00E9cifiques li\u00E9s \u00E0 ce client ?")) {
			var qDelete = new QueryHttp("Facturation/Clients/deletePrixClientByClientId.tmpl");
			qDelete.setParam("Client_Id", ofc_clientId);
			qDelete.execute();

			oot_aPrixClient.initTree();
			oot_nouveauPrixClient();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oot_rechercherArticle() {
	try {

		var url = "chrome://opensi/content/facturation/user/articles/popup-rechercheArticle.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', oot_retourRechercherArticle, "V", null, null, null, null, null, ofc_clientId);

	} catch (e) {
		recup_erreur(e);
	}
}


function oot_retourRechercherArticle(reference, articleId) {
	try {

  	document.getElementById('oot-reference').value = reference;
		oot_chargerInfosTarifSpecifique(articleId);

	} catch (e) {
		recup_erreur(e);
	}
}


function oot_chargerInfosTarifSpecifique(articleId) {
	try {

		var qInfos = new QueryHttp("Facturation/Articles/getInfosTarifSpecifique.tmpl");
		qInfos.setParam("Article_Id", articleId);
		qInfos.setParam("Client_Id", ofc_clientId);
		var result = qInfos.execute();

		var contenu = result.responseXML.documentElement;

		document.getElementById('oot-prixRevient').value = contenu.getAttribute('Prix_Revient');
		document.getElementById('oot-tauxTVA').value = contenu.getAttribute('Taux_TVA');
		document.getElementById('oot-tarifClient').value = contenu.getAttribute('Tarif_Client');
		document.getElementById('oot-basePrixHT').value = contenu.getAttribute('Base_Prix_HT');
		document.getElementById('oot-basePrixTTC').value = contenu.getAttribute('Base_Prix_TTC');

		document.getElementById("oot-pourcentagePV").disabled = false;
		document.getElementById("oot-prixHT").disabled = false;
		document.getElementById("oot-prixTTC").disabled = false;
		document.getElementById("oot-tauxMarque").disabled = false;
		document.getElementById("oot-tauxMarge").disabled = false;
		document.getElementById("oot-dateFin").disabled = false;

		oot_arrondiHT = contenu.getAttribute('Arrondi_HT');
		oot_arrondiTTC = contenu.getAttribute('Arrondi_TTC');

	} catch (e) {
		recup_erreur(e);
	}
}


function oot_calculerTarif(origine) {
  try {

		var nfHT = new Arrondi(oot_arrondiHT);
		var nfTTC = new Arrondi(oot_arrondiTTC);
		var nf6 = new NumberFormat("0.######", false);
		var nf4 = new NumberFormat("0.####", false);

		var pr = parseFloat(document.getElementById('oot-prixRevient').value);
		var tva = parseFloat(document.getElementById('oot-tauxTVA').value)/100 + 1;
		var baseHT = parseFloat(document.getElementById('oot-basePrixHT').value);

		if (origine=="h" && !isEmpty(document.getElementById('oot-prixHT').value)) {
			var pvht = parseFloat(document.getElementById('oot-prixHT').value);
			document.getElementById('oot-pourcentagePV').value = (baseHT>0?nf4.format((pvht-baseHT)/baseHT*100):"");
			document.getElementById('oot-prixTTC').value = nfTTC.round(pvht * tva);
			document.getElementById('oot-tauxMarque').value = (pvht>0 && pr>0?nf6.format((pvht-pr)/pvht * 100):"");
			document.getElementById('oot-tauxMarge').value = (pr>0?nf4.format((pvht-pr)/pr * 100):"");
		}
		else if (origine=="c" && !isEmpty(document.getElementById('oot-pourcentagePV').value)) {
			var pourcPV = parseFloat(document.getElementById('oot-pourcentagePV').value);
			var pvht = nfHT.round(baseHT * (1+pourcPV/100));
			document.getElementById('oot-prixHT').value = nfHT.round(pvht);
			document.getElementById('oot-prixTTC').value = nfTTC.round(pvht * tva);
			document.getElementById('oot-tauxMarque').value = (pvht>0 && pr>0?nf6.format((pvht-pr)/pvht * 100):"");
			document.getElementById('oot-tauxMarge').value = (pr>0?nf4.format((pvht-pr)/pr * 100):"");
		}
		else if (origine=="t" && !isEmpty(document.getElementById('oot-prixTTC').value)) {
			var pvht = nfHT.round(parseFloat(document.getElementById('oot-prixTTC').value) / tva);
			document.getElementById('oot-prixHT').value = nfHT.round(pvht);
			document.getElementById('oot-pourcentagePV').value = (baseHT>0?nf4.format((pvht-baseHT)/baseHT*100):"");
			document.getElementById('oot-tauxMarque').value = (pvht>0 && pr>0?nf6.format((pvht-pr)/pvht * 100):"");
			document.getElementById('oot-tauxMarge').value = (pr>0?nf4.format((pvht-pr)/pr * 100):"");
		}
		else if (origine=="g" && !isEmpty(document.getElementById('oot-tauxMarge').value)) {
			var pvht = nfHT.round(pr * (1 + parseFloat(document.getElementById('oot-tauxMarge').value)/100));
			document.getElementById('oot-prixHT').value = nfHT.round(pvht);
			document.getElementById('oot-pourcentagePV').value = (baseHT>0?nf4.format((pvht-baseHT)/baseHT*100):"");
			document.getElementById('oot-prixTTC').value = nfTTC.round(pvht * tva);
			document.getElementById('oot-tauxMarque').value = (pvht>0 && pr>0?nf6.format((pvht-pr)/pvht * 100):"");
		}
		else if (!isEmpty(document.getElementById('oot-tauxMarque').value)) {
			if (parseFloat(document.getElementById('oot-tauxMarque').value)>=100) {
				showWarning("Le taux de marque doit \u00EAtre inf\u00E9rieur \u00E0 100 % !");
			}
			else {
				var pvht = nfHT.round(pr / (1 - parseFloat(document.getElementById('oot-tauxMarque').value)/100));
				document.getElementById('oot-prixHT').value = nfHT.round(pvht);
				document.getElementById('oot-pourcentagePV').value = (baseHT>0?nf4.format((pvht-baseHT)/baseHT*100):"");
				document.getElementById('oot-prixTTC').value = nfTTC.round(pvht * tva);
				document.getElementById('oot-tauxMarge').value = (pr>0?nf4.format((pvht-pr)/pr * 100):"");
			}
		}
		else {
			document.getElementById('oot-tauxMarge').value = "";
			document.getElementById('oot-prixHT').value = "";
			document.getElementById('oot-pourcentagePV').value = "";
			document.getElementById('oot-prixTTC').value = "";
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oot_traitementLot() {
	try {

		var url = "chrome://opensi/content/facturation/user/clients/popup-tarifsSpecifiques.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', oot_retourTraitementLot, ofc_clientId, oot_arrondiHT, oot_arrondiTTC);

	}	catch(e) {
		recup_erreur(e);
	}
}


function oot_retourTraitementLot() {
	try {

		oot_aPrixClient.initTree();
		oot_nouveauPrixClient();

	}	catch(e) {
		recup_erreur(e);
	}
}


function oot_editionPDF() {
	try {

		document.getElementById("ofc-pdfClient").setAttribute("src", "");

		var qEditionPdf = new QueryHttp("Facturation/Clients/pdfPrixClient.tmpl");
		qEditionPdf.setParam("Client_Id", ofc_clientId);
		var result = qEditionPdf.execute();

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}
		else {
			var page = getDirPdf() + result.responseXML.documentElement.getAttribute('FichierPDF');
			document.getElementById("bRetourClient").collapsed = false;
			document.getElementById("ofc-deckClient").selectedIndex = 1;
			document.getElementById('ofc-pdfClient').setAttribute("src", page);
		}

	}	catch(e) {
		recup_erreur(e);
	}
}


function oot_editionCatalogueCSV() {
	try {

		document.getElementById('oot-bCatCsv').disabled = true;
		document.getElementById('pmbox').collapsed = false;
		document.getElementById('pm').setAttribute('mode', 'undetermined');

		var qEditionCsv = new QueryHttp("Facturation/Clients/csvCatalogueClient.tmpl");
		qEditionCsv.setParam("Client_Id", ofc_clientId);

		qEditionCsv.execute(oot_endEditionCatalogueCSV);

	} catch (e) {
		recup_erreur(e);
	}
}


function oot_endEditionCatalogueCSV(result) {
	try {

		document.getElementById('pm').setAttribute('mode', 'none');
		document.getElementById('pmbox').collapsed = true;
		document.getElementById('oot-bCatCsv').disabled = false;

		var fichier = result.responseXML.documentElement.getAttribute('FichierCSV');

		var file = fileChooser("save", fichier);
		if (file!=null) {
			downloadFile(getDirBuffer()+ fichier, file);
		}

	} catch (e) {
		recup_erreur(e);
	}
}
