/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/verif.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/arbres.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/lib_tva.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/formatter.js");


var aCodesTVA = new Arbre('ComboListe/combo-tauxTVA.tmpl', 'codeTVA');
var aModesReglements = new Arbre('ComboListe/combo-modesReglement.tmpl', 'modeReglement');

var commandeId;
var totalTTC;
var totalAcompte;
var montantMaxAcompte;
var chargerModeReg = "";
var codePays;

var nf = new NumberFormat("0.00", false);



function init() {
  try {

		commandeId = ParamValeur("Commande_Id");

		var qLoad = new QueryHttp("Facturation/Commandes/loadCommandeFournisseur.tmpl");
		qLoad.setParam("Commande_Id", commandeId);
		var result = qLoad.execute();
		document.getElementById('libelle').value = "Acompte sur commande fournisseur N\u00B0 " + result.responseXML.documentElement.getAttribute('Numero');
		totalTTC = parseFloat(result.responseXML.documentElement.getAttribute("Total_TTC"));
		totalAcompte = parseFloat(result.responseXML.documentElement.getAttribute("Acompte"));
		montantMaxAcompte = nf.format(totalTTC-totalAcompte);

		var fournisseurId = ParamValeur("Fournisseur_Id");
		if (fournisseurId!="") {
			var qGetFournisseur = new QueryHttp("Facturation/Fournisseurs/loadFicheFournisseur.tmpl");
			qGetFournisseur.setParam("Fournisseur_Id", fournisseurId);
			var result = qGetFournisseur.execute();
			chargerModeReg = result.responseXML.documentElement.getAttribute("Mode_Reg_Id");
		}

		codePays = ParamValeur("Code_Pays");

		aCodesTVA.setParam("Code_Pays", codePays);
    aCodesTVA.initTree(selectTVA);

  } catch (e) {
    recup_erreur(e);
  }
}


function selectTVA() {
  try {

    document.getElementById('codeTVA').value = (codePays!="FR"?getCodeTvaZero(codePays):getCodeTvaNormalFrance());
    aModesReglements.setParam("Selection", chargerModeReg);
    aModesReglements.initTree(initModeReglement);

  } catch (e) {
    recup_erreur(e);
  }
}


function initModeReglement() {
	try {

		document.getElementById('modeReglement').value = chargerModeReg;

	} catch (e) {
		recup_erreur(e);
	}
}


function pressOnExoneration() {
	try {

		var exoneration = document.getElementById('chkExonerationTVA').checked;
		document.getElementById('codeTVA').value = (codePays!="FR" || exoneration?getCodeTvaZero(codePays):getCodeTvaNormalFrance());
		calculerMontantTTC();
		document.getElementById('rowCodeTVA').collapsed = exoneration;
		document.getElementById('rowMontantTTC').collapsed = exoneration;
		document.getElementById('lblMontantHT').value = (exoneration?"* Montant :":"* Montant HT :");

	} catch (e) {
		recup_erreur(e);
	}
}


function calculerMontantHT() {
	try {

		var tauxTVA = parseFloat(document.getElementById('codeTVA').getAttribute("label"));
		var montantTTC = document.getElementById('montantTTC').value;
		if (!isEmpty(montantTTC) && !isNaN(montantTTC)) {
			var montantHT = parseFloat(montantTTC)/(1 + tauxTVA/100);
			document.getElementById('montantHT').value = nf.format(montantHT);
		}
	} catch (e) {
		recup_erreur(e);
	}
}


function calculerMontantTTC() {
	try {

		var tauxTVA = parseFloat(document.getElementById('codeTVA').getAttribute("label"));
		var montantHT = document.getElementById('montantHT').value;
		if (!isEmpty(montantHT) && !isNaN(montantHT)) {
			var montantTTC = parseFloat(montantHT)*(1 + tauxTVA/100);
			document.getElementById('montantTTC').value = nf.format(montantTTC);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function valider() {
	try {

  	var numAcompte = document.getElementById('numAcompte').value;
  	var codeTVA = document.getElementById('codeTVA').value;
		var montantHT = document.getElementById('montantHT').value;
		var montantTTC = document.getElementById('montantTTC').value;
		var modeReglement = document.getElementById('modeReglement').value;
		var libelle = document.getElementById('libelle').value;
		var commentaires = document.getElementById('commentaires').value;

		if (isEmpty(numAcompte)) { showWarning("N\u00B0 Acompte manquant"); }
		else if (isEmpty(montantHT) || !isPositive(montantHT) || !checkNumber(montantHT,14,2)) { showWarning("Le montant HT est incorrect !"); }
		else if (isEmpty(montantTTC) || !isPositive(montantTTC) || !checkNumber(montantTTC,14,2)) { showWarning("Le montant TTC est incorrect !"); }
		else if (parseFloat(montantTTC)>montantMaxAcompte) { showWarning("Le montant de l'acompte ne peut pas exc\u00E9der "+ montantMaxAcompte +" !"); }
		else if (isEmpty(modeReglement)) { showWarning("Veuillez choisir un mode de r\u00E8glement !"); }
		else if (isEmpty(libelle)) { showWarning("Veuillez saisir un libell\u00E9 !"); }
		else if (window.confirm("Confirmez-vous la g\u00E9n\u00E9ration de la facture d'acompte ?")) {
	  	var qCreate = new QueryHttp("Facturation/Commandes/createAcompteFournisseur.tmpl");
	  	qCreate.setParam("Commande_Id", commandeId);
	  	qCreate.setParam("Num_Acompte", numAcompte);
	  	qCreate.setParam("Code_TVA", codeTVA);
	  	qCreate.setParam("Total_HT", montantHT);
	  	qCreate.setParam("Total_TTC", montantTTC);
	  	qCreate.setParam("Mode_Reg_Id", modeReglement);
	  	qCreate.setParam("Libelle", libelle);
	  	qCreate.setParam("Commentaires_Fin", commentaires);
	  	qCreate.execute();

			window.arguments[0]();
			window.close();
		}

	} catch (e) {
    recup_erreur(e);
  }
}
