/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

jsLoader.loadSubScript("chrome://opensi/content/libs/arbres.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/verif.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/formatter.js");


var aCommandes = new Arbre("Facturation/Commandes/combo-commandesTLC.tmpl", "commande");
var aArticles = new Arbre("Facturation/Commandes/list-ligneCommandeTLC.tmpl", "listeArticles");

var nf = new NumberFormat("0.###", false);
var commandeId;



function init() {
	try {

  	commandeId = ParamValeur("Commande_Id");

		var aFournisseurs = new Arbre("Facturation/Commandes/combo-fournisseursTLC.tmpl", "fournisseurId");
  	aFournisseurs.setParam("Commande_Id", commandeId);
  	aFournisseurs.initTree(initFournisseur);

	} catch (e) {
		recup_erreur(e);
	}
}


function initFournisseur() {
	try {

    document.getElementById('fournisseurId').selectedIndex = 0;
    pressOnFournisseur();

	} catch (e) {
    recup_erreur(e);
  }
}


function toutCocher(b) {
	try {

		for (var i=0; i<aArticles.nbLignes(); i++) {
			aArticles.setCellValue(i, "colSelArticle", b);
		}

		checkValidationPossible();

	} catch (e) {
		recup_erreur(e);
	}
}


function pressOnFournisseur() {
	try {

		document.getElementById('bValider').disabled = true;

		if (document.getElementById('fournisseurId').selectedIndex != 0) {
			var fournisseurId = document.getElementById('fournisseurId').value;
			aArticles.setParam("Fournisseur_Id", fournisseurId);
			aArticles.setParam("Commande_Id", commandeId);
			aArticles.initTree(initListeArticles);
		}
		else {
			aArticles.deleteTree();
			aCommandes.deleteTree();
			initCommande();
		}

		document.getElementById('quantite').value = "";
		document.getElementById('quantite').disabled = true;
		document.getElementById('bValiderLigne').disabled = true;

	} catch (e) {
    recup_erreur(e);
  }
}


function initListeArticles() {
	try {

		checkValidationPossible();

		var fournisseurId = document.getElementById('fournisseurId').value;
		aCommandes.setParam("Fournisseur_Id", fournisseurId);
		aCommandes.setParam("Commande_Id", commandeId);
		aCommandes.initTree(initCommande);

	} catch (e) {
		recup_erreur(e);
	}
}


function initCommande() {
	try {

    document.getElementById('commande').selectedIndex = 0;

	} catch (e) {
    recup_erreur(e);
  }
}


function selectOnListeArticles() {
	try {

		if (aArticles.isSelected()) {
			document.getElementById("quantite").value = aArticles.getSelectedCellText("colQteTrans");
			document.getElementById('quantite').disabled = false;
			document.getElementById('bValiderLigne').disabled = false;
			setTimeout("document.getElementById('quantite').select()", 0);
		}
		else {
			document.getElementById('quantite').value = "";
			document.getElementById('quantite').disabled = true;
			document.getElementById('bValiderLigne').disabled = true;
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function clickOnListeArticles() {
	try {

		checkValidationPossible();

	} catch (e) {
		recup_erreur(e);
	}
}


function pressOnQuantite(ev) {
	try {

		if (ev.keyCode==13) {
			validerLigne();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function validerLigne() {
	try {

		if (aArticles.isSelected()) {
			var nouvelleQte = document.getElementById('quantite').value;

			if (isEmpty(nouvelleQte) || !isPositiveOrNull(nouvelleQte)) {
				showWarning("La quantit\u00E9 saisie est incorrecte !");
			}
			else {

				nouvelleQte = parseFloat(nouvelleQte);
				var qteInitiale = parseFloat(aArticles.getSelectedCellText("colQteInit"));

				if (nouvelleQte>qteInitiale) {
					showWarning("La quantit\u00E9 \u00E0 transf\u00E9rer doit \u00EAtre inf\u00E9rieure ou \u00E9gale \u00E0 la quantit\u00E9 de la ligne !");
				}
				else {

					aArticles.setSelectedCellText("colQteTrans", nf.format(nouvelleQte));
					aArticles.setSelectedCellValue("colSelArticle", (nouvelleQte>0));

					document.getElementById('quantite').value = "";
					document.getElementById('quantite').disabled = true;
					document.getElementById('bValiderLigne').disabled = true;

					checkValidationPossible();
				}
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function checkValidationPossible() {
	try {

		var existeCoche = false;
		var i = 0;

		while (i<aArticles.nbLignes() && !existeCoche) {
			if (aArticles.getCellValue(i, "colSelArticle")=="true" && parseFloat(aArticles.getCellText(i, "colQteTrans"))>0) {
				existeCoche = true;
			}
			i++;
		}

		document.getElementById('bValider').disabled = (!existeCoche);

	} catch (e) {
		recup_erreur(e);
	}
}


function valider() {
  try {

		if (document.getElementById("fournisseurId").selectedIndex==0) {
			showWarning("Veuillez choisir un fournisseur");
		}
  	else if (document.getElementById("commande").selectedIndex==0) {
			showWarning("Veuillez choisir une commande de destination");
		}
  	else {
	  	document.getElementById('bValider').disabled = true;

			var nbCoche = 0;
			var listLigneId = "";

			for (var i=0; i<aArticles.nbLignes(); i++) {
				if (aArticles.getCellValue(i, "colSelArticle")=="true") {
					listLigneId += (nbCoche>0?",":"") + aArticles.getCellText(i, "colLigneId") +";"+ aArticles.getCellText(i, "colQteTrans");
					nbCoche++;
				}
			}

			if (nbCoche==0) {
				showWarning("Veuillez cocher au moins un article !");
				document.getElementById('bValider').disabled = false;
			}
			else {
				var qToggle = new QueryHttp("Facturation/Commandes/toggleMultiLigneCF.tmpl");
				qToggle.setParam("Commande_Id_Source", commandeId);
				qToggle.setParam("Commande_Id_Dest", document.getElementById("commande").value);
				qToggle.setParam("Fournisseur_Id_Dest", document.getElementById("fournisseurId").value);
				qToggle.setParam("Liste_Articles", listLigneId);
				qToggle.execute();

				window.arguments[0]();
				window.close();
			}
  	}

  } catch (e) {
    recup_erreur(e);
  }
}

