/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

/*
	Arguments du popup :
		- 0 : Fonction de retour
		- 1 : Identifiant de la ligne de commande
*/

jsLoader.loadSubScript("chrome://opensi/content/libs/arbres.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/verif.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/formatter.js");


var aCommandes = new Arbre("Facturation/Commandes/combo-commandesTLC.tmpl", "Commande");

var commandeId;
var ligneId;

var nf = new NumberFormat("0.###", false);



function init() {
  try {

		ligneId = window.arguments[1];

  	var qLoad = new QueryHttp("Facturation/Commandes/loadLigneCommandeFournisseur.tmpl");
  	qLoad.setParam("Ligne_Id", ligneId);
  	var result = qLoad.execute();
		var contenu = result.responseXML.documentElement;
		document.getElementById('Reference').value = contenu.getAttribute('Reference');
		document.getElementById('lblDesignation').value = contenu.getAttribute('Designation');
		document.getElementById('Quantite').value = nf.format(contenu.getAttribute('Quantite'));
		commandeId = contenu.getAttribute('Commande_Id');

		var aFournisseur = new Arbre("Facturation/Commandes/combo-fournisseursTLC.tmpl", "Fournisseur_Id");
    aFournisseur.setParam("Commande_Id", commandeId);
    aFournisseur.setParam("Article_Id", contenu.getAttribute('Article_Id'));
    aFournisseur.initTree(initFournisseur);

	} catch (e) {
    recup_erreur(e);
  }
}


function initFournisseur() {
	try {

    document.getElementById('Fournisseur_Id').selectedIndex = 0;
    initCommande();

	} catch (e) {
    recup_erreur(e);
  }
}


function initCommande() {
	try {

		if (document.getElementById('Fournisseur_Id').selectedIndex != 0) {
			aCommandes.setParam("Fournisseur_Id", document.getElementById('Fournisseur_Id').value);
			aCommandes.setParam("Commande_Id", commandeId);
			aCommandes.initTree(initCommande2);
		}
		else {
			aCommandes.deleteTree();
			initCommande2();
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function initCommande2() {
	try {

    document.getElementById('Commande').selectedIndex = 0;

    if (document.getElementById('Fournisseur_Id').selectedIndex>0 && !isEmpty(document.getElementById('Fournisseur_Id').value)) {
    	var qArticle = new QueryHttp("Facturation/Stocks/getStockDispoFournisseur.tmpl");
    	qArticle.setParam("Fournisseur_Id", document.getElementById('Fournisseur_Id').value);
    	qArticle.setParam("Article_Id", document.getElementById('Reference').value);
    	var result = qArticle.execute();
    	document.getElementById('qteDispo').value = nf.format(result.responseXML.documentElement.getAttribute("Qte_Stock"));
    }
		else {
    	document.getElementById('qteDispo').value = "0";
    }

	} catch (e) {
    recup_erreur(e);
  }
}


function valider() {
  try {

  	if (document.getElementById("Fournisseur_Id").selectedIndex==0) {
			showWarning("Veuillez choisir un fournisseur !");
		}
  	else if (document.getElementById("Commande").selectedIndex==0) { showWarning("Veuillez choisir une commande de destination !"); }
  	else {
	  	var quantite = document.getElementById("Quantite").value;

			if (document.getElementById('Fournisseur_Id').selectedIndex == 0) { showWarning("Veuillez choisir un fournisseur !"); }
			else if (!checkQte(quantite)) { showWarning("Quantit\u00E9 incorrecte !");	}
			else {
				var qToggle = new QueryHttp("Facturation/Commandes/toggleMonoLigneCF.tmpl");
				qToggle.setParam("Ligne_Id_Source", ligneId);
				qToggle.setParam("Quantite", quantite);
				qToggle.setParam("Commande_Id_Source", commandeId);
				qToggle.setParam("Commande_Id_Dest", document.getElementById("Commande").value);
				qToggle.setParam("Fournisseur_Id_Dest", document.getElementById("Fournisseur_Id").value);
				qToggle.execute();
				window.arguments[0]();
				window.close();
			}
  	}

  } catch (e) {
    recup_erreur(e);
  }
}

