/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

/*
	Arguments du popup :
		- 0 : Type document
		- 1 : Liste id des lignes  modifier
		- 2 : Fonction de retour pour les factures client
*/

jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/verif.js");


var typeDoc;
var listLigneId;
var tmpl;
var compLibelle;
var typeRistourne = 'P';



function init() {
  try {

		typeDoc = window.arguments[0];
		listLigneId = window.arguments[1];

		if (typeDoc=="CC") {
			tmpl = "Facturation/Affaires/updateRistourneLigneCC.tmpl";
			compLibelle = "de la commande";
		}
		else if (typeDoc=="DC") {
			tmpl = "Facturation/Devis/updateRistourneLigneDC.tmpl";
			compLibelle = "du devis";
		}
		else if (typeDoc=="FC") {
			tmpl = "Facturation/FacturesVente/updateRistourneLigneFC.tmpl";
			compLibelle = "de la facture";
		}
		else if (typeDoc=="AC") {
			tmpl = "Facturation/Avoirs/updateRistourneLigneAC.tmpl";
			compLibelle = "de l'avoir";
		}
		else if (typeDoc=="CF") {
			tmpl = "Facturation/Commandes/updateRistourneLigneCF.tmpl";
			compLibelle = "de la commande";
		}
		else if (typeDoc=="FF") {
			tmpl = "Facturation/Factu_Fournisseur/updateRistourneLigneFF.tmpl";
			compLibelle = "de la facture";
		}
		else if (typeDoc=="AF") {
			tmpl = "Facturation/Avoirs_Fournisseur/updateRistourneLigneAF.tmpl";
			compLibelle = "de l'avoir";
		}

		document.getElementById('titre').value = "s\u00E9lectionn\u00E9es "+ compLibelle;

		document.getElementById('ristourne').focus();

  } catch (e) {
    recup_erreur(e);
  }
}


function enregistrerRistourne() {
  try {

  	var ristourne = document.getElementById('ristourne').value;

		if (isEmpty(ristourne) || (typeRistourne=='P'?!isTaux(ristourne):!isPositiveOrNull(ristourne) || !checkNumber(ristourne,9,2))) {
			showWarning("Ristourne incorrecte");
		}
		else {
  		var qUpdate = new QueryHttp(tmpl);
			qUpdate.setParam("List_Ligne_Id", listLigneId);
			qUpdate.setParam("Ristourne", ristourne);
			qUpdate.setParam("Type_Ristourne", typeRistourne);

			var result = qUpdate.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				var nbNonApp = parseIntBis(result.responseXML.documentElement.getAttribute('Nb_Non_App'));

				if (nbNonApp>0) {
					showWarning("Attention, la ristourne n'a pas pu \u00EAtre appliqu\u00E9e sur "+ nbNonApp +" lignes "+ compLibelle);
				}

				if (typeDoc=="FC" || typeDoc=="FF") {
					var contenu = result.responseXML.documentElement;
  				var bloquerEcheance = parseFloat(contenu.getAttribute('Net_A_Payer'))==0;
    			var echModifiable = contenu.getAttribute('Ech_Modifiable')=="true";
					window.arguments[2](bloquerEcheance, echModifiable);
				}
			}

    	window.close();
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function switchRistourne() {
	try {

		if (typeRistourne=='P') {
			document.getElementById('bRistourne').setAttribute("class", "bIcoEuro");
			typeRistourne = 'M';
		}
		else {
			document.getElementById('bRistourne').setAttribute("class", "bIcoPourcentage");
			typeRistourne = 'P';
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function pressOnRistourne(ev) {
	try {

		if (ev.keyCode==13) {
			enregistrerRistourne();
		}

	} catch (e) {
    recup_erreur(e);
  }
}
