/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

jsLoader.loadSubScript("chrome://opensi/content/libs/verif.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/arbres.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");

var currentContact=-1;
var fournisseurId;
var adresseContact = "";

var aContacts = new Arbre("Facturation/Fournisseurs/list-contactFournisseur.tmpl", "tree-contacts");


function init() {
  try {

		fournisseurId = ParamValeur("Fournisseur_Id");
		aContacts.setParam("Fournisseur_Id", ParamValeur("Fournisseur_Id"));
		aContacts.initTree();
		nouveauContact();

  } catch (e) {
    recup_erreur(e);
  }
}


function nouveauContact() {
	try {

		aContacts.clearSelection();

		currentContact=-1;

	  document.getElementById('Civilite').value = "1";
		document.getElementById('Nom').value = "";
		document.getElementById('Prenom').value = "";
		document.getElementById('Fonction').value = "";
		document.getElementById('denomination').value = "";
		document.getElementById('Adresse_1').value = "";
		document.getElementById('Adresse_2').value = "";
		document.getElementById('Adresse_3').value = "";
		document.getElementById('Code_Postal').value = "";
		document.getElementById('Ville').value = "";
		document.getElementById('Pays').value = "";
		document.getElementById('tel1').value = "";
		document.getElementById('tel2').value = "";
		document.getElementById('Fax').value = "";
		document.getElementById('Email').value = "";
		document.getElementById('Relation').value = "0";
		document.getElementById('Principal').checked = false;
		document.getElementById('Principal').disabled = false;
		document.getElementById('Defaut').checked = false;
		document.getElementById('Defaut').disabled = false;
		document.getElementById('Infos').value = "";
		adresseContact = "";

		document.getElementById('bNouveauContact').collapsed = true;
		document.getElementById('bSupprimerContact').collapsed = true;
		document.getElementById('bModifierContact').collapsed = true;
		document.getElementById('bCreerContact').collapsed = false;

	} catch (e) {
    recup_erreur(e);
  }
}


function changergroupbox(check) {
	try {

		window.resizeTo(1000,check?800:400);
		document.getElementById('Group_Contact').collapsed=!check;

	} catch (e) {
    recup_erreur(e);
  }
}


function chargerContact() {
	try {

		if (aContacts.isSelected()) {

			currentContact = aContacts.getSelectedCellValue('ColCiv');
			document.getElementById('Nom').value = aContacts.getSelectedCellText('ColNom');
			document.getElementById('Prenom').value = aContacts.getSelectedCellText('ColPrenom');
			document.getElementById('Fonction').value = aContacts.getSelectedCellText('ColFonction');
			document.getElementById('Relation').value = aContacts.getSelectedCellText('ColRelation');
			document.getElementById('Infos').value = aContacts.getSelectedCellText('ColInfos');
			document.getElementById('denomination').value = aContacts.getSelectedCellText('ColDenomination');
			document.getElementById('Adresse_1').value = aContacts.getSelectedCellText('ColAdresse_1');
			document.getElementById('Adresse_2').value = aContacts.getSelectedCellText('ColAdresse_2');
			document.getElementById('Adresse_3').value = aContacts.getSelectedCellText('ColAdresse_3');
			document.getElementById('Code_Postal').value = aContacts.getSelectedCellText('ColCode_Postal');
			document.getElementById('Ville').value = aContacts.getSelectedCellText('ColVille');
			document.getElementById('Pays').value = aContacts.getSelectedCellText('ColPays');
			document.getElementById('tel1').value = aContacts.getSelectedCellText('ColTel1');
			document.getElementById('tel2').value = aContacts.getSelectedCellText('ColTel2');
			document.getElementById('Fax').value = aContacts.getSelectedCellText('ColFax');
			document.getElementById('Email').value = aContacts.getSelectedCellText('ColEmail');
			document.getElementById('Principal').checked = (aContacts.getSelectedCellText('ColPrincipal')=="true");
			document.getElementById('Defaut').checked = (aContacts.getSelectedCellText('ColDefaut')=="true");
			document.getElementById("Civilite").value = aContacts.getSelectedCellText('ColNum_Civ');
			adresseContact = aContacts.getSelectedCellText('ColAdresse_Id');
			document.getElementById('Principal').disabled = document.getElementById('Principal').checked;
			document.getElementById('Defaut').disabled = document.getElementById('Defaut').checked;

			document.getElementById('bSupprimerContact').collapsed = false;
			document.getElementById('bModifierContact').collapsed = false;
			document.getElementById('bNouveauContact').collapsed = false;
			document.getElementById('bCreerContact').collapsed = true;
  	}

 	} catch (e) {
    recup_erreur(e);
  }
}


function supprimerContact() {
	try {

		var prenom = document.getElementById('Prenom').value;
		var nom = document.getElementById('Nom').value;

		if (window.confirm("Confirmez-vous la suppression du contact '"+ prenom +" "+ nom +"' ?")) {

			var qSupContact = new QueryHttp("Facturation/Fournisseurs/deleteContactFournisseur.tmpl");
			qSupContact.setParam('Contact_Id', currentContact);
			var result = qSupContact.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				document.getElementById('bSupprimerContact').collapsed = true;
				document.getElementById('bModifierContact').collapsed = true;
				document.getElementById('bCreerContact').collapsed = false;
				document.getElementById('bNouveauContact').collapsed = true;
				aContacts.initTree();
				nouveauContact();
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function enregistrerContact(mode) {
	try {

    var civilite = document.getElementById('Civilite').value;
		var nom = document.getElementById('Nom').value;
		var prenom = document.getElementById('Prenom').value;
		var fonction = document.getElementById('Fonction').value;
		var relation = document.getElementById('Relation').value;
		var infos = document.getElementById('Infos').value;
		var tel1 = document.getElementById('tel1').value;
		var tel2 = document.getElementById('tel2').value;
		var fax = document.getElementById('Fax').value;
		var email = document.getElementById('Email').value;
		var principal = document.getElementById('Principal').checked;
		var defaut = document.getElementById('Defaut').checked;

		if (isEmpty(nom)) {
			showWarning("Veuillez sp\u00E9cifier le nom du contact !");
		}
		else if (!isEmpty(tel1) && !isPhone(tel1)) { showWarning("T\u00E9l\u00E9phone 1 invalide"); }
		else if (!isEmpty(tel2) && !isPhone(tel2)) { showWarning("T\u00E9l\u00E9phone 2 invalide"); }
		else if (!isEmpty(fax) && !isPhone(fax)) { showWarning("Le num\u00E9ro de fax est invalide !"); }
		else if (!isEmpty(email) && !isEmail(email)) { showWarning("L'adresse e-mail est invalide !"); }
		else {

			var qSaveContact;

			if (mode=="C") {
				qSaveContact = new QueryHttp("Facturation/Fournisseurs/createContactFournisseur.tmpl");
			}
			else {
				qSaveContact = new QueryHttp("Facturation/Fournisseurs/updateContactFournisseur.tmpl");
				qSaveContact.setParam('Contact_Id', currentContact);
			}

			qSaveContact.setParam('Fournisseur_Id', fournisseurId);
			qSaveContact.setParam('Civilite', civilite);
			qSaveContact.setParam('Nom', nom);
			qSaveContact.setParam('Prenom', prenom);
			qSaveContact.setParam('Fonction', fonction);
			qSaveContact.setParam('Relation', relation);
			qSaveContact.setParam('Infos', infos);
			qSaveContact.setParam('Tel_1', tel1);
			qSaveContact.setParam('Tel_2', tel2);
			qSaveContact.setParam('Fax', fax);
			qSaveContact.setParam('Email', email);
			qSaveContact.setParam('Defaut', defaut);
			qSaveContact.setParam('Adresse_Id', adresseContact);
			qSaveContact.setParam('Principal', principal);

			var result = qSaveContact.execute();

			document.getElementById('Principal').disabled = principal;
			document.getElementById('Defaut').disabled = defaut;

			if (mode=="C") {
				currentContact = result.responseXML.documentElement.getAttribute('Contact_Id');

				document.getElementById('bCreerContact').collapsed = true;
				document.getElementById('bModifierContact').collapsed = false;
				document.getElementById('bNouveauContact').collapsed = false;
				document.getElementById('bSupprimerContact').collapsed = false;
			}

			aContacts.initTree(scrollToNum);
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function scrollToNum() {
	try {
		var tree = document.getElementById("tree-contacts");

		if (tree.view!=null && tree.view.rowCount>0 && currentContact>-1) {

			var i = 0;
			var trouve = false;

			while (!trouve && i<tree.view.rowCount) {
				if (parseIntBis(aContacts.getCellValue(i,'ColCiv'))==currentContact) {
					aContacts.ensureRowIsVisible(i);
					aContacts.select(i);
					trouve = true;
				}

				i++;
			}
			if (!trouve) aContacts.ensureRowIsVisible(tree.view.rowCount-1);
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function ouvrirInter() {
  try {

		if (currentContact!=-1) {

			var civ = aContacts.getSelectedCellText('ColNum_Civ');
			var nom = aContacts.getSelectedCellText('ColNom');
			var prenom = aContacts.getSelectedCellText('ColPrenom');
			var tel1 = aContacts.getSelectedCellText('ColTel1');
			var tel2 = aContacts.getSelectedCellText('ColTel2');
			var fax = aContacts.getSelectedCellText('ColFax');
			var email = aContacts.getSelectedCellText('ColEmail');

			window.arguments[0](civ, nom, prenom, tel1, tel2, fax, email);
    	window.close();
		}
		else {
			showWarning("Veuillez s\u00E9lectionner un contact !");
		}

  } catch (e) {
    recup_erreur(e);
  }
}


function pressOnTree(ev) {
  try {

    if (ev.keyCode==13) {
    	ouvrirInter();
    }

  } catch (e) {
    recup_erreur(e);
  }
}


function rechercherAdresse() {
  try {

		var url = "chrome://opensi/content/facturation/user/commun/popup-choixAdrCom.xul?"+ cookie() +"&Fournisseur_Id="+ fournisseurId;
    window.openDialog(url,'','chrome,modal,centerscreen', reporterAdresse);

	} catch (e) {
  	recup_erreur(e);
  }
}


function reporterAdresse(denomination, adr1, adr2, adr3, cp, ville, pays, code_pays, contact, depotId, adresseId) {
  try {

		document.getElementById("denomination").value = denomination;
		document.getElementById("Adresse_1").value = adr1;
		document.getElementById("Adresse_2").value = adr2;
		document.getElementById("Adresse_3").value = adr3;
		document.getElementById("Code_Postal").value = cp;
		document.getElementById("Ville").value = ville;
	  document.getElementById("Pays").value = pays;

		adresseContact = adresseId;

	} catch (e) {
  	recup_erreur(e);
  }
}

