/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

jsLoader.loadSubScript("chrome://opensi/content/libs/arbres.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/formatter.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/verif.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");


var aTarifs = new Arbre('Facturation/Articles/list-prixQuantite.tmpl', 'tarifs_qte');

var base_calcul;
var taux_tva;
var articleId;
var prixId;


function init() {
  try {

		var specRE = getConfig().isSpecREDS();

		articleId = window.arguments[1];

		var qGet = new QueryHttp("Facturation/Articles/getInfosTarifQuantite.tmpl");
		qGet.setParam("Article_Id", articleId);
		var result = qGet.execute();

    var contenu = result.responseXML.documentElement;

		document.getElementById('Prix_Revient').value = contenu.getAttribute('Prix_Revient');
		taux_tva = contenu.getAttribute('Taux_TVA');
		base_calcul = contenu.getAttribute('Base_Calcul')=="true";

		if (specRE) {
			document.getElementById('descrip1').value = contenu.getAttribute('Descrip_1');
			document.getElementById('descrip2').value = contenu.getAttribute('Descrip_2');

			document.getElementById("boxDispoStock").collapsed = false;
			var aDispoStock = new Arbre('Facturation/Articles/list-dispoStock.tmpl', 'listeDispoStock');
			aDispoStock.setParam("Article_Id", articleId);
			aDispoStock.initTree();
		}

		initModeTarifQte();
		switchMode();
		annulerLigne();

		aTarifs.setParam('Article_Id', articleId);
		if (base_calcul) {
			aTarifs.setParam('Prix_Achat', document.getElementById('Prix_Revient').value);
		}
		aTarifs.initTree();

  } catch (e) {
    recup_erreur(e);
  }
}


function ouvrirTarif() {
  try {

		if (aTarifs.isSelected()) {
			window.arguments[0](aTarifs.getSelectedCellText('colPrixId'));
			window.close();
		}

	} catch (e) {
    recup_erreur(e);
  }
}

function validerLigne() {
  try {

		var quantite = document.getElementById('Quantite_Ligne').value;
		var prix = document.getElementById('Prix_Ligne').value;
		var prix_ttc = document.getElementById('Prix_Ligne_TTC').value;
		var lib_ext = document.getElementById('Lib_Ext').value;
		var lib_int = document.getElementById('Lib_Int').value;
		var coeff = document.getElementById('Coeff_Ligne').value;
		var tauxMarque = document.getElementById('Taux_Marque_Ligne').value;
		var tauxMarge = document.getElementById('Taux_Marge_Ligne').value;

		if (isEmpty(prix) || !isPositiveOrNull(prix)) {
			showWarning("Prix HT incorrect !");
		}
		else if (isEmpty(prix_ttc) || !isPositiveOrNull(prix_ttc) || !checkDecimal(prix_ttc,4)) {
			showWarning("Prix TTC incorrect !");
		}
		else if (!checkQte(quantite)) {
			showWarning("Quantit\u00E9 incorrecte !");
		}
		else if (base_calcul && (!isEmpty(coeff) && (!isPositiveOrNull(coeff) || !checkDecimal(coeff,6)))) {
			showWarning("Coefficient incorrect !");
		}
		else if (base_calcul && (!isEmpty(tauxMarque) && (!checkDecimal(tauxMarque,6) || parseFloat(tauxMarque)>=100))) {
			showWarning("Taux de marque incorrect");
		}
		else if (base_calcul && (!isEmpty(tauxMarge) && !checkDecimal(tauxMarge,4))) {
			showWarning("Taux de marge incorrect");
		}
		else {
			var qSave;

			if (isEmpty(prixId)) {
				qSave = new QueryHttp("Facturation/Articles/createPrixQuantite.tmpl");
				qSave.setParam("Article_Id", articleId);
			}
			else {
				qSave = new QueryHttp("Facturation/Articles/updatePrixQuantite.tmpl");
				qSave.setParam("Prix_Id", prixId);
			}

			qSave.setParam("Quantite", quantite);
			qSave.setParam("Prix", prix);
			qSave.setParam("Lib_Ext", lib_ext);
			qSave.setParam("Lib_Int", lib_int);
			qSave.setParam("Coeff", coeff);
			qSave.setParam("Taux_Marque", tauxMarque);
			qSave.setParam("Taux_Marge", tauxMarge);
			qSave.setParam("Prix_TTC", prix_ttc);

			var result = qSave.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}

			aTarifs.initTree();
			annulerLigne();
		}

  } catch (e) {
  	recup_erreur(e);
	}
}


function switchMode() {
  try {

		var b = !document.getElementById('SwitchMode').checked;

		document.getElementById('boxBoutons').collapsed = b;
		document.getElementById('boxLigne').collapsed = b;
		document.getElementById('boxRevient').collapsed = b;

	} catch (e) {
  	recup_erreur(e);
	}
}


function initModeTarifQte() {
  try {

		document.getElementById('ColTauxMarque').collapsed = !base_calcul;
		document.getElementById('ColTauxMarge').collapsed = !base_calcul;
		document.getElementById('ColCoeff').collapsed = !base_calcul;
		document.getElementById('Taux_Marque_Ligne').collapsed = !base_calcul;
		document.getElementById('Taux_Marge_Ligne').collapsed = !base_calcul;
		document.getElementById('Coeff_Ligne').collapsed = !base_calcul;
		document.getElementById('Prix_Revient').collapsed = !base_calcul;
		document.getElementById('lblPrix_Revient').collapsed = !base_calcul;

	} catch (e) {
  	recup_erreur(e);
	}
}


function annulerLigne() {
  try {

		document.getElementById('Lib_Int').value = "";
		document.getElementById('Lib_Ext').value = "";
		document.getElementById('Quantite_Ligne').value = "";
		document.getElementById('Prix_Ligne').value = "";
		document.getElementById('Taux_Marque_Ligne').value = "";
		document.getElementById('Taux_Marge_Ligne').value = "";
		document.getElementById('Coeff_Ligne').value = "";
		document.getElementById('Prix_Ligne_TTC').value = "";
		prixId = "";
		document.getElementById('bSupprimer').disabled = true;

	} catch (e) {
  	recup_erreur(e);
	}
}


function calculerLigne(t) {
  try {

		var nf6 = new NumberFormat("0.######", false);
		var nf4 = new NumberFormat("0.####", false);
		var nf = new NumberFormat("0.00", false);

		var tva = parseFloat(taux_tva)/100 + 1;

		var pr = document.getElementById('Prix_Revient').value;

		if (t=="h") {
			var pvht = parseFloat(document.getElementById('Prix_Ligne').value);
			document.getElementById('Coeff_Ligne').value = (pr>0?nf6.format(pvht / pr):"");
			document.getElementById('Prix_Ligne_TTC').value = nf.format(pvht * tva);
			document.getElementById('Taux_Marque_Ligne').value = (pvht>0 && pr>0?nf6.format((pvht-pr)/pvht * 100):"");
			document.getElementById('Taux_Marge_Ligne').value = (pr>0?nf4.format((pvht-pr)/pr * 100):"");
		}
		else if (t=="c") {
			var pvht = parseFloat(document.getElementById('Coeff_Ligne').value) * pr;
			document.getElementById('Prix_Ligne').value = nf.format(pvht);
			document.getElementById('Prix_Ligne_TTC').value = nf.format(pvht * tva);
			document.getElementById('Taux_Marque_Ligne').value = (pvht>0 && pr>0?nf6.format((pvht-pr)/pvht * 100):"");
			document.getElementById('Taux_Marge_Ligne').value = (pr>0?nf4.format((pvht-pr)/pr * 100):"");
		}
		else if (t=="t") {
			var pvht = parseFloat(document.getElementById('Prix_Ligne_TTC').value) / tva;
			document.getElementById('Prix_Ligne').value = nf.format(pvht);
			document.getElementById('Coeff_Ligne').value = (pr>0?nf6.format(pvht / pr):"");
			document.getElementById('Taux_Marque_Ligne').value = (pvht>0 && pr>0?nf6.format((pvht-pr)/pvht * 100):"");
			document.getElementById('Taux_Marge_Ligne').value = (pr>0?nf4.format((pvht-pr)/pr * 100):"");
		}
		else if (t=="g") {
			var pvht = pr * (1 + parseFloat(document.getElementById('Taux_Marge_Ligne').value)/100);
			document.getElementById('Prix_Ligne').value = nf.format(pvht);
			document.getElementById('Coeff_Ligne').value = (pr>0?nf6.format(pvht / pr):"");
			document.getElementById('Prix_Ligne_TTC').value = nf.format(pvht * tva);
			document.getElementById('Taux_Marque_Ligne').value = (pvht>0 && pr>0?nf6.format((pvht-pr)/pvht * 100):"");
		}
		else if (t=="m") {
			if (parseFloat(document.getElementById('Taux_Marque_Ligne').value)>=100) {
				showWarning("Le taux de marque doit \u00EAtre inf\u00E9rieur \u00E0 100 % !");
			}
			else {
				var pvht = pr / (1 - parseFloat(document.getElementById('Taux_Marque_Ligne').value)/100);
				document.getElementById('Prix_Ligne').value = nf.format(pvht);
				document.getElementById('Coeff_Ligne').value = (pr>0?nf6.format(pvht / pr):"");
				document.getElementById('Prix_Ligne_TTC').value = nf.format(pvht * tva);
				document.getElementById('Taux_Marge_Ligne').value = (pr>0?nf4.format((pvht-pr)/pr * 100):"");
			}
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function reporterLigne() {
  try {

		if (aTarifs.isSelected()) {
			document.getElementById('Lib_Int').value = aTarifs.getSelectedCellText('ColLibInt');
			document.getElementById('Lib_Ext').value = aTarifs.getSelectedCellText('ColLibExt');
			document.getElementById('Quantite_Ligne').value = aTarifs.getSelectedCellText('ColQuantite');
			document.getElementById('Prix_Ligne').value = aTarifs.getSelectedCellText('ColHT');
			document.getElementById('Taux_Marque_Ligne').value = aTarifs.getSelectedCellText('ColTauxMarque');
			document.getElementById('Taux_Marge_Ligne').value = aTarifs.getSelectedCellText('ColTauxMarge');
			document.getElementById('Coeff_Ligne').value = aTarifs.getSelectedCellText('ColCoeff');
			document.getElementById('Prix_Ligne_TTC').value = aTarifs.getSelectedCellText('ColTTC');
			prixId = aTarifs.getSelectedCellText('colPrixId');
			document.getElementById('bSupprimer').disabled = false;
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function supprimerLigne() {
  try {

		if (window.confirm("Supprimer la ligne de tarif ?")) {

			var qDelete = new QueryHttp("Facturation/Articles/deletePrixQuantite.tmpl");
			qDelete.setParam("Prix_Id", prixId);
			var result = qDelete.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}

    	aTarifs.initTree();
			annulerLigne();
		}

	} catch (e) {
  	recup_erreur(e);
	}
}

