/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

/*
	Arguments du popup :
		- 0 : Type document
		- 1 : Identifiant document
		- 2 : Si true, mode lecture seule
*/

jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");


var typeDoc;
var docId;
var tmplSave;
var pDocId;



function init() {
  try {

		typeDoc = window.arguments[0];
		docId = window.arguments[1];
		var readOnly = window.arguments[2];

		document.getElementById('boxValider').collapsed = readOnly;
		document.getElementById('boxQuitter').collapsed = !readOnly;

		if (readOnly) {
			document.getElementById('Commentaires_Hid').setAttribute("readonly", true);
			document.getElementById('bQuitter').focus();
		}
		else {
			document.getElementById('Commentaires_Hid').focus();
		}

		var tmplLoad;

		if (typeDoc=="CC") {
			tmplLoad = "Facturation/Affaires/getCommentairesInternesCC.tmpl";
			tmplSave = "Facturation/Affaires/updateCommentairesInternesCC.tmpl";
			pDocId = "Commande_Id";
		}
		else if (typeDoc=="DC") {
			tmplLoad = "Facturation/Devis/getCommentairesInternesDC.tmpl";
			tmplSave = "Facturation/Devis/updateCommentairesInternesDC.tmpl";
			pDocId = "Devis_Id";
		}
		else if (typeDoc=="FC") {
			tmplLoad = "Facturation/FacturesVente/getCommentairesInternesFC.tmpl";
			tmplSave = "Facturation/FacturesVente/updateCommentairesInternesFC.tmpl";
			pDocId = "Facture_Id";
		}
		else if (typeDoc=="AC") {
			tmplLoad = "Facturation/Avoirs/getCommentairesInternesAC.tmpl";
			tmplSave = "Facturation/Avoirs/updateCommentairesInternesAC.tmpl";
			pDocId = "Avoir_Id";
		}
		else if (typeDoc=="RC") {
			tmplLoad = "Facturation/Affaires/getCommentairesInternesRC.tmpl";
			tmplSave = "Facturation/Affaires/updateCommentairesInternesRC.tmpl";
			pDocId = "Retour_Id";
		}
		else if (typeDoc=="TS") {
			tmplLoad = "Facturation/Transferts_Stocks/getCommentairesInternesTS.tmpl";
			tmplSave = "Facturation/Transferts_Stocks/updateCommentairesInternesTS.tmpl";
			pDocId = "Transfert_Id";
		}
		else if (typeDoc=="TE") {
			tmplLoad = "Facturation/Transferts_Emplacements/getCommentairesInternesTE.tmpl";
			tmplSave = "Facturation/Transferts_Emplacements/updateCommentairesInternesTE.tmpl";
			pDocId = "Transfert_Id";
		}
		else if (typeDoc=="CF") {
			tmplLoad = "Facturation/Commandes/getCommentairesInternesCF.tmpl";
			tmplSave = "Facturation/Commandes/updateCommentairesInternesCF.tmpl";
			pDocId = "Commande_Id";
		}
		else if (typeDoc=="FF") {
			tmplLoad = "Facturation/Factu_Fournisseur/getCommentairesInternesFF.tmpl";
			tmplSave = "Facturation/Factu_Fournisseur/updateCommentairesInternesFF.tmpl";
			pDocId = "Facture_Id";
		}
		else if (typeDoc=="AF") {
			tmplLoad = "Facturation/Avoirs_Fournisseur/getCommentairesInternesAF.tmpl";
			tmplSave = "Facturation/Avoirs_Fournisseur/updateCommentairesInternesAF.tmpl";
			pDocId = "Avoir_Id";
		}
		else if (typeDoc=="RF") {
			tmplLoad = "Facturation/Retours_Fournisseurs/getCommentairesInternesRF.tmpl";
			tmplSave = "Facturation/Retours_Fournisseurs/updateCommentairesInternesRF.tmpl";
			pDocId = "Retour_Id";
		}
		else if (typeDoc=="BR") {
			tmplLoad = "Facturation/Commandes/getCommentairesInternesBR.tmpl";
			tmplSave = "Facturation/Commandes/updateCommentairesInternesBR.tmpl";
			pDocId = "Bon_Id";
		}
		else if (typeDoc=="BRT") {
			tmplLoad = "Facturation/Transferts_Stocks/getCommentairesInternesBR.tmpl";
			tmplSave = "Facturation/Transferts_Stocks/updateCommentairesInternesBR.tmpl";
			pDocId = "Bon_Id";
		}
		else if (typeDoc=="BRR") {
			tmplLoad = "Facturation/Retours_Fournisseurs/getCommentairesInternesBR.tmpl";
			tmplSave = "Facturation/Retours_Fournisseurs/updateCommentairesInternesBR.tmpl";
			pDocId = "Bon_Id";
		}
		else if (typeDoc=="BLT") {
			tmplLoad = "Facturation/Transferts_Stocks/getCommentairesInternesBL.tmpl";
			tmplSave = "Facturation/Transferts_Stocks/updateCommentairesInternesBL.tmpl";
			pDocId = "Bon_Id";
		}
		else if (typeDoc=="BLR") {
			tmplLoad = "Facturation/Retours_Fournisseurs/getCommentairesInternesBL.tmpl";
			tmplSave = "Facturation/Retours_Fournisseurs/updateCommentairesInternesBL.tmpl";
			pDocId = "Bon_Id";
		}
		else if (typeDoc=="BL") {
			tmplLoad = "Facturation/Affaires/getCommentairesInternesBL.tmpl";
			tmplSave = "Facturation/Affaires/updateCommentairesInternesBL.tmpl";
			pDocId = "Bon_Id";
		}
		else if (typeDoc=="OL") {
			tmplLoad = "Facturation/Affaires/getCommentairesInternesBL.tmpl";
			tmplSave = "Facturation/Affaires/updateCommentairesInternesBL.tmpl";
			pDocId = "Bon_Id";
		}
		else if (typeDoc=="LF") {
			tmplLoad = "Facturation/Affaires/getCommentairesInternesBL.tmpl";
			tmplSave = "Facturation/Affaires/updateCommentairesInternesBL.tmpl";
			pDocId = "Bon_Id";
		}
		else if (typeDoc=="MA") {
			tmplLoad = "Facturation/Abonnements/getCommentairesInternesMA.tmpl";
			tmplSave = "Facturation/Abonnements/updateCommentairesInternesMA.tmpl";
			pDocId = "Modele_Id";
		}
		else if (typeDoc=="CA") {
			tmplLoad = "Facturation/Abonnements/getCommentairesInternesCA.tmpl";
			tmplSave = "Facturation/Abonnements/updateCommentairesInternesCA.tmpl";
			pDocId = "Contrat_Id";
		}

  	var qLoad = new QueryHttp(tmplLoad);
  	qLoad.setParam(pDocId, docId);
		var result = qLoad.execute();

		document.getElementById('Commentaires_Hid').value = result.responseXML.documentElement.getAttribute('Commentaires_Hid');

  } catch (e) {
    recup_erreur(e);
  }
}


function enregistrerCommentaires() {
  try {

  	var commentairesHid = document.getElementById('Commentaires_Hid').value;

  	var qSave = new QueryHttp(tmplSave);
		qSave.setParam(pDocId, docId);
		qSave.setParam("Commentaires_Hid", commentairesHid);

		var result = qSave.execute();

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}

		window.close();

	} catch (e) {
    recup_erreur(e);
  }
}
