/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

/*
	Arguments du popup :
		- 0 : Type document
		- 1 : Identifiant de ligne de document
		- 2 : Demande de confirmation d'enregistrement spcifique (argument facultatif)
*/

jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");


var typeDoc;
var ligneId;
var tmplSave;
var msgConfirm = null;



function init() {
  try {

		typeDoc = window.arguments[0];
		ligneId = window.arguments[1];
		msgConfirm = window.arguments[2];

		var tmplLoad;

		if (typeDoc=="FC") {
			tmplLoad = "Facturation/FacturesVente/getCommentairesLigneFC.tmpl";
			tmplSave = "Facturation/FacturesVente/updateCommentairesLigneFC.tmpl";
		}
		else if (typeDoc=="AC") {
			tmplLoad = "Facturation/Avoirs/getCommentairesLigneAC.tmpl";
			tmplSave = "Facturation/Avoirs/updateCommentairesLigneAC.tmpl";
		}
		else if (typeDoc=="FF") {
			tmplLoad = "Facturation/Factu_Fournisseur/getCommentairesLigneFF.tmpl";
			tmplSave = "Facturation/Factu_Fournisseur/updateCommentairesLigneFF.tmpl";
		}
		else if (typeDoc=="AF") {
			tmplLoad = "Facturation/Avoirs_Fournisseur/getCommentairesLigneAF.tmpl";
			tmplSave = "Facturation/Avoirs_Fournisseur/updateCommentairesLigneAF.tmpl";
		}
		else if (typeDoc=="TS") {
			tmplLoad = "Facturation/Transferts_Stocks/getCommentairesLigneTS.tmpl";
			tmplSave = "Facturation/Transferts_Stocks/updateCommentairesLigneTS.tmpl";
		}
		else if (typeDoc=="TE") {
			tmplLoad = "Facturation/Transferts_Emplacements/getCommentairesLigneTE.tmpl";
			tmplSave = "Facturation/Transferts_Emplacements/updateCommentairesLigneTE.tmpl";
		}
		else if (typeDoc=="DC") {
			tmplLoad = "Facturation/Devis/getCommentairesLigneDC.tmpl";
			tmplSave = "Facturation/Devis/updateCommentairesLigneDC.tmpl";
		}
		else if (typeDoc=="RF") {
			tmplLoad = "Facturation/Retours_Fournisseurs/getCommentairesLigneRF.tmpl";
			tmplSave = "Facturation/Retours_Fournisseurs/updateCommentairesLigneRF.tmpl";
		}
		else if (typeDoc=="CC") {
			tmplLoad = "Facturation/Affaires/getCommentairesLigneCC.tmpl";
			tmplSave = "Facturation/Affaires/updateCommentairesLigneCC.tmpl";
		}
		else if (typeDoc=="CF") {
			tmplLoad = "Facturation/Commandes/getCommentairesLigneCF.tmpl";
			tmplSave = "Facturation/Commandes/updateCommentairesLigneCF.tmpl";
		}
		else if (typeDoc=="MA") {
			tmplLoad = "Facturation/Abonnements/getCommentairesLigneMA.tmpl";
			tmplSave = "Facturation/Abonnements/updateCommentairesLigneMA.tmpl";
		}
		else if (typeDoc=="CA") {
			tmplLoad = "Facturation/Abonnements/getCommentairesLigneCA.tmpl";
			tmplSave = "Facturation/Abonnements/updateCommentairesLigneCA.tmpl";
		}

		var qLoad = new QueryHttp(tmplLoad);
		qLoad.setParam("Ligne_Id", ligneId);
		var result = qLoad.execute();

		document.getElementById('Commentaire_Avant').value = result.responseXML.documentElement.getAttribute('Commentaire_Avant');
		document.getElementById('Commentaire_Apres').value = result.responseXML.documentElement.getAttribute('Commentaire_Apres');
    document.getElementById('Commentaire_Apres').focus();

  } catch (e) {
    recup_erreur(e);
  }
}


function enregistrerCommentaires() {
  try {

		if (msgConfirm==null || window.confirm(msgConfirm)) {
			var qSave = new QueryHttp(tmplSave);
			qSave.setParam("Ligne_Id", ligneId);
			qSave.setParam("Commentaire_Apres", document.getElementById('Commentaire_Apres').value);
			qSave.setParam("Commentaire_Avant", document.getElementById('Commentaire_Avant').value);

			var result = qSave.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
		}

		window.close();

	} catch (e) {
    recup_erreur(e);
  }
}
