/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/


jsLoader.loadSubScript("chrome://opensi/content/libs/arbres.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/verif.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");


var infosExistantes = false;
var numerotation_auto = false;
var currentChampCompte;
var chargementFamille;
var chargerResponsable;
var selPoleActivite;
var def_pole_activite;
var tarifDefaut;

var aFamilles = new Arbre("ComboListe/combo-famillesClient.tmpl", "Famille");
var aResponsables = new Arbre("ComboListe/combo-responsables.tmpl", "Login_Resp");
var aPolesActivite = new Arbre("ComboListe/combo-polesActivite.tmpl", "Secteur");


function init() {
  try {

  	var config = getConfig();

		var mode_tarif = config.getModeTarif();
		numerotation_auto = !isEmpty(config.getFormatNC());
		tarifDefaut = config.getTarifDefaut();

		document.getElementById('Num_Client').disabled = numerotation_auto;
		document.getElementById('Num_Client').collapsed = numerotation_auto;
		document.getElementById('lblAuto').collapsed = !numerotation_auto;

    if (mode_tarif=="Q") {
			document.getElementById('rowTarifVente').collapsed = true;
		}

		if (config.isSpecTKPA()) {
			def_pole_activite = ParamValeur("DefPoleActivite");
		}
		else {
			def_pole_activite = "";
		}

		selTypeClient('E');
		infosExistantes = (ParamValeur('Infos_Existantes')=='1');
		document.getElementById('Tarif_Id').value = 1;
		document.getElementById('Type_Client').value = 'E';
		document.getElementById('Civilite').value = "0";

		var aPays = new Arbre("ComboListe/combo-pays.tmpl", "Code_Pays");
		aPays.initTree(initPays);

  } catch (e) {
    recup_erreur(e);
  }
}


function init2() {
	try {
		if (infosExistantes) {
			var assujettiTVA = (ParamValeur("Assujetti_TVA")=="1");
			document.getElementById('Assujetti_TVA').checked = assujettiTVA;
			changerAssujettiTVA(assujettiTVA);
			if (assujettiTVA) {
				document.getElementById('Type_Client').value = "E";
				selTypeClient("E");
				document.getElementById('Denomination').value = ParamValeur("Denomination_Fact");
				document.getElementById('Num_TVA_Intra').value = ParamValeur("Num_TVA");
				document.getElementById('Civilite').value = ParamValeur("Civ_Inter_Fact");
				document.getElementById('Nom').value = ParamValeur("Nom_Inter_Fact");
				document.getElementById('Prenom').value = ParamValeur("Prenom_Inter_Fact");
			} else {
				document.getElementById('Type_Client').value = "P";
				selTypeClient("P");
				var nom = ParamValeur("Denomination_Fact");
				if (nom.length>30) { nom = nom.substr(0,30); }
				document.getElementById('Nom').value = nom;
				document.getElementById('Civilite').value = "0";
			}
			document.getElementById('Login_Resp').value = ParamValeur("Util_R");
			document.getElementById('Tarif_Id').value = ParamValeur("Tarif_Id");

			if (ParamValeur("Mode_Reg")=="0") {
				document.getElementById('Mode_Reg').value = "";
			}
			else {
				document.getElementById('Mode_Reg').value = ParamValeur("Mode_Reg");
			}

			document.getElementById('Adresse_1').value = ParamValeur("Adresse_1_Fact");
			document.getElementById('Adresse_2').value = ParamValeur("Adresse_2_Fact");
			document.getElementById('Adresse_3').value = ParamValeur("Adresse_3_Fact");
			document.getElementById('Code_Postal').value = ParamValeur("Code_Postal_Fact");
			document.getElementById('Ville').value = ParamValeur("Ville_Fact");
			document.getElementById('Code_Pays').value = ParamValeur("Code_Pays_Fact");
			document.getElementById('Tel_1').value = ParamValeur("Tel_Inter_1_Fact");
			document.getElementById('Tel_2').value = ParamValeur("Tel_Inter_2_Fact");
			document.getElementById('Fax').value = ParamValeur("Fax_Inter_Fact");
			document.getElementById('Email').value = ParamValeur("Email_Inter_Fact");

			var poleActivite = ParamValeur("Pole_Activite");

			if (isEmpty(poleActivite)) {
				poleActivite = def_pole_activite;
			}

			chargerPolesActivite(poleActivite);
		}
		else {
			chargerPolesActivite(def_pole_activite);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function chargerPolesActivite(selection) {
	try {

	 selPoleActivite = selection;
	 aPolesActivite.setParam("Selection", selPoleActivite);
	 aPolesActivite.initTree(initPoleActivite);

	} catch (e) {
		recup_erreur(e);
	}
}


function initPoleActivite() {
  try {

		document.getElementById('Secteur').value = selPoleActivite;

	} catch (e) {
  	recup_erreur(e);
	}
}


function initPays() {
	try {

    document.getElementById('Code_Pays').value = "FR";

    chargerResponsable = getProfil().getLoggedUser();
    aResponsables.setParam("Selection", chargerResponsable);
		aResponsables.initTree(initResponsable);

	} catch (e) {
    recup_erreur(e);
  }
}


function initResponsable() {
	try {

    document.getElementById('Login_Resp').value = chargerResponsable;
    var aModeReg = new Arbre("ComboListe/combo-modesReglement.tmpl", "Mode_Reg");
		aModeReg.initTree(initMode);

	} catch (e) {
    recup_erreur(e);
  }
}


function initMode() {
	try {

		document.getElementById('Mode_Reg').selectedIndex = 0;
		var aTarifsVente = new Arbre("ComboListe/combo-tarifsVente.tmpl", "Tarif_Id");
		aTarifsVente.initTree(initTarifVente);

	} catch (e) {
    recup_erreur(e);
  }
}


function initTarifVente() {
	try {

		document.getElementById('Tarif_Id').value = tarifDefaut;
		aFamilles.initTree(initType);

	} catch (e) {
		recup_erreur(e);
	}
}


function initType() {
  try {

		document.getElementById('Famille').selectedIndex=0;
		var arbre_type=new Arbre("ComboListe/combo-formesJuridiques.tmpl", "formeJuridique");
		arbre_type.initTree(initTypeIndex);

  } catch (e) {
    recup_erreur(e);
  }
}


function initTypeIndex() {
	try {

		selectFormeJuridique('SARL');
		init2();

	} catch (e) {
		recup_erreur(e);
	}
}


function selectFormeJuridique(formeJuridique) {
	try {

		var selected = false;
		var i = 0;
		var menulist = document.getElementById('formeJuridique');
		var items = menulist.getElementsByTagName("menuitem");
		while (!selected && i<items.length) {
			if (items[i].getAttribute("label")==formeJuridique) {
				menulist.selectedIndex = i;
				selected = true;
			}
			i++;
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function selTypeClient(t) {
  try {

		switch(t) {
			case 'P':	document.getElementById('bcParticulier').collapsed = true;
								document.getElementById('rowFormeJuridique').collapsed = true;
								if (!infosExistantes) {
									document.getElementById('Assujetti_TVA').checked = false;
									changerAssujettiTVA(false);
								}
								break;
			case 'E':	document.getElementById('bcParticulier').collapsed = false;
								document.getElementById('rowFormeJuridique').collapsed = false;
								if (!infosExistantes) {
									document.getElementById('Assujetti_TVA').checked = true;
									changerAssujettiTVA(true);
								}
								break;
			case 'O': document.getElementById('bcParticulier').collapsed = false;
								document.getElementById('rowFormeJuridique').collapsed = true;
								if (!infosExistantes) {
									document.getElementById('Assujetti_TVA').checked = false;
									changerAssujettiTVA(false);
								}
								break;
			case 'A': document.getElementById('bcParticulier').collapsed = false;
								document.getElementById('rowFormeJuridique').collapsed = false;
								break;
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function existeClient(numClient) {
  try {

		var qExist = new QueryHttp("Facturation/Clients/existNumClient.tmpl");
		qExist.setParam('Num_Client', numClient);
		var result = qExist.execute();

  	return result.responseXML.documentElement.getAttribute('Exist')=="true";

  } catch (e) {
    recup_erreur(e);
  }
}


function enregistrer() {
	try {

		var numClient = document.getElementById('Num_Client').value;
		var raison_sociale = document.getElementById('Denomination').value;
		var civilite = document.getElementById('Civilite').value;
		var nom = document.getElementById('Nom').value;
		var prenom = document.getElementById('Prenom').value;
		var adresse_1 = document.getElementById('Adresse_1').value;
		var adresse_2 = document.getElementById('Adresse_2').value;
		var adresse_3 = document.getElementById('Adresse_3').value;
		var code_postal = document.getElementById('Code_Postal').value;
		var ville = document.getElementById('Ville').value;
		var code_pays = document.getElementById('Code_Pays').value;
		var tel1 = document.getElementById('Tel_1').value;
		var tel2 = document.getElementById('Tel_2').value;
		var fax = document.getElementById('Fax').value;
		var email = document.getElementById('Email').value;
		var formeJuridique = document.getElementById('formeJuridique').value;
		var assujetti_tva = document.getElementById('Assujetti_TVA').checked;
		var num_tva_intra = (document.getElementById('Assujetti_TVA').checked?document.getElementById('Num_TVA_Intra').value:"");
		var famille = document.getElementById('Famille').value;
		var poleId = document.getElementById('Secteur').value;
		var utilR = document.getElementById('Login_Resp').value;
		var type_client = document.getElementById('Type_Client').value;
		var compteClient = document.getElementById('Compte_Client').value;
		var tarifVente = document.getElementById('Tarif_Id').value;
		var mode_reg = document.getElementById('Mode_Reg').value;

		var saveOK = false;
		var clientId;

		if (!numerotation_auto && isEmpty(numClient)) {	showWarning("Veuillez sp\u00E9cifier un num\u00E9ro client !"); }
		else if (!numerotation_auto && existeClient(numClient)) {	showWarning("Le num\u00E9ro client '"+ numClient +"' est d\u00E9j\u00E0 utilis\u00E9 !"); }
		else if (!numerotation_auto && !isCleAlpha(numClient)) { showWarning("Num\u00E9ro client invalide !"); }
		else if (type_client!="P" && isEmpty(raison_sociale)) { showWarning("Veuillez sp\u00E9cifier la d\u00E9nomination du client !"); }
		else if (type_client=="P" && isEmpty(nom)) { showWarning("Veuillez sp\u00E9cifier le nom du client !"); }
		else if (isEmpty(adresse_1)) { showWarning("Veuillez sp\u00E9cifier l'adresse du client !"); }
		else if (isEmpty(ville)) { showWarning("Veuillez sp\u00E9cifier la ville du client !"); }
		else if (!isEmpty(tel1) && !isPhone(tel1)) { showWarning("T\u00E9l\u00E9phone 1 incorrect"); }
		else if (!isEmpty(tel2) && !isPhone(tel2)) { showWarning("T\u00E9l\u00E9phone 2 incorrect"); }
		else if (!isEmpty(fax) && !isPhone(fax)) { showWarning("Num\u00E9ro de fax incorrect !"); }
		else if (!isEmpty(email) && !isEmail(email)) { showWarning("Adresse e-mail incorrecte !"); }
		else if (isEmpty(utilR)) { showWarning("Veuillez sp\u00E9cifier le responsable du client"); }
		else {

			saveOK = true;
			if (assujetti_tva && type_client=="P") {
				showWarning("Attention : vous avez coch\u00E9 la case assujetti \u00E0 la tva bien que votre client soit un particulier !");
			} else if (assujetti_tva && type_client=="O") {
				showWarning("Attention : vous avez coch\u00E9 la case assujetti \u00E0 la tva bien que votre client soit un organisme public !");
			} else if (!assujetti_tva && type_client=="E") {
				showWarning("Attention : vous n'avez pas coch\u00E9 la case assujetti \u00E0 la tva bien que votre client soit une entreprise !");
			}

			if (assujetti_tva && code_pays!="FR" && isEmpty(num_tva_intra)) {
				var qZoneUE = new QueryHttp("Facturation/Commun/getZoneUEPays.tmpl");
				qZoneUE.setParam("Code_Pays", code_pays);
				var result = qZoneUE.execute();
				if (result.responseXML.documentElement.getAttribute("Zone_UE")=="true") {
					saveOK = (window.confirm("Vous n'avez pas saisi le num\u00E9ro de tva intra-communautaire ! Continuer ?"));
				}
			}

			if (saveOK) {
				var qCreate = new QueryHttp("Facturation/Clients/creerClientExpress.tmpl");
				if (!numerotation_auto) {
					qCreate.setParam("Num_Client", numClient);
				}
				qCreate.setParam("Denomination", raison_sociale);
				qCreate.setParam("Civilite", civilite);
				qCreate.setParam("Nom", nom);
				qCreate.setParam("Prenom", prenom);
				qCreate.setParam("Adresse_1", adresse_1);
				qCreate.setParam("Adresse_2", adresse_2);
				qCreate.setParam("Adresse_3", adresse_3);
				qCreate.setParam("Code_Postal", code_postal);
				qCreate.setParam("Ville", ville);
				qCreate.setParam("Code_Pays", code_pays);
				qCreate.setParam("Tel_1", tel1);
				qCreate.setParam("Tel_2", tel2);
				qCreate.setParam("Fax", fax);
				qCreate.setParam("Email", email);
				qCreate.setParam("Forme_Juridique", formeJuridique);
				qCreate.setParam("Assujetti_TVA", assujetti_tva);
				qCreate.setParam("Num_TVA_Intra", num_tva_intra);
				qCreate.setParam("Famille", famille);
				qCreate.setParam("Pole_Id", poleId);
				qCreate.setParam("Util_R", utilR);
				qCreate.setParam("Type_Client", type_client);
				qCreate.setParam("Compte_Client", compteClient);
				qCreate.setParam("Tarif_Id", tarifVente);
				qCreate.setParam("Mode_Reg", mode_reg);

				var result = qCreate.execute();

				clientId = result.responseXML.documentElement.getAttribute("Client_Id");

				if (numerotation_auto) {
					if (result.responseXML.documentElement.getAttribute("Num_Client")=="") {
						showMessage("Erreur : le format de num\u00E9rotation actuel ne permet plus de g\u00E9n\u00E9rer de num\u00E9ros client pour la p\u00E9riode d\u00E9finie !");
						saveOK = false;
					}
					else {
						document.getElementById("Num_Client").value = result.responseXML.documentElement.getAttribute("Num_Client");
					}
				}
			}

		}

		if (saveOK) {
			window.arguments[0](document.getElementById("Num_Client").value, clientId);
			window.close();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function ouvrirEditionListe() {
	try {
		var url = "chrome://opensi/content/facturation/user/commun/popup-ajouterElementListe.xul?"+ cookie() +"&Type_Element=FCLIENT";
    window.openDialog(url,'','chrome,modal,centerscreen', chargerFamille);
	} catch (e) {
		recup_erreur(e);
	}
}


function chargerFamille(selection) {
	try {
		chargementFamille = selection;
		aFamilles.setParam("Selection", chargementFamille);
		aFamilles.initTree(initFamilleClient);
	} catch (e) {
		recup_erreur(e);
	}
}

function initFamilleClient() {
	try {
		document.getElementById('Famille').value = chargementFamille;
	} catch (e) {
		recup_erreur(e);
	}
}


function rechcompte(id) {
	try {

		currentChampCompte = id;
    var url ="chrome://opensi/content/compta/user/comptes/popup-rechercheCompte.xul";
    window.openDialog(url,'','chrome,modal,centerscreen', retourRechercherCompte, "", "C", "CLIENT", "", false);

	} catch (e) {
		recup_erreur(e);
	}
}


function retourRechercherCompte(numCompte, compteId) {
	try {

		document.getElementById(currentChampCompte).value = numCompte;

	} catch (e) {
		  recup_erreur(e);
	}
}


function changerAssujettiTVA(etat) {
	try {

		document.getElementById('row_tva').collapsed=!etat;

	}	catch(e) {
		recup_erreur(e);
	}
}

