/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/


var ood_aDemandes = new Arbre("Facturation/Controle_Achats/list-demandeAvoirFournisseur.tmpl", "ood-listeDemandes");
var ood_aApercuDemande = new Arbre('Facturation/Controle_Achats/list-apercuDemandeAvoirFournisseur.tmpl', 'ood-apercu');

var ood_qListDAF = new QueryHttp("Facturation/Controle_Achats/getDataListDAF.tmpl");

var ood_pageCourante;
var ood_nbPages;

var ood_currentDemandeId = "";



function ood_initOngletDemandesAvoir() {
	try {

		ood_initCriteres();

	} catch (e) {
		recup_erreur(e);
  }
}


function ood_initCriteres() {
	try {

		document.getElementById('ood-numDemande').value = "";
		document.getElementById('ood-numFournisseur').value = "";
		document.getElementById('ood-etat').value = "V";
		document.getElementById('ood-dateDemandeDebut').value = "";
		document.getElementById('ood-dateDemandeFin').value = "";
		document.getElementById('ood-typeEcart').value = "";

		ood_listerDemandes();

	} catch (e) {
		recup_erreur(e);
	}
}


function ood_listerDemandes() {
	try {

		var numDemande = document.getElementById('ood-numDemande').value;
		var numFournisseur = document.getElementById('ood-numFournisseur').value;
		var etat = document.getElementById('ood-etat').value;
		var dateDemandeDebut = document.getElementById('ood-dateDemandeDebut').value;
		var dateDemandeFin = document.getElementById('ood-dateDemandeFin').value;
		var typeEcart = document.getElementById('ood-typeEcart').value;
		var nbLignesParPage = document.getElementById('ood-nbLignesParPage').value;

		if (!isEmpty(dateDemandeDebut) && !isDate(dateDemandeDebut)) { showWarning("Date de d\u00E9but incorrecte !"); }
		else if (!isEmpty(dateDemandeFin) && !isDate(dateDemandeFin)) { showWarning("Date de fin incorrecte !"); }
		else if (!isEmpty(dateDemandeDebut) && !isEmpty(dateDemandeFin) && !isDateInterval(dateDemandeDebut, dateDemandeFin)) { showWarning("Plage de dates incorrecte !"); }
		else {

			ood_pageCourante = 1;
			ood_nbPages = 1;
			document.getElementById('ood-pageDeb').value = 1;
			document.getElementById('ood-pageFin').value = 1;
			document.getElementById('ood-bPrec').disabled = true;
			document.getElementById('ood-bSuiv').disabled = true;

			document.getElementById('ood-listeDemandes').disabled = true;
			document.getElementById('ood-bEditionCsv').disabled = true;
			document.getElementById('ood-bVisualiser').disabled = true;
			document.getElementById('ood-bAnnuler').collapsed = true;
			document.getElementById('ood-bRefuser').collapsed = true;
			document.getElementById('ood-bAccepter').collapsed = true;
			document.getElementById('ood-numDemandeSelect').value = "";
			ood_aApercuDemande.deleteTree();
			ood_aDemandes.deleteTree();

			ood_qListDAF.setParam("Num_Demande", numDemande);
			ood_qListDAF.setParam("Num_Fournisseur", numFournisseur);
			ood_qListDAF.setParam("Etat", etat);
			ood_qListDAF.setParam("Date_Demande_Debut", dateDemandeDebut);
			ood_qListDAF.setParam("Date_Demande_Fin", dateDemandeFin);
			ood_qListDAF.setParam("Type_Ecart", typeEcart);
			ood_qListDAF.setParam("Nb_Lignes_Par_Page", nbLignesParPage);
			ood_qListDAF.setParam("Current_Page", ood_pageCourante);

			var result = ood_qListDAF.execute();

			var contenu = result.responseXML.documentElement;

			document.getElementById('ood-totalHT').value = contenu.getAttribute("Total_HT");
			ood_nbPages = contenu.getAttribute("Nb_Pages");
			var listDemandeId = contenu.getAttribute("List_Demande_Id");

			ood_aDemandes.setParam("List_Demande_Id", listDemandeId);
			ood_aDemandes.initTree(ood_initPagination);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function ood_initPagination() {
	try {

		document.getElementById('ood-pageDeb').value = ood_pageCourante;
		document.getElementById('ood-pageFin').value = (ood_nbPages>0?ood_nbPages:1);
		document.getElementById('ood-bPrec').disabled = (ood_pageCourante==1);
		document.getElementById('ood-bSuiv').disabled = (ood_pageCourante>=ood_nbPages); // peut se produire si ood_nbPages=0

		ood_afterMajPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function ood_pressOnPagePrec() {
	try {

		ood_pageCourante--;
		ood_majPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function ood_pressOnPageSuiv() {
	try {

		ood_pageCourante++;
		ood_majPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function ood_majPagination() {
	try {

		document.getElementById('ood-pageDeb').value = ood_pageCourante;
		document.getElementById('ood-bPrec').disabled = (ood_pageCourante==1);
		document.getElementById('ood-bSuiv').disabled = (ood_pageCourante==ood_nbPages);

		document.getElementById('ood-numDemandeSelect').value = "";

		document.getElementById('ood-listeDemandes').disabled = true;
		document.getElementById('ood-bEditionCsv').disabled = true;
		ood_aApercuDemande.deleteTree();

		ood_qListDAF.setParam("Current_Page", ood_pageCourante);
		var result = ood_qListDAF.execute();
		var listDemandeId = result.responseXML.documentElement.getAttribute("List_Demande_Id");

		ood_aDemandes.setParam("List_Demande_Id", listDemandeId);
		ood_aDemandes.initTree(ood_afterMajPagination);

	} catch (e) {
		recup_erreur(e);
	}
}


function ood_afterMajPagination() {
	try {

		document.getElementById('ood-listeDemandes').disabled = false;
		document.getElementById('ood-bEditionCsv').disabled=(ood_aDemandes.nbLignes()==0);

	} catch (e) {
		recup_erreur(e);
	}
}


function ood_selectOnListeDemandes() {
	try {

		if (ood_aDemandes.isSelected()) {
			ood_currentDemandeId = ood_aDemandes.getSelectedCellText('ood-colDemandeId');
			var etat = ood_aDemandes.getSelectedCellText('ood-colEtat');

			document.getElementById('ood-bVisualiser').disabled = false;
			document.getElementById('ood-bAnnuler').collapsed = etat!="V";
			document.getElementById('ood-bRefuser').collapsed = etat!="V";
			document.getElementById('ood-bAccepter').collapsed = etat!="V";

			document.getElementById('ood-numDemandeSelect').value = ood_aDemandes.getSelectedCellText('ood-colNumDemande');
			ood_aApercuDemande.setParam("Demande_Id", ood_currentDemandeId);
			ood_aApercuDemande.initTree();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function ood_pressOnCritere(ev) {
  try {

		if (ev.keyCode==13) {
			ood_listerDemandes();
    }

	} catch (e) {
  	recup_erreur(e);
  }
}


function ood_rechercherFournisseur() {
	try {

		var url = "chrome://opensi/content/facturation/user/fournisseurs/popup-rechercheFournisseur.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', ood_retourRechercherFournisseur);

	} catch (e) {
		recup_erreur(e);
	}
}


function ood_retourRechercherFournisseur(numFournisseur) {
	try {

  	document.getElementById('ood-numFournisseur').value = numFournisseur;
  	ood_listerDemandes();

	} catch (e) {
		recup_erreur(e);
	}
}


function ood_visualiserDemandeAvoirFournisseur() {
	try {

		if (!isEmpty(ood_currentDemandeId)) {
			visualiserDemandeAvoirFournisseur(ood_currentDemandeId);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function ood_annulerDemandeAvoirFournisseur() {
	try {

		if (window.confirm("Confirmez-vous l'annulation de la demande s\u00E9lectionn\u00E9e ?")) {
			var qCancel = new QueryHttp("Facturation/Controle_Achats/cancelDemandeAvoirFournisseur.tmpl");
			qCancel.setParam("Demande_Id", ood_currentDemandeId);

			var result = qCancel.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}

			ood_listerDemandes();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function ood_refuserDemandeAvoirFournisseur() {
	try {

		var url = "chrome://opensi/content/facturation/user/controle_achats/popup-demandeRefusee.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', ood_refuserDemandeAvoirFournisseur2);

	} catch (e) {
		recup_erreur(e);
	}
}


function ood_refuserDemandeAvoirFournisseur2(motifId, commentaires) {
	try {

		var qReject = new QueryHttp("Facturation/Controle_Achats/rejectDemandeAvoirFournisseur.tmpl");
		qReject.setParam("Demande_Id", ood_currentDemandeId);
		qReject.setParam("Motif_Id", motifId);
		qReject.setParam("Commentaires", commentaires);

		var result = qReject.execute();

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}

		ood_listerDemandes();

	} catch (e) {
		recup_erreur(e);
	}
}


function ood_accepterDemandeAvoirFournisseur() {
	try {

		var url = "chrome://opensi/content/facturation/user/controle_achats/popup-demandeAcceptee.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', ood_accepterDemandeAvoirFournisseur2);

	} catch (e) {
		recup_erreur(e);
	}
}


function ood_accepterDemandeAvoirFournisseur2(motifId, commentaires) {
	try {

		var qAccept = new QueryHttp("Facturation/Controle_Achats/acceptDemandeAvoirFournisseur.tmpl");
		qAccept.setParam("Demande_Id", ood_currentDemandeId);
		qAccept.setParam("Motif_Id", motifId);
		qAccept.setParam("Commentaires", commentaires);

		var result = qAccept.execute();

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
			ood_listerDemandes();
		}
		else {
			var avoirId = result.responseXML.documentElement.getAttribute('Avoir_Id');
			window.location = "chrome://opensi/content/facturation/user/factu_fournisseur/gestionFactures.xul?Avoir_Id="+ avoirId;
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function ood_pressOnEditionCsv() {
	try {

		var numDemande = document.getElementById('ood-numDemande').value;
		var numFournisseur = document.getElementById('ood-numFournisseur').value;
		var etat = document.getElementById('ood-etat').value;
		var dateDemandeDebut = document.getElementById('ood-dateDemandeDebut').value;
		var dateDemandeFin = document.getElementById('ood-dateDemandeFin').value;
		var typeEcart = document.getElementById('ood-typeEcart').value;

		if (!isEmpty(dateDemandeDebut) && !isDate(dateDemandeDebut)) { showWarning("Date de d\u00E9but incorrecte !"); }
		else if (!isEmpty(dateDemandeFin) && !isDate(dateDemandeFin)) { showWarning("Date de fin incorrecte !"); }
		else if (!isEmpty(dateDemandeDebut) && !isEmpty(dateDemandeFin) && !isDateInterval(dateDemandeDebut, dateDemandeFin)) { showWarning("Plage de dates incorrecte !"); }
		else {

			var qEditionCsv = new QueryHttp("Facturation/Controle_Achats/csvDemandeAvoirFournisseur.tmpl");

			qEditionCsv.setParam("Num_Demande", numDemande);
			qEditionCsv.setParam("Num_Fournisseur", numFournisseur);
			qEditionCsv.setParam("Etat", etat);
			qEditionCsv.setParam("Date_Demande_Debut", dateDemandeDebut);
			qEditionCsv.setParam("Date_Demande_Fin", dateDemandeFin);
			qEditionCsv.setParam("Type_Ecart", typeEcart);

			var result = qEditionCsv.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				var fichier = result.responseXML.documentElement.getAttribute('FichierCSV');

				var file = fileChooser("save", fichier);
				if (file!=null) {
					downloadFile(getDirBuffer()+ fichier, file);
				}
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}
