/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

/*
	Arguments du popup :
		- 0 : Requte QueryHttp d'enregistrement de la prvision d'cart
		- 1 : Valeur attendue de la prvision
*/

jsLoader.loadSubScript("chrome://opensi/content/libs/arbres.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/verif.js");


var aCommandes = new Arbre("Facturation/Controle_Achats/list-commandesForPrevision.tmpl", "listeCommandes");



function init() {
  try {

		var valeurAttendue = window.arguments[1];
		aCommandes.setParam("Valeur_Attendue", valeurAttendue);

  } catch (e) {
    recup_erreur(e);
  }
}


function toutCocher(b) {
	try {

		for (var i=0; i<aCommandes.nbLignes(); i++) {
			aCommandes.setCellValue(i, "colSelCommande", b);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function listerCommandes(fournisseurId) {
	try {

		aCommandes.setParam("Fournisseur_Id", fournisseurId);
		aCommandes.initTree();

	} catch (e) {
		recup_erreur(e);
	}
}


function rattacherCommandes() {
	try {

		var listCommandeId = "";

		for (var i=0; i<aCommandes.nbLignes(); i++) {
			if (aCommandes.getCellValue(i, "colSelCommande")=="true") {
				listCommandeId += aCommandes.getCellText(i, "colCommandeId") +",";
			}
		}

		if (isEmpty(listCommandeId)) {
			showWarning("Veuillez cocher au moins une commande");
		}
		else {
			window.arguments[0].setParam("List_Commande_Id", listCommandeId);
			window.close();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function rechercherFournisseur() {
	try {

		var url = "chrome://opensi/content/facturation/user/fournisseurs/popup-rechercheFournisseur.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', retourRechercherFournisseur);

	} catch (e) {
		recup_erreur(e);
	}
}


function retourRechercherFournisseur(numFournisseur, fournisseurId) {
	try {

  	document.getElementById('numFournisseur').value = numFournisseur;
  	listerCommandes(fournisseurId);

	} catch (e) {
		recup_erreur(e);
	}
}

