/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

/*
	Arguments du popup :
		- 0 : Fonction de retour
		- 1 : Identifiant de l'cart d'origine
*/

jsLoader.loadSubScript("chrome://opensi/content/libs/arbres.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/verif.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/formatter.js");


var aEcarts = new Arbre("Facturation/Controle_Achats/list-ecartADemander.tmpl", "listeEcarts");



function init() {
  try {

		var ecartId = window.arguments[1];

		aEcarts.setParam("Ecart_Id", ecartId);
		aEcarts.initTree();

  } catch (e) {
    recup_erreur(e);
  }
}


function selectOnListeEcarts() {
	try {

		if (aEcarts.isSelected()) {
			document.getElementById("valeurDemande").value = aEcarts.getSelectedCellText("colValeurDemande");
			document.getElementById("valeurDemande").disabled = false;
			document.getElementById("bModifier").disabled = false;
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function pressOnValeurDemande(ev) {
	try {

		if (ev.keyCode==13) {
		 	modifierValeurDemande();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function modifierValeurDemande() {
	try {

		if (aEcarts.isSelected()) {
			var ecartId = aEcarts.getSelectedCellText("colEcartId");
			var typeEcart = aEcarts.getSelectedCellText("colTypeEcart");
			var valeurDemande = document.getElementById('valeurDemande').value;

			if (!isPositive(valeurDemande) || (typeEcart=="LQ" && !checkQte(valeurDemande)) || (typeEcart!="LQ" && !checkDecimal(valeurDemande,4))) {
				showWarning("Valeur demande incorrecte");
			}
			else {
				var qSet = new QueryHttp("Facturation/Controle_Achats/setValeurDemandeEFF.tmpl");
				qSet.setParam("Ecart_Id", ecartId);
				qSet.setParam("Valeur_Demande", valeurDemande);
				var result = qSet.execute();

				var errors = new Errors(result);
				if (errors.hasNext()) {
					errors.show();
				}
				else {
					var fqte = new NumberFormat("0.###", false);
					var fmon = new NumberFormat("0.00##", false);

					aEcarts.setSelectedCellText("colValeurDemande", typeEcart=="LQ"?fqte.format(valeurDemande):fmon.format(valeurDemande));
					aEcarts.clearSelection();
					document.getElementById("bModifier").disabled = true;
					document.getElementById("valeurDemande").disabled = true;
					document.getElementById("valeurDemande").value = "";
				}
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function toutCocher(b) {
	try {

		for (var i=0; i<aEcarts.nbLignes(); i++) {
			aEcarts.setCellValue(i, "colSelEcart", b);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function validerDemande() {
	try {

		var listEcartId = "";

		for (var i=0; i<aEcarts.nbLignes(); i++) {
			if (aEcarts.getCellValue(i, "colSelEcart")=="true") {
				listEcartId += aEcarts.getCellText(i, "colEcartId") +",";
			}
		}

		if (isEmpty(listEcartId)) {
			showWarning("Veuillez cocher au moins un \u00E9cart");
		}
		else {
			var objet = document.getElementById("objet").value;

			var qDemande = new QueryHttp("Facturation/Controle_Achats/createDemandeAvoirFournisseur.tmpl");
			qDemande.setParam("List_Ecart_Id", listEcartId);
			qDemande.setParam("Objet", objet);

			var result = qDemande.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				var demandeId = result.responseXML.documentElement.getAttribute("Demande_Id");
				window.arguments[0](demandeId);
				window.close();
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}
