/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/arbres.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/verif.js");


var aFormatsImportCSV = new Arbre("ComboListe/combo-formatsImportData.tmpl", "formatImport");
var aFormatsExportCSV = new Arbre("ComboListe/combo-formatsExportData.tmpl", "formatExport");
var aChampsImportDispos = new Arbre("Facturation/CSV/list-champImportDispo.tmpl", "champsImportDispos");
var aChampsExportDispos = new Arbre("Facturation/CSV/list-champExportDispo.tmpl", "champsExportDispos");
var aChampsImportInclus = new Arbre("Facturation/CSV/list-champImportInclus.tmpl", "champsImportInclus");
var aChampsExportInclus = new Arbre("Facturation/CSV/list-champExportInclus.tmpl", "champsExportInclus");

var selectionFormatImport;
var selectionFormatExport;
var selectedLineImport;
var selectedLineExport;
var canClick = true;
var importFile;



function init() {
	try {

		var aImportsCSV = new Arbre("ComboListe/combo-importsCSV.tmpl", "typeImport");
		aImportsCSV.initTree();

		var aExportsCSV = new Arbre("ComboListe/combo-exportsCSV.tmpl", "typeExport");
		aExportsCSV.initTree();

		aFormatsImportCSV.initTree();
		aFormatsExportCSV.initTree();

		var aDepots = new Arbre('ComboListe/combo-depotsStock.tmpl', 'depotId');
		aDepots.initTree();

	} catch (e) {
		recup_erreur(e);
 	}
}


function rechercherFournisseur() {
	try {

		var url = "chrome://opensi/content/facturation/user/fournisseurs/popup-rechercheFournisseur.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', retourRechercherFournisseur);

	} catch (e) {
		recup_erreur(e);
	}
}


function retourRechercherFournisseur(numFournisseur) {
	try {

  	document.getElementById('numFournisseur').value = numFournisseur;

	} catch (e) {
		recup_erreur(e);
	}
}


function rechercherClient() {
	try {

		var url = "chrome://opensi/content/facturation/user/clients/popup-rechercheClient.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', retourRechercherClient);

	} catch (e) {
		recup_erreur(e);
	}
}


function retourRechercherClient(numClient) {
	try {

  	document.getElementById('numClient').value = numClient;

	} catch (e) {
		recup_erreur(e);
	}
}


function retourMenuPrincipal() {
  try {

    window.location = "chrome://opensi/content/facturation/user/menu_principal.xul";

  } catch (e) {
   	recup_erreur(e);
  }
}


// ONGLET IMPORT


function supprimerFormatImport() {
	try {

		var formatId = document.getElementById("formatImport").value;
		var intitule = document.getElementById("formatImport").getAttribute("label");

		if (!isEmpty(formatId) && window.confirm("Confirmez-vous la suppression du format d'import \""+ intitule +"\" ?")) {

			var qDelete = new QueryHttp("Facturation/CSV/deleteFormatImport.tmpl");
			qDelete.setParam("FormatId", formatId);
			var result = qDelete.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}

			aFormatsImportCSV.initTree();
			document.getElementById("formatImport").value = "";
			document.getElementById("typeImport").value = "";
			refreshChampsImport();
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function enregistrerFormatImport() {
	try {

		var formatId = document.getElementById("formatImport").value;
		var importId = document.getElementById("typeImport").value;
		var intitule = document.getElementById("formatImport").getAttribute("label");
		var ligneDebut = document.getElementById("ligneDebut").value;
		var separateur = document.getElementById("separateurImport").value;
		var delimiteur = document.getElementById("delimiteurImport").value;

		if (isEmpty(importId)) {
			showWarning("Veuillez s\u00E9lectionner un type d'import");
		}
		else if (!isPositiveInteger(ligneDebut)) {
			showWarning("Veuillez s\u00E9lectionner le num\u00E9ro de ligne");
		}
		else {
			var listChampId = "";

			for (var i=0; i<aChampsImportInclus.nbLignes(); i++) {
				listChampId += aChampsImportInclus.getCellText(i, "colChampIdCII") +",";
			}

			if (!isEmpty(formatId)) {
				if (window.confirm("Voulez vous modifier le format d'import "+ intitule +" ?")) {
					var qUpdate = new QueryHttp("Facturation/CSV/updateFormatImport.tmpl");
					qUpdate.setParam("Format_Id", formatId);
					qUpdate.setParam("Import_Id", importId);
					qUpdate.setParam("Ligne_Debut", ligneDebut);
					qUpdate.setParam("Separateur", separateur);
					qUpdate.setParam("Delimiteur", delimiteur);
					qUpdate.setParam("List_Champ_Id", listChampId);
					qUpdate.execute();
				}
			}
			else {
				var url = "chrome://opensi/content/facturation/user/csv/popup-choixFormatImport.xul";
		   	window.openDialog(url,'','chrome,modal,centerscreen', importId, ligneDebut, separateur, delimiteur, listChampId, retourChoixFormatImport);
			}

			aChampsImportDispos.clearSelection();
			aChampsImportInclus.clearSelection();

			disableBoutonsImport();
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function retourChoixFormatImport(formatId) {
	try {

		selectionFormatImport = formatId;
 		aFormatsImportCSV.initTree(initFormatImport);

	} catch (e) {
		recup_erreur(e);
	}
}


function initFormatImport() {
	try {

		document.getElementById("formatImport").value = selectionFormatImport;

	} catch (e) {
		recup_erreur(e);
	}
}


function refreshImport() {
	try {

		var formatId = document.getElementById("formatImport").value;

		if (!isEmpty(formatId)) {
			var qLoad = new QueryHttp("Facturation/CSV/loadFormatImport.tmpl");
			qLoad.setParam("Format_Id", formatId);
			var result = qLoad.execute();
			var contenu = result.responseXML.documentElement;

			document.getElementById("typeImport").value = contenu.getAttribute("Import_Id");
			document.getElementById("ligneDebut").value = contenu.getAttribute("Ligne_Debut");
			document.getElementById("delimiteurImport").value = contenu.getAttribute("Delimiteur");
			document.getElementById("separateurImport").value = contenu.getAttribute("Separateur");
		}

		refreshChampsImport();

	} catch (e) {
   	recup_erreur(e);
 	}
}


function refreshChampsImport() {
	try {

		var importId = document.getElementById("typeImport").value;

		if (isEmpty(importId)) {
			aChampsImportDispos.deleteTree();
			aChampsImportInclus.deleteTree();
			document.getElementById("formatImport").value = "";
			document.getElementById("separateurImport").value = ";";
			document.getElementById("delimiteurImport").value = "\"";
			document.getElementById("ligneDebut").value = "2";
		}
		else {
			var formatId = document.getElementById("formatImport").value;
			if (!isEmpty(formatId)) {
				aChampsImportDispos.clearParams();
				aChampsImportDispos.setParam("Format_Id", formatId);
				aChampsImportDispos.setParam("Import_Id", importId);
				aChampsImportDispos.initTree();

				aChampsImportInclus.clearParams();
				aChampsImportInclus.setParam("Format_Id", formatId);
				aChampsImportInclus.setParam("Import_Id", importId);
				aChampsImportInclus.initTree();
			}
			else {
				document.getElementById("separateurImport").value = ";";
				document.getElementById("delimiteurImport").value = "\"";
				document.getElementById("ligneDebut").value = "2";
				aChampsImportDispos.deleteTree();

				aChampsImportInclus.clearParams();
				aChampsImportInclus.setParam("Import_Id", importId);
				aChampsImportInclus.initTree();
			}
		}

		disableBoutonsImport();

	} catch (e) {
		recup_erreur(e);
	}
}


function modifTypeImport() {
	try {

		document.getElementById("formatImport").value = "";
		refreshImport();

	} catch (e) {
		recup_erreur(e)
	}
}


function disableBoutonsImport() {
	try {

		document.getElementById("bAjouterImport").disabled = true;
		document.getElementById("bEnleverImport").disabled = true;
		document.getElementById("bHautImport").disabled = true;
		document.getElementById("bBasImport").disabled = true;

	} catch (e) {
		recup_erreur(e)
	}
}


function selectOnChampsImportDispos() {
	try {

		aChampsImportInclus.clearSelection();
		document.getElementById("bAjouterImport").disabled = false;
		document.getElementById("bEnleverImport").disabled = true;
		document.getElementById("bHautImport").disabled = true;
		document.getElementById("bBasImport").disabled = true;

	} catch (e) {
		recup_erreur(e)
	}
}


function selectOnChampsImportInclus() {
	try {

		aChampsImportDispos.clearSelection();

		var start = new Object();
		var end = new Object();
		var obligatoire = true;

		for (var t=0; t<aChampsImportInclus.getRangeCount(); t++) {
			aChampsImportInclus.getRangeAt(t,start,end);
			for (var v=start.value; v<=end.value; v++) {
			  if (aChampsImportInclus.getCellValue(v, "colObligatoireCII")=="false") {
				  obligatoire = false;
			  }
			}
		}

		if (aChampsImportInclus.nbSelection()==1) {
			document.getElementById("bEnleverImport").disabled = aChampsImportInclus.getSelectedCellValue("colObligatoireCII")=="true";
			document.getElementById("bAjouterImport").disabled = true;
			var currentIndex = aChampsImportInclus.getCurrentIndex();
			var nbLignes = aChampsImportInclus.nbLignes();
			document.getElementById("bHautImport").disabled = (currentIndex==0);
			document.getElementById("bBasImport").disabled = (currentIndex+1==nbLignes);
		}
		else {
			if (!obligatoire) {
				document.getElementById("bEnleverImport").disabled = false;
				document.getElementById("bAjouterImport").disabled = true;
				document.getElementById("bHautImport").disabled = true;
				document.getElementById("bBasImport").disabled = true;
			}
			else {
				document.getElementById("bEnleverImport").disabled = true;
				document.getElementById("bAjouterImport").disabled = true;
				document.getElementById("bHautImport").disabled = true;
				document.getElementById("bBasImport").disabled = true;
			}
		}

	} catch (e) {
		recup_erreur(e)
	}
}


function ajouterChampImport() {
	try {

		var importId = document.getElementById('typeImport').value;
		var start = new Object();
		var end = new Object();
		var listSelection = new Array();

		for (var t=0; t<aChampsImportDispos.getRangeCount(); t++) {
			aChampsImportDispos.getRangeAt(t,start,end);
			for (var v=start.value; v<=end.value; v++) {
				if (v!=-1) {
				  listSelection.push(aChampsImportDispos.getCellText(v, "colChampIdCID"));
				}
			}
		}

		var listChampId = "";

		for (var i=0; i<aChampsImportInclus.nbLignes(); i++) {
			listChampId += aChampsImportInclus.getCellText(i, "colChampIdCII") +",";
		}

		for (var i=0; i<listSelection.length; i++) {
			listChampId += listSelection[i] +",";
		}

		aChampsImportInclus.clearParams();
		aChampsImportInclus.setParam("List_Champ_Id", listChampId);
		aChampsImportInclus.setParam("Import_Id", importId);
		aChampsImportInclus.initTree();

		aChampsImportDispos.clearParams();
		aChampsImportDispos.setParam("List_Non_Dispo", listChampId);
		aChampsImportDispos.setParam("Import_Id", importId);
		aChampsImportDispos.initTree();

		disableBoutonsImport();

	} catch (e) {
		recup_erreur(e)
	}
}


function enleverChampImport() {
	try {

		var importId = document.getElementById('typeImport').value;
		var start = new Object();
		var end = new Object();
		var listSelection = new Array();

		for (var t=0; t<aChampsImportInclus.getRangeCount(); t++) {
			aChampsImportInclus.getRangeAt(t,start,end);
			for (var v=start.value; v<=end.value; v++) {
				if (v!=-1 && aChampsImportInclus.getCellValue(v, "colObligatoireCII")=="false") {
					listSelection.push(aChampsImportInclus.getCellText(v, "colChampIdCII"));
				}
			}
		}

		var listChampId = "";

		for (var i=0; i<aChampsImportInclus.nbLignes(); i++) {
			var champId = aChampsImportInclus.getCellText(i, "colChampIdCII");
			var trouve = false;
			for (var j=0; j<listSelection.length; j++) {
				if (champId==listSelection[j]) {
					trouve = true;
				}
			}
			if (!trouve) {
				listChampId += champId +",";
			}
		}

		aChampsImportInclus.clearParams();
		aChampsImportInclus.setParam("List_Champ_Id", listChampId);
		aChampsImportInclus.setParam("Import_Id", importId);
		aChampsImportInclus.initTree();

		aChampsImportDispos.clearParams();
		aChampsImportDispos.setParam("List_Non_Dispo", listChampId);
		aChampsImportDispos.setParam("Import_Id", importId);
		aChampsImportDispos.initTree();

		disableBoutonsImport();

	} catch (e) {
		recup_erreur(e)
	}
}


function deplacerChampImport(moveType) {
	try {

		if (canClick) {
			canClick = false;
			disableBoutonsImport();

			var importId = document.getElementById('typeImport').value;
			var listChampId = "";
			var sourceIndex = aChampsImportInclus.getCurrentIndex();
			var sourceId = aChampsImportInclus.getCellText(sourceIndex, "colChampIdCII");
			var targetIndex = moveType=="B"?sourceIndex + 1:sourceIndex - 1;
			var targetId = aChampsImportInclus.getCellText(targetIndex, "colChampIdCII");

			for (var i=0; i<aChampsImportInclus.nbLignes(); i++) {
				if (i==sourceIndex) {
					listChampId += targetId +",";
				}
				else if (i==targetIndex) {
					listChampId += sourceId +",";
				}
				else {
					listChampId += aChampsImportInclus.getCellText(i, "colChampIdCII") +",";
				}
			}

			selectedLineImport = targetIndex;

			aChampsImportInclus.clearParams();
			aChampsImportInclus.setParam("List_Champ_Id", listChampId);
			aChampsImportInclus.setParam("Import_Id", importId);
			aChampsImportInclus.initTree(selectLineImport);
		}

	} catch (e) {
		recup_erreur(e)
	}
}


function selectLineImport() {
	try {

		aChampsImportInclus.select(selectedLineImport);
		canClick = true;

	} catch (e) {
		recup_erreur(e)
	}
}


function importer() {
	try {

		if (importFile==null) {
			showWarning("Vous devez s\u00E9lectionner un fichier \u00E0 importer");
		}
		else {
			var extension = getFileExtension(importFile.leafName).toLowerCase();
			var formatFichier = "";

			if (extension=="txt" || isEmpty(extension)) {
				formatFichier = "CSV";
			}
			else if (extension=="csv" || extension=="xls" || extension=="xlsx") {
				formatFichier = extension.toUpperCase();
			}

			if (aChampsImportInclus.nbLignes()==0) {
				showWarning("Vous devez s\u00E9lectionner un type d\'import");
			}
			else if (isEmpty(formatFichier)) {
				showWarning("Format de fichier incorrect (formats accept\u00E9s : *.csv, *.txt, *.xls, *.xlsx)");
			}
			else if (checkUploadFile(importFile)) {

				document.getElementById('bImporter').disabled = true;
				document.getElementById('pmboxImport').collapsed = false;
				document.getElementById('pmImport').setAttribute('mode', 'undetermined');

				var importId = document.getElementById("typeImport").value;
				var separateur = document.getElementById("separateurImport").value;
				var delimiteur = document.getElementById("delimiteurImport").value;
				var ligneDebut = document.getElementById("ligneDebut").value;

				var listChampId = "";

				for (var i=0; i<aChampsImportInclus.nbLignes(); i++) {
					listChampId += aChampsImportInclus.getCellText(i, "colChampIdCII") +",";
				}

				uploadFile(importFile);

				var qImport = new QueryHttp("Facturation/CSV/importData.tmpl");
				qImport.setParam("Import_Id", importId);
				qImport.setParam("Separateur", separateur);
				qImport.setParam("Delimiteur", delimiteur);
				qImport.setParam("Ligne_Debut", ligneDebut);
				qImport.setParam("List_Champ_Id", listChampId);
				qImport.setParam("Format_Fichier", formatFichier);
				qImport.setParam("Fichier", importFile.leafName);
				qImport.execute(importer2);
			}
		}

	} catch (e) {
		recup_erreur(e)
	}
}


function importer2(result) {
	try {

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}

		document.getElementById('pmImport').setAttribute('mode', 'none');
		document.getElementById('pmboxImport').collapsed = true;

		var nbLines = result.responseXML.documentElement.getElementsByTagName("erreurs").length;

		if (nbLines==0) {
			showMessage("Import termin\u00E9 avec succ\u00E8s");
		}
		else {
			var rapport = result.responseXML.documentElement.getAttribute('Fichier_Rapport');

			var messages = new Array();
			var lines = new Array();
			var cells = new Array();

			for (var j=0 ; j<result.responseXML.documentElement.getElementsByTagName("erreurs").length ; j++) {
				var erreur = result.responseXML.documentElement.getElementsByTagName('erreurs')[j];
				messages[j] = erreur.getAttribute("Message");
				lines[j] = erreur.getAttribute("Ligne");
				cells[j] = erreur.getAttribute("Cellule");
			}

			window.openDialog("chrome://opensi/content/facturation/user/csv/popup-rapportErreurs.xul",'','chrome,modal,centerscreen', lines, cells, messages, rapport);
		}

		document.getElementById('bImporter').disabled = false;

	} catch (e) {
		recup_erreur(e)
	}
}


function searchFile() {
	try {

		var file = fileChooser("open");
		if (file!=null) {
			importFile = file;
			document.getElementById("pathFile").value = file.path;
		}

	} catch (e) {
		recup_erreur(e);
	}
}


// ONGLET EXPORT


function supprimerFormatExport() {
	try {

		var formatId = document.getElementById("formatExport").value;
		var intitule = document.getElementById("formatExport").getAttribute("label");

		if (!isEmpty(formatId) && window.confirm("Confirmez-vous la suppression du format d'export \""+ intitule +"\" ?")) {

			var qDelete = new QueryHttp("Facturation/CSV/deleteFormatExport.tmpl");
			qDelete.setParam("FormatId", formatId);
			var result = qDelete.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}

			aFormatsExportCSV.initTree();
			document.getElementById("formatExport").value = "";
			document.getElementById("typeExport").value = "";
			refreshChampsExport();
		}

	} catch (e) {
   	recup_erreur(e);
  }
}


function enregistrerFormatExport() {
	try {

		var exportId = document.getElementById("typeExport").value;
		var formatId = document.getElementById("formatExport").value;
		var intitule = document.getElementById("formatExport").getAttribute("label");
		var separateur = document.getElementById("separateurExport").value;
		var delimiteur = document.getElementById("delimiteurExport").value;
		var ligneTitre = document.getElementById("ligneTitre").checked;

		if (isEmpty(exportId)) {
			showWarning("Veuillez s\u00E9lectionner un type d'export");
		}
		else if (aChampsExportInclus.nbLignes()==0) {
			showWarning("Veuillez s\u00E9lectionner des champs \u00E9 exporter");
		}
		else {
			var listChampId = "";

			for (var i=0; i<aChampsExportInclus.nbLignes(); i++) {
				listChampId += aChampsExportInclus.getCellText(i, "colChampIdCEI") +",";
			}

			if (!isEmpty(formatId)) {
				if (window.confirm("Voulez vous modifier le format d'export "+ intitule +" ?")) {
					var qUpdate = new QueryHttp("Facturation/CSV/updateFormatExport.tmpl");
					qUpdate.setParam("Format_Id", formatId);
					qUpdate.setParam("Export_Id", exportId);
					qUpdate.setParam("Ligne_Titre", ligneTitre);
					qUpdate.setParam("Separateur", separateur);
					qUpdate.setParam("Delimiteur", delimiteur);
					qUpdate.setParam("List_Champ_Id", listChampId);
					qUpdate.execute();
				}
			}
			else {
				var url = "chrome://opensi/content/facturation/user/csv/popup-choixFormatExport.xul";
		   	window.openDialog(url,'','chrome,modal,centerscreen', exportId, ligneTitre, separateur, delimiteur, listChampId, retourChoixFormatExport);
			}
		}

	} catch (e) {
   	recup_erreur(e);
 	}
}


function retourChoixFormatExport(formatId) {
	try {

		selectionFormatExport = formatId;
 		aFormatsExportCSV.initTree(initFormatExport);

	} catch (e) {
		recup_erreur(e);
	}
}


function initFormatExport() {
	try {

		document.getElementById("formatExport").value = selectionFormatExport;

	} catch (e) {
		recup_erreur(e);
	}
}


function refreshExport() {
	try {

		var formatId = document.getElementById("formatExport").value;

		if (!isEmpty(formatId)) {
			var qLoad = new QueryHttp("Facturation/CSV/loadFormatExport.tmpl");
			qLoad.setParam("Format_Id", formatId);
			var result = qLoad.execute();
			var contenu = result.responseXML.documentElement;

			document.getElementById("typeExport").value = contenu.getAttribute("Export_Id");
			document.getElementById("ligneTitre").checked = contenu.getAttribute("Ligne_Titre")=="true";
			document.getElementById("delimiteurExport").value = contenu.getAttribute("Delimiteur");
			document.getElementById("separateurExport").value = contenu.getAttribute("Separateur");
		}

		var exportId = document.getElementById("typeExport").value;

		if (!isEmpty(exportId)) {
			var qGet = new QueryHttp("Facturation/CSV/getCodeExport.tmpl");
			qGet.setParam("Export_Id", exportId);
			var result = qGet.execute();

			var codeExport = result.responseXML.documentElement.getAttribute("Code");
			document.getElementById("chkSansFournisseur").collapsed = (codeExport!="ARTF" && codeExport!="FAAF");
			document.getElementById("boxNumFournisseur").collapsed = (codeExport!="ARTF" && codeExport!="FAAF" && codeExport!="PREL");
			document.getElementById("boxNumClient").collapsed = (codeExport!="TCLI" && codeExport!="RCLI" && codeExport!="TMAC" && codeExport!="RMAC");
			document.getElementById("boxDepotStock").collapsed = (codeExport!="PSTK" && codeExport!="ESTK" && codeExport!="EART");
		}
		else {
			document.getElementById("chkSansFournisseur").collapsed = true;
			document.getElementById("boxNumFournisseur").collapsed = true;
			document.getElementById("boxNumClient").collapsed = true;
			document.getElementById("boxDepotStock").collapsed = true;
		}

		refreshChampsExport();

	} catch (e) {
   	recup_erreur(e);
 	}
}


function refreshChampsExport() {
	try {

		var exportId = document.getElementById("typeExport").value;

		if (isEmpty(exportId)) {
			aChampsExportDispos.deleteTree();
			aChampsExportInclus.deleteTree();
			document.getElementById("formatExport").value = "";
			document.getElementById("separateurExport").value = ";";
			document.getElementById("delimiteurExport").value = "\"";
			document.getElementById("ligneTitre").checked = true;
		}
		else {
			var formatId = document.getElementById("formatExport").value;
			if (!isEmpty(formatId)) {
				aChampsExportDispos.clearParams();
				aChampsExportDispos.setParam("Export_Id", exportId);
				aChampsExportDispos.setParam("Format_Id", formatId);
				aChampsExportDispos.initTree();

				aChampsExportInclus.clearParams();
				aChampsExportInclus.setParam("Export_Id", exportId);
				aChampsExportInclus.setParam("Format_Id", formatId);
				aChampsExportInclus.initTree();
			}
			else {
				document.getElementById("separateurExport").value = ";";
				document.getElementById("delimiteurExport").value = "\"";
				document.getElementById("ligneTitre").checked = true;
				aChampsExportDispos.deleteTree();

				aChampsExportInclus.clearParams();
				aChampsExportInclus.setParam("Export_Id", exportId);
				aChampsExportInclus.initTree();
			}
		}

		disableBoutonsExport();

	} catch (e) {
		recup_erreur(e);
	}
}


function modifTypeExport() {
	try {

		document.getElementById("formatExport").value = "";
		refreshExport();

	} catch (e) {
		recup_erreur(e)
	}
}


function disableBoutonsExport() {
	try {

		document.getElementById("bAjouterExport").disabled = true;
		document.getElementById("bEnleverExport").disabled = true;
		document.getElementById("bHautExport").disabled = true;
		document.getElementById("bBasExport").disabled = true;

	} catch (e) {
		recup_erreur(e)
	}
}


function selectOnChampsExportDispos() {
	try {

		aChampsExportInclus.clearSelection();
		document.getElementById("bAjouterExport").disabled = false;
		document.getElementById("bEnleverExport").disabled = true;
		document.getElementById("bHautExport").disabled = true;
		document.getElementById("bBasExport").disabled = true;

	} catch (e) {
		recup_erreur(e)
	}
}


function selectOnChampsExportInclus() {
	try {

		aChampsExportDispos.clearSelection();
		document.getElementById("bEnleverExport").disabled = false;
		document.getElementById("bAjouterExport").disabled = true;
		var currentIndex = aChampsExportInclus.getCurrentIndex();
		var nbLignes = aChampsExportInclus.nbLignes();
		document.getElementById("bHautExport").disabled = (currentIndex==0);
		document.getElementById("bBasExport").disabled = (currentIndex+1==nbLignes);

	} catch (e) {
		recup_erreur(e)
	}
}


function ajouterChampExport() {
	try {

		var exportId = document.getElementById('typeExport').value;
		var start = new Object();
		var end = new Object();
		var listSelection = new Array();

		for (var t=0; t<aChampsExportDispos.getRangeCount(); t++) {
			aChampsExportDispos.getRangeAt(t,start,end);
			for (var v=start.value; v<=end.value; v++) {
				if (v!=-1) {
					listSelection.push(aChampsExportDispos.getCellText(v, "colChampIdCED"));
				}
			}
		}

		var listChampId = "";

		for (var i=0; i<aChampsExportInclus.nbLignes(); i++) {
			listChampId += aChampsExportInclus.getCellText(i, "colChampIdCEI") +",";
		}

		for (var i=0; i<listSelection.length; i++) {
			listChampId += listSelection[i] +",";
		}

		aChampsExportInclus.clearParams();
		aChampsExportInclus.setParam("Export_Id", exportId);
		aChampsExportInclus.setParam("List_Champ_Id", listChampId);
		aChampsExportInclus.initTree();

		aChampsExportDispos.clearParams();
		aChampsExportDispos.setParam("Export_Id", exportId);
		aChampsExportDispos.setParam("List_Non_Dispo", listChampId);
		aChampsExportDispos.initTree();

		disableBoutonsExport();

	} catch (e) {
		recup_erreur(e)
	}
}


function enleverChampExport() {
	try {

		var exportId = document.getElementById('typeExport').value;
		var start = new Object();
		var end = new Object();
		var listSelection = new Array();

		for (var t=0; t<aChampsExportInclus.getRangeCount(); t++) {
			aChampsExportInclus.getRangeAt(t,start,end);
			for (var v=start.value; v<=end.value; v++) {
				if (v!=-1) {
					listSelection.push(aChampsExportInclus.getCellText(v, "colChampIdCEI"));
				}
			}
		}

		var listChampId = "";

		for (var i=0; i<aChampsExportInclus.nbLignes(); i++) {
			var champId = aChampsExportInclus.getCellText(i, "colChampIdCEI");
			var trouve = false;
			for (var j=0; j<listSelection.length; j++) {
				if (champId==listSelection[j]) {
					trouve = true;
				}
			}
			if (!trouve) {
				listChampId += champId +",";
			}
		}

		aChampsExportInclus.clearParams();
		aChampsExportInclus.setParam("List_Champ_Id", listChampId);
		aChampsExportInclus.setParam("Export_Id", exportId);
		aChampsExportInclus.initTree();

		aChampsExportDispos.clearParams();
		aChampsExportDispos.setParam("List_Non_Dispo", listChampId);
		aChampsExportDispos.setParam("Export_Id", exportId);
		aChampsExportDispos.initTree();

		disableBoutonsExport();

	} catch (e) {
		recup_erreur(e)
	}
}


function deplacerChampExport(moveType) {
	try {

		if (canClick) {
			canClick = false;
			disableBoutonsExport();

			var exportId = document.getElementById('typeExport').value;
			var listChampId = "";
			var sourceIndex = aChampsExportInclus.getCurrentIndex();
			var sourceId = aChampsExportInclus.getCellText(sourceIndex, "colChampIdCEI");
			var targetIndex = moveType=="B"?sourceIndex + 1:sourceIndex - 1;
			var targetId = aChampsExportInclus.getCellText(targetIndex, "colChampIdCEI");

			for (var i=0; i<aChampsExportInclus.nbLignes(); i++) {
				if (i==sourceIndex) {
					listChampId += targetId +",";
				}
				else if (i==targetIndex) {
					listChampId += sourceId +",";
				}
				else {
					listChampId += aChampsExportInclus.getCellText(i, "colChampIdCEI") +",";
				}
			}

			selectedLineExport = targetIndex;

			aChampsExportInclus.clearParams();
			aChampsExportInclus.setParam("List_Champ_Id", listChampId);
			aChampsExportInclus.setParam("Export_Id", exportId);
			aChampsExportInclus.initTree(selectLineExport);
		}

	} catch (e) {
		recup_erreur(e)
	}
}


function selectLineExport() {
	try {

		aChampsExportInclus.select(selectedLineExport);
		canClick = true;

	} catch (e) {
		recup_erreur(e)
	}
}


function exporter() {
	try {

		if (aChampsExportInclus.nbLignes()==0) {
			showWarning("Veuillez s\u00E9lectionner des champs \u00E0 exporter");
		}
		else {
			document.getElementById('bExporter').disabled = true;
			document.getElementById('pmboxExport').collapsed = false;
			document.getElementById('pmExport').setAttribute('mode', 'undetermined');

			var exportId = document.getElementById("typeExport").value;
			var separateur = document.getElementById("separateurExport").value;
			var delimiteur = document.getElementById("delimiteurExport").value;
			var ligneTitre = document.getElementById("ligneTitre").checked;
			var actif = document.getElementById("chkActif").checked;
			var sansFournisseur = document.getElementById("chkSansFournisseur").checked;
			var numFournisseur = document.getElementById("numFournisseur").value;
			var numClient = document.getElementById("numClient").value;
			var depotId = document.getElementById("depotId").value;
			var formatFichier = document.getElementById("formatFichier").value;

			var listChampId = "";

			for (var i=0; i<aChampsExportInclus.nbLignes(); i++) {
				listChampId += aChampsExportInclus.getCellText(i, "colChampIdCEI") +",";
			}

			var qExport = new QueryHttp("Facturation/CSV/exportData.tmpl");
			qExport.setParam("Export_Id", exportId);
			qExport.setParam("Separateur", separateur);
			qExport.setParam("Delimiteur", delimiteur);
			qExport.setParam("Ligne_Titre", ligneTitre);
			qExport.setParam("Actif", actif);
			qExport.setParam("Sans_Fournisseur", sansFournisseur);
			qExport.setParam("Num_Fournisseur", numFournisseur);
			qExport.setParam("Num_Client", numClient);
			qExport.setParam("Depot_Id", depotId);
			qExport.setParam("Format_Fichier", formatFichier);
			qExport.setParam("List_Champ_Id", listChampId);

			qExport.execute(exporter2);
		}

	} catch (e) {
		recup_erreur(e)
	}
}


function exporter2(result) {
	try {

		document.getElementById('pmExport').setAttribute('mode', 'none');
		document.getElementById('pmboxExport').collapsed = true;

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}
		else {
			var fichier = result.responseXML.documentElement.getAttribute('FichierCSV');
			var formatFichier = document.getElementById("formatFichier").value;

			var file = fileChooser("save", fichier, formatFichier);
			if (file!=null) {
				downloadFile(getDirBuffer()+ fichier, file);
			}
		}

		document.getElementById('bExporter').disabled = false;

	} catch (e) {
		recup_erreur(e)
	}
}



