/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/


var oed_aLignesDEB = new Arbre('Facturation/DEB/list-ligneDEB.tmpl', 'oed-tLignesDEB');
var oed_aTotauxPays = new Arbre('Facturation/DEB/list-totauxPays.tmpl', 'oed-tTotauxPays');
var oed_qListLD = new QueryHttp("Facturation/DEB/getDataListLD.tmpl");

var oed_declarationId;
var oed_mode;
var oed_etatDEB;
var oed_modified = false;
var oed_typeDeclaration;
var oed_niveauObligation;
var oed_currentIndex = 0;
var oed_pageCourante;
var oed_nbPages;



function oed_init() {
	try {

		var aTransactions = new Arbre("ComboListe/combo-debTransactions.tmpl", "oed-natureTransaction");
		aTransactions.initTree();

		var aModesTransport = new Arbre("ComboListe/combo-debModesTransport.tmpl", "oed-modeTransport");
		aModesTransport.initTree();

		var aPaysOrigine = new Arbre("ComboListe/combo-pays.tmpl", "oed-paysOrigine");
		aPaysOrigine.initTree();

		var aPaysDestProv = new Arbre("ComboListe/combo-pays.tmpl", "oed-paysDestProv");
		aPaysDestProv.setParam("Only_UE", true);
		aPaysDestProv.initTree();

	} catch (e) {
		recup_erreur(e);
	}
}


function oed_initIHM() {
	try {

		document.getElementById('oed-bEnregistrerDEB').collapsed = oed_etatDEB=="A";
		document.getElementById('oed-bSupprimerDEB').collapsed = oed_mode!="M";
		document.getElementById('oed-bAnnulerDEB').collapsed = oed_mode!="V" || oed_etatDEB=="A";
		document.getElementById('oed-bValiderDEB').collapsed = oed_mode!="M";
		document.getElementById('oed-bExportIC').collapsed = oed_mode!="V";

		document.getElementById('oed-ligneDEB').collapsed = oed_mode=="V";
		oed_currentIndex = 0;
		oed_annulerLigne();

		document.getElementById('oed-refFichier').disabled = oed_etatDEB=="A";
		document.getElementById('oed-commentaires').disabled = oed_etatDEB=="A";

		document.getElementById('oed-tLignesDEB').disabled = false;

		document.getElementById('oed-bcIntroduction').collapsed = (oed_typeDeclaration=="E");
		document.getElementById('oed-bcExpedition').collapsed = (oed_typeDeclaration=="I");
		document.getElementById('oed-colNumeroTVA').setAttribute("ignoreincolumnpicker", (oed_typeDeclaration=="I"));

		document.getElementById('oed-lblDepartement').value = (oed_typeDeclaration=="E"?"D\u00E9pt. exp\u00E9 :":"D\u00E9pt. dest. :");
		document.getElementById('oed-lblPaysDestProv').value = (oed_typeDeclaration=="E"?"Pays destination :":"Pays provenance :");
		document.getElementById('oed-colDepartement').setAttribute("label", (oed_typeDeclaration=="E"?"D\u00E9pt. exp\u00E9":"D\u00E9pt. dest."));
		document.getElementById('oed-colPaysDestProv').setAttribute("label", (oed_typeDeclaration=="E"?"Pays destination":"Pays provenance"));

		oed_setModified(false);

	} catch (e) {
		recup_erreur(e);
	}
}


function oed_chargerDEB() {
  try {

		document.getElementById('oed-deckDEB').selectedIndex = 0;
		document.getElementById('oed-tLignesDEB').disabled = true;

		var qLoad = new QueryHttp('Facturation/DEB/loadDeclarationDEB.tmpl');
		qLoad.setParam("Declaration_Id", oed_declarationId);
		var result = qLoad.execute();
		var contenu = result.responseXML.documentElement;

		oed_etatDEB = contenu.getAttribute("Etat");
		oed_mode = (oed_etatDEB=="N"?"M":"V");

		document.getElementById('oed-numero').value = contenu.getAttribute("Numero");
		document.getElementById('oed-typeDeclaration').value = contenu.getAttribute("Libelle_Type_Declaration");
		document.getElementById('oed-periodeRef').value = contenu.getAttribute("Periode_Ref");
		document.getElementById('oed-etat').value = contenu.getAttribute("Libelle_Etat");
		document.getElementById('oed-niveauObligation').value = contenu.getAttribute("Niveau_Obligation");
		document.getElementById('oed-refFichier').value = contenu.getAttribute("Ref_Fichier");
		document.getElementById('oed-commentaires').value = contenu.getAttribute("Commentaires");

		document.getElementById('oed-creation').setAttribute("label","D\u00E9claration cr\u00E9\u00E9e le "+ contenu.getAttribute('Date_Creation') +" par "+ contenu.getAttribute('Login_Creation'));
		document.getElementById('oed-modification').setAttribute("label","Derni\u00E8re modification le "+ contenu.getAttribute('Date_Maj') +" par "+ contenu.getAttribute('Login_Maj'));
		document.getElementById('oed-document').setAttribute("label","D\u00E9claration N\u00B0 "+ contenu.getAttribute('Numero'));

		oed_listerLignes();

		oed_typeDeclaration = contenu.getAttribute("Type_Declaration");
		oed_niveauObligation = contenu.getAttribute("Niveau_Obligation");

		var aCodesRegime = new Arbre("ComboListe/combo-debRegimes.tmpl", "oed-codeRegime");
		aCodesRegime.setParam("Type_Regime", (oed_typeDeclaration=="I"?0:1));
		aCodesRegime.initTree();

		oed_initIHM();

		oed_refreshTotaux();

	} catch (e) {
  	recup_erreur(e);
  }
}


function oed_listerLignes() {
	try {

		var nbLignesParPage = document.getElementById('oed-nbLignesParPage').value;

		oed_pageCourante = 1;
		oed_nbPages = 1;
		document.getElementById('oed-pageDeb').value = 1;
		document.getElementById('oed-pageFin').value = 1;
		document.getElementById('oed-bPrec').disabled = true;
		document.getElementById('oed-bSuiv').disabled = true;

		document.getElementById('oed-tLignesDEB').disabled = true;
		oed_aLignesDEB.deleteTree();

		oed_qListLD.setParam("Declaration_Id", oed_declarationId);
		oed_qListLD.setParam("Nb_Lignes_Par_Page", nbLignesParPage);
		oed_qListLD.setParam("Current_Page", oed_pageCourante);

		var result = oed_qListLD.execute();
		var contenu = result.responseXML.documentElement;

		oed_nbPages = contenu.getAttribute("Nb_Pages");
		var listLigneId = contenu.getAttribute("List_Ligne_Id");

		oed_aLignesDEB.setParam('Declaration_Id', oed_declarationId);
		oed_aLignesDEB.setParam("List_Ligne_Id", listLigneId);
		oed_aLignesDEB.initTree(oed_initPagination);

	} catch (e) {
		recup_erreur(e);
	}
}


function oed_initPagination() {
	try {

		document.getElementById('oed-pageDeb').value = oed_pageCourante;
		document.getElementById('oed-pageFin').value = (oed_nbPages>0?oed_nbPages:1);
		document.getElementById('oed-bPrec').disabled = (oed_pageCourante==1);
		document.getElementById('oed-bSuiv').disabled = (oed_pageCourante>=oed_nbPages); // peut se produire si oed_nbPages=0

		oed_afterMajPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function oed_pressOnPagePrec() {
	try {

		oed_pageCourante--;
		oed_majPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function oed_pressOnPageSuiv() {
	try {

		oed_pageCourante++;
		oed_majPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function oed_majPagination() {
	try {

		document.getElementById('oed-pageDeb').value = oed_pageCourante;
		document.getElementById('oed-bPrec').disabled = (oed_pageCourante==1);
		document.getElementById('oed-bSuiv').disabled = (oed_pageCourante==oed_nbPages);

		document.getElementById('oed-tLignesDEB').disabled = true;

		oed_qListLD.setParam("Current_Page", oed_pageCourante);
		var result = oed_qListLD.execute();
		var listLigneId = result.responseXML.documentElement.getAttribute("List_Ligne_Id");

		oed_aLignesDEB.setParam("List_Ligne_Id", listLigneId);
		oed_aLignesDEB.initTree(oed_afterMajPagination);

	} catch (e) {
		recup_erreur(e);
	}
}


function oed_afterMajPagination() {
	try {

		oed_currentIndex = 0;
		oed_annulerLigne();
		document.getElementById('oed-tLignesDEB').disabled = false;

	} catch (e) {
		recup_erreur(e);
	}
}


function oed_refreshTotaux() {
	try {

		var qTotaux = new QueryHttp('Facturation/DEB/getTotauxDEB.tmpl');
		qTotaux.setParam("Declaration_Id", oed_declarationId);
		var result = qTotaux.execute();
		var contenu = result.responseXML.documentElement;

		document.getElementById('oed-nbFactures').value = contenu.getAttribute("Nb_Factures");
		document.getElementById('oed-nbLignes').value = contenu.getAttribute("Nb_Lignes");
		document.getElementById('oed-valeurTotale').value = contenu.getAttribute("Valeur_Totale");
		document.getElementById('oed-masseTotale').value = contenu.getAttribute("Masse_Totale");

		oed_aTotauxPays.setParam("Declaration_Id", oed_declarationId);
		oed_aTotauxPays.initTree();

	} catch (e) {
		recup_erreur(e);
	}
}


function oed_enregistrerDEB(rafraichir) {
  try {

  	var ok = false;

		var commentaires = document.getElementById('oed-commentaires').value;
		var refFichier = document.getElementById('oed-refFichier').value;

		var qSave = new QueryHttp("Facturation/DEB/updateDeclarationDEB.tmpl");
		qSave.setParam("Declaration_Id", oed_declarationId);
		qSave.setParam("Commentaires", commentaires);
		qSave.setParam("Ref_Fichier", refFichier);

		var result = qSave.execute();

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}
		else {
			oed_setModified(false);
			ok = true;
		}

		return ok;

	} catch (e) {
  	recup_erreur(e);
  }
}


function oed_supprimerDEB() {
  try {

		if (window.confirm("Confirmez-vous la suppression de la d\u00E9claration ?")) {

			var qSup = new QueryHttp("Facturation/DEB/deleteDeclarationDEB.tmpl");
			qSup.setParam("Declaration_Id", oed_declarationId);
			var result = qSup.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				showMessage("La d\u00E9claration a \u00E9t\u00E9 supprim\u00E9e.");
				retourMenuDEB();
			}
		}

	} catch (e) {
  	recup_erreur(e);
  }
}


function oed_annulerLigne() {
	try {

		oed_aLignesDEB.clearSelection();
		oed_aLignesDEB.ensureRowIsVisible(oed_currentIndex);

		document.getElementById('oed-codeRegime').value = "";
		document.getElementById('oed-paysDestProv').value = "";
		document.getElementById('oed-departement').value = "";
		document.getElementById('oed-natureTransaction').value = "";
		document.getElementById('oed-modeTransport').value = "";
		document.getElementById('oed-numeroTVA').value = "";

		document.getElementById('oed-reference').value = "";
		document.getElementById('oed-designation').value = "";
		document.getElementById('oed-quantite').value = "";
		document.getElementById('oed-codeNC8').value = "";
		document.getElementById('oed-codeNGP').value = "";
		document.getElementById('oed-masseNette').value = "";
		document.getElementById('oed-valeurHT').value = "";
		document.getElementById('oed-paysOrigine').value = "";

		document.getElementById('oed-bSupprimer').disabled = true;
		document.getElementById('oed-bValiderDF').disabled = true;
		document.getElementById('oed-bValiderLF').disabled = true;

	} catch (e) {
		recup_erreur(e);
	}
}


function oed_validerLigneDF() {
	try {

		var codeRegime = document.getElementById('oed-codeRegime').value;
		var paysDestProv = document.getElementById('oed-paysDestProv').value;
		var departement = document.getElementById('oed-departement').value;
		var natureTransaction = document.getElementById('oed-natureTransaction').value;
		var modeTransport = document.getElementById('oed-modeTransport').value;
		var numeroTVA = document.getElementById('oed-numeroTVA').value;
		var factDebId = oed_aLignesDEB.getSelectedCellText('oed-colFactDebId');
		var assujettiTVA = oed_aLignesDEB.getSelectedCellText('oed-colAssujettiTVA')=="true";

		if (isEmpty(codeRegime)) { showWarning("Veuillez s\u00E9lectionner le code r\u00E9gime"); }
		else if (isEmpty(natureTransaction)) { showWarning("Veuillez s\u00E9lectionner la nature de la transaction"); }
		else if (isEmpty(modeTransport)) { showWarning("Veuillez s\u00E9lectionner le mode de transport"); }
		else if (isEmpty(paysDestProv)) { showWarning("Veuillez s\u00E9lectionner le pays de "+ (oed_typeDeclaration=="I"?"provenance":"destination")); }
		else if (oed_typeDeclaration=="E" && assujettiTVA && isEmpty(numeroTVA)) { showWarning("Num\u00E9ro TVA incorrect"); }
		else if ((oed_niveauObligation=="1" && isEmpty(departement)) || (!isEmpty(departement) && (!isDigitList(departement) || departement.length<2))) { showWarning("D\u00E9partement de "+ (oed_typeDeclaration=="I"?"destination":"provenance") +" incorrect"); }
		else {

			var qValider = new QueryHttp(oed_typeDeclaration=="I"?"Facturation/DEB/updateDebFactureIntroduction.tmpl":"Facturation/DEB/updateDebFactureExpedition.tmpl");
			qValider.setParam("Fact_Deb_Id", factDebId);
			qValider.setParam("Code_Regime", codeRegime);
			qValider.setParam("Pays_Dest_Prov", paysDestProv);
			qValider.setParam("Departement", departement);
			qValider.setParam("Nature_Transaction", natureTransaction);
			qValider.setParam("Mode_Transport", modeTransport);
			qValider.setParam("Numero_TVA", numeroTVA);

			var result = qValider.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				oed_aLignesDEB.initTree(oed_annulerLigne);
				oed_refreshTotaux();
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oed_validerLigneLF() {
	try {

		var quantite = document.getElementById('oed-quantite').value;
		var codeNC8 = document.getElementById('oed-codeNC8').value;
		var codeNGP = document.getElementById('oed-codeNGP').value;
		var masseNette = document.getElementById('oed-masseNette').value;
		var valeurHT = document.getElementById('oed-valeurHT').value;
		var paysOrigine = document.getElementById('oed-paysOrigine').value;
		var ligneDebId = oed_aLignesDEB.getSelectedCellText('oed-colLigneDebId');
		var oldNC8 = oed_aLignesDEB.getSelectedCellText('oed-colCodeNC8');
		var oldNGP = oed_aLignesDEB.getSelectedCellText('oed-colCodeNGP');
		var articleId = oed_aLignesDEB.getSelectedCellText('oed-colArticleId');

		if ((oed_niveauObligation=="1" && !isPositiveInteger(quantite)) || !isPositiveOrNullInteger(quantite)) { showWarning("Quantit\u00E9 incorrecte"); }
		else if (!isPositiveOrNullInteger(masseNette)) { showWarning("Masse nette incorrecte"); }
		else if ((oed_niveauObligation=="1" && !isPositiveInteger(valeurHT)) || !isPositiveOrNullInteger(valeurHT)) { showWarning("Valeur HT incorrecte"); }
		else if (isEmpty(paysOrigine)) { showWarning("Veuillez s\u00E9lectionner le pays d'origine"); }
		else if ((oed_niveauObligation=="1" && isEmpty(codeNC8)) || (!isEmpty(codeNC8) && (!isDigitList(codeNC8) || codeNC8.length<8))) { showWarning("Code NC8 incorrect"); }
		else if (!isEmpty(codeNGP) && (!isPositive(codeNGP))) { showWarning("Code NGP incorrect (valeur de 1 \u00E0 9)"); }
		else {

			var qValider = new QueryHttp(oed_typeDeclaration=="I"?"Facturation/DEB/updateDebLigneIntroduction.tmpl":"Facturation/DEB/updateDebLigneExpedition.tmpl");
			qValider.setParam("Ligne_Deb_Id", ligneDebId);
			qValider.setParam("Quantite", quantite);
			qValider.setParam("Code_NC8", codeNC8);
			qValider.setParam("Code_NGP", codeNGP);
			qValider.setParam("Masse_Nette", masseNette);
			qValider.setParam("Valeur_HT", valeurHT);
			qValider.setParam("Pays_Origine", paysOrigine);

			var result = qValider.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				oed_aLignesDEB.initTree(oed_annulerLigne);
				oed_refreshTotaux();
				oed_saveNC8NGP(articleId, oldNC8, oldNGP, codeNC8, codeNGP);
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oed_supprimerLigne() {
	try {

		if (oed_aLignesDEB.isSelected() && window.confirm("Confirmez-vous la suppression de ligne ?")) {
			var ligneDebId = oed_aLignesDEB.getSelectedCellText('oed-colLigneDebId');

			var qSup = new QueryHttp(oed_typeDeclaration=="I"?"Facturation/DEB/deleteDebLigneIntroduction.tmpl":"Facturation/DEB/deleteDebLigneExpedition.tmpl");
			qSup.setParam("Ligne_Deb_Id", ligneDebId);
			var result = qSup.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				oed_currentIndex--;
				oed_aLignesDEB.initTree(oed_annulerLigne);
				oed_refreshTotaux();
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oed_selectOnLignesDEB() {
	try {

		if (oed_mode!="V" && oed_aLignesDEB.isSelected()) {
			var i = oed_aLignesDEB.getCurrentIndex();
			oed_currentIndex = i;

			document.getElementById('oed-codeRegime').value = oed_aLignesDEB.getCellText(i,'oed-colCodeRegime');
			document.getElementById('oed-paysDestProv').value = oed_aLignesDEB.getCellText(i,'oed-colPaysDestProv');
			document.getElementById('oed-departement').value = oed_aLignesDEB.getCellText(i,'oed-colDepartement');
			document.getElementById('oed-natureTransaction').value = oed_aLignesDEB.getCellText(i,'oed-colNatureTransaction');
			document.getElementById('oed-modeTransport').value = oed_aLignesDEB.getCellText(i,'oed-colModeTransport');
			document.getElementById('oed-numeroTVA').value = oed_aLignesDEB.getCellText(i,'oed-colNumeroTVA');

			document.getElementById('oed-reference').value = oed_aLignesDEB.getCellText(i,'oed-colReference');
			document.getElementById('oed-designation').value = oed_aLignesDEB.getCellText(i,'oed-colDesignation');
			document.getElementById('oed-quantite').value = oed_aLignesDEB.getCellText(i,'oed-colQuantite');
			document.getElementById('oed-codeNC8').value = oed_aLignesDEB.getCellText(i,'oed-colCodeNC8');
			document.getElementById('oed-codeNGP').value = oed_aLignesDEB.getCellText(i,'oed-colCodeNGP');
			document.getElementById('oed-masseNette').value = oed_aLignesDEB.getCellText(i,'oed-colMasseNette');
			document.getElementById('oed-valeurHT').value = oed_aLignesDEB.getCellText(i,'oed-colValeurHT');
			document.getElementById('oed-paysOrigine').value = oed_aLignesDEB.getCellText(i,'oed-colPaysOrigine');

			document.getElementById('oed-capFacture').setAttribute("label", "Facture N\u00B0 "+ oed_aLignesDEB.getCellText(i,'oed-colNumFacture'));
			document.getElementById('oed-capLigne').setAttribute("label", "Ligne N\u00B0 "+ oed_aLignesDEB.getCellText(i,'oed-colNumLigne'));

			document.getElementById('oed-bSupprimer').disabled = false;
			document.getElementById('oed-bValiderDF').disabled = false;
			document.getElementById('oed-bValiderLF').disabled = false;
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oed_saveNC8NGP(articleId, oldNC8, oldNGP, codeNC8, codeNGP) {
  try {

		if (!isEmpty(articleId)) {
			var majNC8 = false;
			var majNGP = false;

			if ((isEmpty(oldNC8) && !isEmpty(codeNC8)) || (oldNC8!=codeNC8 && window.confirm("Le code NC8 a chang\u00E9. Voulez-vous enregistrer le nouveau code sur la fiche article ?"))) {
				majNC8 = true;
			}

			if ((isEmpty(oldNGP) && !isEmpty(codeNGP)) || (oldNGP!=codeNGP && window.confirm("Le code NGP a chang\u00E9. Voulez-vous enregistrer le nouveau code sur la fiche article ?"))) {
				majNGP = true;
			}

			if (majNC8 || majNGP) {
				var query = new QueryHttp("Facturation/DEB/saveNC8NGP.tmpl");
				query.setParam("Article_Id", articleId);
				if (majNC8) query.setParam("Code_NC8", codeNC8);
				if (majNGP) query.setParam("Code_NGP", codeNGP);

				var result = query.execute();

				var errors = new Errors(result);
				if (errors.hasNext()) {
					errors.show();
				}
			}
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oed_demandeEnregistrement() {
  try {

		if (oed_modified) {
			if (window.confirm("Voulez-vous enregistrer les modifications apport\u00E9es \u00E0 la d\u00E9claration ?")) {
				oed_enregistrerDEB(false);
			}
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oed_setModified(m) {
  try {

  	oed_modified = m;
		if (m) {
			document.getElementById('oed-capDEB').setAttribute('image', 'chrome://opensi/content/design/icones/modified.png');
			document.getElementById('oed-bValiderDEB').disabled = true;
		}
		else {
			document.getElementById('oed-capDEB').setAttribute('image', null);
			document.getElementById('oed-bValiderDEB').disabled = false;
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oed_validerDEB() {
  try {

		if (oed_aLignesDEB.nbLignes()==0) {
			showWarning("La d\u00E9claration ne contient aucune ligne.");
		}
  	else if (window.confirm("Confirmez-vous la validation de la d\u00E9claration ?")) {

			var qValider = new QueryHttp("Facturation/DEB/validDeclarationDEB.tmpl");
			qValider.setParam('Declaration_Id', oed_declarationId);
			var result = qValider.execute();
			var errors = new Errors(result);

			if (errors.hasNext()) {
				errors.show();
			}
			else {
				oed_chargerDEB();
			}
  	}

	} catch (e) {
    recup_erreur(e);
  }
}


function oed_annulerDEB() {
	try {

		if (window.confirm("Confirmez-vous l'annulation de la d\u00E9claration ?")) {
			var qAnnuler = new QueryHttp("Facturation/DEB/cancelDeclarationDEB.tmpl");
			qAnnuler.setParam('Declaration_Id', oed_declarationId);
			var result = qAnnuler.execute();
			var errors = new Errors(result);

			if (errors.hasNext()) {
				errors.show();
			}
			else {
				showMessage("La d\u00E9claration a \u00E9t\u00E9 annul\u00E9e.");
				oed_chargerDEB();
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oed_exportCSV() {
	try {

		var qExp = new QueryHttp("Facturation/DEB/csvLigneDEB.tmpl");
		qExp.setParam("Declaration_Id", oed_declarationId);

		var result = qExp.execute();
		var fichier = result.responseXML.documentElement.getAttribute('FichierCSV');

		var file = fileChooser("save", fichier);
		if (file!=null) {
			downloadFile(getDirBuffer()+ fichier, file);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oed_exportIntracom() {
	try {

		var qExp = new QueryHttp("Facturation/DEB/exportIntracom.tmpl");
		qExp.setParam("Declaration_Id", oed_declarationId);

		var result = qExp.execute();
		var fichier = result.responseXML.documentElement.getAttribute('FichierIntracom');

		var file = fileChooser("save", fichier);
		if (file!=null) {
			downloadFile(getDirBuffer()+ fichier, file);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oed_choixCodeNC8() {
  try {

		var url = "chrome://opensi/content/facturation/user/stocks/rech_code_nc8.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', oed_retourChoixCodeNC8);

	} catch (e) {
    recup_erreur(e);
  }
}


function oed_retourChoixCodeNC8(codeNC8) {
  try {

		document.getElementById('oed-codeNC8').value = codeNC8;

	} catch (e) {
    recup_erreur(e);
  }
}
