/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/


var oed_aLignes = new Arbre('Facturation/Devis/list-ligneDevis.tmpl', 'oed-articles');
var oed_aModesReglements = new Arbre('ComboListe/combo-modesReglement.tmpl', 'oed-modeReglement');
var oed_aModesExpedition = new Arbre('ComboListe/combo-modesExpedition.tmpl', 'oed-modeExpedition');
var oed_aResponsables = new Arbre("ComboListe/combo-responsables.tmpl","oed-Login_Resp");
var oed_aPolesActivite = new Arbre("ComboListe/combo-polesActivite.tmpl", "oed-poleActivite");
var oed_aVersion = new Arbre("Facturation/Devis/list-versionDevis.tmpl","oed-listeVersion");
var oed_aEtablissements = new Arbre('ComboListe/combo-etablissements.tmpl', 'oed-etablissement');
var oed_aCodesTVAFraisPort = new Arbre("ComboListe/combo-tauxTVA.tmpl", "oed-codeTVAFraisPort");
var oed_aLangues = new Arbre("ComboListe/combo-langues.tmpl", "oed-langueDefaut");
var oed_aListeHistorique = new Arbre("Facturation/Devis/list-historiqueDevis.tmpl", "oed-listeHistorique");
var oed_aSitesWeb = new Arbre("ComboListe/combo-sitesWeb.tmpl","oed-siteWeb");
var oed_aTarifsVente = new Arbre("ComboListe/combo-tarifsVente.tmpl", "oed-Tarif_Id");


var oed_devisId;
var oed_clientId = "";
var oed_etatDevis;
var oed_modeLigne;
var oed_mode;
var oed_modeTarif;
var oed_typeRistourne = 'P';
var oed_typeRemise = 'P';
var oed_typeRemiseFP = 'P';
var oed_editionTTC = false;
var oed_assujettiTVA = false;
var oed_tauxTVAPort;
var oed_codeTVAPort = "";
var oed_zoneUE = false;
var oed_modified = false;
var oed_chargerModeReg;
var oed_selModeExpedition;
var oed_chargerResponsable;
var oed_selPoleActivite;
var oed_selTarifVente;
var oed_curSiteWeb;
var oed_insertionLigneId = 0;
var oed_uniteDefaut;
var oed_defModeReglement;
var oed_defModeExpedition;
var oed_chargementEnCours = false;
var oed_currentIndex = 0;
var oed_toSelectLigne = null;
var oed_montantHT = 0;
var oed_montantTTC = 0;
var oed_curEtablissement;
var oed_codesTvaInactifs = "";
var oed_typeEditionPdf;
var oed_docIdPdf;
var oed_editionInit = false;
var oed_langueDefaut;
var oed_isDevisWeb;
var oed_actDevisWeb;
var oed_ligneId;
var oed_articleId;
var oed_typeLigne;
var oed_devisType;
var oed_prixId = "";
var oed_libelle = "";
var oed_modifElemFin;
var oed_nfmt = new NumberFormat("0.00", true);



function oed_init() {
  try {

		oed_modifElemFin = gProfil.isModifElemFinDV();

		document.getElementById('oed-rowFax').collapsed = !gConfig.isShowFax();

		document.getElementById('oed-symboleUniteVolume').value = gConfig.getSymboleUniteVolume();
		document.getElementById('oed-symboleUnitePoids').value = gConfig.getSymboleUnitePoids();

		oed_actDevisWeb = gConfig.isActDevisWeb();
		document.getElementById('oed-rowSiteWeb').collapsed = !oed_actDevisWeb;

		var act_code_stats = gConfig.isActCodeStats();
		oed_defModeReglement = gConfig.getDefModeReglementC();
		oed_uniteDefaut = gConfig.getUniteDefaut();
		oed_defModeExpedition = gConfig.getDefModeExpedition();

		if (!act_code_stats) {
			document.getElementById('oed-ColCode_Stats').collapsed = true;
			document.getElementById('oed-ColCode_Stats').setAttribute('ignoreincolumnpicker', true);
	  	document.getElementById('oed-Act_Code_Stats').collapsed = true;
		} else {
			document.getElementById('oed-labelRef').setAttribute('style', 'margin-left:0px');
			document.getElementById('oed-Reference').setAttribute('style', 'margin-left:0px');
		}

		var actUnites = gConfig.isActUnites();
		var actNbPieces = gConfig.isActNbPieces();

		if (!actUnites) {
			document.getElementById('oed-ColSymboleUnite').collapsed = true;
			document.getElementById('oed-ColSymboleUnite').setAttribute('ignoreincolumnpicker', true);
			document.getElementById('oed-fieldUnite').collapsed = true;
		}

		if (!actNbPieces) {
			document.getElementById('oed-ColNb_Pieces').collapsed = true;
			document.getElementById('oed-ColNb_Pieces').setAttribute('ignoreincolumnpicker', true);
			document.getElementById('oed-fieldNbPieces').collapsed = true;
		}

		oed_modeTarif = gConfig.getModeTarif();

		if (oed_modeTarif=='Q') {
			document.getElementById('oed-row_tarif').collapsed = true;
		}

		var qAttPrinc = new QueryHttp("Facturation/Commun/getAttributsPrincipaux.tmpl");
		var result = qAttPrinc.execute();

		var contenu = result.responseXML.documentElement;

		for (var i=1; i<=6; i++) {
			if (!isEmpty(contenu.getAttribute("Groupe_Id_"+ i))) {
				document.getElementById("oed-ColAttribut"+ i).setAttribute("label", contenu.getAttribute("Intitule_"+ i));
			}
			else {
				document.getElementById("oed-ColAttribut"+ i).collapsed = true;
				document.getElementById("oed-ColAttribut"+ i).setAttribute("ignoreincolumnpicker", true);
			}
		}

		var aUnite = new Arbre("ComboListe/combo-unitesVente.tmpl", "oed-Unite");
		aUnite.initTree(oed_initUnite);

		if (gReadOnly) {
			document.getElementById('oed-bAjouterLigne').collapsed = true;
			document.getElementById('oed-bMoveUp').collapsed = true;
			document.getElementById('oed-bMoveDown').collapsed = true;
			document.getElementById('oed-bMoveFirst').collapsed = true;
			document.getElementById('oed-bMoveLast').collapsed = true;
			document.getElementById('oed-bMultiSuppression').collapsed = true;
			document.getElementById('oed-gridLigneDevis').collapsed = true;
			document.getElementById('oed-tabDevis').setAttribute('tooltiptext', "Lecture seule");
		}

		if (!gAccesCoutAchat) {
			document.getElementById('oed-colPrixAchat').setAttribute("ignoreincolumnpicker", true);
			document.getElementById('oed-colTauxMarque').setAttribute("ignoreincolumnpicker", true);
			document.getElementById('oed-colTauxMarge').setAttribute("ignoreincolumnpicker", true);
			document.getElementById('oed-colMargeHT').setAttribute("ignoreincolumnpicker", true);
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oed_initUnite() {
	try {

    document.getElementById('oed-Unite').selectedIndex = 0;
  	var aPays = new Arbre("ComboListe/combo-pays.tmpl", "oed-Code_Pays_Fact");
		aPays.initTree(oed_initPaysFact);

	} catch (e) {
    recup_erreur(e);
  }
}


function oed_initPaysFact() {
	try {

		var aPaysEnvoi = new Arbre("ComboListe/combo-pays.tmpl", "oed-Code_Pays_Envoi");
		aPaysEnvoi.initTree(oed_initPaysEnvoi);

	} catch (e) {
    recup_erreur(e);
  }
}

function oed_initPaysEnvoi() {
	try {

		var aPaysLiv = new Arbre("ComboListe/combo-pays.tmpl", "oed-Code_Pays_Liv");
		aPaysLiv.initTree();

	} catch (e) {
    recup_erreur(e);
  }
}


function oed_chargerResponsables(selection) {
	try {

		oed_chargerResponsable = selection;
		oed_aResponsables.setParam("Selection", oed_chargerResponsable);
		oed_aResponsables.initTree(oed_initResponsable);

	} catch (e) {
		recup_erreur(e);
	}
}


function oed_initResponsable() {
  try {

		document.getElementById('oed-Login_Resp').value = oed_chargerResponsable;

	} catch (e) {
  	recup_erreur(e);
	}
}


function oed_chargerPolesActivite(selection) {
	try {

		oed_selPoleActivite = selection;
		oed_aPolesActivite.setParam("Selection", oed_selPoleActivite);
		oed_aPolesActivite.initTree(oed_initPoleActivite);

	} catch (e) {
		recup_erreur(e);
	}
}


function oed_initPoleActivite() {
  try {

		document.getElementById('oed-poleActivite').value = oed_selPoleActivite;

	} catch (e) {
  	recup_erreur(e);
	}
}


function oed_chargerSiteWeb(selection) {
	try {

		oed_curSiteWeb = selection;
		if (oed_actDevisWeb) {
			oed_aSitesWeb.setParam("Client_Id", (isEmpty(oed_clientId)?"0":oed_clientId));
		}
		oed_aSitesWeb.setParam("Selection", oed_curSiteWeb);
		oed_aSitesWeb.initTree(oed_initSiteWeb);

	} catch (e) {
		recup_erreur(e);
	}
}


function oed_initSiteWeb() {
  try {

		document.getElementById('oed-siteWeb').value = oed_curSiteWeb;

	} catch (e) {
  	recup_erreur(e);
	}
}


function oed_chargerEtablissement(selection) {
	try {

		oed_curEtablissement = selection;
		oed_aEtablissements.setParam("Selection", selection);
		oed_aEtablissements.initTree(oed_initEtablissement);

	} catch (e) {
		recup_erreur(e);
	}
}


function oed_initEtablissement() {
	try {

		document.getElementById('oed-etablissement').value = oed_curEtablissement;

	} catch (e) {
		recup_erreur(e);
	}
}


function oed_selectPaysLiv() {
	try {

		oed_listeTVA();
    oed_changerTypeVente();

	} catch (e) {
		recup_erreur(e);
	}
}


function oed_listeTVA() {
  try {

  	oed_calculTotaux();
    var aCode = new Arbre("ComboListe/combo-tauxTVA.tmpl", "oed-Code_TVA");
    aCode.setParam("Code_Pays", document.getElementById("oed-Code_Pays_Liv").value);
    aCode.setParam("Regime_TVA", document.getElementById("oed-Regime_TVA").value);
    aCode.setParam("Assujetti_TVA", oed_assujettiTVA);
		aCode.setParam("Selection", oed_codesTvaInactifs);
    aCode.initTree(oed_selectTVA);

  } catch (e) {
    recup_erreur(e);
  }
}


function oed_selectTVA() {
  try {

    document.getElementById('oed-Code_TVA').value = getCodeTvaNormal(document.getElementById('oed-Code_Pays_Liv').value,oed_assujettiTVA,document.getElementById("oed-Regime_TVA").value);

  } catch (e) {
    recup_erreur(e);
  }
}


function oed_listeTVAFraisPort() {
	try {

	  oed_aCodesTVAFraisPort.setParam("Code_Pays", document.getElementById("oed-Code_Pays_Liv").value);
	  oed_aCodesTVAFraisPort.setParam("Regime_TVA", document.getElementById("oed-Regime_TVA").value);
	  oed_aCodesTVAFraisPort.setParam("Assujetti_TVA", oed_assujettiTVA);
		oed_aCodesTVAFraisPort.setParam("Selection", oed_codeTVAPort);
	 	oed_aCodesTVAFraisPort.initTree(oed_finListeTVAFraisPort);

	} catch (e) {
	  recup_erreur(e);
	}
}


function oed_finListeTVAFraisPort() {
	try {

	  document.getElementById('oed-codeTVAFraisPort').value = getCodeTvaNormal(document.getElementById('oed-Code_Pays_Liv').value, oed_assujettiTVA, document.getElementById('oed-Regime_TVA').value);

	  oed_codeTVAPort = document.getElementById('oed-codeTVAFraisPort').value;
	  oed_tauxTVAPort = getTva(oed_codeTVAPort);

	} catch (e) {
	  recup_erreur(e);
	}
}


function oed_chargerModesReglements(selection) {
	try {

		oed_chargerModeReg = selection;
		oed_aModesReglements.setParam("Selection", oed_chargerModeReg);
		oed_aModesReglements.initTree(oed_initModeReglement);

	} catch (e) {
		recup_erreur(e);
	}
}


function oed_initModeReglement() {
	try {

    document.getElementById('oed-modeReglement').value = oed_chargerModeReg;
		oed_setModified(false);

	} catch (e) {
    recup_erreur(e);
  }
}


function oed_chargerModesExpedition(selection) {
	try {

		oed_selModeExpedition = selection;
		oed_aModesExpedition.setParam("Selection", selection);
		oed_aModesExpedition.initTree(oed_initModeExpedition);

	} catch (e) {
		recup_erreur(e);
	}
}


function oed_initModeExpedition() {
	try {

    document.getElementById('oed-modeExpedition').value = oed_selModeExpedition;
		oed_setModified(false);

	} catch (e) {
    recup_erreur(e);
  }
}


function oed_switchRistourne() {
	try {

		if (oed_typeRistourne=='P') {
			document.getElementById('oed-bRistourne').setAttribute("class", "bIcoEuro");
			oed_typeRistourne = 'M';
		}
		else {
			document.getElementById('oed-bRistourne').setAttribute("class", "bIcoPourcentage");
			oed_typeRistourne = 'P';
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oed_switchRemise() {
	try {

		if (oed_typeRemise=='P') {
			document.getElementById('oed-bRemise').setAttribute("class", "bIcoEuro");
			oed_typeRemise = 'M';
		}
		else {
			document.getElementById('oed-bRemise').setAttribute("class", "bIcoPourcentage");
			oed_typeRemise = 'P';
		}
		oed_calculTotaux();
		oed_setModified(true);

	} catch (e) {
    recup_erreur(e);
  }
}


function oed_switchRemiseFP() {
	try {

		if (oed_typeRemiseFP=='P') {
			document.getElementById('oed-bRemiseFP').setAttribute("class", "bIcoEuro");
			oed_typeRemiseFP = 'M';
		}
		else {
			document.getElementById('oed-bRemiseFP').setAttribute("class", "bIcoPourcentage");
			oed_typeRemiseFP = 'P';
		}
		oed_calculTotaux();
		oed_setModified(true);

	} catch (e) {
    recup_erreur(e);
  }
}


function oed_afficherFichiers() {
	try {

    var ok = true;
		if (oed_mode=="C") {
			ok = oed_enregistrerDevis();
		}

		if (ok) {
  	  var url = "chrome://opensi/content/facturation/user/commun/popup-fichiersAssocies.xul";
    	window.openDialog(url,'','chrome,modal,centerscreen', "DC", oed_devisId, gReadOnly);
    }

	} catch (e) {
    recup_erreur(e);
  }
}


function oed_ajouterLigne(typeLigne, articleId) {
  try {

		document.getElementById('oed-bSupprimer').disabled = true;
		document.getElementById('oed-bMoveUp').disabled = true;
		document.getElementById('oed-bMoveDown').disabled = true;
		document.getElementById('oed-bMoveFirst').disabled = true;
		document.getElementById('oed-bMoveLast').disabled = true;
		document.getElementById('oed-bMultiSuppression').disabled = true;
		document.getElementById('oed-bCommentaire').disabled = true;

		oed_modeLigne = "C";
		oed_typeLigne = typeLigne;
		oed_ligneId = "";

		oed_formatLigne(typeLigne);
		var codePaysLiv = document.getElementById('oed-Code_Pays_Liv').value;
		var regimeTVA = document.getElementById('oed-Regime_TVA').value;

		if (typeLigne=="S") {
			oed_articleId = articleId;

			if (oed_modeTarif=='Q') {
				var url = "chrome://opensi/content/facturation/user/commun/popup-choixTarif.xul";
    		window.openDialog(url,'','chrome,modal,centerscreen', oed_retourChoixPrixQuantite, articleId);

				if (!isEmpty(oed_prixId)) {
					var qGet = new QueryHttp("Facturation/Articles/getInfosArticleQuantite.tmpl");
        	qGet.setParam("Article_Id", articleId);
        	qGet.setParam("Prix_Id", oed_prixId);
					qGet.setParam("TTC", oed_editionTTC);
					var result = qGet.execute();

					var contenu = result.responseXML.documentElement;
					document.getElementById("oed-Code_Stats").value = contenu.getAttribute("Code_Stats");
					document.getElementById("oed-Designation").value = contenu.getAttribute("Designation");
					document.getElementById("oed-Nb_Pieces").value = "";
					document.getElementById('oed-Quantite').value = contenu.getAttribute("Quantite");
					document.getElementById('oed-Unite').value = contenu.getAttribute("Unite_Id");
					document.getElementById("oed-PU").value = contenu.getAttribute("Prix_Unitaire");
					document.getElementById('oed-Ristourne').value = "0.00";
					document.getElementById("oed-Code_TVA").value = getCodeTvaCorrespondant(contenu.getAttribute("Code_TVA"), codePaysLiv, oed_assujettiTVA, regimeTVA);
					oed_prixId = "";
					oed_libelle = contenu.getAttribute("Libelle");
				}
				else {
					oed_ajouterLigne("I");
				}
			}
			else {
				var qGet = new QueryHttp("Facturation/Articles/getInfosArticleVente.tmpl");
        qGet.setParam("Article_Id", articleId);
        qGet.setParam("Tarif_Id", document.getElementById('oed-Tarif_Id').value);
				qGet.setParam("TTC", oed_editionTTC);
				qGet.setParam("Client_Id", oed_clientId);
				var result = qGet.execute();

				var contenu = result.responseXML.documentElement;
				document.getElementById("oed-Code_Stats").value = contenu.getAttribute("Code_Stats");
				document.getElementById("oed-Designation").value = contenu.getAttribute("Designation");
				document.getElementById("oed-Nb_Pieces").value = "";
				document.getElementById('oed-Quantite').value = 1;
				document.getElementById('oed-Unite').value = contenu.getAttribute("Unite_Id");
				document.getElementById("oed-PU").value = contenu.getAttribute("Prix_Unitaire");
				document.getElementById('oed-Ristourne').value = contenu.getAttribute("Ristourne");
				document.getElementById("oed-Code_TVA").value = getCodeTvaCorrespondant(contenu.getAttribute("Code_TVA"), codePaysLiv, oed_assujettiTVA, regimeTVA);
				oed_libelle = "";
			}
		}
		else {
			oed_articleId = "";
			document.getElementById('oed-Code_Stats').value = "";
			document.getElementById('oed-Reference').value = "";
			document.getElementById('oed-Designation').value = "";
			document.getElementById("oed-Nb_Pieces").value = "";
			document.getElementById('oed-Quantite').value = 1;
			document.getElementById('oed-Unite').value = oed_uniteDefaut;
			document.getElementById('oed-PU').value = "";
			document.getElementById('oed-Ristourne').value = "0.00";
			document.getElementById('oed-Code_TVA').value = getCodeTvaNormal(codePaysLiv, oed_assujettiTVA, regimeTVA);
			oed_libelle = "";
			document.getElementById('oed-Reference').focus();
			oed_insertionLigneId = 0;
			document.getElementById('oed-bAjouterLigne').disabled = true;
			document.getElementById('oed-Act_Insert').collapsed = true;
			oed_aLignes.setCellSrc(oed_currentIndex, 'oed-ColReference', "");
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oed_formatLigne(typeLigne) {
  try {

		switch(typeLigne) {
			case "S":
				document.getElementById('oed-Code_Stats').disabled = false;
				document.getElementById('oed-Reference').disabled = true;
				document.getElementById('oed-Designation').disabled = true;
				document.getElementById('oed-Nb_Pieces').disabled = false;
				document.getElementById('oed-Quantite').disabled = false;
				document.getElementById('oed-Unite').disabled = false;
				document.getElementById('oed-PU').disabled = !oed_modifElemFin;
				document.getElementById('oed-Ristourne').disabled = !oed_modifElemFin;
				document.getElementById('oed-bRistourne').disabled = !oed_modifElemFin;
				document.getElementById('oed-Code_TVA').disabled = !oed_modifElemFin;
				document.getElementById('oed-bValider').disabled = false;
				document.getElementById('oed-bAnnuler').disabled = false;
				break;

			case "I":
				document.getElementById('oed-Code_Stats').disabled = false;
				document.getElementById('oed-Reference').disabled = false;
				document.getElementById('oed-Designation').disabled = false;
				document.getElementById('oed-Nb_Pieces').disabled = false;
				document.getElementById('oed-Quantite').disabled = false;
				document.getElementById('oed-Unite').disabled = false;
				document.getElementById('oed-PU').disabled = !oed_modifElemFin;
				document.getElementById('oed-Ristourne').disabled = !oed_modifElemFin;
				document.getElementById('oed-bRistourne').disabled = !oed_modifElemFin;
				document.getElementById('oed-Code_TVA').disabled = !oed_modifElemFin;
				document.getElementById('oed-bValider').disabled = false;
				document.getElementById('oed-bAnnuler').disabled = false;
				break;

			default:
				document.getElementById('oed-Code_Stats').value = "";
				document.getElementById('oed-Reference').value = "";
				document.getElementById('oed-Designation').value = "";
				document.getElementById('oed-Nb_Pieces').value = "";
				document.getElementById('oed-Quantite').value = "";
				document.getElementById('oed-Unite').value = oed_uniteDefaut;
				document.getElementById('oed-PU').value = "";
				document.getElementById('oed-Ristourne').value = "";
				oed_libelle = "";
				oed_ligneId = "";
				document.getElementById('oed-Code_TVA').value = getCodeTvaNormal(document.getElementById("oed-Code_Pays_Liv").value,oed_assujettiTVA,document.getElementById('oed-Regime_TVA').value);
				document.getElementById('oed-Code_Stats').disabled = true;
				document.getElementById('oed-Reference').disabled = true;
				document.getElementById('oed-Designation').disabled = true;
				document.getElementById('oed-Nb_Pieces').disabled = true;
				document.getElementById('oed-Quantite').disabled = true;
				document.getElementById('oed-Unite').disabled = true;
				document.getElementById('oed-PU').disabled = true;
				document.getElementById('oed-Ristourne').disabled = true;
				document.getElementById('oed-bRistourne').disabled = true;
				document.getElementById('oed-Code_TVA').disabled = true;
				document.getElementById('oed-bSupprimer').disabled = true;
				document.getElementById('oed-bMoveUp').disabled = true;
				document.getElementById('oed-bMoveDown').disabled = true;
				document.getElementById('oed-bMoveFirst').disabled = true;
				document.getElementById('oed-bMoveLast').disabled = true;
				document.getElementById('oed-bMultiSuppression').disabled = true;
				document.getElementById('oed-bCommentaire').disabled = true;
				document.getElementById('oed-bValider').disabled = true;
				document.getElementById('oed-bAnnuler').disabled = true;
				break;
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oed_pressOnWindow(ev) {
	try {

		if (ev.altKey && oed_mode!="V") {
			switch(ev.charCode) {
      	case 97: // 'a'
				case 65: // 'A'
					oed_rechercherArticle();
        	break;
				case 116: // 't'
					oed_modifierTarif();
					break;
    	}
		}
		else if (ev.ctrlKey && oed_mode!="V") {
			if (ev.keyCode==46) {
				// ctrl + suppr
				ev.preventDefault();
				oed_supprimerLigne();
			}
			else if (ev.charCode==114 || ev.charCode==82) {
				// ctrl + r (ou R)
				ev.preventDefault();
				oed_appliquerRistourne();
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oed_pressOnReference(ev) {
	try {

		if (ev.keyCode==13) {
			oed_rechercherReference();
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oed_rechercherArticle(reference) {
	try {

		var url = "chrome://opensi/content/facturation/user/articles/popup-rechercheArticle.xul";
		var tarifId = (oed_modeTarif!="Q"?document.getElementById('oed-Tarif_Id').value:null);
		var multiSel = (oed_modeTarif!="Q"?true:null);
    window.openDialog(url,'','chrome,modal,centerscreen', oed_retourRechercherArticle, "V", reference, tarifId, null, null, null, oed_clientId, multiSel);

	} catch (e) {
    recup_erreur(e);
  }
}


function oed_retourRechercherArticle(reference, articleId, listArticleId) {
	try {

		if (articleId!=null) {
			document.getElementById('oed-Reference').value = reference;
			document.getElementById('oed-Quantite').focus();
			oed_ajouterLigne("S", articleId);
		}
		else {
			oed_ajouterMulti(listArticleId);
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oed_rechercherReference() {
	try {

		var reference = document.getElementById('oed-Reference').value;

		var qSearch = new QueryHttp("Facturation/Articles/searchReference.tmpl");
		qSearch.setParam("Reference", reference);
		qSearch.setParam("Vente_Achat", "V");
		var result = qSearch.execute();

		var articleId = result.responseXML.documentElement.getAttribute("Article_Id");
		if (!isEmpty(articleId)) {
			document.getElementById('oed-Reference').value = result.responseXML.documentElement.getAttribute("Reference");
			document.getElementById('oed-Quantite').focus();
			oed_ajouterLigne("S", articleId);
		}
		else {
			oed_rechercherArticle(reference);
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oed_ajouterMulti(listArticleId) {
	try {

		var ok = true;

		if (oed_mode=="C") {
			ok = oed_enregistrerDevis();
		}

		if (ok) {
			var qAdd = new QueryHttp("Facturation/Devis/addLigneDevis.tmpl");
			qAdd.setParam("List_Article_Id", listArticleId);
			qAdd.setParam("Devis_Id", oed_devisId);
			qAdd.execute();

			oed_calculerPoids();
			oed_ajouterLigne("I");
			oed_aLignes.initTree(oed_afterRefreshArticles);
		}

	} catch (e) {
		recup_erreur(e);
  }
}


function oed_modifierTarif() {
	try {

		if (oed_modeLigne=="M" && oed_typeLigne=='S' && oed_modeTarif=='Q') {

			var url = "chrome://opensi/content/facturation/user/commun/popup-choixTarif.xul";
    	window.openDialog(url,'','chrome,modal,centerscreen', oed_retourChoixPrixQuantite, oed_articleId);

			if (!isEmpty(oed_prixId)) {
				var qGet = new QueryHttp("Facturation/Articles/getInfosArticleQuantite.tmpl");
        qGet.setParam("Article_Id", oed_articleId);
        qGet.setParam("Prix_Id", oed_prixId);
				qGet.setParam("TTC", oed_editionTTC);
				var result = qGet.execute();

				var contenu = result.responseXML.documentElement;
				document.getElementById('oed-Quantite').value = contenu.getAttribute("Quantite");
				document.getElementById('oed-Unite').value = contenu.getAttribute("Unite_Id");
				document.getElementById("oed-PU").value = contenu.getAttribute("Prix_Unitaire");
				oed_prixId = "";
				oed_libelle = contenu.getAttribute("Libelle");
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oed_retourChoixPrixQuantite(prixId) {
	try {

		oed_prixId = prixId;

	} catch (e) {
		recup_erreur(e);
	}
}


function oed_ouvrirLigne() {
  try {

		if (oed_aLignes.isSelected() && oed_mode=="M") {

			if (oed_aLignes.nbSelection()==1) {
				var i = oed_aLignes.getCurrentIndex();
				oed_aLignes.setCellSrc(i, 'oed-ColReference', "");
				oed_currentIndex = i;
				document.getElementById('oed-bMultiSuppression').disabled = true;

				if (oed_aLignes.getCellText(i,'oed-colTypeLigne')=="C") {
					oed_ajouterLigne("I");
				}
				else {
					document.getElementById('oed-bAjouterLigne').disabled = false;
					oed_insertionLigneId = 0;
					document.getElementById('oed-Act_Insert').collapsed = true;

					oed_modeLigne = "M";
					document.getElementById('oed-bSupprimer').disabled = false;
					document.getElementById('oed-bCommentaire').disabled = false;

					document.getElementById("oed-Code_Stats").value = oed_aLignes.getCellText(i,'oed-ColCode_Stats');
					document.getElementById("oed-Reference").value = oed_aLignes.getCellText(i,'oed-ColReference');
					document.getElementById("oed-Designation").value = oed_aLignes.getCellText(i,'oed-ColDesignation');
					document.getElementById("oed-Nb_Pieces").value = oed_aLignes.getCellText(i,'oed-ColNb_Pieces');
					document.getElementById("oed-Quantite").value = oed_aLignes.getCellText(i,'oed-ColQuantite');
					document.getElementById("oed-Unite").value = oed_aLignes.getCellText(i,'oed-ColUnite');
					document.getElementById("oed-PU").value = oed_aLignes.getCellText(i,'oed-ColPU');
					document.getElementById("oed-Code_TVA").value = oed_aLignes.getCellText(i,'oed-ColCode_TVA');
					document.getElementById("oed-Ristourne").value = oed_aLignes.getCellValue(i,'oed-ColRistourne');
					oed_typeRistourne = oed_aLignes.getSelectedCellText('oed-colTypeRistourne');
					document.getElementById('oed-bRistourne').setAttribute("class", (oed_typeRistourne=='P'?"bIcoPourcentage":"bIcoEuro"));
					oed_typeLigne = oed_aLignes.getCellText(i,'oed-colTypeLigne');
					oed_ligneId = oed_aLignes.getCellText(i,'oed-colLigneId');
					oed_articleId = oed_aLignes.getCellText(i,'oed-colArticleId');
					oed_libelle = oed_aLignes.getCellText(i,'oed-ColLibelle');

					// on ignore les lignes de commentaires
					var firstIndex = 0;
					var lastIndex = oed_aLignes.nbLignes()-1;
					if (oed_aLignes.getCellText(firstIndex,'oed-colTypeLigne')=="C") { firstIndex++; }
					if (oed_aLignes.getCellText(lastIndex,'oed-colTypeLigne')=="C") { lastIndex--; }

					document.getElementById('oed-bMoveUp').disabled = (i==firstIndex);
					document.getElementById('oed-bMoveDown').disabled = (i==lastIndex);
					document.getElementById('oed-bMoveFirst').disabled = (i==firstIndex);
					document.getElementById('oed-bMoveLast').disabled = (i==lastIndex);

					oed_formatLigne(oed_typeLigne);
				}
			}
			else {
				oed_ajouterLigne("I");
				document.getElementById('oed-bMultiSuppression').disabled = false;
			}
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oed_ajouterLigneAvant() {
  try {

		if (oed_aLignes.isSelected() && oed_mode=="M") {
			var idx = oed_aLignes.getCurrentIndex();
			oed_currentIndex = idx;
			var ligneId = oed_aLignes.getCellText(idx,'oed-colLigneId');
			oed_annulerLigne();

			oed_aLignes.setCellSrc(idx, 'oed-ColReference', "chrome://opensi/content/design/insertbefore.png");

			oed_insertionLigneId = ligneId;

			document.getElementById('oed-Act_Insert').collapsed = false;
			document.getElementById('oed-Reference').focus();
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oed_pressOnLigneDevis(event) {
	try {

		if (event.keyCode==45 && event.ctrlKey) {
			// ctrl + inser
			// insrer une ligne avant

			oed_ajouterLigneAvant();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oed_ouvrirCommentaire() {
  try {

		if (oed_aLignes.isSelected() && oed_mode=="M") {
			var i = oed_aLignes.getCurrentIndex();
			if (oed_aLignes.getCellText(i,'oed-colTypeLigne')=="C") {
				oed_editerCommentaire();
			}
			else {
				oed_editerPrixAchat();
			}
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oed_deplacerLigne(moveType) {
	try {

		if (oed_aLignes.isSelected() && oed_aLignes.getSelectedCellText('oed-colTypeLigne')!="C" && oed_mode=="M"
				&& (!oed_devisType || oed_etatDevis=='N' || window.confirm("ATTENTION : Devis type !\nConfirmez-vous la modification du devis ?"))) {

			document.getElementById('oed-bMoveUp').disabled = true;
			document.getElementById('oed-bMoveDown').disabled = true;
			document.getElementById('oed-bMoveFirst').disabled = true;
			document.getElementById('oed-bMoveLast').disabled = true;

			var qMove = new QueryHttp("Facturation/Devis/moveLigneDevis.tmpl");
			qMove.setParam("Ligne_Id", oed_ligneId);
			qMove.setParam("Move_Type", moveType);
			var result = qMove.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				oed_toSelectLigne = oed_ligneId;
				oed_ajouterLigne("I");
				oed_aLignes.initTree(oed_afterRefreshArticles);
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oed_validerLigne() {
  try {

		var code_stats = document.getElementById("oed-Code_Stats").value;
		var reference = document.getElementById("oed-Reference").value;
		var designation = document.getElementById("oed-Designation").value;
		var nb_pieces = document.getElementById("oed-Nb_Pieces").value;
		var quantite = document.getElementById("oed-Quantite").value;
		var unite = document.getElementById("oed-Unite").value;
		var prixUnitaire = document.getElementById("oed-PU").value;
		var ristourne = document.getElementById("oed-Ristourne").value;
		var code_tva = document.getElementById("oed-Code_TVA").value;
		var ok = true;

		if (isEmpty(nb_pieces)) {
			nb_pieces = 0;
		}

		var typeLigne = oed_typeLigne; // sauvegarde si article ajout avant enregistrement pour le recalcul du poids
		if (oed_mode=="C") {
			ok = oed_enregistrerDevis();
		}

		if (ok) {

			if (isEmpty(designation)) { showWarning("D\u00E9signation de l'article manquante"); }
			else if (!checkQte(quantite)) { showWarning("Quantit\u00E9 incorrecte");	}
			else if (!isPositiveOrNullInteger(nb_pieces)) { showWarning("Nombre de pi\u00E8ces incorrect");	}
			else if (isEmpty(prixUnitaire) || !isPositiveOrNull(prixUnitaire) || !checkDecimal(prixUnitaire,4)) { showWarning("Prix unitaire incorrect");	}
			else if (isEmpty(ristourne) || (oed_typeRistourne=='P'?!isTaux(ristourne):!isPositiveOrNull(ristourne) || !checkNumber(ristourne,9,2) || parseFloat(ristourne)>parseFloat(prixUnitaire))) { showWarning("Ristourne incorrecte"); }
			else if (!oed_devisType || oed_etatDevis=='N' || window.confirm("ATTENTION : Devis type !\nConfirmez-vous la modification du devis ?")) {

				if (oed_modeLigne=="C" && oed_insertionLigneId==0) {
					oed_currentIndex = oed_aLignes.nbLignes();
				}

				var qSave;

				if (oed_modeLigne=="C") {
					qSave = new QueryHttp("Facturation/Devis/createLigneDevis.tmpl");
					qSave.setParam("Devis_Id", oed_devisId);
				}
				else {
					qSave = new QueryHttp("Facturation/Devis/updateLigneDevis.tmpl");
					qSave.setParam("Ligne_Id", oed_ligneId);
				}

				qSave.setParam("Reference", reference);
				qSave.setParam("Designation", designation);
				qSave.setParam("Nb_Pieces", nb_pieces);
				qSave.setParam("Quantite", quantite);
				qSave.setParam("Unite", unite);
				qSave.setParam("Prix", prixUnitaire);
				qSave.setParam("Ristourne", ristourne);
				qSave.setParam("Type_Ristourne", oed_typeRistourne);
				qSave.setParam("Code_TVA", code_tva);
				qSave.setParam("Libelle", oed_libelle);
				qSave.setParam("Code_Stats", code_stats);
				qSave.setParam("Insertion_Ligne_Id", oed_insertionLigneId);

				var result = qSave.execute();

				var errors = new Errors(result);
				if (errors.hasNext()) {
					errors.show();
				}
				else {
					if (typeLigne=='S') {
						oed_calculerPoids();
					}
					oed_ajouterLigne("I");
					oed_aLignes.initTree(oed_afterRefreshArticles);
				}
			}
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oed_annulerLigne() {
  try {

  	oed_aLignes.clearSelection();
		oed_ajouterLigne("I");

	} catch (e) {
  	recup_erreur(e);
	}
}


function oed_supprimerLigne() {
  try {

		if (!oed_devisType || oed_etatDevis=='N' || window.confirm("ATTENTION : Devis type !\nConfirmez-vous la modification du devis ?")) {

			var listLigneId = "";
			var maxIndex = 0;

			if (!isEmpty(oed_ligneId)) {
				listLigneId = oed_ligneId;
				maxIndex = oed_currentIndex;
			}
			else {
				var start = new Object();
				var end = new Object();
				var numRanges = oed_aLignes.getRangeCount();

				for (var t=0; t<numRanges; t++){
					oed_aLignes.getRangeAt(t,start,end);
			  	for (var v=start.value; v<=end.value; v++){
						if (oed_aLignes.getCellText(v,'oed-colTypeLigne')!="C") {
			  			listLigneId += oed_aLignes.getCellText(v,'oed-colLigneId')+",";
							if (v>maxIndex) maxIndex = v;
						}
			  	}
				}
			}

			if (!isEmpty(listLigneId)) {
				var qDelete = new QueryHttp("Facturation/Devis/deleteLigneDevis.tmpl");
				qDelete.setParam('List_Ligne_Id', listLigneId);
				var result = qDelete.execute();

				var errors = new Errors(result);
				if (errors.hasNext()) {
					errors.show();
				}
				else {
					oed_currentIndex = maxIndex-1;
					oed_calculerPoids();
					oed_ajouterLigne("I");
					oed_aLignes.initTree(oed_afterRefreshArticles);
				}
			}
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oed_appliquerRistourne() {
	try {

		if (!oed_devisType || oed_etatDevis=='N' || window.confirm("ATTENTION : Devis type !\nConfirmez-vous la modification du devis ?")) {

			var listLigneId = "";
			var maxIndex = 0;

			if (oed_aLignes.isSelected()) {
				var start = new Object();
				var end = new Object();
				var numRanges = oed_aLignes.getRangeCount();

				for (var t=0; t<numRanges; t++){
					oed_aLignes.getRangeAt(t,start,end);
			  	for (var v=start.value; v<=end.value; v++){
						if (oed_aLignes.getCellText(v,'oed-colTypeLigne')!="C") {
			  			listLigneId += oed_aLignes.getCellText(v,'oed-colLigneId')+",";
							if (v>maxIndex) maxIndex = v;
						}
			  	}
				}
			}

			if (!isEmpty(listLigneId)) {
				var url = "chrome://opensi/content/facturation/user/commun/popup-applicationRistourne.xul";
				window.openDialog(url,'','chrome,modal,centerscreen', "DC", listLigneId);

				oed_currentIndex = maxIndex;
				oed_ajouterLigne("I");
				oed_aLignes.initTree(oed_afterRefreshArticles);
			}
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oed_transAffaire() {
  try {

		var montantBase = (oed_editionTTC?oed_montantTTC:oed_montantHT);
		var remise = document.getElementById('oed-Remise').value;

		if (oed_aLignes.nbLignes()<=0) {
			showWarning("Le devis ne contient aucune ligne !");
		}
		else if (isEmpty(remise) || (oed_typeRemise=='P'?!isTaux(remise):!isPositiveOrNull(remise) || !checkNumber(remise,9,2) || parseFloat(remise)>montantBase)) {
			showWarning("Remise incorrecte !");
		}
		else {
			if (window.confirm("Etes-vous s\u00FBr de vouloir passer le devis en affaire ?")) {

				var qTrans = new QueryHttp("Facturation/Devis/transDevisAffaire.tmpl");
				qTrans.setParam("Devis_Id", oed_devisId);

				var result = qTrans.execute();

				var errors = new Errors(result);
				if (errors.hasNext()) {
					errors.show();
				}
				else {
					var affaireId = result.responseXML.documentElement.getAttribute("Affaire_Id");
    			window.location = "chrome://opensi/content/facturation/user/affaires/gestionAffaires.xul?Affaire_Id="+ affaireId;
				}
			}
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oed_transFacture() {
  try {

		var montantBase = (oed_editionTTC?oed_montantTTC:oed_montantHT);
		var remise = document.getElementById('oed-Remise').value;

		if (oed_aLignes.nbLignes()<=0) {
			showWarning("Le devis ne contient aucune ligne !");
		}
		else if (isEmpty(remise) || (oed_typeRemise=='P'?!isTaux(remise):!isPositiveOrNull(remise) || !checkNumber(remise,9,2) || parseFloat(remise)>montantBase)) {
			showWarning("Remise incorrecte !");
		}
		else {
			if (window.confirm("Etes-vous s\u00FBr de vouloir passer le devis en facture express ?")) {

				var qTrans = new QueryHttp("Facturation/Devis/transDevisFacture.tmpl");
				qTrans.setParam("Devis_Id", oed_devisId);

				var result = qTrans.execute();

				var errors = new Errors(result);
				if (errors.hasNext()) {
					errors.show();
				}
				else {
					var factureId = result.responseXML.documentElement.getAttribute("Facture_Id");
    			window.location = "chrome://opensi/content/facturation/user/factures_vente/gestionFactures.xul?Facture_Id="+ factureId;
				}
			}
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oed_enregistrerDevis() {
  try {

		var save = false;

		var remise = document.getElementById('oed-Remise').value;
		var remiseFP = document.getElementById('oed-RemiseFP').value;
		var taux_remise = 0;
		var montant_remise = 0;
		var tauxRemiseFP = 0;
		var montantRemiseFP = 0;
		var modeReglement = document.getElementById('oed-modeReglement').value;
		var modeExpedition = document.getElementById('oed-modeExpedition').value;
		var frais_port = document.getElementById('oed-Frais_Port').value;
		var escompte = document.getElementById('oed-Escompte').value;
		var date_exp = document.getElementById('oed-Date_Exp').value;
		var denomination_fact = document.getElementById('oed-Denomination_Fact').value;
		var adresse_1_fact = document.getElementById('oed-Adresse_1_Fact').value;
		var adresse_2_fact = document.getElementById('oed-Adresse_2_Fact').value;
		var adresse_3_fact = document.getElementById('oed-Adresse_3_Fact').value;
		var code_postal_fact = document.getElementById('oed-Code_Postal_Fact').value;
		var ville_fact = document.getElementById('oed-Ville_Fact').value;
		var code_pays_fact = document.getElementById('oed-Code_Pays_Fact').value;
		var util_R = document.getElementById('oed-Login_Resp').value;
		var intitule = document.getElementById('oed-intitule').value;
		var poleActivite = document.getElementById('oed-poleActivite').value;
		var etablissement = document.getElementById('oed-etablissement').value;
		var siteWebId = document.getElementById('oed-siteWeb').value;
		var editionTTC = document.getElementById('oed-Edition_TTC').checked;
		var tarifId = document.getElementById('oed-Tarif_Id').value;
		var regimeTVA = document.getElementById('oed-Regime_TVA').value;
		var devisType = document.getElementById('oed-devisType').checked;
		var commentairesFin = document.getElementById('oed-Commentaires_Fin').value;
		var commentairesInt = document.getElementById('oed-Commentaires_Int').value;

		var civ_inter_fact = document.getElementById("oed-Civ_Inter_Fact").value;
		var nom_inter_fact = document.getElementById("oed-Nom_Inter_Fact").value;
		var prenom_inter_fact = document.getElementById("oed-Prenom_Inter_Fact").value;
		var telInter1fact = document.getElementById("oed-Tel_Inter_1_Fact").value;
		var telInter2fact = document.getElementById("oed-Tel_Inter_2_Fact").value;
		var fax_inter_fact = document.getElementById('oed-Fax_Inter_Fact').value;
		var email_inter_fact = document.getElementById('oed-Email_Inter_Fact').value;

		var denomination_liv = document.getElementById('oed-Denomination_Liv').value;
		var adresse_1_liv = document.getElementById('oed-Adresse_1_Liv').value;
		var adresse_2_liv = document.getElementById('oed-Adresse_2_Liv').value;
		var adresse_3_liv = document.getElementById('oed-Adresse_3_Liv').value;
		var code_postal_liv = document.getElementById('oed-Code_Postal_Liv').value;
		var ville_liv = document.getElementById('oed-Ville_Liv').value;
		var code_pays_liv = document.getElementById('oed-Code_Pays_Liv').value;

		var civ_inter_liv = document.getElementById("oed-Civ_Inter_Liv").value;
		var nom_inter_liv = document.getElementById("oed-Nom_Inter_Liv").value;
		var prenom_inter_liv = document.getElementById("oed-Prenom_Inter_Liv").value;
		var telInter1liv = document.getElementById("oed-Tel_Inter_1_Liv").value;
		var telInter2liv = document.getElementById("oed-Tel_Inter_2_Liv").value;
		var fax_inter_liv = document.getElementById('oed-Fax_Inter_Liv').value;
		var email_inter_liv = document.getElementById('oed-Email_Inter_Liv').value;

		var denomination_envoi = document.getElementById('oed-Denomination_Envoi').value;
		var adresse_1_envoi = document.getElementById('oed-Adresse_1_Envoi').value;
		var adresse_2_envoi = document.getElementById('oed-Adresse_2_Envoi').value;
		var adresse_3_envoi = document.getElementById('oed-Adresse_3_Envoi').value;
		var code_postal_envoi = document.getElementById('oed-Code_Postal_Envoi').value;
		var ville_envoi = document.getElementById('oed-Ville_Envoi').value;
		var code_pays_envoi = document.getElementById('oed-Code_Pays_Envoi').value;

		var civ_inter_envoi = document.getElementById("oed-Civ_Inter_Envoi").value;
		var nom_inter_envoi = document.getElementById("oed-Nom_Inter_Envoi").value;
		var prenom_inter_envoi = document.getElementById("oed-Prenom_Inter_Envoi").value;
		var telInter1envoi = document.getElementById("oed-Tel_Inter_1_Envoi").value;
		var telInter2envoi = document.getElementById("oed-Tel_Inter_2_Envoi").value;
		var fax_inter_envoi = document.getElementById('oed-Fax_Inter_Envoi').value;
		var email_inter_envoi = document.getElementById('oed-Email_Inter_Envoi').value;

		var num_tva = oed_assujettiTVA?document.getElementById('oed-Num_TVA').value:"";
		var montant_base = (oed_editionTTC?oed_montantTTC:oed_montantHT);

		oed_codeTVAPort = document.getElementById('oed-codeTVAFraisPort').value;
		oed_tauxTVAPort = getTva(oed_codeTVAPort);

		if (isEmpty(remise) || (oed_typeRemise=='P'?!isTaux(remise):!isPositiveOrNull(remise) || !checkNumber(remise,9,2) || parseFloat(remise)>montant_base)) { showWarning("Remise incorrecte !"); }
		else if (isEmpty(frais_port) || !isPositiveOrNull(frais_port)) { showWarning("Frais de port incorrects !"); }
		else if (isEmpty(remiseFP) || (oed_typeRemiseFP=='P'?!isTaux(remiseFP):!isPositiveOrNull(remiseFP) || !checkNumber(remiseFP,9,2) || parseFloat(remiseFP)>parseFloat(frais_port))) { showWarning("Remise sur frais de port incorrecte !"); }
		else if (isEmpty(denomination_fact)) { showWarning("Veuillez indiquer la d\u00E9nomination du client de facturation !"); }
		else if (isEmpty(adresse_1_fact)) { showWarning("Veuillez indiquer l'adresse du client de facturation !"); }
		else if (isEmpty(ville_fact)) { showWarning("Veuillez indiquer la ville du client de facturation !"); }
		else if (isEmpty(denomination_liv)) { showWarning("Veuillez indiquer la d\u00E9nomination du client de livraison !"); }
		else if (isEmpty(adresse_1_liv)) { showWarning("Veuillez indiquer l'adresse du client de livraison !"); }
		else if (isEmpty(ville_liv)) { showWarning("Veuillez indiquer la ville du client de livraison !"); }
		else if (isEmpty(denomination_envoi)) { showWarning("Veuillez indiquer la d\u00E9nomination du client d'envoi !"); }
		else if (isEmpty(adresse_1_envoi)) { showWarning("Veuillez indiquer l'adresse du client d'envoi !"); }
		else if (isEmpty(ville_envoi)) { showWarning("Veuillez indiquer la ville du client d'envoi !"); }
		else if (isEmpty(escompte) || !isTaux(escompte)) { showWarning("Taux d'escompte incorrect !"); }
		else if (!isEmpty(date_exp) && !isDate(date_exp)) { showWarning("Date d'expiration de l'offre incorrecte !"); }
		else if (!isEmpty(telInter1fact) && !isPhone(telInter1fact)) { showWarning("T\u00E9l\u00E9phone 1 de facturation incorrect !"); }
		else if (!isEmpty(telInter2fact) && !isPhone(telInter2fact)) { showWarning("T\u00E9l\u00E9phone 2 de facturation incorrect !"); }
		else if (!isEmpty(fax_inter_fact) && !isPhone(fax_inter_fact)) { showWarning("Num\u00E9ro de fax de facturation incorrect !"); }
		else if (!isEmpty(email_inter_fact) && !isEmail(email_inter_fact)) { showWarning("Adresse e-mail de facturation incorrecte !"); }
		else if (!isEmpty(telInter1liv) && !isPhone(telInter1liv)) { showWarning("T\u00E9l\u00E9phone 1 de livraison incorrect !"); }
		else if (!isEmpty(telInter2liv) && !isPhone(telInter2liv)) { showWarning("T\u00E9l\u00E9phone 2 de livraison incorrect !"); }
		else if (!isEmpty(fax_inter_liv) && !isPhone(fax_inter_liv)) { showWarning("Num\u00E9ro de fax de livraison incorrect !"); }
		else if (!isEmpty(email_inter_liv) && !isEmail(email_inter_liv)) { showWarning("Adresse e-mail de livraison incorrecte !"); }
		else if (!isEmpty(telInter1envoi) && !isPhone(telInter1envoi)) { showWarning("T\u00E9l\u00E9phone 1 d'envoi incorrect !"); }
		else if (!isEmpty(telInter2envoi) && !isPhone(telInter2envoi)) { showWarning("T\u00E9l\u00E9phone 2 d'envoi incorrect !"); }
		else if (!isEmpty(fax_inter_envoi) && !isPhone(fax_inter_envoi)) { showWarning("Num\u00E9ro de fax d'envoi incorrect !"); }
		else if (!isEmpty(email_inter_envoi) && !isEmail(email_inter_envoi)) { showWarning("Adresse e-mail d'envoi incorrecte !"); }
		else if (!oed_devisType || oed_etatDevis=='N' || window.confirm("ATTENTION : Devis type !\nConfirmez-vous la modification du devis ?")) {

			if (oed_assujettiTVA && code_pays_liv!="FR" && isEmpty(num_tva) && oed_zoneUE) {
				showWarning("Attention : vous n'avez pas saisi le num\u00E9ro de tva intra-communautaire !");
			}

			frais_port = parseFloat(frais_port);
			remise = parseFloat(remise);
			remiseFP = parseFloat(remiseFP);

			if (oed_typeRemise=='P') {
				taux_remise = remise;
			}
			else {
				taux_remise = (montant_base>0?remise/montant_base*100:0);
				montant_remise = remise;
			}

			if (oed_typeRemiseFP=='P') {
				tauxRemiseFP = remiseFP;
			}
			else {
				tauxRemiseFP = (frais_port>0?remiseFP/frais_port*100:0);
				montantRemiseFP = remiseFP;
			}

			var qSave;

			if (oed_mode=="C") {
				qSave = new QueryHttp("Facturation/Devis/createDevis.tmpl");
				qSave.setParam("Devis_Type", devisType);
			}
			else {
				qSave = new QueryHttp("Facturation/Devis/updateDevis.tmpl");
				qSave.setParam("Devis_Id", oed_devisId);
			}

			qSave.setParam("PRemise", taux_remise);
			qSave.setParam("Frais_Port", frais_port);
			qSave.setParam("Escompte", escompte);
			qSave.setParam("MRemise", montant_remise);
			qSave.setParam("PRemise_FP", tauxRemiseFP);
			qSave.setParam("MRemise_FP", montantRemiseFP);
			qSave.setParam("Mode_Reg", modeReglement);
			qSave.setParam("Mode_Expedition", modeExpedition);
			qSave.setParam("Commentaires_Fin", commentairesFin);
			qSave.setParam("Commentaires_Int", commentairesInt);
			qSave.setParam("Date_Exp", date_exp);
			qSave.setParam("Tarif_Id", tarifId);
			qSave.setParam("Regime_TVA", regimeTVA);
			qSave.setParam("Intitule", intitule);
			qSave.setParam("Pole_Activite", poleActivite);
			qSave.setParam("Etab_Id", etablissement);
			qSave.setParam("Site_Web_Id", siteWebId);
			qSave.setParam("Code_TVA_Port", oed_codeTVAPort);
			qSave.setParam("Taux_TVA_Port", oed_tauxTVAPort);
			qSave.setParam("Edition_TTC", editionTTC);
			qSave.setParam("Assujetti_TVA", oed_assujettiTVA);
			qSave.setParam("Num_TVA_Intra", num_tva);
			qSave.setParam("Util_R", util_R);
			qSave.setParam("Client_Id", oed_clientId);

			qSave.setParam("Denomination", denomination_fact);
			qSave.setParam("Adresse_1", adresse_1_fact);
			qSave.setParam("Adresse_2", adresse_2_fact);
			qSave.setParam("Adresse_3", adresse_3_fact);
			qSave.setParam("Code_Postal", code_postal_fact);
			qSave.setParam("Ville", ville_fact);
			qSave.setParam("Code_Pays", code_pays_fact);
			qSave.setParam("Civ_Inter", civ_inter_fact);
			qSave.setParam("Nom_Inter", nom_inter_fact);
			qSave.setParam("Prenom_Inter", prenom_inter_fact);
			qSave.setParam("Tel_Inter_1", telInter1fact);
			qSave.setParam("Tel_Inter_2", telInter2fact);
			qSave.setParam("Fax_Inter", fax_inter_fact);
			qSave.setParam("Email_Inter", email_inter_fact);

			qSave.setParam("Denomination_Liv", denomination_liv);
			qSave.setParam("Adresse_1_Liv", adresse_1_liv);
			qSave.setParam("Adresse_2_Liv", adresse_2_liv);
			qSave.setParam("Adresse_3_Liv", adresse_3_liv);
			qSave.setParam("Code_Postal_Liv", code_postal_liv);
			qSave.setParam("Ville_Liv", ville_liv);
			qSave.setParam("Code_Pays_Liv", code_pays_liv);
			qSave.setParam("Civ_Inter_Liv", civ_inter_liv);
			qSave.setParam("Nom_Inter_Liv", nom_inter_liv);
			qSave.setParam("Prenom_Inter_Liv", prenom_inter_liv);
			qSave.setParam("Tel_Inter_1_Liv", telInter1liv);
			qSave.setParam("Tel_Inter_2_Liv", telInter2liv);
			qSave.setParam("Fax_Inter_Liv", fax_inter_liv);
			qSave.setParam("Email_Inter_Liv", email_inter_liv);

			qSave.setParam("Denomination_Envoi", denomination_envoi);
			qSave.setParam("Adresse_1_Envoi", adresse_1_envoi);
			qSave.setParam("Adresse_2_Envoi", adresse_2_envoi);
			qSave.setParam("Adresse_3_Envoi", adresse_3_envoi);
			qSave.setParam("Code_Postal_Envoi", code_postal_envoi);
			qSave.setParam("Ville_Envoi", ville_envoi);
			qSave.setParam("Code_Pays_Envoi", code_pays_envoi);
			qSave.setParam("Civ_Inter_Envoi", civ_inter_envoi);
			qSave.setParam("Nom_Inter_Envoi", nom_inter_envoi);
			qSave.setParam("Prenom_Inter_Envoi", prenom_inter_envoi);
			qSave.setParam("Tel_Inter_1_Envoi", telInter1envoi);
			qSave.setParam("Tel_Inter_2_Envoi", telInter2envoi);
			qSave.setParam("Fax_Inter_Envoi", fax_inter_envoi);
			qSave.setParam("Email_Inter_Envoi", email_inter_envoi);

			var result = qSave.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				if (oed_mode=="C") {
					oed_devisId = result.responseXML.documentElement.getAttribute("Devis_Id");
					oed_aLignes.setParam('Devis_Id', oed_devisId);
					oed_chargerDevis();
				}
				else {
					var messageTVA = result.responseXML.documentElement.getAttribute('Message_TVA');
					if (messageTVA!=null) {
						showWarning(messageTVA);
					}

					oed_ajouterLigne("I");
					oed_aLignes.initTree(oed_afterRefreshArticles);
				}

				oed_setModified(false);
				save = true;
			}
		}

		return save;

	} catch (e) {
  	recup_erreur(e);
	}
}


function oed_calculTotaux() {
  try {

		document.getElementById('oed-Edition_TTC').disabled = (oed_aLignes.nbLignes()>0);
    document.getElementById('oed-Code_Pays_Liv').disabled = (oed_aLignes.nbLignes()>0 && oed_etatDevis!="N");
    document.getElementById('oed-chercher_client').collapsed = oed_mode=='V' || gReadOnly;
   	document.getElementById('oed-chercher_adrliv').disabled = (isEmpty(oed_clientId) || (oed_aLignes.nbLignes()>0 && oed_etatDevis!="N"));
    document.getElementById('oed-bCopierFactVersLivEnvoi').disabled = (oed_mode=='V' || (oed_aLignes.nbLignes()>0 && oed_etatDevis!="N"));
    document.getElementById('oed-Tarif_Id').disabled = (oed_aLignes.nbLignes()>0);
		document.getElementById('oed-Regime_TVA').disabled = (oed_aLignes.nbLignes()>0);
		document.getElementById('oed-Assujetti_TVA').disabled = (oed_aLignes.nbLignes()>0);

		var remise = parseFloat(document.getElementById('oed-Remise').value);
		var remiseFP = parseFloat(document.getElementById('oed-RemiseFP').value);
		var taux_escompte = parseFloat(document.getElementById('oed-Escompte').value);
		var frais_port = parseFloat(document.getElementById('oed-Frais_Port').value);

		if ((oed_typeRemise=='P'?isTaux(remise):isPositiveOrNull(remise)) && (oed_typeRemiseFP=='P'?isTaux(remiseFP):isPositiveOrNull(remiseFP)) && isTaux(taux_escompte) && isPositiveOrNull(frais_port)) {

			var calculDocument = new CalculDocument();
			calculDocument.setEditionTTC(oed_editionTTC);
			if (oed_typeRemise=='P') { calculDocument.setRemiseP(remise); }
			else { calculDocument.setRemiseM(remise); }
			calculDocument.setFraisPortBruts(frais_port);
			if (oed_typeRemiseFP=='P') { calculDocument.setRemiseFPP(remiseFP); }
			else { calculDocument.setRemiseFPM(remiseFP); }
			calculDocument.setCodeAndTauxTVAFP(document.getElementById('oed-codeTVAFraisPort').value, getTva(document.getElementById('oed-codeTVAFraisPort').value));
			calculDocument.setEscompteP(taux_escompte);

			for (var i=0; i<oed_aLignes.nbLignes(); i++) {
				if (oed_aLignes.getCellText(i,'oed-colTypeLigne')!="C") {
					var montantLigne = oed_aLignes.getCellText(i,'oed-ColTotal');
					var codeTVA  = oed_aLignes.getCellText(i,'oed-ColCode_TVA');
					calculDocument.addLigneDocument(montantLigne, codeTVA);
				}
			}

			calculDocument.calculer();

			if (oed_editionTTC) {
				document.getElementById('oed-pttcMontantRemise').value = calculDocument.getRemiseM();
				document.getElementById('oed-pttcMontantFrais_Port').value = calculDocument.getFraisPortBruts();
				document.getElementById('oed-pttcMontantRemiseFP').value = calculDocument.getRemiseFPM();
				document.getElementById('oed-pttcTVA').value = calculDocument.getTotalTVA();
				document.getElementById('oed-pttcMontantTTC').value = calculDocument.getMontantTTC();
				document.getElementById('oed-pttcMontantEscompte').value = calculDocument.getEscompteM();
				document.getElementById('oed-pttcNetCommercial').value = calculDocument.getNetCommercial();
				document.getElementById('oed-pttcTotalTTC').value = calculDocument.getTotalTTC();
				document.getElementById('oed-pttcNetTTC').value = calculDocument.getNetAPayer();

				oed_montantTTC = calculDocument.getMontantTTCSansFormat();

				document.getElementById('oed-rowRemiseTTC').collapsed = !calculDocument.afficherRemiseM();
				document.getElementById('oed-rowRemiseFPTTC').collapsed = !calculDocument.afficherRemiseFPM();
				document.getElementById('oed-rowNetCommercialTTC').collapsed = !calculDocument.afficherNetCommercial();
				document.getElementById('oed-rowEscompteTTC').collapsed = !calculDocument.afficherEscompteM();
			}
			else {
				document.getElementById('oed-MontantHT').value = calculDocument.getMontantHT();
				document.getElementById('oed-MontantRemise').value = calculDocument.getRemiseM();
				document.getElementById('oed-MontantFrais_Port').value = calculDocument.getFraisPortBruts();
				document.getElementById('oed-MontantRemiseFP').value = calculDocument.getRemiseFPM();
				document.getElementById('oed-TotalHT').value = calculDocument.getTotalHT();
				document.getElementById('oed-TVA').value = calculDocument.getTotalTVA();
				document.getElementById('oed-MontantEscompte').value = calculDocument.getEscompteM();
				document.getElementById('oed-NetCommercial').value = calculDocument.getNetCommercial();
				document.getElementById('oed-TotalTTC').value = calculDocument.getTotalTTC();

				oed_montantHT = calculDocument.getMontantHTSansFormat();

				document.getElementById('oed-rowRemiseHT').collapsed = !calculDocument.afficherRemiseM();
				document.getElementById('oed-rowRemiseFPHT').collapsed = !calculDocument.afficherRemiseFPM();
				document.getElementById('oed-rowNetCommercialHT').collapsed = !calculDocument.afficherNetCommercial();
				document.getElementById('oed-rowEscompteHT').collapsed = !calculDocument.afficherEscompteM();
			}
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oed_calculerPoids() {
	try {

		var qGet = new QueryHttp("Facturation/Devis/getPoidsTotal.tmpl");
		qGet.setParam("Devis_Id", oed_devisId);
		var result = qGet.execute();

		document.getElementById('oed-poidsTotal').value = result.responseXML.documentElement.getAttribute("Poids");
		document.getElementById('oed-volumeTotal').value = result.responseXML.documentElement.getAttribute("Volume");

	} catch (e) {
		recup_erreur(e);
	}
}


function oed_afterRefreshArticles() {
	try {

		if (oed_toSelectLigne!=null) {
			for (var i=0; i<oed_aLignes.nbLignes(); i++) {
				if (oed_aLignes.getCellText(i, "oed-colLigneId")==oed_toSelectLigne && oed_aLignes.getCellText(i, "oed-colTypeLigne")!="C") {
					oed_aLignes.select(i);
					break;
				}
			}
			oed_toSelectLigne = null;
		}
		oed_aLignes.ensureRowIsVisible(oed_currentIndex);

		document.getElementById('oed-Reference').focus();
		oed_calculTotaux();
		oed_loadRecapitulatif();

	} catch (e) {
  	recup_erreur(e);
	}
}


function oed_demandeEnregistrement() {
  try {

		if (oed_modified && window.confirm("Voulez-vous enregistrer les modifications apport\u00E9es au devis ?")) {
			oed_enregistrerDevis();
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oed_setModified(m) {
  try {

  	oed_modified = m && !gReadOnly;

		if (oed_modified) {
			document.getElementById('oed-tabDevis').setAttribute('image', 'chrome://opensi/content/design/icones/modified.png');
			document.getElementById('oed-bVisualiser').disabled = true;
			document.getElementById('oed-bCopierDevis').disabled = true;
			document.getElementById('oed-bCopierType').disabled = true;
			document.getElementById('oed-bProforma').disabled = true;
			document.getElementById('oed-bTransAff').disabled = true;
			document.getElementById('oed-bTransFac').disabled = true;
			document.getElementById('oed-bArchiverDevis').disabled = true;
			document.getElementById('oed-bValiderDevis').disabled = true;
			document.getElementById('oed-bApercu').disabled = true;
		}
		else {
			document.getElementById('oed-tabDevis').setAttribute('image', gReadOnly?'chrome://opensi/content/design/icones/readonly.png':null);
			document.getElementById('oed-bVisualiser').disabled = (oed_chargementEnCours);
			document.getElementById('oed-bCopierDevis').disabled = (oed_chargementEnCours);
			document.getElementById('oed-bCopierType').disabled = (oed_chargementEnCours);
			document.getElementById('oed-bProforma').disabled = (oed_chargementEnCours || oed_devisType);
			document.getElementById('oed-bTransAff').disabled = (oed_chargementEnCours || oed_devisType);
			document.getElementById('oed-bTransFac').disabled = (oed_chargementEnCours || oed_devisType);
			document.getElementById('oed-bArchiverDevis').disabled = (oed_chargementEnCours);
			document.getElementById('oed-bApercu').disabled = (oed_chargementEnCours);
			document.getElementById('oed-bValiderDevis').disabled = (oed_chargementEnCours);
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oed_debloquerInterface() {
	try {

		document.getElementById('oed-intitule').disabled = (oed_mode=="V");
		document.getElementById('oed-poleActivite').disabled = (oed_mode=="V");
		document.getElementById('oed-modeExpedition').disabled = (oed_mode=="V");
		document.getElementById('oed-siteWeb').disabled = (oed_mode=="V" || (oed_actDevisWeb && oed_etatDevis=='T'));
		document.getElementById('oed-etablissement').disabled = (oed_mode=="V");
		document.getElementById('oed-Login_Resp').disabled = (oed_mode=="V");
		document.getElementById('oed-Assujetti_TVA').disabled = (oed_mode=="V");
		document.getElementById('oed-Regime_TVA').disabled = (oed_mode=="V");
		document.getElementById('oed-Edition_TTC').disabled = (oed_mode=="V");
		document.getElementById('oed-chercher_client').disabled = oed_mode=="V" || gReadOnly;
		document.getElementById('oed-bCreerClient').disabled = (oed_mode=="V");
		document.getElementById('oed-bCopierFactVersLivEnvoi').disabled = (oed_mode=="V");
		document.getElementById('oed-Tarif_Id').disabled = (oed_mode=="V");

		if (oed_mode=="V") {
			document.getElementById('oed-Denomination_Fact').setAttribute('readonly', true);
			document.getElementById('oed-Adresse_1_Fact').setAttribute('readonly', true);
			document.getElementById('oed-Adresse_2_Fact').setAttribute('readonly', true);
			document.getElementById('oed-Adresse_3_Fact').setAttribute('readonly', true);
			document.getElementById('oed-Code_Postal_Fact').setAttribute('readonly', true);
			document.getElementById('oed-Ville_Fact').setAttribute('readonly', true);
			document.getElementById('oed-Code_Pays_Fact').disabled = true;
			document.getElementById('oed-Civ_Inter_Fact').disabled = true;
			document.getElementById('oed-Nom_Inter_Fact').setAttribute('readonly', true);
			document.getElementById('oed-Prenom_Inter_Fact').setAttribute('readonly', true);
			document.getElementById('oed-Tel_Inter_1_Fact').setAttribute('readonly', true);
			document.getElementById('oed-Tel_Inter_2_Fact').setAttribute('readonly', true);
			document.getElementById('oed-Fax_Inter_Fact').setAttribute('readonly', true);
			document.getElementById('oed-Email_Inter_Fact').setAttribute('readonly', true);

			document.getElementById('oed-Denomination_Liv').setAttribute('readonly', true);
			document.getElementById('oed-Adresse_1_Liv').setAttribute('readonly', true);
			document.getElementById('oed-Adresse_2_Liv').setAttribute('readonly', true);
			document.getElementById('oed-Adresse_3_Liv').setAttribute('readonly', true);
			document.getElementById('oed-Code_Postal_Liv').setAttribute('readonly', true);
			document.getElementById('oed-Ville_Liv').setAttribute('readonly', true);
			document.getElementById('oed-Code_Pays_Liv').disabled = true;
			document.getElementById('oed-Civ_Inter_Liv').disabled = true;
			document.getElementById('oed-Nom_Inter_Liv').setAttribute('readonly', true);
			document.getElementById('oed-Prenom_Inter_Liv').setAttribute('readonly', true);
			document.getElementById('oed-Tel_Inter_1_Liv').setAttribute('readonly', true);
			document.getElementById('oed-Tel_Inter_2_Liv').setAttribute('readonly', true);
			document.getElementById('oed-Fax_Inter_Liv').setAttribute('readonly', true);
			document.getElementById('oed-Email_Inter_Liv').setAttribute('readonly', true);

			document.getElementById('oed-Denomination_Envoi').setAttribute('readonly', true);
			document.getElementById('oed-Adresse_1_Envoi').setAttribute('readonly', true);
			document.getElementById('oed-Adresse_2_Envoi').setAttribute('readonly', true);
			document.getElementById('oed-Adresse_3_Envoi').setAttribute('readonly', true);
			document.getElementById('oed-Code_Postal_Envoi').setAttribute('readonly', true);
			document.getElementById('oed-Ville_Envoi').setAttribute('readonly', true);
			document.getElementById('oed-Code_Pays_Envoi').disabled = true;
			document.getElementById('oed-Civ_Inter_Envoi').disabled = true;
			document.getElementById('oed-Nom_Inter_Envoi').setAttribute('readonly', true);
			document.getElementById('oed-Prenom_Inter_Envoi').setAttribute('readonly', true);
			document.getElementById('oed-Tel_Inter_1_Envoi').setAttribute('readonly', true);
			document.getElementById('oed-Tel_Inter_2_Envoi').setAttribute('readonly', true);
			document.getElementById('oed-Fax_Inter_Envoi').setAttribute('readonly', true);
			document.getElementById('oed-Email_Inter_Envoi').setAttribute('readonly', true);
		}
		else {
			document.getElementById('oed-Denomination_Fact').removeAttribute('readonly');
			document.getElementById('oed-Adresse_1_Fact').removeAttribute('readonly');
			document.getElementById('oed-Adresse_2_Fact').removeAttribute('readonly');
			document.getElementById('oed-Adresse_3_Fact').removeAttribute('readonly');
			document.getElementById('oed-Code_Postal_Fact').removeAttribute('readonly');
			document.getElementById('oed-Ville_Fact').removeAttribute('readonly');
			document.getElementById('oed-Code_Pays_Fact').disabled = false;
			document.getElementById('oed-Civ_Inter_Fact').disabled = false;
			document.getElementById('oed-Nom_Inter_Fact').removeAttribute('readonly');
			document.getElementById('oed-Prenom_Inter_Fact').removeAttribute('readonly');
			document.getElementById('oed-Tel_Inter_1_Fact').removeAttribute('readonly');
			document.getElementById('oed-Tel_Inter_2_Fact').removeAttribute('readonly');
			document.getElementById('oed-Fax_Inter_Fact').removeAttribute('readonly');
			document.getElementById('oed-Email_Inter_Fact').removeAttribute('readonly');

			document.getElementById('oed-Denomination_Liv').removeAttribute('readonly');
			document.getElementById('oed-Adresse_1_Liv').removeAttribute('readonly');
			document.getElementById('oed-Adresse_2_Liv').removeAttribute('readonly');
			document.getElementById('oed-Adresse_3_Liv').removeAttribute('readonly');
			document.getElementById('oed-Code_Postal_Liv').removeAttribute('readonly');
			document.getElementById('oed-Ville_Liv').removeAttribute('readonly');
			document.getElementById('oed-Code_Pays_Liv').disabled = false;
			document.getElementById('oed-Civ_Inter_Liv').disabled = false;
			document.getElementById('oed-Nom_Inter_Liv').removeAttribute('readonly');
			document.getElementById('oed-Prenom_Inter_Liv').removeAttribute('readonly');
			document.getElementById('oed-Tel_Inter_1_Liv').removeAttribute('readonly');
			document.getElementById('oed-Tel_Inter_2_Liv').removeAttribute('readonly');
			document.getElementById('oed-Fax_Inter_Liv').removeAttribute('readonly');
			document.getElementById('oed-Email_Inter_Liv').removeAttribute('readonly');

			document.getElementById('oed-Denomination_Envoi').removeAttribute('readonly');
			document.getElementById('oed-Adresse_1_Envoi').removeAttribute('readonly');
			document.getElementById('oed-Adresse_2_Envoi').removeAttribute('readonly');
			document.getElementById('oed-Adresse_3_Envoi').removeAttribute('readonly');
			document.getElementById('oed-Code_Postal_Envoi').removeAttribute('readonly');
			document.getElementById('oed-Ville_Envoi').removeAttribute('readonly');
			document.getElementById('oed-Code_Pays_Envoi').disabled = false;
			document.getElementById('oed-Civ_Inter_Envoi').disabled = false;
			document.getElementById('oed-Nom_Inter_Envoi').removeAttribute('readonly');
			document.getElementById('oed-Prenom_Inter_Envoi').removeAttribute('readonly');
			document.getElementById('oed-Tel_Inter_1_Envoi').removeAttribute('readonly');
			document.getElementById('oed-Tel_Inter_2_Envoi').removeAttribute('readonly');
			document.getElementById('oed-Fax_Inter_Envoi').removeAttribute('readonly');
			document.getElementById('oed-Email_Inter_Envoi').removeAttribute('readonly');
		}

		document.getElementById('oed-Code_Stats').disabled = (oed_mode=="V");
		document.getElementById('oed-Reference').disabled = (oed_mode=="V");
		document.getElementById('oed-Designation').disabled = (oed_mode=="V");
		document.getElementById('oed-Nb_Pieces').disabled = (oed_mode=="V");
		document.getElementById('oed-Quantite').disabled = (oed_mode=="V");
		document.getElementById('oed-Unite').disabled = (oed_mode=="V");
		document.getElementById('oed-PU').disabled = (oed_mode=="V" || !oed_modifElemFin);
		document.getElementById('oed-Ristourne').disabled = (oed_mode=="V" || !oed_modifElemFin);
		document.getElementById('oed-bRistourne').disabled = (oed_mode=="V" || !oed_modifElemFin);
		document.getElementById('oed-Code_TVA').disabled = (oed_mode=="V" || !oed_modifElemFin);
		document.getElementById('oed-bAnnuler').disabled = (oed_mode=="V");
		document.getElementById('oed-bValider').disabled = (oed_mode=="V");
		document.getElementById('oed-Commentaires_Fin').disabled = (oed_mode=="V");
		document.getElementById('oed-Commentaires_Int').disabled = (oed_mode=="V");
		document.getElementById('oed-modeReglement').disabled = (oed_mode=="V");
		document.getElementById('oed-bRemise').disabled = (oed_mode=="V" || !oed_modifElemFin);
		document.getElementById('oed-Remise').disabled = (oed_mode=="V" || !oed_modifElemFin);
		document.getElementById('oed-Frais_Port').disabled = (oed_mode=="V" || !oed_modifElemFin);
		document.getElementById('oed-codeTVAFraisPort').disabled = (oed_mode=="V" || !oed_modifElemFin);
		document.getElementById('oed-bRemiseFP').disabled = (oed_mode=="V" || !oed_modifElemFin);
		document.getElementById('oed-RemiseFP').disabled = (oed_mode=="V" || !oed_modifElemFin);
		document.getElementById('oed-Escompte').disabled = (oed_mode=="V" || !oed_modifElemFin);
		document.getElementById('oed-Date_Exp').disabled = (oed_mode=="V");
		document.getElementById('oed-bEnregistrer').disabled = oed_devisType && !gProfil.isGestionDevisType();
		document.getElementById('oed-bProforma').disabled = oed_devisType;
		document.getElementById('oed-bArchiverDevis').disabled = false;
		document.getElementById('oed-bTransFac').disabled = oed_devisType;
		document.getElementById('oed-bTransAff').disabled = oed_devisType;
		document.getElementById('oed-bValiderDevis').disabled = false;
		document.getElementById('oed-bApercu').disabled = false;
		document.getElementById('oed-bSupDevis').disabled = false;
		document.getElementById('oed-bArticle').disabled = (oed_mode=="V");
		document.getElementById('oed-bChoisirMentions').disabled = (oed_mode=="V");

	} catch (e) {
		recup_erreur(e);
	}
}


function oed_nouveauDevis() {
  try {

		oed_devisId = "";
		oed_clientId = "";
		oed_mode = "C";
		oed_etatDevis = "N";
		oed_isDevisWeb = false;
		oed_devisType = false;
		document.getElementById('oed-deckDevis').selectedIndex = 0;
		document.getElementById('oed-tabEntete').selectedIndex = 0;
		document.getElementById('oed-tabAdresses').selectedIndex = 0;
		document.getElementById('oed-tabDevis').setAttribute('image', gReadOnly?'chrome://opensi/content/design/icones/readonly.png':null);

		var venteTTC = gConfig.isVenteTTC();

		document.getElementById('oed-Edition_TTC').checked = venteTTC;
		oed_changerTypeEdition(venteTTC);

		document.getElementById('oed-rowFrancoPort').collapsed = true;
		document.getElementById('oed-lblFrancoPort').value = "";

		document.getElementById('oed-tabVersionDocument').collapsed = true;

		oed_assujettiTVA = false;
		oed_codesTvaInactifs = "";
		oed_codeTVAPort = "";
		document.getElementById('oed-Assujetti_TVA').checked = false;
		document.getElementById('oed-devisType').checked = false;
		document.getElementById('oed-devisType').collapsed = !gProfil.isGestionDevisType();
		document.getElementById('oed-lblDevisType').collapsed = true;
		document.getElementById('oed-Num_TVA').value = "";
		oed_chargerTarifsVente(gConfig.getTarifDefaut());
		document.getElementById('oed-Regime_TVA').value = "G";
		document.getElementById('oed-intitule').value = "";
		document.getElementById('oed-Indications').value = "";
		oed_chargerModesReglements(oed_defModeReglement);
		oed_chargerModesExpedition(oed_defModeExpedition);
		oed_chargerEtablissement(etablissementDefaut);
		oed_chargerSiteWeb("");
		oed_chargerPolesActivite("");

		document.getElementById('oed-bCreerClient').collapsed = true;

		document.getElementById('oed-Commentaires_Fin').value = "";
		document.getElementById('oed-Commentaires_Int').value = "";
		document.getElementById('oed-Date_Devis').value = "";
		document.getElementById('oed-Numero').value = "";

		document.getElementById('oed-Remise').value = "0.00";
		document.getElementById('oed-Escompte').value = "0.00";
		document.getElementById('oed-Frais_Port').value = "0.00";
		document.getElementById('oed-RemiseFP').value = "0.00";
		document.getElementById('oed-Date_Exp').value = "";
		document.getElementById('oed-poidsTotal').value = 0;
		document.getElementById('oed-volumeTotal').value = 0;

		document.getElementById('oed-Denomination_Fact').value = "";
		document.getElementById('oed-Adresse_1_Fact').value = "";
		document.getElementById('oed-Adresse_2_Fact').value = "";
		document.getElementById('oed-Adresse_3_Fact').value = "";
		document.getElementById('oed-Code_Postal_Fact').value = "";
		document.getElementById('oed-Ville_Fact').value = "";
		document.getElementById('oed-Code_Pays_Fact').value = "FR";

		document.getElementById('oed-Civ_Inter_Fact').selectedIndex = 0;
		document.getElementById('oed-Nom_Inter_Fact').value = "";
		document.getElementById('oed-Prenom_Inter_Fact').value = "";
		document.getElementById('oed-Tel_Inter_1_Fact').value = "";
		document.getElementById('oed-Tel_Inter_2_Fact').value = "";
		document.getElementById('oed-Fax_Inter_Fact').value = "";
		document.getElementById('oed-Email_Inter_Fact').value = "";

		document.getElementById('oed-Denomination_Liv').value = "";
		document.getElementById('oed-Adresse_1_Liv').value = "";
		document.getElementById('oed-Adresse_2_Liv').value = "";
		document.getElementById('oed-Adresse_3_Liv').value = "";
		document.getElementById('oed-Code_Postal_Liv').value = "";
		document.getElementById('oed-Ville_Liv').value = "";
		document.getElementById('oed-Code_Pays_Liv').value = "FR";
		oed_listeTVAFraisPort();
		oed_selectPaysLiv();

		document.getElementById('oed-Civ_Inter_Liv').selectedIndex = 0;
		document.getElementById('oed-Nom_Inter_Liv').value = "";
		document.getElementById('oed-Prenom_Inter_Liv').value = "";
		document.getElementById('oed-Tel_Inter_1_Liv').value = "";
		document.getElementById('oed-Tel_Inter_2_Liv').value = "";
		document.getElementById('oed-Fax_Inter_Liv').value = "";
		document.getElementById('oed-Email_Inter_Liv').value = "";

		document.getElementById('oed-Denomination_Envoi').value = "";
		document.getElementById('oed-Adresse_1_Envoi').value = "";
		document.getElementById('oed-Adresse_2_Envoi').value = "";
		document.getElementById('oed-Adresse_3_Envoi').value = "";
		document.getElementById('oed-Code_Postal_Envoi').value = "";
		document.getElementById('oed-Ville_Envoi').value = "";
		document.getElementById('oed-Code_Pays_Envoi').value = "FR";

		document.getElementById('oed-Civ_Inter_Envoi').selectedIndex = 0;
		document.getElementById('oed-Nom_Inter_Envoi').value = "";
		document.getElementById('oed-Prenom_Inter_Envoi').value = "";
		document.getElementById('oed-Tel_Inter_1_Envoi').value = "";
		document.getElementById('oed-Tel_Inter_2_Envoi').value = "";
		document.getElementById('oed-Fax_Inter_Envoi').value = "";
		document.getElementById('oed-Email_Inter_Envoi').value = "";

		document.getElementById('oed-MontantHT').value = "0.00";
		document.getElementById('oed-MontantRemise').value = "0.00";
		document.getElementById('oed-MontantFrais_Port').value = "0.00";
		document.getElementById('oed-MontantRemiseFP').value = "0.00";
		document.getElementById('oed-TotalHT').value = "0.00";
		document.getElementById('oed-TVA').value = "0.00";
		document.getElementById('oed-MontantEscompte').value = "0.00";
		document.getElementById('oed-TotalTTC').value = "0.00";

		document.getElementById('oed-rowRemiseHT').collapsed = true;
		document.getElementById('oed-rowRemiseFPHT').collapsed = true;
		document.getElementById('oed-rowEscompteHT').collapsed = true;

		document.getElementById('oed-pttcMontantRemise').value = "0.00";
		document.getElementById('oed-pttcMontantFrais_Port').value = "0.00";
		document.getElementById('oed-pttcMontantRemiseFP').value = "0.00";
		document.getElementById('oed-pttcTVA').value = "0.00";
		document.getElementById('oed-pttcMontantTTC').value = "0.00";
		document.getElementById('oed-pttcMontantEscompte').value = "0.00";
		document.getElementById('oed-pttcTotalTTC').value = "0.00";
		document.getElementById('oed-pttcNetTTC').value = "0.00";

		document.getElementById('oed-rowNetCommercialHT').collapsed = true;
		document.getElementById('oed-rowEscompteTTC').collapsed = true;
		document.getElementById('oed-pttcNetCommercial').value = "0.00";
		document.getElementById('oed-NetCommercial').value = "0.00";

		oed_montantHT=0;
		oed_montantTTC=0;

		document.getElementById('oed-rowRemiseTTC').collapsed = true;
		document.getElementById('oed-rowRemiseFPTTC').collapsed = true;
		document.getElementById('oed-rowEscompteTTC').collapsed = true;

		document.getElementById('oed-creation').setAttribute("label", "");
		document.getElementById('oed-modification').setAttribute("label", "");
		document.getElementById('oed-document').setAttribute("label", "");

		oed_chargerResponsables(gProfil.getLoggedUser());
		document.getElementById('oed-numClient').value = "";

		oed_ajouterLigne("I");
		oed_typeRistourne = 'P';
		document.getElementById('oed-bRistourne').setAttribute("class", "bIcoPourcentage");

		oed_aLignes.deleteTree();

		document.getElementById('oed-tabHistorique').collapsed = true;
		oed_aListeHistorique.deleteTree();
		oed_aVersion.deleteTree();

		document.getElementById('oed-bProforma').collapsed = true;
		document.getElementById('oed-bTransAff').collapsed = true;
		document.getElementById('oed-bTransFac').collapsed = true;
		document.getElementById('oed-bArchiverDevis').collapsed = true;
		document.getElementById('oed-bVisualiser').collapsed = true;
		document.getElementById('oed-bValiderDevis').collapsed = true;
		document.getElementById('oed-bSupDevis').collapsed = true;
		document.getElementById('oed-bApercu').collapsed = true;
		document.getElementById('oed-bCopierDevis').collapsed = true;
		document.getElementById('oed-bCopierType').collapsed = true;
		document.getElementById('oed-bEnregistrer').collapsed = false;
		document.getElementById('oed-bVoirFichier').disabled = true;

		document.getElementById('oed-bArticle').disabled = false;

		document.getElementById('oed-caHT').value = "0.00 \u20AC";
		document.getElementById('oed-paHT').value = "0.00 \u20AC";
		document.getElementById('oed-margeHT').value = "0.00 \u20AC";
		document.getElementById('oed-tauxMarque').value = "0.00 %";
		document.getElementById('oed-tauxMarge').value = "0.00 %";
		document.getElementById('oed-nbLignes').value = "0";
		document.getElementById('oed-qteArticles').value = "0";
		document.getElementById('oed-lblMargeHT').setAttribute("style", "color:black");
		document.getElementById('oed-margeHT').setAttribute("style", "color:black");
		document.getElementById('oed-lblTauxMarque').setAttribute("style", "color:black");
		document.getElementById('oed-tauxMarque').setAttribute("style", "color:black");
		document.getElementById('oed-lblTauxMarge').setAttribute("style", "color:black");
		document.getElementById('oed-tauxMarge').setAttribute("style", "color:black");
		document.getElementById('oed-pictoMargeNegative').collapsed = true;

		document.getElementById('oed-bAjouterLigne').disabled = true;

		oed_debloquerInterface();

		document.getElementById('oed-bChoisirMentions').disabled = true;
		document.getElementById('oed-bOuvrirCommentairesCaches').disabled = true;
		document.getElementById('oed-chercher_adrfact').disabled = true;
		document.getElementById('oed-chercher_inter').disabled = true;
		document.getElementById('oed-chercher_adrliv').disabled = true;
		document.getElementById('oed-chercher_inter_liv').disabled = true;
		document.getElementById('oed-chercher_adrenvoi').disabled = true;
		document.getElementById('oed-chercher_inter_envoi').disabled = true;

		oed_setModified(false);

	} catch (e) {
  	recup_erreur(e);
  }
}


function oed_chargerDevis() {
  try {

		oed_mode = "M";
		oed_chargementEnCours = true;
		document.getElementById('oed-deckDevis').selectedIndex = 0;
		document.getElementById('oed-tabEntete').selectedIndex = 0;
		document.getElementById('oed-tabAdresses').selectedIndex = 0;
		document.getElementById('oed-tabDevis').setAttribute('image', gReadOnly?'chrome://opensi/content/design/icones/readonly.png':null);

		var qLoad = new QueryHttp("Facturation/Devis/loadDevis.tmpl");
		qLoad.setParam("Devis_Id", oed_devisId);

		var result = qLoad.execute();
		var contenu = result.responseXML.documentElement;

		var numero = contenu.getAttribute('Num_Devis');

		oed_chargerModesReglements(contenu.getAttribute('Mode_Reg'));
		oed_chargerModesExpedition(contenu.getAttribute('Mode_Expedition'));

		oed_typeRemise = (parseFloat(contenu.getAttribute('MRemise'))!=0?'M':'P');
		document.getElementById('oed-Remise').value = (oed_typeRemise=='P'?contenu.getAttribute('PRemise'):contenu.getAttribute('MRemise'));
		document.getElementById('oed-bRemise').setAttribute("class", (oed_typeRemise=='P'?"bIcoPourcentage":"bIcoEuro"));

		oed_typeRemiseFP = (parseFloat(contenu.getAttribute('MRemise_FP'))!=0?'M':'P');
		document.getElementById('oed-RemiseFP').value = (oed_typeRemiseFP=='P'?contenu.getAttribute('PRemise_FP'):contenu.getAttribute('MRemise_FP'));
		document.getElementById('oed-bRemiseFP').setAttribute("class", (oed_typeRemiseFP=='P'?"bIcoPourcentage":"bIcoEuro"));

		document.getElementById('oed-Escompte').value = contenu.getAttribute('Escompte');
		document.getElementById('oed-Frais_Port').value = contenu.getAttribute('Frais_Port');
		document.getElementById('oed-Commentaires_Fin').value = contenu.getAttribute('Commentaires_Fin');
		document.getElementById('oed-Commentaires_Int').value = contenu.getAttribute('Commentaires_Int');
		document.getElementById('oed-Date_Devis').value = contenu.getAttribute('Date_Devis');
		document.getElementById('oed-Numero').value = numero;
		document.getElementById('oed-Date_Exp').value = contenu.getAttribute('Date_Exp');
		document.getElementById('oed-intitule').value = contenu.getAttribute('Intitule');
		oed_chargerEtablissement(contenu.getAttribute('Etab_Id'));
		oed_chargerPolesActivite(contenu.getAttribute('Pole_Activite'));

		document.getElementById('oed-Denomination_Fact').value = contenu.getAttribute('Denomination');
		document.getElementById('oed-Adresse_1_Fact').value = contenu.getAttribute('Adresse_1');
		document.getElementById('oed-Adresse_2_Fact').value = contenu.getAttribute('Adresse_2');
		document.getElementById('oed-Adresse_3_Fact').value = contenu.getAttribute('Adresse_3');
		document.getElementById('oed-Code_Postal_Fact').value = contenu.getAttribute('Code_Postal');
		document.getElementById('oed-Ville_Fact').value = contenu.getAttribute('Ville');
		document.getElementById('oed-Code_Pays_Fact').value = contenu.getAttribute('Code_Pays');

		document.getElementById('oed-Denomination_Liv').value = contenu.getAttribute('Denomination_Liv');
		document.getElementById('oed-Adresse_1_Liv').value = contenu.getAttribute('Adresse_1_Liv');
		document.getElementById('oed-Adresse_2_Liv').value = contenu.getAttribute('Adresse_2_Liv');
		document.getElementById('oed-Adresse_3_Liv').value = contenu.getAttribute('Adresse_3_Liv');
		document.getElementById('oed-Code_Postal_Liv').value = contenu.getAttribute('Code_Postal_Liv');
		document.getElementById('oed-Ville_Liv').value = contenu.getAttribute('Ville_Liv');
		document.getElementById('oed-Code_Pays_Liv').value = contenu.getAttribute('Code_Pays_Liv');

		document.getElementById('oed-Civ_Inter_Fact').value = contenu.getAttribute('Civ_Inter');
		document.getElementById('oed-Nom_Inter_Fact').value = contenu.getAttribute('Nom_Inter');
		document.getElementById('oed-Prenom_Inter_Fact').value = contenu.getAttribute('Prenom_Inter');
		document.getElementById('oed-Tel_Inter_1_Fact').value = contenu.getAttribute('Tel_Inter_1');
		document.getElementById('oed-Tel_Inter_2_Fact').value = contenu.getAttribute('Tel_Inter_2');
		document.getElementById('oed-Fax_Inter_Fact').value = contenu.getAttribute('Fax_Inter');
		document.getElementById('oed-Email_Inter_Fact').value = contenu.getAttribute('Email_Inter');

		document.getElementById('oed-Civ_Inter_Liv').value = contenu.getAttribute('Civ_Inter_Liv');
		document.getElementById('oed-Nom_Inter_Liv').value = contenu.getAttribute('Nom_Inter_Liv');
		document.getElementById('oed-Prenom_Inter_Liv').value = contenu.getAttribute('Prenom_Inter_Liv');
		document.getElementById('oed-Tel_Inter_1_Liv').value = contenu.getAttribute('Tel_Inter_1_Liv');
		document.getElementById('oed-Tel_Inter_2_Liv').value = contenu.getAttribute('Tel_Inter_2_Liv');
		document.getElementById('oed-Fax_Inter_Liv').value = contenu.getAttribute('Fax_Inter_Liv');
		document.getElementById('oed-Email_Inter_Liv').value = contenu.getAttribute('Email_Inter_Liv');

		document.getElementById('oed-Denomination_Envoi').value = contenu.getAttribute('Denomination_Envoi');
		document.getElementById('oed-Adresse_1_Envoi').value = contenu.getAttribute('Adresse_1_Envoi');
		document.getElementById('oed-Adresse_2_Envoi').value = contenu.getAttribute('Adresse_2_Envoi');
		document.getElementById('oed-Adresse_3_Envoi').value = contenu.getAttribute('Adresse_3_Envoi');
		document.getElementById('oed-Code_Postal_Envoi').value = contenu.getAttribute('Code_Postal_Envoi');
		document.getElementById('oed-Ville_Envoi').value = contenu.getAttribute('Ville_Envoi');
		document.getElementById('oed-Code_Pays_Envoi').value = contenu.getAttribute('Code_Pays_Envoi');

		document.getElementById('oed-Civ_Inter_Envoi').value = contenu.getAttribute('Civ_Inter_Envoi');
		document.getElementById('oed-Nom_Inter_Envoi').value = contenu.getAttribute('Nom_Inter_Envoi');
		document.getElementById('oed-Prenom_Inter_Envoi').value = contenu.getAttribute('Prenom_Inter_Envoi');
		document.getElementById('oed-Tel_Inter_1_Envoi').value = contenu.getAttribute('Tel_Inter_1_Envoi');
		document.getElementById('oed-Tel_Inter_2_Envoi').value = contenu.getAttribute('Tel_Inter_2_Envoi');
		document.getElementById('oed-Fax_Inter_Envoi').value = contenu.getAttribute('Fax_Inter_Envoi');
		document.getElementById('oed-Email_Inter_Envoi').value = contenu.getAttribute('Email_Inter_Envoi');

		oed_chargerTarifsVente(contenu.getAttribute('Tarif_Id'));
		document.getElementById('oed-Regime_TVA').value = contenu.getAttribute('Regime_TVA');
		oed_codeTVAPort = contenu.getAttribute('Code_TVA_Port');
		oed_tauxTVAPort = contenu.getAttribute('Taux_TVA_Port');
		oed_assujettiTVA = (contenu.getAttribute('Assujetti_TVA')=="true");
		oed_codesTvaInactifs = contenu.getAttribute('Codes_TVA_Inactifs');

		var typeEdition = (contenu.getAttribute('Edition_TTC')=="true");
		document.getElementById('oed-Edition_TTC').checked = typeEdition;

		document.getElementById('oed-Assujetti_TVA').checked = oed_assujettiTVA;
		document.getElementById('oed-Num_TVA').value = contenu.getAttribute("Num_TVA_Intra");

		oed_devisType = contenu.getAttribute("Devis_Type")=="true";
		document.getElementById('oed-devisType').collapsed = true;
		document.getElementById('oed-lblDevisType').collapsed = !oed_devisType;

		oed_clientId = contenu.getAttribute('Client_Id');
		var client_connu = !isEmpty(oed_clientId);

		document.getElementById('oed-numClient').value = contenu.getAttribute('Num_Client');
		document.getElementById('oed-bCreerClient').collapsed = client_connu;

		oed_chargerResponsables(contenu.getAttribute('Util_R'));
		oed_chargerSiteWeb(contenu.getAttribute('Site_Web_Id'));

		document.getElementById('oed-creation').label = "Devis cr\u00E9\u00E9 le "+ contenu.getAttribute('Date_Creation') +" par "+ contenu.getAttribute('Login_Createur');
		document.getElementById('oed-modification').label = "Derni\u00E8re modification le "+ contenu.getAttribute('Date_Maj') +" par "+ contenu.getAttribute('Login_Maj');
		document.getElementById('oed-document').label = "Devis N\u00B0 "+ numero;

		oed_etatDevis = contenu.getAttribute("Etat");
		oed_isDevisWeb = !isEmpty(contenu.getAttribute('Site_Web_Id'));

		document.getElementById('oed-tabVersionDocument').collapsed = false;
    oed_initVersion();

		if ((oed_etatDevis!='N' && oed_etatDevis!='T') || (oed_isDevisWeb && oed_etatDevis=='T') || (oed_devisType && !gProfil.isGestionDevisType())) {
			oed_mode = "V";
			oed_formatLigne("");
		}
		else {
			oed_ajouterLigne("I");
		}

		if (oed_etatDevis!='N' || gConfig.isHistoAvantValidDC()) {
			document.getElementById('oed-tabHistorique').collapsed = false;
			document.getElementById('oed-bEditionInitiale').collapsed = oed_etatDevis=="N";
			document.getElementById('oed-histoAvantVal').collapsed = oed_etatDevis=="N" || !gConfig.isHistoAvantValidDC();
			document.getElementById('oed-histoAvantVal').checked = oed_etatDevis=="N";
			oed_listerHistorique();
		}
		else {
			document.getElementById('oed-tabHistorique').collapsed = true;
			oed_aListeHistorique.deleteTree();
		}

		document.getElementById('oed-bTransFac').collapsed = oed_isDevisWeb || oed_etatDevis!='T' || !gProfil.isMenuGC_VFactures() || oed_devisType || gReadOnly;
		document.getElementById('oed-bTransAff').collapsed = oed_isDevisWeb || oed_etatDevis!='T' || !gProfil.isMenuGC_VAffaires() || oed_devisType || gReadOnly;
		document.getElementById('oed-bArchiverDevis').collapsed = oed_etatDevis!='T' || gReadOnly || (oed_devisType && !gProfil.isGestionDevisType());
		document.getElementById('oed-bProforma').collapsed = (oed_etatDevis!='N' && oed_etatDevis!='T') || gReadOnly || oed_devisType;
		document.getElementById('oed-bCopierDevis').collapsed = gReadOnly;
		document.getElementById('oed-bCopierType').collapsed = gReadOnly || !gProfil.isGestionDevisType();
		document.getElementById('oed-bApercu').collapsed = (oed_etatDevis!='N');
		document.getElementById('oed-bVisualiser').collapsed = (oed_etatDevis=='N');
		document.getElementById('oed-bSupDevis').collapsed = oed_etatDevis!='N' || gReadOnly;
		document.getElementById('oed-bValiderDevis').collapsed = oed_etatDevis!='N' || (gReadOnly && !gProfil.isValidationDC());
		document.getElementById('oed-bEnregistrer').collapsed = (oed_etatDevis!='N' && oed_etatDevis!='T') || (oed_isDevisWeb && oed_etatDevis=='T') || gReadOnly || (oed_devisType && !gProfil.isGestionDevisType());
		document.getElementById('oed-bVoirFichier').disabled = (oed_etatDevis=='N');
		document.getElementById('oed-bAjouterLigne').disabled = true;

		document.getElementById('oed-Num_TVA').disabled = !oed_assujettiTVA || (oed_etatDevis!='N' && oed_etatDevis!='T');
		document.getElementById('oed-chercher_adrfact').disabled = !client_connu || (oed_etatDevis!='N' && oed_etatDevis!='T');
		document.getElementById('oed-chercher_inter').disabled = !client_connu || (oed_etatDevis!='N' && oed_etatDevis!='T');
		document.getElementById('oed-chercher_adrliv').disabled = !client_connu || (oed_etatDevis!='N' && oed_etatDevis!='T');
		document.getElementById('oed-chercher_inter_liv').disabled = !client_connu || (oed_etatDevis!='N' && oed_etatDevis!='T');
		document.getElementById('oed-chercher_adrenvoi').disabled = !client_connu || (oed_etatDevis!='N' && oed_etatDevis!='T');
		document.getElementById('oed-chercher_inter_envoi').disabled = !client_connu || (oed_etatDevis!='N' && oed_etatDevis!='T');

		oed_debloquerInterface();

		document.getElementById('oed-bOuvrirCommentairesCaches').disabled = false;

		oed_calculerPoids();

		if (client_connu) {
			document.getElementById('oed-Indications').value = contenu.getAttribute("Indications");

			var francoPort = contenu.getAttribute('Franco_Port')=="true";
			var montantFranco = contenu.getAttribute("Montant_Franco");
			oed_majFrancoPort(francoPort, montantFranco);
		}

		oed_changerTypeEdition(typeEdition);

		oed_loadRecapitulatif();

		oed_chargementEnCours = false;
		oed_setModified(false);

		oed_aLignes.setParam("Devis_Id", oed_devisId);
		oed_aLignes.initTree(oed_chargerDevis2);

	} catch (e) {
    recup_erreur(e);
  }
}


function oed_chargerDevis2() {
	try {

		oed_aCodesTVAFraisPort.setParam("Code_Pays", document.getElementById("oed-Code_Pays_Liv").value);
    oed_aCodesTVAFraisPort.setParam("Regime_TVA", document.getElementById("oed-Regime_TVA").value);
    oed_aCodesTVAFraisPort.setParam("Assujetti_TVA", oed_assujettiTVA);
		oed_aCodesTVAFraisPort.setParam("Selection", oed_codeTVAPort);
		oed_aCodesTVAFraisPort.initTree(oed_selectionTvaPort);

	} catch (e) {
    recup_erreur(e);
  }
}


function oed_validerDevis() {
	try {

		var montantBase = (oed_editionTTC?oed_montantTTC:oed_montantHT);
		var remise = document.getElementById('oed-Remise').value;

		if (oed_aLignes.nbLignes()<=0) {
			showWarning("Le devis ne contient aucune ligne !");
		}
		else if (isEmpty(remise) || (oed_typeRemise=='P'?!isTaux(remise):!isPositiveOrNull(remise) || !checkNumber(remise,9,2) || parseFloat(remise)>montantBase)) {
			showWarning("Remise incorrecte !");
		}
		else {
			document.getElementById('oed-bValiderDevis').disabled = true;

			if (window.confirm("Voulez-vous valider le devis ?")) {

				var qValider = new QueryHttp("Facturation/Devis/validDevis.tmpl");
				qValider.setParam("Devis_Id", oed_devisId);
				var result = qValider.execute();

				var errors = new Errors(result);
				if (errors.hasNext()) {
					errors.show();
				}
				else {
					showMessage("Le devis est valid\u00E9");
					oed_chargerDevis();
				}
			}
			else {
				document.getElementById('oed-bValiderDevis').disabled = false;
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oed_selectionTvaPort() {
  try {
   	document.getElementById('oed-codeTVAFraisPort').value = oed_codeTVAPort;
		oed_tauxTVAPort = getTva(oed_codeTVAPort);
		oed_selectPaysLiv();

  } catch (e) {
    recup_erreur(e);
  }
}



function oed_loadRecapitulatif() {
	try {

		var qRecap = new QueryHttp("Facturation/Devis/getRecapitulatifDC.tmpl");
		qRecap.setParam("Devis_Id", oed_devisId);
		var result = qRecap.execute();
		var contenu = result.responseXML.documentElement;

		document.getElementById('oed-caHT').value = contenu.getAttribute("CAHT") +" \u20AC";
		document.getElementById('oed-paHT').value = contenu.getAttribute("PAHT") +" \u20AC";
		document.getElementById('oed-margeHT').value = contenu.getAttribute("Marge_HT") +" \u20AC";
		document.getElementById('oed-tauxMarque').value = contenu.getAttribute("Taux_Marque") +" %";
		document.getElementById('oed-tauxMarge').value = contenu.getAttribute("Taux_Marge") +" %";
		document.getElementById('oed-nbLignes').value = contenu.getAttribute("Nb_Lignes");
		document.getElementById('oed-qteArticles').value = contenu.getAttribute("Qte_Articles");
		document.getElementById('oed-pictoMargeNegative').collapsed = true;
		if (contenu.getAttribute("Marge_Negative")=="true") {
			document.getElementById('oed-lblMargeHT').setAttribute("style", "color:red");
			document.getElementById('oed-margeHT').setAttribute("style", "color:red");
			document.getElementById('oed-lblTauxMarque').setAttribute("style", "color:red");
			document.getElementById('oed-tauxMarque').setAttribute("style", "color:red");
			document.getElementById('oed-lblTauxMarge').setAttribute("style", "color:red");
			document.getElementById('oed-tauxMarge').setAttribute("style", "color:red");
			document.getElementById('oed-pictoMargeNegative').collapsed = false;
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oed_editerDevis() {
  try {

		if (oed_aLignes.nbLignes()<=0) {
			showWarning("Le devis ne contient aucune ligne !");
		}
		else {
			oed_typeEditionPdf = "DC";
			oed_docIdPdf = oed_devisId;
			document.getElementById('oed-sansTotaux').collapsed = false;
			document.getElementById('oed-sansTotaux').checked = false;
			oed_editionInit = false;

			var qLangueDefaut = new QueryHttp("Facturation/Commun/getLangueDefaut.tmpl");
			qLangueDefaut.setParam("Type_Doc", "DC");
			qLangueDefaut.setParam("Doc_Id", oed_devisId);
			var result = qLangueDefaut.execute();
			oed_langueDefaut = result.responseXML.documentElement.getAttribute("Langue_Id");
			oed_aLangues.setParam("Selection", oed_langueDefaut);
			oed_aLangues.initTree(oed_initLangue);
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oed_visualiserDevis() {
  try {

  	document.getElementById('oed-pdfDevis').setAttribute('src', '');
		document.getElementById('oed-deckDevis').selectedIndex = 1;
		document.getElementById('bRetourDevis').collapsed = false;

		var qGenPdf = new QueryHttp("Facturation/Devis/pdfDevis.tmpl");
		qGenPdf.setParam('Devis_Id', oed_devisId);
		qGenPdf.setParam('Langue_Id', document.getElementById('oed-langueDefaut').value);
		qGenPdf.setParam('Show_Totaux', !document.getElementById('oed-sansTotaux').checked);
		qGenPdf.setParam('Edition_Init', oed_editionInit);

		var result = qGenPdf.execute();
		var page = getDirPdf() + result.responseXML.documentElement.getAttribute('FichierPDF');
		document.getElementById('oed-pdfDevis').setAttribute("src", page);

	} catch (e) {
    recup_erreur(e);
  }
}


function oed_editerProforma() {
  try {

		if (oed_aLignes.nbLignes()<=0) {
			showWarning("Le devis ne contient aucune ligne !");
		}
		else {
			oed_typeEditionPdf = "PF";
			document.getElementById('oed-sansTotaux').collapsed = true;

			var qCreerProforma = new QueryHttp("Facturation/Devis/transDevisProforma.tmpl");
			qCreerProforma.setParam("Devis_Id", oed_devisId);
			var result = qCreerProforma.execute();
			var proformaId = result.responseXML.documentElement.getAttribute("Proforma_Id");
			oed_docIdPdf = proformaId;

			var qLangueDefaut = new QueryHttp("Facturation/Commun/getLangueDefaut.tmpl");
			qLangueDefaut.setParam("Type_Doc", "PF");
			qLangueDefaut.setParam("Doc_Id", proformaId);
			var result = qLangueDefaut.execute();
			oed_langueDefaut = result.responseXML.documentElement.getAttribute("Langue_Id");
			oed_aLangues.setParam("Selection", oed_langueDefaut);
			oed_aLangues.initTree(oed_initLangue);
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oed_visualiserProforma() {
  try {

  	document.getElementById('oed-pdfDevis').setAttribute('src', '');
		document.getElementById('oed-deckDevis').selectedIndex = 1;
		document.getElementById('bRetourDevis').collapsed = false;

		var qGenPdf = new QueryHttp("Facturation/Proforma/pdfProforma.tmpl");
		qGenPdf.setParam('Proforma_Id', oed_docIdPdf);
		qGenPdf.setParam('Langue_Id', document.getElementById('oed-langueDefaut').value);

		var result = qGenPdf.execute();
		var page = getDirPdf() + result.responseXML.documentElement.getAttribute('FichierPDF');
		document.getElementById('oed-pdfDevis').setAttribute("src", page);

	} catch (e) {
    recup_erreur(e);
  }
}


function oed_initLangue() {
	try {

		document.getElementById('oed-langueDefaut').value = oed_langueDefaut;
		oed_reediterPdf();

	} catch (e) {
		recup_erreur(e);
	}
}


function oed_reediterPdf() {
	try {

		if (oed_typeEditionPdf=="PF") {
			oed_visualiserProforma();
		}
		else {
			oed_visualiserDevis();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oed_editerDevisInitial() {
	try {

		oed_editionInit = true;
		oed_typeEditionPdf = "DC";
		oed_docIdPdf = oed_devisId;
		document.getElementById('oed-sansTotaux').collapsed = false;
		document.getElementById('oed-sansTotaux').checked = false;

		var qLangueDefaut = new QueryHttp("Facturation/Commun/getLangueDefaut.tmpl");
		qLangueDefaut.setParam("Type_Doc", "DCI");
		qLangueDefaut.setParam("Doc_Id", oed_devisId);
		var result = qLangueDefaut.execute();
		oed_langueDefaut = result.responseXML.documentElement.getAttribute("Langue_Id");
		oed_aLangues.setParam("Selection", oed_langueDefaut);
		oed_aLangues.initTree(oed_initLangue);

	} catch (e) {
		recup_erreur(e);
	}
}


function oed_envoyerMail() {
	try {

		var langue = document.getElementById('oed-langueDefaut').value;
		var sansTotaux = document.getElementById('oed-sansTotaux').checked;

		var url = "chrome://opensi/content/popup/popup-envoyerMail.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', oed_typeEditionPdf, oed_docIdPdf, langue, !sansTotaux, oed_editionInit);

	}	catch (e) {
    recup_erreur(e);
  }
}


function oed_supprimerDevis() {
  try {

		if (window.confirm("Confirmez-vous la suppression du devis ?")) {

			var qDelete = new QueryHttp("Facturation/Devis/deleteDevis.tmpl");
			qDelete.setParam("Devis_Id", oed_devisId);
			var result = qDelete.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				showMessage("Le devis a \u00E9t\u00E9 supprim\u00E9");
				retourMenuDevis();
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oed_copierDevis(copyType) {
	try {

		if (window.confirm(copyType?"Voulez-vous copier le devis en devis type ?":"Voulez-vous copier le devis ?")) {
			var qCopy = new QueryHttp("Facturation/Devis/duplicateDevis.tmpl");
			qCopy.setParam("Devis_Id", oed_devisId);
			qCopy.setParam("Copy_Type", copyType);
			var result = qCopy.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				var newDevisId = result.responseXML.documentElement.getAttribute('Devis_Id');
				oed_devisId = newDevisId;
				oed_chargerDevis();
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oed_editerCommentaire() {
  try {

		if (oed_aLignes.isSelected()) {
			var ligneId = oed_aLignes.getSelectedCellText('oed-colLigneId');
			var msgConfirm = oed_devisType && oed_etatDevis!='N'?"ATTENTION : Devis type !\nConfirmez-vous la modification du devis ?":null;

			var url = "chrome://opensi/content/facturation/user/commun/popup-commentairesLigne.xul";
    	window.openDialog(url,'','chrome,modal,centerscreen', "DC", ligneId, msgConfirm);

			oed_aLignes.initTree(oed_afterRefreshArticles);
			oed_ajouterLigne("I");
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oed_editerPrixAchat() {
  try {

		if (!gReadOnly && !isEmpty(oed_ligneId) && gAccesCoutAchat && gProfil.isModifPADV()) {
			var url = "chrome://opensi/content/facturation/user/commun/popup-modifierPrixAchat.xul";
    	window.openDialog(url,'','chrome,modal,centerscreen', oed_retourEditerPrixAchat, "DC", oed_ligneId);
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oed_retourEditerPrixAchat() {
	try {

		oed_aLignes.initTree(oed_afterRefreshArticles);
		oed_ajouterLigne("I");

	} catch (e) {
		recup_erreur(e);
	}
}


function oed_editerCommentairesInternes() {
  try {

		var url = "chrome://opensi/content/facturation/user/commun/popup-commentairesInternes.xul";
  	window.openDialog(url,'','chrome,modal,centerscreen', "DC", oed_devisId, gReadOnly);

	} catch (e) {
    recup_erreur(e);
  }
}


function oed_editerCommentairesDocument() {
  try {

		var commentairesFin = document.getElementById('oed-Commentaires_Fin').value;
		var commentairesInt = document.getElementById('oed-Commentaires_Int').value;
		var readOnly = (oed_mode=="V" || gReadOnly);
		var msgConfirm = oed_devisType && oed_etatDevis!='N'?"ATTENTION : Devis type !\nConfirmez-vous la modification du devis ?":null;

		var url = "chrome://opensi/content/facturation/user/commun/popup-commentairesDocument.xul";
  	window.openDialog(url,'','chrome,modal,centerscreen', oed_retourEditerCommentaires, "DC", oed_devisId, commentairesFin, commentairesInt, readOnly, msgConfirm);

	} catch (e) {
    recup_erreur(e);
  }
}


function oed_retourEditerCommentaires(commentairesFin, commentairesInt) {
  try {

		document.getElementById('oed-Commentaires_Fin').value = commentairesFin;
		document.getElementById('oed-Commentaires_Int').value = commentairesInt;

	} catch (e) {
    recup_erreur(e);
  }
}


function oed_charger_coord() {
  try {

		var qGet = new QueryHttp("Facturation/Clients/getDefautDocumentVente.tmpl");
		qGet.setParam("Client_Id", oed_clientId);
		var result = qGet.execute();

		var contenu = result.responseXML.documentElement;

		oed_chargerSiteWeb("");
		oed_chargerResponsables(gConfig.isGDCRespCreateur()?gProfil.getLoggedUser():contenu.getAttribute('Util_R'));
		document.getElementById("oed-Remise").value = contenu.getAttribute("Taux_Remise");
		document.getElementById("oed-Escompte").value = contenu.getAttribute("Taux_Escompte");
		document.getElementById('oed-bRemise').setAttribute("class", "bIcoPourcentage");
		oed_typeRemise = 'P';
		oed_chargerTarifsVente(contenu.getAttribute("Tarif_Id"));
		oed_chargerModesReglements(contenu.getAttribute('Mode_Reg_Id'));
		oed_chargerModesExpedition(contenu.getAttribute('Mode_Expedition'));
		oed_assujettiTVA = contenu.getAttribute("Assujetti_TVA")=="true";
		document.getElementById('oed-Assujetti_TVA').checked = oed_assujettiTVA;
		document.getElementById('oed-Num_TVA').disabled = !oed_assujettiTVA;
		document.getElementById('oed-Num_TVA').value = contenu.getAttribute("Num_TVA_Intra");
		oed_chargerPolesActivite(contenu.getAttribute('Pole_Activite'));
		document.getElementById('oed-Regime_TVA').value = contenu.getAttribute("Regime_TVA");

		document.getElementById('oed-Indications').value = contenu.getAttribute("Indications");
		document.getElementById('oed-numClient').value = contenu.getAttribute("Num_Client");

		document.getElementById("oed-Denomination_Fact").value = contenu.getAttribute("Denomination_Fact");
		document.getElementById("oed-Adresse_1_Fact").value = contenu.getAttribute("Adresse_1_Fact");
		document.getElementById("oed-Adresse_2_Fact").value = contenu.getAttribute("Adresse_2_Fact");
		document.getElementById("oed-Adresse_3_Fact").value = contenu.getAttribute("Adresse_3_Fact");
		document.getElementById("oed-Code_Postal_Fact").value = contenu.getAttribute("Code_Postal_Fact");
		document.getElementById("oed-Ville_Fact").value = contenu.getAttribute("Ville_Fact");
    document.getElementById("oed-Code_Pays_Fact").value = contenu.getAttribute("Code_Pays_Fact");
		document.getElementById("oed-Civ_Inter_Fact").value = contenu.getAttribute("Civ_Inter_Fact");
		document.getElementById("oed-Nom_Inter_Fact").value = contenu.getAttribute("Nom_Inter_Fact");
		document.getElementById("oed-Prenom_Inter_Fact").value = contenu.getAttribute("Prenom_Inter_Fact");
		document.getElementById("oed-Tel_Inter_1_Fact").value = contenu.getAttribute("Tel_Inter_1_Fact");
		document.getElementById("oed-Tel_Inter_2_Fact").value = contenu.getAttribute("Tel_Inter_2_Fact");
		document.getElementById("oed-Fax_Inter_Fact").value = contenu.getAttribute("Fax_Inter_Fact");
		document.getElementById("oed-Email_Inter_Fact").value = contenu.getAttribute("Email_Inter_Fact");

		document.getElementById("oed-Denomination_Liv").value = contenu.getAttribute("Denomination_Liv");
		document.getElementById("oed-Adresse_1_Liv").value = contenu.getAttribute("Adresse_1_Liv");
		document.getElementById("oed-Adresse_2_Liv").value = contenu.getAttribute("Adresse_2_Liv");
		document.getElementById("oed-Adresse_3_Liv").value = contenu.getAttribute("Adresse_3_Liv");
		document.getElementById("oed-Code_Postal_Liv").value = contenu.getAttribute("Code_Postal_Liv");
		document.getElementById("oed-Ville_Liv").value = contenu.getAttribute("Ville_Liv");
    document.getElementById("oed-Code_Pays_Liv").value = contenu.getAttribute("Code_Pays_Liv");
    document.getElementById("oed-Civ_Inter_Liv").value = contenu.getAttribute("Civ_Inter_Liv");
		document.getElementById("oed-Nom_Inter_Liv").value = contenu.getAttribute("Nom_Inter_Liv");
		document.getElementById("oed-Prenom_Inter_Liv").value = contenu.getAttribute("Prenom_Inter_Liv");
		document.getElementById("oed-Tel_Inter_1_Liv").value = contenu.getAttribute("Tel_Inter_1_Liv");
		document.getElementById("oed-Tel_Inter_2_Liv").value = contenu.getAttribute("Tel_Inter_2_Liv");
		document.getElementById("oed-Fax_Inter_Liv").value = contenu.getAttribute("Fax_Inter_Liv");
		document.getElementById("oed-Email_Inter_Liv").value = contenu.getAttribute("Email_Inter_Liv");

		document.getElementById("oed-Denomination_Envoi").value = contenu.getAttribute("Denomination_EDC");
		document.getElementById("oed-Adresse_1_Envoi").value = contenu.getAttribute("Adresse_1_EDC");
		document.getElementById("oed-Adresse_2_Envoi").value = contenu.getAttribute("Adresse_2_EDC");
		document.getElementById("oed-Adresse_3_Envoi").value = contenu.getAttribute("Adresse_3_EDC");
		document.getElementById("oed-Code_Postal_Envoi").value = contenu.getAttribute("Code_Postal_EDC");
		document.getElementById("oed-Ville_Envoi").value = contenu.getAttribute("Ville_EDC");
    document.getElementById("oed-Code_Pays_Envoi").value = contenu.getAttribute("Code_Pays_EDC");
    document.getElementById("oed-Civ_Inter_Envoi").value = contenu.getAttribute("Civ_Inter_EDC");
		document.getElementById("oed-Nom_Inter_Envoi").value = contenu.getAttribute("Nom_Inter_EDC");
		document.getElementById("oed-Prenom_Inter_Envoi").value = contenu.getAttribute("Prenom_Inter_EDC");
		document.getElementById("oed-Tel_Inter_1_Envoi").value = contenu.getAttribute("Tel_Inter_1_EDC");
		document.getElementById("oed-Tel_Inter_2_Envoi").value = contenu.getAttribute("Tel_Inter_2_EDC");
		document.getElementById("oed-Fax_Inter_Envoi").value = contenu.getAttribute("Fax_Inter_EDC");
		document.getElementById("oed-Email_Inter_Envoi").value = contenu.getAttribute("Email_Inter_EDC");

		document.getElementById('oed-bCreerClient').collapsed = true;
    oed_listeTVAFraisPort();
    oed_selectPaysLiv();

		var client_connu = !isEmpty(oed_clientId);
   	document.getElementById('oed-chercher_adrliv').disabled = (!client_connu || (oed_aLignes.nbLignes()>0 && oed_etatDevis!="N"));
   	document.getElementById('oed-bCopierFactVersLivEnvoi').disabled = (oed_mode=='V' || (oed_aLignes.nbLignes()>0 && oed_etatDevis!="N"));
    document.getElementById('oed-Tarif_Id').disabled = (oed_aLignes.nbLignes()>0);
		document.getElementById('oed-chercher_adrfact').disabled = !client_connu;
		document.getElementById('oed-chercher_inter').disabled = !client_connu;
		document.getElementById('oed-chercher_inter_liv').disabled = !client_connu;
		document.getElementById('oed-chercher_adrenvoi').disabled = !client_connu;
		document.getElementById('oed-chercher_inter_envoi').disabled = !client_connu;

		if (client_connu) {
			var francoPort = contenu.getAttribute('Franco_Port')=="true";
			var montantFranco = contenu.getAttribute("Montant_Franco");
			oed_majFrancoPort(francoPort, montantFranco);
		}

		oed_ajouterLigne("I");

	} catch (e) {
  	recup_erreur(e);
  }
}


function oed_rechercherClient() {
  try {

		var url = "chrome://opensi/content/facturation/user/clients/popup-rechercheClient.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', oed_retourRechercherClient, true, true);

	} catch (e) {
  	recup_erreur(e);
  }
}


function oed_retourRechercherClient(numClient, clientId) {
	try {

		oed_changerClient(clientId);

	} catch (e) {
		recup_erreur(e);
	}
}


function oed_changerClient(clientId) {
	try {

		var changementClientPossible = oed_etatDevis=='N' || oed_aLignes.nbLignes()==0;

		if (!changementClientPossible) {
			var qCheckChgtClient = new QueryHttp("Facturation/Clients/getDefautDocumentVente.tmpl");
			qCheckChgtClient.setParam("Client_Id", clientId);
			var result = qCheckChgtClient.execute();
			var contenu = result.responseXML.documentElement;
			var ancCodePaysLiv = document.getElementById('oed-Code_Pays_Liv').value;
			var nouvCodePaysLiv = contenu.getAttribute('Code_Pays_Liv');
			var ancAssujettiTVA = document.getElementById('oed-Assujetti_TVA').checked;
			var nouvAssujettiTVA = contenu.getAttribute('Assujetti_TVA')=="true";
			var ancRegimeTVA = document.getElementById('oed-Regime_TVA').value;
			var nouvRegimeTVA = contenu.getAttribute('Regime_TVA');

			if (ancCodePaysLiv!=nouvCodePaysLiv) { showWarning("Impossible de changer le client car le code pays de livraison n'est pas identique."); }
			else if (ancAssujettiTVA!=nouvAssujettiTVA) { showWarning("Impossible de changer le client car le statut de la case 'Assujetti TVA' n'est pas identique."); }
			else if (ancRegimeTVA!=nouvRegimeTVA) { showWarning("Impossible de changer le client car le r\u00E9gime de TVA n'est pas identique."); }
			else {
				changementClientPossible = true;
			}
		}

		if (changementClientPossible) {
			oed_clientId = clientId;
			oed_charger_coord();
			oed_setModified(true);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oed_evaluer(field, ev) {
	try {

		var val = field.value;

		if (ev.keyCode==13 && !isEmpty(val) && isArithmetic(val)) {
			field.value = calcExpr(val);
		}

	}	catch(e) {
		recup_erreur(e);
	}
}


function oed_pressOnLineNumberField(field, ev) {
	try {

		var val = field.value;

		if (ev.keyCode==13 && !isEmpty(val)) {
			if (isArithmetic(val)) {
				field.value = calcExpr(val);
			}
			else {
				oed_validerLigne();
			}
		}

	}	catch(e) {
		recup_erreur(e);
	}
}


function oed_changerTypeEdition(chgType) {
	try {

		oed_editionTTC = chgType;

		if (oed_editionTTC) {
			document.getElementById('oed-ColTotal').setAttribute("label", "Total TTC");
			document.getElementById('oed-ColPU').setAttribute("label", "P.U TTC");
			document.getElementById('oed-lblFrais_Port').value = "Frais de port (ttc) :";
			document.getElementById('oed-lblPU').value = "P.U TTC :";
			document.getElementById('oed-piedTTC').collapsed = false;
			document.getElementById('oed-piedHT').collapsed = true;
		}
		else {
			document.getElementById('oed-ColTotal').setAttribute("label", "Total HT");
			document.getElementById('oed-ColPU').setAttribute("label", "P.U HT");
			document.getElementById('oed-lblFrais_Port').value = "Frais de port (ht) :";
			document.getElementById('oed-lblPU').value = "P.U HT :";
			document.getElementById('oed-piedTTC').collapsed = true;
			document.getElementById('oed-piedHT').collapsed = false;
		}

	}	catch(e) {
		recup_erreur(e);
	}
}


function oed_changerAssujettiTVA(etat) {
	try {

		oed_assujettiTVA = etat;
		document.getElementById('oed-Num_TVA').disabled=!oed_assujettiTVA;
		oed_listeTVA();
		oed_setModified(true);

	}	catch(e) {
		recup_erreur(e);
	}
}


function oed_changerTypeVente() {
	try {

	  var qZoneUE = new QueryHttp("Facturation/Commun/getZoneUEPays.tmpl");
	  qZoneUE.setParam("Code_Pays", document.getElementById("oed-Code_Pays_Liv").value);
	  var result = qZoneUE.execute();
	  oed_zoneUE = (result.responseXML.documentElement.getAttribute("Zone_UE")=="true");

	}	catch(e) {
		recup_erreur(e);
	}
}


function oed_rechercherAdrFact() {
  try {

		var url = "chrome://opensi/content/facturation/user/commun/popup-choixAdresse.xul";
    window.openDialog(url,'','chrome,modal,centerscreen', oed_reporterAdrFact, oed_clientId, gReadOnly);

	} catch (e) {
  	recup_erreur(e);
  }
}


function oed_reporterAdrFact(nom, adr1, adr2, adr3, cp, ville, pays, code_pays, contact_fact, contact_liv, contact_envoi, contact_devis, adresseId) {
  try {

		document.getElementById("oed-Denomination_Fact").value = nom;
		document.getElementById("oed-Adresse_1_Fact").value = adr1;
		document.getElementById("oed-Adresse_2_Fact").value = adr2;
		document.getElementById("oed-Adresse_3_Fact").value = adr3;
		document.getElementById("oed-Code_Postal_Fact").value = cp;
		document.getElementById("oed-Ville_Fact").value = ville;
	  document.getElementById("oed-Code_Pays_Fact").value = code_pays;

	  if (!isEmpty(contact_fact)) {
	  	var qLoad = new QueryHttp("Facturation/Clients/loadContactClient.tmpl");
	  	qLoad.setParam("Contact_Id", contact_fact);
	  	var result = qLoad.execute();
	  	var contenu = result.responseXML.documentElement;
	  	oed_reporterInterFact(contenu.getAttribute("Civilite"),contenu.getAttribute("Nom"),contenu.getAttribute("Prenom"),contenu.getAttribute("Tel_1"),contenu.getAttribute("Tel_2"),contenu.getAttribute("Fax"),contenu.getAttribute("Email"));
	  }
		oed_setModified(true);

	} catch (e) {
  	recup_erreur(e);
  }
}


function oed_rechercherInterlocuteurFact() {
  try {

		var url = "chrome://opensi/content/facturation/user/commun/popup-choixInter.xul";
    window.openDialog(url,'','chrome,modal,centerscreen', oed_reporterInterFact, oed_clientId, gReadOnly);

	} catch (e) {
  	recup_erreur(e);
  }
}


function oed_reporterInterFact(civ, nom, prenom, tel1, tel2, fax, email) {
  try {

		document.getElementById("oed-Civ_Inter_Fact").value = civ;
		document.getElementById("oed-Nom_Inter_Fact").value = nom;
		document.getElementById("oed-Prenom_Inter_Fact").value = prenom;
		document.getElementById("oed-Tel_Inter_1_Fact").value = tel1;
		document.getElementById("oed-Tel_Inter_2_Fact").value = tel2;
		document.getElementById("oed-Fax_Inter_Fact").value = fax;
		document.getElementById("oed-Email_Inter_Fact").value = email;

		oed_setModified(true);

	} catch (e) {
  	recup_erreur(e);
  }
}


function oed_rechercherAdrEnvoi() {
  try {

		var url = "chrome://opensi/content/facturation/user/commun/popup-choixAdresse.xul";
    window.openDialog(url,'','chrome,modal,centerscreen', oed_reporterAdrEnvoi, oed_clientId, gReadOnly);

	} catch (e) {
  	recup_erreur(e);
  }
}


function oed_reporterAdrEnvoi(nom, adr1, adr2, adr3, cp, ville, pays, code_pays, contact_fact, contact_liv, contact_envoi, contact_devis, adresseId) {
  try {

		document.getElementById("oed-Denomination_Envoi").value = nom;
		document.getElementById("oed-Adresse_1_Envoi").value = adr1;
		document.getElementById("oed-Adresse_2_Envoi").value = adr2;
		document.getElementById("oed-Adresse_3_Envoi").value = adr3;
		document.getElementById("oed-Code_Postal_Envoi").value = cp;
		document.getElementById("oed-Ville_Envoi").value = ville;
	  document.getElementById("oed-Code_Pays_Envoi").value = code_pays;

	   if (!isEmpty(contact_devis)) {
	  	var qLoad = new QueryHttp("Facturation/Clients/loadContactClient.tmpl");
	  	qLoad.setParam("Contact_Id", contact_devis);
	  	var result = qLoad.execute();
	  	var contenu = result.responseXML.documentElement;
	  	oed_reporterInterEnvoi(contenu.getAttribute("Civilite"),contenu.getAttribute("Nom"),contenu.getAttribute("Prenom"),contenu.getAttribute("Tel_1"),contenu.getAttribute("Tel_2"),contenu.getAttribute("Fax"),contenu.getAttribute("Email"));
	  }

		oed_setModified(true);

	} catch (e) {
  	recup_erreur(e);
  }
}


function oed_copierFactVersLivEnvoi() {
	try {
		document.getElementById('oed-Denomination_Liv').value = document.getElementById('oed-Denomination_Fact').value;
		document.getElementById("oed-Adresse_1_Liv").value = document.getElementById("oed-Adresse_1_Fact").value;
		document.getElementById("oed-Adresse_2_Liv").value = document.getElementById("oed-Adresse_2_Fact").value;
		document.getElementById("oed-Adresse_3_Liv").value = document.getElementById("oed-Adresse_3_Fact").value;
		document.getElementById("oed-Code_Postal_Liv").value = document.getElementById("oed-Code_Postal_Fact").value;
		document.getElementById("oed-Ville_Liv").value = document.getElementById("oed-Ville_Fact").value;
	  document.getElementById("oed-Code_Pays_Liv").value = document.getElementById("oed-Code_Pays_Fact").value;
		oed_listeTVAFraisPort();
		oed_selectPaysLiv();

	  document.getElementById("oed-Civ_Inter_Liv").value = document.getElementById("oed-Civ_Inter_Fact").value;
		document.getElementById("oed-Nom_Inter_Liv").value = document.getElementById("oed-Nom_Inter_Fact").value;
		document.getElementById("oed-Prenom_Inter_Liv").value = document.getElementById("oed-Prenom_Inter_Fact").value;
		document.getElementById("oed-Tel_Inter_1_Liv").value = document.getElementById("oed-Tel_Inter_1_Fact").value;
		document.getElementById("oed-Tel_Inter_2_Liv").value = document.getElementById("oed-Tel_Inter_2_Fact").value;
		document.getElementById("oed-Fax_Inter_Liv").value = document.getElementById("oed-Fax_Inter_Fact").value;
		document.getElementById("oed-Email_Inter_Liv").value = document.getElementById("oed-Email_Inter_Fact").value;

		document.getElementById('oed-Denomination_Envoi').value = document.getElementById('oed-Denomination_Fact').value;
		document.getElementById("oed-Adresse_1_Envoi").value = document.getElementById("oed-Adresse_1_Fact").value;
		document.getElementById("oed-Adresse_2_Envoi").value = document.getElementById("oed-Adresse_2_Fact").value;
		document.getElementById("oed-Adresse_3_Envoi").value = document.getElementById("oed-Adresse_3_Fact").value;
		document.getElementById("oed-Code_Postal_Envoi").value = document.getElementById("oed-Code_Postal_Fact").value;
		document.getElementById("oed-Ville_Envoi").value = document.getElementById("oed-Ville_Fact").value;
	  document.getElementById("oed-Code_Pays_Envoi").value = document.getElementById("oed-Code_Pays_Fact").value;

	  document.getElementById("oed-Civ_Inter_Envoi").value = document.getElementById("oed-Civ_Inter_Fact").value;
		document.getElementById("oed-Nom_Inter_Envoi").value = document.getElementById("oed-Nom_Inter_Fact").value;
		document.getElementById("oed-Prenom_Inter_Envoi").value = document.getElementById("oed-Prenom_Inter_Fact").value;
		document.getElementById("oed-Tel_Inter_1_Envoi").value = document.getElementById("oed-Tel_Inter_1_Fact").value;
		document.getElementById("oed-Tel_Inter_2_Envoi").value = document.getElementById("oed-Tel_Inter_2_Fact").value;
		document.getElementById("oed-Fax_Inter_Envoi").value = document.getElementById("oed-Fax_Inter_Fact").value;
		document.getElementById("oed-Email_Inter_Envoi").value = document.getElementById("oed-Email_Inter_Fact").value;

		oed_setModified(true);
	} catch (e) {
		recup_erreur(e);
	}
}


function oed_rechercherAdrLiv() {
  try {

		var url = "chrome://opensi/content/facturation/user/commun/popup-choixAdresse.xul";
    window.openDialog(url,'','chrome,modal,centerscreen', oed_reporterAdrLiv, oed_clientId, gReadOnly);

	} catch (e) {
  	recup_erreur(e);
  }
}


function oed_reporterAdrLiv(nom, adr1, adr2, adr3, cp, ville, pays, code_pays, contact_fact, contact_liv, contact_envoi, contact_devis, adresseId) {
  try {

		document.getElementById("oed-Denomination_Liv").value = nom;
		document.getElementById("oed-Adresse_1_Liv").value = adr1;
		document.getElementById("oed-Adresse_2_Liv").value = adr2;
		document.getElementById("oed-Adresse_3_Liv").value = adr3;
		document.getElementById("oed-Code_Postal_Liv").value = cp;
		document.getElementById("oed-Ville_Liv").value = ville;
	  document.getElementById("oed-Code_Pays_Liv").value = code_pays;
	  oed_listeTVAFraisPort();
		oed_selectPaysLiv();

		if (!isEmpty(contact_liv)) {
	  	var qLoad = new QueryHttp("Facturation/Clients/loadContactClient.tmpl");
	  	qLoad.setParam("Contact_Id", contact_liv);
	  	var result = qLoad.execute();
	  	var contenu = result.responseXML.documentElement;
	  	oed_reporterInterLiv(contenu.getAttribute("Civilite"),contenu.getAttribute("Nom"),contenu.getAttribute("Prenom"),contenu.getAttribute("Tel_1"),contenu.getAttribute("Tel_2"),contenu.getAttribute("Fax"),contenu.getAttribute("Email"));
	  }
	  oed_setModified(true);

	} catch (e) {
  	recup_erreur(e);
  }
}


function oed_rechercherInterlocuteurLiv() {
  try {

		var url = "chrome://opensi/content/facturation/user/commun/popup-choixInter.xul";
    window.openDialog(url,'','chrome,modal,centerscreen', oed_reporterInterLiv, oed_clientId, gReadOnly);

	} catch (e) {
  	recup_erreur(e);
  }
}


function oed_reporterInterLiv(civ, nom, prenom, tel1, tel2, fax, email) {
  try {

		document.getElementById("oed-Civ_Inter_Liv").value = civ;
		document.getElementById("oed-Nom_Inter_Liv").value = nom;
		document.getElementById("oed-Prenom_Inter_Liv").value = prenom;
		document.getElementById("oed-Tel_Inter_1_Liv").value = tel1;
		document.getElementById("oed-Tel_Inter_2_Liv").value = tel2;
		document.getElementById("oed-Fax_Inter_Liv").value = fax;
		document.getElementById("oed-Email_Inter_Liv").value = email;

		oed_setModified(true);

	} catch (e) {
  	recup_erreur(e);
  }
}


function oed_rechercherInterlocuteurEnvoi() {
  try {

		var url = "chrome://opensi/content/facturation/user/commun/popup-choixInter.xul";
    window.openDialog(url,'','chrome,modal,centerscreen', oed_reporterInterEnvoi, oed_clientId, gReadOnly);

	} catch (e) {
  	recup_erreur(e);
  }
}


function oed_reporterInterEnvoi(civ, nom, prenom, tel1, tel2, fax, email) {
  try {
		document.getElementById("oed-Civ_Inter_Envoi").value = civ;
		document.getElementById("oed-Nom_Inter_Envoi").value = nom;
		document.getElementById("oed-Prenom_Inter_Envoi").value = prenom;
		document.getElementById("oed-Tel_Inter_1_Envoi").value = tel1;
		document.getElementById("oed-Tel_Inter_2_Envoi").value = tel2;
		document.getElementById("oed-Fax_Inter_Envoi").value = fax;
		document.getElementById("oed-Email_Inter_Envoi").value = email;

		oed_setModified(true);
	} catch (e) {
  	recup_erreur(e);
  }
}


function oed_choisirMentions() {
  try {

  	var ok = true;

  	if (oed_mode=="C") {
			ok = oed_enregistrerDevis();
		}

		if (ok) {
			var msgConfirm = oed_devisType && oed_etatDevis!='N'?"ATTENTION : Devis type !\nConfirmez-vous la modification du devis ?":null;

			var url = "chrome://opensi/content/facturation/user/commun/popup-mentionsDocument.xul";
    	window.openDialog(url,'','chrome,modal,centerscreen', "DC", oed_devisId, gReadOnly, msgConfirm);
		}

	} catch (e) {
  	recup_erreur(e);
  }
}


function oed_archiverDevis() {
	try {

		var montantBase = (oed_editionTTC?oed_montantTTC:oed_montantHT);
		var remise = document.getElementById('oed-Remise').value;

		if (isEmpty(remise) || (oed_typeRemise=='P'?!isTaux(remise):!isPositiveOrNull(remise) || !checkNumber(remise,9,2) || parseFloat(remise)>montantBase)) {
			showWarning("Remise incorrecte !");
		}
		else if (window.confirm(oed_devisType?"ATTENTION : Devis type !\nConfirmez-vous l'archivage du devis ?":"Confirmez-vous l'archivage du devis?")) {
			var qArchiver = new QueryHttp("Facturation/Devis/archiveDevis.tmpl");
			qArchiver.setParam("Devis_Id", oed_devisId);
			var result = qArchiver.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}

			oed_chargerDevis();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oed_creerClient() {
	try {

		var denomination_fact = document.getElementById('oed-Denomination_Fact').value;
		var adresse_1_fact = document.getElementById('oed-Adresse_1_Fact').value;
		var adresse_2_fact = document.getElementById('oed-Adresse_2_Fact').value;
		var adresse_3_fact = document.getElementById('oed-Adresse_3_Fact').value;
		var code_postal_fact = document.getElementById('oed-Code_Postal_Fact').value;
		var ville_fact = document.getElementById('oed-Ville_Fact').value;
		var code_pays_fact = document.getElementById('oed-Code_Pays_Fact').value;
		var civ_inter_fact = document.getElementById("oed-Civ_Inter_Fact").value;
		var nom_inter_fact = document.getElementById("oed-Nom_Inter_Fact").value;
		var prenom_inter_fact = document.getElementById("oed-Prenom_Inter_Fact").value;
		var telInter1fact = document.getElementById("oed-Tel_Inter_1_Fact").value;
		var telInter2fact = document.getElementById("oed-Tel_Inter_2_Fact").value;
		var fax_inter_fact = document.getElementById('oed-Fax_Inter_Fact').value;
		var email_inter_fact = document.getElementById('oed-Email_Inter_Fact').value;
		var util_R = document.getElementById('oed-Login_Resp').value;
		var num_tva = oed_assujettiTVA?document.getElementById('oed-Num_TVA').value:"";
		var tarifVente = document.getElementById("oed-Tarif_Id").value;
		var modeReglement = document.getElementById("oed-modeReglement").value;
		var poleActivite = document.getElementById("oed-poleActivite").value;

		var params = "&Denomination_Fact=" + urlEncode(denomination_fact);
		params += "&Adresse_1_Fact=" + urlEncode(adresse_1_fact);
		params += "&Adresse_2_Fact=" + urlEncode(adresse_2_fact);
		params += "&Adresse_3_Fact=" + urlEncode(adresse_3_fact);
		params += "&Code_Postal_Fact=" + urlEncode(code_postal_fact);
		params += "&Ville_Fact=" + urlEncode(ville_fact);
		params += "&Code_Pays_Fact=" + urlEncode(code_pays_fact);
		params += "&Civ_Inter_Fact=" + civ_inter_fact;
		params += "&Nom_Inter_Fact=" + urlEncode(nom_inter_fact);
		params += "&Prenom_Inter_Fact=" + urlEncode(prenom_inter_fact);
		params += "&Tel_Inter_1_Fact=" + urlEncode(telInter1fact);
		params += "&Tel_Inter_2_Fact=" + urlEncode(telInter2fact);
		params += "&Fax_Inter_Fact=" + urlEncode(fax_inter_fact);
		params += "&Email_Inter_Fact=" + urlEncode(email_inter_fact);
		params += "&Util_R=" + util_R;
		params += "&Assujetti_TVA=" + (oed_assujettiTVA?"1":"0");
		params += "&Num_TVA=" + urlEncode(num_tva);
		params += "&Tarif_Id=" + tarifVente;
		params += "&Mode_Reg=" + modeReglement;
		params += "&Pole_Activite=" + poleActivite;
		params += "&Infos_Existantes=1";

		var url = "chrome://opensi/content/facturation/user/commun/popup-creerClient.xul?"+ cookie() + params +"&DefPoleActivite="+ gProfil.getPoleActivite();
    window.openDialog(url,'','chrome,modal,centerscreen', oed_retourCreerClient);

	} catch (e) {
		recup_erreur(e);
	}
}


function oed_retourCreerClient(numClient, clientId) {
	try {

		oed_changerClient(clientId);

	} catch (e) {
		recup_erreur(e);
	}
}


function oed_initVersion() {
	try {

		oed_aVersion.setParam("Devis_Id", oed_devisId);
		oed_aVersion.initTree();

	} catch (e) {
		recup_erreur(e);
	}
}


function oed_majFrancoPort(francoPort, montantFranco) {
	try {

		var lblFrancoPort = "";
		if (!francoPort) { lblFrancoPort = "Non"; }
		else { lblFrancoPort = (parseFloat(montantFranco)==0?"Oui":oed_nfmt.format(montantFranco) +" \u20AC"); }
		document.getElementById('oed-lblFrancoPort').value = lblFrancoPort;
		document.getElementById('oed-rowFrancoPort').collapsed = false;

	} catch (e) {
		recup_erreur(e);
	}
}


function oed_listerHistorique() {
	try {

		var exclureTotaux = document.getElementById('oed-exclureTotaux').checked;
		var histoAvantVal = document.getElementById('oed-histoAvantVal').checked;
		oed_aListeHistorique.setParam("Devis_Id", oed_devisId);
		oed_aListeHistorique.setParam("Exclure_Totaux", exclureTotaux);
		oed_aListeHistorique.setParam("Histo_Avant_Val", histoAvantVal);
		oed_aListeHistorique.initTree();

	} catch (e) {
		recup_erreur(e);
	}
}


function oed_editerHistoriqueCSV() {
	try {

		var exclureTotaux = document.getElementById('oed-exclureTotaux').checked;
		var histoAvantVal = document.getElementById('oed-histoAvantVal').checked;

		var qEditionCsv = new QueryHttp("Facturation/Devis/csvHistoriqueDevis.tmpl");
		qEditionCsv.setParam("Devis_Id", oed_devisId);
		qEditionCsv.setParam("Exclure_Totaux", exclureTotaux);
		qEditionCsv.setParam("Histo_Avant_Val", histoAvantVal);

		var result = qEditionCsv.execute();

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}
		else {
			var fichier = result.responseXML.documentElement.getAttribute('FichierCSV');
			var file = fileChooser("save", fichier);
			if (file!=null) {
				downloadFile(getDirBuffer() + fichier, file);
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oed_chargerTarifsVente(selection) {
	try {

		oed_selTarifVente = selection;
		oed_aTarifsVente.setParam("Selection", oed_selTarifVente);
		oed_aTarifsVente.initTree(oed_initTarifVente);

	} catch (e) {
		recup_erreur(e);
	}
}


function oed_initTarifVente() {
  try {

		document.getElementById('oed-Tarif_Id').value = oed_selTarifVente;

	} catch (e) {
  	recup_erreur(e);
	}
}
