/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/verif.js");



function init() {
	try {



	} catch (e) {
		recup_erreur(e);
	}
}


function creerDeclarationEcoPart() {
	try {

		var typeEcoPart = document.getElementById("typeEcoPart").value;
		var periodeDebut = document.getElementById("periodeDebut").value;
		var periodeFin = document.getElementById("periodeFin").value;

		if (isEmpty(typeEcoPart)) {
			showWarning("Veuillez choisir le type d'\u00E9co-participation");
		}
		else if (!isPeriode(periodeDebut)) {
			showWarning("P\u00E9riode d\u00E9but incorrecte");
		}
		else if (!isPeriode(periodeFin)) {
			showWarning("P\u00E9riode fin incorrecte");
		}
		else if (!isPeriodeInterval(periodeDebut, periodeFin)) {
			showWarning("Plage de p\u00E9riodes incorrecte");
		}
		else {
			var qSave = new QueryHttp("Facturation/EcoPart/createDeclarationEcoPart.tmpl");
			qSave.setParam("Type_Eco_Part", typeEcoPart);
			qSave.setParam("Periode_Debut", periodeDebut);
			qSave.setParam("Periode_Fin", periodeFin);

			var result = qSave.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				var declarationId = result.responseXML.documentElement.getAttribute('Declaration_Id');
				window.arguments[0](declarationId);
				window.close();
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}
