/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/


var ome_aFamille2 = new Arbre('ComboListe/combo-famillesArticle.tmpl', 'ome-famille2');
var ome_aFamille3 = new Arbre('ComboListe/combo-famillesArticle.tmpl', 'ome-famille3');

var ome_currentCodeEdition;
var ome_web;
var ome_direction;



function ome_init() {
  try {

		ome_enableDates(false);
		ome_clickOnComparatif();

		var profil = getProfil();

		ome_direction = profil.isDirection();

		if (!ome_direction) {
			document.getElementById('ome-responsableClient').disabled = true;
			document.getElementById('ome-responsableFournisseur').disabled = true;
		}

		document.getElementById('ome-miProvenanceHL').collapsed = !profil.isProvenanceHL();

		var aFamilleClient = new Arbre('ComboListe/combo-famillesClient.tmpl', 'ome-familleClient');
		aFamilleClient.initTree();

		var aRespClient = new Arbre('ComboListe/combo-responsables.tmpl', 'ome-responsableClient');
		aRespClient.initTree(ome_initRespClient);

		var aRespFournisseur = new Arbre('ComboListe/combo-responsables.tmpl', 'ome-responsableFournisseur');
		aRespFournisseur.initTree(ome_initRespFournisseur);

		var aFamilleFournisseur = new Arbre('ComboListe/combo-famillesFournisseur.tmpl', 'ome-familleFournisseur');
		aFamilleFournisseur.initTree();

		var aFamille1 = new Arbre('ComboListe/combo-famillesArticle.tmpl', 'ome-famille1');
		aFamille1.initTree();

		var aMarques = new Arbre('ComboListe/combo-marquesArticle.tmpl', 'ome-marque');
		aMarques.initTree();

		var aDepots = new Arbre('ComboListe/combo-depotsStock.tmpl', 'ome-depotStock');
		aDepots.initTree();

		var config = getConfig();

		document.getElementById('ome-bEditionVLE').collapsed = !config.isSpecLHELE();
		document.getElementById('ome-bEditionVRC').collapsed = !config.isActReassortCC();
		document.getElementById('ome-bEditionVAR').collapsed = !config.isSpecSMEAR();
		document.getElementById('ome-bEditionVCS').collapsed = !config.isActCodeStats();
		document.getElementById('ome-bEditionVFV').collapsed = !config.isSpecEDEFV();
		document.getElementById('ome-bEditionVRE').collapsed = !config.isSpecREERC();
		document.getElementById('ome-bEditionVCR').collapsed = !config.isSpecLMECR();
		document.getElementById('ome-bEditionVHP').collapsed = !config.isSpecKEESK();
		document.getElementById('ome-bEditionASF').collapsed = !config.isSpecLHFNP();
		document.getElementById('ome-bEditionASD').collapsed = !config.isSpecHMDNP();
		document.getElementById('ome-bEditionVCT').collapsed = !config.isGACCoutTrans();

		document.getElementById('ome-bEditionCPC').disabled = !profil.isEditionDES_CPC();
		document.getElementById('ome-bEditionCLC').disabled = !profil.isEditionDES_CLC();
		document.getElementById('ome-bEditionFPF').disabled = !profil.isEditionDES_FPF();
		document.getElementById('ome-bEditionFLF').disabled = !profil.isEditionDES_FLF();
		document.getElementById('ome-bEditionSPA').disabled = !profil.isEditionDES_SPA();
		document.getElementById('ome-bEditionSFA').disabled = !profil.isEditionDES_SFA();
		document.getElementById('ome-bEditionSMS').disabled = !profil.isEditionDES_SMS();
		document.getElementById('ome-bEditionSES').disabled = !profil.isEditionDES_SES();
		document.getElementById('ome-bEditionSRS').disabled = !profil.isEditionDES_SRS();
		document.getElementById('ome-bEditionSPF').disabled = !profil.isEditionDES_SPF();
		document.getElementById('ome-bEditionSMA').disabled = !profil.isEditionDES_SMA();
		document.getElementById('ome-bEditionVJV').disabled = !profil.isEditionDES_VJV();
		document.getElementById('ome-bEditionVJA').disabled = !profil.isEditionDES_VJA();
		document.getElementById('ome-bEditionVVA').disabled = !profil.isEditionDES_VVA();
		document.getElementById('ome-bEditionVFA').disabled = !profil.isEditionDES_VFA();
		document.getElementById('ome-bEditionVFC').disabled = !profil.isEditionDES_VFC();
		document.getElementById('ome-bEditionVFD').disabled = !profil.isEditionDES_VFD();
		document.getElementById('ome-bEditionVSC').disabled = !profil.isEditionDES_VSC();
		document.getElementById('ome-bEditionVLE').disabled = !profil.isEditionDES_VLE();
		document.getElementById('ome-bEditionVLC').disabled = !profil.isEditionDES_VLC();
		document.getElementById('ome-bEditionVEC').disabled = !profil.isEditionDES_VEC();
		document.getElementById('ome-bEditionVCT').disabled = !profil.isEditionDES_VCT();
		document.getElementById('ome-bEditionVRC').disabled = !profil.isEditionDES_VRC();
		document.getElementById('ome-bEditionVAR').disabled = !profil.isEditionDES_VAR();
		document.getElementById('ome-bEditionVCS').disabled = !profil.isEditionDES_VCS();
		document.getElementById('ome-bEditionVFV').disabled = !profil.isEditionDES_VFV();
		document.getElementById('ome-bEditionVRE').disabled = !profil.isEditionDES_VRE();
		document.getElementById('ome-bEditionVCR').disabled = !profil.isEditionDES_VCR();
		document.getElementById('ome-bEditionVHP').disabled = !profil.isEditionDES_VHP();
		document.getElementById('ome-bEditionAJA').disabled = !profil.isEditionDES_AJA();
		document.getElementById('ome-bEditionAAC').disabled = !profil.isEditionDES_AAC();
		document.getElementById('ome-bEditionAAA').disabled = !profil.isEditionDES_AAA();
		document.getElementById('ome-bEditionAEF').disabled = !profil.isEditionDES_AEF();
		document.getElementById('ome-bEditionARF').disabled = !profil.isEditionDES_ARF();
		document.getElementById('ome-bEditionASF').disabled = !profil.isEditionDES_ASF();
		document.getElementById('ome-bEditionASD').disabled = !profil.isEditionDES_ASD();

		var qExistEPE = new QueryHttp("Facturation/Editions/existEtapePrepaExpedition.tmpl");
		var result = qExistEPE.execute();
		var prepaExpe = (result.responseXML.documentElement.getAttribute("Exist")=="true");

		var qExistECE = new QueryHttp("Facturation/Editions/existEtapeConfirmExpedition.tmpl");
		result = qExistECE.execute();
		var confirmExpe = (result.responseXML.documentElement.getAttribute("Exist")=="true");

		ome_web = config.isECommerce();

		var aPoles = new Arbre("ComboListe/combo-polesActivite.tmpl", "ome-poleActivite");
		aPoles.initTree();

		var aTypeSuivi = new Arbre("ComboListe/combo-typesSuiviCC.tmpl", "ome-typeSuivi");
		aTypeSuivi.initTree();

		var aProvenance = new Arbre("ComboListe/combo-sitesWeb.tmpl", "ome-provenance");
		aProvenance.initTree();

		var aMarketplaces = new Arbre("ComboListe/combo-marketplaces.tmpl", "ome-marketplace");
		aMarketplaces.initTree();

		if (!prepaExpe) {
			document.getElementById('ome-miPreparation').collapsed = true;
		}
		if (!confirmExpe) {
			document.getElementById('ome-miPretExpedier').collapsed = true;
		}

		ome_switchCategorie('C');

	} catch (e) {
  	recup_erreur(e);
  }
}


function ome_chargerFamilles2() {
	try {

		var famille1 = document.getElementById('ome-famille1').value;

		if (isEmpty(famille1)) {
			ome_aFamille2.deleteTree();
			ome_initFamille2();
		}
		else {
			ome_aFamille2.setParam('Parent_Id', famille1);
			ome_aFamille2.initTree(ome_initFamille2);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function ome_initFamille2() {
  try {

		document.getElementById('ome-famille2').selectedIndex = 0;
		ome_chargerFamilles3();

	} catch (e) {
		recup_erreur(e);
	}
}


function ome_chargerFamilles3() {
	try {

		var famille2 = document.getElementById('ome-famille2').value;

		if (isEmpty(famille2)) {
			ome_aFamille3.deleteTree();
			ome_initFamille3();
		}
		else {
			ome_aFamille3.setParam('Parent_Id', famille2);
			ome_aFamille3.initTree(ome_initFamille3);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function ome_initFamille3() {
  try {

		document.getElementById('ome-famille3').selectedIndex = 0;

	} catch (e) {
		recup_erreur(e);
	}
}


function ome_initRespClient() {
	try {

		if (!ome_direction) {
			document.getElementById('ome-responsableClient').value = getProfil().getLoggedUser();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function ome_initRespFournisseur() {
	try {

		if (!ome_direction) {
			document.getElementById('ome-responsableFournisseur').value = getProfil().getLoggedUser();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function ome_switchCategorie(codeCategorie) {
  try {

		switch (codeCategorie) {
			case 'C':	document.getElementById('ome-deckCategorie').selectedIndex = 0;
								ome_selectEdition('ome-boxEC');
								break;
			case 'F':	document.getElementById('ome-deckCategorie').selectedIndex = 1;
								ome_selectEdition('ome-boxEF');
								break;
			case 'S':	document.getElementById('ome-deckCategorie').selectedIndex = 2;
								ome_selectEdition('ome-boxES');
								break;
			case 'V':	document.getElementById('ome-deckCategorie').selectedIndex = 3;
								ome_selectEdition('ome-boxEV');
								break;
			case 'A':	document.getElementById('ome-deckCategorie').selectedIndex = 4;
								ome_selectEdition('ome-boxEA');
								break;
		}

	} catch (e) {
  	recup_erreur(e);
  }
}


function ome_selectEdition(boxId) {
	try {

		document.getElementById("ome-boxOptions").collapsed = true;

		var elems = document.getElementById(boxId).getElementsByTagName("button");
		for (var i=0; i<elems.length; i++) {
			var edition = elems[i];
			if (edition.disabled==false && edition.collapsed==false) {
				edition.checked = true;
				edition.doCommand();
				break;
			}
		}

	} catch (e) {
  	recup_erreur(e);
  }
}


function ome_switchOptions(codeEdition) {
  try {

		ome_currentCodeEdition = codeEdition;

		document.getElementById('ome-bEditionPDF').collapsed = true;
		document.getElementById('ome-bEditionCSV').collapsed = true;

		document.getElementById('ome-gPeriode').collapsed = true;
		document.getElementById('ome-gSelectionClients').collapsed = true;
		document.getElementById('ome-gTriClients').collapsed = true;
		document.getElementById('ome-gSelectionFournisseurs').collapsed = true;
		document.getElementById('ome-gTriFournisseurs').collapsed = true;
		document.getElementById('ome-gDetailCA').collapsed = true;
		document.getElementById('ome-gValorisation').collapsed = true;
		document.getElementById('ome-gDateArrete').collapsed = true;
		document.getElementById('ome-gDepot').collapsed = true;
		document.getElementById('ome-gFourPrinc').collapsed = true;
		document.getElementById('ome-gSelectionArticles').collapsed = true;
		document.getElementById('ome-gSelection').collapsed = true;
		document.getElementById('ome-gDetails').collapsed = true;
		document.getElementById('ome-gStatistiques').collapsed = true;
		document.getElementById('ome-gTypeSuivis').collapsed = true;
		document.getElementById('ome-gTypeListeExpeditions').collapsed = true;
		document.getElementById('ome-gTypeEdition').collapsed = true;
		document.getElementById('ome-gSelectionMvts').collapsed = true;

		document.getElementById('ome-nonMvt').collapsed = true;
		document.getElementById('ome-includeFP').collapsed = true;
		document.getElementById('ome-rowArtActif').collapsed = true;
		document.getElementById('ome-rowReference').collapsed = true;
		document.getElementById('ome-rowTypeArticle').collapsed = true;
		document.getElementById('ome-rowStockEntier').collapsed = true;
		document.getElementById('ome-rowArtNonVendus').collapsed = true;
		document.getElementById('ome-rowExclureQuarantaine').collapsed = true;
		document.getElementById('ome-rowProvenance').collapsed = true;
		document.getElementById('ome-rowMarketplace').collapsed = true;
		document.getElementById('ome-rowResponsableClient').collapsed = false;
		document.getElementById('ome-rowFamilleClient').collapsed = false;
		document.getElementById('ome-rowNumClient').collapsed = true;
		document.getElementById('ome-rowTarifsSpe').collapsed = false;
		document.getElementById('ome-comparatif').collapsed = true;
		document.getElementById('ome-nonVenduN').collapsed = true;
		document.getElementById('ome-periodePP').collapsed = true;
		document.getElementById('ome-periodeDD').collapsed = false;

		switch (codeEdition) {
			case 'CPC':	document.getElementById('ome-gPeriode').collapsed = false;
									document.getElementById('ome-gSelectionClients').collapsed = false;
									document.getElementById('ome-gDetailCA').collapsed = false;
									document.getElementById('ome-bEditionPDF').collapsed = false;
									document.getElementById('ome-bEditionCSV').collapsed = false;
									document.getElementById('ome-gTypeEdition').collapsed = false;
									break;
			case 'CLC':	document.getElementById('ome-gSelectionClients').collapsed = false;
									document.getElementById('ome-gTriClients').collapsed = false;
									document.getElementById('ome-bEditionPDF').collapsed = false;
									break;
			case 'FPF':	document.getElementById('ome-gPeriode').collapsed = false;
									document.getElementById('ome-gSelectionFournisseurs').collapsed = false;
									document.getElementById('ome-gDetailCA').collapsed = false;
									document.getElementById('ome-bEditionPDF').collapsed = false;
									document.getElementById('ome-bEditionCSV').collapsed = false;
									document.getElementById('ome-gTypeEdition').collapsed = false;
									break;
			case 'FLF':	document.getElementById('ome-gSelectionFournisseurs').collapsed = false;
									document.getElementById('ome-gTriFournisseurs').collapsed = false;
									document.getElementById('ome-bEditionPDF').collapsed = false;
									break;
			case 'SPA':	document.getElementById('ome-gPeriode').collapsed = false;
									document.getElementById('ome-gSelectionArticles').collapsed = false;
									document.getElementById('ome-bEditionPDF').collapsed = false;
									document.getElementById('ome-bEditionCSV').collapsed = false;
									document.getElementById('ome-gTypeEdition').collapsed = false;
									document.getElementById('ome-comparatif').collapsed = false;
									document.getElementById('ome-nonVenduN').collapsed = false;
									break;
			case 'SFA':	document.getElementById('ome-gSelectionArticles').collapsed = false;
									document.getElementById('ome-bEditionPDF').collapsed = false;
									break;
			case 'SMS':	document.getElementById('ome-periodePP').collapsed = false;
									document.getElementById('ome-periodeDD').collapsed = true;
									document.getElementById('ome-gPeriode').collapsed = false;
									document.getElementById('ome-gDepot').collapsed = false;
									document.getElementById('ome-choixDepot').setAttribute("label", "[Choisir]");
									document.getElementById('ome-gSelectionArticles').collapsed = false;
									document.getElementById('ome-nonMvt').collapsed = false;
									document.getElementById('ome-bEditionPDF').collapsed = false;
									break;
			case 'SES':	document.getElementById('ome-gValorisation').collapsed = false;
									document.getElementById('ome-gDateArrete').collapsed = document.getElementById('ome-valorisation').value=='D';
									document.getElementById('ome-gDepot').collapsed = false;
									document.getElementById('ome-choixDepot').setAttribute("label", "[Tous]");
									document.getElementById('ome-gSelectionArticles').collapsed = false;
									document.getElementById('ome-rowTypeArticle').collapsed = false;
									document.getElementById('ome-rowStockEntier').collapsed = false;
									document.getElementById('ome-bEditionPDF').collapsed = false;
									document.getElementById('ome-bEditionCSV').collapsed = false;
									break;
			case 'SRS':	document.getElementById('ome-gPeriode').collapsed = false;
									document.getElementById('ome-gFourPrinc').collapsed = false;
									document.getElementById('ome-gSelectionArticles').collapsed = false;
									document.getElementById('ome-gValorisation').collapsed = false;
									document.getElementById('ome-bEditionCSV').collapsed = false;
									break;
			case 'SPF':	document.getElementById('ome-gSelectionArticles').collapsed = false;
									document.getElementById('ome-gDepot').collapsed = false;
									document.getElementById('ome-choixDepot').setAttribute("label", "[Tous]");
									document.getElementById('ome-bEditionCSV').collapsed = false;
									break;
			case 'SMA':	document.getElementById('ome-gPeriode').collapsed = false;
									document.getElementById('ome-gSelectionArticles').collapsed = false;
									document.getElementById('ome-gSelectionMvts').collapsed = false;
									document.getElementById('ome-gDepot').collapsed = false;
									document.getElementById('ome-choixDepot').setAttribute("label", "[Tous]");
									document.getElementById('ome-bEditionCSV').collapsed = false;
									break;
			case 'VJV':	document.getElementById('ome-gPeriode').collapsed = false;
									document.getElementById('ome-gSelection').collapsed = false;
									document.getElementById('ome-rowProvenance').collapsed = !ome_web;
									document.getElementById('ome-gDetails').collapsed = false;
									document.getElementById('ome-bEditionPDF').collapsed = false;
									document.getElementById('ome-bEditionCSV').collapsed = false;
									break;
			case 'VJA':	document.getElementById('ome-gPeriode').collapsed = false;
									document.getElementById('ome-gSelection').collapsed = false;
									document.getElementById('ome-gDetails').collapsed = false;
									document.getElementById('ome-bEditionPDF').collapsed = false;
									document.getElementById('ome-bEditionCSV').collapsed = false;
									break;
			case 'VVA':	document.getElementById('ome-gPeriode').collapsed = false;
									document.getElementById('ome-gSelectionArticles').collapsed = false;
									document.getElementById('ome-gSelection').collapsed = false;
									document.getElementById('ome-rowProvenance').collapsed = !ome_web;
									document.getElementById('ome-gTypeEdition').collapsed = false;
									document.getElementById('ome-rowMarketplace').collapsed = !ome_web;
									document.getElementById('ome-bEditionCSV').collapsed = false;
									break;
			case 'VAR':	document.getElementById('ome-gPeriode').collapsed = false;
									document.getElementById('ome-gSelectionArticles').collapsed = false;
									document.getElementById('ome-gSelection').collapsed = false;
									document.getElementById('ome-rowProvenance').collapsed = !ome_web;
									document.getElementById('ome-bEditionCSV').collapsed = false;
									document.getElementById('ome-rowArtNonVendus').collapsed = false;
									document.getElementById('ome-rowExclureQuarantaine').collapsed = false;
									break;
			case 'VFA':	document.getElementById('ome-gPeriode').collapsed = false;
									document.getElementById('ome-gSelectionArticles').collapsed = false;
									document.getElementById('ome-gSelectionClients').collapsed = false;
									document.getElementById('ome-rowTarifsSpe').collapsed = true;
									document.getElementById('ome-rowNumClient').collapsed = false;
									document.getElementById('ome-gSelection').collapsed = false;
									document.getElementById('ome-rowProvenance').collapsed = !ome_web;
									document.getElementById('ome-rowMarketplace').collapsed = !ome_web;
									document.getElementById('ome-bEditionCSV').collapsed = false;
									break;
			case 'VFC':	document.getElementById('ome-gPeriode').collapsed = false;
									document.getElementById('ome-gSelection').collapsed = false;
									document.getElementById('ome-gSelectionClients').collapsed = false;
									document.getElementById('ome-rowResponsableClient').collapsed = true;
									document.getElementById('ome-rowTarifsSpe').collapsed = true;
									document.getElementById('ome-rowProvenance').collapsed = !ome_web;
									document.getElementById('ome-bEditionCSV').collapsed = false;
									break;
			case 'VFD':	document.getElementById('ome-gPeriode').collapsed = false;
									document.getElementById('ome-gSelection').collapsed = false;
									document.getElementById('ome-gSelectionClients').collapsed = false;
									document.getElementById('ome-rowResponsableClient').collapsed = true;
									document.getElementById('ome-rowTarifsSpe').collapsed = true;
									document.getElementById('ome-rowProvenance').collapsed = !ome_web;
									document.getElementById('ome-bEditionCSV').collapsed = false;
									break;
			case 'VSC':	document.getElementById('ome-gPeriode').collapsed = false;
									document.getElementById('ome-gTypeSuivis').collapsed = false;
									document.getElementById('ome-gSelectionClients').collapsed = false;
									document.getElementById('ome-rowNumClient').collapsed = false;
									document.getElementById('ome-rowResponsableClient').collapsed = true;
									document.getElementById('ome-rowTarifsSpe').collapsed = true;
									document.getElementById('ome-rowFamilleClient').collapsed = true;
									document.getElementById('ome-bEditionCSV').collapsed = false;
									break;
			case 'VLE':	document.getElementById('ome-gPeriode').collapsed = false;
									document.getElementById('ome-gTypeListeExpeditions').collapsed = false;
									document.getElementById('ome-bEditionCSV').collapsed = false;
									break;
			case 'VLC':	document.getElementById('ome-gPeriode').collapsed = false;
									document.getElementById('ome-bEditionCSV').collapsed = false;
									break;
			case 'VEC':	document.getElementById('ome-gPeriode').collapsed = false;
									document.getElementById('ome-bEditionCSV').collapsed = false;
									break;
			case 'VCT':	document.getElementById('ome-gPeriode').collapsed = false;
									document.getElementById('ome-bEditionCSV').collapsed = false;
									break;
			case 'VRC':	document.getElementById('ome-gPeriode').collapsed = false;
									document.getElementById('ome-bEditionCSV').collapsed = false;
									break;
			case 'VCS':	document.getElementById('ome-gPeriode').collapsed = false;
									document.getElementById('ome-gStatistiques').collapsed = false;
									document.getElementById('ome-bEditionCSV').collapsed = false;
									break;
			case 'VFV':	document.getElementById('ome-gSelectionArticles').collapsed = false;
									document.getElementById('ome-gDepot').collapsed = false;
									document.getElementById('ome-choixDepot').setAttribute("label", "[Choisir]");
									document.getElementById('ome-bEditionCSV').collapsed = false;
									break;
			case 'VRE':	document.getElementById('ome-gPeriode').collapsed = false;
									document.getElementById('ome-bEditionCSV').collapsed = false;
									break;
			case 'VCR':	document.getElementById('ome-gPeriode').collapsed = false;
									document.getElementById('ome-bEditionCSV').collapsed = false;
									break;
			case 'VHP':	document.getElementById('ome-gPeriode').collapsed = false;
									document.getElementById('ome-gSelectionArticles').collapsed = false;
									document.getElementById('ome-rowArtActif').collapsed = false;
									document.getElementById('ome-rowReference').collapsed = false;
									document.getElementById('ome-bEditionCSV').collapsed = false;
									break;
			case 'AJA':	document.getElementById('ome-gPeriode').collapsed = false;
									document.getElementById('ome-gSelection').collapsed = false;
									document.getElementById('ome-gDetails').collapsed = false;
									document.getElementById('ome-bEditionPDF').collapsed = false;
									document.getElementById('ome-bEditionCSV').collapsed = false;
									break;
			case 'AAC':	document.getElementById('ome-gPeriode').collapsed = false;
									document.getElementById('ome-gSelection').collapsed = false;
									document.getElementById('ome-gDetails').collapsed = false;
									document.getElementById('ome-bEditionPDF').collapsed = false;
									document.getElementById('ome-bEditionCSV').collapsed = false;
									break;
			case 'AAA':	document.getElementById('ome-gPeriode').collapsed = false;
									document.getElementById('ome-gSelectionArticles').collapsed = false;
									document.getElementById('ome-gSelection').collapsed = false;
									document.getElementById('ome-bEditionCSV').collapsed = false;
									break;
			case 'AEF':	document.getElementById('ome-gPeriode').collapsed = false;
									document.getElementById('ome-includeFP').collapsed = false;
									document.getElementById('ome-bEditionCSV').collapsed = false;
									break;
			case 'ARF':	document.getElementById('ome-gPeriode').collapsed = false;
									document.getElementById('ome-gSelection').collapsed = false;
									document.getElementById('ome-gSelectionFournisseurs').collapsed = false;
									document.getElementById('ome-bEditionCSV').collapsed = false;
									break;
			case 'ASF':	document.getElementById('ome-gPeriode').collapsed = false;
									document.getElementById('ome-gDateArrete').collapsed = false;
									document.getElementById('ome-bEditionCSV').collapsed = false;
									break;
			case 'ASD':	document.getElementById('ome-gPeriode').collapsed = false;
									document.getElementById('ome-gDateArrete').collapsed = false;
									document.getElementById('ome-bEditionCSV').collapsed = false;
									break;
		}

		document.getElementById("ome-boxOptions").collapsed = false;

	} catch (e) {
    recup_erreur(e);
  }
}


function ome_enableDates(b) {
	try {

		document.getElementById("ome-dateDebut").disabled = !b;
		document.getElementById("ome-dateFin").disabled = !b;
		document.getElementById("ome-periodeDebut").disabled = !b;
		document.getElementById("ome-periodeFin").disabled = !b;

	} catch (e) {
    recup_erreur(e);
  }
}


function ome_switchValorisation() {
	try {

		if (ome_currentCodeEdition=="SES") {
			var valorisation = document.getElementById('ome-valorisation').value;
			document.getElementById('ome-gDateArrete').collapsed = (valorisation=="D");
			if (valorisation=="D") {
				document.getElementById('ome-dateArrete').value = "";
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function ome_clickOnComparatif() {
	try {

		document.getElementById('ome-nonVenduN').disabled = !document.getElementById('ome-comparatif').checked;
		if (!document.getElementById('ome-comparatif').checked) {
			document.getElementById('ome-nonVenduN').checked = false;
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function ome_rechercherClient() {
	try {

		var url = "chrome://opensi/content/facturation/user/clients/popup-rechercheClient.xul";
    window.openDialog(url,'','chrome,modal,centerscreen', ome_retourRechercherClient);

  } catch (e) {
    recup_erreur(e);
  }
}


function ome_retourRechercherClient(numClient) {
	try {

		document.getElementById('ome-numClient').value = numClient;

	} catch (e) {
		recup_erreur(e);
	}
}


function ome_rechercherFournisseur() {
	try {

		var url = "chrome://opensi/content/facturation/user/fournisseurs/popup-rechercheFournisseur.xul";
    window.openDialog(url,'','chrome,modal,centerscreen', ome_retourRechercherFournisseur);

  } catch (e) {
    recup_erreur(e);
  }
}


function ome_retourRechercherFournisseur(numFournisseur) {
	try {

		document.getElementById('ome-fourPrinc').value = numFournisseur;

	} catch (e) {
		recup_erreur(e);
	}
}


function ome_rechercherArticle() {
	try {

		var url = "chrome://opensi/content/facturation/user/articles/popup-rechercheArticle.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', ome_retourRechercherArticle);

	} catch (e) {
		recup_erreur(e);
	}
}


function ome_retourRechercherArticle(reference, articleId) {
	try {

  	document.getElementById('ome-refArticle').value = reference;

	} catch (e) {
		recup_erreur(e);
	}
}


function ome_editionPDF() {
	try {

		var periode = document.getElementById('ome-periode').value;
		var dateDebut = document.getElementById('ome-dateDebut').value;
		var dateFin = document.getElementById('ome-dateFin').value;
		var periodeDebut = document.getElementById('ome-periodeDebut').value;
		var periodeFin = document.getElementById('ome-periodeFin').value;
		var marque = document.getElementById('ome-marque').value;
		var famille1 = document.getElementById('ome-famille1').value;
		var famille2 = document.getElementById('ome-famille2').value;
		var famille3 = document.getElementById('ome-famille3').value;
		var typeArticle = document.getElementById('ome-typeArticle').value;
		var provenance = document.getElementById('ome-provenance').value;
		var marketplace = document.getElementById('ome-marketplace').value;
		var detailCompte = document.getElementById('ome-detailCompte').checked;
		var detailModeReg = document.getElementById('ome-detailModeReg').checked;
		var poleActivite = document.getElementById('ome-poleActivite').value;
		var fourPrinc = document.getElementById('ome-fourPrinc').value;
		var statutExpedition = document.getElementById('ome-statutExpedition').value;
		var numCommande = document.getElementById('ome-numCommande').value;
		var typeSuivi = document.getElementById('ome-typeSuivi').value;
		var numClient = document.getElementById('ome-numClient').value;
		var numExpedition = document.getElementById('ome-numExpedition').value;
		var familleFournisseur = document.getElementById('ome-familleFournisseur').value;
		var familleClient = document.getElementById('ome-familleClient').value;
		var detailCA = document.getElementById('ome-detailCA').value;
		var typeEdition = document.getElementById('ome-typeEdition').value;
		var responsableClient = document.getElementById('ome-responsableClient').value;
		var responsableFournisseur = document.getElementById('ome-responsableFournisseur').value;
		var tarifsSpe = document.getElementById('ome-tarifsSpe').checked;
		var valorisation = document.getElementById('ome-valorisation').value;
		var stockEntier = document.getElementById('ome-stockEntier').checked;
		var depotId = document.getElementById('ome-depotStock').value;
		var dateArrete = document.getElementById('ome-dateArrete').value;
		var nonMvt = document.getElementById('ome-nonMvt').checked;
		var comparatif = document.getElementById('ome-comparatif').checked;
		var nonVenduN = document.getElementById('ome-nonVenduN').checked;
		var triClient1 = document.getElementById('ome-triClient1').value;
		var triClient2 = document.getElementById('ome-triClient2').value;
		var triClient3 = document.getElementById('ome-triClient3').value;
		var triFournisseur1 = document.getElementById('ome-triFournisseur1').value;
		var triFournisseur2 = document.getElementById('ome-triFournisseur2').value;
		var triFournisseur3 = document.getElementById('ome-triFournisseur3').value;

		var needPeriode = !document.getElementById('ome-gPeriode').collapsed;

		if (needPeriode && periode=="DD" && !isDate(dateDebut)) { showWarning("Date de d\u00E9but de p\u00E9riode incorrecte"); }
		else if (needPeriode && periode=="DD" && !isDate(dateFin)) { showWarning("Date de fin de p\u00E9riode incorrecte"); }
		else if (needPeriode && periode=="DD" && !isDateInterval(dateDebut, dateFin)) { showWarning("Plage de dates incorrecte"); }
		else if (needPeriode && periode=="PP" && !isPeriode(periodeDebut)) { showWarning("P\u00E9riode de d\u00E9but incorrecte"); }
		else if (needPeriode && periode=="PP" && !isPeriode(periodeFin)) { showWarning("P\u00E9riode de fin incorrecte"); }
		else if (needPeriode && periode=="PP" && !isPeriodeInterval(periodeDebut, periodeFin)) { showWarning("Plage de p\u00E9riodes incorrecte"); }
		else if (!isEmpty(dateArrete) && !isDate(dateArrete)) { showWarning("Date d'arret\u00E9 incorrecte"); }
		else if (ome_currentCodeEdition=="SMS" && isEmpty(depotId)) { showWarning("Veuillez indiquer un d\u00E9pot de stock"); }
		else {

			var qEditionPdf = new QueryHttp("Facturation/Editions/pdfEdition.tmpl");

			qEditionPdf.setParam("CodeEdition", ome_currentCodeEdition);
			qEditionPdf.setParam("Periode", periode);
			qEditionPdf.setParam("DateDebut", dateDebut);
			qEditionPdf.setParam("DateFin", dateFin);
			qEditionPdf.setParam("PeriodeDebut", periodeDebut);
			qEditionPdf.setParam("PeriodeFin", periodeFin);
			qEditionPdf.setParam("Marque", marque);
			qEditionPdf.setParam("Famille1", famille1);
			qEditionPdf.setParam("Famille2", famille2);
			qEditionPdf.setParam("Famille3", famille3);
			qEditionPdf.setParam("Type_Article", typeArticle);
			qEditionPdf.setParam("Provenance", provenance);
			qEditionPdf.setParam("Marketplace", marketplace);
			qEditionPdf.setParam("DetailCompte", detailCompte);
			qEditionPdf.setParam("DetailModeReg", detailModeReg);
			qEditionPdf.setParam("PoleActivite", poleActivite);
			qEditionPdf.setParam("FourPrinc", fourPrinc);
			qEditionPdf.setParam("StatutExpedition", statutExpedition);
			qEditionPdf.setParam("NumCommande", numCommande);
			qEditionPdf.setParam("TypeSuivi", typeSuivi);
			qEditionPdf.setParam("NumClient", numClient);
			qEditionPdf.setParam("NumExpedition", numExpedition);
			qEditionPdf.setParam("FamilleFournisseur", familleFournisseur);
			qEditionPdf.setParam("FamilleClient", familleClient);
			qEditionPdf.setParam("DetailCA", detailCA);
			qEditionPdf.setParam("TypeEdition", typeEdition);
			qEditionPdf.setParam("ResponsableClient", responsableClient);
			qEditionPdf.setParam("ResponsableFournisseur", responsableFournisseur);
			qEditionPdf.setParam("TarifsSpe", tarifsSpe);
			qEditionPdf.setParam("Valorisation", valorisation);
			qEditionPdf.setParam("StockEntier", stockEntier);
			qEditionPdf.setParam("DepotId", depotId);
			qEditionPdf.setParam("DateArrete", dateArrete);
			qEditionPdf.setParam("NonMvt", nonMvt);
			qEditionPdf.setParam("Comparatif", comparatif);
			qEditionPdf.setParam("NonVenduN", nonVenduN);
			qEditionPdf.setParam("TriClient1", triClient1);
			qEditionPdf.setParam("TriClient2", triClient2);
			qEditionPdf.setParam("TriClient3", triClient3);
			qEditionPdf.setParam("TriFournisseur1", triFournisseur1);
			qEditionPdf.setParam("TriFournisseur2", triFournisseur2);
			qEditionPdf.setParam("TriFournisseur3", triFournisseur3);

			document.getElementById('ome-pmbox').collapsed = false;
			document.getElementById('ome-pm').setAttribute('mode', 'undetermined');

			qEditionPdf.execute(ome_editionPDF_2);
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function ome_editionPDF_2(result) {
	try {

		document.getElementById('ome-pmbox').collapsed = true;
		document.getElementById('ome-pm').setAttribute('mode', 'none');

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}
		else {
			var page = getDirPdf() + result.responseXML.documentElement.getAttribute('FichierPDF');
			document.getElementById('pdf').setAttribute("src", page);

			document.getElementById('deck').selectedIndex = 1;
			document.getElementById('bMenuEditions').collapsed = false;
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function ome_editionCSV() {
	try {

		var qEditionCsv = new QueryHttp("Facturation/Editions/csvEdition.tmpl");

		var periode = document.getElementById('ome-periode').value;
		var dateDebut = document.getElementById('ome-dateDebut').value;
		var dateFin = document.getElementById('ome-dateFin').value;
		var periodeDebut = document.getElementById('ome-periodeDebut').value;
		var periodeFin = document.getElementById('ome-periodeFin').value;
		var marque = document.getElementById('ome-marque').value;
		var famille1 = document.getElementById('ome-famille1').value;
		var famille2 = document.getElementById('ome-famille2').value;
		var famille3 = document.getElementById('ome-famille3').value;
		var typeArticle = document.getElementById('ome-typeArticle').value;
		var provenance = document.getElementById('ome-provenance').value;
		var marketplace = document.getElementById('ome-marketplace').value;
		var detailCompte = document.getElementById('ome-detailCompte').checked;
		var detailModeReg = document.getElementById('ome-detailModeReg').checked;
		var poleActivite = document.getElementById('ome-poleActivite').value;
		var fourPrinc = document.getElementById('ome-fourPrinc').value;
		var statutExpedition = document.getElementById('ome-statutExpedition').value;
		var numCommande = document.getElementById('ome-numCommande').value;
		var typeSuivi = document.getElementById('ome-typeSuivi').value;
		var numClient = document.getElementById('ome-numClient').value;
		var numExpedition = document.getElementById('ome-numExpedition').value;
		var familleFournisseur = document.getElementById('ome-familleFournisseur').value;
		var familleClient = document.getElementById('ome-familleClient').value;
		var detailCA = document.getElementById('ome-detailCA').value;
		var typeEdition = document.getElementById('ome-typeEdition').value;
		var responsableClient = document.getElementById('ome-responsableClient').value;
		var responsableFournisseur = document.getElementById('ome-responsableFournisseur').value;
		var tarifsSpe = document.getElementById('ome-tarifsSpe').checked;
		var valorisation = document.getElementById('ome-valorisation').value;
		var stockEntier = document.getElementById('ome-stockEntier').checked;
		var artNonVendus = document.getElementById('ome-artNonVendus').checked;
		var exclureQuarantaine = document.getElementById('ome-exclureQuarantaine').checked;
		var depotId = document.getElementById('ome-depotStock').value;
		var dateArrete = document.getElementById('ome-dateArrete').value;
		var detailArticle = document.getElementById('ome-detailArticle').checked;
		var comparatif = document.getElementById('ome-comparatif').checked;
		var nonVenduN = document.getElementById('ome-nonVenduN').checked;
		var includeFP = document.getElementById('ome-includeFP').checked;
		var reference = document.getElementById('ome-refArticle').value;
		var artActif = document.getElementById('ome-artActif').checked;
		var typeMvt = document.getElementById('ome-typeMvt').value;
		var sensMvt = document.getElementById('ome-sensMvt').value;

		var needPeriode = !document.getElementById('ome-gPeriode').collapsed;

		if (needPeriode && periode=="DD" && !isDate(dateDebut)) { showWarning("Date de d\u00E9but de p\u00E9riode incorrecte"); }
		else if (needPeriode && periode=="DD" && !isDate(dateFin)) { showWarning("Date de fin de p\u00E9riode incorrecte"); }
		else if (needPeriode && periode=="DD" && !isDateInterval(dateDebut, dateFin)) { showWarning("Plage de dates incorrecte"); }
		else if (needPeriode && periode=="PP" && !isPeriode(periodeDebut)) { showWarning("P\u00E9riode de d\u00E9but incorrecte"); }
		else if (needPeriode && periode=="PP" && !isPeriode(periodeFin)) { showWarning("P\u00E9riode de fin incorrecte"); }
		else if (needPeriode && periode=="PP" && !isPeriodeInterval(periodeDebut, periodeFin)) { showWarning("Plage de p\u00E9riodes incorrecte"); }
		else if (!isEmpty(dateArrete) && !isDate(dateArrete)) { showWarning("Date d'arret\u00E9 incorrecte"); }
		else if ((ome_currentCodeEdition=="SMS" || ome_currentCodeEdition=="VFV") && isEmpty(depotId)) { showWarning("Veuillez indiquer un d\u00E9pot de stock"); }
		else {

			qEditionCsv.setParam("CodeEdition", ome_currentCodeEdition);
			qEditionCsv.setParam("Periode", periode);
			qEditionCsv.setParam("DateDebut", dateDebut);
			qEditionCsv.setParam("DateFin", dateFin);
			qEditionCsv.setParam("PeriodeDebut", periodeDebut);
			qEditionCsv.setParam("PeriodeFin", periodeFin);
			qEditionCsv.setParam("Marque", marque);
			qEditionCsv.setParam("Famille1", famille1);
			qEditionCsv.setParam("Famille2", famille2);
			qEditionCsv.setParam("Famille3", famille3);
			qEditionCsv.setParam("Type_Article", typeArticle);
			qEditionCsv.setParam("Provenance", provenance);
			qEditionCsv.setParam("Marketplace", marketplace);
			qEditionCsv.setParam("DetailCompte", detailCompte);
			qEditionCsv.setParam("DetailModeReg", detailModeReg);
			qEditionCsv.setParam("PoleActivite", poleActivite);
			qEditionCsv.setParam("FourPrinc", fourPrinc);
			qEditionCsv.setParam("StatutExpedition", statutExpedition);
			qEditionCsv.setParam("NumCommande", numCommande);
			qEditionCsv.setParam("TypeSuivi", typeSuivi);
			qEditionCsv.setParam("NumClient", numClient);
			qEditionCsv.setParam("NumExpedition", numExpedition);
			qEditionCsv.setParam("FamilleFournisseur", familleFournisseur);
			qEditionCsv.setParam("FamilleClient", familleClient);
			qEditionCsv.setParam("DetailCA", detailCA);
			qEditionCsv.setParam("TypeEdition", typeEdition);
			qEditionCsv.setParam("ResponsableClient", responsableClient);
			qEditionCsv.setParam("ResponsableFournisseur", responsableFournisseur);
			qEditionCsv.setParam("TarifsSpe", tarifsSpe);
			qEditionCsv.setParam("Valorisation", valorisation);
			qEditionCsv.setParam("StockEntier", stockEntier);
			qEditionCsv.setParam("ArtNonVendus", artNonVendus);
			qEditionCsv.setParam("ExclureQuarantaine", exclureQuarantaine);
			qEditionCsv.setParam("DepotId", depotId);
			qEditionCsv.setParam("DateArrete", dateArrete);
			qEditionCsv.setParam("DetailArticle", detailArticle);
			qEditionCsv.setParam("Comparatif", comparatif);
			qEditionCsv.setParam("NonVenduN", nonVenduN);
			qEditionCsv.setParam("IncludeFP", includeFP);
			qEditionCsv.setParam("Reference", reference);
			qEditionCsv.setParam("ArtActif", artActif);
			qEditionCsv.setParam("TypeMvt", typeMvt);
			qEditionCsv.setParam("SensMvt", sensMvt);

			document.getElementById('ome-pmbox').collapsed = false;
			document.getElementById('ome-pm').setAttribute('mode', 'undetermined');

			qEditionCsv.execute(ome_editionCSV_2);
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function ome_editionCSV_2(result) {
	try {

		document.getElementById('ome-pmbox').collapsed = true;
		document.getElementById('ome-pm').setAttribute('mode', 'none');

		var fichier = result.responseXML.documentElement.getAttribute('FichierCSV');

		var file = fileChooser("save", fichier);
		if (file!=null) {
			downloadFile(getDirBuffer()+ fichier, file);
		}

	} catch (e) {
    recup_erreur(e);
  }
}
