/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/


var ooe_aFiltresZones = new Arbre("ComboListe/combo-zonesStockage.tmpl", "ooe-filtreZoneStockage");
var ooe_aDepots = new Arbre('ComboListe/combo-depotsStock.tmpl', 'ooe-depotId');
var ooe_aZones = new Arbre("ComboListe/combo-zonesStockage.tmpl", "ooe-zoneId");
var ooe_aSupports = new Arbre("ComboListe/combo-supportsStockage.tmpl", "ooe-supportId");
var ooe_aApercuEmplacement = new Arbre("Facturation/Emplacements/list-apercuEmplacementStock.tmpl", "ooe-apercuEmplacement");
var ooe_aEmplacements = new Arbre("Facturation/Emplacements/list-emplacementStock.tmpl", "ooe-listeEmplacements");
var ooe_qListES = new QueryHttp("Facturation/Emplacements/getDataListES.tmpl");

var ooe_pageCourante;
var ooe_nbPages;

var ooe_currentEmplacementId = "";
var ooe_selDepotId = "";
var ooe_selZoneId = "";
var ooe_selSupportId = "";



function ooe_initOngletEmplacements() {
	try {

		var aFiltreDepots = new Arbre('ComboListe/combo-depotsStock.tmpl', 'ooe-filtreDepotStock');
		aFiltreDepots.setParam('Selection', depotDefaut);
		aFiltreDepots.initTree(ooe_initFiltreDepotStock);

		var aFiltreSupports = new Arbre("ComboListe/combo-supportsStockage.tmpl", "ooe-filtreSupportStockage");
		aFiltreSupports.initTree();

		ooe_nouveauEmplacement();

	} catch (e) {
		recup_erreur(e);
  }
}


function ooe_initFiltreDepotStock() {
	try {

		document.getElementById('ooe-filtreDepotStock').value = depotDefaut;
		ooe_chargerFiltreZones();

	} catch (e) {
		recup_erreur(e);
  }
}


function ooe_chargerFiltreZones() {
	try {

		ooe_aFiltresZones.setParam("Depot_Id", document.getElementById('ooe-filtreDepotStock').value);
		ooe_aFiltresZones.initTree(ooe_initFiltreZoneStockage);

	} catch (e) {
		recup_erreur(e);
  }
}


function ooe_initFiltreZoneStockage() {
	try {

		document.getElementById('ooe-filtreZoneStockage').value = "";

	} catch (e) {
		recup_erreur(e);
  }
}


function ooe_initCriteres() {
	try {

		document.getElementById('ooe-filtreCodeEmplacement').value = "";
		document.getElementById('ooe-filtreDepotStock').value = depotDefaut;
		document.getElementById('ooe-filtreZoneStockage').value = "";
		document.getElementById('ooe-filtreSupportStockage').value = "";
		document.getElementById('ooe-filtreRefArticle').value = "";
		document.getElementById('ooe-filtreActif').checked = true;

		ooe_chargerFiltreZones();

		ooe_listerEmplacements();

	} catch (e) {
		recup_erreur(e);
	}
}


function ooe_listerEmplacements() {
	try {

		var codeEmplacement = document.getElementById('ooe-filtreCodeEmplacement').value;
		var depotStock = document.getElementById('ooe-filtreDepotStock').value;
		var zoneStockage = document.getElementById('ooe-filtreZoneStockage').value;
		var supportStockage = document.getElementById('ooe-filtreSupportStockage').value;
		var refArticle = document.getElementById('ooe-filtreRefArticle').value;
		var actif = document.getElementById('ooe-filtreActif').checked;
		var nbLignesParPage = document.getElementById('ooe-nbLignesParPage').value;

		ooe_pageCourante = 1;
		ooe_nbPages = 1;
		document.getElementById('ooe-pageDeb').value = 1;
		document.getElementById('ooe-pageFin').value = 1;
		document.getElementById('ooe-bPrec').disabled = true;
		document.getElementById('ooe-bSuiv').disabled = true;

		document.getElementById('ooe-listeEmplacements').disabled = true;
		document.getElementById('ooe-bEditionCsv').disabled = true;
		document.getElementById('ooe-bEditionDetailCsv').disabled = true;
		document.getElementById('ooe-bEtiquettes').disabled = true;
		document.getElementById('ooe-codeEmplacementSelect').value = "";
		ooe_aApercuEmplacement.deleteTree();
		ooe_aEmplacements.deleteTree();

		ooe_qListES.setParam("Code_Emplacement", codeEmplacement);
		ooe_qListES.setParam("Depot_Stock", depotStock);
		ooe_qListES.setParam("Zone_Stockage", zoneStockage);
		ooe_qListES.setParam("Support_Stockage", supportStockage);
		ooe_qListES.setParam("Ref_Article", refArticle);
		ooe_qListES.setParam("Actif", actif);
		ooe_qListES.setParam("Nb_Lignes_Par_Page", nbLignesParPage);
		ooe_qListES.setParam("Current_Page", ooe_pageCourante);

		var result = ooe_qListES.execute();

		var contenu = result.responseXML.documentElement;

		ooe_nbPages = contenu.getAttribute("Nb_Pages");
		var listEmplacementId = contenu.getAttribute("List_Emplacement_Id");

		ooe_aEmplacements.setParam("List_Emplacement_Id", listEmplacementId);
		ooe_aEmplacements.initTree(ooe_initPagination);

	} catch (e) {
		recup_erreur(e);
	}
}


function ooe_initPagination() {
	try {

		document.getElementById('ooe-pageDeb').value = ooe_pageCourante;
		document.getElementById('ooe-pageFin').value = (ooe_nbPages>0?ooe_nbPages:1);
		document.getElementById('ooe-bPrec').disabled = (ooe_pageCourante==1);
		document.getElementById('ooe-bSuiv').disabled = (ooe_pageCourante>=ooe_nbPages); // peut se produire si ooe_nbPages=0

		ooe_afterMajPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function ooe_pressOnPagePrec() {
	try {

		ooe_pageCourante--;
		ooe_majPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function ooe_pressOnPageSuiv() {
	try {

		ooe_pageCourante++;
		ooe_majPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function ooe_majPagination() {
	try {

		document.getElementById('ooe-pageDeb').value = ooe_pageCourante;
		document.getElementById('ooe-bPrec').disabled = (ooe_pageCourante==1);
		document.getElementById('ooe-bSuiv').disabled = (ooe_pageCourante==ooe_nbPages);

		document.getElementById('ooe-listeEmplacements').disabled = true;
		document.getElementById('ooe-bEditionCsv').disabled = true;
		document.getElementById('ooe-bEditionDetailCsv').disabled = true;
		document.getElementById('ooe-bEtiquettes').disabled = true;

		document.getElementById('ooe-codeEmplacementSelect').value = "";
		ooe_aApercuEmplacement.deleteTree();

		ooe_qListES.setParam("Current_Page", ooe_pageCourante);
		var result = ooe_qListES.execute();
		var listEmplacementId = result.responseXML.documentElement.getAttribute("List_Emplacement_Id");

		ooe_aEmplacements.setParam("List_Emplacement_Id", listEmplacementId);
		ooe_aEmplacements.initTree(ooe_afterMajPagination);

	} catch (e) {
		recup_erreur(e);
	}
}


function ooe_afterMajPagination() {
	try {

		document.getElementById('ooe-listeEmplacements').disabled = false;
		document.getElementById('ooe-bEditionCsv').disabled = (ooe_aEmplacements.nbLignes()==0);
		document.getElementById('ooe-bEditionDetailCsv').disabled = (ooe_aEmplacements.nbLignes()==0);
		document.getElementById('ooe-bEtiquettes').disabled = (ooe_aEmplacements.nbLignes()==0);

	} catch (e) {
		recup_erreur(e);
	}
}


function ooe_selectOnListeEmplacements() {
	try {

		if (ooe_aEmplacements.isSelected()) {
			var emplacementId = ooe_aEmplacements.getSelectedCellText("ooe-colEmplacementId");
			document.getElementById('ooe-codeEmplacementSelect').value = ooe_aEmplacements.getSelectedCellText("ooe-colCodeEmplacement");
			ooe_aApercuEmplacement.setParam("Emplacement_Id", emplacementId);
			ooe_aApercuEmplacement.initTree();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function ooe_pressOnCritere(ev) {
  try {

		if (ev.keyCode==13) {
			ooe_listerEmplacements();
    }

	} catch (e) {
  	recup_erreur(e);
  }
}


function ooe_pressOnEditionCsv(detail) {
	try {

		var codeEmplacement = document.getElementById('ooe-filtreCodeEmplacement').value;
		var depotStock = document.getElementById('ooe-filtreDepotStock').value;
		var zoneStockage = document.getElementById('ooe-filtreZoneStockage').value;
		var supportStockage = document.getElementById('ooe-filtreSupportStockage').value;
		var refArticle = document.getElementById('ooe-filtreRefArticle').value;
		var actif = document.getElementById('ooe-filtreActif').checked;

		var qEditionCsv = new QueryHttp("Facturation/Emplacements/"+ (detail?"csvDetailEmplacementStock.tmpl":"csvEmplacementStock.tmpl"));

		qEditionCsv.setParam("Code_Emplacement", codeEmplacement);
		qEditionCsv.setParam("Depot_Stock", depotStock);
		qEditionCsv.setParam("Zone_Stockage", zoneStockage);
		qEditionCsv.setParam("Support_Stockage", supportStockage);
		qEditionCsv.setParam("Ref_Article", refArticle);
		qEditionCsv.setParam("Actif", actif);

		var result = qEditionCsv.execute();

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}
		else {
			var fichier = result.responseXML.documentElement.getAttribute('FichierCSV');

			var file = fileChooser("save", fichier);
			if (file!=null) {
				downloadFile(getDirBuffer()+ fichier, file);
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function ooe_editerEtiquettes() {
	try {

		document.getElementById('pdfEtiquettes').setAttribute("src", "");
		document.getElementById('bMenuEmplacements').collapsed = false;
		document.getElementById("deck").selectedIndex = 1;

		var codeEmplacement = document.getElementById('ooe-filtreCodeEmplacement').value;
		var depotStock = document.getElementById('ooe-filtreDepotStock').value;
		var zoneStockage = document.getElementById('ooe-filtreZoneStockage').value;
		var supportStockage = document.getElementById('ooe-filtreSupportStockage').value;
		var refArticle = document.getElementById('ooe-filtreRefArticle').value;
		var actif = document.getElementById('ooe-filtreActif').checked;

		var qEditionPdf = new QueryHttp("Facturation/Emplacements/pdfListEtiquetteEmplacement.tmpl");

		qEditionPdf.setParam("Code_Emplacement", codeEmplacement);
		qEditionPdf.setParam("Depot_Stock", depotStock);
		qEditionPdf.setParam("Zone_Stockage", zoneStockage);
		qEditionPdf.setParam("Support_Stockage", supportStockage);
		qEditionPdf.setParam("Ref_Article", refArticle);
		qEditionPdf.setParam("Actif", actif);

		var result = qEditionPdf.execute();

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}
		else {
			var page = getDirPdf() + result.responseXML.documentElement.getAttribute('FichierPDF');
			document.getElementById('pdfEtiquettes').setAttribute("src", page);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function ooe_nouveauEmplacement() {
	try {

		ooe_currentEmplacementId = "";
		ooe_aEmplacements.clearSelection();

		ooe_selDepotId = depotDefaut;
		ooe_selZoneId = "";
		ooe_chargerDepots();
		ooe_chargerSupport("");
		document.getElementById('ooe-codeEmplacement').value = "";
		document.getElementById('ooe-actif').checked = true;

		document.getElementById('ooe-depotId').disabled = false;
		document.getElementById('ooe-bSupprimer').collapsed = true;
		document.getElementById('ooe-bNouveau').collapsed = true;

	} catch (e) {
    recup_erreur(e);
  }
}


function ooe_chargerEmplacement() {
	try {

		if (ooe_aEmplacements.isSelected()) {
			ooe_currentEmplacementId = ooe_aEmplacements.getSelectedCellText("ooe-colEmplacementId");

			var qLoad = new QueryHttp("Facturation/Emplacements/loadEmplacementStock.tmpl");
			qLoad.setParam("Emplacement_Id", ooe_currentEmplacementId);
			var result = qLoad.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				var contenu = result.responseXML.documentElement;

				ooe_selDepotId = contenu.getAttribute('Depot_Id');
				ooe_selZoneId = contenu.getAttribute('Zone_Id');
				ooe_chargerDepots();
				ooe_chargerSupport(contenu.getAttribute('Support_Id'));
				document.getElementById('ooe-codeEmplacement').value = contenu.getAttribute('Code_Emplacement');
				document.getElementById('ooe-actif').checked = contenu.getAttribute('Actif')=="true";

				document.getElementById('ooe-depotId').disabled = true;
				document.getElementById('ooe-bSupprimer').collapsed = false;
				document.getElementById('ooe-bNouveau').collapsed = false;
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function ooe_enregistrerEmplacement() {
	try {

		var codeEmplacement = document.getElementById('ooe-codeEmplacement').value;
		var depotId = document.getElementById('ooe-depotId').value;
		var zoneId = document.getElementById('ooe-zoneId').value;
		var supportId = document.getElementById('ooe-supportId').value;
		var actif = document.getElementById('ooe-actif').checked;

		if (isEmpty(codeEmplacement)) {
			showWarning("Code emplacement manquant");
		}
		else if (isEmpty(depotId)) {
			showWarning("D\u00E9p\u00F4t de stock manquant");
		}
		else {
			var qSave;

			if (!isEmpty(ooe_currentEmplacementId)) {
				qSave = new QueryHttp("Facturation/Emplacements/updateEmplacementStock.tmpl");
				qSave.setParam("Emplacement_Id", ooe_currentEmplacementId);
			}
			else {
				qSave = new QueryHttp("Facturation/Emplacements/createEmplacementStock.tmpl");
				qSave.setParam("Depot_Id", depotId);
			}

			qSave.setParam("Code_Emplacement", codeEmplacement);
			qSave.setParam("Zone_Id", zoneId);
			qSave.setParam("Support_Id", supportId);
			qSave.setParam("Actif", actif);

			var result = qSave.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				ooe_nouveauEmplacement();
				ooe_listerEmplacements();
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function ooe_supprimerEmplacement() {
	try {

		if (!isEmpty(ooe_currentEmplacementId) && window.confirm("Confirmez-vous la suppression de l'emplacement s\u00E9lectionn\u00E9 ?")) {

			var qDelete = new QueryHttp("Facturation/Emplacements/deleteEmplacementStock.tmpl");
			qDelete.setParam("Emplacement_Id", ooe_currentEmplacementId);
			var result = qDelete.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				ooe_listerEmplacements();
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function ooe_chargerDepots() {
	try {

		ooe_aDepots.setParam("Selection", ooe_selDepotId);
		ooe_aDepots.initTree(ooe_initDepot);

	} catch (e) {
		recup_erreur(e);
	}
}


function ooe_initDepot() {
  try {

		document.getElementById('ooe-depotId').value = ooe_selDepotId;
		if (!isEmpty(ooe_selDepotId)) {
			ooe_selDepotId = "";
			ooe_chargerZones();
		}
		else {
			ooe_aZones.deleteTree();
			document.getElementById('ooe-zoneId').value = "";
			document.getElementById('ooe-zoneId').disabled = true;
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function ooe_chargerZones() {
	try {

		var depotId = document.getElementById('ooe-depotId').value;
		if (isEmpty(depotId)) {
			document.getElementById('ooe-zoneId').disabled = true;
		}
		else {
			ooe_aZones.setParam('Depot_Id', depotId);
			ooe_aZones.setParam("Selection", ooe_selZoneId);
			ooe_aZones.initTree(ooe_initZone);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function ooe_initZone() {
  try {

		document.getElementById('ooe-zoneId').value = ooe_selZoneId;
		if (!isEmpty(document.getElementById('ooe-depotId').value)) {
			document.getElementById('ooe-zoneId').disabled = false;
		}

		ooe_selZoneId = "";

	} catch (e) {
		recup_erreur(e);
	}
}


function ooe_chargerSupport(selection) {
	try {

		ooe_selSupportId = selection;
		ooe_aSupports.setParam("Selection", selection);
		ooe_aSupports.initTree(ooe_initSupport);

	} catch (e) {
		recup_erreur(e);
	}
}


function ooe_initSupport() {
	try {

		document.getElementById('ooe-supportId').value = ooe_selSupportId;

	} catch (e) {
		recup_erreur(e);
	}
}


function ooe_rechercherArticle() {
	try {

		var url = "chrome://opensi/content/facturation/user/articles/popup-rechercheArticle.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', ooe_retourRechercherArticle, null);

	} catch (e) {
		recup_erreur(e);
	}
}


function ooe_retourRechercherArticle(reference, articleId) {
	try {

  	document.getElementById('ooe-filtreRefArticle').value = reference;
  	ooe_listerEmplacements();

	} catch (e) {
		recup_erreur(e);
	}
}
