/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/


var oos_aSupports = new Arbre("Facturation/Emplacements/list-supportStockage.tmpl", "oos-listeSupports");

var oos_currentSupportId = "";



function oos_initOngletSupports() {
	try {

		oos_listerSupports();

	} catch (e) {
    recup_erreur(e);
  }
}


function oos_listerSupports() {
	try {

		oos_aSupports.setParam("Actif", document.getElementById("oos-filtreActif").checked);
		oos_aSupports.initTree();
		oos_nouveauSupport();

	} catch (e) {
		recup_erreur(e);
	}
}


function oos_nouveauSupport() {
	try {

		oos_currentSupportId = "";
		oos_aSupports.clearSelection();

		document.getElementById('oos-libelle').value = "";
		document.getElementById('oos-codeSupport').value = "";
		document.getElementById('oos-actif').checked = true;

		document.getElementById('oos-bSupprimer').collapsed = true;
		document.getElementById('oos-bNouveau').collapsed = true;

	} catch (e) {
    recup_erreur(e);
  }
}


function oos_chargerSupport() {
	try {

		if (oos_aSupports.isSelected()) {
			oos_currentSupportId = oos_aSupports.getSelectedCellText("oos-colSupportId");

			var qLoad = new QueryHttp("Facturation/Emplacements/loadSupportStockage.tmpl");
			qLoad.setParam("Support_Id", oos_currentSupportId);
			var result = qLoad.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				var contenu = result.responseXML.documentElement;

				document.getElementById('oos-libelle').value = contenu.getAttribute('Libelle');
				document.getElementById('oos-codeSupport').value = contenu.getAttribute('Code_Support');
				document.getElementById('oos-actif').checked = contenu.getAttribute('Actif')=="true";

				document.getElementById('oos-bSupprimer').collapsed = false;
				document.getElementById('oos-bNouveau').collapsed = false;
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oos_enregistrerSupport() {
	try {

		var libelle = document.getElementById('oos-libelle').value;
		var codeSupport = document.getElementById('oos-codeSupport').value;
		var actif = document.getElementById('oos-actif').checked;

		if (isEmpty(libelle)) {
			showWarning("Libell\u00E9 manquant");
		}
		else {
			var qSave;

			if (!isEmpty(oos_currentSupportId)) {
				qSave = new QueryHttp("Facturation/Emplacements/updateSupportStockage.tmpl");
				qSave.setParam("Support_Id", oos_currentSupportId);
			}
			else {
				qSave = new QueryHttp("Facturation/Emplacements/createSupportStockage.tmpl");
			}

			qSave.setParam("Libelle", libelle);
			qSave.setParam("Code_Support", codeSupport);
			qSave.setParam("Actif", actif);

			var result = qSave.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				oos_listerSupports();
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oos_supprimerSupport() {
	try {

		if (!isEmpty(oos_currentSupportId) && window.confirm("Confirmez-vous la suppression du support s\u00E9lectionn\u00E9 ?")) {

			var qDelete = new QueryHttp("Facturation/Emplacements/deleteSupportStockage.tmpl");
			qDelete.setParam("Support_Id", oos_currentSupportId);
			var result = qDelete.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				oos_listerSupports();
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}
