/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

/*
	Arguments du popup :
		- 0 : Fonction de retour
		- 1 : Depot_Id
		- 2 : Code_Emplacement
*/


jsLoader.loadSubScript("chrome://opensi/content/libs/arbres.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/verif.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");


var aDepots = new Arbre('ComboListe/combo-depotsStock.tmpl', 'depotId');
var aZones = new Arbre("ComboListe/combo-zonesStockage.tmpl", "zoneId");

var selDepotId;



function init() {
  try {

		selDepotId = window.arguments[1];
		chargerDepots();

		document.getElementById('codeEmplacement').value = window.arguments[2];

		var aSupports = new Arbre("ComboListe/combo-supportsStockage.tmpl", "supportId");
		aSupports.initTree();

  } catch (e) {
    recup_erreur(e);
  }
}


function chargerDepots() {
	try {

		aDepots.setParam("Selection", selDepotId);
		aDepots.initTree(initDepot);

	} catch (e) {
		recup_erreur(e);
	}
}


function initDepot() {
  try {

		document.getElementById('depotId').value = selDepotId;
		if (!isEmpty(selDepotId)) {
			selDepotId = "";
			chargerZones();
		}
		else {
			aZones.deleteTree();
			document.getElementById('zoneId').value = "";
			document.getElementById('zoneId').disabled = true;
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function chargerZones() {
	try {

		var depotId = document.getElementById('depotId').value;
		if (isEmpty(depotId)) {
			document.getElementById('zoneId').disabled = true;
		}
		else {
			aZones.setParam('Depot_Id', depotId);
			aZones.initTree(initZone);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function initZone() {
  try {

		document.getElementById('zoneId').value = "";
		if (!isEmpty(document.getElementById('depotId').value)) {
			document.getElementById('zoneId').disabled = false;
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function valider() {
  try {

		var codeEmplacement = document.getElementById('codeEmplacement').value;
		var depotId = document.getElementById('depotId').value;
		var zoneId = document.getElementById('zoneId').value;
		var supportId = document.getElementById('supportId').value;

		if (isEmpty(codeEmplacement)) {
			showWarning("Code emplacement manquant");
		}
		else if (isEmpty(depotId)) {
			showWarning("D\u00E9p\u00F4t de stock manquant");
		}
		else {
			var qCreate = new QueryHttp("Facturation/Emplacements/createEmplacementStock.tmpl");

			qCreate.setParam("Depot_Id", depotId);
			qCreate.setParam("Code_Emplacement", codeEmplacement);
			qCreate.setParam("Zone_Id", zoneId);
			qCreate.setParam("Support_Id", supportId);
			qCreate.setParam("Actif", true);

			var result = qCreate.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				if (window.arguments[0]!=null) {
					var emplacementId = result.responseXML.documentElement.getAttribute('Emplacement_Id');
					window.arguments[0](emplacementId);
				}
				window.close();
			}
		}

  } catch (e) {
    recup_erreur(e);
  }
}
