/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

/*
	Arguments du popup :
		- 0 : Fonction de retour
		- 1 : Depot_Id
		- 2 : Rfrence article
*/

jsLoader.loadSubScript("chrome://opensi/content/libs/verif.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/arbres.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");


var aZones = new Arbre("ComboListe/combo-zonesStockage.tmpl", "zoneStockage");
var aApercuEmplacement = new Arbre("Facturation/Emplacements/list-apercuEmplacementStock.tmpl", "apercuEmplacement");
var aEmplacements = new Arbre("Facturation/Emplacements/list-emplacementStock.tmpl", "listeEmplacements");
var qListES = new QueryHttp("Facturation/Emplacements/getDataListES.tmpl");

var pageCourante;
var nbPages;

var argDepotId;
var argRefArticle;
var depotDefaut = "";



function init() {
  try {

		argDepotId = window.arguments[1];
		argRefArticle = window.arguments[2];

		if (argRefArticle!=null && !isEmpty(argRefArticle)) {
			document.getElementById('refArticle').value = "="+ argRefArticle;
		}

		if (argDepotId==null || isEmpty(argDepotId)) {
			var etablissementDefaut = getProfil().getEtabId();

			var qDepotDefaut = new QueryHttp("Facturation/Commun/getDepotDefautEts.tmpl");
			qDepotDefaut.setParam("Etablissement_Id", etablissementDefaut);
			var result = qDepotDefaut.execute();
			depotDefaut = result.responseXML.documentElement.getAttribute('Depot_Defaut');
		}

		document.getElementById('depotStock').disabled = argDepotId!=null && !isEmpty(argDepotId);

		var aDepots = new Arbre("ComboListe/combo-depotsStock.tmpl", "depotStock");
		aDepots.setParam('Selection', argDepotId!=null && !isEmpty(argDepotId)?argDepotId:depotDefaut);
		aDepots.initTree(initDepotStock);

		var aSupports = new Arbre("ComboListe/combo-supportsStockage.tmpl", "supportStockage");
		aSupports.initTree();

    document.getElementById('codeEmplacement').focus();

  } catch (e) {
    recup_erreur(e);
  }
}


function initDepotStock() {
	try {

		document.getElementById('depotStock').value = argDepotId!=null && !isEmpty(argDepotId)?argDepotId:depotDefaut;
		chargerZones();

		if (argRefArticle!=null && !isEmpty(argRefArticle)) {
			listerEmplacements();
		}

	} catch (e) {
		recup_erreur(e);
  }
}


function chargerZones() {
	try {

		aZones.setParam("Depot_Id", document.getElementById('depotStock').value);
		aZones.initTree(initZoneStockage);

	} catch (e) {
		recup_erreur(e);
  }
}


function initZoneStockage() {
	try {

		document.getElementById('zoneStockage').value = "";

	} catch (e) {
		recup_erreur(e);
  }
}


function pressOnCodeEmplacement(ev) {
  try {

    if (ev.keyCode==13) {
			checkEmplacement(document.getElementById('codeEmplacement').value);
    }

  } catch (e) {
    recup_erreur(e);
  }
}


function pressOnCritere(ev) {
  try {

    if (ev.keyCode==13) {
			listerEmplacements();
    }

  } catch (e) {
    recup_erreur(e);
  }
}


function checkEmplacement(codeEmplacement) {
  try {

		if (!isEmpty(codeEmplacement)) {
			var depotId = document.getElementById('depotStock').value;

			var qSearch = new QueryHttp("Facturation/Emplacements/searchCodeEmplacement.tmpl");
			qSearch.setParam('Code_Emplacement', codeEmplacement);
			qSearch.setParam('Depot_Id', depotId);

			var result = qSearch.execute();
			var contenu = result.responseXML.documentElement;

			var emplacementId = contenu.getAttribute('Emplacement_Id');

			if (!isEmpty(emplacementId)) {
				ouvrirEmplacement(contenu.getAttribute('Code_Emplacement'), emplacementId);
			}
			else {
				listerEmplacements();
			}
		}
		else {
			listerEmplacements();
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function pressOnTree(ev) {
  try {

    if (ev.keyCode==13) {
			choixEmplacement();
  	}

  } catch (e) {
    recup_erreur(e);
  }
}


function ouvrirEmplacement(codeEmplacement, emplacementId) {
  try {

		window.arguments[0](codeEmplacement, emplacementId);
    setTimeout("window.close()", 0); // pour fermeture si fonction appele d'un autre popup

  } catch (e) {
    recup_erreur(e);
  }
}


function choixEmplacement() {
	try {

		if (aEmplacements.isSelected()) {
			var codeEmplacement = aEmplacements.getSelectedCellText('colCodeEmplacement');
			var emplacementId = aEmplacements.getSelectedCellText('colEmplacementId');
			ouvrirEmplacement(codeEmplacement, emplacementId);
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function initCriteres() {
	try {

		document.getElementById('codeEmplacement').value = "";
		document.getElementById('depotStock').value = argDepotId!=null && !isEmpty(argDepotId)?argDepotId:depotDefaut;
		document.getElementById('zoneStockage').value = "";
		document.getElementById('supportStockage').value = "";
		document.getElementById('refArticle').value = "";
		document.getElementById('actif').checked = true;

		listerEmplacements();

	} catch (e) {
    recup_erreur(e);
  }
}


function listerEmplacements() {
	try {

		var codeEmplacement = document.getElementById('codeEmplacement').value;
		var depotStock = document.getElementById('depotStock').value;
		var zoneStockage = document.getElementById('zoneStockage').value;
		var supportStockage = document.getElementById('supportStockage').value;
		var refArticle = document.getElementById('refArticle').value;
		var actif = document.getElementById('actif').checked;

		var nbLignesParPage = document.getElementById('nbLignesParPage').value;

		pageCourante = 1;
		nbPages = 1;
		document.getElementById('pageDeb').value = 1;
		document.getElementById('pageFin').value = 1;
		document.getElementById('bPrec').disabled = true;
		document.getElementById('bSuiv').disabled = true;

		document.getElementById('listeEmplacements').disabled = true;
		document.getElementById('codeEmplacementSelect').value = "";
		aApercuEmplacement.deleteTree();
		aEmplacements.deleteTree();

		qListES.setParam('Depot_Stock', depotStock);
		qListES.setParam("Code_Emplacement", codeEmplacement);
		qListES.setParam("Zone_Stockage", zoneStockage);
		qListES.setParam("Support_Stockage", supportStockage);
		qListES.setParam("Ref_Article", refArticle);
		qListES.setParam("Actif", actif);
		qListES.setParam("Nb_Lignes_Par_Page", nbLignesParPage);
		qListES.setParam("Current_Page", pageCourante);

		var result = qListES.execute();

		var contenu = result.responseXML.documentElement;

		nbPages = contenu.getAttribute("Nb_Pages");
		var listEmplacementId = contenu.getAttribute("List_Emplacement_Id");

		aEmplacements.setParam("List_Emplacement_Id", listEmplacementId);
		aEmplacements.initTree(initPagination);

	} catch (e) {
    recup_erreur(e);
  }
}


function initPagination() {
	try {

		document.getElementById('pageDeb').value = pageCourante;
		document.getElementById('pageFin').value = (nbPages>0?nbPages:1);
		document.getElementById('bPrec').disabled = (pageCourante==1);
		document.getElementById('bSuiv').disabled = (pageCourante>=nbPages); // peut se produire si nbPages=0

		afterMajPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function pressOnPagePrec() {
	try {

		pageCourante--;
		majPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function pressOnPageSuiv() {
	try {

		pageCourante++;
		majPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function majPagination() {
	try {

		document.getElementById('pageDeb').value = pageCourante;
		document.getElementById('bPrec').disabled = (pageCourante==1);
		document.getElementById('bSuiv').disabled = (pageCourante==nbPages);

		document.getElementById('listeEmplacements').disabled = true;

		document.getElementById('codeEmplacementSelect').value = "";
		aApercuEmplacement.deleteTree();

		qListES.setParam("Current_Page", pageCourante);
		var result = qListES.execute();
		var listEmplacementId = result.responseXML.documentElement.getAttribute("List_Emplacement_Id");

		aEmplacements.setParam("List_Emplacement_Id", listEmplacementId);
		aEmplacements.initTree(afterMajPagination);

	} catch (e) {
		recup_erreur(e);
	}
}


function afterMajPagination() {
	try {

		document.getElementById('listeEmplacements').disabled = false;

	} catch (e) {
		recup_erreur(e);
	}
}


function selectOnListeEmplacements() {
	try {

		if (aEmplacements.isSelected()) {
			var emplacementId = aEmplacements.getSelectedCellText("colEmplacementId");
			document.getElementById('codeEmplacementSelect').value = aEmplacements.getSelectedCellText("colCodeEmplacement");
			aApercuEmplacement.setParam("Emplacement_Id", emplacementId);
			aApercuEmplacement.initTree();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function rechercherArticle() {
	try {

		var url = "chrome://opensi/content/facturation/user/articles/popup-rechercheArticle.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', retourRechercherArticle, null);

	} catch (e) {
		recup_erreur(e);
	}
}


function retourRechercherArticle(reference, articleId) {
	try {

  	document.getElementById('refArticle').value = reference;
  	listerEmplacements();

	} catch (e) {
		recup_erreur(e);
	}
}
