/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

jsLoader.loadSubScript("chrome://opensi/content/libs/verif.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/arbres.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");


var aModeExpe = new Arbre('Facturation/Expedition/list-modeExpeditionTransporteur.tmpl','listeModesExpedition');
var aExpeditions = new Arbre('Facturation/Expedition/liste-expeditions.tmpl','listeExpeditions');
var aColis = new Arbre('Facturation/Expedition/liste-colis.tmpl','listeColis');

var treeFormatsExport = new Arbre("ComboListe/combo-formatsTransporteur.tmpl", "FormatExport");
var treeFormatsImport = new Arbre("ComboListe/combo-formatsImportColis.tmpl", "FormatImport");
var aDepots = new Arbre('ComboListe/combo-depotsStock.tmpl', 'depot');

var aUnconfirmedExpedition = new Arbre('Facturation/Expedition/list-unconfirmedExpedition.tmpl', 'list-BL');
var qListUE = new QueryHttp("Facturation/Expedition/getDataListUE.tmpl");

var otmt_aErreurs = new Arbre('Facturation/Expedition/list-erreurTransporteur.tmpl', 'list-erreurTransporteur');
var otmt_aPaysLiv = new Arbre("ComboListe/combo-pays.tmpl", "otmt-codePaysLiv");
var otmt_aColis = new Arbre('Facturation/Expedition/list-colisErreurTransporteur.tmpl','otmt-listeColis');
var otmt_currentErreurId = "";
var otmt_currentColisId = "";

var qModColis = new QueryHttp("Facturation/Expedition/updateColis.tmpl");
var qSuppColis = new QueryHttp("Facturation/Expedition/deleteColis.tmpl");

var depotDefaut;
var importFile;

var bonId = "";
var colisId = "";
var lastBonLivId = "";

var auj;
var demain;

var pageCourante;
var nbPages;



function init() {
	try {

		var config = getConfig();

		document.getElementById("NouveauColis").disabled = true;
		document.getElementById("ValiderColis").disabled = true;
		document.getElementById("SupprimerColis").disabled = true;

		document.getElementById('boxProvenance').collapsed = !config.isECommerce();

		var etablissementDefaut = getProfil().getEtabId();

		var qDepotDefaut = new QueryHttp("Facturation/Commun/getDepotDefautEts.tmpl");
		qDepotDefaut.setParam("Etablissement_Id", etablissementDefaut);
		var result = qDepotDefaut.execute();
		var type = result.responseXML.documentElement.getAttribute('Type');
		depotDefaut = (type=="E"?result.responseXML.documentElement.getAttribute('Depot_Defaut'):"");

		document.getElementById('Periode').value="A";

		var qDates = new QueryHttp("GetDates.tmpl");
		result = qDates.execute();
		auj = result.responseXML.documentElement.getAttribute("auj");
		demain = result.responseXML.documentElement.getAttribute("demain");
		document.getElementById('Date_Debut').value = auj;
		document.getElementById('Date_Fin').value = demain;

		document.getElementById('typeBL').value="";
		document.getElementById('typeBLExport').value = "B";
		document.getElementById('origineBL').value = "C";
		listerUnconfirmedExpedition();

		aDepots.setParam("Depot_Vente", false);
		aDepots.setParam("Depot_Logistique", false);
		aDepots.setParam("Depot_Quarantaine", false);
		aDepots.initTree(initDepot);

		otmt_aPaysLiv.initTree(otmt_initPaysLiv);

		var gSymboleUniteVolume = config.getSymboleUniteVolume();

		document.getElementById("otmt-colVolume").setAttribute("label", "Volume ("+ gSymboleUniteVolume +")");
		document.getElementById("otmt-lblVolume").value = "Volume ("+ gSymboleUniteVolume +") :";
		document.getElementById("lcColVolume").setAttribute("label", "Volume ("+ gSymboleUniteVolume +")");
		document.getElementById("lblVolume").value = "Volume ("+ gSymboleUniteVolume +") :";

	} catch (e) {
    recup_erreur(e);
  }
}


function initCriteres() {
	try {

		document.getElementById('Heure').value = "00:00";
		document.getElementById('Heure_Debut').value = "00:00";
		document.getElementById('Heure_Fin').value = "00:00";

		document.getElementById('Date_Debut').value=auj;
		document.getElementById('Date_Fin').value=demain;

		document.getElementById('depot').value = depotDefaut;

		document.getElementById('noncolis').checked=true;
		document.getElementById('nonexportes').checked=true;
		document.getElementById('provenance').value="T";
		document.getElementById('typeBLExport').value = "B";
		document.getElementById('FormatExport').value="";
		initTreeExpeditions();

	} catch (e) {
		recup_erreur(e);
	}
}


function initDepot() {
	try {

		document.getElementById('depot').value = depotDefaut;
		treeFormatsExport.setParam("Type_Format", "E");
		treeFormatsExport.initTree(initFormatExport);

	} catch (e) {
		recup_erreur(e);
	}
}


function initFormatExport() {
	try {

		document.getElementById('FormatExport').selectedIndex = 0;
		treeFormatsImport.initTree(initFormatImport);

	} catch (e) {
    recup_erreur(e);
  }
}


function initFormatImport() {
	try {

		document.getElementById('FormatImport').selectedIndex = 0;
		initTreeModesExpedition();

	} catch (e) {
    recup_erreur(e);
  }
}


function initTreeModesExpedition() {
	try {

		aModeExpe.setParam("Format_Export", document.getElementById('FormatExport').value);
		aModeExpe.initTree(initTreeExpeditions);

	} catch (e) {
    recup_erreur(e);
  }
}


function changeTypeBLExport() {
	try {

		if (document.getElementById('typeBLExport').value=="F") {
			document.getElementById('depot').value = "";
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function initTreeExpeditions() {
	try {

		var nbModesExpe = 0;
		var expediteur="";
		var nbLignes = aModeExpe.nbLignes();
		if (nbLignes>0) {
			for (var i=0; i<aModeExpe.nbLignes(); i++) {
				if (aModeExpe.getCellValue(i, "colSelect")=="true") {
					nbModesExpe++;
					expediteur += aModeExpe.getCellText(i, "lcModeExpId") +",";
				}
			}
  		}
		if (nbModesExpe>0) {

			var heure = document.getElementById('Heure').value;

			var colis = document.getElementById('noncolis').checked;
			var nonExportes = document.getElementById('nonexportes').checked;
			var provenance = document.getElementById('provenance').value;
			var typeBL = document.getElementById('typeBLExport').value;
			var depot = document.getElementById('depot').value;
			var format = document.getElementById('FormatExport').value;
			var heure_debut = document.getElementById('Heure_Debut').value;
			var heure_fin = document.getElementById('Heure_Fin').value;
			var date_debut = document.getElementById('Date_Debut').value;
			var date_fin = document.getElementById('Date_Fin').value;
			var dtDebut = convertXulDateTime(date_debut, heure_debut);
			var dtFin = convertXulDateTime(date_fin, heure_fin);

			if (document.getElementById('PeriodeDD').selected && (!isDateTime(dtDebut) || !isDateTime(dtFin) || !isDateTimeInterval(dtDebut, dtFin))) {
				showMessage("Plage de dates invalide !");
			}
			else {
				aColis.deleteTree();
				document.getElementById("NouveauColis").disabled = true;
				document.getElementById("ValiderColis").disabled = true;
				document.getElementById("SupprimerColis").disabled = true;

				aExpeditions.setParam("Heure", heure);
				aExpeditions.setParam("Heure_Debut", heure_debut);
				aExpeditions.setParam("Heure_Fin", heure_fin);
				aExpeditions.setParam("Date_Debut", date_debut);
				aExpeditions.setParam("Date_Fin", date_fin);
				aExpeditions.setParam("Colis", colis);
				aExpeditions.setParam("Non_Exportes", nonExportes);
				aExpeditions.setParam("Depot_Id", depot);
				aExpeditions.setParam("Provenance", provenance);
				aExpeditions.setParam("Type_BL", typeBL);
				aExpeditions.setParam("Expediteur", expediteur);
				aExpeditions.setParam("Periode", document.getElementById('Periode').value);
				aExpeditions.initTree();
			}
		}
		else {
			aColis.deleteTree();
			aExpeditions.deleteTree();
			document.getElementById("NouveauColis").disabled = true;
			document.getElementById("ValiderColis").disabled = true;
			document.getElementById("SupprimerColis").disabled = true;
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function listerColis(bonId) {
	try {

		aColis.setParam("Bon_Id", bonId);
		aColis.initTree();

		nouveauColis();

	} catch (e) {
    recup_erreur(e);
  }
}


function validerColis() {
	try {

		var poids = document.getElementById('poids').value;
		var volume = document.getElementById('volume').value;

		if (isEmpty(volume)) {
			volume = 0;
		}

		if (!isPositiveOrNull(poids) || !checkNumber(poids,10,3)) {
			showWarning("Poids du colis incorrect");
		}
		else if (!isPositiveOrNull(volume) || !checkNumber(volume,9,3)) {
			showWarning("Volume du colis incorrect");
		}
		else {
			if (!isEmpty(colisId)) {
				if (aColis.getSelectedCellText("lcColStatut")!="N") {
					showWarning("Impossible de modifier un colis d\u00E9j\u00E0 num\u00E9rot\u00E9");
				}
				else {
					qModColis.setParam("Colis_Id", colisId);
					qModColis.setParam("Poids", poids);
					qModColis.setParam("Volume", volume);
					var result = qModColis.execute();

					var errors = new Errors(result);
					if (errors.hasNext()) {
						errors.show();
					}
				}
			}
			else {
				var qCreate = new QueryHttp("Facturation/Expedition/createColis.tmpl");
				qCreate.setParam("Bon_Liv_Id", bonId);
				qCreate.setParam("Poids", poids);
				qCreate.setParam("Volume", volume);
				var result = qCreate.execute();

				var errors = new Errors(result);
				if (errors.hasNext()) {
					errors.show();
				}
			}

			aColis.initTree();
			nouveauColis();
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function supprimerColis() {
	try {

		if (aColis.nbLignes()==1) {
			showWarning("Vous ne pouvez pas supprimer le dernier colis");
		}
		else {
			qSuppColis.setParam("Colis_Id", colisId);
			var result = qSuppColis.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}

			aColis.initTree();
			nouveauColis();
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function nouveauColis() {
	try {

		colisId = "";
		document.getElementById('interne').value = "";
		document.getElementById('poids').value = "";
		document.getElementById('volume').value = "";
		document.getElementById("NouveauColis").disabled = false;
		document.getElementById("ValiderColis").disabled = false;
		document.getElementById("SupprimerColis").disabled = true;

	} catch (e) {
    recup_erreur(e);
  }
}


function selectOnListeExpeditions() {
	try {

		if (aExpeditions.isSelected()) {
			bonId = aExpeditions.getSelectedCellText("colBon_Id");
			document.getElementById('numBonColis').value = "Colis du bon de livraison N\u00B0 "+ aExpeditions.getSelectedCellText("colNum_BL") +" :";
			listerColis(bonId);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function selectOnListeColis() {
	try {

		if (aColis.isSelected()) {
			colisId = aColis.getSelectedCellText("lcColColisId");
			document.getElementById('interne').value = aColis.getSelectedCellText("lcColNumInterne");
			document.getElementById('poids').value = aColis.getSelectedCellText("lcColPoids");
			document.getElementById('volume').value = aColis.getSelectedCellText("lcColVolume");
			document.getElementById("NouveauColis").disabled = false;
			document.getElementById("ValiderColis").disabled = false;
			document.getElementById("SupprimerColis").disabled = false;
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function toutCocherBL(b) {
	try {

		for (var i=0; i<aExpeditions.nbLignes(); i++) {
			if (aExpeditions.isEditable(i, "colSelect")) {
				aExpeditions.setCellValue(i, "colSelect", b);
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function disableHeure(b) {
	try {

		document.getElementById('Heure').disabled = b;

	} catch (e) {
    recup_erreur(e);
  }
}


function disableDates(b) {
	try {

		document.getElementById('Date_Debut').disabled = b;
		document.getElementById('Date_Fin').disabled = b;
		document.getElementById('Heure_Debut').disabled = b;
		document.getElementById('Heure_Fin').disabled = b;

	} catch (e) {
    recup_erreur(e);
  }
}


function exporter() {
	try {

		var listBonId = "";
		var nbCommandesATraiter = 0;

		for (var i=0; i<aExpeditions.nbLignes(); i++) {
			if (aExpeditions.getCellValue(i, "colSelect")=="true") {
				nbCommandesATraiter++;
				listBonId += aExpeditions.getCellText(i, "colBon_Id") +",";
			}
		}

		var format = document.getElementById('FormatExport').value;

		if (nbCommandesATraiter==0) {
			showWarning("Veuillez s\u00E9lectionner au moins un bon de livraison");
		}
		else if (isEmpty(format)) {
			showWarning("Veuillez choisir un format d'export");
		}
		else {
			document.getElementById('progression').collapsed = false;
			document.getElementById('pm').setAttribute("mode", "undetermined");
			document.getElementById('bExporter').disabled = true;

			var qGenExport = new QueryHttp("Facturation/Expedition/ProcessExport.tmpl");
			qGenExport.setParam('Format', format);
			qGenExport.setParam('Liste_Export', listBonId);
			var result = qGenExport.execute();

			var contenu = result.responseXML.documentElement;
			var fichier_export = contenu.getAttribute('FileName');
			var nom_sugg = contenu.getAttribute('SuggestedName');

			document.getElementById('pm').setAttribute("mode", "none");
			document.getElementById('progression').collapsed = true;
			document.getElementById('bExporter').disabled = false;

			var file = fileChooser("save", nom_sugg);
			if (file!=null) {
				downloadFile(getDirBuffer()+ fichier_export, file);
				initTreeExpeditions();
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function searchFile() {
	try {

		var file = fileChooser("open");
		if (file!=null) {
			importFile = file;
			document.getElementById("pathFile").value = file.path;
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function importer() {
	try {

		var format = document.getElementById('FormatImport').value;

    if (importFile==null) {
			showWarning("Vous devez s\u00E9lectionner un fichier");
		}
		else if (isEmpty(format)) {
			showWarning("Vous devez s\u00E9lectionner un format d'import");
		}
		else if (checkUploadFile(importFile)) {

			uploadFile(importFile);

			var qImport = new QueryHttp("Facturation/Expedition/ProcessImport.tmpl");
			qImport.setParam("Format", format);
			qImport.setParam("Fichier", importFile.leafName);
			var result = qImport.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				showMessage("Les num\u00E9ros de colis ont \u00E9t\u00E9 mis \u00E0 jour");
			}
		}

  } catch (e) {
    recup_erreur(e);
  }
}


function onKeyPressConfirmation(ev) {
	try {

		if (ev.keyCode==13) {
			confirmerExpedition();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function pressOnPoids(ev) {
	try {

		if (ev.keyCode==13) {
			validerColis();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function pressOnVolume(ev) {
	try {

		if (ev.keyCode==13) {
			validerColis();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function onKeyPress(ev) {
	try {

		if (ev.keyCode==13) {
			initTreeExpeditions();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function confirmerExpedition() {
	try {

		var numExpedition = document.getElementById("numeroBL").value;

		if (!isEmpty(numExpedition))	{
			var qConfirm = new QueryHttp("Facturation/Expedition/ConfirmExp.tmpl");
			qConfirm.setParam("Num_Expedition", numExpedition);
			var result = qConfirm.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				lastBonLivId = result.responseXML.documentElement.getAttribute("Bon_Liv_Id");
				document.getElementById("lblDernierBL").value = numExpedition;
				document.getElementById("lblDernierColis").value = "";
				document.getElementById("boxScanIci").collapsed = true;
				document.getElementById("boxDernierBL").collapsed = false;
			}

			document.getElementById("numeroBL").value = "";
			listerUnconfirmedExpedition();
			document.getElementById("numeroBL").focus();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function pressOnNumColis(ev) {
	try {

		if (ev.keyCode==13) {
			ajouterNumColis();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function ajouterNumColis() {
	try {

		if (!isEmpty(lastBonLivId)) {
			var numColis = document.getElementById("numColis").value;

			if (!isEmpty(numColis))	{
				var qInject = new QueryHttp("Facturation/Expedition/injectTrackingBL.tmpl");
				qInject.setParam("Bon_Liv_Id", lastBonLivId);
				qInject.setParam("Num_Colis", numColis);
				var result = qInject.execute();

				var errors = new Errors(result);
				if (errors.hasNext()) {
					errors.show();
				}
				else {
					document.getElementById("numColis").value = "";
					document.getElementById("lblDernierColis").value = numColis;
				}
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function pressOnSourceType() {
	try {

		var isTypeCommande = document.getElementById('origineBL').value=="C";
		document.getElementById("filterTypeExpedition").collapsed = !isTypeCommande;

		if (!isTypeCommande) {
			document.getElementById('typeBL').value = "";
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function listerUnconfirmedExpedition() {
	try {

		var sourceType = document.getElementById('origineBL').value;
		var typeLiv = document.getElementById('typeBL').value;
		var nbLignesParPage = document.getElementById('nbLignesParPage').value;

		pageCourante = 1;
		nbPages = 1;
		document.getElementById('pageDeb').value = 1;
		document.getElementById('pageFin').value = 1;
		document.getElementById('bPrec').disabled = true;
		document.getElementById('bSuiv').disabled = true;

		document.getElementById('list-BL').disabled = true;
		aUnconfirmedExpedition.deleteTree();

		qListUE.setParam("Source_Type", sourceType);
		qListUE.setParam("Type_Liv", typeLiv);
		qListUE.setParam("Nb_Lignes_Par_Page", nbLignesParPage);
		qListUE.setParam("Current_Page", pageCourante);

		var result = qListUE.execute();

		var contenu = result.responseXML.documentElement;

		nbPages = contenu.getAttribute("Nb_Pages");
		var listBonId = contenu.getAttribute("List_Bon_Id");

		aUnconfirmedExpedition.setParam("List_Bon_Id", listBonId);
		aUnconfirmedExpedition.initTree(initPagination);

	} catch (e) {
		recup_erreur(e);
	}
}


function initPagination() {
	try {

		document.getElementById('pageDeb').value = pageCourante;
		document.getElementById('pageFin').value = (nbPages>0?nbPages:1);
		document.getElementById('bPrec').disabled = (pageCourante==1);
		document.getElementById('bSuiv').disabled = (pageCourante>=nbPages); // peut se produire si nbPages=0

		afterMajPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function pressOnPagePrec() {
	try {

		pageCourante--;
		majPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function pressOnPageSuiv() {
	try {

		pageCourante++;
		majPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function majPagination() {
	try {

		document.getElementById('pageDeb').value = pageCourante;
		document.getElementById('bPrec').disabled = (pageCourante==1);
		document.getElementById('bSuiv').disabled = (pageCourante==nbPages);

		document.getElementById('list-BL').disabled = true;

		qListUE.setParam("Current_Page", pageCourante);
		var result = qListUE.execute();
		var listBonId = result.responseXML.documentElement.getAttribute("List_Bon_Id");

		aUnconfirmedExpedition.setParam("List_Bon_Id", listBonId);
		aUnconfirmedExpedition.initTree(afterMajPagination);

	} catch (e) {
		recup_erreur(e);
	}
}


function afterMajPagination() {
	try {

		document.getElementById('list-BL').disabled = false;

	} catch (e) {
		recup_erreur(e);
	}
}


function reporterNumNl() {
	try {

		if (aUnconfirmedExpedition.isSelected()) {
			document.getElementById("numeroBL").value = aUnconfirmedExpedition.getSelectedCellText('colNumBl');
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function retourMenuPrincipal() {
  try {

    window.location = "chrome://opensi/content/facturation/user/menu_principal.xul";

  } catch (e) {
    recup_erreur(e);
  }
}


function otmt_resetErreurTransporteur() {
	try {

		otmt_currentErreurId = "";

		document.getElementById('otmt-numExpedition').value = "";
		document.getElementById('otmt-codeErreur').value = "";
		document.getElementById('otmt-typeErreur').value = "";
		document.getElementById('otmt-description').value = "";

		document.getElementById('otmt-pointRetrait').value = "";
		document.getElementById('otmt-denominationLiv').value = "";
		document.getElementById('otmt-adresse1Liv').value = "";
		document.getElementById('otmt-adresse2Liv').value = "";
		document.getElementById('otmt-adresse3Liv').value = "";
		document.getElementById('otmt-codePostalLiv').value = "";
		document.getElementById('otmt-villeLiv').value = "";
		document.getElementById('otmt-codePaysLiv').value = "FR";
		document.getElementById('otmt-civInterLiv').value = 0;
		document.getElementById('otmt-nomInterLiv').value = "";
		document.getElementById('otmt-prenomInterLiv').value = "";
		document.getElementById('otmt-telInterLiv').value = "";
		document.getElementById('otmt-emailInterLiv').value = "";

		document.getElementById("bTraiterErreur").disabled = true;
		otmt_aErreurs.initTree();

		document.getElementById('otmt-pointRetrait').disabled = true;
		document.getElementById('otmt-denominationLiv').disabled = true;
		document.getElementById('otmt-adresse1Liv').disabled = true;
		document.getElementById('otmt-adresse2Liv').disabled = true;
		document.getElementById('otmt-adresse3Liv').disabled = true;
		document.getElementById('otmt-codePostalLiv').disabled = true;
		document.getElementById('otmt-villeLiv').disabled = true;
		document.getElementById('otmt-codePaysLiv').disabled = true;
		document.getElementById('otmt-civInterLiv').disabled = true;
		document.getElementById('otmt-nomInterLiv').disabled = true;
		document.getElementById('otmt-prenomInterLiv').disabled = true;
		document.getElementById('otmt-telInterLiv').disabled = true;
		document.getElementById('otmt-emailInterLiv').disabled = true;

		otmt_aColis.deleteTree();
		document.getElementById('otmt-poids').disabled = true;
		document.getElementById('otmt-volume').disabled = true;
		document.getElementById("otmt-nouveauColis").disabled = true;
		document.getElementById("otmt-validerColis").disabled = true;
		document.getElementById("otmt-supprimerColis").disabled = true;

	} catch (e) {
    recup_erreur(e);
  }
}


function otmt_pressOnErreurTransporteur() {
	try {

		if (otmt_aErreurs.isSelected()) {
			otmt_currentErreurId = otmt_aErreurs.getSelectedCellText("colErreurIdET");
			otmt_chargerErreurTransporteur();
		}

  } catch (e) {
    recup_erreur(e);
  }
}


function otmt_chargerErreurTransporteur() {
	try {

		if (!isEmpty(otmt_currentErreurId)) {
			var qLoad = new QueryHttp("Facturation/Expedition/loadErreurTransporteur.tmpl");
			qLoad.setParam("Erreur_Id", otmt_currentErreurId);
			var result = qLoad.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				var contenu = result.responseXML.documentElement;

				document.getElementById('otmt-numExpedition').value = contenu.getAttribute('Num_Expedition');
				document.getElementById('otmt-codeErreur').value = contenu.getAttribute('Code_Erreur');
				document.getElementById('otmt-typeErreur').value = contenu.getAttribute('Type_Erreur');
				document.getElementById('otmt-description').value = contenu.getAttribute('Description');

				document.getElementById('otmt-pointRetrait').value = contenu.getAttribute('Point_Retrait');
				document.getElementById('otmt-denominationLiv').value = contenu.getAttribute('Denomination_Liv');
				document.getElementById('otmt-adresse1Liv').value = contenu.getAttribute('Adresse_1_Liv');
				document.getElementById('otmt-adresse2Liv').value = contenu.getAttribute('Adresse_2_Liv');
				document.getElementById('otmt-adresse3Liv').value = contenu.getAttribute('Adresse_3_Liv');
				document.getElementById('otmt-codePostalLiv').value = contenu.getAttribute('Code_Postal_Liv');
				document.getElementById('otmt-villeLiv').value = contenu.getAttribute('Ville_Liv');
				document.getElementById('otmt-codePaysLiv').value = contenu.getAttribute('Code_Pays_Liv');
				document.getElementById('otmt-civInterLiv').value = contenu.getAttribute("Civ_Inter_Liv");
				document.getElementById('otmt-nomInterLiv').value = contenu.getAttribute("Nom_Inter_Liv");
				document.getElementById('otmt-prenomInterLiv').value = contenu.getAttribute("Prenom_Inter_Liv");
				document.getElementById('otmt-telInterLiv').value = contenu.getAttribute("Tel_Inter_1_Liv");
				document.getElementById('otmt-emailInterLiv').value = contenu.getAttribute("Email_Inter_Liv");

				document.getElementById('otmt-pointRetrait').disabled = false;
				document.getElementById('otmt-denominationLiv').disabled = false;
				document.getElementById('otmt-adresse1Liv').disabled = false;
				document.getElementById('otmt-adresse2Liv').disabled = false;
				document.getElementById('otmt-adresse3Liv').disabled = false;
				document.getElementById('otmt-codePostalLiv').disabled = false;
				document.getElementById('otmt-villeLiv').disabled = false;
				document.getElementById('otmt-codePaysLiv').disabled = false;
				document.getElementById('otmt-civInterLiv').disabled = false;
				document.getElementById('otmt-nomInterLiv').disabled = false;
				document.getElementById('otmt-prenomInterLiv').disabled = false;
				document.getElementById('otmt-telInterLiv').disabled = false;
				document.getElementById('otmt-emailInterLiv').disabled = false;

				document.getElementById("bTraiterErreur").disabled = false;

				otmt_listerColis();
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function otmt_traiterErreurTransporteur() {
	try {

		if (!isEmpty(otmt_currentErreurId)) {

			var pointRetrait = document.getElementById('otmt-pointRetrait').value;
			var denominationLiv = document.getElementById('otmt-denominationLiv').value;
			var adresse1Liv = document.getElementById('otmt-adresse1Liv').value;
			var adresse2Liv = document.getElementById('otmt-adresse2Liv').value;
			var adresse3Liv = document.getElementById('otmt-adresse3Liv').value;
			var codePostalLiv = document.getElementById('otmt-codePostalLiv').value;
			var villeLiv = document.getElementById('otmt-villeLiv').value;
			var codePaysLiv = document.getElementById('otmt-codePaysLiv').value;
			var civInterLiv = document.getElementById('otmt-civInterLiv').value;
			var nomInterLiv = document.getElementById('otmt-nomInterLiv').value;
			var prenomInterLiv = document.getElementById('otmt-prenomInterLiv').value;
			var telInterLiv = document.getElementById('otmt-telInterLiv').value;
			var emailInterLiv = document.getElementById('otmt-emailInterLiv').value;

			if (isEmpty(denominationLiv)) { showWarning("D\u00E9nomination de livraison manquante"); }
			else if (isEmpty(adresse1Liv)) { showWarning("Ligne d'adresse 1 manquante"); }
			else if (isEmpty(villeLiv)) { showWarning("Ville manquante"); }
			else if (!isEmpty(telInterLiv) && !isPhone(telInterLiv)) { showWarning("Num\u00E9ro de t\u00E9l\u00E9phone de livraison incorrect !"); }
			else if (!isEmpty(emailInterLiv) && !isEmail(emailInterLiv)) { showWarning("Adresse e-mail de livraison incorrecte !"); }
			else {

				var qRetry = new QueryHttp("Facturation/Expedition/retrySendExpedition.tmpl");

				qRetry.setParam("Erreur_Id", otmt_currentErreurId);
				qRetry.setParam("Point_Retrait", pointRetrait);
				qRetry.setParam("Denomination_Liv",denominationLiv);
				qRetry.setParam("Adresse_1_Liv",adresse1Liv);
				qRetry.setParam("Adresse_2_Liv",adresse2Liv);
				qRetry.setParam("Adresse_3_Liv",adresse3Liv);
				qRetry.setParam("Code_Postal_Liv",codePostalLiv);
				qRetry.setParam("Ville_Liv",villeLiv);
				qRetry.setParam("Code_Pays_Liv",codePaysLiv);
				qRetry.setParam("Civ_Inter_Liv",civInterLiv);
				qRetry.setParam("Nom_Inter_Liv",nomInterLiv);
				qRetry.setParam("Prenom_Inter_Liv",prenomInterLiv);
				qRetry.setParam("Tel_Inter_1_Liv",telInterLiv);
				qRetry.setParam("Email_Inter_Liv",emailInterLiv);

				var result = qRetry.execute();

				var errors = new Errors(result);
				if (errors.hasNext()) {
					errors.show();
				}
				else {
					otmt_resetErreurTransporteur();
				}
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function otmt_initPaysLiv() {
	try {

		document.getElementById('otmt-codePaysLiv').value = "FR";
		otmt_resetErreurTransporteur();

	} catch (e) {
    recup_erreur(e);
  }
}


function otmt_selectOnListeColis() {
	try {

		if (otmt_aColis.isSelected()) {
			otmt_currentColisId = otmt_aColis.getSelectedCellText("otmt-colColisId");
			document.getElementById('otmt-numInterne').value = otmt_aColis.getSelectedCellText("otmt-colNumInterne");
			document.getElementById('otmt-poids').value = otmt_aColis.getSelectedCellText("otmt-colPoids");
			document.getElementById('otmt-volume').value = otmt_aColis.getSelectedCellText("otmt-colVolume");
			document.getElementById('otmt-poids').disabled = false;
			document.getElementById('otmt-volume').disabled = false;
			document.getElementById("otmt-nouveauColis").disabled = false;
			document.getElementById("otmt-validerColis").disabled = false;
			document.getElementById("otmt-supprimerColis").disabled = false;
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function otmt_pressOnPoids(ev) {
	try {

		if (ev.keyCode==13) {
			otmt_validerColis();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function otmt_pressOnVolume(ev) {
	try {

		if (ev.keyCode==13) {
			otmt_validerColis();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function otmt_listerColis() {
	try {

		otmt_aColis.setParam("Erreur_Id", otmt_currentErreurId);
		otmt_aColis.initTree();

		otmt_nouveauColis();

	} catch (e) {
    recup_erreur(e);
  }
}


function otmt_validerColis() {
	try {

		var poids = document.getElementById('otmt-poids').value;
		var volume = document.getElementById('otmt-volume').value;

		if (isEmpty(volume)) {
			volume = 0;
		}

		if (!isPositiveOrNull(poids) || !checkNumber(poids,10,3)) {
			showWarning("Poids du colis incorrect");
		}
		else if (!isPositiveOrNull(volume) || !checkNumber(volume,9,3)) {
			showWarning("Volume du colis incorrect");
		}
		else {
			if (!isEmpty(otmt_currentColisId)) {
				if (otmt_aColis.getSelectedCellText("otmt-colStatut")!="N") {
					showWarning("Impossible de modifier un colis d\u00E9j\u00E0 num\u00E9rot\u00E9");
				}
				else {
					qModColis.setParam("Colis_Id", otmt_currentColisId);
					qModColis.setParam("Poids", poids);
					qModColis.setParam("Volume", volume);
					var result = qModColis.execute();

					var errors = new Errors(result);
					if (errors.hasNext()) {
						errors.show();
					}
				}
			}
			else {
				var qCreate = new QueryHttp("Facturation/Expedition/createColisErreurTransporteur.tmpl");
				qCreate.setParam("Erreur_Id", otmt_currentErreurId);
				qCreate.setParam("Poids", poids);
				qCreate.setParam("Volume", volume);
				var result = qCreate.execute();

				var errors = new Errors(result);
				if (errors.hasNext()) {
					errors.show();
				}
			}

			otmt_aColis.initTree();
			otmt_nouveauColis();
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function otmt_supprimerColis() {
	try {

		if (otmt_aColis.nbLignes()==1) {
			showWarning("Vous ne pouvez pas supprimer le dernier colis");
		}
		else {
			qSuppColis.setParam("Colis_Id", otmt_currentColisId);
			var result = qSuppColis.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}

			otmt_aColis.initTree();
			otmt_nouveauColis();
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function otmt_nouveauColis() {
	try {

		otmt_currentColisId = "";
		document.getElementById('otmt-numInterne').value = "";
		document.getElementById('otmt-poids').value = "";
		document.getElementById('otmt-volume').value = "";
		document.getElementById('otmt-poids').disabled = false;
		document.getElementById('otmt-volume').disabled = false;
		document.getElementById("otmt-nouveauColis").disabled = false;
		document.getElementById("otmt-validerColis").disabled = false;
		document.getElementById("otmt-supprimerColis").disabled = true;

	} catch (e) {
    recup_erreur(e);
  }
}
