/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

jsLoader.loadSubScript("chrome://opensi/content/libs/arbres.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/verif.js");


var aListeTransferts = new Arbre("Facturation/ExpeditionsTS/list-transfertsExpediables.tmpl", "liste_transferts");
var aModeExpedition = new Arbre("ComboListe/combo-modesExpedition.tmpl","modeExpedition");
var aModifierModeExpedition = new Arbre("ComboListe/combo-modesExpedition.tmpl","modifierModeExpedition");

var aApercuTransfert = new Arbre("Facturation/Transferts_Stocks/list-apercuTransfertStock.tmpl","apercuTransfert");
var aEtablissements = new Arbre('ComboListe/combo-etablissements.tmpl', 'etablissement');
var aDepots = new Arbre('ComboListe/combo-depotsStock.tmpl', 'depot');
var aTransporteurs = new Arbre("ComboListe/combo-transporteurs.tmpl", "transporteur");
var aFormatsExport = new Arbre("ComboListe/combo-formatsTransporteur.tmpl", "Export_Id");
var aTranchesVolume = new Arbre("ComboListe/combo-tranchesVolumeConfigExpedition.tmpl", "trancheId");

var etablissementDefaut;
var depotDefaut;
var lastExpeditionId;
var defautEtapePrepaBLTS;
var defautEtapePickingBLTS;
var etapePrepaBL;
var etapePickingBL;
var bacs;
var confirmation;
var specCET;
var defautEditBP;
var defautEditBL;
var defautEditPK;
var defautEditRE;
var defautExpediable;
var defautEditEtiq;
var defautNbBacMulti;
var defautNbBacMono;
var defautTypeConfig;
var defautEXLConfig;
var nbBacMulti;
var nbBacMono;



function init() {
	try {

		window.parent.addEventListener("close", onCloseWindow, false);

		bloquer(true);

		var config = getConfig();

		defautEtapePrepaBLTS = config.isEtapePrepaBLTS();
		defautEtapePickingBLTS = config.isEtapePickingBLTS();
		defautExpediable = config.getEXTExpediable();
		bacs = config.isEXLBacPrepa();
		confirmation = config.isEXLConfirmation();
		specCET = config.isSpecPCCET();

		var exlConfig = config.getEXLConfig();
		defautEXLConfig = exlConfig;

		var qConfExp = new QueryHttp("Config/gc/expeditions/loadConfigExpedition.tmpl");
		qConfExp.setParam('Config_Id', exlConfig);
		var result = qConfExp.execute();

		defautEditBP = result.responseXML.documentElement.getAttribute("Edit_BP")=="true";
		defautEditBL = result.responseXML.documentElement.getAttribute("Edit_BL")=="true";
		defautEditEtiq = result.responseXML.documentElement.getAttribute("Edit_Etiq")=="true";
		defautEditPK = result.responseXML.documentElement.getAttribute("Edit_PK")=="true";
		defautEditRE = result.responseXML.documentElement.getAttribute("Edit_RE")=="true";
		defautNbBacMulti = result.responseXML.documentElement.getAttribute("Nb_Bac_Multi");
		defautNbBacMono = result.responseXML.documentElement.getAttribute("Nb_Bac_Mono");
		defautTypeConfig = result.responseXML.documentElement.getAttribute("Type_Config");

		document.getElementById('bRetourExpeditions').collapsed = true;
		document.getElementById('deck').selectedIndex = 0;

		etablissementDefaut = getProfil().getEtabId();

		var qDepotDefaut = new QueryHttp("Facturation/Commun/getDepotDefautEts.tmpl");
		qDepotDefaut.setParam("Etablissement_Id", etablissementDefaut);
		result = qDepotDefaut.execute();
		depotDefaut = result.responseXML.documentElement.getAttribute('Depot_Defaut');

		aDepots.setParam("Depot_Vente", false);
		aDepots.setParam("Depot_Quarantaine", false);

		aEtablissements.initTree(initEtablissement);

		aFormatsExport.setParam("Type_Format", "E");
		aFormatsExport.initTree();

	} catch (e) {
		recup_erreur(e);
	}
}


function initEtablissement() {
	try {

		document.getElementById('etablissement').value = etablissementDefaut;
		aModeExpedition.initTree(initModesExpedition);

	} catch (e) {
		recup_erreur(e);
	}
}


function initModesExpedition() {
	try {

		document.getElementById('modeExpedition').selectedIndex = 0;
		aModifierModeExpedition.initTree(initModifierModesExpedition);

	} catch (e) {
		recup_erreur(e);
	}
}

function initModifierModesExpedition() {
	try {

		document.getElementById('modifierModeExpedition').selectedIndex = 0;
		aTransporteurs.initTree(initTransporteur);

	} catch (e) {
		recup_erreur(e);
	}
}

function initTransporteur() {
	try {

		document.getElementById('transporteur').selectedIndex = 0;
		initFiltres();

	} catch (e) {
		recup_erreur(e);
	}
}


function onKeyPress(event) {
	try {

		if (event.keyCode==13) {
			listerTransferts();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function initIHM() {
	try {

		aDepots.setParam("Depot_Expedition", true);
		aDepots.setParam("Depot_Logistique", false);
		aDepots.initTree(initDepot);

		document.getElementById('rowBacs').collapsed = !bacs;

	} catch (e) {
		recup_erreur(e);
	}
}


function initDepot() {
	try {

		if (document.getElementById('etablissement').value == etablissementDefaut) {
			document.getElementById('depot').value = depotDefaut;
		}
		else {
			document.getElementById('depot').selectedIndex = (document.getElementById('depot').itemCount==2?1:0);
		}

		affecterConfDepot();
		listerTransferts();

	} catch (e) {
		recup_erreur(e);
	}
}


function initFiltres() {
	try {

		document.getElementById('etablissement').value = etablissementDefaut;
		document.getElementById('modeExpedition').selectedIndex = 0;
		document.getElementById('transporteur').selectedIndex = 0;
		document.getElementById("dispoStock").value = defautExpediable;
		document.getElementById('dateDebut').value = "";
		document.getElementById('dateFin').value = "";
		document.getElementById('dateExpDebut').value = "";
		document.getElementById('dateExpFin').value = "";
		document.getElementById('typeTransfert').value = "";

		initIHM();

	} catch (e) {
		recup_erreur(e);
	}
}


function listerTransferts() {
	try {

		bloquer(true);

		var modeExpedition = document.getElementById("modeExpedition").value;
		var transporteur = document.getElementById("transporteur").value;
		var dispoStock = document.getElementById("dispoStock").value;
		var dateDebut = document.getElementById('dateDebut').value;
		var dateFin = document.getElementById('dateFin').value;
		var dateExpDebut = document.getElementById('dateExpDebut').value;
		var dateExpFin = document.getElementById('dateExpFin').value;
		var depot = document.getElementById('depot').value;
		var etablissement = document.getElementById('etablissement').value;
		var trancheId = document.getElementById('trancheId').value;
		var typeTransfert = document.getElementById('typeTransfert').value;

		if (!isEmpty(dateDebut) && !isDate(dateDebut)) { showWarning("Date transfert de d\u00E9but incorrecte"); }
		else if (!isEmpty(dateFin) && !isDate(dateFin)) { showWarning("Date transfert de fin incorrecte"); }
		else if (!isEmpty(dateDebut) && !isEmpty(dateFin) && !isDateInterval(dateDebut, dateFin)) { showWarning("Plage de dates de transfert incorrecte"); }
		else if (!isEmpty(dateExpDebut) && !isDate(dateExpDebut)) { showWarning("Date exp\u00E9dition de d\u00E9but incorrecte"); }
		else if (!isEmpty(dateExpFin) && !isDate(dateExpFin)) { showWarning("Date exp\u00E9dition de fin incorrecte"); }
		else if (!isEmpty(dateExpDebut) && !isEmpty(dateExpFin) && !isDateInterval(dateExpDebut, dateExpFin)) { showWarning("Plage de dates d'exp\u00E9dition incorrecte"); }
		else if (isEmpty(depot)) { showWarning("Veuillez s\u00E9lectionner un d\u00E9pot de stock"); }
		else {

			aApercuTransfert.deleteTree();
			document.getElementById('numTransfertSelect').value = "";

			aListeTransferts.setParam("Mode_Expedition", modeExpedition);
			aListeTransferts.setParam("Transporteur", transporteur);
			aListeTransferts.setParam("Dispo_Stock", dispoStock);
			aListeTransferts.setParam("Date_Debut", dateDebut);
			aListeTransferts.setParam("Date_Fin", dateFin);
			aListeTransferts.setParam("Date_Exp_Debut", dateExpDebut);
			aListeTransferts.setParam("Date_Exp_Fin", dateExpFin);
			aListeTransferts.setParam("Depot_Id", depot);
			aListeTransferts.setParam("Etab_Id", etablissement);
			aListeTransferts.setParam("Tranche_Id", trancheId);
			aListeTransferts.setParam("Type_Transfert", typeTransfert);
			aListeTransferts.initTree(debloquerListe);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function debloquerListe() {
	try {

		compterLignesCochees();
		bloquer(false);

	} catch (e) {
		recup_erreur(e);
	}
}


function compterLignesCochees() {
	try {

		var nbCoches = 0;

		for (var i=0; i<aListeTransferts.nbLignes(); i++) {
			if (aListeTransferts.getCellValue(i, "colSelect")=="true") {
				nbCoches++;
			}
  	}

		document.getElementById('lblNbLignesCochees').value = nbCoches;

	} catch (e) {
		recup_erreur(e);
	}
}


function editionCommentairesNonImprimablesTS() {
	try {

		if (aListeTransferts.isSelected()) {
			var transfertId = aListeTransferts.getCellText(aListeTransferts.getCurrentIndex(), "colTransfert_Id");
			var url = "chrome://opensi/content/facturation/user/expedition_transfert/popup-editionCommentairesNonImprimablesTS.xul";
			window.openDialog(url,'','chrome,modal,centerscreen', transfertId, listerTransferts);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function selectOnListeTransferts() {
	try {

		if (aListeTransferts.isSelected()) {
			var transfertId = aListeTransferts.getCellText(aListeTransferts.getCurrentIndex(), "colTransfert_Id");
			var numTransfert = aListeTransferts.getCellText(aListeTransferts.getCurrentIndex(), "colNum_Transfert");

			document.getElementById('numTransfertSelect').value = "Aper\u00E7u du transfert N\u00B0 "+ numTransfert +" :";
			listerApercuTransfert(transfertId);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function pressOnListeTransferts(ev) {
	try {

		if (ev.keyCode==32 && aListeTransferts.isSelected()) {
			aListeTransferts.setSelectedCellValue("colSelect", aListeTransferts.getSelectedCellValue("colSelect")=="false");
			compterLignesCochees();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function listerApercuTransfert(id) {
	try {

		aApercuTransfert.setParam("Transfert_Id", id);
		aApercuTransfert.initTree();

	} catch (e) {
		recup_erreur(e);
	}
}


function toutCocherBL(b) {
	try {

		bloquer(true);

		for (var i=0; i<aListeTransferts.nbLignes(); i++) {
			if (aListeTransferts.isEditable(i, "colSelect")) {
				aListeTransferts.setCellValue(i, "colSelect", b);
  		}
		}

		compterLignesCochees();
		bloquer(false);

	} catch (e) {
		recup_erreur(e);
	}
}


function affecterConfDepot() {
	try {

		var editBP = defautEditBP;
		var editBL = defautEditBL;
		var editPK = defautEditPK;
		var editRE = defautEditRE;
		var editEtiq = defautEditEtiq;
		nbBacMulti = defautNbBacMulti;
		nbBacMono = defautNbBacMono;
		var typeConfig = defautTypeConfig;
		var exlConfig = defautEXLConfig;
		etapePrepaBL = defautEtapePrepaBLTS;
		etapePickingBL = defautEtapePickingBLTS;

		var depotId = document.getElementById('depot').value;
		if (!isEmpty(depotId)) {
			var qDepot = new QueryHttp("Facturation/Commun/getDepotStock.tmpl");
			qDepot.setParam("Depot_Id", depotId);
			var result = qDepot.execute();

			var etapePrepaDepotBL = result.responseXML.documentElement.getAttribute("Etape_Prepa_BL_TS");
			if (!isEmpty(etapePrepaDepotBL)) {
				etapePrepaBL = (etapePrepaDepotBL=="true");
			}

			var etapePickingDepotBL = result.responseXML.documentElement.getAttribute("Etape_Picking_BL_TS");
			if (!isEmpty(etapePickingDepotBL)) {
				etapePickingBL = (etapePickingDepotBL=="true");
			}

			var exlConfigDepot = result.responseXML.documentElement.getAttribute("EXL_Config");

			if (specCET) {
				var transporteurId = document.getElementById('transporteur').value;
				if (!isEmpty(transporteurId)) {
					var qTrans = new QueryHttp("Facturation/Fournisseurs/getEXLConfig.tmpl");
					qTrans.setParam("Fournisseur_Id", transporteurId);
					result = qTrans.execute();
					var exlConfigTrans = result.responseXML.documentElement.getAttribute("EXL_Config");
					if (!isEmpty(exlConfigTrans)) {
						exlConfigDepot = exlConfigTrans;
					}
				}
			}

			if (!isEmpty(exlConfigDepot)) {
				var qConfExp = new QueryHttp("Config/gc/expeditions/loadConfigExpedition.tmpl");
				qConfExp.setParam('Config_Id', exlConfigDepot);
				var result = qConfExp.execute();

				editBP = result.responseXML.documentElement.getAttribute("Edit_BP")=="true";
				editBL = result.responseXML.documentElement.getAttribute("Edit_BL")=="true";
				editEtiq = result.responseXML.documentElement.getAttribute("Edit_Etiq")=="true";
				editPK = result.responseXML.documentElement.getAttribute("Edit_PK")=="true";
				editRE = result.responseXML.documentElement.getAttribute("Edit_RE")=="true";
				nbBacMulti = result.responseXML.documentElement.getAttribute("Nb_Bac_Multi");
				nbBacMono = result.responseXML.documentElement.getAttribute("Nb_Bac_Mono");
				typeConfig = result.responseXML.documentElement.getAttribute("Type_Config");
				exlConfig = exlConfigDepot;
			}
		}

		document.getElementById('chkBP').checked = ((!etapePickingBL && etapePrepaBL) || editBP);
		document.getElementById('chkBL').checked = (!etapePickingBL && !etapePrepaBL && editBL);
		document.getElementById('chkBP').collapsed = etapePrepaBL;
		document.getElementById('chkBL').collapsed = etapePrepaBL;
		document.getElementById('chkPK').checked = editPK;
		document.getElementById('chkRE').checked = editRE;
		document.getElementById('chkEtiquetteExpedition').checked = editEtiq;

		if (!etapePrepaBL && !document.getElementById('chkBP').checked && !document.getElementById('chkBL').checked) {
			document.getElementById('chkBL').checked = true;
		}

		affecterNbBacs();

		if (bacs && typeConfig=="V") {
			document.getElementById('trancheId').value = "";
			document.getElementById('lblVolumeTransfert').collapsed = false;
			document.getElementById('trancheId').collapsed = false;
			aTranchesVolume.setParam("Config_Id", exlConfig);
			aTranchesVolume.initTree();
		}
		else {
			document.getElementById('lblVolumeTransfert').collapsed = true;
			document.getElementById('trancheId').collapsed = true;
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function affecterNbBacs() {
	try {

		if (bacs && isEmpty(document.getElementById('trancheId').value)) {
			if (!isEmpty(document.getElementById('typeTransfert').value)) {
				document.getElementById('nbBacs').value = nbBacMono;
			}
			else {
				document.getElementById('nbBacs').value = nbBacMulti;
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function selectTrancheVolume() {
	try {

		var trancheId = document.getElementById('trancheId').value;

		if (isEmpty(trancheId)) {
			affecterNbBacs();
		}
		else {
			var qTranche = new QueryHttp("Config/gc/expeditions/loadTrancheVolumeConfigExpedition.tmpl");
			qTranche.setParam('Tranche_Id', trancheId);
			var result = qTranche.execute();

			document.getElementById('nbBacs').value = result.responseXML.documentElement.getAttribute("Nb_Bac");
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function affecterConfTrans() {
	try {
		if (specCET) {
			affecterConfDepot();
		}
	} catch (e) {
		recup_erreur(e);
	}
}


function valider() {
	try {

		bloquer(true);

		if (!confirmation || window.confirm("Confirmez-vous la validation des exp\u00E9ditions ?")) {

			var nbBacs = document.getElementById('nbBacs').value;
			var listeTS = "";

			for (var i=0; i<aListeTransferts.nbLignes(); i++) {
				if (aListeTransferts.getCellValue(i, "colSelect")=="true") {
					listeTS += aListeTransferts.getCellText(i, "colTransfert_Id") +",";
				}
  		}

			if (!document.getElementById('chkBL').checked && !document.getElementById('chkBP').checked && !etapePickingBL) {
				showWarning("Veuillez cocher au moins une des deux cases 'Editer les bons de pr\u00E9paration' ou 'Editer les bons de livraison'");
			}
			else if (!document.getElementById('chkPK').checked && !document.getElementById('chkRE').checked && etapePickingBL) {
				showWarning("Veuillez cocher au moins une des deux cases 'Editer un bon de picking' ou 'Editer les r\u00E9capitulatifs d\'exp\u00E9dition'");
			}
			else if (isEmpty(listeTS)) {
				showWarning("Veuillez cocher au moins un transfert de stock");
			}
			else if (bacs && !isPositiveInteger(nbBacs)) {
				showWarning("Nombre de bacs incorrect");
			}
			else {
				document.getElementById('deck').selectedIndex = 1;
				document.getElementById('pmbox').collapsed = false;
				document.getElementById('pm').setAttribute('mode', 'undetermined');
				document.getElementById('boxExpTrans').collapsed = true;

				var qGenExp = new QueryHttp("Facturation/ExpeditionsTS/generateExpedition.tmpl");

				qGenExp.setParam('Liste_TS', listeTS);
				qGenExp.setParam('Edit_BP', document.getElementById('chkBP').checked);
				qGenExp.setParam('Edit_BL', document.getElementById('chkBL').checked);
				qGenExp.setParam('Edit_RE', document.getElementById('chkRE').checked);
				qGenExp.setParam('Edit_PK', document.getElementById('chkPK').checked);
				qGenExp.setParam('Edit_EC', document.getElementById('chkEtiquetteExpedition').checked);
				qGenExp.setParam('Depot_Id', document.getElementById('depot').value);
				qGenExp.setParam('Nb_Bacs', nbBacs);

				var result = qGenExp.execute();
				var errors = new Errors(result);

				if (errors.hasNext()) {
					errors.show();
					retour_expedition(true);
				}
				else {
					lastExpeditionId = result.responseXML.documentElement.getAttribute('Expedition_Id');

					var qGenPdf = new QueryHttp("Facturation/ExpeditionsTS/pdfExpedition.tmpl");
					qGenPdf.setParam('Expedition_Id', lastExpeditionId);

					var result2 = qGenPdf.execute();
					var page = getDirPdf() + result2.responseXML.documentElement.getAttribute('FichierPDF');

					document.getElementById('bExpedition').collapsed = false;
					document.getElementById('expedition').setAttribute("src", page);

					if (document.getElementById('chkEtiquetteExpedition').checked) {
						var qEtiquettes = new QueryHttp("Facturation/Affaires/pdfEtiquettes.tmpl");
						qEtiquettes.setParam("Expedition_Id", lastExpeditionId);
						var res = qEtiquettes.execute();
						var page = getDirPdf() + res.responseXML.documentElement.getAttribute('fichier');
						document.getElementById('bEtiquettes').collapsed = false;
						document.getElementById('etiquettes').setAttribute("src", page);
					}

					document.getElementById('bRetourExpeditions').collapsed = false;
				}

				document.getElementById('pm').setAttribute('mode', 'none');
				document.getElementById('pmbox').collapsed = true;
				document.getElementById('Export_Id').value = "";
				document.getElementById('boxExpTrans').collapsed = etapePrepaBL;
			}
		}

		bloquer(false);

	} catch (e) {
		recup_erreur(e);
	}
}


function validerModificationME() {
	try {

		bloquer(true);

		var modeExpedition = document.getElementById('modifierModeExpedition').value;
		var listeTS = "";

		for (var i=0; i<aListeTransferts.nbLignes(); i++) {
			if (aListeTransferts.getCellValue(i, "colSelect")=="true") {
				listeTS += aListeTransferts.getCellText(i, "colTransfert_Id") +",";
			}
  	}

		if (isEmpty(listeTS)) {
			showWarning("Veuillez cocher au moins un transfert de stock");
		}
		else if (isEmpty(modeExpedition)) {
			showWarning("Veuillez s\u00E9lectionner un mode d'exp\u00E9dition");
		}
		else if (window.confirm("Confirmez-vous la modification du mode d'exp\u00E9dition pour tous les transferts s\u00E9lectionn\u00E9s ?")) {

			var qGenModificationME = new QueryHttp("Facturation/ExpeditionsTS/modifierModeExpedition.tmpl");
			qGenModificationME.setParam('Mode_Expedition', modeExpedition);
			qGenModificationME.setParam('Liste_TS', listeTS);
			var result = qGenModificationME.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}

			aListeTransferts.initTree(debloquerListe);
		}

		bloquer(false);

	} catch (e) {
		recup_erreur(e);
	}
}


function bloquer(bloque) {
	try {

		document.getElementById("bValider").disabled = bloque;

	} catch (e) {
		recup_erreur(e);
	}
}


function retour_expedition(nocheck) {
  try {

		if (nocheck || checkPrinting()) {
			document.getElementById('etiquettes').setAttribute("src", "");
			document.getElementById('expedition').setAttribute("src", "");
			listerTransferts();
			document.getElementById('bRetourExpeditions').collapsed = true;
			document.getElementById('bExpedition').collapsed = true;
			document.getElementById('bEtiquettes').collapsed = true;
			document.getElementById('deck').selectedIndex = 0;
		}

  } catch (e) {
    recup_erreur(e);
  }
}


function retourMenuPrincipal() {
  try {

		if (checkPrinting()) {
    	window.location = "chrome://opensi/content/facturation/user/menu_principal.xul";
			window.parent.removeEventListener("close", onCloseWindow, false);
		}

  } catch (e) {
    recup_erreur(e);
  }
}


function checkPrinting() {
  try {

		return document.getElementById('deck').selectedIndex!=1 || window.confirm("Avant de quitter ce listing, assurez-vous de l'avoir imprim\u00E9. Voulez-vous continuer ?");

	} catch (e) {
    recup_erreur(e);
		return true;
  }
}


function onCloseWindow(evt) {
  try {

		if (!checkPrinting()) {
			evt.preventDefault();
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function quitWithCheck() {
  try {

		if (checkPrinting()) {
			window.parent.removeEventListener("close", onCloseWindow, false);
			quit();
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function ouvrirLegende() {
  try {

		window.openDialog("chrome://opensi/content/facturation/user/expedition_transfert/popup-legende.xul",'','chrome,modal,centerscreen');

	} catch (e) {
    recup_erreur(e);
  }
}


function exportTransporteur() {
	try {

		var exportId = document.getElementById('Export_Id').value;

		if (isEmpty(exportId)) {
			showWarning("Veuillez s\u00E9lectionner un format d'export transporteur");
		}
		else {
			document.getElementById('bExporter').disabled = true;

			var qGenExport = new QueryHttp("Facturation/Expedition_Lot/genExportTransporteur.tmpl");
			qGenExport.setParam('Export_Id', exportId);
			qGenExport.setParam('Expedition_Id', lastExpeditionId);
			var result = qGenExport.execute();

			var contenu = result.responseXML.documentElement;
			var fichier_export = contenu.getAttribute('FileName');
			var nom_sugg = contenu.getAttribute('SuggestedName');

			document.getElementById('bExporter').disabled = false;

			var file = fileChooser("save", nom_sugg);
			if (file!=null) {
				downloadFile(getDirBuffer() + fichier_export, file);
			}
		}

	} catch (e) {
	  recup_erreur(e);
	}
}
