/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/


var oea_aLignes = new Arbre('Facturation/Avoirs/list-ligneAvoirClient.tmpl', 'oea-articles');
var oea_aResponsables = new Arbre("ComboListe/combo-responsables.tmpl","oea-Login_Resp");
var oea_aPolesActivite = new Arbre("ComboListe/combo-polesActivite.tmpl", "oea-Secteur");
var oea_aVersion = new Arbre("Facturation/Avoirs/list-versionAvoirClient.tmpl","oea-listeVersion");
var oea_aEtablissements = new Arbre('ComboListe/combo-etablissements.tmpl', 'oea-etablissement');
var oea_aDepots = new Arbre('ComboListe/combo-depotsStock.tmpl', 'oea-depot');
var oea_aCodesTVAFraisPort = new Arbre("ComboListe/combo-tauxTVA.tmpl", "oea-codeTVAFraisPort");
var oea_aLangues = new Arbre("ComboListe/combo-langues.tmpl", "oea-langueDefaut");
var oea_aTarifsVente = new Arbre("ComboListe/combo-tarifsVente.tmpl", "oea-Tarif_Id");


var oea_avoirId;
var oea_clientId = "";
var oea_modeLigne;
var oea_mode;
var oea_modeTarif;
var oea_gen;
var oea_assujettiTVA = false;
var oea_tauxTVAPort;
var oea_codeTVAPort = "";
var oea_typeRistourne = 'P';
var oea_typeRemise = 'P';
var oea_typeRemiseFP = 'P';
var oea_editionTTC = false;
var oea_zoneUE = false;
var oea_modified = false;
var oea_chargerResponsable;
var oea_selPoleActivite;
var oea_selTarifVente;
var oea_currentIndex = 0;
var oea_toSelectLigne = null;
var oea_montantHT = 0;
var oea_montantTTC = 0;
var oea_curEtablissement;
var oea_depotDefaut;
var oea_curDepot;
var oea_actSuiviLot;
var oea_actSuiviSerie;
var oea_codesTvaInactifs = "";
var oea_uniteDefaut;
var oea_insertionLigneId = 0;
var oea_typeEditionPdf;
var oea_docIdPdf;
var oea_apercu;
var oea_langueDefaut;
var oea_ligneId;
var oea_typeLigne;
var oea_articleId;
var oea_prixId = "";
var oea_libelle = "";
var oea_modifElemFin;



function oea_init() {
  try {

		oea_modifElemFin = gProfil.isModifElemFinDV();

		document.getElementById('oea-rowFax').collapsed = !gConfig.isShowFax();

		var act_codeStats = gConfig.isActCodeStats();
		oea_uniteDefaut = gConfig.getUniteDefaut();
		oea_actSuiviSerie = gConfig.isActSuiviSerie();
		document.getElementById('oea-bConsultSerieLigne').collapsed = !oea_actSuiviSerie;
		document.getElementById('oea-bConsultSerieLigne').disabled = true;

		if (!act_codeStats) {
			document.getElementById('oea-ColCode_Stats').collapsed = true;
			document.getElementById('oea-ColCode_Stats').setAttribute('ignoreincolumnpicker', true);
	  	document.getElementById('oea-Act_Code_Stats').collapsed = true;
		} else {
			document.getElementById('oea-labelRef').setAttribute('style', 'margin-left:0px');
			document.getElementById('oea-Reference').setAttribute('style', 'margin-left:0px');
		}

		oea_actSuiviLot = gConfig.isActSuiviLot();
		var actUnites = gConfig.isActUnites();
		var actNbPieces = gConfig.isActNbPieces();

		if (!oea_actSuiviLot) {
			document.getElementById('oea-ColNum_Lot').collapsed = true;
			document.getElementById('oea-ColNum_Lot').setAttribute('ignoreincolumnpicker', true);
			document.getElementById('oea-ColDate_Peremption').collapsed = true;
			document.getElementById('oea-ColDate_Peremption').setAttribute('ignoreincolumnpicker', true);
			document.getElementById('oea-fieldNumLot').collapsed = true;
			document.getElementById('oea-fieldDLC').collapsed = true;
		}

		if (!actUnites) {
			document.getElementById('oea-ColSymboleUnite').collapsed = true;
			document.getElementById('oea-ColSymboleUnite').setAttribute('ignoreincolumnpicker', true);
			document.getElementById('oea-fieldUnite').collapsed = true;
		}

		if (!actNbPieces) {
			document.getElementById('oea-ColNb_Pieces').collapsed = true;
			document.getElementById('oea-ColNb_Pieces').setAttribute('ignoreincolumnpicker', true);
			document.getElementById('oea-fieldNbPieces').collapsed = true;
		}

		oea_modeTarif = gConfig.getModeTarif();
    if (oea_modeTarif == 'Q'){
      document.getElementById('oea-row_tarif').collapsed = true;
    }

		var qAttPrinc = new QueryHttp("Facturation/Commun/getAttributsPrincipaux.tmpl");
		var result = qAttPrinc.execute();

		var contenu = result.responseXML.documentElement;

		for (var i=1; i<=6; i++) {
			if (!isEmpty(contenu.getAttribute("Groupe_Id_"+ i))) {
				document.getElementById("oea-ColAttribut"+ i).setAttribute("label", contenu.getAttribute("Intitule_"+ i));
			}
			else {
				document.getElementById("oea-ColAttribut"+ i).collapsed = true;
				document.getElementById("oea-ColAttribut"+ i).setAttribute("ignoreincolumnpicker", true);
			}
		}

		var qDepotDefaut = new QueryHttp("Facturation/Commun/getDepotDefautEts.tmpl");
		qDepotDefaut.setParam("Etablissement_Id", etablissementDefaut);
		result = qDepotDefaut.execute();
		oea_depotDefaut = result.responseXML.documentElement.getAttribute('Depot_Defaut');

		var aUnite = new Arbre("ComboListe/combo-unitesVente.tmpl", "oea-Unite");
		aUnite.initTree(oea_initUnite);

	} catch (e) {
  	recup_erreur(e);
	}
}


function oea_initUnite() {
	try {

    document.getElementById('oea-Unite').selectedIndex = 0;
		var aPays = new Arbre("ComboListe/combo-pays.tmpl", "oea-Code_Pays_Fact");
		aPays.initTree(oea_initPaysFact);

	} catch (e) {
    recup_erreur(e);
  }
}


function oea_chargerResponsables(selection) {
	try {
		oea_chargerResponsable = selection;
		oea_aResponsables.setParam("Selection", oea_chargerResponsable);
		oea_aResponsables.initTree(oea_initResponsable);
	} catch (e) {
		recup_erreur(e);
	}
}


function oea_initResponsable() {
  try {
		document.getElementById('oea-Login_Resp').value = oea_chargerResponsable;
	} catch (e) {
  	recup_erreur(e);
	}
}


function oea_chargerPolesActivite(selection) {
	try {

		oea_selPoleActivite = selection;
		oea_aPolesActivite.setParam("Selection", oea_selPoleActivite);
		oea_aPolesActivite.initTree(oea_initPoleActivite);

	} catch (e) {
		recup_erreur(e);
	}
}


function oea_initPoleActivite() {
  try {

		document.getElementById('oea-Secteur').value = oea_selPoleActivite;

	} catch (e) {
  	recup_erreur(e);
	}
}


function oea_initPaysFact() {
	try {

		var aPaysEnvoi = new Arbre("ComboListe/combo-pays.tmpl", "oea-Code_Pays_Envoi");
		aPaysEnvoi.initTree(oea_initPaysEnvoi);

	} catch (e) {
    recup_erreur(e);
  }
}

function oea_initPaysEnvoi() {
	try {

		var aPaysLiv = new Arbre("ComboListe/combo-pays.tmpl", "oea-Code_Pays_Liv");
		aPaysLiv.initTree();

	} catch (e) {
    recup_erreur(e);
  }
}


function oea_chargerEtablissement(selection) {
	try {
		oea_curEtablissement = selection;
		oea_aEtablissements.setParam("Selection", selection);
		oea_aEtablissements.initTree(oea_initEtablissement);
	} catch (e) {
		recup_erreur(e);
	}
}

function oea_initEtablissement() {
	try {
		document.getElementById('oea-etablissement').value = oea_curEtablissement;
	} catch (e) {
		recup_erreur(e);
	}
}


function oea_chargerDepot(selection) {
	try {
		oea_curDepot = selection;
		oea_aDepots.setParam("Depot_Quarantaine", false);
		oea_aDepots.setParam("Selection", selection);
		oea_aDepots.initTree(oea_initDepot);
	} catch (e) {
		recup_erreur(e);
	}
}

function oea_initDepot() {
	try {
		document.getElementById('oea-depot').value = oea_curDepot;
	} catch (e) {
		recup_erreur(e);
	}
}


function oea_selectPaysLiv() {
	try {

		oea_listeTVA();
    oea_changerTypeVente();

	} catch (e) {
		recup_erreur(e);
	}
}


function oea_listeTVAFraisPort() {
  try {

    oea_aCodesTVAFraisPort.setParam("Code_Pays", document.getElementById("oea-Code_Pays_Liv").value);
    oea_aCodesTVAFraisPort.setParam("Regime_TVA", document.getElementById("oea-Regime_TVA").value);
    oea_aCodesTVAFraisPort.setParam("Assujetti_TVA", oea_assujettiTVA);
		oea_aCodesTVAFraisPort.setParam("Selection", oea_codeTVAPort);
    oea_aCodesTVAFraisPort.initTree(oea_finListeTVAFraisPort);

  } catch (e) {
    recup_erreur(e);
  }
}


function oea_finListeTVAFraisPort() {
  try {

   	document.getElementById('oea-codeTVAFraisPort').value = getCodeTvaNormal(document.getElementById('oea-Code_Pays_Liv').value, oea_assujettiTVA, document.getElementById('oea-Regime_TVA').value);
   	oea_codeTVAPort = document.getElementById('oea-codeTVAFraisPort').value;
		oea_tauxTVAPort = getTva(oea_codeTVAPort);

  } catch (e) {
    recup_erreur(e);
  }
}


function oea_listeTVA() {
  try {

  	oea_calculTotaux();
    var aCode = new Arbre("ComboListe/combo-tauxTVA.tmpl", "oea-Code_TVA");
    aCode.setParam("Code_Pays", document.getElementById("oea-Code_Pays_Liv").value);
    aCode.setParam("Regime_TVA", document.getElementById("oea-Regime_TVA").value);
    aCode.setParam("Assujetti_TVA", oea_assujettiTVA);
		aCode.setParam("Selection", oea_codesTvaInactifs);
    aCode.initTree(oea_selectTVA);

  } catch (e) {
    recup_erreur(e);
  }
}


function oea_selectTVA() {
  try {

    document.getElementById('oea-Code_TVA').value = getCodeTvaNormal(document.getElementById('oea-Code_Pays_Liv').value,oea_assujettiTVA,document.getElementById("oea-Regime_TVA").value);

  } catch (e) {
    recup_erreur(e);
  }
}


function oea_switchRistourne() {
	try {

		if (oea_typeRistourne=='P') {
			document.getElementById('oea-bRistourne').setAttribute("class", "bIcoEuro");
			oea_typeRistourne = 'M';
		}
		else {
			document.getElementById('oea-bRistourne').setAttribute("class", "bIcoPourcentage");
			oea_typeRistourne = 'P';
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oea_switchRemise() {
	try {

		if (oea_typeRemise=='P') {
			document.getElementById('oea-bRemise').setAttribute("class", "bIcoEuro");
			oea_typeRemise = 'M';
		}
		else {
			document.getElementById('oea-bRemise').setAttribute("class", "bIcoPourcentage");
			oea_typeRemise = 'P';
		}
		oea_calculTotaux();
		oea_setModified(true);

	} catch (e) {
    recup_erreur(e);
  }
}


function oea_switchRemiseFP() {
	try {

		if (oea_typeRemiseFP=='P') {
			document.getElementById('oea-bRemiseFP').setAttribute("class", "bIcoEuro");
			oea_typeRemiseFP = 'M';
		}
		else {
			document.getElementById('oea-bRemiseFP').setAttribute("class", "bIcoPourcentage");
			oea_typeRemiseFP = 'P';
		}
		oea_calculTotaux();
		oea_setModified(true);

	} catch (e) {
    recup_erreur(e);
  }
}



function oea_ajouterLigne(typeLigne, articleId) {
  try {

		document.getElementById('oea-bSupprimer').disabled = true;
		document.getElementById('oea-bMoveUp').disabled = true;
		document.getElementById('oea-bMoveDown').disabled = true;
		document.getElementById('oea-bMoveFirst').disabled = true;
		document.getElementById('oea-bMoveLast').disabled = true;
		document.getElementById('oea-bMultiSuppression').disabled = true;
		document.getElementById('oea-bCommentaire').disabled = true;

		oea_modeLigne = "C";
		oea_typeLigne = typeLigne;
		oea_ligneId = "";

		oea_formatLigne(typeLigne);
		var codePaysLiv = document.getElementById("oea-Code_Pays_Liv").value;
		var regimeTVA = document.getElementById("oea-Regime_TVA").value;

		if (typeLigne=="S") {
			oea_articleId = articleId;

			if (oea_modeTarif=='Q') {
				var url = "chrome://opensi/content/facturation/user/commun/popup-choixTarif.xul";
    		window.openDialog(url,'','chrome,modal,centerscreen', oea_retourChoixPrixQuantite, articleId);

				if (!isEmpty(oea_prixId)) {
					var qGet = new QueryHttp("Facturation/Articles/getInfosArticleQuantite.tmpl");
        	qGet.setParam("Article_Id", articleId);
        	qGet.setParam("Prix_Id", oea_prixId);
					qGet.setParam("TTC", oea_editionTTC);
					var result = qGet.execute();

					var contenu = result.responseXML.documentElement;
					document.getElementById("oea-Code_Stats").value = contenu.getAttribute("Code_Stats");
					document.getElementById("oea-Designation").value = contenu.getAttribute("Designation");
					document.getElementById("oea-Num_Lot").value = "";
					document.getElementById("oea-Nb_Pieces").value = "";
					document.getElementById('oea-Quantite').value = contenu.getAttribute("Quantite");
					document.getElementById('oea-Unite').value = contenu.getAttribute("Unite_Id");
					document.getElementById("oea-Date_Peremption").value = "";
					document.getElementById("oea-PU").value = contenu.getAttribute("Prix_Unitaire");
					document.getElementById('oea-Ristourne').value = "0.00";
					document.getElementById("oea-Code_TVA").value = getCodeTvaCorrespondant(contenu.getAttribute("Code_TVA"), codePaysLiv, oea_assujettiTVA, regimeTVA);
					oea_prixId = "";
					oea_libelle = contenu.getAttribute("Libelle");
				}
				else {
					oea_ajouterLigne("I");
				}
			}
			else {
				var qGet = new QueryHttp("Facturation/Articles/getInfosArticleVente.tmpl");
        qGet.setParam("Article_Id", articleId);
        qGet.setParam("Tarif_Id", document.getElementById('oea-Tarif_Id').value);
				qGet.setParam("TTC", oea_editionTTC);
				qGet.setParam("Client_Id", oea_clientId);
				var result = qGet.execute();

				var contenu = result.responseXML.documentElement;
				document.getElementById("oea-Code_Stats").value = contenu.getAttribute("Code_Stats");
				document.getElementById("oea-Designation").value = contenu.getAttribute("Designation");
				document.getElementById("oea-Num_Lot").value = "";
				document.getElementById("oea-Nb_Pieces").value = "";
				document.getElementById('oea-Quantite').value = 1;
				document.getElementById('oea-Unite').value = contenu.getAttribute("Unite_Id");
				document.getElementById("oea-Date_Peremption").value = "";
				document.getElementById("oea-PU").value = contenu.getAttribute("Prix_Unitaire");
				document.getElementById('oea-Ristourne').value = contenu.getAttribute("Ristourne");
				document.getElementById("oea-Code_TVA").value = getCodeTvaCorrespondant(contenu.getAttribute("Code_TVA"), codePaysLiv, oea_assujettiTVA, regimeTVA);
				oea_libelle = "";
			}
		}
		else {
			oea_articleId = "";
			document.getElementById("oea-bConsultSerieLigne").disabled = true;
			document.getElementById("oea-Code_Stats").value = "";
			document.getElementById('oea-Reference').value = "";
			document.getElementById('oea-Designation').value = "";
			document.getElementById("oea-Num_Lot").value = "";
			document.getElementById("oea-Nb_Pieces").value = "";
			document.getElementById('oea-Quantite').value = 1;
			document.getElementById('oea-Unite').value = oea_uniteDefaut;
			document.getElementById("oea-Date_Peremption").value = "";
			document.getElementById('oea-PU').value = "";
			document.getElementById('oea-Ristourne').value = "0.00";
			document.getElementById('oea-Code_TVA').value = getCodeTvaNormal(codePaysLiv, oea_assujettiTVA, regimeTVA);
			oea_libelle = "";
			oea_insertionLigneId = 0;
			document.getElementById('oea-bAjouterLigne').disabled = true;
			document.getElementById('oea-Act_Insert').collapsed = true;
			oea_aLignes.setCellSrc(oea_currentIndex, 'oea-ColReference', "");
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oea_formatLigne(typeLigne) {
  try {

		switch(typeLigne) {
			case "S":
        if (oea_mode != 'V') {
        	document.getElementById('oea-Code_Stats').disabled = false;
				  document.getElementById('oea-Reference').disabled = true;
				  document.getElementById('oea-Designation').disabled = true;
				  document.getElementById('oea-Num_Lot').disabled = false;
					document.getElementById('oea-Nb_Pieces').disabled = false;
					document.getElementById('oea-Quantite').disabled = false;
					document.getElementById('oea-Unite').disabled = false;
					document.getElementById('oea-Date_Peremption').disabled = false;
				  document.getElementById('oea-PU').disabled = !oea_modifElemFin;
				  document.getElementById('oea-Ristourne').disabled = !oea_modifElemFin;
				  document.getElementById('oea-bRistourne').disabled = !oea_modifElemFin;
				  document.getElementById('oea-Code_TVA').disabled = !oea_modifElemFin;
				  document.getElementById('oea-bValider').disabled = false;
				  document.getElementById('oea-bAnnuler').disabled = false;
        }
				break;

			case "I":
        if (oea_mode != 'V') {
        	document.getElementById('oea-Code_Stats').disabled = false;
  				document.getElementById('oea-Reference').disabled = false;
	  			document.getElementById('oea-Designation').disabled = false;
		  		document.getElementById('oea-Num_Lot').disabled = true;
					document.getElementById('oea-Nb_Pieces').disabled = false;
					document.getElementById('oea-Quantite').disabled = false;
					document.getElementById('oea-Unite').disabled = false;
					document.getElementById('oea-Date_Peremption').disabled = true;
			  	document.getElementById('oea-PU').disabled = !oea_modifElemFin;
			  	document.getElementById('oea-Ristourne').disabled = !oea_modifElemFin;
				  document.getElementById('oea-bRistourne').disabled = !oea_modifElemFin;
				  document.getElementById('oea-Code_TVA').disabled = !oea_modifElemFin;
				  document.getElementById('oea-bValider').disabled = false;
				  document.getElementById('oea-bAnnuler').disabled = false;
        }
				break;

			default:
				document.getElementById('oea-Code_Stats').value = "";
				document.getElementById('oea-Reference').value = "";
				document.getElementById('oea-Designation').value = "";
				document.getElementById('oea-Num_Lot').value = "";
				document.getElementById('oea-Nb_Pieces').value = "";
				document.getElementById('oea-Quantite').value = "";
				document.getElementById('oea-Unite').value = oea_uniteDefaut;
				document.getElementById('oea-Date_Peremption').value = "";
				document.getElementById('oea-PU').value = "";
				document.getElementById('oea-Ristourne').value = "0.00";
				document.getElementById('oea-Code_TVA').value = getCodeTvaNormal(document.getElementById("oea-Code_Pays_Liv").value,oea_assujettiTVA,document.getElementById("oea-Regime_TVA").value);
				oea_libelle = "";
				oea_ligneId = "";
				document.getElementById('oea-Code_Stats').disabled = true;
				document.getElementById('oea-Reference').disabled = true;
				document.getElementById('oea-Designation').disabled = true;
				document.getElementById('oea-Num_Lot').disabled = true;
				document.getElementById('oea-Nb_Pieces').disabled = true;
				document.getElementById('oea-Quantite').disabled = true;
				document.getElementById('oea-Unite').disabled = true;
				document.getElementById('oea-Date_Peremption').disabled = true;
				document.getElementById('oea-PU').disabled = true;
				document.getElementById('oea-Ristourne').disabled = true;
				document.getElementById('oea-bRistourne').disabled = true;
				document.getElementById('oea-Code_TVA').disabled = true;
				document.getElementById('oea-bSupprimer').disabled = true;
				document.getElementById('oea-bMoveUp').disabled = true;
				document.getElementById('oea-bMoveDown').disabled = true;
				document.getElementById('oea-bMoveFirst').disabled = true;
				document.getElementById('oea-bMoveLast').disabled = true;
				document.getElementById('oea-bMultiSuppression').disabled = true;
				document.getElementById('oea-bCommentaire').disabled = true;
				document.getElementById('oea-bValider').disabled = true;
				document.getElementById('oea-bAnnuler').disabled = true;
				break;
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oea_pressOnWindow(ev) {
	try {

		if (ev.altKey && oea_mode!="V") {
			switch(ev.charCode) {
      	case 97: // 'a'
				case 65: // 'A'
        	oea_rechercherStock();
        	break;
				case 116: // 't'
					oea_modifierTarif();
					break;
    	}
		}
		else if (ev.ctrlKey && oea_mode!="V") {
			if (ev.keyCode==46) {
				// ctrl + suppr
				ev.preventDefault();
				oea_supprimerLigne();
			}
			else if (ev.charCode==114 || ev.charCode==82) {
				// ctrl + r (ou R)
				ev.preventDefault();
				oea_appliquerRistourne();
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oea_pressOnReference(ev) {
	try {

		if (ev.keyCode==13) {
			oea_rechercherReference();
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oea_rechercherStock(reference) {
	try {

		var url = "chrome://opensi/content/facturation/user/articles/popup-rechercheArticle.xul";
		var tarifId = (oea_modeTarif!="Q"?document.getElementById('oea-Tarif_Id').value:null);
		var multiSel = (oea_modeTarif!="Q"?true:null);
    window.openDialog(url,'','chrome,modal,centerscreen', oea_retourRechercherStock, "V", reference, tarifId, null, null, null, oea_clientId, multiSel);

	} catch (e) {
    recup_erreur(e);
  }
}


function oea_retourRechercherStock(reference, articleId, listArticleId) {
	try {

		if (articleId!=null) {
			document.getElementById('oea-Reference').value = reference;
			document.getElementById('oea-Quantite').focus();
			oea_ajouterLigne("S", articleId);
		}
		else {
			oea_ajouterMulti(listArticleId);
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oea_rechercherReference() {
	try {

		var reference = document.getElementById('oea-Reference').value;

		var qSearch = new QueryHttp("Facturation/Articles/searchReference.tmpl");
		qSearch.setParam("Reference", reference);
		qSearch.setParam("Vente_Achat", "V");
		var result = qSearch.execute();

		var articleId = result.responseXML.documentElement.getAttribute("Article_Id");
		if (!isEmpty(articleId)) {
			document.getElementById('oea-Reference').value = result.responseXML.documentElement.getAttribute("Reference");
			document.getElementById('oea-Quantite').focus();
			oea_ajouterLigne("S", articleId);
		}
		else {
			oea_rechercherStock(reference);
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oea_ajouterMulti(listArticleId) {
	try {

		var ok = true;

		if (oea_mode=="C") {
			ok = oea_enregistrerAvoir();
		}

		if (ok) {
			var qAdd = new QueryHttp("Facturation/Avoirs/addLigneAvoirClient.tmpl");
			qAdd.setParam("List_Article_Id", listArticleId);
			qAdd.setParam("Avoir_Id", oea_avoirId);
			qAdd.execute();

			oea_ajouterLigne("I");
			oea_aLignes.initTree(oea_afterRefreshArticles);
		}

	} catch (e) {
		recup_erreur(e);
  }
}


function oea_modifierTarif() {
	try {

		if (oea_modeLigne=="M" && oea_typeLigne=='S' && oea_modeTarif=='Q') {

			var url = "chrome://opensi/content/facturation/user/commun/popup-choixTarif.xul";
    	window.openDialog(url,'','chrome,modal,centerscreen', oea_retourChoixPrixQuantite, oea_articleId);

			if (!isEmpty(oea_prixId)) {
				var qGet = new QueryHttp("Facturation/Articles/getInfosArticleQuantite.tmpl");
        qGet.setParam("Article_Id", oea_articleId);
        qGet.setParam("Prix_Id", oea_prixId);
				qGet.setParam("TTC", oea_editionTTC);
				var result = qGet.execute();

				var contenu = result.responseXML.documentElement;
				document.getElementById('oea-Quantite').value = contenu.getAttribute("Quantite");
				document.getElementById('oea-Unite').value = contenu.getAttribute("Unite_Id");
				document.getElementById("oea-PU").value = contenu.getAttribute("Prix_Unitaire");
				oea_prixId = "";
				oea_libelle = contenu.getAttribute("Libelle");
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oea_retourChoixPrixQuantite(prixId) {
	try {

		oea_prixId = prixId;

	} catch (e) {
		recup_erreur(e);
	}
}


function oea_ouvrirLigne() {
  try {

		if (oea_aLignes.isSelected() && oea_mode=="M") {

			if (oea_aLignes.nbSelection()==1) {
				var i = oea_aLignes.getCurrentIndex();
				oea_aLignes.setCellSrc(i, 'oea-ColReference', "");

				oea_currentIndex = i;

				var typeLigne = oea_aLignes.getCellText(i,'oea-colTypeLigne');
				document.getElementById("oea-bConsultSerieLigne").disabled = (typeLigne!="S");
				document.getElementById('oea-bMultiSuppression').disabled = true;

				if (oea_aLignes.getCellText(i,'oea-colTypeLigne')=="C") {
					oea_ajouterLigne("I");
				}
				else {
					oea_modeLigne = "M";

					document.getElementById('oea-bAjouterLigne').disabled = false;
					oea_insertionLigneId = 0;
					document.getElementById('oea-Act_Insert').collapsed = true;
					document.getElementById("oea-Code_Stats").value = oea_aLignes.getCellText(i,'oea-ColCode_Stats');
					document.getElementById("oea-Reference").value = oea_aLignes.getCellText(i,'oea-ColReference');
					document.getElementById("oea-Designation").value = oea_aLignes.getCellText(i,'oea-ColDesignation');
					document.getElementById("oea-Num_Lot").value = oea_aLignes.getCellText(i,'oea-ColNum_Lot');
					document.getElementById("oea-Nb_Pieces").value = oea_aLignes.getCellText(i,'oea-ColNb_Pieces');
					document.getElementById("oea-Quantite").value = oea_aLignes.getCellText(i,'oea-ColQuantite');
					document.getElementById("oea-Unite").value = oea_aLignes.getCellText(i,'oea-ColUnite');
					document.getElementById("oea-Date_Peremption").value = oea_aLignes.getCellText(i,'oea-ColDate_Peremption');
					document.getElementById("oea-PU").value = oea_aLignes.getCellText(i,'oea-ColPU');
					document.getElementById("oea-Ristourne").value = oea_aLignes.getCellValue(i,'oea-ColRistourne');
					oea_typeRistourne = oea_aLignes.getSelectedCellText('oea-colTypeRistourne');
					document.getElementById('oea-bRistourne').setAttribute("class", (oea_typeRistourne=='P'?"bIcoPourcentage":"bIcoEuro"));
					document.getElementById("oea-Code_TVA").value = oea_aLignes.getCellText(i,'oea-ColCode_TVA');
					oea_typeLigne = oea_aLignes.getCellText(i,'oea-colTypeLigne');
					oea_ligneId = oea_aLignes.getCellText(i,'oea-colLigneId');
					oea_articleId = oea_aLignes.getCellText(i,'oea-colArticleId');
					oea_libelle = oea_aLignes.getCellText(i,'oea-ColLibelle');

					document.getElementById('oea-bSupprimer').disabled = false;
					document.getElementById('oea-bCommentaire').disabled = false;

  		  	// on ignore les lignes de commentaires
  				var firstIndex = 0;
  				var lastIndex = oea_aLignes.nbLignes()-1;
  				if (oea_aLignes.getCellText(firstIndex,'oea-colTypeLigne')=="C") { firstIndex++; }
  				if (oea_aLignes.getCellText(lastIndex,'oea-colTypeLigne')=="C") { lastIndex--; }

  				document.getElementById('oea-bMoveUp').disabled = (i==firstIndex);
  				document.getElementById('oea-bMoveDown').disabled = (i==lastIndex);
					document.getElementById('oea-bMoveFirst').disabled = (i==firstIndex);
  				document.getElementById('oea-bMoveLast').disabled = (i==lastIndex);

					oea_formatLigne(oea_typeLigne);
				}
			}
			else {
				oea_ajouterLigne("I");
				document.getElementById('oea-bMultiSuppression').disabled = false;
			}
		}

	} catch (e) {
  	recup_erreur(e);
	}
}

function oea_ajouterLigneAvant() {
  try {

		if (oea_aLignes.isSelected() && oea_mode=="M") {
			var idx = oea_aLignes.getCurrentIndex();
			var ligneId = oea_aLignes.getCellText(idx,'oea-colLigneId');
			oea_annulerLigne();

			oea_aLignes.setCellSrc(idx, 'oea-ColReference', "chrome://opensi/content/design/insertbefore.png");

			oea_insertionLigneId = ligneId;
			oea_currentIndex = idx;
			document.getElementById('oea-Act_Insert').collapsed = false;
			document.getElementById('oea-Reference').focus();
		}

	} catch (e) {
  	recup_erreur(e);
	}
}

function oea_pressOnLigneAvoir(event) {
	try {

		if (event.keyCode==45 && event.ctrlKey) {
			// ctrl + inser
			// insrer une ligne avant

			oea_ajouterLigneAvant();
		}
	} catch (e) {
		recup_erreur(e);
	}
}


function oea_ouvrirCommentaire() {
  try {

		if (oea_aLignes.isSelected() && oea_mode=="M") {
			var i = oea_aLignes.getCurrentIndex();

			if (oea_aLignes.getCellText(i,'oea-colTypeLigne')=="C") {
				oea_editerCommentaire();
			}
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oea_deplacerLigne(moveType) {
	try {

		if (oea_aLignes.isSelected() && oea_mode=="M" && oea_aLignes.getSelectedCellText('oea-colTypeLigne')!="C") {

			document.getElementById('oea-bMoveUp').disabled = true;
			document.getElementById('oea-bMoveDown').disabled = true;
			document.getElementById('oea-bMoveFirst').disabled = true;
			document.getElementById('oea-bMoveLast').disabled = true;

			var qMove = new QueryHttp("Facturation/Avoirs/moveLigneAvoirClient.tmpl");
			qMove.setParam("Ligne_Id", oea_ligneId);
			qMove.setParam("Move_Type", moveType);
			var result = qMove.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				oea_toSelectLigne = oea_ligneId;
				oea_ajouterLigne("I");
				oea_aLignes.initTree(oea_afterRefreshArticles);
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oea_validerLigne() {
  try {

		var codeStats = document.getElementById("oea-Code_Stats").value;
		var reference = document.getElementById("oea-Reference").value;
		var designation = document.getElementById("oea-Designation").value;
		var numLot = document.getElementById("oea-Num_Lot").value;
		var nbPieces = document.getElementById("oea-Nb_Pieces").value;
		var quantite = document.getElementById("oea-Quantite").value;
		var unite = document.getElementById("oea-Unite").value;
		var datePeremption = document.getElementById("oea-Date_Peremption").value;
		var prixUnitaire = document.getElementById("oea-PU").value;
		var ristourne = document.getElementById("oea-Ristourne").value;
		var codeTVA = document.getElementById("oea-Code_TVA").value;

		if (isEmpty(nbPieces)) {
			nbPieces = 0;
		}

		var ok = true;

		if (oea_mode=="C") {
			ok = oea_enregistrerAvoir();
		}

		if (ok) {

			if (isEmpty(designation)) { showWarning("D\u00E9signation de l'article manquante !"); }
			else if (!checkQte(quantite)) { showWarning("Quantit\u00E9 incorrecte !"); }
	  	else if (!isPositiveOrNullInteger(nbPieces)) { showWarning("Nombre de pi\u00E8ces incorrect !"); }
			else if (isEmpty(prixUnitaire) || !checkDecimal(prixUnitaire,4) || !isPositiveOrNull(prixUnitaire)) { showWarning("Prix unitaire incorrect !"); }
			else if (isEmpty(ristourne) || (oea_typeRistourne=='P'?!isTaux(ristourne):!isPositiveOrNull(ristourne) || !checkNumber(ristourne,9,2) || parseFloat(ristourne)>parseFloat(prixUnitaire))) { showWarning("Ristourne incorrecte"); }
			else if (oea_checkNumLotLigne(numLot, datePeremption)) {

				var qSave;

				if (oea_modeLigne=="C") {
					if (oea_insertionLigneId==0) {
						oea_currentIndex = oea_aLignes.nbLignes();
					}
					qSave = new QueryHttp("Facturation/Avoirs/createLigneAvoirClient.tmpl");
					qSave.setParam("Avoir_Id", oea_avoirId);
				}
				else {
					qSave = new QueryHttp("Facturation/Avoirs/updateLigneAvoirClient.tmpl");
					qSave.setParam("Ligne_Id", oea_ligneId);
				}

				qSave.setParam("Reference", reference);
	  		qSave.setParam("Designation", designation);
	  		qSave.setParam("Quantite", quantite);
				qSave.setParam("Prix", prixUnitaire);
				qSave.setParam("Ristourne", ristourne);
				qSave.setParam("Type_Ristourne", oea_typeRistourne);
	  		qSave.setParam("Code_TVA", codeTVA);
				qSave.setParam("Libelle", oea_libelle);
				qSave.setParam("Num_Lot", numLot);
				qSave.setParam("Date_Peremption", datePeremption);
				qSave.setParam("Nb_Pieces", nbPieces);
				qSave.setParam("Unite", unite);
				qSave.setParam("Code_Stats", codeStats);
				qSave.setParam("Insertion_Ligne_Id", oea_insertionLigneId);

				var result = qSave.execute();

				var errors = new Errors(result);
				if (errors.hasNext()) {
					errors.show();
				}
				else {

					if (oea_modeLigne=="C") {
			      oea_ligneId = result.responseXML.documentElement.getAttribute('Ligne_Id');
			    }

					oea_checkNumSerieLigne(quantite);

					oea_ajouterLigne("I");
					oea_aLignes.initTree(oea_afterRefreshArticles);
				}
			}
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oea_annulerLigne() {
  try {

  	oea_aLignes.clearSelection();
		oea_ajouterLigne("I");

	} catch (e) {
  	recup_erreur(e);
	}
}


function oea_supprimerLigne() {
  try {

		var listLigneId = "";
		var maxIndex = 0;

		if (!isEmpty(oea_ligneId)) {
			listLigneId = oea_ligneId;
			maxIndex = oea_currentIndex;
		}
		else {
			var start = new Object();
			var end = new Object();
			var numRanges = oea_aLignes.getRangeCount();

			for (var t=0; t<numRanges; t++){
				oea_aLignes.getRangeAt(t,start,end);
			  for (var v=start.value; v<=end.value; v++){
					if (oea_aLignes.getCellText(v,'oea-colTypeLigne')!="C") {
			  		listLigneId += oea_aLignes.getCellText(v,'oea-colLigneId')+",";
						if (v>maxIndex) maxIndex = v;
					}
			  }
			}
		}

		if (!isEmpty(listLigneId)) {
			var qDelete = new QueryHttp("Facturation/Avoirs/deleteLigneAvoirClient.tmpl");
			qDelete.setParam('List_Ligne_Id', listLigneId);
			var result = qDelete.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				oea_currentIndex = maxIndex-1;
				oea_ajouterLigne("I");
				oea_aLignes.initTree(oea_afterRefreshArticles);
			}
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oea_appliquerRistourne() {
	try {

		var listLigneId = "";
		var maxIndex = 0;

		if (oea_aLignes.isSelected()) {
			var start = new Object();
			var end = new Object();
			var numRanges = oea_aLignes.getRangeCount();

			for (var t=0; t<numRanges; t++){
				oea_aLignes.getRangeAt(t,start,end);
			  for (var v=start.value; v<=end.value; v++){
					if (oea_aLignes.getCellText(v,'oea-colTypeLigne')!="C") {
			  		listLigneId += oea_aLignes.getCellText(v,'oea-colLigneId')+",";
						if (v>maxIndex) maxIndex = v;
					}
			  }
			}
		}

		if (!isEmpty(listLigneId)) {
			var url = "chrome://opensi/content/facturation/user/commun/popup-applicationRistourne.xul";
			window.openDialog(url,'','chrome,modal,centerscreen', "AC", listLigneId);

			oea_currentIndex = maxIndex;
			oea_ajouterLigne("I");
			oea_aLignes.initTree(oea_afterRefreshArticles);
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oea_enregistrerAvoir() {
  try {

		var save = false;

    var remise = document.getElementById('oea-Remise').value;
    var remiseFP = document.getElementById('oea-RemiseFP').value;
		var taux_remise = 0;
		var montant_remise = 0;
		var tauxRemiseFP = 0;
		var montantRemiseFP = 0;
		var frais_port = document.getElementById('oea-Frais_Port').value;
		var escompte = document.getElementById('oea-Escompte').value;
		var modeEnvoiAvoir = document.getElementById('oea-modeEnvoiAvoir').value;
		var secteurActivite = document.getElementById('oea-Secteur').value;
		var etablissement = document.getElementById('oea-etablissement').value;
		var chkIncrStock = document.getElementById('oea-chkIncrementerStock').checked;
		var depotStock = (chkIncrStock?document.getElementById('oea-depot').value:"");
		var utilR = document.getElementById('oea-Login_Resp').value;
		var editionTTC = document.getElementById('oea-Edition_TTC').checked;
		var regimeTVA = document.getElementById("oea-Regime_TVA").value;
		var tarifId = document.getElementById("oea-Tarif_Id").value;
		var commentairesInt = document.getElementById('oea-Commentaires_Int').value;
		var commentairesFin = document.getElementById('oea-Commentaires_Fin').value;
		var num_tva = oea_assujettiTVA?document.getElementById('oea-Num_TVA').value:"";
		var montant_base = (oea_editionTTC?oea_montantTTC:oea_montantHT);
		oea_codeTVAPort = document.getElementById('oea-codeTVAFraisPort').value;
		oea_tauxTVAPort = getTva(oea_codeTVAPort);

    var denomination_fact = document.getElementById('oea-Denomination_Fact').value;
		var adresse_1_fact = document.getElementById('oea-Adresse_1_Fact').value;
		var adresse_2_fact = document.getElementById('oea-Adresse_2_Fact').value;
		var adresse_3_fact = document.getElementById('oea-Adresse_3_Fact').value;
		var code_postal_fact = document.getElementById('oea-Code_Postal_Fact').value;
		var ville_fact = document.getElementById('oea-Ville_Fact').value;
		var code_pays_fact = document.getElementById('oea-Code_Pays_Fact').value;

		var civ_inter_fact = document.getElementById("oea-Civ_Inter_Fact").value;
		var nom_inter_fact = document.getElementById("oea-Nom_Inter_Fact").value;
		var prenom_inter_fact = document.getElementById("oea-Prenom_Inter_Fact").value;
		var telInter1fact = document.getElementById("oea-Tel_Inter_1_Fact").value;
		var telInter2fact = document.getElementById("oea-Tel_Inter_2_Fact").value;
		var fax_inter_fact = document.getElementById('oea-Fax_Inter_Fact').value;
		var email_inter_fact = document.getElementById('oea-Email_Inter_Fact').value;

		var denomination_liv = document.getElementById('oea-Denomination_Liv').value;
		var adresse_1_liv = document.getElementById('oea-Adresse_1_Liv').value;
		var adresse_2_liv = document.getElementById('oea-Adresse_2_Liv').value;
		var adresse_3_liv = document.getElementById('oea-Adresse_3_Liv').value;
		var code_postal_liv = document.getElementById('oea-Code_Postal_Liv').value;
		var ville_liv = document.getElementById('oea-Ville_Liv').value;
		var code_pays_liv = document.getElementById('oea-Code_Pays_Liv').value;

		var civ_inter_liv = document.getElementById("oea-Civ_Inter_Liv").value;
		var nom_inter_liv = document.getElementById("oea-Nom_Inter_Liv").value;
		var prenom_inter_liv = document.getElementById("oea-Prenom_Inter_Liv").value;
		var telInter1liv = document.getElementById("oea-Tel_Inter_1_Liv").value;
		var telInter2liv = document.getElementById("oea-Tel_Inter_2_Liv").value;
		var fax_inter_liv = document.getElementById('oea-Fax_Inter_Liv').value;
		var email_inter_liv = document.getElementById('oea-Email_Inter_Liv').value;

		var denomination_envoi = document.getElementById('oea-Denomination_Envoi').value;
		var adresse_1_envoi = document.getElementById('oea-Adresse_1_Envoi').value;
		var adresse_2_envoi = document.getElementById('oea-Adresse_2_Envoi').value;
		var adresse_3_envoi = document.getElementById('oea-Adresse_3_Envoi').value;
		var code_postal_envoi = document.getElementById('oea-Code_Postal_Envoi').value;
		var ville_envoi = document.getElementById('oea-Ville_Envoi').value;
		var code_pays_envoi = document.getElementById('oea-Code_Pays_Envoi').value;

		var civ_inter_envoi = document.getElementById("oea-Civ_Inter_Envoi").value;
		var nom_inter_envoi = document.getElementById("oea-Nom_Inter_Envoi").value;
		var prenom_inter_envoi = document.getElementById("oea-Prenom_Inter_Envoi").value;
		var telInter1envoi = document.getElementById("oea-Tel_Inter_1_Envoi").value;
		var telInter2envoi = document.getElementById("oea-Tel_Inter_2_Envoi").value;
		var fax_inter_envoi = document.getElementById('oea-Fax_Inter_Envoi').value;
		var email_inter_envoi = document.getElementById('oea-Email_Inter_Envoi').value;

		if (isEmpty(remise) || (oea_typeRemise=='P'?!isTaux(remise):!isPositiveOrNull(remise) || !checkNumber(remise,9,2) || parseFloat(remise)>montant_base)) { showWarning("Remise incorrecte !"); }
		else if (isEmpty(frais_port) || !isPositiveOrNull(frais_port)) { showWarning("Frais de port incorrects !"); }
		else if (isEmpty(remiseFP) || (oea_typeRemiseFP=='P'?!isTaux(remiseFP):!isPositiveOrNull(remiseFP) || !checkNumber(remiseFP,9,2) || parseFloat(remiseFP)>parseFloat(frais_port))) { showWarning("Remise sur frais de port incorrecte !"); }
		else if (isEmpty(escompte) || !isTaux(escompte)) { showWarning("Taux d'escompte incorrect !"); }
		else if (isEmpty(denomination_fact)) { showWarning("Veuillez indiquer la d\u00E9nomination du client de facturation !"); }
		else if (isEmpty(adresse_1_fact)) { showWarning("Veuillez indiquer l'adresse du client de facturation !"); }
		else if (isEmpty(ville_fact)) { showWarning("Veuillez indiquer la ville du client de facturation !"); }
		else if (isEmpty(denomination_liv)) { showWarning("Veuillez indiquer la d\u00E9nomination du client de livraison !"); }
		else if (isEmpty(adresse_1_liv)) { showWarning("Veuillez indiquer l'adresse du client de livraison !"); }
		else if (isEmpty(ville_liv)) { showWarning("Veuillez indiquer la ville du client de livraison !"); }
		else if (isEmpty(denomination_envoi)) { showWarning("Veuillez indiquer la d\u00E9nomination du client d'envoi !"); }
		else if (isEmpty(adresse_1_envoi)) { showWarning("Veuillez indiquer l'adresse du client d'envoi !"); }
		else if (isEmpty(ville_envoi)) { showWarning("Veuillez indiquer la ville du client d'envoi !"); }
		else if (!isEmpty(telInter1fact) && !isPhone(telInter1fact)) { showWarning("T\u00E9l\u00E9phone 1 de facturation incorrect !"); }
		else if (!isEmpty(telInter2fact) && !isPhone(telInter2fact)) { showWarning("T\u00E9l\u00E9phone 2 de facturation incorrect !"); }
		else if (!isEmpty(fax_inter_fact) && !isPhone(fax_inter_fact)) { showWarning("Num\u00E9ro de fax de facturation incorrect !"); }
		else if (!isEmpty(email_inter_fact) && !isEmail(email_inter_fact)) { showWarning("Adresse e-mail de facturation incorrecte !"); }
		else if (!isEmpty(telInter1liv) && !isPhone(telInter1liv)) { showWarning("T\u00E9l\u00E9phone 1 de livraison incorrect !"); }
		else if (!isEmpty(telInter2liv) && !isPhone(telInter2liv)) { showWarning("T\u00E9l\u00E9phone 2 de livraison incorrect !"); }
		else if (!isEmpty(fax_inter_liv) && !isPhone(fax_inter_liv)) { showWarning("Num\u00E9ro de fax de livraison incorrect !"); }
		else if (!isEmpty(email_inter_liv) && !isEmail(email_inter_liv)) { showWarning("Adresse e-mail de livraison incorrecte !"); }
		else if (!isEmpty(telInter1envoi) && !isPhone(telInter1envoi)) { showWarning("T\u00E9l\u00E9phone 1 d'envoi incorrect !"); }
		else if (!isEmpty(telInter2envoi) && !isPhone(telInter2envoi)) { showWarning("T\u00E9l\u00E9phone 2 d'envoi incorrect !"); }
		else if (!isEmpty(fax_inter_envoi) && !isPhone(fax_inter_envoi)) { showWarning("Num\u00E9ro de fax d'envoi incorrect !"); }
		else if (!isEmpty(email_inter_envoi) && !isEmail(email_inter_envoi)) { showWarning("Adresse e-mail d'envoi incorrecte !"); }
		else {

			if (oea_assujettiTVA && code_pays_liv!="FR" && isEmpty(num_tva) && oea_zoneUE) {
				showWarning("Attention : vous n'avez pas saisi le num\u00E9ro de tva intra-communautaire !");
			}

			frais_port = parseFloat(frais_port);
			remise = parseFloat(remise);
			remiseFP = parseFloat(remiseFP);

			if (oea_typeRemise=='P') {
				taux_remise = remise;
			}
			else {
				taux_remise = (montant_base>0?remise/montant_base*100:0);
				montant_remise = remise;
			}

			if (oea_typeRemiseFP=='P') {
				tauxRemiseFP = remiseFP;
			}
			else {
				tauxRemiseFP = (frais_port>0?remiseFP/frais_port*100:0);
				montantRemiseFP = remiseFP;
			}

			var qSave;

			if (oea_mode=="C") {
				qSave = new QueryHttp("Facturation/Avoirs/createAvoirClient.tmpl");
			}
			else {
				qSave = new QueryHttp("Facturation/Avoirs/updateAvoirClient.tmpl");
				qSave.setParam("Avoir_Id", oea_avoirId);
			}

			qSave.setParam("Util_R", utilR);
			qSave.setParam("Mode_Envoi_Avoir", modeEnvoiAvoir);
			qSave.setParam("Pole_Activite", secteurActivite);
			qSave.setParam("Etab_Id", etablissement);
			qSave.setParam("Depot_Id", depotStock);
			qSave.setParam("PRemise", taux_remise);
			qSave.setParam("MRemise", montant_remise);
			qSave.setParam("PRemise_FP", tauxRemiseFP);
			qSave.setParam("MRemise_FP", montantRemiseFP);
      qSave.setParam("Frais_Port", frais_port);
      qSave.setParam("Escompte", escompte);
			qSave.setParam("Commentaires_Fin", commentairesFin);
			qSave.setParam("Commentaires_Int", commentairesInt);
			qSave.setParam("Edition_TTC", editionTTC);
			qSave.setParam("Assujetti_TVA", oea_assujettiTVA);
			qSave.setParam("Num_TVA_Intra", num_tva);
			qSave.setParam("Regime_TVA", regimeTVA);
			qSave.setParam("Code_TVA_Port", oea_codeTVAPort);
			qSave.setParam("Taux_TVA_Port", oea_tauxTVAPort);
      qSave.setParam("Tarif_Id", tarifId);
      qSave.setParam("Client_Id", oea_clientId);

			qSave.setParam("Denomination", denomination_fact);
      qSave.setParam("Adresse_1", adresse_1_fact);
      qSave.setParam("Adresse_2", adresse_2_fact);
			qSave.setParam("Adresse_3", adresse_3_fact);
      qSave.setParam("Code_Postal", code_postal_fact);
      qSave.setParam("Ville", ville_fact);
			qSave.setParam("Code_Pays", code_pays_fact);
			qSave.setParam("Civ_Inter", civ_inter_fact);
			qSave.setParam("Nom_Inter", nom_inter_fact);
			qSave.setParam("Prenom_Inter", prenom_inter_fact);
			qSave.setParam("Tel_Inter_1", telInter1fact);
			qSave.setParam("Tel_Inter_2", telInter2fact);
			qSave.setParam("Fax_Inter", fax_inter_fact);
			qSave.setParam("Email_Inter", email_inter_fact);

			qSave.setParam("Denomination_Liv", denomination_liv);
			qSave.setParam("Adresse_1_Liv", adresse_1_liv);
			qSave.setParam("Adresse_2_Liv", adresse_2_liv);
			qSave.setParam("Adresse_3_Liv", adresse_3_liv);
			qSave.setParam("Code_Postal_Liv", code_postal_liv);
			qSave.setParam("Ville_Liv", ville_liv);
			qSave.setParam("Code_Pays_Liv", code_pays_liv);
			qSave.setParam("Civ_Inter_Liv", civ_inter_liv);
			qSave.setParam("Nom_Inter_Liv", nom_inter_liv);
			qSave.setParam("Prenom_Inter_Liv", prenom_inter_liv);
			qSave.setParam("Tel_Inter_1_Liv", telInter1liv);
			qSave.setParam("Tel_Inter_2_Liv", telInter2liv);
			qSave.setParam("Fax_Inter_Liv", fax_inter_liv);
			qSave.setParam("Email_Inter_Liv", email_inter_liv);

			qSave.setParam("Denomination_Envoi", denomination_envoi);
			qSave.setParam("Adresse_1_Envoi", adresse_1_envoi);
			qSave.setParam("Adresse_2_Envoi", adresse_2_envoi);
			qSave.setParam("Adresse_3_Envoi", adresse_3_envoi);
			qSave.setParam("Code_Postal_Envoi", code_postal_envoi);
			qSave.setParam("Ville_Envoi", ville_envoi);
			qSave.setParam("Code_Pays_Envoi", code_pays_envoi);
			qSave.setParam("Civ_Inter_Envoi", civ_inter_envoi);
			qSave.setParam("Nom_Inter_Envoi", nom_inter_envoi);
			qSave.setParam("Prenom_Inter_Envoi", prenom_inter_envoi);
			qSave.setParam("Tel_Inter_1_Envoi", telInter1envoi);
			qSave.setParam("Tel_Inter_2_Envoi", telInter2envoi);
			qSave.setParam("Fax_Inter_Envoi", fax_inter_envoi);
			qSave.setParam("Email_Inter_Envoi", email_inter_envoi);

			var result = qSave.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				if (oea_mode=="C") {
					oea_avoirId = result.responseXML.documentElement.getAttribute("Avoir_Id");
					oea_aLignes.setParam('Avoir_Id', oea_avoirId);
					oea_chargerAvoir();
				}

				oea_setModified(false);
				save = true;
			}
		}

		return save;

	} catch (e) {
  	recup_erreur(e);
	}
}


function oea_calculTotaux() {
  try {

		if (oea_mode!='V') {
			document.getElementById('oea-Edition_TTC').disabled = (oea_aLignes.nbLignes()>0);
	    document.getElementById('oea-Code_Pays_Liv').disabled = (oea_aLignes.nbLignes()>0);
	    document.getElementById('oea-chercher_client').collapsed = (oea_aLignes.nbLignes()>0);
	    document.getElementById('oea-chercher_adrliv').disabled = (isEmpty(oea_clientId) || oea_aLignes.nbLignes()>0);
			document.getElementById('oea-bCopierFactVersLivEnvoi').disabled = (oea_aLignes.nbLignes()>0);
			document.getElementById('oea-Tarif_Id').disabled = (oea_aLignes.nbLignes()>0);
			document.getElementById("oea-Regime_TVA").disabled = (oea_aLignes.nbLignes()>0);
			document.getElementById('oea-Assujetti_TVA').disabled = (oea_aLignes.nbLignes()>0);
		}

		var remise = parseFloat(document.getElementById('oea-Remise').value);
		var remiseFP = parseFloat(document.getElementById('oea-RemiseFP').value);
		var taux_escompte = parseFloat(document.getElementById('oea-Escompte').value);
		var frais_port = parseFloat(document.getElementById('oea-Frais_Port').value);

		if (isPositiveOrNull(remise) && isPositiveOrNull(remiseFP) && isPositiveOrNull(taux_escompte) && isPositiveOrNull(frais_port)) {

			var calculDocument = new CalculDocument();
			calculDocument.setEditionTTC(oea_editionTTC);
			if (oea_typeRemise=='P') { calculDocument.setRemiseP(remise); }
			else { calculDocument.setRemiseM(remise); }
			calculDocument.setFraisPortBruts(frais_port);
			if (oea_typeRemiseFP=='P') { calculDocument.setRemiseFPP(remiseFP); }
			else { calculDocument.setRemiseFPM(remiseFP); }
			calculDocument.setCodeAndTauxTVAFP(document.getElementById('oea-codeTVAFraisPort').value, getTva(document.getElementById('oea-codeTVAFraisPort').value));
			calculDocument.setEscompteP(taux_escompte);

			for (var i=0; i<oea_aLignes.nbLignes(); i++) {
				if (oea_aLignes.getCellText(i,'oea-colTypeLigne')!="C") {
					var montantLigne = oea_aLignes.getCellText(i,'oea-ColTotal');
					var codeTVA = oea_aLignes.getCellText(i,'oea-ColCode_TVA');
					calculDocument.addLigneDocument(montantLigne, codeTVA);
				}
			}

			calculDocument.calculer();

			if (oea_editionTTC) {
				document.getElementById('oea-pttcMontantRemise').value = calculDocument.getRemiseM();
				document.getElementById('oea-pttcMontantFrais_Port').value = calculDocument.getFraisPortBruts();
				document.getElementById('oea-pttcMontantRemiseFP').value = calculDocument.getRemiseFPM();
				document.getElementById('oea-pttcTVA').value = calculDocument.getTotalTVA();
				document.getElementById('oea-pttcMontantTTC').value = calculDocument.getMontantTTC();
				document.getElementById('oea-pttcMontantEscompte').value = calculDocument.getEscompteM();
				document.getElementById('oea-pttcNetCommercial').value = calculDocument.getNetCommercial();
				document.getElementById('oea-pttcTotalTTC').value = calculDocument.getTotalTTC();
				document.getElementById('oea-pttcNetTTC').value = calculDocument.getNetAPayer();

				oea_montantTTC = calculDocument.getMontantTTCSansFormat();

				document.getElementById('oea-rowRemiseTTC').collapsed = !calculDocument.afficherRemiseM();
				document.getElementById('oea-rowRemiseFPTTC').collapsed = !calculDocument.afficherRemiseFPM();
				document.getElementById('oea-rowNetCommercialTTC').collapsed = !calculDocument.afficherNetCommercial();
				document.getElementById('oea-rowEscompteTTC').collapsed = !calculDocument.afficherEscompteM();
			}
			else {
				document.getElementById('oea-MontantHT').value = calculDocument.getMontantHT();
				document.getElementById('oea-MontantRemise').value = calculDocument.getRemiseM();
				document.getElementById('oea-MontantFrais_Port').value = calculDocument.getFraisPortBruts();
				document.getElementById('oea-MontantRemiseFP').value = calculDocument.getRemiseFPM();
				document.getElementById('oea-TotalHT').value = calculDocument.getTotalHT();
				document.getElementById('oea-TVA').value = calculDocument.getTotalTVA();
				document.getElementById('oea-MontantEscompte').value = calculDocument.getEscompteM();
				document.getElementById('oea-NetCommercial').value = calculDocument.getNetCommercial();
				document.getElementById('oea-TotalTTC').value = calculDocument.getTotalTTC();

				oea_montantHT = calculDocument.getMontantHTSansFormat();

				document.getElementById('oea-rowRemiseHT').collapsed = !calculDocument.afficherRemiseM();
				document.getElementById('oea-rowRemiseFPHT').collapsed = !calculDocument.afficherRemiseFPM();
				document.getElementById('oea-rowNetCommercialHT').collapsed = !calculDocument.afficherNetCommercial();
				document.getElementById('oea-rowEscompteHT').collapsed = !calculDocument.afficherEscompteM();
			}
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oea_afterRefreshArticles() {
	try {

		if (oea_toSelectLigne!=null) {
			for (var i=0; i<oea_aLignes.nbLignes(); i++) {
				if (oea_aLignes.getCellText(i, "oea-colLigneId")==oea_toSelectLigne && oea_aLignes.getCellText(i, "oea-colTypeLigne")!="C") {
					oea_aLignes.select(i);
					break;
				}
			}
			oea_toSelectLigne = null;
		}
		oea_aLignes.ensureRowIsVisible(oea_currentIndex);

		document.getElementById('oea-Reference').focus();
		oea_calculTotaux();

	} catch (e) {
  	recup_erreur(e);
	}
}


function oea_demandeEnregistrement() {
  try {

		if (oea_modified) {
			if (window.confirm("Voulez-vous enregistrer les modifications apport\u00E9es \u00E0 l'avoir ?")) {
				oea_enregistrerAvoir();
			}
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oea_setModified(m) {
  try {

		oea_modified = m;
		if (m) {
			document.getElementById('oea-tabAvoir').setAttribute('image', 'chrome://opensi/content/design/icones/modified.png');
			document.getElementById('oea-bApercu').disabled = true;
			document.getElementById('oea-bValiderAvoir').disabled = true;
			document.getElementById('oea-bVisualiser').disabled = true;
		}
		else {
			document.getElementById('oea-tabAvoir').setAttribute('image', null);
			document.getElementById('oea-bApercu').disabled = (oea_mode=="C");
			document.getElementById('oea-bValiderAvoir').disabled = (oea_mode=="C");
			document.getElementById('oea-bVisualiser').disabled = (oea_mode=="C");
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oea_debloquerInterface() {
	try {

		document.getElementById('oea-Secteur').disabled = (oea_mode=='V');
		document.getElementById('oea-modeEnvoiAvoir').disabled = (oea_mode=='V');
		document.getElementById('oea-etablissement').disabled = (oea_mode=='V');
		document.getElementById('oea-chkIncrementerStock').disabled = (oea_mode=='V');
		document.getElementById('oea-depot').disabled = (oea_mode=='V');
		document.getElementById('oea-Login_Resp').disabled = (oea_mode=='V');
		document.getElementById('oea-Assujetti_TVA').disabled = (oea_mode=='V');
		document.getElementById('oea-Regime_TVA').disabled = (oea_mode=='V');
		document.getElementById('oea-Edition_TTC').disabled = (oea_mode=='V');
		document.getElementById('oea-bCopierFactVersLivEnvoi').disabled = (oea_mode=='V');
		document.getElementById('oea-Tarif_Id').disabled = (oea_mode=='V');

		if (oea_mode=="V") {
			document.getElementById('oea-Denomination_Fact').setAttribute('readonly', true);
			document.getElementById('oea-chercher_client').setAttribute('readonly', true);
			document.getElementById('oea-Adresse_1_Fact').setAttribute('readonly', true);
			document.getElementById('oea-Adresse_2_Fact').setAttribute('readonly', true);
			document.getElementById('oea-Adresse_3_Fact').setAttribute('readonly', true);
			document.getElementById('oea-Code_Postal_Fact').setAttribute('readonly', true);
			document.getElementById('oea-Ville_Fact').setAttribute('readonly', true);
			document.getElementById('oea-Code_Pays_Fact').disabled = true;
			document.getElementById('oea-Civ_Inter_Fact').disabled = true;
			document.getElementById('oea-Nom_Inter_Fact').setAttribute('readonly', true);
			document.getElementById('oea-Prenom_Inter_Fact').setAttribute('readonly', true);
			document.getElementById('oea-Tel_Inter_1_Fact').setAttribute('readonly', true);
			document.getElementById('oea-Tel_Inter_2_Fact').setAttribute('readonly', true);
			document.getElementById('oea-Fax_Inter_Fact').setAttribute('readonly', true);
			document.getElementById('oea-Email_Inter_Fact').setAttribute('readonly', true);

			document.getElementById('oea-Denomination_Liv').setAttribute('readonly', true);
			document.getElementById('oea-Adresse_1_Liv').setAttribute('readonly', true);
			document.getElementById('oea-Adresse_2_Liv').setAttribute('readonly', true);
			document.getElementById('oea-Adresse_3_Liv').setAttribute('readonly', true);
			document.getElementById('oea-Code_Postal_Liv').setAttribute('readonly', true);
			document.getElementById('oea-Ville_Liv').setAttribute('readonly', true);
			document.getElementById('oea-Code_Pays_Liv').disabled = true;
			document.getElementById('oea-Civ_Inter_Liv').disabled = true;
			document.getElementById('oea-Nom_Inter_Liv').setAttribute('readonly', true);
			document.getElementById('oea-Prenom_Inter_Liv').setAttribute('readonly', true);
			document.getElementById('oea-Tel_Inter_1_Liv').setAttribute('readonly', true);
			document.getElementById('oea-Tel_Inter_2_Liv').setAttribute('readonly', true);
			document.getElementById('oea-Fax_Inter_Liv').setAttribute('readonly', true);
			document.getElementById('oea-Email_Inter_Liv').setAttribute('readonly', true);

			document.getElementById('oea-Denomination_Envoi').setAttribute('readonly', true);
			document.getElementById('oea-Adresse_1_Envoi').setAttribute('readonly', true);
			document.getElementById('oea-Adresse_2_Envoi').setAttribute('readonly', true);
			document.getElementById('oea-Adresse_3_Envoi').setAttribute('readonly', true);
			document.getElementById('oea-Code_Postal_Envoi').setAttribute('readonly', true);
			document.getElementById('oea-Ville_Envoi').setAttribute('readonly', true);
			document.getElementById('oea-Code_Pays_Envoi').disabled = true;
			document.getElementById('oea-Civ_Inter_Envoi').disabled = true;
			document.getElementById('oea-Nom_Inter_Envoi').setAttribute('readonly', true);
			document.getElementById('oea-Prenom_Inter_Envoi').setAttribute('readonly', true);
			document.getElementById('oea-Tel_Inter_1_Envoi').setAttribute('readonly', true);
			document.getElementById('oea-Tel_Inter_2_Envoi').setAttribute('readonly', true);
			document.getElementById('oea-Fax_Inter_Envoi').setAttribute('readonly', true);
			document.getElementById('oea-Email_Inter_Envoi').setAttribute('readonly', true);
		}
		else {
			document.getElementById('oea-Denomination_Fact').removeAttribute('readonly');
			document.getElementById('oea-chercher_client').removeAttribute('readonly');
			document.getElementById('oea-Adresse_1_Fact').removeAttribute('readonly');
			document.getElementById('oea-Adresse_2_Fact').removeAttribute('readonly');
			document.getElementById('oea-Adresse_3_Fact').removeAttribute('readonly');
			document.getElementById('oea-Code_Postal_Fact').removeAttribute('readonly');
			document.getElementById('oea-Ville_Fact').removeAttribute('readonly');
			document.getElementById('oea-Code_Pays_Fact').disabled = false;
			document.getElementById('oea-Civ_Inter_Fact').disabled = false;
			document.getElementById('oea-Nom_Inter_Fact').removeAttribute('readonly');
			document.getElementById('oea-Prenom_Inter_Fact').removeAttribute('readonly');
			document.getElementById('oea-Tel_Inter_1_Fact').removeAttribute('readonly');
			document.getElementById('oea-Tel_Inter_2_Fact').removeAttribute('readonly');
			document.getElementById('oea-Fax_Inter_Fact').removeAttribute('readonly');
			document.getElementById('oea-Email_Inter_Fact').removeAttribute('readonly');

			document.getElementById('oea-Denomination_Liv').removeAttribute('readonly');
			document.getElementById('oea-Adresse_1_Liv').removeAttribute('readonly');
			document.getElementById('oea-Adresse_2_Liv').removeAttribute('readonly');
			document.getElementById('oea-Adresse_3_Liv').removeAttribute('readonly');
			document.getElementById('oea-Code_Postal_Liv').removeAttribute('readonly');
			document.getElementById('oea-Ville_Liv').removeAttribute('readonly');
			document.getElementById('oea-Code_Pays_Liv').disabled = false;
			document.getElementById('oea-Civ_Inter_Liv').disabled = false;
			document.getElementById('oea-Nom_Inter_Liv').removeAttribute('readonly');
			document.getElementById('oea-Prenom_Inter_Liv').removeAttribute('readonly');
			document.getElementById('oea-Tel_Inter_1_Liv').removeAttribute('readonly');
			document.getElementById('oea-Tel_Inter_2_Liv').removeAttribute('readonly');
			document.getElementById('oea-Fax_Inter_Liv').removeAttribute('readonly');
			document.getElementById('oea-Email_Inter_Liv').removeAttribute('readonly');

			document.getElementById('oea-Denomination_Envoi').removeAttribute('readonly');
			document.getElementById('oea-Adresse_1_Envoi').removeAttribute('readonly');
			document.getElementById('oea-Adresse_2_Envoi').removeAttribute('readonly');
			document.getElementById('oea-Adresse_3_Envoi').removeAttribute('readonly');
			document.getElementById('oea-Code_Postal_Envoi').removeAttribute('readonly');
			document.getElementById('oea-Ville_Envoi').removeAttribute('readonly');
			document.getElementById('oea-Code_Pays_Envoi').disabled = false;
			document.getElementById('oea-Civ_Inter_Envoi').disabled = false;
			document.getElementById('oea-Nom_Inter_Envoi').removeAttribute('readonly');
			document.getElementById('oea-Prenom_Inter_Envoi').removeAttribute('readonly');
			document.getElementById('oea-Tel_Inter_1_Envoi').removeAttribute('readonly');
			document.getElementById('oea-Tel_Inter_2_Envoi').removeAttribute('readonly');
			document.getElementById('oea-Fax_Inter_Envoi').removeAttribute('readonly');
			document.getElementById('oea-Email_Inter_Envoi').removeAttribute('readonly');
		}

		document.getElementById('oea-Code_Stats').disabled = (oea_mode=='V');
		document.getElementById('oea-Reference').disabled = (oea_mode=='V');
		document.getElementById('oea-Designation').disabled = (oea_mode=='V');
		document.getElementById('oea-Num_Lot').disabled =true;
		document.getElementById('oea-Nb_Pieces').disabled = (oea_mode=='V');
		document.getElementById('oea-Quantite').disabled = (oea_mode=='V');
		document.getElementById('oea-Unite').disabled = (oea_mode=='V');
		document.getElementById('oea-Date_Peremption').disabled =true;
		document.getElementById('oea-PU').disabled = (oea_mode=='V' || !oea_modifElemFin);
		document.getElementById('oea-Ristourne').disabled = (oea_mode=='V' || !oea_modifElemFin);
		document.getElementById('oea-bRistourne').disabled = (oea_mode=='V' || !oea_modifElemFin);
		document.getElementById('oea-Code_TVA').disabled = (oea_mode=='V' || !oea_modifElemFin);
		document.getElementById('oea-bArticle').disabled = (oea_mode=='V');
		document.getElementById('oea-bAnnuler').disabled = (oea_mode=='V');
		document.getElementById('oea-bValider').disabled = (oea_mode=='V');
		document.getElementById('oea-Commentaires_Fin').disabled = (oea_mode=='V');
		document.getElementById('oea-Commentaires_Int').disabled = (oea_mode=='V');
		document.getElementById('oea-bChoisirMentions').disabled = (oea_mode=='V');
		document.getElementById('oea-bRemise').disabled = (oea_mode=='V' || !oea_modifElemFin);
		document.getElementById('oea-Remise').disabled = (oea_mode=='V' || !oea_modifElemFin);
		document.getElementById('oea-Frais_Port').disabled = (oea_mode=='V' || !oea_modifElemFin);
		document.getElementById('oea-codeTVAFraisPort').disabled = (oea_mode=='V' || !oea_modifElemFin);
		document.getElementById('oea-bRemiseFP').disabled = (oea_mode=='V' || !oea_modifElemFin);
		document.getElementById('oea-RemiseFP').disabled = (oea_mode=='V' || !oea_modifElemFin);
		document.getElementById('oea-Escompte').disabled = (oea_mode=='V' || !oea_modifElemFin);
		document.getElementById('oea-bEnregistrer').disabled = false;

	} catch (e) {
		recup_erreur(e);
	}
}


function oea_nouvelAvoir() {
  try {

		oea_avoirId = "";
		oea_mode = "C";
		oea_gen = false;
		document.getElementById('oea-deckAvoir').selectedIndex = 0;
		document.getElementById('oea-tabEntete').selectedIndex = 0;
		document.getElementById('oea-tabAdresses').selectedIndex = 0;

		var venteTTC = gConfig.isVenteTTC();

		document.getElementById('oea-Edition_TTC').checked = venteTTC;
		oea_changerTypeEdition(venteTTC);

		document.getElementById('oea-tabVersionDocument').collapsed = true;

		oea_assujettiTVA = false;
		oea_codesTvaInactifs = "";
		oea_codeTVAPort = "";

		document.getElementById('oea-Assujetti_TVA').checked = false;
		document.getElementById('oea-Num_TVA').value = "";
		oea_chargerTarifsVente(gConfig.getTarifDefaut());
		document.getElementById("oea-Regime_TVA").value = "G";
		oea_chargerPolesActivite("");

		document.getElementById('oea-modeEnvoiAvoir').value = gConfig.getDefModeEnvoiFacture();
		oea_chargerEtablissement(etablissementDefaut);
		oea_chargerDepot(oea_depotDefaut);
		document.getElementById('oea-chkIncrementerStock').checked = true;
		document.getElementById('oea-rowDepot').collapsed = false;

		document.getElementById('oea-Commentaires_Fin').value = "";
		document.getElementById('oea-Commentaires_Int').value = "";
		document.getElementById('oea-Date_Avoir').value = "";
		document.getElementById('oea-Numero').value = "";
		document.getElementById('oea-refAvoirWeb').value = "";
		document.getElementById('oea-rowRefAvoirWeb').collapsed = true;

		document.getElementById('oea-Remise').value = "0.00";
		document.getElementById('oea-Escompte').value = "0.00";
		document.getElementById('oea-Frais_Port').value = "0.00";
		document.getElementById('oea-RemiseFP').value = "0.00";

		document.getElementById('oea-Denomination_Fact').value = "";
		document.getElementById('oea-Adresse_1_Fact').value = "";
		document.getElementById('oea-Adresse_2_Fact').value = "";
		document.getElementById('oea-Adresse_3_Fact').value = "";
		document.getElementById('oea-Code_Postal_Fact').value = "";
		document.getElementById('oea-Ville_Fact').value = "";
		document.getElementById('oea-Code_Pays_Fact').value = "FR";

		document.getElementById('oea-Civ_Inter_Fact').selectedIndex = 0;
		document.getElementById('oea-Nom_Inter_Fact').value = "";
		document.getElementById('oea-Prenom_Inter_Fact').value = "";
		document.getElementById('oea-Tel_Inter_1_Fact').value = "";
		document.getElementById('oea-Tel_Inter_2_Fact').value = "";
		document.getElementById('oea-Fax_Inter_Fact').value = "";
		document.getElementById('oea-Email_Inter_Fact').value = "";

		document.getElementById('oea-Denomination_Liv').value = "";
		document.getElementById('oea-Adresse_1_Liv').value = "";
		document.getElementById('oea-Adresse_2_Liv').value = "";
		document.getElementById('oea-Adresse_3_Liv').value = "";
		document.getElementById('oea-Code_Postal_Liv').value = "";
		document.getElementById('oea-Ville_Liv').value = "";
		document.getElementById('oea-Code_Pays_Liv').value = "FR";
		oea_listeTVAFraisPort();
		oea_selectPaysLiv();

		document.getElementById('oea-Civ_Inter_Liv').selectedIndex = 0;
		document.getElementById('oea-Nom_Inter_Liv').value = "";
		document.getElementById('oea-Prenom_Inter_Liv').value = "";
		document.getElementById('oea-Tel_Inter_1_Liv').value = "";
		document.getElementById('oea-Tel_Inter_2_Liv').value = "";
		document.getElementById('oea-Fax_Inter_Liv').value = "";
		document.getElementById('oea-Email_Inter_Liv').value = "";

		document.getElementById('oea-Denomination_Envoi').value = "";
		document.getElementById('oea-Adresse_1_Envoi').value = "";
		document.getElementById('oea-Adresse_2_Envoi').value = "";
		document.getElementById('oea-Adresse_3_Envoi').value = "";
		document.getElementById('oea-Code_Postal_Envoi').value = "";
		document.getElementById('oea-Ville_Envoi').value = "";
		document.getElementById('oea-Code_Pays_Envoi').value = "FR";

		document.getElementById('oea-Civ_Inter_Envoi').selectedIndex = 0;
		document.getElementById('oea-Nom_Inter_Envoi').value = "";
		document.getElementById('oea-Prenom_Inter_Envoi').value = "";
		document.getElementById('oea-Tel_Inter_1_Envoi').value = "";
		document.getElementById('oea-Tel_Inter_2_Envoi').value = "";
		document.getElementById('oea-Fax_Inter_Envoi').value = "";
		document.getElementById('oea-Email_Inter_Envoi').value = "";

		document.getElementById('oea-MontantHT').value = "0.00";
		document.getElementById('oea-MontantRemise').value = "0.00";
		document.getElementById('oea-MontantFrais_Port').value = "0.00";
		document.getElementById('oea-MontantRemiseFP').value = "0.00";
		document.getElementById('oea-TotalHT').value = "0.00";
		document.getElementById('oea-TVA').value = "0.00";
		document.getElementById('oea-MontantEscompte').value = "0.00";
		document.getElementById('oea-TotalTTC').value = "0.00";

		document.getElementById('oea-rowRemiseHT').collapsed = true;
		document.getElementById('oea-rowRemiseFPHT').collapsed = true;
		document.getElementById('oea-rowEscompteHT').collapsed = true;

		document.getElementById('oea-pttcMontantRemise').value = "0.00";
		document.getElementById('oea-pttcMontantFrais_Port').value = "0.00";
		document.getElementById('oea-pttcMontantRemiseFP').value = "0.00";
		document.getElementById('oea-pttcTVA').value = "0.00";
		document.getElementById('oea-pttcMontantTTC').value = "0.00";
		document.getElementById('oea-pttcMontantEscompte').value = "0.00";
		document.getElementById('oea-pttcTotalTTC').value = "0.00";
		document.getElementById('oea-pttcNetTTC').value = "0.00";

		document.getElementById('oea-rowNetCommercialHT').collapsed = true;
		document.getElementById('oea-rowEscompteTTC').collapsed = true;
		document.getElementById('oea-pttcNetCommercial').value = "0.00";
		document.getElementById('oea-NetCommercial').value = "0.00";

		oea_montantHT=0;
		oea_montantTTC=0;

		document.getElementById('oea-rowRemiseTTC').collapsed = true;
		document.getElementById('oea-rowRemiseFPTTC').collapsed = true;
		document.getElementById('oea-rowEscompteTTC').collapsed = true;

		document.getElementById('oea-creation').setAttribute("label", "");
		document.getElementById('oea-modification').setAttribute("label", "");
		document.getElementById('oea-document').setAttribute("label", "");

    oea_chargerResponsables(gProfil.getLoggedUser());
		document.getElementById('oea-numClient').value = "";
		oea_clientId = "";

		document.getElementById('oea-bApercu').collapsed = true;
		document.getElementById('oea-bValiderAvoir').collapsed = true;
		document.getElementById('oea-bEnregistrer').collapsed = false;
		document.getElementById('oea-bSupAvoir').collapsed = true;
		document.getElementById('oea-bVisualiser').collapsed = true;
		document.getElementById('oea-chercher_client').collapsed = false;

		oea_ajouterLigne("I");
		oea_typeRistourne = 'P';
		document.getElementById('oea-bRistourne').setAttribute("class", "bIcoPourcentage");
		oea_aLignes.deleteTree();

		oea_debloquerInterface();

		document.getElementById('oea-bChoisirMentions').disabled = true;
		document.getElementById('oea-bOuvrirCommentairesCaches').disabled = true;
		document.getElementById('oea-chercher_adrfact').disabled = true;
		document.getElementById('oea-chercher_inter').disabled = true;
		document.getElementById('oea-chercher_adrliv').disabled = true;
		document.getElementById('oea-chercher_inter_liv').disabled = true;
		document.getElementById('oea-chercher_adrenvoi').disabled = true;
		document.getElementById('oea-chercher_inter_envoi').disabled = true;

		oea_setModified(false);

	} catch (e) {
  	recup_erreur(e);
  }
}


function oea_chargerAvoir() {
  try {

		oea_mode = "M";
		document.getElementById('oea-deckAvoir').selectedIndex = 0;
		document.getElementById('oea-tabEntete').selectedIndex = 0;
		document.getElementById('oea-tabAdresses').selectedIndex = 0;

		var qLoad = new QueryHttp("Facturation/Avoirs/loadAvoirClient.tmpl");
		qLoad.setParam("Avoir_Id", oea_avoirId);
		var result = qLoad.execute();

		var contenu = result.responseXML.documentElement;

		oea_gen = contenu.getAttribute('Statut')=="V";

		if (oea_gen) {
			oea_mode = "V";
		}

		document.getElementById('oea-bApercu').collapsed = oea_gen;
		document.getElementById('oea-bValiderAvoir').collapsed = oea_gen;
		document.getElementById('oea-bEnregistrer').collapsed = oea_gen;
		document.getElementById('oea-bSupAvoir').collapsed = oea_gen;
		document.getElementById('oea-bVisualiser').collapsed = !oea_gen;

		document.getElementById('oea-modeEnvoiAvoir').value = contenu.getAttribute('Mode_Envoi_Avoir');

		oea_typeRemise = (parseFloat(contenu.getAttribute('MRemise'))!=0?'M':'P');
		document.getElementById('oea-Remise').value = (oea_typeRemise=='P'?contenu.getAttribute('PRemise'):contenu.getAttribute('MRemise'));
		document.getElementById('oea-bRemise').setAttribute("class", (oea_typeRemise=='P'?"bIcoPourcentage":"bIcoEuro"));

		oea_typeRemiseFP = (parseFloat(contenu.getAttribute('MRemise_FP'))!=0?'M':'P');
		document.getElementById('oea-RemiseFP').value = (oea_typeRemiseFP=='P'?contenu.getAttribute('PRemise_FP'):contenu.getAttribute('MRemise_FP'));
		document.getElementById('oea-bRemiseFP').setAttribute("class", (oea_typeRemiseFP=='P'?"bIcoPourcentage":"bIcoEuro"));

    document.getElementById('oea-Escompte').value = contenu.getAttribute('Escompte');
    document.getElementById('oea-Frais_Port').value = contenu.getAttribute('Frais_Port');
		document.getElementById('oea-Commentaires_Fin').value = contenu.getAttribute('Commentaires_Fin');
		document.getElementById('oea-Commentaires_Int').value = contenu.getAttribute('Commentaires_Int');
		document.getElementById('oea-Date_Avoir').value = contenu.getAttribute('Date_Avoir');
		document.getElementById('oea-Numero').value = contenu.getAttribute('Num_Avoir');
		var refAvoirWeb = contenu.getAttribute("Ref_Avoir_Web");
		document.getElementById('oea-refAvoirWeb').value = refAvoirWeb;
		document.getElementById('oea-rowRefAvoirWeb').collapsed = isEmpty(refAvoirWeb);
		oea_chargerPolesActivite(contenu.getAttribute('Pole_Activite'));
		oea_chargerEtablissement(contenu.getAttribute('Etab_Id'));
		var depotId = contenu.getAttribute('Depot_Id');
    if (isEmpty(depotId)) { oea_chargerDepot(oea_depotDefaut); }
    else { oea_chargerDepot(depotId); }
		document.getElementById('oea-chkIncrementerStock').checked = !isEmpty(depotId);
		document.getElementById('oea-rowDepot').collapsed = isEmpty(depotId);

		document.getElementById('oea-Denomination_Fact').value = contenu.getAttribute('Denomination');
		document.getElementById('oea-Adresse_1_Fact').value = contenu.getAttribute('Adresse_1');
		document.getElementById('oea-Adresse_2_Fact').value = contenu.getAttribute('Adresse_2');
		document.getElementById('oea-Adresse_3_Fact').value = contenu.getAttribute('Adresse_3');
		document.getElementById('oea-Code_Postal_Fact').value = contenu.getAttribute('Code_Postal');
		document.getElementById('oea-Ville_Fact').value = contenu.getAttribute('Ville');
		document.getElementById('oea-Code_Pays_Fact').value = contenu.getAttribute('Code_Pays');

		document.getElementById('oea-Denomination_Liv').value = contenu.getAttribute('Denomination_Liv');
		document.getElementById('oea-Adresse_1_Liv').value = contenu.getAttribute('Adresse_1_Liv');
		document.getElementById('oea-Adresse_2_Liv').value = contenu.getAttribute('Adresse_2_Liv');
		document.getElementById('oea-Adresse_3_Liv').value = contenu.getAttribute('Adresse_3_Liv');
		document.getElementById('oea-Code_Postal_Liv').value = contenu.getAttribute('Code_Postal_Liv');
		document.getElementById('oea-Ville_Liv').value = contenu.getAttribute('Ville_Liv');
		document.getElementById('oea-Code_Pays_Liv').value = contenu.getAttribute('Code_Pays_Liv');

		document.getElementById('oea-Civ_Inter_Fact').value = contenu.getAttribute('Civ_Inter');
		document.getElementById('oea-Nom_Inter_Fact').value = contenu.getAttribute('Nom_Inter');
		document.getElementById('oea-Prenom_Inter_Fact').value = contenu.getAttribute('Prenom_Inter');
		document.getElementById('oea-Tel_Inter_1_Fact').value = contenu.getAttribute('Tel_Inter_1');
		document.getElementById('oea-Tel_Inter_2_Fact').value = contenu.getAttribute('Tel_Inter_2');
		document.getElementById('oea-Fax_Inter_Fact').value = contenu.getAttribute('Fax_Inter');
		document.getElementById('oea-Email_Inter_Fact').value = contenu.getAttribute('Email_Inter');

		document.getElementById('oea-Civ_Inter_Liv').value = contenu.getAttribute('Civ_Inter_Liv');
		document.getElementById('oea-Nom_Inter_Liv').value = contenu.getAttribute('Nom_Inter_Liv');
		document.getElementById('oea-Prenom_Inter_Liv').value = contenu.getAttribute('Prenom_Inter_Liv');
		document.getElementById('oea-Tel_Inter_1_Liv').value = contenu.getAttribute('Tel_Inter_1_Liv');
		document.getElementById('oea-Tel_Inter_2_Liv').value = contenu.getAttribute('Tel_Inter_2_Liv');
		document.getElementById('oea-Fax_Inter_Liv').value = contenu.getAttribute('Fax_Inter_Liv');
		document.getElementById('oea-Email_Inter_Liv').value = contenu.getAttribute('Email_Inter_Liv');

		document.getElementById('oea-Denomination_Envoi').value = contenu.getAttribute('Denomination_Envoi');
		document.getElementById('oea-Adresse_1_Envoi').value = contenu.getAttribute('Adresse_1_Envoi');
		document.getElementById('oea-Adresse_2_Envoi').value = contenu.getAttribute('Adresse_2_Envoi');
		document.getElementById('oea-Adresse_3_Envoi').value = contenu.getAttribute('Adresse_3_Envoi');
		document.getElementById('oea-Code_Postal_Envoi').value = contenu.getAttribute('Code_Postal_Envoi');
		document.getElementById('oea-Ville_Envoi').value = contenu.getAttribute('Ville_Envoi');
		document.getElementById('oea-Code_Pays_Envoi').value = contenu.getAttribute('Code_Pays_Envoi');

		document.getElementById('oea-Civ_Inter_Envoi').value = contenu.getAttribute('Civ_Inter_Envoi');
		document.getElementById('oea-Nom_Inter_Envoi').value = contenu.getAttribute('Nom_Inter_Envoi');
		document.getElementById('oea-Prenom_Inter_Envoi').value = contenu.getAttribute('Prenom_Inter_Envoi');
		document.getElementById('oea-Tel_Inter_1_Envoi').value = contenu.getAttribute('Tel_Inter_1_Envoi');
		document.getElementById('oea-Tel_Inter_2_Envoi').value = contenu.getAttribute('Tel_Inter_2_Envoi');
		document.getElementById('oea-Fax_Inter_Envoi').value = contenu.getAttribute('Fax_Inter_Envoi');
		document.getElementById('oea-Email_Inter_Envoi').value = contenu.getAttribute('Email_Inter_Envoi');

		oea_chargerTarifsVente(contenu.getAttribute('Tarif_Id'));
		document.getElementById("oea-Regime_TVA").value = contenu.getAttribute('Regime_TVA');
		oea_codeTVAPort = contenu.getAttribute('Code_TVA_Port');
		oea_tauxTVAPort = contenu.getAttribute('Taux_TVA_Port');
    oea_assujettiTVA = (contenu.getAttribute('Assujetti_TVA')=="true");
		oea_codesTvaInactifs = contenu.getAttribute('Codes_TVA_Inactifs');

		var typeEdition = (contenu.getAttribute('Edition_TTC')=="true");

		document.getElementById('oea-Edition_TTC').checked = typeEdition;

		document.getElementById('oea-Assujetti_TVA').checked = oea_assujettiTVA;
		document.getElementById('oea-Num_TVA').value = contenu.getAttribute("Num_TVA_Intra");

		oea_clientId = contenu.getAttribute('Client_Id');
		var client_connu = !isEmpty(oea_clientId);

		document.getElementById('oea-numClient').value = contenu.getAttribute('Num_Client');

		oea_chargerResponsables(contenu.getAttribute('Util_R'));

		document.getElementById('oea-creation').label = "Avoir cr\u00E9\u00E9 le "+ contenu.getAttribute('Date_Creation') + " par "+ contenu.getAttribute('Login_Createur');
		document.getElementById('oea-modification').label = "Derni\u00E8re modification le "+ contenu.getAttribute('Date_Maj') +" par "+ contenu.getAttribute('Login_Maj');
		document.getElementById('oea-document').label = "Avoir N\u00B0 "+ contenu.getAttribute('Num_Avoir');

		document.getElementById('oea-tabVersionDocument').collapsed = false;
    oea_initVersion();

		oea_setModified(false);

		document.getElementById('oea-Num_TVA').disabled = !oea_assujettiTVA || oea_mode=='V';
		document.getElementById('oea-chercher_adrfact').disabled = !client_connu || oea_mode=='V';
		document.getElementById('oea-chercher_inter').disabled = !client_connu || oea_mode=='V';
		document.getElementById('oea-chercher_adrliv').disabled = !client_connu || oea_mode=='V';
		document.getElementById('oea-chercher_inter_liv').disabled = !client_connu || oea_mode=='V';
		document.getElementById('oea-chercher_adrenvoi').disabled = !client_connu || oea_mode=='V';
		document.getElementById('oea-chercher_inter_envoi').disabled = !client_connu || oea_mode=='V';

		if (oea_mode!="V") {
			oea_ajouterLigne("I");
		}
		else {
			oea_formatLigne("");
		}

		oea_debloquerInterface();

		if (oea_mode!="V") {
			// impratif aprs l'appel  oea_debloquerInterface()
			document.getElementById('oea-chkIncrementerStock').disabled = (contenu.getAttribute('Direct')=="false");
		}

		document.getElementById('oea-bAjouterLigne').disabled = true;
		document.getElementById('oea-bOuvrirCommentairesCaches').disabled = false;

		oea_changerTypeEdition(typeEdition);

		oea_aLignes.setParam('Avoir_Id', oea_avoirId);
		oea_aLignes.initTree(oea_chargerAvoir2);

	} catch (e) {
    recup_erreur(e);
  }
}


function oea_chargerAvoir2() {
  try {

		oea_aCodesTVAFraisPort.setParam("Code_Pays", document.getElementById("oea-Code_Pays_Liv").value);
		oea_aCodesTVAFraisPort.setParam("Regime_TVA", document.getElementById("oea-Regime_TVA").value);
		oea_aCodesTVAFraisPort.setParam("Assujetti_TVA", oea_assujettiTVA);
		oea_aCodesTVAFraisPort.setParam("Selection", oea_codeTVAPort);
		oea_aCodesTVAFraisPort.initTree(oea_selectionTvaPort);

	} catch (e) {
    recup_erreur(e);
  }
}


function oea_selectionTvaPort() {
  try {
   	document.getElementById('oea-codeTVAFraisPort').value = oea_codeTVAPort;
		oea_tauxTVAPort = getTva(oea_codeTVAPort);
		oea_selectPaysLiv();

  } catch (e) {
    recup_erreur(e);
  }
}


function oea_editerAvoir() {
  try {

		var montantBase = (oea_editionTTC?oea_montantTTC:oea_montantHT);
		var remise = document.getElementById('oea-Remise').value;
		var frais_port = document.getElementById('oea-Frais_Port').value;

		if ((oea_aLignes.nbLignes()<=0) && frais_port==0) {
			showWarning("L'avoir ne contient aucune ligne");
		}
		else if (isEmpty(remise) || (oea_typeRemise=='P'?!isTaux(remise):!isPositiveOrNull(remise) || !checkNumber(remise,9,2) || parseFloat(remise)>montantBase)) {
			showWarning("Remise incorrecte !");
		}
		else {
			var ok = true;
			if (oea_actSuiviSerie && !oea_gen) {
				var qCheck = new QueryHttp("Facturation/Avoirs/checkNumSerieAC.tmpl");
				qCheck.setParam("Avoir_Id", oea_avoirId);
				var result = qCheck.execute();

				var errors = new Errors(result);
				if (errors.hasNext()) {
					errors.show();
					ok = false;
				}
			}

			if (ok && (oea_gen || window.confirm("Confirmez-vous la g\u00E9n\u00E9ration de l'avoir ?\n(Attention l'avoir g\u00E9n\u00E9r\u00E9 ne pourra plus \u00EAtre modifi\u00E9 !)"))) {
				oea_typeEditionPdf = "AC";
				oea_docIdPdf = oea_avoirId;
				oea_apercu = false;

				var qLangueDefaut = new QueryHttp("Facturation/Commun/getLangueDefaut.tmpl");
				qLangueDefaut.setParam("Type_Doc", "AC");
				qLangueDefaut.setParam("Doc_Id", oea_avoirId);
				var result = qLangueDefaut.execute();
				oea_langueDefaut = result.responseXML.documentElement.getAttribute("Langue_Id");
				oea_aLangues.setParam("Selection", oea_langueDefaut);
				oea_aLangues.initTree(oea_initLangue);
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oea_apercuAvoir() {
  try {

		var adresse_fact = document.getElementById('oea-Adresse_1_Fact').value;
    var ville_fact = document.getElementById('oea-Ville_Fact').value;
    var frais_port = document.getElementById('oea-Frais_Port').value;

		if ((oea_aLignes.nbLignes()<=0) && frais_port==0) { showWarning("L'avoir ne contient aucune ligne"); }
		else if (!oea_gen && isEmpty(adresse_fact)) { showWarning("Adresse du client manquante"); }
		else if (!oea_gen && isEmpty(ville_fact)) { showWarning("Ville du client manquante"); }
		else {
			oea_typeEditionPdf = "AC";
			oea_docIdPdf = oea_avoirId;
			oea_apercu = true;

			var qLangueDefaut = new QueryHttp("Facturation/Commun/getLangueDefaut.tmpl");
			qLangueDefaut.setParam("Type_Doc", "AC");
			qLangueDefaut.setParam("Doc_Id", oea_avoirId);
			var result = qLangueDefaut.execute();
			oea_langueDefaut = result.responseXML.documentElement.getAttribute("Langue_Id");
			oea_aLangues.setParam("Selection", oea_langueDefaut);
			oea_aLangues.initTree(oea_initLangue);
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oea_visualiserAvoir() {
  try {

		var qGenPdf = new QueryHttp("Facturation/Avoirs/pdfAvoirClient.tmpl");
		qGenPdf.setParam('Avoir_Id', oea_avoirId);
		qGenPdf.setParam('Langue_Id', document.getElementById('oea-langueDefaut').value);
		qGenPdf.setParam('Apercu', oea_apercu);

		var result = qGenPdf.execute();

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}
		else {
			document.getElementById('oea-pdfAvoir').setAttribute('src', '');
			document.getElementById('oea-deckAvoir').selectedIndex = 1;
			document.getElementById('bRetourAvoir').collapsed = false;

			var page = getDirPdf() + result.responseXML.documentElement.getAttribute('FichierPDF');
			document.getElementById('oea-pdfAvoir').setAttribute("src", page);
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oea_initLangue() {
	try {

		document.getElementById('oea-langueDefaut').value = oea_langueDefaut;
		oea_reediterPdf();

	} catch (e) {
		recup_erreur(e);
	}
}


function oea_reediterPdf() {
	try {

		oea_visualiserAvoir();

	} catch (e) {
		recup_erreur(e);
	}
}


function oea_envoyerMail() {
	try {

		var langue = document.getElementById('oea-langueDefaut').value;

		var url = "chrome://opensi/content/popup/popup-envoyerMail.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', oea_typeEditionPdf, oea_docIdPdf, langue);

	}	catch (e) {
    recup_erreur(e);
  }
}


function oea_supprimerAvoir() {
  try {

		if (window.confirm("Confirmez-vous la suppression de l'avoir ?")) {

			var qDelete = new QueryHttp("Facturation/Avoirs/deleteAvoirClient.tmpl");
			qDelete.setParam("Avoir_Id", oea_avoirId);
			var result = qDelete.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				showMessage("L'avoir a \u00E9t\u00E9 supprim\u00E9");
			}

			retourMenuFactures();
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oea_editerCommentaire() {
  try {

		if (oea_aLignes.isSelected()) {
			var ligneId = oea_aLignes.getSelectedCellText('oea-colLigneId');

			var url = "chrome://opensi/content/facturation/user/commun/popup-commentairesLigne.xul";
    	window.openDialog(url,'','chrome,modal,centerscreen', "AC", ligneId);

			oea_aLignes.initTree(oea_afterRefreshArticles);
			oea_ajouterLigne("I");
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oea_editerCommentairesInternes() {
  try {

		var url = "chrome://opensi/content/facturation/user/commun/popup-commentairesInternes.xul";
  	window.openDialog(url,'','chrome,modal,centerscreen', "AC", oea_avoirId, false);

	} catch (e) {
    recup_erreur(e);
  }
}


function oea_editerCommentairesDocument() {
  try {

		var commentairesFin = document.getElementById('oea-Commentaires_Fin').value;
		var commentairesInt = document.getElementById('oea-Commentaires_Int').value;
		var readOnly = (oea_mode=="V");

		var url = "chrome://opensi/content/facturation/user/commun/popup-commentairesDocument.xul";
  	window.openDialog(url,'','chrome,modal,centerscreen', oea_retourEditerCommentaires, "AC", oea_avoirId, commentairesFin, commentairesInt, readOnly);

	} catch (e) {
    recup_erreur(e);
  }
}


function oea_retourEditerCommentaires(commentairesFin, commentairesInt) {
  try {

		document.getElementById('oea-Commentaires_Fin').value = commentairesFin;
		document.getElementById('oea-Commentaires_Int').value = commentairesInt;

	} catch (e) {
    recup_erreur(e);
  }
}


function oea_charger_coord() {
  try {

		var qGet = new QueryHttp("Facturation/Clients/getDefautDocumentVente.tmpl");
		qGet.setParam("Client_Id", oea_clientId);
		var result = qGet.execute();

		var contenu = result.responseXML.documentElement;

		oea_chargerResponsables(contenu.getAttribute("Util_R"));
		oea_chargerTarifsVente(contenu.getAttribute("Tarif_Id"));
		document.getElementById('oea-Remise').value = contenu.getAttribute("Taux_Remise");
		document.getElementById('oea-Escompte').value = contenu.getAttribute("Taux_Escompte");
		document.getElementById('oea-bRemise').setAttribute("class", "bIcoPourcentage");
		oea_typeRemise = 'P';

		oea_assujettiTVA = contenu.getAttribute("Assujetti_TVA")=="true";
		document.getElementById('oea-Assujetti_TVA').checked = oea_assujettiTVA;
		document.getElementById('oea-Num_TVA').disabled = !oea_assujettiTVA;
		document.getElementById('oea-Num_TVA').value = contenu.getAttribute("Num_TVA_Intra");
		oea_chargerPolesActivite(contenu.getAttribute("Pole_Activite"));
		document.getElementById("oea-modeEnvoiAvoir").value = contenu.getAttribute("Mode_Envoi_Facture");
		document.getElementById("oea-Regime_TVA").value = contenu.getAttribute("Regime_TVA");

		document.getElementById('oea-numClient').value = contenu.getAttribute("Num_Client");

		document.getElementById("oea-Denomination_Fact").value = contenu.getAttribute("Denomination_Fact");
		document.getElementById("oea-Adresse_1_Fact").value = contenu.getAttribute("Adresse_1_Fact");
		document.getElementById("oea-Adresse_2_Fact").value = contenu.getAttribute("Adresse_2_Fact");
		document.getElementById("oea-Adresse_3_Fact").value = contenu.getAttribute("Adresse_3_Fact");
		document.getElementById("oea-Code_Postal_Fact").value = contenu.getAttribute("Code_Postal_Fact");
		document.getElementById("oea-Ville_Fact").value = contenu.getAttribute("Ville_Fact");
    document.getElementById("oea-Code_Pays_Fact").value = contenu.getAttribute("Code_Pays_Fact");
		document.getElementById("oea-Civ_Inter_Fact").value = contenu.getAttribute("Civ_Inter_Fact");
		document.getElementById("oea-Nom_Inter_Fact").value = contenu.getAttribute("Nom_Inter_Fact");
		document.getElementById("oea-Prenom_Inter_Fact").value = contenu.getAttribute("Prenom_Inter_Fact");
		document.getElementById("oea-Tel_Inter_1_Fact").value = contenu.getAttribute("Tel_Inter_1_Fact");
		document.getElementById("oea-Tel_Inter_2_Fact").value = contenu.getAttribute("Tel_Inter_2_Fact");
		document.getElementById("oea-Fax_Inter_Fact").value = contenu.getAttribute("Fax_Inter_Fact");
		document.getElementById("oea-Email_Inter_Fact").value = contenu.getAttribute("Email_Inter_Fact");

		document.getElementById("oea-Denomination_Liv").value = contenu.getAttribute("Denomination_Liv");
		document.getElementById("oea-Adresse_1_Liv").value = contenu.getAttribute("Adresse_1_Liv");
		document.getElementById("oea-Adresse_2_Liv").value = contenu.getAttribute("Adresse_2_Liv");
		document.getElementById("oea-Adresse_3_Liv").value = contenu.getAttribute("Adresse_3_Liv");
		document.getElementById("oea-Code_Postal_Liv").value = contenu.getAttribute("Code_Postal_Liv");
		document.getElementById("oea-Ville_Liv").value = contenu.getAttribute("Ville_Liv");
    document.getElementById("oea-Code_Pays_Liv").value = contenu.getAttribute("Code_Pays_Liv");
    document.getElementById("oea-Civ_Inter_Liv").value = contenu.getAttribute("Civ_Inter_Liv");
		document.getElementById("oea-Nom_Inter_Liv").value = contenu.getAttribute("Nom_Inter_Liv");
		document.getElementById("oea-Prenom_Inter_Liv").value = contenu.getAttribute("Prenom_Inter_Liv");
		document.getElementById("oea-Tel_Inter_1_Liv").value = contenu.getAttribute("Tel_Inter_1_Liv");
		document.getElementById("oea-Tel_Inter_2_Liv").value = contenu.getAttribute("Tel_Inter_2_Liv");
		document.getElementById("oea-Fax_Inter_Liv").value = contenu.getAttribute("Fax_Inter_Liv");
		document.getElementById("oea-Email_Inter_Liv").value = contenu.getAttribute("Email_Inter_Liv");

		document.getElementById("oea-Denomination_Envoi").value = contenu.getAttribute("Denomination_Envoi");
		document.getElementById("oea-Adresse_1_Envoi").value = contenu.getAttribute("Adresse_1_Envoi");
		document.getElementById("oea-Adresse_2_Envoi").value = contenu.getAttribute("Adresse_2_Envoi");
		document.getElementById("oea-Adresse_3_Envoi").value = contenu.getAttribute("Adresse_3_Envoi");
		document.getElementById("oea-Code_Postal_Envoi").value = contenu.getAttribute("Code_Postal_Envoi");
		document.getElementById("oea-Ville_Envoi").value = contenu.getAttribute("Ville_Envoi");
    document.getElementById("oea-Code_Pays_Envoi").value = contenu.getAttribute("Code_Pays_Envoi");
    document.getElementById("oea-Civ_Inter_Envoi").value = contenu.getAttribute("Civ_Inter_Envoi");
		document.getElementById("oea-Nom_Inter_Envoi").value = contenu.getAttribute("Nom_Inter_Envoi");
		document.getElementById("oea-Prenom_Inter_Envoi").value = contenu.getAttribute("Prenom_Inter_Envoi");
		document.getElementById("oea-Tel_Inter_1_Envoi").value = contenu.getAttribute("Tel_Inter_1_Envoi");
		document.getElementById("oea-Tel_Inter_2_Envoi").value = contenu.getAttribute("Tel_Inter_2_Envoi");
		document.getElementById("oea-Fax_Inter_Envoi").value = contenu.getAttribute("Fax_Inter_Envoi");
		document.getElementById("oea-Email_Inter_Envoi").value = contenu.getAttribute("Email_Inter_Envoi");

    oea_listeTVAFraisPort();
    oea_selectPaysLiv();

		var client_connu = !isEmpty(oea_clientId);
   	document.getElementById('oea-chercher_adrliv').disabled = (!client_connu || oea_aLignes.nbLignes()>0);
    document.getElementById('oea-bCopierFactVersLivEnvoi').disabled = (oea_aLignes.nbLignes()>0);
    document.getElementById('oea-Tarif_Id').disabled = (oea_aLignes.nbLignes()>0);
		document.getElementById('oea-chercher_adrfact').disabled = !client_connu;
		document.getElementById('oea-chercher_inter').disabled = !client_connu;
		document.getElementById('oea-chercher_inter_liv').disabled = !client_connu;
		document.getElementById('oea-chercher_adrenvoi').disabled = !client_connu;
		document.getElementById('oea-chercher_inter_envoi').disabled = !client_connu;

		oea_ajouterLigne("I");

	} catch (e) {
  	recup_erreur(e);
  }
}


function oea_rechercherClient() {
  try {

		var url = "chrome://opensi/content/facturation/user/clients/popup-rechercheClient.xul";
    window.openDialog(url,'','chrome,modal,centerscreen', oea_retourRechercherClient, true, true);

	} catch (e) {
  	recup_erreur(e);
  }
}


function oea_retourRechercherClient(numClient, clientId) {
	try {

		oea_clientId = clientId;
		oea_charger_coord();
		oea_setModified(true);

	} catch (e) {
		recup_erreur(e);
	}
}


function oea_evaluer(field, ev) {
	try {

		var val = field.value;

		if (ev.keyCode==13 && !isEmpty(val) && isArithmetic(val)) {
			field.value = calcExpr(val);
		}

	}	catch(e) {
		recup_erreur(e);
	}
}


function oea_pressOnLineNumberField(field, ev) {
	try {

		var val = field.value;

		if (ev.keyCode==13 && !isEmpty(val)) {
			if (isArithmetic(val)) {
				field.value = calcExpr(val);
			}
			else {
				oea_validerLigne();
			}
		}

	}	catch(e) {
		recup_erreur(e);
	}
}


function oea_changerTypeEdition(chgType) {
	try {

		oea_editionTTC = chgType;

		if (oea_editionTTC) {
			document.getElementById('oea-ColTotal').setAttribute("label", "Total TTC");
			document.getElementById('oea-ColPU').setAttribute("label", "P.U TTC");
			document.getElementById('oea-lblFrais_Port').value = "Frais de port (ttc) :";
			document.getElementById('oea-lblPU').value = "P.U TTC :";
			document.getElementById('oea-piedTTC').collapsed = false;
			document.getElementById('oea-piedHT').collapsed = true;
		}
		else {
			document.getElementById('oea-ColTotal').setAttribute("label", "Total HT");
			document.getElementById('oea-ColPU').setAttribute("label", "P.U HT");
			document.getElementById('oea-lblFrais_Port').value = "Frais de port (ht) :";
			document.getElementById('oea-lblPU').value = "P.U HT :";
			document.getElementById('oea-piedTTC').collapsed = true;
			document.getElementById('oea-piedHT').collapsed = false;
		}

	}	catch(e) {
		recup_erreur(e);
	}
}


function oea_changerAssujettiTVA(etat) {
	try {

		oea_assujettiTVA = etat;
		document.getElementById('oea-Num_TVA').disabled =!oea_assujettiTVA;
		oea_listeTVA();
		oea_setModified(true);

	}	catch(e) {
		recup_erreur(e);
	}
}


function oea_changerTypeVente() {
	try {

	  var qZoneUE = new QueryHttp("Facturation/Commun/getZoneUEPays.tmpl");
	  qZoneUE.setParam("Code_Pays", document.getElementById("oea-Code_Pays_Liv").value);
	  var result = qZoneUE.execute();
	  oea_zoneUE = (result.responseXML.documentElement.getAttribute("Zone_UE")=="true");

	}	catch(e) {
		recup_erreur(e);
	}
}


function oea_rechercherAdrFact() {
  try {

		var url = "chrome://opensi/content/facturation/user/commun/popup-choixAdresse.xul";
    window.openDialog(url,'','chrome,modal,centerscreen', oea_reporterAdrFact, oea_clientId, false);

	} catch (e) {
  	recup_erreur(e);
  }
}


function oea_reporterAdrFact(nom, adr1, adr2, adr3, cp, ville, pays, code_pays, contact_fact, contact_liv, contact_envoi, contact_devis, adresseId) {
  try {

		document.getElementById("oea-Denomination_Fact").value = nom;
		document.getElementById("oea-Adresse_1_Fact").value = adr1;
		document.getElementById("oea-Adresse_2_Fact").value = adr2;
		document.getElementById("oea-Adresse_3_Fact").value = adr3;
		document.getElementById("oea-Code_Postal_Fact").value = cp;
		document.getElementById("oea-Ville_Fact").value = ville;
	  document.getElementById("oea-Code_Pays_Fact").value = code_pays;

	  if (!isEmpty(contact_fact)) {
	  	var qLoad = new QueryHttp("Facturation/Clients/loadContactClient.tmpl");
	  	qLoad.setParam("Contact_Id", contact_fact);
	  	var result = qLoad.execute();
	  	var contenu = result.responseXML.documentElement;
	  	oea_reporterInterFact(contenu.getAttribute("Civilite"),contenu.getAttribute("Nom"),contenu.getAttribute("Prenom"),contenu.getAttribute("Tel_1"),contenu.getAttribute("Tel_2"),contenu.getAttribute("Fax"),contenu.getAttribute("Email"));
	  }
	  oea_setModified(true);

	} catch (e) {
  	recup_erreur(e);
  }
}


function oea_rechercherInterlocuteurFact() {
  try {

		var url = "chrome://opensi/content/facturation/user/commun/popup-choixInter.xul";
    window.openDialog(url,'','chrome,modal,centerscreen', oea_reporterInterFact, oea_clientId, false);

	} catch (e) {
  	recup_erreur(e);
  }
}


function oea_reporterInterFact(civ, nom, prenom, tel1, tel2, fax, email) {
  try {

		document.getElementById("oea-Civ_Inter_Fact").value = civ;
		document.getElementById("oea-Nom_Inter_Fact").value = nom;
		document.getElementById("oea-Prenom_Inter_Fact").value = prenom;
		document.getElementById("oea-Tel_Inter_1_Fact").value = tel1;
		document.getElementById("oea-Tel_Inter_2_Fact").value = tel2;
		document.getElementById("oea-Fax_Inter_Fact").value = fax;
		document.getElementById("oea-Email_Inter_Fact").value = email;

		oea_setModified(true);

	} catch (e) {
  	recup_erreur(e);
  }
}


function oea_rechercherAdrEnvoi() {
  try {

		var url = "chrome://opensi/content/facturation/user/commun/popup-choixAdresse.xul";
    window.openDialog(url,'','chrome,modal,centerscreen', oea_reporterAdrEnvoi, oea_clientId, false);

	} catch (e) {
  	recup_erreur(e);
  }
}


function oea_reporterAdrEnvoi(nom, adr1, adr2, adr3, cp, ville, pays, code_pays, contact_fact, contact_liv, contact_envoi, contact_devis, adresseId) {
  try {

		document.getElementById("oea-Denomination_Envoi").value = nom;
		document.getElementById("oea-Adresse_1_Envoi").value = adr1;
		document.getElementById("oea-Adresse_2_Envoi").value = adr2;
		document.getElementById("oea-Adresse_3_Envoi").value = adr3;
		document.getElementById("oea-Code_Postal_Envoi").value = cp;
		document.getElementById("oea-Ville_Envoi").value = ville;
	  document.getElementById("oea-Code_Pays_Envoi").value = code_pays;

	  if (!isEmpty(contact_envoi)) {
	  	var qLoad = new QueryHttp("Facturation/Clients/loadContactClient.tmpl");
	  	qLoad.setParam("Contact_Id", contact_envoi);
	  	var result = qLoad.execute();
	  	var contenu = result.responseXML.documentElement;
	  	oea_reporterInterEnvoi(contenu.getAttribute("Civilite"),contenu.getAttribute("Nom"),contenu.getAttribute("Prenom"),contenu.getAttribute("Tel_1"),contenu.getAttribute("Tel_2"),contenu.getAttribute("Fax"),contenu.getAttribute("Email"));
	  }

		oea_setModified(true);

	} catch (e) {
  	recup_erreur(e);
  }
}


function oea_copierFactVersLivEnvoi() {
	try {
		document.getElementById('oea-Denomination_Liv').value = document.getElementById('oea-Denomination_Fact').value;
		document.getElementById("oea-Adresse_1_Liv").value = document.getElementById("oea-Adresse_1_Fact").value;
		document.getElementById("oea-Adresse_2_Liv").value = document.getElementById("oea-Adresse_2_Fact").value;
		document.getElementById("oea-Adresse_3_Liv").value = document.getElementById("oea-Adresse_3_Fact").value;
		document.getElementById("oea-Code_Postal_Liv").value = document.getElementById("oea-Code_Postal_Fact").value;
		document.getElementById("oea-Ville_Liv").value = document.getElementById("oea-Ville_Fact").value;
	  document.getElementById("oea-Code_Pays_Liv").value = document.getElementById("oea-Code_Pays_Fact").value;
	  oea_listeTVAFraisPort();
	  oea_selectPaysLiv();
	  document.getElementById("oea-Civ_Inter_Liv").value = document.getElementById("oea-Civ_Inter_Fact").value;
		document.getElementById("oea-Nom_Inter_Liv").value = document.getElementById("oea-Nom_Inter_Fact").value;
		document.getElementById("oea-Prenom_Inter_Liv").value = document.getElementById("oea-Prenom_Inter_Fact").value;
		document.getElementById("oea-Tel_Inter_1_Liv").value = document.getElementById("oea-Tel_Inter_1_Fact").value;
		document.getElementById("oea-Tel_Inter_2_Liv").value = document.getElementById("oea-Tel_Inter_2_Fact").value;
		document.getElementById("oea-Fax_Inter_Liv").value = document.getElementById("oea-Fax_Inter_Fact").value;
		document.getElementById("oea-Email_Inter_Liv").value = document.getElementById("oea-Email_Inter_Fact").value;

		document.getElementById('oea-Denomination_Envoi').value = document.getElementById('oea-Denomination_Fact').value;
		document.getElementById("oea-Adresse_1_Envoi").value = document.getElementById("oea-Adresse_1_Fact").value;
		document.getElementById("oea-Adresse_2_Envoi").value = document.getElementById("oea-Adresse_2_Fact").value;
		document.getElementById("oea-Adresse_3_Envoi").value = document.getElementById("oea-Adresse_3_Fact").value;
		document.getElementById("oea-Code_Postal_Envoi").value = document.getElementById("oea-Code_Postal_Fact").value;
		document.getElementById("oea-Ville_Envoi").value = document.getElementById("oea-Ville_Fact").value;
	  document.getElementById("oea-Code_Pays_Envoi").value = document.getElementById("oea-Code_Pays_Fact").value;

	  document.getElementById("oea-Civ_Inter_Envoi").value = document.getElementById("oea-Civ_Inter_Fact").value;
		document.getElementById("oea-Nom_Inter_Envoi").value = document.getElementById("oea-Nom_Inter_Fact").value;
		document.getElementById("oea-Prenom_Inter_Envoi").value = document.getElementById("oea-Prenom_Inter_Fact").value;
		document.getElementById("oea-Tel_Inter_1_Envoi").value = document.getElementById("oea-Tel_Inter_1_Fact").value;
		document.getElementById("oea-Tel_Inter_2_Envoi").value = document.getElementById("oea-Tel_Inter_2_Fact").value;
		document.getElementById("oea-Fax_Inter_Envoi").value = document.getElementById("oea-Fax_Inter_Fact").value;
		document.getElementById("oea-Email_Inter_Envoi").value = document.getElementById("oea-Email_Inter_Fact").value;

		oea_setModified(true);
	} catch (e) {
		recup_erreur(e);
	}
}


function oea_rechercherAdrLiv() {
  try {

		var url = "chrome://opensi/content/facturation/user/commun/popup-choixAdresse.xul";
    window.openDialog(url,'','chrome,modal,centerscreen', oea_reporterAdrLiv, oea_clientId, false);

	} catch (e) {
  	recup_erreur(e);
  }
}


function oea_reporterAdrLiv(nom, adr1, adr2, adr3, cp, ville, pays, code_pays, contact_fact, contact_liv, contact_envoi, contact_devis, adresseId) {
  try {

		document.getElementById("oea-Denomination_Liv").value = nom;
		document.getElementById("oea-Adresse_1_Liv").value = adr1;
		document.getElementById("oea-Adresse_2_Liv").value = adr2;
		document.getElementById("oea-Adresse_3_Liv").value = adr3;
		document.getElementById("oea-Code_Postal_Liv").value = cp;
		document.getElementById("oea-Ville_Liv").value = ville;
	  document.getElementById("oea-Code_Pays_Liv").value = code_pays;
	  oea_listeTVAFraisPort();
	  oea_selectPaysLiv();

		if (!isEmpty(contact_liv)) {
	  	var qLoad = new QueryHttp("Facturation/Clients/loadContactClient.tmpl");
	  	qLoad.setParam("Contact_Id", contact_liv);
	  	var result = qLoad.execute();
	  	var contenu = result.responseXML.documentElement;
	  	oea_reporterInterLiv(contenu.getAttribute("Civilite"),contenu.getAttribute("Nom"),contenu.getAttribute("Prenom"),contenu.getAttribute("Tel_1"),contenu.getAttribute("Tel_2"),contenu.getAttribute("Fax"),contenu.getAttribute("Email"));
	  }
		oea_setModified(true);

	} catch (e) {
  	recup_erreur(e);
  }
}


function oea_rechercherInterlocuteurLiv() {
  try {

		var url = "chrome://opensi/content/facturation/user/commun/popup-choixInter.xul";
    window.openDialog(url,'','chrome,modal,centerscreen', oea_reporterInterLiv, oea_clientId, false);

	} catch (e) {
  	recup_erreur(e);
  }
}


function oea_reporterInterLiv(civ, nom, prenom, tel1, tel2, fax, email) {
  try {

		document.getElementById("oea-Civ_Inter_Liv").value = civ;
		document.getElementById("oea-Nom_Inter_Liv").value = nom;
		document.getElementById("oea-Prenom_Inter_Liv").value = prenom;
		document.getElementById("oea-Tel_Inter_1_Liv").value = tel1;
		document.getElementById("oea-Tel_Inter_2_Liv").value = tel2;
		document.getElementById("oea-Fax_Inter_Liv").value = fax;
		document.getElementById("oea-Email_Inter_Liv").value = email;

		oea_setModified(true);

	} catch (e) {
  	recup_erreur(e);
  }
}


function oea_rechercherInterlocuteurEnvoi() {
  try {

		var url = "chrome://opensi/content/facturation/user/commun/popup-choixInter.xul";
    window.openDialog(url,'','chrome,modal,centerscreen', oea_reporterInterEnvoi, oea_clientId, false);

	} catch (e) {
  	recup_erreur(e);
  }
}


function oea_reporterInterEnvoi(civ, nom, prenom, tel1, tel2, fax, email) {
  try {

		document.getElementById("oea-Civ_Inter_Envoi").value = civ;
		document.getElementById("oea-Nom_Inter_Envoi").value = nom;
		document.getElementById("oea-Prenom_Inter_Envoi").value = prenom;
		document.getElementById("oea-Tel_Inter_1_Envoi").value = tel1;
		document.getElementById("oea-Tel_Inter_2_Envoi").value = tel2;
		document.getElementById("oea-Fax_Inter_Envoi").value = fax;
		document.getElementById("oea-Email_Inter_Envoi").value = email;

		oea_setModified(true);

	} catch (e) {
  	recup_erreur(e);
  }
}


function oea_choisirMentions() {
  try {

  	var ok = true;

  	if (oea_mode=="C") {
			ok = oea_enregistrerAvoir();
		}

		if (ok) {
			var url = "chrome://opensi/content/facturation/user/commun/popup-mentionsDocument.xul";
    	window.openDialog(url,'','chrome,modal,centerscreen', "AC", oea_avoirId, false);
		}

	} catch (e) {
  	recup_erreur(e);
  }
}


function oea_checkOnIncrementerStock(b) {
	try {
		document.getElementById('oea-rowDepot').collapsed = !b;
	} catch (e) {
		recup_erreur(e);
	}
}


function oea_initVersion() {
	try {

		oea_aVersion.setParam("Avoir_Id", oea_avoirId);
		oea_aVersion.initTree();

	} catch (e) {
		recup_erreur(e);
	}
}


function oea_checkNumSerieLigne(quantite) {
	try {

		if (oea_actSuiviSerie && !isEmpty(oea_articleId)) {

			var qSuiviSerie = new QueryHttp("Facturation/Articles/getSuiviSerie.tmpl");
			qSuiviSerie.setParam("Article_Id", oea_articleId);
			var result = qSuiviSerie.execute();
			var isSuiviSerie = (result.responseXML.documentElement.getAttribute("Suivi_Serie")=="true");

			var wrongNbSerie = false;

			if (oea_modeLigne=="M") {
			  var qNbSerie = new QueryHttp("Facturation/Avoirs/getNbNumSerieLigneAC.tmpl");
			  qNbSerie.setParam("Ligne_Id", oea_ligneId);
			  var resNS = qNbSerie.execute();
			  var nb = parseIntBis(resNS.responseXML.documentElement.getAttribute("Nombre"));
			  if ((isSuiviSerie && nb!=quantite) || nb>quantite) {
					wrongNbSerie = true;
			  }
		  }

			if ((oea_modeLigne=="C" && isSuiviSerie) || wrongNbSerie) {
				var url = "chrome://opensi/content/facturation/user/commun/popup-numSerie.xul";
		    window.openDialog(url,'','chrome,modal,centerscreen', "S", "AC", oea_ligneId, oea_clientId);
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oea_consulterNumSerie() {
	try {

		if (oea_aLignes.isSelected()) {
			var url = "chrome://opensi/content/facturation/user/commun/popup-numSerie.xul";
    	window.openDialog(url,'','chrome,modal,centerscreen', (oea_mode!="V"?"S":"C"), "AC", oea_ligneId, oea_clientId);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oea_checkNumLotLigne(numero, datePeremption) {
	try {

		var ok = true;

		if (oea_actSuiviLot && !isEmpty(oea_articleId)) {

			var qSuiviLotDLC = new QueryHttp("Facturation/Articles/getSuiviLotDLC.tmpl");
			qSuiviLotDLC.setParam("Article_Id", oea_articleId);
			var result = qSuiviLotDLC.execute();
			var isSuiviLot = (result.responseXML.documentElement.getAttribute("Suivi_Lot")=="true");
			var isSuiviDLC = (result.responseXML.documentElement.getAttribute("Suivi_DLC")=="true");

			if ((isSuiviLot || !isEmpty(datePeremption)) && isEmpty(numero)) {
				ok = false;
				showWarning("N\u00B0 Lot manquant");
			}
			else if (isSuiviDLC && isEmpty(datePeremption)) {
				ok = false;
				showWarning("Date de p\u00E9remption manquante");
			}
			else if (!isEmpty(datePeremption) && !isDate(datePeremption)) {
				ok = false;
				showWarning("Date de p\u00E9remption incorrecte");
			}
		}

		return ok;

	} catch (e) {
		recup_erreur(e);
	}
}


function oea_onKeyPressNumLot(ev) {
	try {

		if (ev.keyCode==13 && !isEmpty(oea_articleId)) {
			var numero = document.getElementById("oea-Num_Lot").value;

			var url = "chrome://opensi/content/facturation/user/tracabilite_articles/popup-rechercheLot.xul";
			window.openDialog(url,'','chrome,modal,centerscreen', oea_retourRechercherLot, oea_articleId, numero, null, oea_clientId);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oea_retourRechercherLot(numero, datePeremption) {
	try {

		document.getElementById("oea-Num_Lot").value = numero;
		document.getElementById("oea-Date_Peremption").value = datePeremption;

	} catch (e) {
		recup_erreur(e);
	}
}


function oea_updateDLC() {
	try {

		var numero = document.getElementById("oea-Num_Lot").value;

		if (!isEmpty(numero) && !isEmpty(oea_articleId)) {
			var qGetDLC = new QueryHttp("Facturation/Tracabilite/getDLCNumLot.tmpl");
			qGetDLC.setParam("Article_Id", oea_articleId);
			qGetDLC.setParam("Numero", numero);
			var result = qGetDLC.execute();
			var datePeremption = result.responseXML.documentElement.getAttribute("Date_Peremption");
			if (!isEmpty(datePeremption)) {
				document.getElementById("oea-Date_Peremption").value = datePeremption;
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oea_chargerTarifsVente(selection) {
	try {

		oea_selTarifVente = selection;
		oea_aTarifsVente.setParam("Selection", oea_selTarifVente);
		oea_aTarifsVente.initTree(oea_initTarifVente);

	} catch (e) {
		recup_erreur(e);
	}
}


function oea_initTarifVente() {
  try {

		document.getElementById('oea-Tarif_Id').value = oea_selTarifVente;

	} catch (e) {
  	recup_erreur(e);
	}
}
