/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/


var oef_aLignes = new Arbre('Facturation/FacturesVente/list-ligneFactureClient.tmpl', 'oef-articles');
var oef_aModesReglements = new Arbre('ComboListe/combo-modesReglement.tmpl', 'oef-Mode_Reg');
var oef_aResponsables = new Arbre("ComboListe/combo-responsables.tmpl","oef-Login_Resp");
var oef_aPolesActivite = new Arbre("ComboListe/combo-polesActivite.tmpl", "oef-Secteur");
var oef_aVersion = new Arbre("Facturation/FacturesVente/list-versionFactureClient.tmpl","oef-listeVersion");
var oef_aEtablissements = new Arbre('ComboListe/combo-etablissements.tmpl', 'oef-etablissement');
var oef_aDepots = new Arbre('ComboListe/combo-depotsStock.tmpl', 'oef-depot');
var oef_aCodesTVAFraisPort = new Arbre("ComboListe/combo-tauxTVA.tmpl", "oef-codeTVAFraisPort");
var oef_aLangues = new Arbre("ComboListe/combo-langues.tmpl", "oef-langueDefaut");
var oef_aTarifsVente = new Arbre("ComboListe/combo-tarifsVente.tmpl", "oef-Tarif_Id");


var oef_factureId = "";
var oef_clientId = "";
var oef_modeLigne;
var oef_mode;
var oef_modeTarif;
var oef_gen;
var oef_assujettiTVA = false;
var oef_tauxTVAPort;
var oef_codeTVAPort = "";
var oef_typeRistourne = 'P';
var oef_typeRemise = 'P';
var oef_typeRemiseFP = 'P';
var oef_editionTTC = false;
var oef_zoneUE = false;
var oef_modified = false;
var oef_chargerModeReg;
var oef_chargerResponsable;
var oef_selPoleActivite;
var oef_selTarifVente;
var oef_bloquerEcheance = false;
var oef_currentIndex = 0;
var oef_toSelectLigne = null;
var oef_montantHT = 0;
var oef_montantTTC = 0;
var oef_acompte = 0;
var oef_curEtablissement;
var oef_depotDefaut = "";
var oef_curDepot;
var oef_actSuiviLot;
var oef_actSuiviSerie;
var oef_codesTvaInactifs = "";
var oef_defModeReglement;
var oef_insertionLigneId = 0;
var oef_uniteDefaut;
var oef_typeEditionPdf;
var oef_docIdPdf;
var oef_apercu;
var oef_langueDefaut;
var oef_ligneId;
var oef_typeLigne;
var oef_articleId;
var oef_prixId = "";
var oef_libelle = "";
var oef_modifElemFin;



function oef_init() {
  try {

		oef_modifElemFin = gProfil.isModifElemFinDV();

		document.getElementById('oef-rowFax').collapsed = !gConfig.isShowFax();
		document.getElementById('oef-rowMontantDeduction').collapsed = !gConfig.isAutDeductionFC();
		document.getElementById('oef-rowDeductionHT').collapsed = !gConfig.isAutDeductionFC();
		document.getElementById('oef-rowDeductionTTC').collapsed = !gConfig.isAutDeductionFC();

		var act_codeStats = gConfig.isActCodeStats();
		oef_uniteDefaut = gConfig.getUniteDefaut();
		oef_actSuiviSerie = gConfig.isActSuiviSerie();
		document.getElementById('oef-bConsultSerieLigne').collapsed = !oef_actSuiviSerie;
		document.getElementById('oef-bConsultSerieLigne').disabled = true;
		oef_defModeReglement = gConfig.getDefModeReglementC();

		if (!act_codeStats) {
			document.getElementById('oef-ColCode_Stats').collapsed = true;
			document.getElementById('oef-ColCode_Stats').setAttribute('ignoreincolumnpicker', true);
	  	document.getElementById('oef-Act_Code_Stats').collapsed = true;
		} else {
			document.getElementById('oef-labelRef').setAttribute('style', 'margin-left:0px');
			document.getElementById('oef-Reference').setAttribute('style', 'margin-left:0px');
		}

		oef_actSuiviLot = gConfig.isActSuiviLot();
		var actUnites = gConfig.isActUnites();
		var actNbPieces = gConfig.isActNbPieces();

		if (!oef_actSuiviLot) {
			document.getElementById('oef-ColNum_Lot').collapsed = true;
			document.getElementById('oef-ColNum_Lot').setAttribute('ignoreincolumnpicker', true);
			document.getElementById('oef-ColDate_Peremption').collapsed = true;
			document.getElementById('oef-ColDate_Peremption').setAttribute('ignoreincolumnpicker', true);
			document.getElementById('oef-fieldNumLot').collapsed = true;
			document.getElementById('oef-fieldDLC').collapsed = true;
		}

		if (!actUnites) {
			document.getElementById('oef-ColSymboleUnite').collapsed = true;
			document.getElementById('oef-ColSymboleUnite').setAttribute('ignoreincolumnpicker', true);
			document.getElementById('oef-fieldUnite').collapsed = true;
		}

		if (!actNbPieces) {
			document.getElementById('oef-ColNb_Pieces').collapsed = true;
			document.getElementById('oef-ColNb_Pieces').setAttribute('ignoreincolumnpicker', true);
			document.getElementById('oef-fieldNbPieces').collapsed = true;
		}

		oef_modeTarif = gConfig.getModeTarif();
    if (oef_modeTarif == 'Q'){
      document.getElementById('oef-row_tarif').collapsed = true;
    }

		var qAttPrinc = new QueryHttp("Facturation/Commun/getAttributsPrincipaux.tmpl");
		var result = qAttPrinc.execute();

		var contenu = result.responseXML.documentElement;

		for (var i=1; i<=6; i++) {
			if (!isEmpty(contenu.getAttribute("Groupe_Id_"+ i))) {
				document.getElementById("oef-ColAttribut"+ i).setAttribute("label", contenu.getAttribute("Intitule_"+ i));
			}
			else {
				document.getElementById("oef-ColAttribut"+ i).collapsed = true;
				document.getElementById("oef-ColAttribut"+ i).setAttribute("ignoreincolumnpicker", true);
			}
		}

		var qDepotDefaut = new QueryHttp("Facturation/Commun/getDepotDefautEts.tmpl");
		qDepotDefaut.setParam("Etablissement_Id", etablissementDefaut);
		result = qDepotDefaut.execute();
		oef_depotDefaut = result.responseXML.documentElement.getAttribute('Depot_Defaut');

		var aUnite = new Arbre("ComboListe/combo-unitesVente.tmpl", "oef-Unite");
		aUnite.initTree(oef_initUnite);

		if (!gAccesCoutAchat) {
			document.getElementById('oef-colPrixAchat').setAttribute("ignoreincolumnpicker", true);
			document.getElementById('oef-colTauxMarque').setAttribute("ignoreincolumnpicker", true);
			document.getElementById('oef-colTauxMarge').setAttribute("ignoreincolumnpicker", true);
			document.getElementById('oef-colMargeHT').setAttribute("ignoreincolumnpicker", true);
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oef_initUnite() {
	try {

    document.getElementById('oef-Unite').selectedIndex = 0;
    var aPays = new Arbre("ComboListe/combo-pays.tmpl", "oef-Code_Pays_Fact");
		aPays.initTree(oef_initPaysFact);

	} catch (e) {
    recup_erreur(e);
  }
}


function oef_initPaysFact() {
	try {

		var aPaysEnvoi = new Arbre("ComboListe/combo-pays.tmpl", "oef-Code_Pays_Envoi");
		aPaysEnvoi.initTree(oef_initPaysEnvoi);

	} catch (e) {
    recup_erreur(e);
  }
}

function oef_initPaysEnvoi() {
	try {

		var aPaysLiv = new Arbre("ComboListe/combo-pays.tmpl", "oef-Code_Pays_Liv");
		aPaysLiv.initTree();

	} catch (e) {
    recup_erreur(e);
  }
}


function oef_chargerResponsables(selection) {
	try {
		oef_chargerResponsable = selection;
		oef_aResponsables.setParam("Selection", oef_chargerResponsable);
		oef_aResponsables.initTree(oef_initResponsable);
	} catch (e) {
		recup_erreur(e);
	}
}


function oef_initResponsable() {
  try {
		document.getElementById('oef-Login_Resp').value = oef_chargerResponsable;
	} catch (e) {
  	recup_erreur(e);
	}
}


function oef_chargerPolesActivite(selection) {
	try {

		oef_selPoleActivite = selection;
		oef_aPolesActivite.setParam("Selection", oef_selPoleActivite);
		oef_aPolesActivite.initTree(oef_initPoleActivite);

	} catch (e) {
		recup_erreur(e);
	}
}


function oef_initPoleActivite() {
  try {

		document.getElementById('oef-Secteur').value = oef_selPoleActivite;

	} catch (e) {
  	recup_erreur(e);
	}
}


function oef_chargerEtablissement(selection) {
	try {
		oef_curEtablissement = selection;
		oef_aEtablissements.setParam("Selection", selection);
		oef_aEtablissements.initTree(oef_initEtablissement);
	} catch (e) {
		recup_erreur(e);
	}
}

function oef_initEtablissement() {
	try {
		document.getElementById('oef-etablissement').value = oef_curEtablissement;
	} catch (e) {
		recup_erreur(e);
	}
}


function oef_chargerDepot(selection) {
	try {
		oef_curDepot = selection;
		oef_aDepots.setParam("Selection", selection);
		oef_aDepots.setParam("Depot_Quarantaine", false);
		oef_aDepots.initTree(oef_initDepot);
	} catch (e) {
		recup_erreur(e);
	}
}

function oef_initDepot() {
	try {
		document.getElementById('oef-depot').value = oef_curDepot;
	} catch (e) {
		recup_erreur(e);
	}
}


function oef_selectPaysLiv() {
	try {

		oef_listeTVA();
    oef_changerTypeVente();

	} catch (e) {
		recup_erreur(e);
	}
}


function oef_listeTVAFraisPort() {
  try {

    oef_aCodesTVAFraisPort.setParam("Code_Pays", document.getElementById("oef-Code_Pays_Liv").value);
    oef_aCodesTVAFraisPort.setParam("Regime_TVA", document.getElementById("oef-Regime_TVA").value);
    oef_aCodesTVAFraisPort.setParam("Assujetti_TVA", oef_assujettiTVA);
		oef_aCodesTVAFraisPort.setParam("Selection", oef_codeTVAPort);
		oef_aCodesTVAFraisPort.initTree(oef_finListeTVAFraisPort);

  } catch (e) {
    recup_erreur(e);
  }
}


function oef_finListeTVAFraisPort() {
  try {

   	document.getElementById('oef-codeTVAFraisPort').value = getCodeTvaNormal(document.getElementById('oef-Code_Pays_Liv').value, oef_assujettiTVA, document.getElementById('oef-Regime_TVA').value);
   	oef_codeTVAPort = document.getElementById('oef-codeTVAFraisPort').value;
		oef_tauxTVAPort = getTva(oef_codeTVAPort);

  } catch (e) {
    recup_erreur(e);
  }
}


function oef_listeTVA() {
  try {

  	oef_calculTotaux();

    var aCode = new Arbre("ComboListe/combo-tauxTVA.tmpl", "oef-Code_TVA");
    aCode.setParam("Code_Pays", document.getElementById("oef-Code_Pays_Liv").value);
    aCode.setParam("Regime_TVA", document.getElementById("oef-Regime_TVA").value);
    aCode.setParam("Assujetti_TVA", oef_assujettiTVA);
		aCode.setParam("Selection", oef_codesTvaInactifs);
    aCode.initTree(oef_selectTVA);

  } catch (e) {
    recup_erreur(e);
  }
}


function oef_selectTVA() {
  try {

    document.getElementById('oef-Code_TVA').value = getCodeTvaNormal(document.getElementById('oef-Code_Pays_Liv').value, oef_assujettiTVA, document.getElementById("oef-Regime_TVA").value);

  } catch (e) {
    recup_erreur(e);
  }
}


function oef_chargerModesReglements(selection) {
	try {
		oef_chargerModeReg = selection;
		oef_aModesReglements.setParam("Selection", oef_chargerModeReg);
		oef_aModesReglements.initTree(oef_initModeReglement);
	} catch (e) {
		recup_erreur(e);
	}
}


function oef_initModeReglement() {
	try {

    document.getElementById('oef-Mode_Reg').value=oef_chargerModeReg;
		oef_setModified(false);

	} catch (e) {
    recup_erreur(e);
  }
}


function oef_pressOnEcheancesMultiples() {
	try {

		var url = "chrome://opensi/content/facturation/user/factures_vente/popup-echeancesMultiples.xul";
    window.openDialog(url,'','chrome,modal,centerscreen', oef_refreshEcheance, oef_factureId, oef_mode!="V");

	} catch (e) {
		recup_erreur(e);
	}
}


function oef_refreshEcheance() {
	try {

		var qGet = new QueryHttp("Facturation/FacturesVente/getFirstEcheanceClient.tmpl");
		qGet.setParam("Facture_Id", oef_factureId);
		var result = qGet.execute();
		var contenu = result.responseXML.documentElement;

		document.getElementById('oef-Echeance').value = contenu.getAttribute('Date_Echeance');
		oef_chargerModesReglements(contenu.getAttribute('Mode_Reg_Id'));
		var echModifiable = contenu.getAttribute('Ech_Modifiable')=="true";
  	document.getElementById('oef-Echeance').disabled = !echModifiable;
		document.getElementById('oef-Mode_Reg').disabled = !echModifiable;

	} catch (e) {
		recup_erreur(e);
	}
}


function oef_switchRistourne() {
	try {

		if (oef_typeRistourne=='P') {
			document.getElementById('oef-bRistourne').setAttribute("class", "bIcoEuro");
			oef_typeRistourne = 'M';
		}
		else {
			document.getElementById('oef-bRistourne').setAttribute("class", "bIcoPourcentage");
			oef_typeRistourne = 'P';
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oef_switchRemise() {
	try {

		if (oef_typeRemise=='P') {
			document.getElementById('oef-bRemise').setAttribute("class", "bIcoEuro");
			oef_typeRemise = 'M';
		}
		else {
			document.getElementById('oef-bRemise').setAttribute("class", "bIcoPourcentage");
			oef_typeRemise = 'P';
		}
		oef_calculTotaux();
		oef_setModified(true);

	} catch (e) {
    recup_erreur(e);
  }
}


function oef_switchRemiseFP() {
	try {

		if (oef_typeRemiseFP=='P') {
			document.getElementById('oef-bRemiseFP').setAttribute("class", "bIcoEuro");
			oef_typeRemiseFP = 'M';
		}
		else {
			document.getElementById('oef-bRemiseFP').setAttribute("class", "bIcoPourcentage");
			oef_typeRemiseFP = 'P';
		}
		oef_calculTotaux();
		oef_setModified(true);

	} catch (e) {
    recup_erreur(e);
  }
}


function oef_ajouterLigne(typeLigne, articleId) {
  try {

		document.getElementById('oef-bSupprimer').disabled = true;
		document.getElementById('oef-bMoveUp').disabled = true;
		document.getElementById('oef-bMoveDown').disabled = true;
		document.getElementById('oef-bMoveFirst').disabled = true;
		document.getElementById('oef-bMoveLast').disabled = true;
		document.getElementById('oef-bMultiSuppression').disabled = true;
		document.getElementById('oef-bCommentaire').disabled = true;

		oef_modeLigne = "C";
		oef_typeLigne = typeLigne;
		oef_ligneId = "";

		oef_formatLigne(typeLigne);
		var codePaysLiv = document.getElementById("oef-Code_Pays_Liv").value;
		var regimeTVA = document.getElementById("oef-Regime_TVA").value;

		if (typeLigne=="S") {
			oef_articleId = articleId;

			if (oef_modeTarif=='Q') {
				var url = "chrome://opensi/content/facturation/user/commun/popup-choixTarif.xul";
    		window.openDialog(url,'','chrome,modal,centerscreen', oef_retourChoixPrixQuantite, articleId);

				if (!isEmpty(oef_prixId)) {
					var qGet = new QueryHttp("Facturation/Articles/getInfosArticleQuantite.tmpl");
        	qGet.setParam("Article_Id", articleId);
        	qGet.setParam("Prix_Id", oef_prixId);
					qGet.setParam("TTC", oef_editionTTC);
					var result = qGet.execute();

					var contenu = result.responseXML.documentElement;
					document.getElementById("oef-Code_Stats").value = contenu.getAttribute("Code_Stats");
          document.getElementById("oef-Designation").value = contenu.getAttribute("Designation");
          document.getElementById("oef-Num_Lot").value = "";
					document.getElementById("oef-Nb_Pieces").value = "";
					document.getElementById('oef-Quantite').value = contenu.getAttribute("Quantite");
					document.getElementById('oef-Unite').value = contenu.getAttribute("Unite_Id");
					document.getElementById("oef-Date_Peremption").value = "";
          document.getElementById("oef-PU").value = contenu.getAttribute("Prix_Unitaire");
          document.getElementById('oef-Ristourne').value = "0.00";
          document.getElementById("oef-Code_TVA").value = getCodeTvaCorrespondant(contenu.getAttribute("Code_TVA"), codePaysLiv, oef_assujettiTVA, regimeTVA);
          oef_prixId = "";
          oef_libelle = contenu.getAttribute("Libelle");
				}
				else {
					oef_ajouterLigne("I");
				}
			}
			else {
				var qGet = new QueryHttp("Facturation/Articles/getInfosArticleVente.tmpl");
        qGet.setParam("Article_Id", articleId);
        qGet.setParam("Tarif_Id", document.getElementById('oef-Tarif_Id').value);
				qGet.setParam("TTC", oef_editionTTC);
				qGet.setParam("Client_Id", oef_clientId);
				var result = qGet.execute();

				var contenu = result.responseXML.documentElement;
        document.getElementById("oef-Code_Stats").value = contenu.getAttribute("Code_Stats");
        document.getElementById("oef-Designation").value = contenu.getAttribute("Designation");
        document.getElementById("oef-Num_Lot").value = "";
				document.getElementById("oef-Nb_Pieces").value = "";
				document.getElementById('oef-Quantite').value = 1;
				document.getElementById('oef-Unite').value = contenu.getAttribute("Unite_Id");
				document.getElementById("oef-Date_Peremption").value = "";
        document.getElementById("oef-PU").value = contenu.getAttribute("Prix_Unitaire");
        document.getElementById('oef-Ristourne').value = contenu.getAttribute("Ristourne");
        document.getElementById("oef-Code_TVA").value = getCodeTvaCorrespondant(contenu.getAttribute("Code_TVA"), codePaysLiv, oef_assujettiTVA, regimeTVA);
        oef_libelle = "";
			}
		}
		else {
			oef_articleId = "";
			document.getElementById('oef-bConsultSerieLigne').disabled = true;
			document.getElementById('oef-Code_Stats').value = "";
			document.getElementById('oef-Reference').value = "";
			document.getElementById('oef-Designation').value = "";
			document.getElementById("oef-Num_Lot").value = "";
			document.getElementById("oef-Nb_Pieces").value = "";
			document.getElementById('oef-Quantite').value = 1;
			document.getElementById('oef-Unite').value = oef_uniteDefaut;
			document.getElementById("oef-Date_Peremption").value = "";
			document.getElementById('oef-PU').value = "";
			document.getElementById('oef-Ristourne').value = "0.00";
			document.getElementById('oef-Code_TVA').value = getCodeTvaNormal(codePaysLiv, oef_assujettiTVA, regimeTVA);
			oef_libelle = "";
			oef_insertionLigneId = 0;
			document.getElementById('oef-bAjouterLigne').disabled = true;
			document.getElementById('oef-Act_Insert').collapsed = true;
			oef_aLignes.setCellSrc(oef_currentIndex, 'oef-ColReference', "");
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oef_formatLigne(typeLigne) {
  try {
		switch(typeLigne) {
			case "S":
        if (oef_mode != 'V') {
        	document.getElementById('oef-Code_Stats').disabled = false;
				  document.getElementById('oef-Reference').disabled = true;
				  document.getElementById('oef-Designation').disabled = true;
				  document.getElementById('oef-Date_Peremption').disabled = false;
				  document.getElementById('oef-Num_Lot').disabled = false;
					document.getElementById('oef-Nb_Pieces').disabled = false;
					document.getElementById('oef-Quantite').disabled = false;
					document.getElementById('oef-Unite').disabled = false;
				  document.getElementById('oef-PU').disabled = !oef_modifElemFin;
				  document.getElementById('oef-Ristourne').disabled = !oef_modifElemFin;
				  document.getElementById('oef-bRistourne').disabled = !oef_modifElemFin;
				  document.getElementById('oef-Code_TVA').disabled = !oef_modifElemFin;
				  document.getElementById('oef-bValider').disabled = false;
				  document.getElementById('oef-bAnnuler').disabled = false;
        }
				break;

			case "I":
        if (oef_mode != 'V') {
        	document.getElementById('oef-Code_Stats').disabled = false;
  				document.getElementById('oef-Reference').disabled = false;
	  			document.getElementById('oef-Designation').disabled = false;
	  			document.getElementById('oef-Num_Lot').disabled = true;
					document.getElementById('oef-Nb_Pieces').disabled = false;
					document.getElementById('oef-Quantite').disabled = false;
					document.getElementById('oef-Unite').disabled = false;
					document.getElementById('oef-Date_Peremption').disabled = true;
			  	document.getElementById('oef-PU').disabled = !oef_modifElemFin;
				  document.getElementById('oef-Ristourne').disabled = !oef_modifElemFin;
				  document.getElementById('oef-bRistourne').disabled = !oef_modifElemFin;
				  document.getElementById('oef-Code_TVA').disabled = !oef_modifElemFin;
				  document.getElementById('oef-bValider').disabled = false;
				  document.getElementById('oef-bAnnuler').disabled = false;
        }
				break;

			default:
				document.getElementById('oef-Code_Stats').value = "";
				document.getElementById('oef-Reference').value = "";
				document.getElementById('oef-Designation').value = "";
				document.getElementById('oef-Num_Lot').value = "";
				document.getElementById('oef-Nb_Pieces').value = "";
				document.getElementById('oef-Quantite').value = "";
				document.getElementById('oef-Unite').value = oef_uniteDefaut;
				document.getElementById('oef-Date_Peremption').value = "";
				document.getElementById('oef-PU').value = "";
				document.getElementById('oef-Ristourne').value = "";
				document.getElementById('oef-Code_TVA').value = getCodeTvaNormal(document.getElementById("oef-Code_Pays_Liv").value,oef_assujettiTVA,document.getElementById("oef-Regime_TVA").value);
				oef_libelle = "";
				oef_ligneId = "";
				document.getElementById('oef-Code_Stats').disabled = true;
				document.getElementById('oef-Reference').disabled = true;
				document.getElementById('oef-Designation').disabled = true;
				document.getElementById('oef-Num_Lot').disabled = true;
				document.getElementById('oef-Nb_Pieces').disabled = true;
				document.getElementById('oef-Quantite').disabled = true;
				document.getElementById('oef-Unite').disabled = true;
				document.getElementById('oef-Date_Peremption').disabled = true;
				document.getElementById('oef-PU').disabled = true;
				document.getElementById('oef-Ristourne').disabled = true;
				document.getElementById('oef-bRistourne').disabled = true;
				document.getElementById('oef-Code_TVA').disabled = true;
				document.getElementById('oef-bSupprimer').disabled = true;
				document.getElementById('oef-bMoveUp').disabled = true;
				document.getElementById('oef-bMoveDown').disabled = true;
				document.getElementById('oef-bMoveFirst').disabled = true;
				document.getElementById('oef-bMoveLast').disabled = true;
				document.getElementById('oef-bMultiSuppression').disabled = true;
				document.getElementById('oef-bCommentaire').disabled = true;
				document.getElementById('oef-bValider').disabled = true;
				document.getElementById('oef-bAnnuler').disabled = true;
				break;
		}

	} catch (e) {
  	recup_erreur(e);
	}
}



function oef_pressOnWindow(ev) {
	try {

		if (ev.altKey && oef_mode!="V") {
			switch(ev.charCode) {
      	case 97: // 'a'
				case 65: // 'A'
        	oef_rechercherStock();
        	break;
				case 116: // 't'
					oef_modifierTarif();
					break;
    	}
		}
		else if (ev.ctrlKey && oef_mode!="V") {
			if (ev.keyCode==46) {
				// ctrl + suppr
				ev.preventDefault();
				oef_supprimerLigne();
			}
			else if (ev.charCode==114 || ev.charCode==82) {
				// ctrl + r (ou R)
				ev.preventDefault();
				oef_appliquerRistourne();
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oef_pressOnReference(ev) {
	try {

		if (ev.keyCode==13) {
			oef_rechercherReference();
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oef_rechercherStock(reference) {
	try {

		var url = "chrome://opensi/content/facturation/user/articles/popup-rechercheArticle.xul";
		var tarifId = (oef_modeTarif!="Q"?document.getElementById('oef-Tarif_Id').value:null);
		var multiSel = (oef_modeTarif!="Q"?true:null);
    window.openDialog(url,'','chrome,modal,centerscreen', oef_retourRechercherStock, "V", reference, tarifId, null, null, null, oef_clientId, multiSel);

	} catch (e) {
    recup_erreur(e);
  }
}


function oef_retourRechercherStock(reference, articleId, listArticleId) {
	try {

		if (articleId!=null) {
			document.getElementById('oef-Reference').value = reference;
			document.getElementById('oef-Quantite').focus();
			oef_ajouterLigne("S", articleId);
		}
		else {
			oef_ajouterMulti(listArticleId);
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oef_rechercherReference() {
	try {

		var reference = document.getElementById('oef-Reference').value;

		var qSearch = new QueryHttp("Facturation/Articles/searchReference.tmpl");
		qSearch.setParam("Reference", reference);
		qSearch.setParam("Vente_Achat", "V");
		var result = qSearch.execute();

		var articleId = result.responseXML.documentElement.getAttribute("Article_Id");
		if (!isEmpty(articleId)) {
			document.getElementById('oef-Reference').value = result.responseXML.documentElement.getAttribute("Reference");
			document.getElementById('oef-Quantite').focus();
			oef_ajouterLigne("S", articleId);
		}
		else {
			oef_rechercherStock(reference);
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oef_ajouterMulti(listArticleId) {
	try {

		var ok = true;

		if (oef_mode=="C") {
			ok = oef_enregistrerFacture();
		}

		if (ok) {
			var qAdd = new QueryHttp("Facturation/FacturesVente/addLigneFactureClient.tmpl");
			qAdd.setParam("List_Article_Id", listArticleId);
			qAdd.setParam("Facture_Id", oef_factureId);
			qAdd.execute();

			oef_ajouterLigne("I");
			oef_aLignes.initTree(oef_afterRefreshArticles);
		}

	} catch (e) {
		recup_erreur(e);
  }
}


function oef_modifierTarif() {
	try {

		if (oef_modeLigne=="M" && oef_typeLigne=='S' && oef_modeTarif=='Q') {

			var url = "chrome://opensi/content/facturation/user/commun/popup-choixTarif.xul";
    	window.openDialog(url,'','chrome,modal,centerscreen', oef_retourChoixPrixQuantite, oef_articleId);

			if (!isEmpty(oef_prixId)) {
				var qGet = new QueryHttp("Facturation/Articles/getInfosArticleQuantite.tmpl");
        qGet.setParam("Article_Id", oef_articleId);
        qGet.setParam("Prix_Id", oef_prixId);
				qGet.setParam("TTC", oef_editionTTC);
				var result = qGet.execute();

				var contenu = result.responseXML.documentElement;
				document.getElementById('oef-Quantite').value = contenu.getAttribute("Quantite");
				document.getElementById('oef-Unite').value = contenu.getAttribute("Unite_Id");
				document.getElementById("oef-PU").value = contenu.getAttribute("Prix_Unitaire");
				oef_prixId = "";
				oef_libelle = contenu.getAttribute("Libelle");
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oef_retourChoixPrixQuantite(prixId) {
	try {

		oef_prixId = prixId;

	} catch (e) {
		recup_erreur(e);
	}
}


function oef_ouvrirLigne() {
  try {

		if (oef_aLignes.isSelected() && oef_mode=="M") {

			if (oef_aLignes.nbSelection()==1) {
				var i = oef_aLignes.getCurrentIndex();
				oef_aLignes.setCellSrc(i, 'oef-ColReference', "");
				oef_currentIndex = i;

				var typeLigne = oef_aLignes.getCellText(i,'oef-colTypeLigne');
				document.getElementById("oef-bConsultSerieLigne").disabled = (typeLigne!="S");
				document.getElementById('oef-bMultiSuppression').disabled = true;

				if (oef_aLignes.getCellText(i,'oef-colTypeLigne')=="C") {
					oef_ajouterLigne("I");
				}
				else {
					oef_modeLigne = "M";

					document.getElementById('oef-bAjouterLigne').disabled = false;
					oef_insertionLigneId = 0;
					document.getElementById('oef-Act_Insert').collapsed = true;
					document.getElementById("oef-Code_Stats").value = oef_aLignes.getCellText(i,'oef-ColCode_Stats');
					document.getElementById("oef-Reference").value = oef_aLignes.getCellText(i,'oef-ColReference');
					document.getElementById("oef-Designation").value = oef_aLignes.getCellText(i,'oef-ColDesignation');
					document.getElementById("oef-Num_Lot").value = oef_aLignes.getCellText(i,'oef-ColNum_Lot');
					document.getElementById("oef-Nb_Pieces").value = oef_aLignes.getCellText(i,'oef-ColNb_Pieces');
					document.getElementById("oef-Quantite").value = oef_aLignes.getCellText(i,'oef-ColQuantite');
					document.getElementById("oef-Unite").value = oef_aLignes.getCellText(i,'oef-ColUnite');
					document.getElementById("oef-Date_Peremption").value = oef_aLignes.getCellText(i,'oef-ColDate_Peremption');
					document.getElementById("oef-PU").value = oef_aLignes.getCellText(i,'oef-ColPU');
					document.getElementById("oef-Ristourne").value = oef_aLignes.getCellValue(i,'oef-ColRistourne');
					oef_typeRistourne = oef_aLignes.getSelectedCellText('oef-colTypeRistourne');
					document.getElementById('oef-bRistourne').setAttribute("class", (oef_typeRistourne=='P'?"bIcoPourcentage":"bIcoEuro"));
					oef_typeLigne = oef_aLignes.getCellText(i,'oef-colTypeLigne');
					oef_ligneId = oef_aLignes.getCellText(i,'oef-colLigneId');
					oef_articleId = oef_aLignes.getCellText(i,'oef-colArticleId');
					oef_libelle = oef_aLignes.getCellText(i,'oef-ColLibelle');
        	document.getElementById("oef-Code_TVA").value = oef_aLignes.getCellText(i,'oef-ColCode_TVA');

        	document.getElementById('oef-bSupprimer').disabled = false;
					document.getElementById('oef-bCommentaire').disabled = false;

  		  	// on ignore les lignes de commentaires
  				var firstIndex = 0;
  				var lastIndex = oef_aLignes.nbLignes()-1;
  				if (oef_aLignes.getCellText(firstIndex,'oef-colTypeLigne')=="C") { firstIndex++; }
  				if (oef_aLignes.getCellText(lastIndex,'oef-colTypeLigne')=="C") { lastIndex--; }

  				document.getElementById('oef-bMoveUp').disabled = (i==firstIndex);
  				document.getElementById('oef-bMoveDown').disabled = (i==lastIndex);
					document.getElementById('oef-bMoveFirst').disabled = (i==firstIndex);
  				document.getElementById('oef-bMoveLast').disabled = (i==lastIndex);

					oef_formatLigne(oef_typeLigne);
				}
			}
			else {
				oef_ajouterLigne("I");
				document.getElementById('oef-bMultiSuppression').disabled = false;
			}
		}

	} catch (e) {
  	recup_erreur(e);
	}
}

function oef_ajouterLigneAvant() {
  try {

		if (oef_aLignes.isSelected() && oef_mode=="M") {
			var idx = oef_aLignes.getCurrentIndex();
			var ligneId = oef_aLignes.getCellText(idx,'oef-colLigneId');
			oef_annulerLigne();

			oef_aLignes.setCellSrc(idx, 'oef-ColReference', "chrome://opensi/content/design/insertbefore.png");

			oef_insertionLigneId = ligneId;
			oef_currentIndex = idx;
			document.getElementById('oef-Act_Insert').collapsed = false;
			document.getElementById('oef-Reference').focus();
		}

	} catch (e) {
  	recup_erreur(e);
	}
}

function oef_pressOnLigneFacture(event) {
	try {

		if (event.keyCode==45 && event.ctrlKey) {
			// ctrl + inser
			// insrer une ligne avant

			oef_ajouterLigneAvant();
		}
	} catch (e) {
		recup_erreur(e);
	}
}


function oef_ouvrirCommentaire() {
  try {

		if (oef_aLignes.isSelected() && oef_mode=="M") {
			var i = oef_aLignes.getCurrentIndex();

			if (oef_aLignes.getCellText(i,'oef-colTypeLigne')=="C") {
				oef_editerCommentaire();
			} else {
				oef_editerPrixAchat();
			}
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oef_deplacerLigne(moveType) {
	try {

		if (oef_aLignes.isSelected() && oef_mode=="M" && oef_aLignes.getSelectedCellText('oef-colTypeLigne')!="C") {

			document.getElementById('oef-bMoveUp').disabled = true;
			document.getElementById('oef-bMoveDown').disabled = true;
			document.getElementById('oef-bMoveFirst').disabled = true;
			document.getElementById('oef-bMoveLast').disabled = true;

			var qMove = new QueryHttp("Facturation/FacturesVente/moveLigneFactureClient.tmpl");
			qMove.setParam("Ligne_Id", oef_ligneId);
			qMove.setParam("Move_Type", moveType);
			var result = qMove.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				oef_toSelectLigne = oef_ligneId;
				oef_ajouterLigne("I");
				oef_aLignes.initTree(oef_afterRefreshArticles);
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oef_validerLigne() {
  try {

		var codeStats = document.getElementById("oef-Code_Stats").value;
		var reference = document.getElementById("oef-Reference").value;
		var designation = document.getElementById("oef-Designation").value;
		var numLot = document.getElementById("oef-Num_Lot").value;
		var nbPieces = document.getElementById("oef-Nb_Pieces").value;
		var quantite = document.getElementById("oef-Quantite").value;
		var unite = document.getElementById("oef-Unite").value;
		var datePeremption = document.getElementById("oef-Date_Peremption").value;
		var prixUnitaire = document.getElementById("oef-PU").value;
		var ristourne = document.getElementById("oef-Ristourne").value;
		var codeTVA = document.getElementById("oef-Code_TVA").value;

		if (isEmpty(nbPieces)) {
			nbPieces = 0;
		}

		var ok = true;

		if (oef_mode=="C") {
			ok = oef_enregistrerFacture();
		}

		if (ok) {

			if (isEmpty(designation)) { showWarning("D\u00E9signation de l'article manquante !"); }
			else if (!checkQte(quantite)) { showWarning("Quantit\u00E9 incorrecte !"); }
			else if (!isPositiveOrNullInteger(nbPieces)) { showWarning("Nombre de pi\u00E8ces incorrect !"); }
			else if (isEmpty(prixUnitaire) || !checkDecimal(prixUnitaire,4) || !isPositiveOrNull(prixUnitaire)) { showWarning("Prix unitaire incorrect !"); }
			else if (isEmpty(ristourne) || (oef_typeRistourne=='P'?!isTaux(ristourne):!isPositiveOrNull(ristourne) || !checkNumber(ristourne,9,2) || parseFloat(ristourne)>parseFloat(prixUnitaire))) { showWarning("Ristourne incorrecte"); }
			else if (oef_checkNumLotLigne(numLot, datePeremption)) {

				var qSave;

				if (oef_modeLigne=="C") {
					if (oef_insertionLigneId==0) {
						oef_currentIndex = oef_aLignes.nbLignes();
					}
					qSave = new QueryHttp("Facturation/FacturesVente/createLigneFactureClient.tmpl");
					qSave.setParam("Facture_Id", oef_factureId);
				}
				else {
					qSave = new QueryHttp("Facturation/FacturesVente/updateLigneFactureClient.tmpl");
					qSave.setParam("Ligne_Id", oef_ligneId);
				}

				qSave.setParam("Reference", reference);
		  	qSave.setParam("Designation", designation);
		  	qSave.setParam("Quantite", quantite);
				qSave.setParam("Prix", prixUnitaire);
		  	qSave.setParam("Ristourne", ristourne);
				qSave.setParam("Type_Ristourne", oef_typeRistourne);
		  	qSave.setParam("Code_TVA", codeTVA);
				qSave.setParam("Libelle", oef_libelle);
				qSave.setParam("Code_Stats", codeStats);
				qSave.setParam("Num_Lot", numLot);
				qSave.setParam("Date_Peremption", datePeremption);
				qSave.setParam("Nb_Pieces", nbPieces);
				qSave.setParam("Unite", unite);
				qSave.setParam("Insertion_Ligne_Id", oef_insertionLigneId);

		    var result = qSave.execute();

				var errors = new Errors(result);
				if (errors.hasNext()) {
					errors.show();
				}
				else {
		      var contenu = result.responseXML.documentElement;

		      if (oef_modeLigne=="C") {
		        oef_ligneId = contenu.getAttribute('Ligne_Id');
		      }

		      oef_bloquerEcheance = (parseFloat(contenu.getAttribute('Net_A_Payer'))==0);
		      var echModifiable = (contenu.getAttribute('Ech_Modifiable')=="true");
		      document.getElementById('oef-Echeance').disabled = !echModifiable;
		      document.getElementById('oef-Mode_Reg').disabled = !echModifiable;
		      document.getElementById('oef-bEchMultiples').disabled = oef_bloquerEcheance;

					oef_checkNumSerieLigne(quantite);

					oef_ajouterLigne("I");
		    	oef_aLignes.initTree(oef_afterRefreshArticles);
				}
			}
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oef_annulerLigne() {
  try {

  	oef_aLignes.clearSelection();
		oef_ajouterLigne("I");

	} catch (e) {
  	recup_erreur(e);
	}
}


function oef_supprimerLigne() {
  try {

		var listLigneId = "";
		var maxIndex = 0;

		if (!isEmpty(oef_ligneId)) {
			listLigneId = oef_ligneId;
			maxIndex = oef_currentIndex;
		}
		else {
			var start = new Object();
			var end = new Object();
			var numRanges = oef_aLignes.getRangeCount();

			for (var t=0; t<numRanges; t++){
				oef_aLignes.getRangeAt(t,start,end);
			  for (var v=start.value; v<=end.value; v++){
					if (oef_aLignes.getCellText(v,'oef-colTypeLigne')!="C") {
			  		listLigneId += oef_aLignes.getCellText(v,'oef-colLigneId')+",";
						if (v>maxIndex) maxIndex = v;
					}
			  }
			}
		}

		if (!isEmpty(listLigneId)) {
			var qDelete = new QueryHttp("Facturation/FacturesVente/deleteLigneFactureClient.tmpl");
			qDelete.setParam('List_Ligne_Id', listLigneId);
			var result = qDelete.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				var contenu = result.responseXML.documentElement;
  			oef_bloquerEcheance = (parseFloat(contenu.getAttribute('Net_A_Payer'))==0);
    		var echModifiable = (contenu.getAttribute('Ech_Modifiable')=="true");
    		document.getElementById('oef-Echeance').disabled = !echModifiable;
    		document.getElementById('oef-Mode_Reg').disabled = !echModifiable;
    		document.getElementById('oef-bEchMultiples').disabled = oef_bloquerEcheance;

				oef_currentIndex = maxIndex-1;
				oef_ajouterLigne("I");
				oef_aLignes.initTree(oef_afterRefreshArticles);
			}
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oef_appliquerRistourne() {
	try {

		var listLigneId = "";
		var maxIndex = 0;

		if (oef_aLignes.isSelected()) {
			var start = new Object();
			var end = new Object();
			var numRanges = oef_aLignes.getRangeCount();

			for (var t=0; t<numRanges; t++){
				oef_aLignes.getRangeAt(t,start,end);
			  for (var v=start.value; v<=end.value; v++){
					if (oef_aLignes.getCellText(v,'oef-colTypeLigne')!="C") {
			  		listLigneId += oef_aLignes.getCellText(v,'oef-colLigneId')+",";
						if (v>maxIndex) maxIndex = v;
					}
			  }
			}
		}

		if (!isEmpty(listLigneId)) {
			var url = "chrome://opensi/content/facturation/user/commun/popup-applicationRistourne.xul";
			window.openDialog(url,'','chrome,modal,centerscreen', "FC", listLigneId, oef_retourAppliquerRistourne);

			oef_currentIndex = maxIndex;
			oef_ajouterLigne("I");
			oef_aLignes.initTree(oef_afterRefreshArticles);
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oef_retourAppliquerRistourne(bloquerEcheance, echModifiable) {
	try {

		oef_bloquerEcheance = bloquerEcheance;
    document.getElementById('oef-Echeance').disabled = !echModifiable;
    document.getElementById('oef-Mode_Reg').disabled = !echModifiable;
    document.getElementById('oef-bEchMultiples').disabled = oef_bloquerEcheance;

	} catch (e) {
  	recup_erreur(e);
	}
}


function oef_enregistrerFacture() {
  try {

		var save = false;

    var modeReglement = document.getElementById('oef-Mode_Reg').value;
    var remise = document.getElementById('oef-Remise').value;
    var remiseFP = document.getElementById('oef-RemiseFP').value;
		var taux_remise = 0;
		var montant_remise = 0;
		var tauxRemiseFP = 0;
		var montantRemiseFP = 0;
		var frais_port = document.getElementById('oef-Frais_Port').value;
		var escompte = document.getElementById('oef-Escompte').value;
		var montantDeduction = document.getElementById('oef-montantDeduction').value;
		var echeance = document.getElementById('oef-Echeance').value;
		var modeEnvoiFacture = document.getElementById('oef-modeEnvoiFacture').value;
		var secteurActivite = document.getElementById('oef-Secteur').value;
		var etablissement = document.getElementById('oef-etablissement').value;
		var chkDecrStock = document.getElementById('oef-chkDecrementerStock').checked;
		var depotStock = (chkDecrStock?document.getElementById('oef-depot').value:"");

    var denomination_fact = document.getElementById('oef-Denomination_Fact').value;
		var adresse_1_fact = document.getElementById('oef-Adresse_1_Fact').value;
		var adresse_2_fact = document.getElementById('oef-Adresse_2_Fact').value;
		var adresse_3_fact = document.getElementById('oef-Adresse_3_Fact').value;
		var code_postal_fact = document.getElementById('oef-Code_Postal_Fact').value;
		var ville_fact = document.getElementById('oef-Ville_Fact').value;
		var code_pays_fact = document.getElementById('oef-Code_Pays_Fact').value;
		var civ_inter_fact = document.getElementById("oef-Civ_Inter_Fact").value;
		var nom_inter_fact = document.getElementById("oef-Nom_Inter_Fact").value;
		var prenom_inter_fact = document.getElementById("oef-Prenom_Inter_Fact").value;
		var telInter1fact = document.getElementById("oef-Tel_Inter_1_Fact").value;
		var telInter2fact = document.getElementById("oef-Tel_Inter_2_Fact").value;
		var fax_inter_fact = document.getElementById('oef-Fax_Inter_Fact').value;
		var email_inter_fact = document.getElementById('oef-Email_Inter_Fact').value;

		var denomination_liv = document.getElementById('oef-Denomination_Liv').value;
		var adresse_1_liv = document.getElementById('oef-Adresse_1_Liv').value;
		var adresse_2_liv = document.getElementById('oef-Adresse_2_Liv').value;
		var adresse_3_liv = document.getElementById('oef-Adresse_3_Liv').value;
		var code_postal_liv = document.getElementById('oef-Code_Postal_Liv').value;
		var ville_liv = document.getElementById('oef-Ville_Liv').value;
		var code_pays_liv = document.getElementById('oef-Code_Pays_Liv').value;
		var civ_inter_liv = document.getElementById("oef-Civ_Inter_Liv").value;
		var nom_inter_liv = document.getElementById("oef-Nom_Inter_Liv").value;
		var prenom_inter_liv = document.getElementById("oef-Prenom_Inter_Liv").value;
		var telInter1liv = document.getElementById("oef-Tel_Inter_1_Liv").value;
		var telInter2liv = document.getElementById("oef-Tel_Inter_2_Liv").value;
		var fax_inter_liv = document.getElementById('oef-Fax_Inter_Liv').value;
		var email_inter_liv = document.getElementById('oef-Email_Inter_Liv').value;

		var denomination_envoi = document.getElementById('oef-Denomination_Envoi').value;
		var adresse_1_envoi = document.getElementById('oef-Adresse_1_Envoi').value;
		var adresse_2_envoi = document.getElementById('oef-Adresse_2_Envoi').value;
		var adresse_3_envoi = document.getElementById('oef-Adresse_3_Envoi').value;
		var code_postal_envoi = document.getElementById('oef-Code_Postal_Envoi').value;
		var ville_envoi = document.getElementById('oef-Ville_Envoi').value;
		var code_pays_envoi = document.getElementById('oef-Code_Pays_Envoi').value;
		var civ_inter_envoi = document.getElementById("oef-Civ_Inter_Envoi").value;
		var nom_inter_envoi = document.getElementById("oef-Nom_Inter_Envoi").value;
		var prenom_inter_envoi = document.getElementById("oef-Prenom_Inter_Envoi").value;
		var telInter1envoi = document.getElementById("oef-Tel_Inter_1_Envoi").value;
		var telInter2envoi = document.getElementById("oef-Tel_Inter_2_Envoi").value;
		var fax_inter_envoi = document.getElementById('oef-Fax_Inter_Envoi').value;
		var email_inter_envoi = document.getElementById('oef-Email_Inter_Envoi').value;

		var num_tva = oef_assujettiTVA?document.getElementById('oef-Num_TVA').value:"";
		var utilR = document.getElementById('oef-Login_Resp').value;

		oef_codeTVAPort = document.getElementById('oef-codeTVAFraisPort').value;
		oef_tauxTVAPort = getTva(oef_codeTVAPort);

		var montant_base = (oef_editionTTC?oef_montantTTC:oef_montantHT);

		if (isEmpty(remise) || (oef_typeRemise=='P'?!isTaux(remise):!isPositiveOrNull(remise) || !checkNumber(remise,9,2) || parseFloat(remise)>montant_base)) { showWarning("Remise incorrecte !"); }
		else if (isEmpty(frais_port) || !isPositiveOrNull(frais_port)) { showWarning("Frais de port incorrects !"); }
		else if (isEmpty(montantDeduction) || !isPositiveOrNull(montantDeduction) || !checkDecimal(montantDeduction,2)) { showWarning("Avoirs et trop-per\u00E7us \u00E0 d\u00E9duire incorrects"); }
		else if (isEmpty(remiseFP) || (oef_typeRemiseFP=='P'?!isTaux(remiseFP):!isPositiveOrNull(remiseFP) || !checkNumber(remiseFP,9,2) || parseFloat(remiseFP)>parseFloat(frais_port))) { showWarning("Remise sur frais de port incorrecte !"); }
		else if (!oef_bloquerEcheance && (isEmpty(echeance) || !isDate(echeance))) { showWarning("Date d'\u00E9ch\u00E9ance incorrecte !"); }
		else if (isEmpty(escompte) || !isTaux(escompte)) { showWarning("Taux d'escompte incorrect !"); }
		else if (isEmpty(denomination_fact)) { showWarning("Veuillez indiquer la d\u00E9nomination du client de facturation !"); }
		else if (isEmpty(adresse_1_fact)) { showWarning("Veuillez indiquer l'adresse du client de facturation !"); }
		else if (isEmpty(ville_fact)) { showWarning("Veuillez indiquer la ville du client de facturation !"); }
		else if (isEmpty(denomination_liv)) { showWarning("Veuillez indiquer la d\u00E9nomination du client de livraison !"); }
		else if (isEmpty(adresse_1_liv)) { showWarning("Veuillez indiquer l'adresse du client de livraison !"); }
		else if (isEmpty(ville_liv)) { showWarning("Veuillez indiquer la ville du client de livraison !"); }
		else if (isEmpty(denomination_envoi)) { showWarning("Veuillez indiquer la d\u00E9nomination du client d'envoi !"); }
		else if (isEmpty(adresse_1_envoi)) { showWarning("Veuillez indiquer l'adresse du client d'envoi !"); }
		else if (isEmpty(ville_envoi)) { showWarning("Veuillez indiquer la ville du client d'envoi !"); }
		else if (!isEmpty(telInter1fact) && !isPhone(telInter1fact)) { showWarning("T\u00E9l\u00E9phone 1 de facturation incorrect !"); }
		else if (!isEmpty(telInter2fact) && !isPhone(telInter2fact)) { showWarning("T\u00E9l\u00E9phone 2 de facturation incorrect !"); }
		else if (!isEmpty(fax_inter_fact) && !isPhone(fax_inter_fact)) { showWarning("Num\u00E9ro de fax de facturation incorrect !"); }
		else if (!isEmpty(email_inter_fact) && !isEmail(email_inter_fact)) { showWarning("Adresse e-mail de facturation incorrecte !"); }
		else if (!isEmpty(telInter1liv) && !isPhone(telInter1liv)) { showWarning("T\u00E9l\u00E9phone 1 de livraison incorrect !"); }
		else if (!isEmpty(telInter2liv) && !isPhone(telInter2liv)) { showWarning("T\u00E9l\u00E9phone 2 de livraison incorrect !"); }
		else if (!isEmpty(fax_inter_liv) && !isPhone(fax_inter_liv)) { showWarning("Num\u00E9ro de fax de livraison incorrect !"); }
		else if (!isEmpty(email_inter_liv) && !isEmail(email_inter_liv)) { showWarning("Adresse e-mail de livraison incorrecte !"); }
		else if (!isEmpty(telInter1envoi) && !isPhone(telInter1envoi)) { showWarning("T\u00E9l\u00E9phone 1 d'envoi incorrect !"); }
		else if (!isEmpty(telInter2envoi) && !isPhone(telInter2envoi)) { showWarning("T\u00E9l\u00E9phone 2 d'envoi incorrect !"); }
		else if (!isEmpty(fax_inter_envoi) && !isPhone(fax_inter_envoi)) { showWarning("Num\u00E9ro de fax d'envoi incorrect !"); }
		else if (!isEmpty(email_inter_envoi) && !isEmail(email_inter_envoi)) { showWarning("Adresse e-mail d'envoi incorrecte !"); }
		else if (chkDecrStock && isEmpty(depotStock)) { showWarning("Veuillez indiquer un d\u00E9p\u00F4t de stock"); }
		else {

			frais_port = parseFloat(frais_port);
			remise = parseFloat(remise);
			remiseFP = parseFloat(remiseFP);

			if (oef_typeRemise=='P') {
				taux_remise = remise;
			}
			else {
				taux_remise = (montant_base>0?remise/montant_base*100:0);
				montant_remise = remise;
			}

			if (oef_typeRemiseFP=='P') {
				tauxRemiseFP = remiseFP;
			}
			else {
				tauxRemiseFP = (frais_port>0?remiseFP/frais_port*100:0);
				montantRemiseFP = remiseFP;
			}

			if (oef_assujettiTVA && code_pays_liv!="FR" && isEmpty(num_tva) && oef_zoneUE) {
				showWarning("Attention : vous n'avez pas saisi le num\u00E9ro de tva intra-communautaire !");
			}

			var qSave;

			if (oef_mode=="C") {
				qSave = new QueryHttp("Facturation/FacturesVente/createFactureClient.tmpl");
			}
			else {
				qSave = new QueryHttp("Facturation/FacturesVente/updateFactureClient.tmpl");
				qSave.setParam("Facture_Id", oef_factureId);
			}

			qSave.setParam("Util_R", utilR);
			qSave.setParam("Mode_Envoi_Facture", modeEnvoiFacture);
			qSave.setParam("Pole_Activite", secteurActivite);
			qSave.setParam("Etab_Id", etablissement);
			qSave.setParam("Depot_Id", depotStock);
			qSave.setParam("Code_TVA_Port", oef_codeTVAPort);
			qSave.setParam("Taux_TVA_Port", oef_tauxTVAPort);
			qSave.setParam("Tarif_Id", document.getElementById("oef-Tarif_Id").value);
      qSave.setParam("Client_Id", oef_clientId);
			qSave.setParam("PRemise", taux_remise);
			qSave.setParam("MRemise", montant_remise);
			qSave.setParam("PRemise_FP", tauxRemiseFP);
			qSave.setParam("MRemise_FP", montantRemiseFP);
      qSave.setParam("Frais_Port", frais_port);
			qSave.setParam("Date_Echeance", echeance);
			qSave.setParam("Mode_Reg_Id", modeReglement);
      qSave.setParam("Escompte", escompte);
      qSave.setParam("Montant_Deduction", montantDeduction);
			qSave.setParam("Commentaires_Fin", document.getElementById('oef-Commentaires_Fin').value);
			qSave.setParam("Commentaires_Int", document.getElementById('oef-Commentaires_Int').value);
			qSave.setParam("Edition_TTC", document.getElementById('oef-Edition_TTC').checked);
			qSave.setParam("Assujetti_TVA", oef_assujettiTVA);
			qSave.setParam("Num_TVA_Intra", num_tva);
			qSave.setParam("Regime_TVA", document.getElementById('oef-Regime_TVA').value);

      qSave.setParam("Denomination", denomination_fact);
      qSave.setParam("Adresse_1", adresse_1_fact);
      qSave.setParam("Adresse_2", adresse_2_fact);
			qSave.setParam("Adresse_3", adresse_3_fact);
      qSave.setParam("Code_Postal", code_postal_fact);
      qSave.setParam("Ville", ville_fact);
			qSave.setParam("Code_Pays", code_pays_fact);
			qSave.setParam("Civ_Inter", civ_inter_fact);
			qSave.setParam("Nom_Inter", nom_inter_fact);
			qSave.setParam("Prenom_Inter", prenom_inter_fact);
			qSave.setParam("Tel_Inter_1", telInter1fact);
			qSave.setParam("Tel_Inter_2", telInter2fact);
			qSave.setParam("Fax_Inter", fax_inter_fact);
			qSave.setParam("Email_Inter", email_inter_fact);

			qSave.setParam("Denomination_Liv", denomination_liv);
			qSave.setParam("Adresse_1_Liv", adresse_1_liv);
			qSave.setParam("Adresse_2_Liv", adresse_2_liv);
			qSave.setParam("Adresse_3_Liv", adresse_3_liv);
			qSave.setParam("Code_Postal_Liv", code_postal_liv);
			qSave.setParam("Ville_Liv", ville_liv);
			qSave.setParam("Code_Pays_Liv", code_pays_liv);
			qSave.setParam("Civ_Inter_Liv", civ_inter_liv);
			qSave.setParam("Nom_Inter_Liv", nom_inter_liv);
			qSave.setParam("Prenom_Inter_Liv", prenom_inter_liv);
			qSave.setParam("Tel_Inter_1_Liv", telInter1liv);
			qSave.setParam("Tel_Inter_2_Liv", telInter2liv);
			qSave.setParam("Fax_Inter_Liv", fax_inter_liv);
			qSave.setParam("Email_Inter_Liv", email_inter_liv);

			qSave.setParam("Denomination_Envoi", denomination_envoi);
			qSave.setParam("Adresse_1_Envoi", adresse_1_envoi);
			qSave.setParam("Adresse_2_Envoi", adresse_2_envoi);
			qSave.setParam("Adresse_3_Envoi", adresse_3_envoi);
			qSave.setParam("Code_Postal_Envoi", code_postal_envoi);
			qSave.setParam("Ville_Envoi", ville_envoi);
			qSave.setParam("Code_Pays_Envoi", code_pays_envoi);
			qSave.setParam("Civ_Inter_Envoi", civ_inter_envoi);
			qSave.setParam("Nom_Inter_Envoi", nom_inter_envoi);
			qSave.setParam("Prenom_Inter_Envoi", prenom_inter_envoi);
			qSave.setParam("Tel_Inter_1_Envoi", telInter1envoi);
			qSave.setParam("Tel_Inter_2_Envoi", telInter2envoi);
			qSave.setParam("Fax_Inter_Envoi", fax_inter_envoi);
			qSave.setParam("Email_Inter_Envoi", email_inter_envoi);

			var result = qSave.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				if (oef_mode=="C") {
					oef_factureId = result.responseXML.documentElement.getAttribute("Facture_Id");
					oef_aLignes.setParam('Facture_Id', oef_factureId);
					oef_chargerFacture();
				}
				else {
					var contenu = result.responseXML.documentElement;
					oef_bloquerEcheance = (parseFloat(contenu.getAttribute('Net_A_Payer'))==0);
		    	var echModifiable = (contenu.getAttribute('Ech_Modifiable')=="true");
		    	document.getElementById('oef-Echeance').disabled = !echModifiable;
		    	document.getElementById('oef-Mode_Reg').disabled = !echModifiable;
		    	document.getElementById('oef-bEchMultiples').disabled = oef_bloquerEcheance;

					oef_ajouterLigne("I");
					oef_aLignes.initTree(oef_afterRefreshArticles);
				}

				oef_setModified(false);

				save = true;
			}
		}

		return save;

	} catch (e) {
  	recup_erreur(e);
	}
}


function oef_calculTotaux() {
  try {

		if (oef_mode!='V') {
			document.getElementById('oef-Edition_TTC').disabled = (oef_aLignes.nbLignes()>0);
			document.getElementById('oef-chercher_client').collapsed = (oef_aLignes.nbLignes()>0);
	    document.getElementById('oef-Code_Pays_Liv').disabled = (oef_aLignes.nbLignes()>0);
	    document.getElementById('oef-chercher_adrliv').disabled = (isEmpty(oef_clientId) || (oef_aLignes.nbLignes()>0));
			document.getElementById('oef-bCopierFactVersLivEnvoi').disabled = (oef_aLignes.nbLignes()>0);
			document.getElementById('oef-Tarif_Id').disabled = (oef_aLignes.nbLignes()>0);
			document.getElementById('oef-Regime_TVA').disabled = (oef_aLignes.nbLignes()>0);
			document.getElementById('oef-Assujetti_TVA').disabled = (oef_aLignes.nbLignes()>0);
		}

		var remise = parseFloat(document.getElementById('oef-Remise').value);
		var remiseFP = parseFloat(document.getElementById('oef-RemiseFP').value);
		var taux_escompte = parseFloat(document.getElementById('oef-Escompte').value);
		var frais_port = parseFloat(document.getElementById('oef-Frais_Port').value);
		var montantDeduction = parseFloat(document.getElementById('oef-montantDeduction').value);

		if (isPositiveOrNull(remise) && isPositiveOrNull(remiseFP) && isPositiveOrNull(taux_escompte) && isPositiveOrNull(frais_port) && isPositiveOrNull(montantDeduction)) {

			var calculDocument = new CalculDocument();
			calculDocument.setEditionTTC(oef_editionTTC);
			if (oef_typeRemise=='P') { calculDocument.setRemiseP(remise); }
			else { calculDocument.setRemiseM(remise); }
			calculDocument.setFraisPortBruts(frais_port);
			if (oef_typeRemiseFP=='P') { calculDocument.setRemiseFPP(remiseFP); }
			else { calculDocument.setRemiseFPM(remiseFP); }
			calculDocument.setCodeAndTauxTVAFP(document.getElementById('oef-codeTVAFraisPort').value, getTva(document.getElementById('oef-codeTVAFraisPort').value));
			calculDocument.setEscompteP(taux_escompte);
			calculDocument.setAcompte(oef_acompte);

			for (var i=0; i<oef_aLignes.nbLignes(); i++) {
				if (oef_aLignes.getCellText(i,'oef-colTypeLigne')!="C") {
					var montantLigne = oef_aLignes.getCellText(i,'oef-ColTotal');
					var codeTVA = oef_aLignes.getCellText(i,'oef-ColCode_TVA');
					calculDocument.addLigneDocument(montantLigne, codeTVA);
				}
			}

			calculDocument.calculer();

			var fmon = new NumberFormat("0.00", true);

			if (oef_editionTTC) {
				document.getElementById('oef-pttcMontantRemise').value = calculDocument.getRemiseM();
				document.getElementById('oef-pttcMontantFrais_Port').value = calculDocument.getFraisPortBruts();
				document.getElementById('oef-pttcMontantRemiseFP').value = calculDocument.getRemiseFPM();
				document.getElementById('oef-pttcTVA').value = calculDocument.getTotalTVA();
				document.getElementById('oef-pttcMontantTTC').value = calculDocument.getMontantTTC();
				document.getElementById('oef-pttcMontantEscompte').value = calculDocument.getEscompteM();
				document.getElementById('oef-pttcNetCommercial').value = calculDocument.getNetCommercial();
				document.getElementById('oef-pttcMontantAcompte').value = calculDocument.getAcompte();
				document.getElementById('oef-pttcDeduction').value = fmon.format(document.getElementById('oef-montantDeduction').value);
				document.getElementById('oef-pttcTotalTTC').value = calculDocument.getTotalTTC();
				document.getElementById('oef-pttcNetTTC').value = montantDeduction<=0?calculDocument.getNetAPayer():fmon.format(calculDocument.getNetAPayer()-montantDeduction);

				oef_montantTTC = calculDocument.getMontantTTCSansFormat();

				document.getElementById('oef-rowRemiseTTC').collapsed = !calculDocument.afficherRemiseM();
				document.getElementById('oef-rowRemiseFPTTC').collapsed = !calculDocument.afficherRemiseFPM();
				document.getElementById('oef-rowEscompteTTC').collapsed = !calculDocument.afficherEscompteM();
				document.getElementById('oef-rowNetCommercialTTC').collapsed = !calculDocument.afficherNetCommercial();
			}
			else {
				document.getElementById('oef-MontantHT').value = calculDocument.getMontantHT();
				document.getElementById('oef-MontantRemise').value = calculDocument.getRemiseM();
				document.getElementById('oef-MontantFrais_Port').value = calculDocument.getFraisPortBruts();
				document.getElementById('oef-MontantRemiseFP').value = calculDocument.getRemiseFPM();
				document.getElementById('oef-TotalHT').value = calculDocument.getTotalHT();
				document.getElementById('oef-TVA').value = calculDocument.getTotalTVA();
				document.getElementById('oef-MontantEscompte').value = calculDocument.getEscompteM();
				document.getElementById('oef-NetCommercial').value = calculDocument.getNetCommercial();
				document.getElementById('oef-montantAcompte').value = calculDocument.getAcompte();
				document.getElementById('oef-deduction').value = fmon.format(document.getElementById('oef-montantDeduction').value);
				document.getElementById('oef-TotalTTC').value = calculDocument.getTotalTTC();

				oef_montantHT = calculDocument.getMontantHTSansFormat();

				document.getElementById('oef-rowRemiseHT').collapsed = !calculDocument.afficherRemiseM();
				document.getElementById('oef-rowRemiseFPHT').collapsed = !calculDocument.afficherRemiseFPM();
				document.getElementById('oef-rowNetCommercialHT').collapsed = !calculDocument.afficherNetCommercial();
				document.getElementById('oef-rowEscompteHT').collapsed = !calculDocument.afficherEscompteM();
			}
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oef_afterRefreshArticles() {
	try {

		if (oef_toSelectLigne!=null) {
			for (var i=0; i<oef_aLignes.nbLignes(); i++) {
				if (oef_aLignes.getCellText(i, "oef-colLigneId")==oef_toSelectLigne && oef_aLignes.getCellText(i, "oef-colTypeLigne")!="C") {
					oef_aLignes.select(i);
					break;
				}
			}
			oef_toSelectLigne = null;
		}
		oef_aLignes.ensureRowIsVisible(oef_currentIndex);

		document.getElementById('oef-Reference').focus();
		oef_calculTotaux();
		oef_loadRecapitulatif();

	} catch (e) {
  	recup_erreur(e);
	}
}


function oef_demandeEnregistrement() {
  try {

		if (oef_modified) {
			if (window.confirm("Voulez-vous enregistrer les modifications apport\u00E9es \u00E0 la facture ?")) {
				oef_enregistrerFacture();
			}
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oef_setModified(m) {
  try {
  	oef_modified = m;
		if (m) {
			document.getElementById('oef-tabFacture').setAttribute('image', 'chrome://opensi/content/design/icones/modified.png');
			document.getElementById('oef-bApercu').disabled = true;
			document.getElementById('oef-bValiderFacture').disabled = true;
			document.getElementById('oef-bVisualiser').disabled = true;
			document.getElementById('oef-bCopierFacture').disabled = true;
			document.getElementById('oef-bProforma').disabled = true;
			document.getElementById('oef-bEchMultiples').disabled = true;
		}
		else {
			document.getElementById('oef-tabFacture').setAttribute('image', null);
			document.getElementById('oef-bApercu').disabled = (oef_mode=="C");
			document.getElementById('oef-bValiderFacture').disabled = (oef_mode=="C");
			document.getElementById('oef-bVisualiser').disabled = (oef_mode=="C");
			document.getElementById('oef-bCopierFacture').disabled = (oef_mode=="C");
			document.getElementById('oef-bProforma').disabled = (oef_mode=="C");
			document.getElementById('oef-bEchMultiples').disabled = (oef_mode=="C" || oef_bloquerEcheance);
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oef_copierFacture() {
	try {

		if (window.confirm("Voulez-vous copier la facture ?")) {
			var qCopie = new QueryHttp("Facturation/FacturesVente/duplicateFactureClient.tmpl");
			qCopie.setParam("Facture_Id", oef_factureId);
			var result = qCopie.execute();
			oef_factureId = result.responseXML.documentElement.getAttribute('Facture_Id');
			oef_chargerFacture();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oef_debloquerInterface() {
	try {

		document.getElementById('oef-Secteur').disabled = (oef_mode=="V");
		document.getElementById('oef-etablissement').disabled = (oef_mode=="V");
		document.getElementById('oef-chkDecrementerStock').disabled = (oef_mode=="V");
		document.getElementById('oef-depot').disabled = (oef_mode=="V");
		document.getElementById('oef-modeEnvoiFacture').disabled = (oef_mode=="V");
		document.getElementById('oef-Login_Resp').disabled = (oef_mode=="V");
		document.getElementById('oef-Assujetti_TVA').disabled = (oef_mode=="V");
		document.getElementById('oef-Regime_TVA').disabled = (oef_mode=="V");
		document.getElementById('oef-Edition_TTC').disabled = (oef_mode=="V");
		document.getElementById('oef-bCopierFactVersLivEnvoi').disabled = (oef_mode=="V");
		document.getElementById('oef-Tarif_Id').disabled = (oef_mode=="V");

		if (oef_mode=="V") {
			document.getElementById('oef-Denomination_Fact').setAttribute('readonly', true);
			document.getElementById('oef-chercher_client').setAttribute('readonly', true);
			document.getElementById('oef-Adresse_1_Fact').setAttribute('readonly', true);
			document.getElementById('oef-Adresse_2_Fact').setAttribute('readonly', true);
			document.getElementById('oef-Adresse_3_Fact').setAttribute('readonly', true);
			document.getElementById('oef-Code_Postal_Fact').setAttribute('readonly', true);
			document.getElementById('oef-Ville_Fact').setAttribute('readonly', true);
			document.getElementById('oef-Code_Pays_Fact').disabled = true;
			document.getElementById('oef-Civ_Inter_Fact').disabled = true;
			document.getElementById('oef-Nom_Inter_Fact').setAttribute('readonly', true);
			document.getElementById('oef-Prenom_Inter_Fact').setAttribute('readonly', true);
			document.getElementById('oef-Tel_Inter_1_Fact').setAttribute('readonly', true);
			document.getElementById('oef-Tel_Inter_2_Fact').setAttribute('readonly', true);
			document.getElementById('oef-Fax_Inter_Fact').setAttribute('readonly', true);
			document.getElementById('oef-Email_Inter_Fact').setAttribute('readonly', true);

			document.getElementById('oef-Denomination_Liv').setAttribute('readonly', true);
			document.getElementById('oef-Adresse_1_Liv').setAttribute('readonly', true);
			document.getElementById('oef-Adresse_2_Liv').setAttribute('readonly', true);
			document.getElementById('oef-Adresse_3_Liv').setAttribute('readonly', true);
			document.getElementById('oef-Code_Postal_Liv').setAttribute('readonly', true);
			document.getElementById('oef-Ville_Liv').setAttribute('readonly', true);
			document.getElementById('oef-Code_Pays_Liv').disabled = true;
			document.getElementById('oef-Civ_Inter_Liv').disabled = true;
			document.getElementById('oef-Nom_Inter_Liv').setAttribute('readonly', true);
			document.getElementById('oef-Prenom_Inter_Liv').setAttribute('readonly', true);
			document.getElementById('oef-Tel_Inter_1_Liv').setAttribute('readonly', true);
			document.getElementById('oef-Tel_Inter_2_Liv').setAttribute('readonly', true);
			document.getElementById('oef-Fax_Inter_Liv').setAttribute('readonly', true);
			document.getElementById('oef-Email_Inter_Liv').setAttribute('readonly', true);

			document.getElementById('oef-Denomination_Envoi').setAttribute('readonly', true);
			document.getElementById('oef-Adresse_1_Envoi').setAttribute('readonly', true);
			document.getElementById('oef-Adresse_2_Envoi').setAttribute('readonly', true);
			document.getElementById('oef-Adresse_3_Envoi').setAttribute('readonly', true);
			document.getElementById('oef-Code_Postal_Envoi').setAttribute('readonly', true);
			document.getElementById('oef-Ville_Envoi').setAttribute('readonly', true);
			document.getElementById('oef-Code_Pays_Envoi').disabled = true;
			document.getElementById('oef-Civ_Inter_Envoi').disabled = true;
			document.getElementById('oef-Nom_Inter_Envoi').setAttribute('readonly', true);
			document.getElementById('oef-Prenom_Inter_Envoi').setAttribute('readonly', true);
			document.getElementById('oef-Tel_Inter_1_Envoi').setAttribute('readonly', true);
			document.getElementById('oef-Tel_Inter_2_Envoi').setAttribute('readonly', true);
			document.getElementById('oef-Fax_Inter_Envoi').setAttribute('readonly', true);
			document.getElementById('oef-Email_Inter_Envoi').setAttribute('readonly', true);
		}
		else {
			document.getElementById('oef-Denomination_Fact').removeAttribute('readonly');
			document.getElementById('oef-chercher_client').removeAttribute('readonly');
			document.getElementById('oef-Adresse_1_Fact').removeAttribute('readonly');
			document.getElementById('oef-Adresse_2_Fact').removeAttribute('readonly');
			document.getElementById('oef-Adresse_3_Fact').removeAttribute('readonly');
			document.getElementById('oef-Code_Postal_Fact').removeAttribute('readonly');
			document.getElementById('oef-Ville_Fact').removeAttribute('readonly');
			document.getElementById('oef-Code_Pays_Fact').disabled = false;
			document.getElementById('oef-Civ_Inter_Fact').disabled = false;
			document.getElementById('oef-Nom_Inter_Fact').removeAttribute('readonly');
			document.getElementById('oef-Prenom_Inter_Fact').removeAttribute('readonly');
			document.getElementById('oef-Tel_Inter_1_Fact').removeAttribute('readonly');
			document.getElementById('oef-Tel_Inter_2_Fact').removeAttribute('readonly');
			document.getElementById('oef-Fax_Inter_Fact').removeAttribute('readonly');
			document.getElementById('oef-Email_Inter_Fact').removeAttribute('readonly');

			document.getElementById('oef-Denomination_Liv').removeAttribute('readonly');
			document.getElementById('oef-Adresse_1_Liv').removeAttribute('readonly');
			document.getElementById('oef-Adresse_2_Liv').removeAttribute('readonly');
			document.getElementById('oef-Adresse_3_Liv').removeAttribute('readonly');
			document.getElementById('oef-Code_Postal_Liv').removeAttribute('readonly');
			document.getElementById('oef-Ville_Liv').removeAttribute('readonly');
			document.getElementById('oef-Code_Pays_Liv').disabled = false;
			document.getElementById('oef-Civ_Inter_Liv').disabled = false;
			document.getElementById('oef-Nom_Inter_Liv').removeAttribute('readonly');
			document.getElementById('oef-Prenom_Inter_Liv').removeAttribute('readonly');
			document.getElementById('oef-Tel_Inter_1_Liv').removeAttribute('readonly');
			document.getElementById('oef-Tel_Inter_2_Liv').removeAttribute('readonly');
			document.getElementById('oef-Fax_Inter_Liv').removeAttribute('readonly');
			document.getElementById('oef-Email_Inter_Liv').removeAttribute('readonly');

			document.getElementById('oef-Denomination_Envoi').removeAttribute('readonly');
			document.getElementById('oef-Adresse_1_Envoi').removeAttribute('readonly');
			document.getElementById('oef-Adresse_2_Envoi').removeAttribute('readonly');
			document.getElementById('oef-Adresse_3_Envoi').removeAttribute('readonly');
			document.getElementById('oef-Code_Postal_Envoi').removeAttribute('readonly');
			document.getElementById('oef-Ville_Envoi').removeAttribute('readonly');
			document.getElementById('oef-Code_Pays_Envoi').disabled = false;
			document.getElementById('oef-Civ_Inter_Envoi').disabled = false;
			document.getElementById('oef-Nom_Inter_Envoi').removeAttribute('readonly');
			document.getElementById('oef-Prenom_Inter_Envoi').removeAttribute('readonly');
			document.getElementById('oef-Tel_Inter_1_Envoi').removeAttribute('readonly');
			document.getElementById('oef-Tel_Inter_2_Envoi').removeAttribute('readonly');
			document.getElementById('oef-Fax_Inter_Envoi').removeAttribute('readonly');
			document.getElementById('oef-Email_Inter_Envoi').removeAttribute('readonly');
		}

		document.getElementById('oef-Code_Stats').disabled = (oef_mode=="V");
		document.getElementById('oef-Reference').disabled = (oef_mode=="V");
		document.getElementById('oef-Designation').disabled = (oef_mode=="V");
		document.getElementById('oef-Num_Lot').disabled = true;
		document.getElementById('oef-Nb_Pieces').disabled = (oef_mode=="V");
		document.getElementById('oef-Quantite').disabled = (oef_mode=="V");
		document.getElementById('oef-Unite').disabled = (oef_mode=="V");
		document.getElementById('oef-Date_Peremption').disabled =true;
		document.getElementById('oef-PU').disabled = (oef_mode=="V" || !oef_modifElemFin);
		document.getElementById('oef-Ristourne').disabled = (oef_mode=="V" || !oef_modifElemFin);
		document.getElementById('oef-bRistourne').disabled = (oef_mode=="V" || !oef_modifElemFin);
		document.getElementById('oef-Code_TVA').disabled = (oef_mode=="V" || !oef_modifElemFin);
		document.getElementById('oef-bArticle').disabled = (oef_mode=="V");
		document.getElementById('oef-bAnnuler').disabled = (oef_mode=="V");
		document.getElementById('oef-bValider').disabled = (oef_mode=="V");
		document.getElementById('oef-Commentaires_Fin').disabled = (oef_mode=="V");
		document.getElementById('oef-Commentaires_Int').disabled = (oef_mode=="V");
		document.getElementById('oef-bChoisirMentions').disabled = (oef_mode=="V");
		document.getElementById('oef-bRemise').disabled = (oef_mode=="V" || !oef_modifElemFin);
		document.getElementById('oef-Remise').disabled = (oef_mode=="V" || !oef_modifElemFin);
		document.getElementById('oef-Frais_Port').disabled = (oef_mode=="V" || !oef_modifElemFin);
		document.getElementById('oef-codeTVAFraisPort').disabled =  (oef_mode=="V" || !oef_modifElemFin);
		document.getElementById('oef-Mode_Reg').disabled =  (oef_mode=="V");
		document.getElementById('oef-Echeance').disabled =  (oef_mode=="V");
		document.getElementById('oef-bRemiseFP').disabled = (oef_mode=="V" || !oef_modifElemFin);
		document.getElementById('oef-RemiseFP').disabled = (oef_mode=="V" || !oef_modifElemFin);
		document.getElementById('oef-Escompte').disabled = (oef_mode=="V" || !oef_modifElemFin);
		document.getElementById('oef-montantDeduction').disabled = (oef_mode=="V" || !oef_modifElemFin);
		document.getElementById('oef-bEnregistrer').disabled = false;

	} catch (e) {
		recup_erreur(e);
	}
}



function oef_nouvelleFacture() {
  try {

		oef_factureId = "";
		oef_mode = "C";
		oef_gen = false;
		document.getElementById('oef-deckFacture').selectedIndex = 0;
		document.getElementById('oef-tabEntete').selectedIndex = 0;
		document.getElementById('oef-tabAdresses').selectedIndex = 0;

		var venteTTC = gConfig.isVenteTTC();

		document.getElementById('oef-Edition_TTC').checked = venteTTC;
		oef_changerTypeEdition(venteTTC);

		document.getElementById('oef-tabVersionDocument').collapsed = true;

		oef_assujettiTVA = false;
		oef_codesTvaInactifs = "";
		oef_codeTVAPort = "";

		document.getElementById('oef-Assujetti_TVA').checked = false;
		document.getElementById('oef-Num_TVA').value = "";
		oef_chargerTarifsVente(gConfig.getTarifDefaut());
		document.getElementById('oef-Regime_TVA').value = "G";
		oef_chargerPolesActivite("");

		oef_chargerModesReglements(oef_defModeReglement);
		oef_chargerEtablissement(etablissementDefaut);
		oef_chargerDepot(oef_depotDefaut);
		document.getElementById('oef-chkDecrementerStock').checked = true;
		document.getElementById('oef-rowDepot').collapsed = false;

		document.getElementById('oef-modeEnvoiFacture').value = gConfig.getDefModeEnvoiFacture();
		document.getElementById('oef-Echeance').disabled = false;
		document.getElementById('oef-Mode_Reg').disabled = false;

		document.getElementById('oef-Commentaires_Fin').value = "";
		document.getElementById('oef-Commentaires_Int').value = "";
		document.getElementById('oef-Date_Facture').value = "";
		document.getElementById('oef-Echeance').value = getDateCourante();
		document.getElementById('oef-Numero').value = "";
		document.getElementById('oef-Remise').value = "0.00";
		document.getElementById('oef-RemiseFP').value = "0.00";
		document.getElementById('oef-Escompte').value = "0.00";
		document.getElementById('oef-montantDeduction').value = "0.00";
		document.getElementById('oef-Frais_Port').value = "0.00";
		oef_acompte = 0;

		document.getElementById('oef-Denomination_Fact').value = "";
		document.getElementById('oef-Adresse_1_Fact').value = "";
		document.getElementById('oef-Adresse_2_Fact').value = "";
		document.getElementById('oef-Adresse_3_Fact').value = "";
		document.getElementById('oef-Code_Postal_Fact').value = "";
		document.getElementById('oef-Ville_Fact').value = "";
		document.getElementById('oef-Code_Pays_Fact').value = "FR";

		document.getElementById('oef-Civ_Inter_Fact').selectedIndex = 0;
		document.getElementById('oef-Nom_Inter_Fact').value = "";
		document.getElementById('oef-Prenom_Inter_Fact').value = "";
		document.getElementById('oef-Tel_Inter_1_Fact').value = "";
		document.getElementById('oef-Tel_Inter_2_Fact').value = "";
		document.getElementById('oef-Fax_Inter_Fact').value = "";
		document.getElementById('oef-Email_Inter_Fact').value = "";

		document.getElementById('oef-Denomination_Liv').value = "";
		document.getElementById('oef-Adresse_1_Liv').value = "";
		document.getElementById('oef-Adresse_2_Liv').value = "";
		document.getElementById('oef-Adresse_3_Liv').value = "";
		document.getElementById('oef-Code_Postal_Liv').value = "";
		document.getElementById('oef-Ville_Liv').value = "";
		document.getElementById('oef-Code_Pays_Liv').value = "FR";
		oef_listeTVAFraisPort();
		oef_selectPaysLiv();

		document.getElementById('oef-Civ_Inter_Liv').selectedIndex = 0;
		document.getElementById('oef-Nom_Inter_Liv').value = "";
		document.getElementById('oef-Prenom_Inter_Liv').value = "";
		document.getElementById('oef-Tel_Inter_1_Liv').value = "";
		document.getElementById('oef-Tel_Inter_2_Liv').value = "";
		document.getElementById('oef-Fax_Inter_Liv').value = "";
		document.getElementById('oef-Email_Inter_Liv').value = "";

		document.getElementById('oef-Denomination_Envoi').value = "";
		document.getElementById('oef-Adresse_1_Envoi').value = "";
		document.getElementById('oef-Adresse_2_Envoi').value = "";
		document.getElementById('oef-Adresse_3_Envoi').value = "";
		document.getElementById('oef-Code_Postal_Envoi').value = "";
		document.getElementById('oef-Ville_Envoi').value = "";
		document.getElementById('oef-Code_Pays_Envoi').value = "FR";

		document.getElementById('oef-Civ_Inter_Envoi').selectedIndex = 0;
		document.getElementById('oef-Nom_Inter_Envoi').value = "";
		document.getElementById('oef-Prenom_Inter_Envoi').value = "";
		document.getElementById('oef-Tel_Inter_1_Envoi').value = "";
		document.getElementById('oef-Tel_Inter_2_Envoi').value = "";
		document.getElementById('oef-Fax_Inter_Envoi').value = "";
		document.getElementById('oef-Email_Inter_Envoi').value = "";

		document.getElementById('oef-MontantHT').value = "0.00";
		document.getElementById('oef-MontantRemise').value = "0.00";
		document.getElementById('oef-MontantFrais_Port').value = "0.00";
		document.getElementById('oef-MontantRemiseFP').value = "0.00";
		document.getElementById('oef-TotalHT').value = "0.00";
		document.getElementById('oef-TVA').value = "0.00";
		document.getElementById('oef-MontantEscompte').value = "0.00";
		document.getElementById('oef-TotalTTC').value = "0.00";
		document.getElementById('oef-montantAcompte').value = "0.00";

		document.getElementById('oef-rowNetCommercialHT').collapsed = true;
		document.getElementById('oef-rowNetCommercialTTC').collapsed = true;
		document.getElementById('oef-pttcNetCommercial').value = "0.00";
		document.getElementById('oef-NetCommercial').value = "0.00";

		document.getElementById('oef-rowRemiseHT').collapsed = true;
		document.getElementById('oef-rowRemiseFPHT').collapsed = true;
		document.getElementById('oef-rowEscompteHT').collapsed = true;

		document.getElementById('oef-pttcMontantRemise').value = "0.00";
		document.getElementById('oef-pttcMontantFrais_Port').value = "0.00";
		document.getElementById('oef-pttcMontantRemiseFP').value = "0.00";
		document.getElementById('oef-pttcTVA').value = "0.00";
		document.getElementById('oef-pttcMontantTTC').value = "0.00";
		document.getElementById('oef-pttcMontantEscompte').value = "0.00";
		document.getElementById('oef-pttcMontantAcompte').value = "0.00";
		document.getElementById('oef-pttcTotalTTC').value = "0.00";
		document.getElementById('oef-pttcNetTTC').value = "0.00";

		oef_montantHT=0;
		oef_montantTTC=0;

		document.getElementById('oef-rowRemiseTTC').collapsed = true;
		document.getElementById('oef-rowRemiseFPTTC').collapsed = true;
		document.getElementById('oef-rowEscompteTTC').collapsed = true;

		document.getElementById('oef-creation').setAttribute("label", "");
		document.getElementById('oef-modification').setAttribute("label", "");
		document.getElementById('oef-document').setAttribute("label", "");
		document.getElementById('oef-numDevisOrigine').value = "";

		oef_chargerResponsables(gProfil.getLoggedUser());
		document.getElementById('oef-numClient').value = "";
		oef_clientId = "";

		oef_ajouterLigne("I");
		oef_typeRistourne = 'P';
		document.getElementById('oef-bRistourne').setAttribute("class", "bIcoPourcentage");

		oef_aLignes.deleteTree();

		document.getElementById('oef-caHT').value = "0.00 \u20AC";
		document.getElementById('oef-paHT').value = "0.00 \u20AC";
		document.getElementById('oef-margeHT').value = "0.00 \u20AC";
		document.getElementById('oef-tauxMarque').value = "0.00 %";
		document.getElementById('oef-tauxMarge').value = "0.00 %";
		document.getElementById('oef-nbLignes').value = "0";
		document.getElementById('oef-qteArticles').value = "0";
		document.getElementById('oef-lblMargeHT').setAttribute("style", "color:black");
		document.getElementById('oef-margeHT').setAttribute("style", "color:black");
		document.getElementById('oef-lblTauxMarque').setAttribute("style", "color:black");
		document.getElementById('oef-tauxMarque').setAttribute("style", "color:black");
		document.getElementById('oef-lblTauxMarge').setAttribute("style", "color:black");
		document.getElementById('oef-tauxMarge').setAttribute("style", "color:black");
		document.getElementById('oef-pictoMargeNegative').collapsed = true;

		document.getElementById('oef-bApercu').collapsed = true;
		document.getElementById('oef-bValiderFacture').collapsed = true;
		document.getElementById('oef-bProforma').collapsed = true;
		document.getElementById('oef-bEnregistrer').collapsed = false;
		document.getElementById('oef-bSupFacture').collapsed = true;
		document.getElementById('oef-bTransAvoir').collapsed = true;
		document.getElementById('oef-bVisualiser').collapsed = true;
		document.getElementById('oef-bCopierFacture').collapsed = true;
		document.getElementById('oef-chercher_client').collapsed = false;

		oef_debloquerInterface();

		document.getElementById('oef-bChoisirMentions').disabled = true;
		document.getElementById('oef-bOuvrirCommentairesCaches').disabled = true;
		document.getElementById('oef-chercher_adrfact').disabled = true;
		document.getElementById('oef-chercher_inter').disabled = true;
		document.getElementById('oef-chercher_adrliv').disabled = true;
		document.getElementById('oef-chercher_inter_liv').disabled = true;
		document.getElementById('oef-chercher_adrenvoi').disabled = true;
		document.getElementById('oef-chercher_inter_envoi').disabled = true;

		oef_setModified(false);

	} catch (e) {
  	recup_erreur(e);
  }
}


function oef_chargerFacture() {
  try {

		oef_mode = "M";
		document.getElementById('oef-deckFacture').selectedIndex = 0;
		document.getElementById('oef-tabEntete').selectedIndex = 0;
		document.getElementById('oef-tabAdresses').selectedIndex = 0;

		var qLoad = new QueryHttp("Facturation/FacturesVente/loadFactureClient.tmpl");
		qLoad.setParam("Facture_Id", oef_factureId);
		var result = qLoad.execute();

    var contenu = result.responseXML.documentElement;

    oef_acompte = contenu.getAttribute('Acompte');
    oef_gen = contenu.getAttribute('Statut')=="V";

		if (oef_gen) {
			oef_mode = "V";
		}

		document.getElementById('oef-bApercu').collapsed = oef_gen;
		document.getElementById('oef-bValiderFacture').collapsed = oef_gen;
		document.getElementById('oef-bProforma').collapsed = oef_gen;
		document.getElementById('oef-bEnregistrer').collapsed = oef_gen;
		document.getElementById('oef-bSupFacture').collapsed = oef_gen;
		document.getElementById('oef-bTransAvoir').collapsed = !oef_gen;
		document.getElementById('oef-bVisualiser').collapsed = !oef_gen;
		document.getElementById('oef-bCopierFacture').collapsed = false;

		oef_typeRemise = (parseFloat(contenu.getAttribute('MRemise'))!=0?'M':'P');
		document.getElementById('oef-Remise').value = (oef_typeRemise=='P'?contenu.getAttribute('PRemise'):contenu.getAttribute('MRemise'));
		document.getElementById('oef-bRemise').setAttribute("class", (oef_typeRemise=='P'?"bIcoPourcentage":"bIcoEuro"));

		oef_typeRemiseFP = (parseFloat(contenu.getAttribute('MRemise_FP'))!=0?'M':'P');
		document.getElementById('oef-RemiseFP').value = (oef_typeRemiseFP=='P'?contenu.getAttribute('PRemise_FP'):contenu.getAttribute('MRemise_FP'));
		document.getElementById('oef-bRemiseFP').setAttribute("class", (oef_typeRemiseFP=='P'?"bIcoPourcentage":"bIcoEuro"));

    document.getElementById('oef-Escompte').value = contenu.getAttribute('Escompte');
		document.getElementById('oef-montantDeduction').value = contenu.getAttribute('Montant_Deduction');
    document.getElementById('oef-Frais_Port').value = contenu.getAttribute('Frais_Port');
    document.getElementById('oef-Commentaires_Fin').value = contenu.getAttribute('Commentaires_Fin');
    document.getElementById('oef-Commentaires_Int').value = contenu.getAttribute('Commentaires_Int');
    document.getElementById('oef-Date_Facture').value = contenu.getAttribute('Date_Facture');
    document.getElementById('oef-Numero').value = contenu.getAttribute('Num_Facture');
    document.getElementById('oef-Echeance').value = contenu.getAttribute('Echeance');
    oef_chargerModesReglements(contenu.getAttribute('Mode_Reg'));
    document.getElementById('oef-modeEnvoiFacture').value = contenu.getAttribute('Mode_Envoi_Facture');
		oef_chargerPolesActivite(contenu.getAttribute('Pole_Activite'));
    oef_chargerEtablissement(contenu.getAttribute('Etab_Id'));
    var depotId = contenu.getAttribute('Depot_Id');

		if (!isEmpty(depotId)) {
			oef_chargerDepot(depotId);
		}
		else {
			// cas d'une copie de facture
			oef_chargerDepot(oef_depotDefaut);
		}

		document.getElementById('oef-chkDecrementerStock').checked = !isEmpty(depotId);
		document.getElementById('oef-rowDepot').collapsed = isEmpty(depotId);

		document.getElementById('oef-Denomination_Fact').value = contenu.getAttribute('Denomination');
		document.getElementById('oef-Adresse_1_Fact').value = contenu.getAttribute('Adresse_1');
		document.getElementById('oef-Adresse_2_Fact').value = contenu.getAttribute('Adresse_2');
		document.getElementById('oef-Adresse_3_Fact').value = contenu.getAttribute('Adresse_3');
		document.getElementById('oef-Code_Postal_Fact').value = contenu.getAttribute('Code_Postal');
		document.getElementById('oef-Ville_Fact').value = contenu.getAttribute('Ville');
		document.getElementById('oef-Code_Pays_Fact').value = contenu.getAttribute('Code_Pays');

		document.getElementById('oef-Denomination_Liv').value = contenu.getAttribute('Denomination_Liv');
		document.getElementById('oef-Adresse_1_Liv').value = contenu.getAttribute('Adresse_1_Liv');
		document.getElementById('oef-Adresse_2_Liv').value = contenu.getAttribute('Adresse_2_Liv');
		document.getElementById('oef-Adresse_3_Liv').value = contenu.getAttribute('Adresse_3_Liv');
		document.getElementById('oef-Code_Postal_Liv').value = contenu.getAttribute('Code_Postal_Liv');
		document.getElementById('oef-Ville_Liv').value = contenu.getAttribute('Ville_Liv');
		document.getElementById('oef-Code_Pays_Liv').value = contenu.getAttribute('Code_Pays_Liv');

		document.getElementById('oef-Civ_Inter_Fact').value = contenu.getAttribute('Civ_Inter');
		document.getElementById('oef-Nom_Inter_Fact').value = contenu.getAttribute('Nom_Inter');
		document.getElementById('oef-Prenom_Inter_Fact').value = contenu.getAttribute('Prenom_Inter');
		document.getElementById('oef-Tel_Inter_1_Fact').value = contenu.getAttribute('Tel_Inter_1');
		document.getElementById('oef-Tel_Inter_2_Fact').value = contenu.getAttribute('Tel_Inter_2');
		document.getElementById('oef-Fax_Inter_Fact').value = contenu.getAttribute('Fax_Inter');
		document.getElementById('oef-Email_Inter_Fact').value = contenu.getAttribute('Email_Inter');

		document.getElementById('oef-Civ_Inter_Liv').value = contenu.getAttribute('Civ_Inter_Liv');
		document.getElementById('oef-Nom_Inter_Liv').value = contenu.getAttribute('Nom_Inter_Liv');
		document.getElementById('oef-Prenom_Inter_Liv').value = contenu.getAttribute('Prenom_Inter_Liv');
		document.getElementById('oef-Tel_Inter_1_Liv').value = contenu.getAttribute('Tel_Inter_1_Liv');
		document.getElementById('oef-Tel_Inter_2_Liv').value = contenu.getAttribute('Tel_Inter_2_Liv');
		document.getElementById('oef-Fax_Inter_Liv').value = contenu.getAttribute('Fax_Inter_Liv');
		document.getElementById('oef-Email_Inter_Liv').value = contenu.getAttribute('Email_Inter_Liv');

		document.getElementById('oef-Denomination_Envoi').value = contenu.getAttribute('Denomination_Envoi');
		document.getElementById('oef-Adresse_1_Envoi').value = contenu.getAttribute('Adresse_1_Envoi');
		document.getElementById('oef-Adresse_2_Envoi').value = contenu.getAttribute('Adresse_2_Envoi');
		document.getElementById('oef-Adresse_3_Envoi').value = contenu.getAttribute('Adresse_3_Envoi');
		document.getElementById('oef-Code_Postal_Envoi').value = contenu.getAttribute('Code_Postal_Envoi');
		document.getElementById('oef-Ville_Envoi').value = contenu.getAttribute('Ville_Envoi');
		document.getElementById('oef-Code_Pays_Envoi').value = contenu.getAttribute('Code_Pays_Envoi');

		document.getElementById('oef-Civ_Inter_Envoi').value = contenu.getAttribute('Civ_Inter_Envoi');
		document.getElementById('oef-Nom_Inter_Envoi').value = contenu.getAttribute('Nom_Inter_Envoi');
		document.getElementById('oef-Prenom_Inter_Envoi').value = contenu.getAttribute('Prenom_Inter_Envoi');
		document.getElementById('oef-Tel_Inter_1_Envoi').value = contenu.getAttribute('Tel_Inter_1_Envoi');
		document.getElementById('oef-Tel_Inter_2_Envoi').value = contenu.getAttribute('Tel_Inter_2_Envoi');
		document.getElementById('oef-Fax_Inter_Envoi').value = contenu.getAttribute('Fax_Inter_Envoi');
		document.getElementById('oef-Email_Inter_Envoi').value = contenu.getAttribute('Email_Inter_Envoi');

    oef_chargerTarifsVente(contenu.getAttribute('Tarif_Id'));
    document.getElementById('oef-Regime_TVA').value = contenu.getAttribute('Regime_TVA');
    oef_codeTVAPort = contenu.getAttribute('Code_TVA_Port');
    oef_tauxTVAPort = contenu.getAttribute('Taux_TVA_Port');
    oef_assujettiTVA = (contenu.getAttribute('Assujetti_TVA')=="true");
		oef_codesTvaInactifs = contenu.getAttribute('Codes_TVA_Inactifs');

		var typeEdition = (contenu.getAttribute('Edition_TTC')=="true");

		document.getElementById('oef-Edition_TTC').checked = typeEdition;

		document.getElementById('oef-Assujetti_TVA').checked = oef_assujettiTVA;
		document.getElementById('oef-Num_TVA').value = contenu.getAttribute("Num_TVA_Intra");

		oef_clientId = contenu.getAttribute('Client_Id');
    var client_connu = !isEmpty(oef_clientId);
		document.getElementById('oef-numClient').value = contenu.getAttribute('Num_Client');

		oef_chargerResponsables(contenu.getAttribute('Util_R'));

    document.getElementById('oef-creation').label = "Facture cr\u00E9\u00E9e le "+ contenu.getAttribute('Date_Creation') +" par "+ contenu.getAttribute('Login_Createur');
    document.getElementById('oef-modification').label = "Derni\u00E8re modification le "+ contenu.getAttribute('Date_Maj') +" par "+ contenu.getAttribute('Login_Maj');
    document.getElementById('oef-document').label = "Facture N\u00B0 "+ contenu.getAttribute('Num_Facture');
		document.getElementById('oef-numDevisOrigine').value = contenu.getAttribute('Num_Devis_Origine');

    document.getElementById('oef-tabVersionDocument').collapsed = false;
    oef_initVersion();

    oef_bloquerEcheance = (parseFloat(contenu.getAttribute('Net_A_Payer'))==0);

		document.getElementById('oef-chercher_adrfact').disabled = !client_connu || oef_mode=='V';
  	document.getElementById('oef-chercher_inter').disabled = !client_connu || oef_mode=='V';
  	document.getElementById('oef-chercher_adrliv').disabled = !client_connu || oef_mode=='V';
  	document.getElementById('oef-chercher_inter_liv').disabled = !client_connu || oef_mode=='V';
  	document.getElementById('oef-chercher_adrenvoi').disabled = !client_connu || oef_mode=='V';
  	document.getElementById('oef-chercher_inter_envoi').disabled = !client_connu || oef_mode=='V';
  	document.getElementById('oef-Num_TVA').disabled = !oef_assujettiTVA || oef_mode=='V';

    if (oef_mode!="V") {
	    oef_ajouterLigne("I");

    	var echModifiable = (contenu.getAttribute('Ech_Modifiable')=="true");
    	document.getElementById('oef-Echeance').disabled = !echModifiable;
  		document.getElementById('oef-Mode_Reg').disabled = !echModifiable;
    }
		else {
			oef_formatLigne("");
		}

		oef_debloquerInterface();

		document.getElementById('oef-bAjouterLigne').disabled = true;
    document.getElementById('oef-bOuvrirCommentairesCaches').disabled = false;
    document.getElementById('oef-bEchMultiples').disabled = oef_bloquerEcheance;

    oef_changerTypeEdition(typeEdition);

		oef_loadRecapitulatif();

    oef_setModified(false);

		oef_aLignes.setParam('Facture_Id', oef_factureId);
		oef_aLignes.initTree(oef_chargerFacture2);

	} catch (e) {
    recup_erreur(e);
  }
}


function oef_chargerFacture2() {
	try {

		oef_aCodesTVAFraisPort.setParam("Code_Pays", document.getElementById("oef-Code_Pays_Liv").value);
    oef_aCodesTVAFraisPort.setParam("Regime_TVA", document.getElementById("oef-Regime_TVA").value);
    oef_aCodesTVAFraisPort.setParam("Assujetti_TVA", oef_assujettiTVA);
		oef_aCodesTVAFraisPort.setParam("Selection", oef_codeTVAPort);
		oef_aCodesTVAFraisPort.initTree(oef_selectionTvaPort);

	} catch (e) {
    recup_erreur(e);
  }
}


function oef_selectionTvaPort() {
  try {

   	document.getElementById('oef-codeTVAFraisPort').value = oef_codeTVAPort;
		oef_tauxTVAPort = getTva(oef_codeTVAPort);
		oef_selectPaysLiv();

  } catch (e) {
    recup_erreur(e);
  }
}


function oef_loadRecapitulatif() {
	try {

		var qRecap = new QueryHttp("Facturation/FacturesVente/getRecapitulatifFC.tmpl");
		qRecap.setParam("Facture_Id", oef_factureId);
		var result = qRecap.execute();
		var contenu = result.responseXML.documentElement;

		document.getElementById('oef-caHT').value = contenu.getAttribute("CAHT") +" \u20AC";
		document.getElementById('oef-paHT').value = contenu.getAttribute("PAHT") +" \u20AC";
		document.getElementById('oef-margeHT').value = contenu.getAttribute("Marge_HT") +" \u20AC";
		document.getElementById('oef-tauxMarque').value = contenu.getAttribute("Taux_Marque") +" %";
		document.getElementById('oef-tauxMarge').value = contenu.getAttribute("Taux_Marge") +" %";
		document.getElementById('oef-nbLignes').value = contenu.getAttribute("Nb_Lignes");
		document.getElementById('oef-qteArticles').value = contenu.getAttribute("Qte_Articles");
		document.getElementById('oef-pictoMargeNegative').collapsed = true;
		if (contenu.getAttribute("Marge_Negative")=="true") {
			document.getElementById('oef-lblMargeHT').setAttribute("style", "color:red");
			document.getElementById('oef-margeHT').setAttribute("style", "color:red");
			document.getElementById('oef-lblTauxMarque').setAttribute("style", "color:red");
			document.getElementById('oef-tauxMarque').setAttribute("style", "color:red");
			document.getElementById('oef-lblTauxMarge').setAttribute("style", "color:red");
			document.getElementById('oef-tauxMarge').setAttribute("style", "color:red");
			document.getElementById('oef-pictoMargeNegative').collapsed = false;
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oef_apercuFacture() {
  try {

		var adresse_fact = document.getElementById('oef-Adresse_1_Fact').value;
    var ville_fact = document.getElementById('oef-Ville_Fact').value;
    var frais_port = document.getElementById('oef-Frais_Port').value;

		if ((oef_aLignes.nbLignes()<=0) && frais_port==0) { showWarning("La facture ne contient aucune ligne"); }
		else if (!oef_gen && isEmpty(adresse_fact)) { showWarning("Adresse du client manquante"); }
		else if (!oef_gen && isEmpty(ville_fact)) { showWarning("Ville du client manquante"); }
		else {
			oef_typeEditionPdf = "FC";
			oef_docIdPdf = oef_factureId;
			oef_apercu = true;

			var qLangueDefaut = new QueryHttp("Facturation/Commun/getLangueDefaut.tmpl");
			qLangueDefaut.setParam("Type_Doc", "FC");
			qLangueDefaut.setParam("Doc_Id", oef_factureId);
			var result = qLangueDefaut.execute();
			oef_langueDefaut = result.responseXML.documentElement.getAttribute("Langue_Id");
			oef_aLangues.setParam("Selection", oef_langueDefaut);
			oef_aLangues.initTree(oef_initLangue);
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oef_editerFacture() {
  try {

		var montantBase = (oef_editionTTC?oef_montantTTC:oef_montantHT);
		var remise = document.getElementById('oef-Remise').value;
		var adresse_fact = document.getElementById('oef-Adresse_1_Fact').value;
    var ville_fact = document.getElementById('oef-Ville_Fact').value;
    var frais_port = document.getElementById('oef-Frais_Port').value;

		if ((oef_aLignes.nbLignes()<=0) && frais_port==0) { showWarning("La facture ne contient aucune ligne"); }
		else if (isEmpty(remise) || (oef_typeRemise=='P'?!isTaux(remise):!isPositiveOrNull(remise) || !checkNumber(remise,9,2) || parseFloat(remise)>montantBase)) {
			showWarning("Remise incorrecte !");
		}
		else if (!oef_gen && isEmpty(adresse_fact)) { showWarning("Adresse du client manquante"); }
		else if (!oef_gen && isEmpty(ville_fact)) { showWarning("Ville du client manquante"); }
		else {
			var ok = true;

		  if (!oef_gen) {
		    var qCheck = new QueryHttp("Facturation/FacturesVente/checkEcheancesFacture.tmpl");
		    qCheck.setParam("Facture_Id", oef_factureId);
		    var result = qCheck.execute();

				var errors = new Errors(result);
				if (errors.hasNext()) {
					errors.show();
					ok = false;
				}
		  }

			if (ok && oef_actSuiviSerie && !oef_gen) {
				var qCheck = new QueryHttp("Facturation/FacturesVente/checkNumSerieFC.tmpl");
				qCheck.setParam("Facture_Id", oef_factureId);

				var result = qCheck.execute();
				var errors = new Errors(result);
				if (errors.hasNext()) {
					errors.show();
					ok = false;
				}
			}

			if (ok && (oef_gen || window.confirm("Confirmez-vous la g\u00E9n\u00E9ration de la facture ?\n(Attention la facture g\u00E9n\u00E9r\u00E9e ne pourra plus \u00EAtre modifi\u00E9e !)"))) {
				oef_typeEditionPdf = "FC";
				oef_docIdPdf = oef_factureId;
				oef_apercu = false;

				var qLangueDefaut = new QueryHttp("Facturation/Commun/getLangueDefaut.tmpl");
				qLangueDefaut.setParam("Type_Doc", "FC");
				qLangueDefaut.setParam("Doc_Id", oef_factureId);
				var result = qLangueDefaut.execute();
				oef_langueDefaut = result.responseXML.documentElement.getAttribute("Langue_Id");
				oef_aLangues.setParam("Selection", oef_langueDefaut);
				oef_aLangues.initTree(oef_initLangue);
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oef_visualiserFacture() {
  try {

		var qGenPdf = new QueryHttp("Facturation/FacturesVente/pdfFactureClient.tmpl");
		qGenPdf.setParam('Facture_Id', oef_factureId);
		qGenPdf.setParam('Langue_Id', document.getElementById('oef-langueDefaut').value);
		qGenPdf.setParam('Apercu', oef_apercu);

		var result = qGenPdf.execute();

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}
		else {
			document.getElementById('oef-pdfFacture').setAttribute('src', '');
			document.getElementById('oef-deckFacture').selectedIndex = 1;
			document.getElementById('bRetourFacture').collapsed = false;

			var page = getDirPdf() + result.responseXML.documentElement.getAttribute('FichierPDF');
			document.getElementById('oef-pdfFacture').setAttribute("src", page);
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oef_editerProforma() {
  try {

		var adresse_fact = document.getElementById('oef-Adresse_1_Fact').value;
    var ville_fact = document.getElementById('oef-Ville_Fact').value;
    var frais_port = document.getElementById('oef-Frais_Port').value;

		if ((oef_aLignes.nbLignes()<=0) && frais_port==0) { showWarning("La facture ne contient aucune ligne !"); }
		else if (!oef_gen && isEmpty(adresse_fact)) { showWarning("Adresse du client manquante"); }
		else if (!oef_gen && isEmpty(ville_fact)) { showWarning("Ville du client manquante"); }
		else {
			oef_typeEditionPdf = "PF";

			var qTrans = new QueryHttp("Facturation/FacturesVente/transFactureProforma.tmpl");
			qTrans.setParam("Facture_Id", oef_factureId);
			var result = qTrans.execute();
			var proformaId = result.responseXML.documentElement.getAttribute("Proforma_Id");
			oef_docIdPdf = proformaId;

			var qLangueDefaut = new QueryHttp("Facturation/Commun/getLangueDefaut.tmpl");
			qLangueDefaut.setParam("Type_Doc", "PF");
			qLangueDefaut.setParam("Doc_Id", proformaId);
			var result = qLangueDefaut.execute();
			oef_langueDefaut = result.responseXML.documentElement.getAttribute("Langue_Id");
			oef_aLangues.setParam("Selection", oef_langueDefaut);
			oef_aLangues.initTree(oef_initLangue);
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oef_visualiserProforma() {
  try {

  	document.getElementById('oef-pdfFacture').setAttribute('src', '');
		document.getElementById('oef-deckFacture').selectedIndex = 1;
		document.getElementById('bRetourFacture').collapsed = false;

		var qGenPdf = new QueryHttp("Facturation/Proforma/pdfProforma.tmpl");
		qGenPdf.setParam('Proforma_Id', oef_docIdPdf);
		qGenPdf.setParam('Langue_Id', document.getElementById('oef-langueDefaut').value);

		var result = qGenPdf.execute();
		var page = getDirPdf() + result.responseXML.documentElement.getAttribute('FichierPDF');
		document.getElementById('oef-pdfFacture').setAttribute("src", page);

	} catch (e) {
    recup_erreur(e);
  }
}


function oef_initLangue() {
	try {

		document.getElementById('oef-langueDefaut').value = oef_langueDefaut;
		oef_reediterPdf();

	} catch (e) {
		recup_erreur(e);
	}
}


function oef_reediterPdf() {
	try {

		if (oef_typeEditionPdf=="PF") {
			oef_visualiserProforma();
		}
		else {
			oef_visualiserFacture();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oef_envoyerMail() {
	try {

		var langue = document.getElementById('oef-langueDefaut').value;

		var url = "chrome://opensi/content/popup/popup-envoyerMail.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', oef_typeEditionPdf, oef_docIdPdf, langue);

	}	catch (e) {
    recup_erreur(e);
  }
}


function oef_supprimerFacture() {
  try {

		if (window.confirm("Confirmez-vous la suppression de la facture ?")) {

			var qDelete = new QueryHttp("Facturation/FacturesVente/deleteFactureClient.tmpl");
			qDelete.setParam("Facture_Id", oef_factureId);

			var result = qDelete.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				showMessage("La facture a \u00E9t\u00E9 supprim\u00E9e !");
			}

			retourMenuFactures();
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oef_editerCommentaire() {
  try {

		if (oef_aLignes.isSelected()) {
			var ligneId = oef_aLignes.getSelectedCellText('oef-colLigneId');

			var url = "chrome://opensi/content/facturation/user/commun/popup-commentairesLigne.xul";
    	window.openDialog(url,'','chrome,modal,centerscreen', "FC", ligneId);

			oef_aLignes.initTree(oef_afterRefreshArticles);
			oef_ajouterLigne("I");
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oef_editerPrixAchat() {
  try {

		if (oef_aLignes.isSelected() && gAccesCoutAchat && gProfil.isModifPADV()) {
			var ligneId = oef_aLignes.getSelectedCellText('oef-colLigneId');

			var url = "chrome://opensi/content/facturation/user/commun/popup-modifierPrixAchat.xul";
    	window.openDialog(url,'','chrome,modal,centerscreen', oef_retourEditerPrixAchat, "FC", ligneId);
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oef_retourEditerPrixAchat() {
	try {

		oef_aLignes.initTree(oef_afterRefreshArticles);
		oef_ajouterLigne("I");

	} catch (e) {
		recup_erreur(e);
	}
}


function oef_editerCommentairesInternes() {
  try {

		var url = "chrome://opensi/content/facturation/user/commun/popup-commentairesInternes.xul";
  	window.openDialog(url,'','chrome,modal,centerscreen', "FC", oef_factureId, false);

	} catch (e) {
    recup_erreur(e);
  }
}


function oef_editerCommentairesDocument() {
  try {

		var commentairesFin = document.getElementById('oef-Commentaires_Fin').value;
		var commentairesInt = document.getElementById('oef-Commentaires_Int').value;
		var readOnly = (oef_mode=="V");

		var url = "chrome://opensi/content/facturation/user/commun/popup-commentairesDocument.xul";
  	window.openDialog(url,'','chrome,modal,centerscreen', oef_retourEditerCommentaires, "FC", oef_factureId, commentairesFin, commentairesInt, readOnly);

	} catch (e) {
    recup_erreur(e);
  }
}


function oef_retourEditerCommentaires(commentairesFin, commentairesInt) {
  try {

		document.getElementById('oef-Commentaires_Fin').value = commentairesFin;
		document.getElementById('oef-Commentaires_Int').value = commentairesInt;

	} catch (e) {
    recup_erreur(e);
  }
}


function oef_charger_coord() {
  try {

		var qGet = new QueryHttp("Facturation/Clients/getDefautDocumentVente.tmpl");
		qGet.setParam("Client_Id", oef_clientId);
		var result = qGet.execute();

		var contenu = result.responseXML.documentElement;

		oef_chargerResponsables(contenu.getAttribute('Util_R'));
		oef_chargerTarifsVente(contenu.getAttribute("Tarif_Id"));
		oef_assujettiTVA = contenu.getAttribute("Assujetti_TVA")=="true";
		document.getElementById('oef-Assujetti_TVA').checked = oef_assujettiTVA;
		document.getElementById('oef-Num_TVA').disabled = !oef_assujettiTVA;
		document.getElementById('oef-Num_TVA').value = contenu.getAttribute("Num_TVA_Intra");
		oef_chargerPolesActivite(contenu.getAttribute("Pole_Activite"));
		document.getElementById("oef-modeEnvoiFacture").value = contenu.getAttribute("Mode_Envoi_Facture");
		document.getElementById("oef-Regime_TVA").value = contenu.getAttribute("Regime_TVA");

		document.getElementById('oef-numClient').value = contenu.getAttribute("Num_Client");

		document.getElementById("oef-Denomination_Fact").value = contenu.getAttribute("Denomination_Fact");
		document.getElementById("oef-Adresse_1_Fact").value = contenu.getAttribute("Adresse_1_Fact");
		document.getElementById("oef-Adresse_2_Fact").value = contenu.getAttribute("Adresse_2_Fact");
		document.getElementById("oef-Adresse_3_Fact").value = contenu.getAttribute("Adresse_3_Fact");
		document.getElementById("oef-Code_Postal_Fact").value = contenu.getAttribute("Code_Postal_Fact");
		document.getElementById("oef-Ville_Fact").value = contenu.getAttribute("Ville_Fact");
    document.getElementById("oef-Code_Pays_Fact").value = contenu.getAttribute("Code_Pays_Fact");
		document.getElementById("oef-Civ_Inter_Fact").value = contenu.getAttribute("Civ_Inter_Fact");
		document.getElementById("oef-Nom_Inter_Fact").value = contenu.getAttribute("Nom_Inter_Fact");
		document.getElementById("oef-Prenom_Inter_Fact").value = contenu.getAttribute("Prenom_Inter_Fact");
		document.getElementById("oef-Tel_Inter_1_Fact").value = contenu.getAttribute("Tel_Inter_1_Fact");
		document.getElementById("oef-Tel_Inter_2_Fact").value = contenu.getAttribute("Tel_Inter_2_Fact");
		document.getElementById("oef-Fax_Inter_Fact").value = contenu.getAttribute("Fax_Inter_Fact");
		document.getElementById("oef-Email_Inter_Fact").value = contenu.getAttribute("Email_Inter_Fact");

		document.getElementById("oef-Denomination_Liv").value = contenu.getAttribute("Denomination_Liv");
		document.getElementById("oef-Adresse_1_Liv").value = contenu.getAttribute("Adresse_1_Liv");
		document.getElementById("oef-Adresse_2_Liv").value = contenu.getAttribute("Adresse_2_Liv");
		document.getElementById("oef-Adresse_3_Liv").value = contenu.getAttribute("Adresse_3_Liv");
		document.getElementById("oef-Code_Postal_Liv").value = contenu.getAttribute("Code_Postal_Liv");
		document.getElementById("oef-Ville_Liv").value = contenu.getAttribute("Ville_Liv");
    document.getElementById("oef-Code_Pays_Liv").value = contenu.getAttribute("Code_Pays_Liv");
    document.getElementById("oef-Civ_Inter_Liv").value = contenu.getAttribute("Civ_Inter_Liv");
		document.getElementById("oef-Nom_Inter_Liv").value = contenu.getAttribute("Nom_Inter_Liv");
		document.getElementById("oef-Prenom_Inter_Liv").value = contenu.getAttribute("Prenom_Inter_Liv");
		document.getElementById("oef-Tel_Inter_1_Liv").value = contenu.getAttribute("Tel_Inter_1_Liv");
		document.getElementById("oef-Tel_Inter_2_Liv").value = contenu.getAttribute("Tel_Inter_2_Liv");
		document.getElementById("oef-Fax_Inter_Liv").value = contenu.getAttribute("Fax_Inter_Liv");
		document.getElementById("oef-Email_Inter_Liv").value = contenu.getAttribute("Email_Inter_Liv");

		document.getElementById("oef-Denomination_Envoi").value = contenu.getAttribute("Denomination_Envoi");
		document.getElementById("oef-Adresse_1_Envoi").value = contenu.getAttribute("Adresse_1_Envoi");
		document.getElementById("oef-Adresse_2_Envoi").value = contenu.getAttribute("Adresse_2_Envoi");
		document.getElementById("oef-Adresse_3_Envoi").value = contenu.getAttribute("Adresse_3_Envoi");
		document.getElementById("oef-Code_Postal_Envoi").value = contenu.getAttribute("Code_Postal_Envoi");
		document.getElementById("oef-Ville_Envoi").value = contenu.getAttribute("Ville_Envoi");
    document.getElementById("oef-Code_Pays_Envoi").value = contenu.getAttribute("Code_Pays_Envoi");
    document.getElementById("oef-Civ_Inter_Envoi").value = contenu.getAttribute("Civ_Inter_Envoi");
		document.getElementById("oef-Nom_Inter_Envoi").value = contenu.getAttribute("Nom_Inter_Envoi");
		document.getElementById("oef-Prenom_Inter_Envoi").value = contenu.getAttribute("Prenom_Inter_Envoi");
		document.getElementById("oef-Tel_Inter_1_Envoi").value = contenu.getAttribute("Tel_Inter_1_Envoi");
		document.getElementById("oef-Tel_Inter_2_Envoi").value = contenu.getAttribute("Tel_Inter_2_Envoi");
		document.getElementById("oef-Fax_Inter_Envoi").value = contenu.getAttribute("Fax_Inter_Envoi");
		document.getElementById("oef-Email_Inter_Envoi").value = contenu.getAttribute("Email_Inter_Envoi");

    oef_listeTVAFraisPort();
    oef_selectPaysLiv();

		document.getElementById('oef-Remise').value = contenu.getAttribute("Taux_Remise");
		document.getElementById('oef-Escompte').value = contenu.getAttribute("Taux_Escompte");
		document.getElementById('oef-bRemise').setAttribute("class", "bIcoPourcentage");
		oef_typeRemise = 'P';

		if (!oef_bloquerEcheance) {
			var qCalc = new QueryHttp("Facturation/FacturesVente/calcEcheanceFacture.tmpl");
			qCalc.setParam("Client_Id", oef_clientId);
			var resCalc = qCalc.execute();

			document.getElementById('oef-Echeance').value = resCalc.responseXML.documentElement.getAttribute('Echeance');
			oef_chargerModesReglements(contenu.getAttribute('Mode_Reg_Id'));
		}

		var client_connu = !isEmpty(oef_clientId);
   	document.getElementById('oef-chercher_adrliv').disabled = (!client_connu || oef_aLignes.nbLignes()>0);
    document.getElementById('oef-bCopierFactVersLivEnvoi').disabled = (oef_aLignes.nbLignes()>0);
    document.getElementById('oef-Tarif_Id').disabled = (oef_aLignes.nbLignes()>0);
		document.getElementById('oef-chercher_adrfact').disabled = !client_connu;
		document.getElementById('oef-chercher_inter').disabled = !client_connu;
		document.getElementById('oef-chercher_inter_liv').disabled = !client_connu;
		document.getElementById('oef-chercher_adrenvoi').disabled = !client_connu;
		document.getElementById('oef-chercher_inter_envoi').disabled = !client_connu;

    oef_ajouterLigne("I");

	} catch (e) {
  	recup_erreur(e);
  }
}


function oef_rechercherClient() {
  try {

		var url = "chrome://opensi/content/facturation/user/clients/popup-rechercheClient.xul";
    window.openDialog(url,'','chrome,modal,centerscreen', oef_retourRechercherClient, true, true);

	} catch (e) {
  	recup_erreur(e);
  }
}


function oef_retourRechercherClient(numClient, clientId) {
	try {

		oef_clientId = clientId;
		oef_charger_coord();
		oef_setModified(true);

	} catch (e) {
		recup_erreur(e);
	}
}


function oef_evaluer(field, ev) {
	try {

		var val = field.value;

		if (ev.keyCode==13 && !isEmpty(val) && isArithmetic(val)) {
			field.value = calcExpr(val);
		}

	}	catch(e) {
		recup_erreur(e);
	}
}


function oef_pressOnLineNumberField(field, ev) {
	try {

		var val = field.value;

		if (ev.keyCode==13 && !isEmpty(val)) {
			if (isArithmetic(val)) {
				field.value = calcExpr(val);
			}
			else {
				oef_validerLigne();
			}
		}

	}	catch(e) {
		recup_erreur(e);
	}
}


function oef_changerTypeEdition(chgType) {
	try {

		oef_editionTTC = chgType;

		if (oef_editionTTC) {
			document.getElementById('oef-ColTotal').setAttribute("label", "Total TTC");
			document.getElementById('oef-ColPU').setAttribute("label", "P.U TTC");
			document.getElementById('oef-lblFrais_Port').value = "Frais de port (ttc) :";
			document.getElementById('oef-lblPU').value = "P.U TTC :";
			document.getElementById('oef-piedTTC').collapsed = false;
			document.getElementById('oef-piedHT').collapsed = true;
		}
		else {
			document.getElementById('oef-ColTotal').setAttribute("label", "Total HT");
			document.getElementById('oef-ColPU').setAttribute("label", "P.U HT");
			document.getElementById('oef-lblFrais_Port').value = "Frais de port (ht) :";
			document.getElementById('oef-lblPU').value = "P.U HT :";
			document.getElementById('oef-piedTTC').collapsed = true;
			document.getElementById('oef-piedHT').collapsed = false;
		}


	}	catch(e) {
		recup_erreur(e);
	}
}


function oef_changerAssujettiTVA(etat) {
	try {

		oef_assujettiTVA = etat;
		document.getElementById('oef-Num_TVA').disabled =!oef_assujettiTVA;
		oef_listeTVA();
		oef_setModified(true);

	}	catch(e) {
		recup_erreur(e);
	}
}


function oef_changerTypeVente() {
	try {

	  var qZoneUE = new QueryHttp("Facturation/Commun/getZoneUEPays.tmpl");
	  qZoneUE.setParam("Code_Pays", document.getElementById("oef-Code_Pays_Liv").value);
	  var result = qZoneUE.execute();
	  oef_zoneUE = (result.responseXML.documentElement.getAttribute("Zone_UE")=="true");

	}	catch(e) {
		recup_erreur(e);
	}
}


function oef_rechercherAdrFact() {
  try {

		var url = "chrome://opensi/content/facturation/user/commun/popup-choixAdresse.xul";
    window.openDialog(url,'','chrome,modal,centerscreen', oef_reporterAdrFact, oef_clientId, false);

	} catch (e) {
  	recup_erreur(e);
  }
}


function oef_reporterAdrFact(nom, adr1, adr2, adr3, cp, ville, pays, code_pays, contact_fact, contact_liv, contact_envoi, contact_devis, adresseId) {
  try {

		document.getElementById("oef-Denomination_Fact").value = nom;
		document.getElementById("oef-Adresse_1_Fact").value = adr1;
		document.getElementById("oef-Adresse_2_Fact").value = adr2;
		document.getElementById("oef-Adresse_3_Fact").value = adr3;
		document.getElementById("oef-Code_Postal_Fact").value = cp;
		document.getElementById("oef-Ville_Fact").value = ville;
	  document.getElementById("oef-Code_Pays_Fact").value = code_pays;

	  if (!isEmpty(contact_fact)) {
	  	var qLoad = new QueryHttp("Facturation/Clients/loadContactClient.tmpl");
	  	qLoad.setParam("Contact_Id", contact_fact);
	  	var result = qLoad.execute();
	  	var contenu = result.responseXML.documentElement;
	  	oef_reporterInterFact(contenu.getAttribute("Civilite"),contenu.getAttribute("Nom"),contenu.getAttribute("Prenom"),contenu.getAttribute("Tel_1"),contenu.getAttribute("Tel_2"),contenu.getAttribute("Fax"),contenu.getAttribute("Email"));
	  }
		oef_setModified(true);


	} catch (e) {
  	recup_erreur(e);
  }
}


function oef_rechercherInterlocuteurFact() {
  try {

		var url = "chrome://opensi/content/facturation/user/commun/popup-choixInter.xul";
    window.openDialog(url,'','chrome,modal,centerscreen', oef_reporterInterFact, oef_clientId, false);

	} catch (e) {
  	recup_erreur(e);
  }
}


function oef_reporterInterFact(civ, nom, prenom, tel1, tel2, fax, email) {
  try {

		document.getElementById("oef-Civ_Inter_Fact").value = civ;
		document.getElementById("oef-Nom_Inter_Fact").value = nom;
		document.getElementById("oef-Prenom_Inter_Fact").value = prenom;
		document.getElementById("oef-Tel_Inter_1_Fact").value = tel1;
		document.getElementById("oef-Tel_Inter_2_Fact").value = tel2;
		document.getElementById("oef-Fax_Inter_Fact").value = fax;
		document.getElementById("oef-Email_Inter_Fact").value = email;

		oef_setModified(true);

	} catch (e) {
  	recup_erreur(e);
  }
}


function oef_rechercherAdrEnvoi() {
  try {

		var url = "chrome://opensi/content/facturation/user/commun/popup-choixAdresse.xul";
    window.openDialog(url,'','chrome,modal,centerscreen', oef_reporterAdrEnvoi, oef_clientId, false);

	} catch (e) {
  	recup_erreur(e);
  }
}


function oef_reporterAdrEnvoi(nom, adr1, adr2, adr3, cp, ville, pays, code_pays, contact_fact, contact_liv, contact_envoi, contact_devis, adresseId) {
  try {

		document.getElementById("oef-Denomination_Envoi").value = nom;
		document.getElementById("oef-Adresse_1_Envoi").value = adr1;
		document.getElementById("oef-Adresse_2_Envoi").value = adr2;
		document.getElementById("oef-Adresse_3_Envoi").value = adr3;
		document.getElementById("oef-Code_Postal_Envoi").value = cp;
		document.getElementById("oef-Ville_Envoi").value = ville;
	  document.getElementById("oef-Code_Pays_Envoi").value = code_pays;

	  if (!isEmpty(contact_envoi)) {
	  	var qLoad = new QueryHttp("Facturation/Clients/loadContactClient.tmpl");
	  	qLoad.setParam("Contact_Id", contact_envoi);
	  	var result = qLoad.execute();
	  	var contenu = result.responseXML.documentElement;
	  	oef_reporterInterEnvoi(contenu.getAttribute("Civilite"),contenu.getAttribute("Nom"),contenu.getAttribute("Prenom"),contenu.getAttribute("Tel_1"),contenu.getAttribute("Tel_2"),contenu.getAttribute("Fax"),contenu.getAttribute("Email"));
	  }

		oef_setModified(true);

	} catch (e) {
  	recup_erreur(e);
  }
}


function oef_copierFactVersLivEnvoi() {
	try {
		document.getElementById('oef-Denomination_Liv').value = document.getElementById('oef-Denomination_Fact').value;
		document.getElementById("oef-Adresse_1_Liv").value = document.getElementById("oef-Adresse_1_Fact").value;
		document.getElementById("oef-Adresse_2_Liv").value = document.getElementById("oef-Adresse_2_Fact").value;
		document.getElementById("oef-Adresse_3_Liv").value = document.getElementById("oef-Adresse_3_Fact").value;
		document.getElementById("oef-Code_Postal_Liv").value = document.getElementById("oef-Code_Postal_Fact").value;
		document.getElementById("oef-Ville_Liv").value = document.getElementById("oef-Ville_Fact").value;
	  document.getElementById("oef-Code_Pays_Liv").value = document.getElementById("oef-Code_Pays_Fact").value;
	  oef_listeTVAFraisPort();
	  oef_selectPaysLiv();
	  document.getElementById("oef-Civ_Inter_Liv").value = document.getElementById("oef-Civ_Inter_Fact").value;
		document.getElementById("oef-Nom_Inter_Liv").value = document.getElementById("oef-Nom_Inter_Fact").value;
		document.getElementById("oef-Prenom_Inter_Liv").value = document.getElementById("oef-Prenom_Inter_Fact").value;
		document.getElementById("oef-Tel_Inter_1_Liv").value = document.getElementById("oef-Tel_Inter_1_Fact").value;
		document.getElementById("oef-Tel_Inter_2_Liv").value = document.getElementById("oef-Tel_Inter_2_Fact").value;
		document.getElementById("oef-Fax_Inter_Liv").value = document.getElementById("oef-Fax_Inter_Fact").value;
		document.getElementById("oef-Email_Inter_Liv").value = document.getElementById("oef-Email_Inter_Fact").value;

		document.getElementById('oef-Denomination_Envoi').value = document.getElementById('oef-Denomination_Fact').value;
		document.getElementById("oef-Adresse_1_Envoi").value = document.getElementById("oef-Adresse_1_Fact").value;
		document.getElementById("oef-Adresse_2_Envoi").value = document.getElementById("oef-Adresse_2_Fact").value;
		document.getElementById("oef-Adresse_3_Envoi").value = document.getElementById("oef-Adresse_3_Fact").value;
		document.getElementById("oef-Code_Postal_Envoi").value = document.getElementById("oef-Code_Postal_Fact").value;
		document.getElementById("oef-Ville_Envoi").value = document.getElementById("oef-Ville_Fact").value;
	  document.getElementById("oef-Code_Pays_Envoi").value = document.getElementById("oef-Code_Pays_Fact").value;

	  document.getElementById("oef-Civ_Inter_Envoi").value = document.getElementById("oef-Civ_Inter_Fact").value;
		document.getElementById("oef-Nom_Inter_Envoi").value = document.getElementById("oef-Nom_Inter_Fact").value;
		document.getElementById("oef-Prenom_Inter_Envoi").value = document.getElementById("oef-Prenom_Inter_Fact").value;
		document.getElementById("oef-Tel_Inter_1_Envoi").value = document.getElementById("oef-Tel_Inter_1_Fact").value;
		document.getElementById("oef-Tel_Inter_2_Envoi").value = document.getElementById("oef-Tel_Inter_2_Fact").value;
		document.getElementById("oef-Fax_Inter_Envoi").value = document.getElementById("oef-Fax_Inter_Fact").value;
		document.getElementById("oef-Email_Inter_Envoi").value = document.getElementById("oef-Email_Inter_Fact").value;

		oef_setModified(true);
	} catch (e) {
		recup_erreur(e);
	}
}


function oef_rechercherAdrLiv() {
  try {

		var url = "chrome://opensi/content/facturation/user/commun/popup-choixAdresse.xul";
    window.openDialog(url,'','chrome,modal,centerscreen', oef_reporterAdrLiv, oef_clientId, false);

	} catch (e) {
  	recup_erreur(e);
  }
}


function oef_reporterAdrLiv(nom, adr1, adr2, adr3, cp, ville, pays, code_pays, contact_fact, contact_liv, contact_envoi, contact_devis, adresseId) {
  try {

		document.getElementById("oef-Denomination_Liv").value = nom;
		document.getElementById("oef-Adresse_1_Liv").value = adr1;
		document.getElementById("oef-Adresse_2_Liv").value = adr2;
		document.getElementById("oef-Adresse_3_Liv").value = adr3;
		document.getElementById("oef-Code_Postal_Liv").value = cp;
		document.getElementById("oef-Ville_Liv").value = ville;
	  document.getElementById("oef-Code_Pays_Liv").value = code_pays;
	  oef_listeTVAFraisPort();
	  oef_selectPaysLiv();

		if (!isEmpty(contact_liv)) {
	  	var qLoad = new QueryHttp("Facturation/Clients/loadContactClient.tmpl");
	  	qLoad.setParam("Contact_Id", contact_liv);
	  	var result = qLoad.execute();
	  	var contenu = result.responseXML.documentElement;
	  	oef_reporterInterLiv(contenu.getAttribute("Civilite"),contenu.getAttribute("Nom"),contenu.getAttribute("Prenom"),contenu.getAttribute("Tel_1"),contenu.getAttribute("Tel_2"),contenu.getAttribute("Fax"),contenu.getAttribute("Email"));
	  }
		oef_setModified(true);

	} catch (e) {
  	recup_erreur(e);
  }
}


function oef_rechercherInterlocuteurLiv() {
  try {

		var url = "chrome://opensi/content/facturation/user/commun/popup-choixInter.xul";
    window.openDialog(url,'','chrome,modal,centerscreen', oef_reporterInterLiv, oef_clientId, false);

	} catch (e) {
  	recup_erreur(e);
  }
}


function oef_reporterInterLiv(civ, nom, prenom, tel1, tel2, fax, email) {
  try {
		document.getElementById("oef-Civ_Inter_Liv").value = civ;
		document.getElementById("oef-Nom_Inter_Liv").value = nom;
		document.getElementById("oef-Prenom_Inter_Liv").value = prenom;
		document.getElementById("oef-Tel_Inter_1_Liv").value = tel1;
		document.getElementById("oef-Tel_Inter_2_Liv").value = tel2;
		document.getElementById("oef-Fax_Inter_Liv").value = fax;
		document.getElementById("oef-Email_Inter_Liv").value = email;

		oef_setModified(true);
	} catch (e) {
  	recup_erreur(e);
  }
}


function oef_rechercherInterlocuteurEnvoi() {
  try {

		var url = "chrome://opensi/content/facturation/user/commun/popup-choixInter.xul";
    window.openDialog(url,'','chrome,modal,centerscreen', oef_reporterInterEnvoi, oef_clientId, false);

	} catch (e) {
  	recup_erreur(e);
  }
}


function oef_reporterInterEnvoi(civ, nom, prenom, tel1, tel2, fax, email) {
  try {

		document.getElementById("oef-Civ_Inter_Envoi").value = civ;
		document.getElementById("oef-Nom_Inter_Envoi").value = nom;
		document.getElementById("oef-Prenom_Inter_Envoi").value = prenom;
		document.getElementById("oef-Tel_Inter_1_Envoi").value = tel1;
		document.getElementById("oef-Tel_Inter_2_Envoi").value = tel2;
		document.getElementById("oef-Fax_Inter_Envoi").value = fax;
		document.getElementById("oef-Email_Inter_Envoi").value = email;

		oef_setModified(true);

	} catch (e) {
  	recup_erreur(e);
  }
}



function oef_transformerAvoir() {
	try {

		if (window.confirm("Voulez-vous cr\u00E9er un avoir \u00E0 partir de cette facture ?")) {
			var qTransFact = new QueryHttp("Facturation/FacturesVente/transFactureAvoir.tmpl");
			qTransFact.setParam("Facture_Id", oef_factureId);
			var result = qTransFact.execute();
			oea_avoirId = result.responseXML.documentElement.getAttribute("Avoir_Id");
			document.getElementById('deck').selectedIndex = 2;
			oea_chargerAvoir();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oef_choisirMentions() {
  try {

  	var ok = true;

  	if (oef_mode=="C") {
			ok = oef_enregistrerFacture();
		}

		if (ok) {
			var url = "chrome://opensi/content/facturation/user/commun/popup-mentionsDocument.xul";
    	window.openDialog(url,'','chrome,modal,centerscreen', "FC", oef_factureId, false);
		}

	} catch (e) {
  	recup_erreur(e);
  }
}


function oef_checkOnDecrementerStock(b) {
	try {
		document.getElementById('oef-rowDepot').collapsed = !b;
	} catch (e) {
		recup_erreur(e);
	}
}


function oef_initVersion() {
	try {

		oef_aVersion.setParam("Facture_Id", oef_factureId);
		oef_aVersion.initTree();

	} catch (e) {
		recup_erreur(e);
	}
}


function oef_checkNumSerieLigne(quantite) {
	try {

		if (oef_actSuiviSerie && !isEmpty(oef_articleId)) {

			var qSuiviSerie = new QueryHttp("Facturation/Articles/getSuiviSerie.tmpl");
			qSuiviSerie.setParam("Article_Id", oef_articleId);
			var result = qSuiviSerie.execute();
			var isSuiviSerie = (result.responseXML.documentElement.getAttribute("Suivi_Serie")=="true");

			var wrongNbSerie = false;

			if (oef_modeLigne=="M") {
			  var qNbSerie = new QueryHttp("Facturation/FacturesVente/getNbNumSerieLigneFC.tmpl");
			  qNbSerie.setParam("Ligne_Id", oef_ligneId);
			  var resNS = qNbSerie.execute();
			  var nb = parseIntBis(resNS.responseXML.documentElement.getAttribute("Nombre"));
			  if ((isSuiviSerie && nb!=quantite) || nb>quantite) {
					wrongNbSerie = true;
			  }
		  }

			if ((oef_modeLigne=="C" && isSuiviSerie) || wrongNbSerie) {
				var chkDecrStock = document.getElementById('oef-chkDecrementerStock').checked;
    		var depotId = (chkDecrStock?document.getElementById('oef-depot').value:"");

				var url = "chrome://opensi/content/facturation/user/commun/popup-numSerie.xul";
		    window.openDialog(url,'','chrome,modal,centerscreen', "S", "FC", oef_ligneId, depotId);
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oef_consulterNumSerie() {
	try {

		if (oef_aLignes.isSelected()) {
			var chkDecrStock = document.getElementById('oef-chkDecrementerStock').checked;
    	var depotId = (chkDecrStock?document.getElementById('oef-depot').value:"");

			var url = "chrome://opensi/content/facturation/user/commun/popup-numSerie.xul";
    	window.openDialog(url,'','chrome,modal,centerscreen', (oef_mode!="V"?"S":"C"), "FC", oef_ligneId, depotId);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oef_checkNumLotLigne(numero, datePeremption) {
	try {

		var ok = true;

		if (oef_actSuiviLot && !isEmpty(oef_articleId)) {

			var qSuiviLotDLC = new QueryHttp("Facturation/Articles/getSuiviLotDLC.tmpl");
			qSuiviLotDLC.setParam("Article_Id", oef_articleId);
			var result = qSuiviLotDLC.execute();
			var isSuiviLot = (result.responseXML.documentElement.getAttribute("Suivi_Lot")=="true");
			var isSuiviDLC = (result.responseXML.documentElement.getAttribute("Suivi_DLC")=="true");

			if ((isSuiviLot || !isEmpty(datePeremption)) && isEmpty(numero)) {
				ok = false;
				showWarning("N\u00B0 Lot manquant");
			}
			else if (isSuiviDLC && isEmpty(datePeremption)) {
				ok = false;
				showWarning("Date de p\u00E9remption manquante");
			}
			else if (!isEmpty(datePeremption) && !isDate(datePeremption)) {
				ok = false;
				showWarning("Date de p\u00E9remption incorrecte");
			}
	    else if (!isEmpty(numero) && document.getElementById('oef-chkDecrementerStock').checked) {
				var qLotBloque = new QueryHttp("Facturation/Tracabilite/isLotBloque.tmpl");
				qLotBloque.setParam("Num_Lot", numero);
				qLotBloque.setParam("Article_Id", oef_articleId);
				var resLB = qLotBloque.execute();
				if (resLB.responseXML.documentElement.getAttribute("Bloque")=="true") {
					ok = false;
					showWarning("Impossible de valider la ligne : N\u00B0 Lot bloqu\u00E9");
				}
	    }
		}

		return ok;

	} catch (e) {
		recup_erreur(e);
	}
}


function oef_onKeyPressNumLot(ev) {
	try {

		if (ev.keyCode==13 && !isEmpty(oef_articleId)) {
			var numero = document.getElementById("oef-Num_Lot").value;
			var chkDecrStock = document.getElementById('oef-chkDecrementerStock').checked;
    	var depotId = (chkDecrStock?document.getElementById('oef-depot').value:"");

			var url = "chrome://opensi/content/facturation/user/tracabilite_articles/popup-rechercheLot.xul";
			window.openDialog(url,'','chrome,modal,centerscreen', oef_retourRechercherLot, oef_articleId, numero, depotId, null);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oef_retourRechercherLot(numero, datePeremption) {
	try {

		document.getElementById("oef-Num_Lot").value = numero;
		document.getElementById("oef-Date_Peremption").value = datePeremption;

	} catch (e) {
		recup_erreur(e);
	}
}


function oef_updateDLC() {
	try {

		var numero = document.getElementById("oef-Num_Lot").value;

		if (!isEmpty(numero) && !isEmpty(oef_articleId)) {
			var qGetDLC = new QueryHttp("Facturation/Tracabilite/getDLCNumLot.tmpl");
			qGetDLC.setParam("Article_Id", oef_articleId);
			qGetDLC.setParam("Numero", numero);
			var result = qGetDLC.execute();
			var datePeremption = result.responseXML.documentElement.getAttribute("Date_Peremption");
			if (!isEmpty(datePeremption)) {
				document.getElementById("oef-Date_Peremption").value = datePeremption;
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oef_chargerTarifsVente(selection) {
	try {

		oef_selTarifVente = selection;
		oef_aTarifsVente.setParam("Selection", oef_selTarifVente);
		oef_aTarifsVente.initTree(oef_initTarifVente);

	} catch (e) {
		recup_erreur(e);
	}
}


function oef_initTarifVente() {
  try {

		document.getElementById('oef-Tarif_Id').value = oef_selTarifVente;

	} catch (e) {
  	recup_erreur(e);
	}
}
