/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

var ooa_currentAdrCom;
var ooa_curDepot;
var ooa_aAdrCom = new Arbre("Facturation/Fournisseurs/list-adresseFournisseur.tmpl", "ooa-tree-adrcom");
var ooa_aContactsAdr = new Arbre("ComboListe/combo-contactsFournisseur.tmpl", "ooa-Contact");
var ooa_aDepots = new Arbre("ComboListe/combo-depotsStock.tmpl", "ooa-depotStock");



function ooa_initOngletAdresses() {
	try {

		var aPays = new Arbre("ComboListe/combo-pays.tmpl", "ooa-Code_Pays");
		aPays.initTree(ooa_initContacts);

	} catch (e) {
		recup_erreur(e);
  }
}


function ooa_initContacts() {
	try {

    ooa_aContactsAdr.setParam("Fournisseur_Id", off_fournisseurId);
		ooa_aContactsAdr.initTree(ooa_initAdresses);

	} catch (e) {
    recup_erreur(e);
  }
}


function ooa_initAdresses() {
	try {

		ooa_aAdrCom.setParam("Fournisseur_Id", off_fournisseurId);
		ooa_aAdrCom.initTree(ooa_nouveauAdrCom);

	} catch (e) {
		recup_erreur(e);
	}
}


function ooa_nouveauAdrCom() {
	try {

		ooa_aAdrCom.clearSelection();

		document.getElementById('ooa-Intitule').value = "";
		document.getElementById('ooa-Denomination').value = "";
		document.getElementById('ooa-Adresse_1').value = "";
		document.getElementById('ooa-Adresse_2').value = "";
		document.getElementById('ooa-Adresse_3').value = "";
		document.getElementById('ooa-Code_Postal').value = "";
		document.getElementById('ooa-Ville').value = "";
		document.getElementById('ooa-Code_Pays').value = "FR";
		document.getElementById('ooa-Defaut').checked = false;
		document.getElementById('ooa-Defaut').disabled = false;
		document.getElementById('ooa-Contact').value = "";
		document.getElementById('ooa-Principale').disabled = false;
		document.getElementById('ooa-Principale').checked = false;

		ooa_chargerDepots("");

		document.getElementById('ooa-bNouveauAdrCom').collapsed = true;
		document.getElementById('ooa-bSupprimerAdrCom').collapsed = true;
		document.getElementById('ooa-bModifierAdrCom').collapsed = true;
		document.getElementById('ooa-bCreerAdrCom').collapsed = false;

	} catch (e) {
    recup_erreur(e);
  }
}


function ooa_enregistrerAdrCom(mode) {
  try {

		var intitule = document.getElementById('ooa-Intitule').value;
    var denomination = document.getElementById('ooa-Denomination').value;
		var adresse_1 = document.getElementById('ooa-Adresse_1').value;
		var adresse_2 = document.getElementById('ooa-Adresse_2').value;
		var adresse_3 = document.getElementById('ooa-Adresse_3').value;
		var code_postal = document.getElementById('ooa-Code_Postal').value;
		var ville = document.getElementById('ooa-Ville').value;
		var code_pays = document.getElementById('ooa-Code_Pays').value;
		var defaut = document.getElementById('ooa-Defaut').checked;
		var contact = document.getElementById('ooa-Contact').value;
		var depot = document.getElementById('ooa-depotStock').value;
		var principale = document.getElementById('ooa-Principale').checked;

		if (isEmpty(denomination)) { showWarning("Veuillez sp\u00E9cifier la d\u00E9nomination"); }
		else if (isEmpty(adresse_1)) { showWarning("Veuillez sp\u00E9cifier l'adresse"); }
		else if (isEmpty(ville)) { showWarning("Veuillez sp\u00E9cifier la ville"); }
		else {

			var qSaveAdr;

			if (mode=="C") {
				qSaveAdr = new QueryHttp("Facturation/Fournisseurs/createAdresseFournisseur.tmpl");
			}
			else {
				qSaveAdr = new QueryHttp("Facturation/Fournisseurs/updateAdresseFournisseur.tmpl");
				qSaveAdr.setParam('Adresse_Id', ooa_currentAdrCom);
			}

			qSaveAdr.setParam('Fournisseur_Id', off_fournisseurId);
			qSaveAdr.setParam('Intitule', intitule);
			qSaveAdr.setParam('Denomination', denomination);
			qSaveAdr.setParam('Adresse_1', adresse_1);
			qSaveAdr.setParam('Adresse_2', adresse_2);
			qSaveAdr.setParam('Adresse_3', adresse_3);
			qSaveAdr.setParam('Code_Postal', code_postal);
			qSaveAdr.setParam('Ville', ville);
			qSaveAdr.setParam('Code_Pays', code_pays);
			qSaveAdr.setParam('Defaut', defaut);
			qSaveAdr.setParam('Contact', contact);
			qSaveAdr.setParam('Depot_Defaut', depot);
			qSaveAdr.setParam('Principale', principale);

			var result = qSaveAdr.execute();

			document.getElementById('ooa-Defaut').disabled = defaut;
			document.getElementById('ooa-Principale').disabled = principale;

			if (principale) {
				document.getElementById('off-denomination').value = denomination;
				document.getElementById('off-adresse1').value = adresse_1;
				document.getElementById('off-adresse2').value = adresse_2;
				document.getElementById('off-adresse3').value = adresse_3;
				document.getElementById('off-codePostal').value = code_postal;
				document.getElementById('off-ville').value = ville;
				document.getElementById('off-codePays').value = code_pays;
			}

			if (mode=="C") {
				ooa_currentAdrCom = result.responseXML.documentElement.getAttribute('Adresse_Id');

				document.getElementById('ooa-bCreerAdrCom').collapsed = true;
				document.getElementById('ooa-bModifierAdrCom').collapsed = false;
				document.getElementById('ooa-bNouveauAdrCom').collapsed = false;
				document.getElementById('ooa-bSupprimerAdrCom').collapsed = false;
			}

			ooa_aAdrCom.initTree();
		}

  } catch (e) {
    recup_erreur(e);
  }
}


function ooa_supprimerAdrCom() {
	try {

		var denomination = document.getElementById('ooa-Denomination').value;

		if (window.confirm("Confirmez-vous la suppression de l'adresse '"+ denomination +"' ?")) {

			var qSupAdr = new QueryHttp("Facturation/Fournisseurs/deleteAdresseFournisseur.tmpl");
			qSupAdr.setParam('Adresse_Id', ooa_currentAdrCom);
			var result = qSupAdr.execute();

			var errors = new Errors(result);

			if (errors.hasNext()) {
				errors.show();
			}
			else {
				document.getElementById('ooa-bSupprimerAdrCom').collapsed = true;
				document.getElementById('ooa-bModifierAdrCom').collapsed = true;
				document.getElementById('ooa-bCreerAdrCom').collapsed = false;
				document.getElementById('ooa-bNouveauAdrCom').collapsed = true;

				ooa_aAdrCom.initTree();
				ooa_nouveauAdrCom();
			}
		}

  } catch (e) {
  	recup_erreur(e);
  }
}


function ooa_chargerAdrCom() {
	try {

		if (ooa_aAdrCom.isSelected()) {

			ooa_currentAdrCom = ooa_aAdrCom.getSelectedCellValue('ooa-ColDenomination');

			document.getElementById('ooa-Intitule').value = ooa_aAdrCom.getSelectedCellText('ooa-ColIntitule');
			document.getElementById('ooa-Denomination').value = ooa_aAdrCom.getSelectedCellText('ooa-ColDenomination');
			document.getElementById('ooa-Adresse_1').value = ooa_aAdrCom.getSelectedCellText('ooa-ColAdresse_1');
			document.getElementById('ooa-Adresse_2').value = ooa_aAdrCom.getSelectedCellText('ooa-ColAdresse_2');
			document.getElementById('ooa-Adresse_3').value = ooa_aAdrCom.getSelectedCellText('ooa-ColAdresse_3');
			document.getElementById('ooa-Code_Postal').value = ooa_aAdrCom.getSelectedCellText('ooa-ColCode_Postal');
			document.getElementById('ooa-Ville').value = ooa_aAdrCom.getSelectedCellText('ooa-ColVille');
			document.getElementById('ooa-Code_Pays').value = ooa_aAdrCom.getSelectedCellText('ooa-ColCode_Pays');
			document.getElementById('ooa-Defaut').checked = (ooa_aAdrCom.getSelectedCellText('ooa-ColDefaut')=="true");
			document.getElementById('ooa-Defaut').disabled = document.getElementById('ooa-Defaut').checked;
			document.getElementById('ooa-Principale').checked = (ooa_aAdrCom.getSelectedCellText('ooa-ColPrincipale')=="true");
			document.getElementById('ooa-Principale').disabled = document.getElementById('ooa-Principale').checked;

			ooa_chargerDepots(ooa_aAdrCom.getSelectedCellText('ooa-colDepotStock'));

			document.getElementById('ooa-Contact').value = (isEmpty(ooa_aAdrCom.getSelectedCellText('ooa-ColLib_Contact'))?"":ooa_aAdrCom.getSelectedCellText('ooa-ColContact'));

			document.getElementById('ooa-bSupprimerAdrCom').collapsed = false;
			document.getElementById('ooa-bModifierAdrCom').collapsed = false;
			document.getElementById('ooa-bNouveauAdrCom').collapsed = false;
			document.getElementById('ooa-bCreerAdrCom').collapsed = true;
		}

 	} catch (e) {
    recup_erreur(e);
  }
}


function ooa_chargerDepots(selection) {
	try {

		ooa_curDepot = selection;
		ooa_aDepots.setParam("Selection", selection);
		ooa_aDepots.setParam("Depot_Vente", false);
		ooa_aDepots.setParam("Depot_Quarantaine", false);
		ooa_aDepots.initTree(ooa_initDepot);

	} catch (e) {
		recup_erreur(e);
	}
}


function ooa_initDepot() {
	try {

		document.getElementById('ooa-depotStock').value = ooa_curDepot;

	} catch (e) {
		recup_erreur(e);
	}
}
