/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

var oob_currentBanque;
var oob_aBanques = new Arbre("Facturation/Fournisseurs/list-banqueFournisseur.tmpl", "oob-tree-banques");



function oob_initOngletBanques() {
	try {

		oob_aBanques.setParam("Fournisseur_Id", off_fournisseurId);
		oob_aBanques.initTree();
		oob_nouveauBanque();

	} catch (e) {
		recup_erreur(e);
  }
}


function oob_makeIBAN() {
	try {

		var suite_iban = "";
		if (!document.getElementById('oob-international').checked) {
			suite_iban += document.getElementById('oob-Code_Banque').value;
			suite_iban += document.getElementById('oob-Code_Guichet').value;
			suite_iban += document.getElementById('oob-Num_Compte').value;
			suite_iban += document.getElementById('oob-Cle_RIB').value;
		}

		document.getElementById('oob-IBAN_Suite').value = suite_iban;

	} catch (e) {
    recup_erreur(e);
  }
}


function oob_nouveauBanque() {
	try {

		oob_aBanques.clearSelection();

		document.getElementById('oob-Nom_Banque').value = "";
		document.getElementById('oob-Domiciliation').value = "";
		document.getElementById('oob-Code_Banque').value = "";
		document.getElementById('oob-Code_Guichet').value = "";
		document.getElementById('oob-Num_Compte').value = "";
		document.getElementById('oob-Cle_RIB').value = "";
		document.getElementById('oob-IBAN').value = "";
		document.getElementById('oob-BIC').value = "";
		document.getElementById('oob-IBAN_Suite').value = "";
		document.getElementById('oob-Principale').checked = false;
		document.getElementById('oob-Principale').disabled = false;
		document.getElementById('oob-bNouveauBanque').collapsed = true;
		document.getElementById('oob-bSupprimerBanque').collapsed = true;
		document.getElementById('oob-bModifierBanque').collapsed = true;
		document.getElementById('oob-bCreerBanque').collapsed = false;

	} catch (e) {
    recup_erreur(e);
  }
}


function oob_supprimerBanque() {
	try {

		var nomBanque = document.getElementById('oob-Nom_Banque').value;

		if (window.confirm("Confirmez-vous la suppression de la banque '"+ nomBanque +"' ?")) {

			var qSup = new QueryHttp("Facturation/Fournisseurs/deleteBanqueFournisseur.tmpl");
			qSup.setParam("Banque_Id", oob_currentBanque);
			var result = qSup.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				document.getElementById('oob-bSupprimerBanque').collapsed = true;
				document.getElementById('oob-bModifierBanque').collapsed = true;
				document.getElementById('oob-bCreerBanque').collapsed = false;
				document.getElementById('oob-bNouveauBanque').collapsed = true;
				oob_aBanques.initTree();
				oob_nouveauBanque();
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oob_enregistrerBanque(mode) {
	try {

    var nomBanque = document.getElementById('oob-Nom_Banque').value;
    var domiciliation = document.getElementById('oob-Domiciliation').value;
    var codeBanque = document.getElementById('oob-Code_Banque').value;
    var code_guichet = document.getElementById('oob-Code_Guichet').value;
    var num_compte = document.getElementById('oob-Num_Compte').value;
    var cle_rib = document.getElementById('oob-Cle_RIB').value;
    var deb_iban=document.getElementById('oob-IBAN').value;
    var fin_iban = document.getElementById('oob-IBAN_Suite').value;
    var iban = document.getElementById('oob-IBAN').value+document.getElementById('oob-IBAN_Suite').value;
    var bic = document.getElementById('oob-BIC').value;
    var international = document.getElementById('oob-international').checked;
		var principale = document.getElementById('oob-Principale').checked;

		if (isEmpty(nomBanque)) { showWarning("Veuillez sp\u00E9cifier le nom de la banque !"); }
		else if (isEmpty(domiciliation)) { showWarning("Veuillez sp\u00E9cifier la domiciliation"); }
		else if (!international && isEmpty(codeBanque)) { showWarning("Veuillez sp\u00E9cifier le code banque !"); }
		else if (!international && isEmpty(code_guichet)) { showWarning("Veuillez sp\u00E9cifier le code guichet !"); }
		else if (!international && isEmpty(num_compte)) { showWarning("Veuillez sp\u00E9cifier le num\u00E9ro de compte !"); }
		else if (!international && isEmpty(cle_rib)) { showWarning("Veuillez sp\u00E9cifier la cl\u00E9 de RIB !"); }
		else if (international && (isEmpty(deb_iban) || isEmpty(fin_iban))) { showWarning("Veuillez sp\u00E9cifier le num\u00E9ro IBAN !"); }
    else if (!international && !isCodeBanque(codeBanque)) { showWarning("Code banque incorrect !"); }
    else if (!international && !isCodeGuichet(code_guichet)) { showWarning("Code guichet incorrect !"); }
    else if (!international && !isNumCompte(num_compte)) { showWarning("Num\u00E9ro de compte incorrect !"); }
    else if (!international && !isCleRIB(cle_rib)) { showWarning("Cl\u00E9 de RIB incorrect !"); }
    else if ((international || !isEmpty(deb_iban)) && !isPrefIBAN(deb_iban)) { showWarning("IBAN incorrect !"); }
    else if (!international && !isEmpty(bic) && !isBIC(bic)) { showWarning("BIC incorrect !"); }
    else if (!international && !verifCleRIB(cle_rib, fin_iban)) { showWarning("Echec du contr\u00F4le de la cl\u00E9 de RIB ! Erreur probable sur Num\u00E9ro de compte, Code banque ou Code guichet"); }
    else if ((international || !isEmpty(deb_iban)) && !verifCleIBAN(deb_iban.substring(2,4), deb_iban, fin_iban)) { showWarning("Echec du contr\u00F4le de la cl\u00E9 IBAN ! Erreur probable sur Num\u00E9ro IBAN, Num\u00E9ro de compte, Code banque ou Code guichet"); }
		else {

			var qSave;

			if (mode=="C") {
				qSave = new QueryHttp("Facturation/Fournisseurs/createBanqueFournisseur.tmpl");
				qSave.setParam('Fournisseur_Id', off_fournisseurId);
			}
			else {
				qSave = new QueryHttp("Facturation/Fournisseurs/updateBanqueFournisseur.tmpl");
				qSave.setParam('Banque_Id', oob_currentBanque);
			}

			qSave.setParam('Nom_Banque', nomBanque);
			qSave.setParam('Domiciliation', domiciliation);
			qSave.setParam('BIC', bic);
			qSave.setParam('Principale', principale);
			qSave.setParam('Code_Banque', (international?"":codeBanque));
			qSave.setParam('Code_Guichet', (international?"":code_guichet));
			qSave.setParam('Num_Compte', (international?"":num_compte));
			qSave.setParam('Cle_RIB', (international?"":cle_rib));
			qSave.setParam('IBAN', (international || deb_iban!=""?iban:""));

			var result = qSave.execute();

			document.getElementById('oob-Principale').disabled = principale;

			if (mode=="C") {
				oob_currentBanque = result.responseXML.documentElement.getAttribute('Banque_Id');
				document.getElementById('oob-bCreerBanque').collapsed = true;
				document.getElementById('oob-bModifierBanque').collapsed = false;
				document.getElementById('oob-bNouveauBanque').collapsed = false;
				document.getElementById('oob-bSupprimerBanque').collapsed = false;
			}

			oob_aBanques.initTree();
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oob_changer_type(international) {
  try {

    document.getElementById("oob-row_Code_Banque").collapsed = international;
    document.getElementById("oob-row_Code_Guichet").collapsed = international;
    document.getElementById("oob-row_Num_Compte").collapsed = international;
    document.getElementById("oob-row_Cle_RIB").collapsed = international;
		if (!international) {
			document.getElementById("oob-IBAN_Suite").setAttribute("readonly", true);
    	oob_makeIBAN();
		}
		else {
			document.getElementById("oob-IBAN_Suite").removeAttribute("readonly");
		}

  } catch (e) {
    recup_erreur(e);
  }
}


function oob_chargerBanque() {
	try {

		if (oob_aBanques.isSelected()) {
			var banqueId = oob_aBanques.getSelectedCellValue('oob-ColNom_Banque');

			var qLoad = new QueryHttp("Facturation/Fournisseurs/getBanqueFournisseur.tmpl");
			qLoad.setParam("Banque_Id", banqueId);
			var result = qLoad.execute();
      var contenu = result.responseXML.documentElement;

			oob_currentBanque = contenu.getAttribute('Banque_Id');
			document.getElementById('oob-Nom_Banque').value = contenu.getAttribute('Nom_Banque');
			document.getElementById('oob-Domiciliation').value = contenu.getAttribute('Domiciliation');
			document.getElementById('oob-Code_Banque').value = contenu.getAttribute('Code_Banque');
			document.getElementById('oob-Code_Guichet').value = contenu.getAttribute('Code_Guichet');
			document.getElementById('oob-Num_Compte').value = contenu.getAttribute('Num_Compte');
			document.getElementById('oob-Cle_RIB').value = contenu.getAttribute('Cle_RIB');
			document.getElementById('oob-IBAN').value = contenu.getAttribute('IBAN');
      document.getElementById('oob-IBAN_Suite').value = contenu.getAttribute('IBAN_Suite');
      document.getElementById('oob-BIC').value = contenu.getAttribute('BIC');
			document.getElementById('oob-Principale').checked = (contenu.getAttribute('Principale')=="true");
			document.getElementById('oob-Principale').disabled = document.getElementById('oob-Principale').checked;
      document.getElementById('oob-bSupprimerBanque').collapsed = false;
      document.getElementById('oob-bModifierBanque').collapsed = false;
      document.getElementById('oob-bNouveauBanque').collapsed = false;
      document.getElementById('oob-bCreerBanque').collapsed = true;
      document.getElementById('oob-international').checked=document.getElementById('oob-Code_Banque').value=="";

			oob_changer_type(document.getElementById('oob-international').checked);
		}

 	} catch (e) {
    recup_erreur(e);
  }
}
