/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

/*
	Arguments du popup :
		- 0 : Fonction de retour
*/

jsLoader.loadSubScript("chrome://opensi/content/libs/verif.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/arbres.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");


var aFournisseurs = new Arbre("Facturation/Fournisseurs/list-ficheFournisseur.tmpl", "listeFournisseurs");
var qListFF = new QueryHttp("Facturation/Fournisseurs/getDataListFF.tmpl");

var pageCourante;
var nbPages;



function init() {
  try {

		var aFamilles = new Arbre('ComboListe/combo-famillesFournisseur.tmpl', 'famille');
		aFamilles.initTree();

		var aPays = new Arbre("ComboListe/combo-pays.tmpl", "pays");
		aPays.initTree();

    document.getElementById('numFournisseur').focus();

  } catch (e) {
    recup_erreur(e);
  }
}


function pressOnNumFournisseur(ev) {
  try {

		if (ev.keyCode==13) {
			checkFournisseur(document.getElementById('numFournisseur').value);
    }

  } catch (e) {
    recup_erreur(e);
  }
}


function pressOnCritere(ev) {
  try {

    if (ev.keyCode==13) {
			listerFournisseurs();
    }

  } catch (e) {
    recup_erreur(e);
  }
}


function checkFournisseur(numFournisseur) {
  try {

		var qSearch = new QueryHttp("Facturation/Fournisseurs/searchNumFournisseur.tmpl");
		qSearch.setParam('Num_Fournisseur', numFournisseur);

		var result = qSearch.execute();
		var contenu = result.responseXML.documentElement;

		var fournisseurId = contenu.getAttribute('Fournisseur_Id');

		if (!isEmpty(fournisseurId)) {
			ouvrirFournisseur(contenu.getAttribute('Num_Fournisseur'), fournisseurId);
		}
		else {
			listerFournisseurs();
		}

  } catch (e) {
    recup_erreur(e);
  }
}


function pressOnTree(ev) {
  try {

    if (ev.keyCode==13) {
			choixFournisseur();
  	}

  } catch (e) {
    recup_erreur(e);
  }
}


function reporterFournisseur(numFournisseur, fournisseurId) {
  try {

		if (!isEmpty(numFournisseur)) {
			ouvrirFournisseur(numFournisseur, fournisseurId);
		}

	} catch (e) {
  	recup_erreur(e);
  }
}


function ouvrirFournisseur(numFournisseur, fournisseurId) {
  try {

		window.arguments[0](numFournisseur, fournisseurId);
		window.close();

  } catch (e) {
    recup_erreur(e);
  }
}


function choixFournisseur() {
	try {

		if (aFournisseurs.isSelected()) {
			var numFournisseur = aFournisseurs.getSelectedCellText('colNumFournisseur');
			var fournisseurId = aFournisseurs.getSelectedCellText('colFournisseurId');
			ouvrirFournisseur(numFournisseur, fournisseurId);
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function initCriteres() {
	try {

		document.getElementById('numFournisseur').value = "";
		document.getElementById('denomination').value = "";
		document.getElementById('famille').value = "";
		document.getElementById('codeCouleur').value = "";
		document.getElementById('actif').checked = true;
		document.getElementById('contact').value = "";
		document.getElementById('ville').value = "";
		document.getElementById('pays').value = "";

		listerFournisseurs();

	} catch (e) {
    recup_erreur(e);
  }
}


function listerFournisseurs() {
	try {

		var numFournisseur = document.getElementById('numFournisseur').value;
		var denomination = document.getElementById('denomination').value;
		var contact = document.getElementById('contact').value;
		var ville = document.getElementById('ville').value;
		var pays = document.getElementById('pays').value;
		var famille = document.getElementById('famille').value;
		var codeCouleur = document.getElementById('codeCouleur').value;
		var actif = document.getElementById('actif').checked;
		var nbLignesParPage = document.getElementById('nbLignesParPage').value;

		pageCourante = 1;
		nbPages = 1;
		document.getElementById('pageDeb').value = 1;
		document.getElementById('pageFin').value = 1;
		document.getElementById('bPrec').disabled = true;
		document.getElementById('bSuiv').disabled = true;

		document.getElementById('listeFournisseurs').disabled = true;
		aFournisseurs.deleteTree();

		qListFF.setParam("Num_Fournisseur", numFournisseur);
		qListFF.setParam("Denomination", denomination);
		qListFF.setParam("Contact", contact);
		qListFF.setParam("Ville", ville);
		qListFF.setParam("Pays", pays);
		qListFF.setParam("Famille", famille);
		qListFF.setParam("Code_Couleur", codeCouleur);
		qListFF.setParam("Actif", actif);
		qListFF.setParam("Nb_Lignes_Par_Page", nbLignesParPage);
		qListFF.setParam("Current_Page", pageCourante);

		var result = qListFF.execute();

		var contenu = result.responseXML.documentElement;

		nbPages = contenu.getAttribute("Nb_Pages");
		var listFournisseurId = contenu.getAttribute("List_Fournisseur_Id");

		aFournisseurs.setParam("List_Fournisseur_Id", listFournisseurId);
		aFournisseurs.initTree(initPagination);

	} catch (e) {
    recup_erreur(e);
  }
}


function initPagination() {
	try {

		document.getElementById('pageDeb').value = pageCourante;
		document.getElementById('pageFin').value = (nbPages>0?nbPages:1);
		document.getElementById('bPrec').disabled = (pageCourante==1);
		document.getElementById('bSuiv').disabled = (pageCourante>=nbPages); // peut se produire si nbPages=0

		afterMajPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function pressOnPagePrec() {
	try {

		pageCourante--;
		majPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function pressOnPageSuiv() {
	try {

		pageCourante++;
		majPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function majPagination() {
	try {

		document.getElementById('pageDeb').value = pageCourante;
		document.getElementById('bPrec').disabled = (pageCourante==1);
		document.getElementById('bSuiv').disabled = (pageCourante==nbPages);

		document.getElementById('listeFournisseurs').disabled = true;

		qListFF.setParam("Current_Page", pageCourante);
		var result = qListFF.execute();
		var listFournisseurId = result.responseXML.documentElement.getAttribute("List_Fournisseur_Id");

		aFournisseurs.setParam("List_Fournisseur_Id", listFournisseurId);
		aFournisseurs.initTree(afterMajPagination);

	} catch (e) {
		recup_erreur(e);
	}
}


function afterMajPagination() {
	try {

		document.getElementById('listeFournisseurs').disabled = false;

	} catch (e) {
		recup_erreur(e);
	}
}
