/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/


var omi_aDepots = new Arbre("ComboListe/combo-depotsStock.tmpl", "omi-depotStock");
var omi_aInventaires = new Arbre('Facturation/Inventaire/list-inventaire.tmpl', 'omi-listeInventaires');
var omi_qListIS = new QueryHttp("Facturation/Inventaire/getDataListIS.tmpl");

var omi_pageCourante;
var omi_nbPages;



function omi_init() {
  try {

		if (!gActEmplacements) {
			document.getElementById('omi-bRechEmplacement').collapsed = true;
			document.getElementById('omi-colZoneStockage').collapsed = true;
			document.getElementById('omi-colZoneStockage').setAttribute("ignoreincolumnpicker", true);
		}

		omi_aDepots.initTree();

		omi_initCriteres();

  } catch (e) {
  	recup_erreur(e);
  }
}


function omi_initCriteres() {
	try {

		document.getElementById('omi-numInventaire').value = "";
		document.getElementById('omi-etat').value = "T";
		document.getElementById('omi-depotStock').value = "";
		document.getElementById('omi-dateInventaireDebut').value = "";
		document.getElementById('omi-dateInventaireFin').value = "";
		document.getElementById('omi-refArticle').value = "";
		document.getElementById('omi-codeEmplacement').value = "";
		document.getElementById('omi-typeInventaire').value = "";

		omi_listerInventaires();

	} catch (e) {
		recup_erreur(e);
	}
}


function omi_listerInventaires() {
	try {

		var numInventaire = document.getElementById('omi-numInventaire').value;
		var etat = document.getElementById('omi-etat').value;
		var depotStock = document.getElementById('omi-depotStock').value;
		var dateInventaireDebut = document.getElementById('omi-dateInventaireDebut').value;
		var dateInventaireFin = document.getElementById('omi-dateInventaireFin').value;
		var refArticle = document.getElementById('omi-refArticle').value;
		var codeEmplacement = document.getElementById('omi-codeEmplacement').value;
		var typeInventaire = document.getElementById('omi-typeInventaire').value;
		var nbLignesParPage = document.getElementById('omi-nbLignesParPage').value;

		if (!isEmpty(dateInventaireDebut) && !isDate(dateInventaireDebut)) { showWarning("Date de d\u00E9but incorrecte !"); }
		else if (!isEmpty(dateInventaireFin) && !isDate(dateInventaireFin)) { showWarning("Date de fin incorrecte !"); }
		else if (!isEmpty(dateInventaireDebut) && !isEmpty(dateInventaireFin) && !isDateInterval(dateInventaireDebut, dateInventaireFin)) { showWarning("Plage de dates incorrecte !"); }
		else {

			omi_pageCourante = 1;
			omi_nbPages = 1;
			document.getElementById('omi-pageDeb').value = 1;
			document.getElementById('omi-pageFin').value = 1;
			document.getElementById('omi-bPrec').disabled = true;
			document.getElementById('omi-bSuiv').disabled = true;

			document.getElementById('omi-listeInventaires').disabled = true;
			document.getElementById('omi-bEditionCsv').disabled = true;
			omi_aInventaires.deleteTree();

			omi_qListIS.setParam("Num_Inventaire", numInventaire);
			omi_qListIS.setParam("Etat", etat);
			omi_qListIS.setParam("Depot_Stock", depotStock);
			omi_qListIS.setParam("Date_Inventaire_Debut", dateInventaireDebut);
			omi_qListIS.setParam("Date_Inventaire_Fin", dateInventaireFin);
			omi_qListIS.setParam("Ref_Article", refArticle);
			omi_qListIS.setParam("Code_Emplacement", codeEmplacement);
			omi_qListIS.setParam("Type_Inventaire", typeInventaire);
			omi_qListIS.setParam("Nb_Lignes_Par_Page", nbLignesParPage);
			omi_qListIS.setParam("Current_Page", omi_pageCourante);

			var result = omi_qListIS.execute();

			var contenu = result.responseXML.documentElement;

			omi_nbPages = contenu.getAttribute("Nb_Pages");
			var listInventaireId = contenu.getAttribute("List_Inventaire_Id");

			omi_aInventaires.setParam("List_Inventaire_Id", listInventaireId);
			omi_aInventaires.initTree(omi_initPagination);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function omi_initPagination() {
	try {

		document.getElementById('omi-pageDeb').value = omi_pageCourante;
		document.getElementById('omi-pageFin').value = (omi_nbPages>0?omi_nbPages:1);
		document.getElementById('omi-bPrec').disabled = (omi_pageCourante==1);
		document.getElementById('omi-bSuiv').disabled = (omi_pageCourante>=omi_nbPages); // peut se produire si omi_nbPages=0

		omi_afterMajPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function omi_pressOnPagePrec() {
	try {

		omi_pageCourante--;
		omi_majPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function omi_pressOnPageSuiv() {
	try {

		omi_pageCourante++;
		omi_majPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function omi_majPagination() {
	try {

		document.getElementById('omi-pageDeb').value = omi_pageCourante;
		document.getElementById('omi-bPrec').disabled = (omi_pageCourante==1);
		document.getElementById('omi-bSuiv').disabled = (omi_pageCourante==omi_nbPages);

		document.getElementById('omi-listeInventaires').disabled = true;
		document.getElementById('omi-bEditionCsv').disabled = true;

		omi_qListIS.setParam("Current_Page", omi_pageCourante);
		var result = omi_qListIS.execute();
		var listInventaireId = result.responseXML.documentElement.getAttribute("List_Inventaire_Id");

		omi_aInventaires.setParam("List_Inventaire_Id", listInventaireId);
		omi_aInventaires.initTree(omi_afterMajPagination);

	} catch (e) {
		recup_erreur(e);
	}
}


function omi_afterMajPagination() {
	try {

		document.getElementById('omi-listeInventaires').disabled = false;
		document.getElementById('omi-bEditionCsv').disabled = (omi_aInventaires.nbLignes()==0);

	} catch (e) {
		recup_erreur(e);
	}
}


function omi_pressOnNouveauInventaire() {
	try {

		var url = "chrome://opensi/content/facturation/user/inventaires/popup-creationInventaire.xul";
    window.openDialog(url,'','chrome,modal,centerscreen', omi_creerInventaire);

	} catch (e) {
		recup_erreur(e);
	}
}


function omi_creerInventaire(typeInventaire, zoneId, codeEmplacement, marqueId, famille1, famille2, famille3, depotId) {
	try {

		var qCreate = new QueryHttp("Facturation/Inventaire/createInventaire.tmpl");
		qCreate.setParam('Type_Inventaire', typeInventaire);
		qCreate.setParam('Zone_Id', zoneId);
		qCreate.setParam('Code_Emplacement', codeEmplacement);
		qCreate.setParam('Marque_Id', marqueId);
		qCreate.setParam('Famille_1', famille1);
		qCreate.setParam('Famille_2', famille2);
		qCreate.setParam('Famille_3', famille3);
		qCreate.setParam('Depot_Id', depotId);

		var result = qCreate.execute();

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}
		else {
			oei_inventaireId = result.responseXML.documentElement.getAttribute('Inventaire_Id');
			oei_chargerInventaire();
			document.getElementById('bMenuInventaires').collapsed = false;
			document.getElementById('deck').selectedIndex = 1;
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function omi_pressOnCritere(ev) {
  try {

		if (ev.keyCode==13) {
			omi_listerInventaires();
    }

	} catch (e) {
  	recup_erreur(e);
  }
}


function omi_pressOnListeInventaires(ev) {
  try {

		if (ev.keyCode==13) {
			omi_ouvrirInventaire();
    }

	} catch (e) {
  	recup_erreur(e);
  }
}


function omi_ouvrirInventaire() {
  try {

  	if (omi_aInventaires.isSelected()) {
			oei_inventaireId = omi_aInventaires.getSelectedCellText('omi-colInventaireId');
			oei_chargerInventaire();
			document.getElementById('bMenuInventaires').collapsed = false;
			document.getElementById('deck').selectedIndex = 1;
  	}

	} catch (e) {
  	recup_erreur(e);
  }
}


function omi_pressOnEditionCsv() {
	try {

		var numInventaire = document.getElementById('omi-numInventaire').value;
		var etat = document.getElementById('omi-etat').value;
		var depotStock = document.getElementById('omi-depotStock').value;
		var dateInventaireDebut = document.getElementById('omi-dateInventaireDebut').value;
		var dateInventaireFin = document.getElementById('omi-dateInventaireFin').value;
		var refArticle = document.getElementById('omi-refArticle').value;
		var codeEmplacement = document.getElementById('omi-codeEmplacement').value;
		var typeInventaire = document.getElementById('omi-typeInventaire').value;

		if (!isEmpty(dateInventaireDebut) && !isDate(dateInventaireDebut)) { showWarning("Date de d\u00E9but incorrecte !"); }
		else if (!isEmpty(dateInventaireFin) && !isDate(dateInventaireFin)) { showWarning("Date de fin incorrecte !"); }
		else if (!isEmpty(dateInventaireDebut) && !isEmpty(dateInventaireFin) && !isDateInterval(dateInventaireDebut, dateInventaireFin)) { showWarning("Plage de dates incorrecte !"); }
		else {

			var qEditionCsv = new QueryHttp("Facturation/Inventaire/csvListInventaire.tmpl");

			qEditionCsv.setParam("Num_Inventaire", numInventaire);
			qEditionCsv.setParam("Etat", etat);
			qEditionCsv.setParam("Depot_Stock", depotStock);
			qEditionCsv.setParam("Date_Inventaire_Debut", dateInventaireDebut);
			qEditionCsv.setParam("Date_Inventaire_Fin", dateInventaireFin);
			qEditionCsv.setParam("Ref_Article", refArticle);
			qEditionCsv.setParam("Code_Emplacement", codeEmplacement);
			qEditionCsv.setParam("Type_Inventaire", typeInventaire);

			var result = qEditionCsv.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				var fichier = result.responseXML.documentElement.getAttribute('FichierCSV');

				var file = fileChooser("save", fichier);
				if (file!=null) {
					downloadFile(getDirBuffer()+ fichier, file);
				}
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function omi_rechercherArticle() {
	try {

		var url = "chrome://opensi/content/facturation/user/articles/popup-rechercheArticle.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', omi_retourRechercherArticle);

	} catch (e) {
		recup_erreur(e);
	}
}


function omi_retourRechercherArticle(reference, articleId) {
	try {

  	document.getElementById('omi-refArticle').value = reference;
  	omi_listerInventaires();

	} catch (e) {
		recup_erreur(e);
	}
}


function omi_rechercherEmplacement() {
	try {

		var url = "chrome://opensi/content/facturation/user/emplacements/popup-rechercheEmplacement.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', omi_retourRechercherEmplacement);

	} catch (e) {
		recup_erreur(e);
	}
}


function omi_retourRechercherEmplacement(codeEmplacement, emplacementId) {
	try {

  	document.getElementById('omi-codeEmplacement').value = codeEmplacement;
  	omi_listerInventaires();

	} catch (e) {
		recup_erreur(e);
	}
}
