/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

var ohr_aBanques = new Arbre("ComboListe/combo-banques.tmpl", "ohr-comboBanques");
var ohr_aTypeReg = new Arbre("ComboListe/combo-typesReglement.tmpl", "ohr-comboTypeReg");
var ohr_aRemises = new Arbre("Facturation/Remises_Banque/list-remiseBanque.tmpl", "ohr-listeRemises");
var ohr_aDetailReglements = new Arbre("Facturation/Remises_Banque/list-ligneRemiseStandard.tmpl", "ohr-listeReglements");
var ohr_aDetailEspeces = new Arbre("Facturation/Remises_Banque/list-ligneRemiseEspeces.tmpl", "ohr-listeReglementsEspeces");
var ohr_qListRB = new QueryHttp("Facturation/Remises_Banque/getDataListRB.tmpl");

var ohr_pageCourante;
var ohr_nbPages;



function ohr_init() {
	try {

		document.getElementById('ohr-bAnnulerRemise').disabled = true;
		document.getElementById('ohr-bReediterBordereau').disabled = true;

		document.getElementById('ohr-boxDetails').collapsed=true;
		document.getElementById('ohr-listeReglements').collapsed=true;
		document.getElementById('ohr-listeReglementsEspeces').collapsed=true;
		ohr_aBanques.initTree(ohr_initBanque);

	} catch (e) {
		recup_erreur(e);
	}
}


function ohr_initBanque() {
	try {

		document.getElementById('ohr-comboBanques').selectedIndex = 0;
		ohr_aTypeReg.initTree(ohr_initTypeReg);

	} catch (e) {
		recup_erreur(e);
	}
}


function ohr_initTypeReg() {
	try {

		document.getElementById('ohr-comboTypeReg').selectedIndex = 0;

	} catch (e) {
		recup_erreur(e);
	}
}


function ohr_rechercherClient() {
	try {

		var url = "chrome://opensi/content/facturation/user/clients/popup-rechercheClient.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', ohr_retourRechercherClient);

	} catch (e) {
		recup_erreur(e);
	}
}


function ohr_retourRechercherClient(codeClient) {
	try {

  	document.getElementById('ohr-numClient').value = codeClient;
  	ohr_listerRemises();

	} catch (e) {
		recup_erreur(e);
	}
}


function ohr_rechercherFournisseur() {
	try {

		var url = "chrome://opensi/content/facturation/user/fournisseurs/popup-rechercheFournisseur.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', ohr_retourRechercherFournisseur);

	} catch (e) {
		recup_erreur(e);
	}
}


function ohr_retourRechercherFournisseur(codeFournisseur) {
	try {

  	document.getElementById('ohr-numFournisseur').value = codeFournisseur;
  	ohr_listerRemises();

	} catch (e) {
		recup_erreur(e);
	}
}


function ohr_onKeyPress(event) {
	try {

		if (event.keyCode==13) {
			ohr_listerRemises();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function ohr_listerRemises() {
	try {

		var numRemise = document.getElementById('ohr-numRemise').value;
		var dateReglementDebut = document.getElementById('ohr-dateDebutReg').value;
		var dateReglementFin = document.getElementById('ohr-dateFinReg').value;
		var dateRemiseDebut = document.getElementById('ohr-dateDebutRemise').value;
		var dateRemiseFin = document.getElementById('ohr-dateFinRemise').value;
		var typeReglement = document.getElementById('ohr-comboTypeReg').value;
		var modeReglement = "";//document.getElementById('ohr-modeReglement').value;
		var banqueRemise = document.getElementById('ohr-comboBanques').value;
		var numClient = document.getElementById('ohr-numClient').value;
		var numFournisseur = document.getElementById('ohr-numFournisseur').value;
		var nbLignesParPage = document.getElementById('ohr-nbLignesParPage').value;

		if (!isEmpty(dateReglementDebut) && !isDate(dateReglementDebut)) { showWarning("Date de d\u00E9but de r\u00E8glement incorrecte"); }
		else if (!isEmpty(dateReglementFin) && !isDate(dateReglementFin)) { showWarning("Date de fin de r\u00E8glement incorrecte"); }
		else if (!isEmpty(dateReglementDebut) && !isEmpty(dateReglementFin) && !isDateInterval(dateReglementDebut, dateReglementFin)) { showWarning("Plage de dates incorrecte"); }
		else if (!isEmpty(dateRemiseDebut) && !isDate(dateRemiseDebut)) { showWarning("Date de d\u00E9but de remise incorrecte"); }
		else if (!isEmpty(dateRemiseFin) && !isDate(dateRemiseFin)) { showWarning("Date de fin de remise incorrecte"); }
		else if (!isEmpty(dateRemiseDebut) && !isEmpty(dateRemiseFin) && !isDateInterval(dateRemiseDebut, dateRemiseFin)) { showWarning("Plage de dates incorrecte"); }
		else {

			ohr_pageCourante = 1;
			ohr_nbPages = 1;
			document.getElementById('ohr-pageDeb').value = 1;
			document.getElementById('ohr-pageFin').value = 1;
			document.getElementById('ohr-bPrec').disabled = true;
			document.getElementById('ohr-bSuiv').disabled = true;

			document.getElementById('ohr-boxDetails').collapsed = true;
			document.getElementById('ohr-listeReglements').collapsed = true;
			document.getElementById('ohr-listeReglementsEspeces').collapsed = true;
			ohr_aDetailReglements.deleteTree();
			ohr_aDetailEspeces.deleteTree();
			document.getElementById('ohr-bAnnulerRemise').disabled = true;
			document.getElementById('ohr-bReediterBordereau').disabled = true;
			document.getElementById('ohr-listeRemises').disabled = true;

			ohr_aRemises.deleteTree();

			ohr_qListRB.setParam("Num_Remise", numRemise);
			ohr_qListRB.setParam("Type_Reglement", typeReglement);
			ohr_qListRB.setParam("Mode_Reglement", modeReglement);
			ohr_qListRB.setParam("Banque_Remise", banqueRemise);
			ohr_qListRB.setParam("Date_Reglement_Debut", dateReglementDebut);
			ohr_qListRB.setParam("Date_Reglement_Fin", dateReglementFin);
			ohr_qListRB.setParam("Date_Remise_Debut", dateRemiseDebut);
			ohr_qListRB.setParam("Date_Remise_Fin", dateRemiseFin);
			ohr_qListRB.setParam("Num_Client", numClient);
			ohr_qListRB.setParam("Num_Fournisseur", numFournisseur);
			ohr_qListRB.setParam("Nb_Lignes_Par_Page", nbLignesParPage);
			ohr_qListRB.setParam("Current_Page", ohr_pageCourante);

			var result = ohr_qListRB.execute();

			var contenu = result.responseXML.documentElement;

			ohr_nbPages = contenu.getAttribute("Nb_Pages");
			var listRemiseId = contenu.getAttribute("List_Remise_Id");

			ohr_aRemises.setParam("List_Remise_Id", listRemiseId);
			ohr_aRemises.initTree(ohr_initPagination);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function ohr_initPagination() {
	try {

		document.getElementById('ohr-pageDeb').value = ohr_pageCourante;
		document.getElementById('ohr-pageFin').value = (ohr_nbPages>0?ohr_nbPages:1);
		document.getElementById('ohr-bPrec').disabled = (ohr_pageCourante==1);
		document.getElementById('ohr-bSuiv').disabled = (ohr_pageCourante>=ohr_nbPages); // peut se produire si ohr_nbPages=0

		ohr_afterMajPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function ohr_pressOnPagePrec() {
	try {

		ohr_pageCourante--;
		ohr_majPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function ohr_pressOnPageSuiv() {
	try {

		ohr_pageCourante++;
		ohr_majPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function ohr_majPagination() {
	try {

		document.getElementById('ohr-pageDeb').value = ohr_pageCourante;
		document.getElementById('ohr-bPrec').disabled = (ohr_pageCourante==1);
		document.getElementById('ohr-bSuiv').disabled = (ohr_pageCourante==ohr_nbPages);

		document.getElementById('ohr-listeRemises').disabled = true;
		document.getElementById('ohr-bAnnulerRemise').disabled = true;
		document.getElementById('ohr-bReediterBordereau').disabled = true;

		document.getElementById('ohr-boxDetails').collapsed = true;
		document.getElementById('ohr-listeReglements').collapsed = true;
		document.getElementById('ohr-listeReglementsEspeces').collapsed = true;
		ohr_aDetailReglements.deleteTree();
		ohr_aDetailEspeces.deleteTree();

		ohr_qListRB.setParam("Current_Page", ohr_pageCourante);
		var result = ohr_qListRB.execute();
		var listRemiseId = result.responseXML.documentElement.getAttribute("List_Remise_Id");

		ohr_aRemises.setParam("List_Remise_Id", listRemiseId);
		ohr_aRemises.initTree(ohr_afterMajPagination);

	} catch (e) {
		recup_erreur(e);
	}
}


function ohr_afterMajPagination() {
	try {

		document.getElementById('ohr-listeRemises').disabled = false;

	} catch (e) {
		recup_erreur(e);
	}
}


function ohr_reinitialiser() {
	try {

		ohr_aRemises.deleteTree();
		document.getElementById('ohr-boxDetails').collapsed=true;
		document.getElementById('ohr-listeReglements').collapsed=true;
		document.getElementById('ohr-listeReglementsEspeces').collapsed=true;
		ohr_aDetailReglements.deleteTree();
		ohr_aDetailEspeces.deleteTree();

		document.getElementById('ohr-bAnnulerRemise').disabled = true;
		document.getElementById('ohr-bReediterBordereau').disabled = true;

		document.getElementById('ohr-comboTypeReg').selectedIndex=0;
		document.getElementById('ohr-comboBanques').selectedIndex=0;
		document.getElementById('ohr-numClient').value="";
		document.getElementById('ohr-numFournisseur').value="";
		document.getElementById('ohr-numRemise').value="";
		document.getElementById('ohr-dateDebutReg').value="";
		document.getElementById('ohr-dateFinReg').value="";
		document.getElementById('ohr-dateDebutRemise').value="";
		document.getElementById('ohr-dateFinRemise').value="";

		ohr_listerRemises();

	} catch (e) {
		recup_erreur(e);
	}
}


function ohr_selectOnListeRemises() {
	try {

		if (ohr_aRemises.isSelected()) {
			var i = ohr_aRemises.getCurrentIndex();
			var remiseId = ohr_aRemises.getCellText(i, 'ohr-colRemiseId');
			var especes = (ohr_aRemises.getCellText(i, 'ohr-colTypeRemise')=="E");
			var annulationPossible = (ohr_aRemises.getCellText(i, 'ohr-colEtat')=="V");

			document.getElementById('ohr-bAnnulerRemise').disabled = !annulationPossible;
			document.getElementById('ohr-bReediterBordereau').disabled = false;

			document.getElementById('ohr-boxDetails').collapsed = false;
			document.getElementById('ohr-listeReglements').collapsed = especes;
			document.getElementById('ohr-listeReglementsEspeces').collapsed = !especes;

			if (especes) {
				ohr_aDetailEspeces.setParam("Remise_Id", remiseId);
				ohr_aDetailEspeces.initTree();
			}
			else {
				ohr_aDetailReglements.setParam("Remise_Id", remiseId);
				ohr_aDetailReglements.initTree();
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function ohr_annulerRemise() {
	try {

		if (window.confirm("Voulez-vous annuler la remise en banque s\u00E9lectionn\u00E9e ?")) {
			var remiseId = ohr_aRemises.getSelectedCellText('ohr-colRemiseId');

			var qAnnulerRemise = new QueryHttp("Facturation/Remises_Banque/cancelRemiseBanque.tmpl");
			qAnnulerRemise.setParam("Remise_Id", remiseId);
			var result = qAnnulerRemise.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}

			ohr_listerRemises();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function ohr_reediterRemise() {
	try {

		if (ohr_aRemises.isSelected()) {
			var i = ohr_aRemises.getCurrentIndex();
			var remiseId = ohr_aRemises.getCellText(i, 'ohr-colRemiseId');
			var especes = (ohr_aRemises.getCellText(i, 'ohr-colTypeRemise')=="E");

			var qGenPdf = new QueryHttp("Facturation/Remises_Banque/pdfRemise.tmpl");
			if (especes) { qGenPdf.setParam('Especes','true'); }
			qGenPdf.setParam('Remise_Id', remiseId);
			var result = qGenPdf.execute();
			var page = getDirPdf() + result.responseXML.documentElement.getAttribute('fichier');
			switchPdf(page);
		}

	} catch (e) {
		recup_erreur(e);
	}
}

