/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

jsLoader.loadSubScript("chrome://opensi/content/libs/verif.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/arbres.js");


var typeTiers;
var reglementId;
var aBanquesRemise = new Arbre('ComboListe/combo-banques.tmpl', 'banqueRemise');



function init() {
  try {

  	reglementId = window.arguments[0];
  	typeTiers = window.arguments[1];
  	aBanquesRemise.initTree(initBanqueRemise);

  } catch (e) {
    recup_erreur(e);
  }
}


function initBanqueRemise() {
	try {

    document.getElementById('banqueRemise').selectedIndex = 0;

	} catch (e) {
    recup_erreur(e);
  }
}


function enregistrer() {
	try {

		var banqueRemise = document.getElementById('banqueRemise').value;

		if (isEmpty(banqueRemise)) {
			showWarning("Veuillez choisir une banque de remise");
		}
		else {
			var qSave = new QueryHttp("Facturation/Remises_Banque/assignBanqueRemise.tmpl");
			qSave.setParam("Reglement_Id", reglementId);
			qSave.setParam("Type_Tiers", typeTiers);
			qSave.setParam("Banque_Remise", banqueRemise);
			qSave.execute();

			window.arguments[2]();
			window.close();
		}

	} catch (e) {
		recup_erreur(e);
	}
}
