/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

var oebr_aEtablissements = new Arbre('ComboListe/combo-etablissements.tmpl', 'oebr-etablissement');
var oebr_aDepots = new Arbre('ComboListe/combo-depotsStock.tmpl', 'oebr-depot');
var oebr_aArticlesRetour = new Arbre('Facturation/Affaires/list-ligneRetourClient.tmpl', 'oebr-listeArticlesBonRetour');
var oebr_aVersion = new Arbre("Facturation/Affaires/list-versionRetourClient.tmpl","oebr-listeVersion");
var aUnites = new Arbre("ComboListe/combo-unitesVente.tmpl","oebr-unites");
var oebr_aLangues = new Arbre("ComboListe/combo-langues.tmpl", "oebr-langueDefaut");

var oebr_mode;
var oebr_clientId = "";
var oebr_etatBon;
var oebr_currentCodePays;
var oebr_modifie = false;
var oebr_curEtablissement;
var oebr_curDepot;
var oebr_curLine = "";
var oebr_curArticleId = "";
var oebr_actSuiviSerie;
var oebr_actSuiviLot;
var oebr_langueDefaut;
var oebr_numSerie;


function oebr_init() {
	try {

		var config = getConfig();

		var actNbPieces = config.isActNbPieces();
		var actUnites = config.isActUnites();
		oebr_actSuiviLot = config.isActSuiviLot();
		oebr_actSuiviSerie = config.isActSuiviSerie();

		document.getElementById('oebr-bConsultSerieLigne').collapsed = !oebr_actSuiviSerie;
		document.getElementById('oebr_switchSaisie').collapsed = !oebr_actSuiviSerie;

		if (!actNbPieces) {
			document.getElementById('oebr-colNbPieces').collapsed = true;
			document.getElementById('oebr-colNbPieces').setAttribute('ignoreincolumnpicker', true);
			document.getElementById('oebr-labNbPieces').collapsed = true;
			document.getElementById('oebr-nbPieces').collapsed = true;
		}

		if (!actUnites) {
			document.getElementById('oebr-colUnites').collapsed = true;
			document.getElementById('oebr-colUnites').setAttribute('ignoreincolumnpicker', true);
			document.getElementById('oebr-labUnites').collapsed = true;
			document.getElementById('oebr-unites').collapsed = true;
		}

		if (!oebr_actSuiviLot) {
			document.getElementById('oebr-colNumLot').collapsed = true;
			document.getElementById('oebr-colNumLot').setAttribute('ignoreincolumnpicker', true);
			document.getElementById('oebr-colDLC').collapsed = true;
			document.getElementById('oebr-colDLC').setAttribute('ignoreincolumnpicker', true);
			document.getElementById('oebr-labNumLot').collapsed = true;
			document.getElementById('oebr-numLot').collapsed = true;
			document.getElementById('oebr-labDLC').collapsed = true;
			document.getElementById('oebr-DLC').collapsed = true;
		}

		var aPays = new Arbre("ComboListe/combo-pays.tmpl", "oebr-codePays");
		aPays.initTree(oebr_initPays);

	} catch (e) {
		recup_erreur(e);
	}
}

function oebr_initPays() {
	try {
		document.getElementById('oebr-codePays').value = "FR";
		aUnites.initTree(oebr_initUnite);
	} catch (e) {
		recup_erreur(e);
	}
}


function oebr_initUnite() {
	try {

		document.getElementById('oebr-unites').value = getConfig().getUniteDefaut();

	} catch (e) {
		recup_erreur(e);
	}
}


function oebr_chargerEtablissement(selection) {
	try {
		oebr_curEtablissement = selection;
		oebr_aEtablissements.setParam("Selection", selection);
		oebr_aEtablissements.initTree(oebr_initEtablissement);
	} catch (e) {
		recup_erreur(e);
	}
}

function oebr_initEtablissement() {
	try {
		document.getElementById('oebr-etablissement').value = oebr_curEtablissement;
	} catch (e) {
		recup_erreur(e);
	}
}


function oebr_chargerDepot(selection) {
	try {
		oebr_curDepot = selection;
		oebr_aDepots.setParam("Selection", selection);
		oebr_aDepots.setParam("Depot_Quarantaine", false);
		oebr_aDepots.initTree(oebr_initDepot);
	} catch (e) {
		recup_erreur(e);
	}
}

function oebr_initDepot() {
	try {
		document.getElementById('oebr-depot').value = oebr_curDepot;
	} catch (e) {
		recup_erreur(e);
	}
}


function oebr_reinitialiser() {
	try {
		oebr_curLine = "";
		oebr_curArticleId = "";
		oebr_clientId = "";
		oebr_viderChamps();
		oebr_bloquerChamps();


	} catch (e) {
		recup_erreur(e);
	}
}


function oebr_debloquerChamps() {
	try {

		document.getElementById('oebr-etablissement').disabled = false;
		document.getElementById('oebr-depot').disabled = false;
		document.getElementById('oebr-denomination').disabled = false;
		document.getElementById('oebr-adresse1').disabled = false;
		document.getElementById('oebr-adresse2').disabled = false;
		document.getElementById('oebr-adresse3').disabled = false;
		document.getElementById('oebr-codePostal').disabled = false;
		document.getElementById('oebr-ville').disabled = false;
		document.getElementById('oebr-codePays').disabled = false;
		document.getElementById('oebr-civInter').disabled = false;
		document.getElementById('oebr-nomInter').disabled = false;
		document.getElementById('oebr-prenomInter').disabled = false;
		document.getElementById('oebr-telInter').disabled = false;
		document.getElementById('oebr-faxInter').disabled = false;
		document.getElementById('oebr-emailInter').disabled = false;
		document.getElementById('oebr-commentairesFin').disabled = false;
		document.getElementById('oebr-commentairesInt').disabled = false;
		document.getElementById('oebr-codePays').disabled = false;
		document.getElementById('oebr-rgpTypeRetour').disabled = false;
		document.getElementById('oebr-bEnregistrer').disabled = false;
		document.getElementById('oebr-listeArticlesBonRetour').disabled = false;
		document.getElementById("oebr-refArticle").disabled = false;
		document.getElementById("oebr-designation").disabled = false;
		document.getElementById("oebr-nbPieces").disabled = false;
		document.getElementById("oebr-qte").disabled = false;
		document.getElementById("oebr-unites").disabled = false;
		document.getElementById("oebr-bAnnulerLigne").disabled = false;
		document.getElementById("oebr-bAjouterLigne").disabled = false;

	} catch (e) {
    recup_erreur(e);
  }
}


function oebr_nouveauBon() {
  try {

	  oebr_reinitialiser();

	  oebr_chargerEtablissement(etablissementDefaut);
	  oebr_chargerDepot(depotRC);

		document.getElementById('oebr-etat').value = "Non valid\u00E9";

		document.getElementById('oebr-bSupprimer').disabled = true;
		document.getElementById('oebr-bValiderReception').collapsed = true;
		document.getElementById('oebr-bAnnuler').collapsed = true;
		document.getElementById('oebr-bVisualiser').collapsed = true;
		document.getElementById('oebr-bSupprimer').collapsed = true;
		document.getElementById('oebr-bValiderBR').collapsed = false;
		document.getElementById('oebr-bValiderBR').disabled = false;
		oebr_debloquerChamps();
		document.getElementById('oebr-bAAjouterLigneSerie').disabled = false;
		document.getElementById('oebr-numSerie').disabled = false;
		document.getElementById("oebr-saisieLigne").collapsed = false;
		document.getElementById("oebr-saisieSerie").collapsed = true;

		document.getElementById('oebr-refArticle').disabled = false;
		document.getElementById('oebr-bArticle').disabled = false;
		oebr_aArticlesRetour.deleteTree();
		oebr_checkChangerFourn();

		oebr_setModifie(false);

	} catch (e) {
  	recup_erreur(e);
  }
}



function oebr_chargerBon() {
  try {

		oebr_reinitialiser();

		oebr_mode = "M";
		var qGetBonRetour = new QueryHttp('Facturation/Retours_Clients/getBonRetour.tmpl');
		qGetBonRetour.setParam("Bon_Id", bonRetourId);
		var result = qGetBonRetour.execute();
		var contenu = result.responseXML.documentElement;

		oebr_etatBon = contenu.getAttribute("Etat");
		oebr_clientId = contenu.getAttribute("Client_Id");
		document.getElementById('oebr-bAnnuler').disabled = (oebr_etatBon!="E" && oebr_etatBon!="V");

		if (oebr_etatBon=="V") {
			oebr_bloquerSaisie();
			document.getElementById('oebr-etat').value = "Valid\u00E9";
			document.getElementById('oebr-bSupprimer').collapsed = true;
			document.getElementById('oebr-bAnnuler').collapsed = false;
			document.getElementById('oebr_switchSaisie').collapsed = true;
			document.getElementById('oebr-bAAjouterLigneSerie').disabled = true;
		}
		else if (oebr_etatBon=="E") {
			oebr_bloquerSaisie();
			document.getElementById('oebr-etat').value = "En attente";
			document.getElementById('oebr-bValiderReception').disabled = false;
			document.getElementById('oebr-bSupprimer').collapsed = true;
			document.getElementById('oebr-bAnnuler').collapsed = false;
			document.getElementById('oebr-bAnnulerLigne').disabled = true;
			document.getElementById('oebr-bAjouterLigne').disabled = true;
			document.getElementById('oebr-bSupprimerLigne').disabled = true;
			document.getElementById('oebr-unites').disabled = true;
			document.getElementById('oebr-listeArticlesBonRetour').disabled = true;
			document.getElementById('oebr_switchSaisie').collapsed = true;
			document.getElementById('oebr-bAAjouterLigneSerie').disabled = true;
		}
		else if (oebr_etatBon=="A") {
			oebr_bloquerSaisie();
			document.getElementById('oebr-etat').value = "Annul\u00E9";
			document.getElementById('oebr-bSupprimer').collapsed = true;
			document.getElementById('oebr-bAnnuler').collapsed = true;
			document.getElementById('oebr_switchSaisie').collapsed = true;
			document.getElementById('oebr-bAAjouterLigneSerie').disabled = true;
		}
		else {
			oebr_debloquerChamps();
			document.getElementById('oebr-etat').value = "Non valid\u00E9";
			document.getElementById('oebr-bEnregistrer').disabled = false;
			document.getElementById('oebr-bValiderBR').collapsed = false;
			document.getElementById('oebr-bValiderBR').disabled = false;
			document.getElementById('oebr-bAnnuler').collapsed = true;
			document.getElementById('oebr-bAnnuler').disabled = true;
			document.getElementById('oebr-bSupprimer').collapsed = false;
			document.getElementById('oebr-bSupprimer').disabled = false;
			document.getElementById('oebr-refArticle').disabled = false;
			document.getElementById('oebr-bArticle').disabled = false;
			document.getElementById('oebr-bRechClient').disabled = false;
			document.getElementById('oebr-bRechClient').collapsed = false;
			document.getElementById('oebr-bChercherAdresse').disabled = (oebr_clientId=="");
			document.getElementById('oebr-bChercherInter').disabled = (oebr_clientId=="");
			document.getElementById('oebr-bChoisirMentions').disabled = false;
			document.getElementById('oebr_switchSaisie').collapsed = !oebr_actSuiviSerie;
			document.getElementById('oebr-bAAjouterLigneSerie').disabled = false;
			document.getElementById('oebr-numSerie').disabled = false;
		}

		document.getElementById('oebr-bValiderReception').collapsed = (oebr_etatBon!='E');

		document.getElementById('oebr-bValiderBR').collapsed = (oebr_etatBon!='N');
		document.getElementById('oebr-bValiderBR').disabled = (oebr_etatBon!='N');

		document.getElementById('oebr-bVisualiser').collapsed = (oebr_etatBon=='N');
		document.getElementById('oebr-bVisualiser').disabled = (oebr_etatBon=='N');

		oebr_chargerEtablissement(contenu.getAttribute('Etab_Id'));
		oebr_chargerDepot(contenu.getAttribute('Depot_Id'));

		document.getElementById('oebr-dateBon').value = contenu.getAttribute("Date_Bon");
		document.getElementById('oebr-dateRetour').value = contenu.getAttribute("Date_Retour");

		document.getElementById('oebr-denomination').value = contenu.getAttribute("Denomination");
		document.getElementById('oebr-adresse1').value = contenu.getAttribute("Adresse_1");
		document.getElementById('oebr-adresse2').value = contenu.getAttribute("Adresse_2");
		document.getElementById('oebr-adresse3').value = contenu.getAttribute("Adresse_3");
		document.getElementById('oebr-codePostal').value = contenu.getAttribute("Code_Postal");
		document.getElementById('oebr-ville').value = contenu.getAttribute("Ville");
		document.getElementById('oebr-codePays').value = contenu.getAttribute("Code_Pays");
		document.getElementById('oebr-numClient').value = contenu.getAttribute("Num_Client");
		document.getElementById('oebr-rgpTypeRetour').value = contenu.getAttribute("Type_Retour");

		document.getElementById('oebr-commentairesFin').value = contenu.getAttribute("Commentaires_Fin");
		document.getElementById('oebr-commentairesInt').value = contenu.getAttribute("Commentaires_Int");
		document.getElementById('oebr-numero').value = contenu.getAttribute("Numero");

		document.getElementById('oebr-civInter').value = contenu.getAttribute("Civ_Inter");
		document.getElementById('oebr-nomInter').value = contenu.getAttribute("Nom_Inter");
		document.getElementById('oebr-prenomInter').value = contenu.getAttribute("Prenom_Inter");
		document.getElementById('oebr-telInter').value = contenu.getAttribute("Tel_Inter_1");
		document.getElementById('oebr-faxInter').value = contenu.getAttribute("Fax_Inter");
		document.getElementById('oebr-emailInter').value = contenu.getAttribute("Email_Inter");

		document.getElementById('oebr-creation').setAttribute("label","Retour cr\u00E9\u00E9 le "+ contenu.getAttribute('Date_Creation') +" par "+ contenu.getAttribute('Login_Createur'));
		document.getElementById('oebr-modification').setAttribute("label","Derni\u00E8re modification le "+ contenu.getAttribute('Date_Maj') +" par "+ contenu.getAttribute('Login_Maj'));
		document.getElementById('oebr-fiche').setAttribute("label","Retour N\u00B0 "+ contenu.getAttribute('Numero'));
		document.getElementById('oebr-creation').collapsed = false;
		document.getElementById('oebr-modification').collapsed = false;

		document.getElementById('oebr-bOuvrirCommentairesCaches').disabled = false;

		oebr_aArticlesRetour.setParam("Retour_Id", bonRetourId);
		oebr_aArticlesRetour.initTree();

		if (oebr_etatBon=='N') {
			oebr_debloquerChamps();
		} else {
			document.getElementById('oebr-tabVersionDocument').collapsed=false;
			oebr_initVersion();
		}
		oebr_setModifie(false);

	} catch (e) {
  	recup_erreur(e);
  }
}



function ober_majAffichageUtilM() {
	try {
		var qGetBonRetour = new QueryHttp('Facturation/Retours_Clients/getBonRetour.tmpl');
		qGetBonRetour.setParam("Bon_Id", bonRetourId);
		var result = qGetBonRetour.execute();
		var contenu = result.responseXML.documentElement;
		document.getElementById('oebr-modification').setAttribute("label","Derni\u00E8re modification le "+ contenu.getAttribute('Date_Maj') +" par "+ contenu.getAttribute('Login_Maj'));
	} catch (e) {
		recup_erreur(e);
	}
}


function oebr_checkChangerFourn() {
	try {
		var desactiverRechFourn = (oebr_etatBon!="N" || oebr_aArticlesRetour.nbLignes()>0);
		document.getElementById('oebr-bRechClient').collapsed = desactiverRechFourn;
		document.getElementById('oebr-bRechClient').disabled = desactiverRechFourn;
	} catch (e) {
		recup_erreur(e);
	}
}


function oebr_editerCommentairesInternes() {
  try {

  	var url = "chrome://opensi/content/facturation/user/commun/popup-commentairesInternes.xul";
  	window.openDialog(url,'','chrome,modal,centerscreen', "RC", bonRetourId, false);

	} catch (e) {
  	recup_erreur(e);
  }
}


function oebr_enregistrerBon(rafraichir) {
  try {

  	var ok=false;

		var qBonRetour;

		if (oebr_mode=="C") {
			qBonRetour = new QueryHttp("Facturation/Retours_Clients/creerBonRetour.tmpl");
		}
		else {
			qBonRetour = new QueryHttp("Facturation/Retours_Clients/modifierBonRetour.tmpl");
			qBonRetour.setParam("Bon_Id", bonRetourId);
		}

		var denomination = document.getElementById('oebr-denomination').value;
		var adresse1 = document.getElementById('oebr-adresse1').value;
		var adresse2 = document.getElementById('oebr-adresse2').value;
		var adresse3 = document.getElementById('oebr-adresse3').value;
		var codePostal = document.getElementById('oebr-codePostal').value;
		var ville = document.getElementById('oebr-ville').value;
		var codePays = document.getElementById('oebr-codePays').value;
		var civInter = document.getElementById('oebr-civInter').value;
		var nomInter = document.getElementById('oebr-nomInter').value;
		var prenomInter = document.getElementById('oebr-prenomInter').value;
		var telInter = document.getElementById('oebr-telInter').value;
		var faxInter = document.getElementById('oebr-faxInter').value;
		var emailInter = document.getElementById('oebr-emailInter').value;
		var commentairesFin = document.getElementById('oebr-commentairesFin').value;
		var commentairesInt = document.getElementById('oebr-commentairesInt').value;
		var typeRetour = document.getElementById('oebr-rgpTypeRetour').value;
		var etablissement = document.getElementById('oebr-etablissement').value;
		var depot = document.getElementById('oebr-depot').value;

		if (isEmpty(denomination)) { showWarning("Veuillez indiquer la d\u00E9nomination du client !"); }
		else if (isEmpty(adresse1)) { showWarning("Veuillez indiquer l'adresse du client !"); }
		else if (isEmpty(ville)) { showWarning("Veuillez indiquer la ville du client !"); }
		else if (!isEmpty(telInter) && !isPhone(telInter)) { showWarning("Num\u00E9ro de t\u00E9l\u00E9phone incorrect !"); }
		else if (!isEmpty(faxInter) && !isPhone(faxInter)) { showWarning("Num\u00E9ro de fax incorrect !"); }
		else if (!isEmpty(emailInter) && !isEmail(emailInter)) { showWarning("Adresse e-mail incorrecte !"); }
		else {
			qBonRetour.setParam("Client_Id", oebr_clientId);
			qBonRetour.setParam("Denomination",denomination);
			qBonRetour.setParam("Adresse_1",adresse1);
			qBonRetour.setParam("Adresse_2",adresse2);
			qBonRetour.setParam("Adresse_3",adresse3);
			qBonRetour.setParam("Code_Postal",codePostal);
			qBonRetour.setParam("Ville",ville);
			qBonRetour.setParam("Code_Pays",codePays);
			qBonRetour.setParam("Civ_Inter",civInter);
			qBonRetour.setParam("Nom_Inter",nomInter);
			qBonRetour.setParam("Prenom_Inter",prenomInter);
			qBonRetour.setParam("Tel_Inter_1",telInter);
			qBonRetour.setParam("Fax_Inter",faxInter);
			qBonRetour.setParam("Email_Inter",emailInter);
			qBonRetour.setParam("Commentaires_Fin",commentairesFin);
			qBonRetour.setParam("Commentaires_Int",commentairesInt);
			qBonRetour.setParam("Type_Retour",typeRetour);
			qBonRetour.setParam("Etab_Id", etablissement);
			qBonRetour.setParam("Depot_Id", depot);

			var result = qBonRetour.execute();
			var contenu = result.responseXML.documentElement;

			if (oebr_mode=="C") {
				bonRetourId = contenu.getAttribute("Bon_Id");
				if (rafraichir) { oebr_chargerBon(); }
			} else {
				ober_majAffichageUtilM();
			}

			oebr_setModifie(false);
			ok=true;
		}
		return ok;

	} catch (e) {
  	recup_erreur(e);
  }
}


function oebr_pressOnReference(ev) {
	try {

		if (ev.keyCode==13) {
			oebr_rechercherReference();
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oebr_rechercherReference() {
	try {

		var reference = document.getElementById('oebr-refArticle').value;

		var qSearch = new QueryHttp("Facturation/Articles/searchReference.tmpl");
		qSearch.setParam("Reference", reference);
		qSearch.setParam("Vente_Achat", "V");
		var result = qSearch.execute();

		var articleId = result.responseXML.documentElement.getAttribute("Article_Id");
		if (!isEmpty(articleId)) {
			oebr_curArticleId = articleId;
			document.getElementById('oebr-refArticle').setAttribute("readonly","readonly");
			document.getElementById('oebr-designation').setAttribute("readonly","readonly");
			document.getElementById('oebr-refArticle').value = result.responseXML.documentElement.getAttribute("Reference");
			document.getElementById('oebr-qte').focus();
			var qDesignation = new QueryHttp("Facturation/Articles/getDesignation.tmpl");
			qDesignation.setParam("Article_Id", articleId);
			result = qDesignation.execute();
			document.getElementById('oebr-designation').value = result.responseXML.documentElement.getAttribute("Designation");
		}
		else {
			oebr_rechercherStock(reference);
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oebr_rechercherStock(reference) {
	try {

		var url = "chrome://opensi/content/facturation/user/articles/popup-rechercheArticle.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', oebr_retourRechercherStock, "V", reference);

	}	catch (e) {
		recup_erreur(e);
	}
}


function oebr_retourRechercherStock(reference, articleId) {
	try {

		document.getElementById('oebr-refArticle').value = reference;

		var qDesignation = new QueryHttp("Facturation/Articles/getDesignation.tmpl");
		qDesignation.setParam("Article_Id", articleId);
		var result = qDesignation.execute();
		document.getElementById('oebr-designation').value = result.responseXML.documentElement.getAttribute("Designation");

		oebr_curArticleId = articleId;
		document.getElementById('oebr-refArticle').setAttribute("readonly","readonly");
		document.getElementById('oebr-designation').setAttribute("readonly","readonly");
		document.getElementById('oebr-DLC').disabled = false;
		document.getElementById('oebr-numLot').disabled = false;

	} catch (e) {
    recup_erreur(e);
  }
}


function oebr_demandeEnregistrement() {
  try {

		if (oebr_modifie) {
			if (window.confirm("Voulez-vous enregistrer les modifications apport\u00E9es au retour ?")) {
				oebr_enregistrerBon(false);
			}
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oebr_setModifie(m) {
  try {
  	oebr_modifie = m;
		if (m) {
			document.getElementById('oebr-tabBon').setAttribute('image', 'chrome://opensi/content/design/icones/modified.png');
			document.getElementById('oebr-bValiderBR').disabled = true;
		}
		else {
			document.getElementById('oebr-tabBon').setAttribute('image', null);
			document.getElementById('oebr-bValiderBR').disabled = (oebr_etatBon=='E');
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function oebr_visualiserBon() {
  try {

		if (oebr_aArticlesRetour.nbLignes()==0) {
			showWarning("Le retour ne contient aucune ligne !");
		}
		else {
			document.getElementById("bRetourBonRetour").collapsed = false;
			document.getElementById("oebr-deckBonRetour").selectedIndex = 1;

			var qLangueDefaut = new QueryHttp("Facturation/Commun/getLangueDefaut.tmpl");
			qLangueDefaut.setParam("Type_Doc", "RC");
			qLangueDefaut.setParam("Doc_Id", bonRetourId);
			var result = qLangueDefaut.execute();
			oebr_langueDefaut = result.responseXML.documentElement.getAttribute("Langue_Id");
			oebr_aLangues.setParam("Selection", oebr_langueDefaut);
			oebr_aLangues.initTree(oebr_initLangue);
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oebr_initLangue() {
	try {

		document.getElementById('oebr-langueDefaut').value = oebr_langueDefaut;
		oebr_editerBon();

	} catch (e) {
		recup_erreur(e);
	}
}


function oebr_editerBon() {
	try {

		var langue = document.getElementById('oebr-langueDefaut').value;

		var qGenPdf = new QueryHttp("Facturation/Retours_Clients/pdfBonRetour.tmpl");
		qGenPdf.setParam('Bon_Id', bonRetourId);
		qGenPdf.setParam('Langue', langue);
		var result = qGenPdf.execute();
		var page = getDirPdf() + result.responseXML.documentElement.getAttribute('fichier');

		document.getElementById('oebr-pdfBonRetour').setAttribute("src", page);

	} catch (e) {
		recup_erreur(e);
	}
}


function oebr_validerBon() {
  try {

		if (oebr_aArticlesRetour.nbLignes()==0) {
			showWarning("Le retour ne contient aucune ligne !");
		}
		else {
			var ok = true;

			if (oebr_actSuiviSerie) {
				var qCheck = new QueryHttp("Facturation/Retours_Clients/checkNumSerieRC.tmpl");
				qCheck.setParam("Retour_Id", bonRetourId);
				var result = qCheck.execute();

				var errors = new Errors(result);
				if (errors.hasNext()) {
					errors.show();
					ok = false;
				}
			}

			if (ok && window.confirm("Confirmez-vous la validation du retour ?\n(Attention le retour valid\u00E9 ne pourra plus \u00EAtre modifi\u00E9 !)")) {
				var depotId = document.getElementById('oebr-depot').value;
				var qValider = new QueryHttp("Facturation/Retours_Clients/validerBonRetour.tmpl");
				qValider.setParam('Bon_Id', bonRetourId);
				var result = qValider.execute();
				var errors = new Errors(result);

				while (errors.hasNext()) {
					errors.show();
				}
				oebr_chargerBon();
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}

function oebr_validerReception() {
	try {

		if (window.confirm("Confirmez-vous la validation de la r\u00E9ception ?")) {
			var qReceptionner = new QueryHttp("Facturation/Retours_Clients/validerReception.tmpl");
			qReceptionner.setParam('Bon_Id', bonRetourId);
			qReceptionner.execute(oebr_chargerBon);
		}

	} catch (e) {
    recup_erreur(e);
  }
}

function oebr_annulerBon() {
	try {

		if (window.confirm("Confirmez-vous l'annulation du retour ?")) {
			var qAnnuler = new QueryHttp("Facturation/Retours_Clients/annulerBonRetour.tmpl");
			qAnnuler.setParam('Bon_Id', bonRetourId);
			var result = qAnnuler.execute();
			var errors = new Errors(result);

			if (errors.hasNext()) {
				errors.show();
			}
			else {
				showWarning("Le bon de retour a \u00E9t\u00E9 annul\u00E9.");
				oebr_chargerBon();
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oebr_rechercherClient() {
	try {

		var url = "chrome://opensi/content/facturation/user/clients/popup-rechercheClient.xul";
    window.openDialog(url,'','chrome,modal,centerscreen', oebr_retourRechercherClient, false, true);

  } catch (e) {
    recup_erreur(e);
  }
}


function oebr_retourRechercherClient(numClient, clientId) {
	try {

		oebr_clientId = clientId;
		oebr_setModifie(true);
		oebr_chargerCoord();

	} catch (e) {
		recup_erreur(e);
	}
}


function oebr_chargerCoord() {
  try {

		var qGet = new QueryHttp("Facturation/Clients/getDefautDocumentVente.tmpl");
		qGet.setParam("Client_Id", oebr_clientId);
		var result = qGet.execute();

		var contenu = result.responseXML.documentElement;

		document.getElementById("oebr-denomination").value = contenu.getAttribute("Denomination_Fact");
		document.getElementById("oebr-adresse1").value = contenu.getAttribute("Adresse_1_Fact");
		document.getElementById("oebr-adresse2").value = contenu.getAttribute("Adresse_2_Fact");
		document.getElementById("oebr-adresse3").value = contenu.getAttribute("Adresse_3_Fact");
		document.getElementById("oebr-codePostal").value = contenu.getAttribute("Code_Postal_Fact");
		document.getElementById("oebr-ville").value = contenu.getAttribute("Ville_Fact");
		document.getElementById("oebr-codePays").value = contenu.getAttribute("Code_Pays_Fact");
		document.getElementById("oebr-civInter").value = contenu.getAttribute("Civ_Inter_Fact");
		document.getElementById("oebr-nomInter").value = contenu.getAttribute("Nom_Inter_Fact");
		document.getElementById("oebr-prenomInter").value = contenu.getAttribute("Prenom_Inter_Fact");
		document.getElementById("oebr-telInter").value = contenu.getAttribute("Tel_Inter_1_Fact");
		document.getElementById("oebr-faxInter").value = contenu.getAttribute("Fax_Inter_Fact");
		document.getElementById("oebr-emailInter").value = contenu.getAttribute("Email_Inter_Fact");

		document.getElementById('oebr-bChercherAdresse').disabled = false;
		document.getElementById('oebr-bChercherInter').disabled = false;

	} catch (e) {
  	recup_erreur(e);
  }
}


function oebr_rechercherAdr() {
  try {

  	oebr_currentCodePays = document.getElementById('oebr-codePays').value;

		var url = "chrome://opensi/content/facturation/user/commun/popup-choixAdresse.xul";
    window.openDialog(url,'','chrome,modal,centerscreen', oebr_reporterAdr, oebr_clientId, false);

	} catch (e) {
  	recup_erreur(e);
  }
}


function oebr_reporterAdr(nom, adr1, adr2, adr3, cp, ville, pays, code_pays, contact_fact, contact_liv, contact_envoi, contact_devis, adresseId) {
  try {

		document.getElementById('oebr-denomination').value = nom;
		document.getElementById('oebr-adresse1').value = adr1;
		document.getElementById('oebr-adresse2').value = adr2;
		document.getElementById('oebr-adresse3').value = adr3;
		document.getElementById('oebr-codePostal').value = cp;
		document.getElementById('oebr-ville').value = ville;
		document.getElementById('oebr-codePays').value = code_pays;

		if (!isEmpty(contact_fact)) {
			var qLoad = new QueryHttp("Facturation/Clients/loadContactClient.tmpl");
	  	qLoad.setParam("Contact_Id", contact_fact);
	  	var result = qLoad.execute();
	  	var contenu = result.responseXML.documentElement;
	  	oebr_reporterInter(contenu.getAttribute("Civilite"),contenu.getAttribute("Nom"),contenu.getAttribute("Prenom"),contenu.getAttribute("Tel_1"),contenu.getAttribute("Fax"),contenu.getAttribute("Email"));
	  } else {
			oebr_setModifie(true);
	  }

	} catch (e) {
  	recup_erreur(e);
  }
}


function oebr_rechercherInterlocuteur() {
  try {

		var url = "chrome://opensi/content/facturation/user/commun/popup-choixInter.xul";
    window.openDialog(url,'','chrome,modal,centerscreen', oebr_reporterInter, oebr_clientId, false);

	} catch (e) {
  	recup_erreur(e);
  }
}


function oebr_reporterInter(civ, nom, prenom, tel, fax, email) {
  try {
		document.getElementById('oebr-civInter').value = civ;
		document.getElementById('oebr-nomInter').value = nom;
		document.getElementById('oebr-prenomInter').value = prenom;
		document.getElementById('oebr-telInter').value = tel;
		document.getElementById('oebr-faxInter').value = fax;
		document.getElementById('oebr-emailInter').value = email;

		oebr_setModifie(true);
	} catch (e) {
  	recup_erreur(e);
  }
}

function oebr_choisirMentions() {
  try {

  	var ok = true;

  	if (oebr_mode=="C") {
			ok = oebr_enregistrerBon(true);
		}

		if (ok) {
			var url = "chrome://opensi/content/facturation/user/commun/popup-mentionsDocument.xul";
	    window.openDialog(url,'','chrome,modal,centerscreen', "RC", bonRetourId, false);
		}

	} catch (e) {
  	recup_erreur(e);
  }
}


function oebr_initVersion() {
	try {

		oebr_aVersion.setParam("Retour_Id", bonRetourId);
		oebr_aVersion.initTree();

	} catch (e) {
		recup_erreur(e);
	}
}

function oebr_resetLine() {
	try {
		document.getElementById("oebr-refArticle").value = "";
		document.getElementById("oebr-designation").value = "";
		document.getElementById("oebr-numLot").value = "";
		document.getElementById("oebr-DLC").value = "";
		document.getElementById("oebr-nbPieces").value = "";
		document.getElementById("oebr-numSerie").value = "";
		document.getElementById("oebr-qte").value = "1";
		document.getElementById('oebr-refArticle').removeAttribute("readonly");
		document.getElementById('oebr-designation').removeAttribute("readonly");
		document.getElementById('oebr-bAjouterLigne').disabled = false;
		oebr_aArticlesRetour.clearSelection();
		document.getElementById('oebr-bSupprimerLigne').disabled = true;
		document.getElementById('oebr-DLC').disabled = true;
		document.getElementById('oebr-numLot').disabled = true;
		document.getElementById('oebr-bConsultSerieLigne').disabled = true;
		oebr_curArticleId = "";
		oebr_curLine = "";
		oebr_initUnite();
	} catch (e) {
		recup_erreur(e);
	}
}

function oebr_saveLine() {
	try {

		var reference = document.getElementById("oebr-refArticle").value;
		var designation = document.getElementById("oebr-designation").value;
		var nbPieces = document.getElementById("oebr-nbPieces").value;
		var quantite = document.getElementById("oebr-qte").value;
		var numLot = document.getElementById("oebr-numLot").value;
		var datePeremption = document.getElementById("oebr-DLC").value;
		var unite = document.getElementById('oebr-unites').value;

		if (reference == "") { showWarning("Veuillez entrer une r\u00E9f\u00E9rence !"); }
		else if (designation == "") { showWarning("Veuillez entrer une d\u00E9signation !"); }
		else if (isEmpty(quantite)) { showWarning("Veuillez entrer une quantit\u00E9 \u00E0 transf\u00E9rer !"); }
		else if (!checkQte(quantite)) { showWarning("Quantit\u00E9 incorrecte !"); }
		else if (!isEmpty(nbPieces) && !isPositiveOrNullInteger(nbPieces)) { showWarning("Nombre de pi\u00E8ces incorrect !");	}
		else if (oebr_checkNumLotLigne(numLot, datePeremption)) {

			var ok = true;

			if (oebr_mode=="C") {
				ok = oebr_enregistrerBon(false);
			}

			if (ok) {
				oebr_mode = "M";

				var qSave;

				if (oebr_curLine == "") {
					qSave = new QueryHttp('Facturation/Retours_Clients/ajouterArticleBonRetour.tmpl');
				}
				else{
					qSave = new QueryHttp('Facturation/Retours_Clients/modifierArticleBonRetour.tmpl');
					qSave.setParam("Ligne_Id", oebr_curLine);
				}

				qSave.setParam("Bon_Id", bonRetourId);
				qSave.setParam("Quantite", quantite);
				qSave.setParam("Nb_Pieces", nbPieces);
				qSave.setParam("Reference", reference);
				qSave.setParam("Designation", designation);
				qSave.setParam("Unite_Id", unite);
				qSave.setParam("Article_Id", oebr_curArticleId);
				qSave.setParam("Num_Lot", numLot);
				qSave.setParam("DLC", datePeremption);

				var result = qSave.execute();

				if (oebr_curLine == "") {
					oebr_curLine = result.responseXML.documentElement.getAttribute('Ligne_Id');
				}

				oebr_checkNumSerieLigne(quantite);

				oebr_resetLine();
				oebr_chargerBon();
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oebr_ouvrirLigne() {
	try {

		if (oebr_aArticlesRetour.isSelected()) {

			document.getElementById("oebr-saisieLigne").collapsed = false;
			document.getElementById("oebr-saisieSerie").collapsed = true;

			var i = oebr_aArticlesRetour.getCurrentIndex();
			var ligneId = oebr_aArticlesRetour.getCellText(i, 'oebr_colLigne_Id');
			oebr_curLine = ligneId;
			oebr_curArticleId = oebr_aArticlesRetour.getCellText(i, 'oebr_colArticle_Id');

			var qGetLigne = new QueryHttp('Facturation/Retours_Clients/getArticleBonRetour.tmpl');
			qGetLigne.setParam("Ligne_Id", ligneId);
			var result = qGetLigne.execute();

			document.getElementById('oebr-refArticle').value = result.responseXML.documentElement.getAttribute('Reference');
			document.getElementById('oebr-designation').value = result.responseXML.documentElement.getAttribute('Designation');
			document.getElementById('oebr-nbPieces').value = result.responseXML.documentElement.getAttribute('Nb_Pieces');
			document.getElementById('oebr-qte').value = result.responseXML.documentElement.getAttribute('Quantite');
			document.getElementById('oebr-numLot').value = result.responseXML.documentElement.getAttribute('Num_Lot');
			document.getElementById('oebr-DLC').value = result.responseXML.documentElement.getAttribute('DLC');
			document.getElementById('oebr-unites').value = result.responseXML.documentElement.getAttribute('Unite_Id');
			var isArticleId = result.responseXML.documentElement.getAttribute('Article_Id');

			if (isArticleId == "true") {
				document.getElementById('oebr-refArticle').setAttribute("readonly","readonly");
				document.getElementById('oebr-designation').setAttribute("readonly","readonly");
			}
			else {
				document.getElementById('oebr-refArticle').removeAttribute("readonly");
				document.getElementById('oebr-designation').removeAttribute("readonly");
			}

			document.getElementById('oebr-bConsultSerieLigne').disabled = (oebr_curArticleId=="");
			document.getElementById('oebr-bAjouterLigne').disabled = false;
			document.getElementById('oebr-bSupprimerLigne').disabled = false;
			document.getElementById('oebr-numLot').disabled = (oebr_curArticleId=="");
			document.getElementById('oebr-DLC').disabled = (oebr_curArticleId=="");
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oebr_deleteLine() {
	try {
		if (oebr_aArticlesRetour.isSelected()) {
			var i = oebr_aArticlesRetour.getCurrentIndex();
			var ligneId = oebr_aArticlesRetour.getCellText(i, 'oebr_colLigne_Id');

			var qDeleteLigne = new QueryHttp('Facturation/Retours_Clients/enleverArticleBonRetour.tmpl');
			qDeleteLigne.setParam("Ligne_Id", ligneId);
			qDeleteLigne.execute(oebr_endDeleteLine);

		}
	} catch (e) {
		recup_erreur(e);
	}
}

function oebr_endDeleteLine() {
	try {
		oebr_resetLine();
		oebr_aArticlesRetour.initTree();
	} catch (e) {
		recup_erreur(e);
	}
}

function oebr_viderChamps() {
	try {
		oebr_mode = "C";
		oebr_etatBon = "N";
		document.getElementById('oebr-deckBonRetour').selectedIndex = 0;
		document.getElementById('oebr-tabBoxBon').selectedIndex = 0;
		document.getElementById('oebr-numClient').value = "";
		document.getElementById('oebr-numero').value = "";
		document.getElementById('oebr-dateBon').value = "";
		document.getElementById('oebr-etat').value = "";
		document.getElementById('oebr-dateRetour').value = "";
		document.getElementById('oebr-refArticle').value = "";

		oebr_aEtablissements.deleteTree();
		oebr_aDepots.deleteTree();

		document.getElementById('oebr-denomination').value = "";
		document.getElementById('oebr-adresse1').value = "";
		document.getElementById('oebr-adresse2').value = "";
		document.getElementById('oebr-adresse3').value = "";
		document.getElementById('oebr-codePostal').value = "";
		document.getElementById('oebr-ville').value = "";
		document.getElementById('oebr-codePays').value = "FR";
		document.getElementById('oebr-civInter').value = "0";
		document.getElementById('oebr-nomInter').value = "";
		document.getElementById('oebr-prenomInter').value = "";
		document.getElementById('oebr-telInter').value = "";
		document.getElementById('oebr-faxInter').value = "";
		document.getElementById('oebr-emailInter').value = "";
		document.getElementById('oebr-rgpTypeRetour').value = "E";
		document.getElementById('oebr-tabBon').setAttribute('image', null);

		oebr_aVersion.deleteTree();

		document.getElementById('oebr-commentairesFin').value = "";
		document.getElementById('oebr-commentairesInt').value = "";
		document.getElementById('oebr-nbPieces').value = "";
		document.getElementById('oebr-qte').value = "1";
		document.getElementById('oebr-DLC').value = "";
		document.getElementById('oebr-numLot').value = "";
		document.getElementById('oebr-numSerie').value = "";
		document.getElementById('oebr-designation').value = "";
		document.getElementById('oebr-creation').value = "";
		document.getElementById('oebr-modification').value = "";
		document.getElementById('oebr-fiche').value = "";
		oebr_modifie = false;
	} catch (e) {
		recup_erreur(e);
	}
}

function oebr_bloquerChamps() {
	try {

		document.getElementById('oebr-refArticle').disabled = true;
		document.getElementById('oebr-bArticle').disabled = true;

		document.getElementById('oebr-etablissement').disabled = true;
		document.getElementById('oebr-depot').disabled = true;
		document.getElementById('oebr-bRechClient').disabled = true;
		document.getElementById('oebr-bChercherAdresse').disabled = true;
		document.getElementById('oebr-bChercherInter').disabled = true;
		document.getElementById('oebr-bChoisirMentions').disabled = true;
		document.getElementById('oebr-bSupprimerLigne').disabled = true;
		document.getElementById('oebr-bEnregistrer').disabled = true;
		document.getElementById('oebr-bValiderBR').disabled = true;
		document.getElementById('oebr-bAnnuler').disabled = true;
		document.getElementById('oebr-bSupprimer').disabled = true;
		document.getElementById('oebr-bVisualiser').disabled = true;

		document.getElementById('oebr-denomination').disabled = true;
		document.getElementById('oebr-adresse1').disabled = true;
		document.getElementById('oebr-adresse2').disabled = true;
		document.getElementById('oebr-adresse3').disabled = true;
		document.getElementById('oebr-codePostal').disabled = true;
		document.getElementById('oebr-ville').disabled = true;
		document.getElementById('oebr-codePays').disabled = true;
		document.getElementById('oebr-civInter').disabled = true;
		document.getElementById('oebr-nomInter').disabled = true;
		document.getElementById('oebr-prenomInter').disabled = true;
		document.getElementById('oebr-telInter').disabled = true;
		document.getElementById('oebr-faxInter').disabled = true;
		document.getElementById('oebr-emailInter').disabled = true;
		document.getElementById('oebr-commentairesFin').disabled = true;
		document.getElementById('oebr-commentairesInt').disabled = true;
		document.getElementById('oebr-codePays').disabled = true;
		document.getElementById('oebr-rgpTypeRetour').disabled = true;

		document.getElementById('oebr-bOuvrirCommentairesCaches').disabled = true;

		document.getElementById('oebr-bRechClient').collapsed = true;

		document.getElementById('oebr-creation').collapsed = true;
		document.getElementById('oebr-modification').collapsed = true;

		document.getElementById("oebr-numLot").disabled = true;
		document.getElementById("oebr-DLC").disabled = true;

		document.getElementById('oebr-bConsultSerieLigne').disabled = true;

		document.getElementById('oebr-bAjouterLigne').disabled = false;
		document.getElementById('oebr-bSupprimerLigne').disabled = true;
		document.getElementById('oebr-bAnnuler').disabled = true;
		document.getElementById('oebr-bAnnuler').collapsed = true;

		document.getElementById('oebr-tabVersionDocument').collapsed=true;
		document.getElementById('oebr_switchSaisie').collapsed = !oebr_actSuiviSerie;
		document.getElementById('oebr-bAAjouterLigneSerie').disabled = true;
		document.getElementById('oebr-numSerie').disabled = true;

		oebr_aArticlesRetour.deleteTree();
	} catch (e) {
		recup_erreur(e);
	}
}

function oebr_supprimerBon() {
	  try {
		  var qDeleteBon = new QueryHttp('Facturation/Retours_Clients/supprimerBonRetour.tmpl');
		  qDeleteBon.setParam("Bon_Id", bonRetourId);
		  var result = qDeleteBon.execute();
		  var errors = new Errors(result);

			if (errors.hasNext()) {
				errors.show();
			}
			else {
				var message = result.responseXML.documentElement.getAttribute('Message');
				if (message!=null) {
					showWarning(message);
				}
				retourMenuRetours();
			}
	  }
	  catch (e) {
			recup_erreur(e);
	  }
}


function oebr_bloquerSaisie() {
	try {

		document.getElementById("oebr-refArticle").disabled = true;
		document.getElementById("oebr-designation").disabled = true;
		document.getElementById("oebr-numLot").disabled = true;
		document.getElementById("oebr-DLC").disabled = true;
		document.getElementById("oebr-nbPieces").disabled = true;
		document.getElementById("oebr-qte").disabled = true;
		document.getElementById("oebr-unites").disabled = true;
		document.getElementById("oebr-bAnnulerLigne").disabled = true;
		document.getElementById("oebr-bAjouterLigne").disabled = true;
		document.getElementById("oebr-bSupprimerLigne").disabled = true;
		document.getElementById("oebr-listeArticlesBonRetour").disabled = true;

	} catch (e) {
		recup_erreur(e);
	}
}


function oebr_checkNumLotLigne(numero, datePeremption) {
	try {

		var ok = true;

		if (oebr_actSuiviLot && !isEmpty(oebr_curArticleId)) {

			var qSuiviLotDLC = new QueryHttp("Facturation/Articles/getSuiviLotDLC.tmpl");
			qSuiviLotDLC.setParam("Article_Id", oebr_curArticleId);
			var result = qSuiviLotDLC.execute();
			var isSuiviLot = (result.responseXML.documentElement.getAttribute("Suivi_Lot")=="true");
			var isSuiviDLC = (result.responseXML.documentElement.getAttribute("Suivi_DLC")=="true");

			if ((isSuiviLot || !isEmpty(datePeremption)) && isEmpty(numero)) {
				ok = false;
				showWarning("N\u00B0 Lot manquant");
			}
			else if (isSuiviDLC && isEmpty(datePeremption)) {
				ok = false;
				showWarning("Date de p\u00E9remption manquante");
			}
			else if (!isEmpty(datePeremption) && !isDate(datePeremption)) {
				ok = false;
				showWarning("Date de p\u00E9remption incorrecte");
			}
		}

		return ok;

	} catch (e) {
		recup_erreur(e);
	}
}


function oebr_onKeyPressNumLot(ev) {
	try {

		if (ev.keyCode==13 && oebr_curArticleId!="") {
			var numero = document.getElementById("oebr-numLot").value;

			var url = "chrome://opensi/content/facturation/user/tracabilite_articles/popup-rechercheLot.xul";
			window.openDialog(url,'','chrome,modal,centerscreen', oebr_retourRechercherLot, oebr_curArticleId, numero, null, oebr_clientId);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oebr_retourRechercherLot(numero, datePeremption) {
	try {

		document.getElementById("oebr-numLot").value = numero;
		document.getElementById("oebr-DLC").value = datePeremption;

	} catch (e) {
		recup_erreur(e);
	}
}


function oebr_updateDLC() {
	try {

		var numero = document.getElementById("oebr-numLot").value;

		if (!isEmpty(numero) && !isEmpty(oebr_curArticleId)) {
			var qGetDLC = new QueryHttp("Facturation/Tracabilite/getDLCNumLot.tmpl");
			qGetDLC.setParam("Article_Id", oebr_curArticleId);
			qGetDLC.setParam("Numero", numero);
			var result = qGetDLC.execute();
			var datePeremption = result.responseXML.documentElement.getAttribute("Date_Peremption");
			if (!isEmpty(datePeremption)) {
				document.getElementById("oebr-DLC").value = datePeremption;
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oebr_checkNumSerieLigne(quantite) {
	try {

		if (oebr_actSuiviSerie && !isEmpty(oebr_curArticleId)) {

			var qSuiviSerie = new QueryHttp("Facturation/Articles/getSuiviSerie.tmpl");
			qSuiviSerie.setParam("Article_Id", oebr_curArticleId);
			var result = qSuiviSerie.execute();
			var isSuiviSerie = (result.responseXML.documentElement.getAttribute("Suivi_Serie")=="true");

			var wrongNbSerie = false;

			var qNbSerie = new QueryHttp("Facturation/Retours_Clients/getNbNumSerieLigneRC.tmpl");
			qNbSerie.setParam("Ligne_Id", oebr_curLine);
			var resNS = qNbSerie.execute();
			var nb = parseIntBis(resNS.responseXML.documentElement.getAttribute("Nombre"));
			if ((isSuiviSerie && nb!=quantite) || nb>quantite) {
				wrongNbSerie = true;
			}

			if (isSuiviSerie || wrongNbSerie) {
				var url = "chrome://opensi/content/facturation/user/commun/popup-numSerie.xul";
		    window.openDialog(url,'','chrome,modal,centerscreen', "S", "RC", oebr_curLine, oebr_clientId);
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oebr_consulterNumSerie()  {
	try {

		if (oebr_aArticlesRetour.isSelected()) {
			var url = "chrome://opensi/content/facturation/user/commun/popup-numSerie.xul";
    	window.openDialog(url,'','chrome,modal,centerscreen', (oebr_mode!="V"?"S":"C"), "RC", oebr_curLine, oebr_clientId);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oebr_onKeyPressNumSerie(event) {
	try {

		if (event.keyCode==13) {
			oebr_validerSaisieBySerie();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oebr_validerSaisieBySerie(articleId) {
	try {

		var numSerie = document.getElementById("oebr-numSerie").value;

		if (articleId==null) {
			articleId = "";
			oebr_numSerie = numSerie;
			// correction bug zen 22578 - le n srie tait vide suite  enregistrement/rechargement du retour en cas de conflit
		}
		else {
			numSerie = oebr_numSerie;
		}

		if (!isEmpty(numSerie)) {

			var ok = true;
			if (oebr_mode=="C") {
				ok = oebr_enregistrerBon(true);
			}
			if (ok) {
				var qAddNS = new QueryHttp("Facturation/Retours_Clients/addNumSerieRC.tmpl");
				qAddNS.setParam("Retour_Id", bonRetourId);
				qAddNS.setParam("Num_Serie", numSerie);
				qAddNS.setParam("Article_Id", articleId);
				var result = qAddNS.execute();

				var errors = new Errors(result);
				if (errors.hasNext()) {
					errors.show();
				}
				else {
					var conflit = (result.responseXML.documentElement.getAttribute("Conflit")=="true");
					if (conflit) {
						var listConflit = result.responseXML.documentElement.getAttribute("List_Conflit");
						var url = "chrome://opensi/content/facturation/user/retours_clients/popup-conflitNumSerieRC.xul";
						window.openDialog(url,'','chrome,modal,centerscreen', listConflit, oebr_retourChoixConflit);
					}
					else {
						oebr_resetLine();
						oebr_aArticlesRetour.initTree();
					}
				}
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oebr_retourChoixConflit(articleId) {
	try {

		oebr_validerSaisieBySerie(articleId);

	} catch (e) {
		recup_erreur(e);
	}
}


function oebr_switchSaisie() {
	try {

		var isCollapsed = document.getElementById("oebr-saisieLigne").collapsed;
		document.getElementById("oebr-saisieLigne").collapsed = !isCollapsed;
		document.getElementById("oebr-saisieSerie").collapsed = isCollapsed;

	} catch (e) {
		recup_erreur(e);
	}
}
