/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/


var orrf_aArticlesBR = new Arbre('Facturation/Retours_Fournisseurs/list-ligneBonReception.tmpl', 'orrf-tArticlesBR');
var orrf_aArticlesRF = new Arbre('Facturation/Retours_Fournisseurs/list-articlesNonReceptionnesRF.tmpl', 'orrf-tArticlesRF');
var orrf_aReceptions = new Arbre('Facturation/Retours_Fournisseurs/list-bonReception.tmpl', 'orrf-tReceptions');
var orrf_aDepotsReception = new Arbre('ComboListe/combo-depotsStock.tmpl', 'orrf-depotReception');
var orrf_aVersions = new Arbre('Facturation/Retours_Fournisseurs/list-versionBonReception.tmpl', 'orrf-tVersions');
var orrf_aRangement = new Arbre("Facturation/Retours_Fournisseurs/list-storeLigneBR.tmpl", "orrf-tRangement");


var orrf_modified = false;
var orrf_actSuiviSerie;
var orrf_actSuiviLot;
var orrf_bonRecId;
var orrf_retourId;
var orrf_etapeRangement;
var orrf_currentDepotId;
var orrf_statutReception;
var orrf_mode;
var orrf_etatBon;
var orrf_etatRF;
var orrf_soldeRec;
var orrf_selectDepotReception;
var orrf_modeSaisieNS;
var orrf_actEmplacements;



function orrf_init() {
  try {

		var config = getConfig();

		orrf_actEmplacements = config.isActEmplacements();
		orrf_actSuiviLot = config.isActSuiviLot();
		orrf_actSuiviSerie = config.isActSuiviSerie();
		orrf_modeSaisieNS = orrf_actSuiviSerie;

		document.getElementById('orrf-bConsultSerieLigne').collapsed = !orrf_actSuiviSerie;
		document.getElementById('orrf-boxSaisieSerie').collapsed = !orrf_actSuiviSerie;
		document.getElementById('orrf-bSwitchMode').collapsed = !orrf_actSuiviSerie;
		document.getElementById('orrf-boxSaisieCodeBarre').collapsed = orrf_actSuiviSerie;

		if (!orrf_actSuiviLot) {
			document.getElementById('orrf-colNumLotBR').collapsed = true;
			document.getElementById('orrf-colNumLotBR').setAttribute('ignoreincolumnpicker', true);
			document.getElementById('orrf-colDatePeremptionBR').collapsed = true;
			document.getElementById('orrf-colDatePeremptionBR').setAttribute('ignoreincolumnpicker', true);
			document.getElementById('orrf-rowNumLot').collapsed = true;
			document.getElementById('orrf-rowDLC').collapsed = true;
		}

		if (!config.isActNbPieces()) {
			document.getElementById('orrf-colNbPiecesRF').collapsed = true;
			document.getElementById('orrf-colNbPiecesRF').setAttribute('ignoreincolumnpicker', true);
			document.getElementById('orrf-colNbPiecesBR').collapsed = true;
			document.getElementById('orrf-colNbPiecesBR').setAttribute('ignoreincolumnpicker', true);
			document.getElementById('orrf-rowNbPieces').collapsed = true;
		}

  } catch (e) {
  	recup_erreur(e);
  }
}


function orrf_initDepotReception() {
	try {

		document.getElementById('orrf-depotReception').value = orrf_selectDepotReception;

	} catch (e) {
		recup_erreur(e);
	}
}


function orrf_chargerDepotsReception(selection) {
	try {

		orrf_selectDepotReception = selection;
		orrf_aDepotsReception.setParam("Selection", selection);
		orrf_aDepotsReception.initTree(orrf_initDepotReception);

	} catch (e) {
		recup_erreur(e);
	}
}


function orrf_start() {
	try {

		var qHasBRNonValide = new QueryHttp('Facturation/Retours_Fournisseurs/getFirstBRNonValide.tmpl');
		qHasBRNonValide.setParam("Retour_Id", orrf_retourId);
		var result = qHasBRNonValide.execute();

		if (result.responseXML.documentElement.getAttribute("HasBRNonValide")=="true") {
			orrf_bonRecId = result.responseXML.documentElement.getAttribute("Bon_Id");
			orrf_chargerBon();
		}
		else {
			orrf_nouveauBon();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function orrf_reinitialiser() {
	try {

		orrf_mode = "C";
		orrf_etatBon = "N";
		orrf_modified = false;
		orrf_etapeRangement = false;
		orrf_currentDepotId = "";

		document.getElementById('orrf-deckBonReception').selectedIndex = 0;
		document.getElementById('orrf-tbBonReception').selectedIndex = 0;
		document.getElementById('orrf-tabBon').setAttribute('image', null);
		document.getElementById('orrf-numeroBR').value = "";
		document.getElementById('orrf-numeroRG').value = "";
		document.getElementById('orrf-tabVersions').collapsed = true;
		document.getElementById('orrf-boxRangement').collapsed = true;

		orrf_aVersions.deleteTree();
		orrf_aReceptions.setParam("Retour_Id", orrf_retourId);
		orrf_aReceptions.initTree();

		document.getElementById('orrf-numSerie').value = "";
		document.getElementById('orrf-codeBarre').value = "";
		document.getElementById('orrf-dateRG').value = "";
		document.getElementById('orrf-dateBR').value = "";
		document.getElementById('orrf-etat').value = "";
		document.getElementById('orrf-commentairesFin').value = "";
		document.getElementById('orrf-commentairesInt').value = "";
		document.getElementById('orrf-numLot').value = "";
		document.getElementById('orrf-datePeremption').value = "";
		document.getElementById('orrf-nbPieces').value = "";
		document.getElementById('orrf-quantite').value = "";
		document.getElementById('orrf-creation').value = "";
		document.getElementById('orrf-modification').value = "";
		document.getElementById('orrf-document').value = "";

		document.getElementById('orrf-bChoisirMentions').disabled = true;
		document.getElementById('orrf-bAjouter').disabled = true;
		document.getElementById('orrf-bToutAjouter').disabled = true;
		document.getElementById('orrf-bEnlever').disabled = true;
		document.getElementById('orrf-bToutEnlever').disabled = true;
		document.getElementById('orrf-bEnregistrer').disabled = true;
		document.getElementById('orrf-bGenererBR').disabled = true;
		document.getElementById('orrf-bAnnuler').disabled = true;
		document.getElementById('orrf-bSupprimer').disabled = true;
		document.getElementById('orrf-bEditerBR').disabled = true;

		document.getElementById('orrf-commentairesFin').disabled = true;
		document.getElementById('orrf-commentairesInt').disabled = true;
		document.getElementById('orrf-depotReception').disabled = true;
		document.getElementById('orrf-numLot').disabled = true;
		document.getElementById('orrf-datePeremption').disabled = true;
		document.getElementById('orrf-nbPieces').disabled = true;
		document.getElementById('orrf-quantite').disabled = true;
		document.getElementById('orrf-bConsultSerieLigne').disabled = true;
		document.getElementById('orrf-bOuvrirCommentairesCaches').disabled = true;

		document.getElementById('orrf-bEditerBR').collapsed = true;
		document.getElementById('orrf-boxSaisieSerie').collapsed = (!orrf_modeSaisieNS || !orrf_actSuiviSerie || orrf_etatBon!="N");
		document.getElementById('orrf-boxSaisieCodeBarre').collapsed = (orrf_modeSaisieNS || orrf_etatBon!="N");
		document.getElementById('orrf-bSwitchMode').collapsed = (!orrf_actSuiviSerie || orrf_etatBon!="N");

		if (orrf_etatBon=="N") {
			if (orrf_modeSaisieNS) {
				document.getElementById('orrf-numSerie').focus();
			}
			else {
				document.getElementById('orrf-codeBarre').focus();
			}
		}

		orrf_aArticlesBR.deleteTree();
		orrf_aArticlesRF.deleteTree();
		orrf_aRangement.deleteTree();

		// chargement des infos du retour

		var qDefTrans = new QueryHttp('Facturation/Retours_Fournisseurs/loadRetourFournisseur.tmpl');
		qDefTrans.setParam('Retour_Id', orrf_retourId);
		var result = qDefTrans.execute();
		orrf_etatRF = result.responseXML.documentElement.getAttribute('Etat');
		orrf_soldeRec = (result.responseXML.documentElement.getAttribute('Solde_Rec')=="true");
		document.getElementById('orrf-numRetour').value = result.responseXML.documentElement.getAttribute('Num_Retour');

		document.getElementById('orrf-bNouveau').disabled = (orrf_etatRF=="C" || orrf_etatRF=="A" || orrf_soldeRec);

		orrf_chargerDepotsReception(result.responseXML.documentElement.getAttribute('Depot_Id'));

	} catch (e) {
		recup_erreur(e);
	}
}


function orrf_debloquerChamps() {
	try {

		document.getElementById('orrf-bChoisirMentions').disabled = false;
		document.getElementById('orrf-bAjouter').disabled = false;
		document.getElementById('orrf-bToutAjouter').disabled = false;
		document.getElementById('orrf-bEnlever').disabled = false;

		document.getElementById('orrf-commentairesFin').disabled = false;
		document.getElementById('orrf-commentairesInt').disabled = false;
		document.getElementById('orrf-depotReception').disabled = false;
		document.getElementById('orrf-numLot').disabled = false;
		document.getElementById('orrf-datePeremption').disabled = false;
		document.getElementById('orrf-nbPieces').disabled = false;
		document.getElementById('orrf-quantite').disabled = false;
		document.getElementById('orrf-bEnregistrer').disabled = false;
		document.getElementById('orrf-bSupprimer').disabled = false;

		document.getElementById('orrf-bAjouter').disabled = true;
		document.getElementById('orrf-bEnlever').disabled = true;

	} catch (e) {
    recup_erreur(e);
  }
}


function orrf_switchMode() {
	try {

		orrf_modeSaisieNS = !orrf_modeSaisieNS;
		document.getElementById('orrf-boxSaisieSerie').collapsed = !orrf_modeSaisieNS;
		document.getElementById('orrf-boxSaisieCodeBarre').collapsed = orrf_modeSaisieNS;
		if (orrf_modeSaisieNS) {
			document.getElementById('orrf-numSerie').focus();
		}
		else {
			document.getElementById('orrf-codeBarre').focus();
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function orrf_nouveauBon() {
  try {

		orrf_bonRecId = "";
		orrf_reinitialiser();

		if (orrf_etatRF!="C" && orrf_etatRF!="A" && !orrf_soldeRec) {
			orrf_aArticlesRF.clearParams();
			orrf_aArticlesRF.setParam('Retour_Id', orrf_retourId);
			orrf_aArticlesRF.initTree();

			document.getElementById('orrf-bEditerBR').collapsed = false;
			document.getElementById('orrf-bSupprimer').collapsed = true;
			document.getElementById('orrf-bAnnuler').collapsed = true;
			orrf_debloquerChamps();

			document.getElementById('orrf-bEnregistrer').disabled = false;
			document.getElementById('orrf-bGenererBR').disabled = true;
			document.getElementById('orrf-bEditerBR').disabled = true;
			document.getElementById('orrf-boxArticlesRF').collapsed = false;
			document.getElementById('orrf-boxActions').collapsed = false;

			orrf_setModified(false);
		}
		else {
			document.getElementById('orrf-boxActions').collapsed = true;
			document.getElementById('orrf-boxArticlesRF').collapsed = true;
			document.getElementById('orrf-boxSaisieSerie').collapsed = true;
			document.getElementById('orrf-boxSaisieCodeBarre').collapsed = true;
			document.getElementById('orrf-bSwitchMode').collapsed = true;
			document.getElementById('orrf-bGenererBR').collapsed = true;
			document.getElementById('orrf-bSupprimer').collapsed = true;
			document.getElementById('orrf-bAnnuler').collapsed = true;
		}

	} catch (e) {
  	recup_erreur(e);
  }
}


function orrf_pressOnReceptions(ev) {
  try {

		if (ev.keyCode==13) {
			orrf_bonRecId = orrf_aReceptions.getSelectedCellText('orrf-colBonId');
			orrf_chargerBon();
		}

	} catch (e) {
  	recup_erreur(e);
  }
}


function orrf_dblclickOnReceptions() {
  try {

		if (orrf_aReceptions.isSelected()) {
			orrf_bonRecId = orrf_aReceptions.getSelectedCellText('orrf-colBonId');
			orrf_chargerBon();
		}

	} catch (e) {
  	recup_erreur(e);
  }
}


function orrf_chargerBon() {
  try {

		orrf_reinitialiser();
		orrf_aArticlesBR.setParam('Bon_Id', orrf_bonRecId);
		orrf_aArticlesRF.setParam('Bon_Id', orrf_bonRecId);

		document.getElementById('orrf-bEditerBR').collapsed = false;

		orrf_mode = "M";

		var qLoad = new QueryHttp('Facturation/Retours_Fournisseurs/loadBonReception.tmpl');
		qLoad.setParam("Bon_Rec_Id", orrf_bonRecId);
		var result = qLoad.execute();
		var contenu = result.responseXML.documentElement;

		orrf_etapeRangement = contenu.getAttribute("Etape_Rangement")=="true";
		orrf_statutReception = contenu.getAttribute("Statut_Reception");
		orrf_currentDepotId = contenu.getAttribute("Depot_Id");

		orrf_etatBon = contenu.getAttribute("Etat");
		orrf_chargerDepotsReception(contenu.getAttribute('Depot_Id'));

		if (orrf_etatBon=="V") {
			document.getElementById('orrf-etat').value = "Valid\u00E9";
			document.getElementById('orrf-bSupprimer').collapsed = true;
			document.getElementById('orrf-bAnnuler').collapsed = (orrf_etatRF=="C");
			document.getElementById('orrf-boxArticlesRF').collapsed = true;
			document.getElementById('orrf-boxActions').collapsed = true;
			document.getElementById('orrf-bAnnuler').disabled = (orrf_etatRF=="C");
			if (orrf_statutReception=="R" && orrf_actEmplacements) {
				document.getElementById('orrf-boxRangement').collapsed = false;
			}
		}
		else if (orrf_etatBon=="A") {
			document.getElementById('orrf-etat').value = "Annul\u00E9";
			document.getElementById('orrf-bSupprimer').collapsed = true;
			document.getElementById('orrf-bAnnuler').collapsed = true;
			document.getElementById('orrf-boxArticlesRF').collapsed = true;
			document.getElementById('orrf-boxActions').collapsed = true;
		}
		else {
			document.getElementById('orrf-etat').value = "Non valid\u00E9";
			document.getElementById('orrf-bAnnuler').collapsed = true;
			document.getElementById('orrf-bSupprimer').collapsed = false;
			document.getElementById('orrf-boxArticlesRF').collapsed = false;
			document.getElementById('orrf-boxActions').collapsed = false;
			document.getElementById('orrf-bNouveau').disabled = true;
		}

		if (orrf_etatBon!="N") {
			document.getElementById('orrf-tabVersions').collapsed = false;
			orrf_initVersion();
		}
		else if (orrf_modeSaisieNS) {
			document.getElementById('orrf-numSerie').focus();
		}
		else {
			document.getElementById('orrf-codeBarre').focus();
		}

		document.getElementById('orrf-boxSaisieSerie').collapsed = (!orrf_modeSaisieNS || !orrf_actSuiviSerie || orrf_etatBon!="N");
		document.getElementById('orrf-boxSaisieCodeBarre').collapsed = (orrf_modeSaisieNS || orrf_etatBon!="N");
		document.getElementById('orrf-bSwitchMode').collapsed = (!orrf_actSuiviSerie || orrf_etatBon!="N");

		document.getElementById('orrf-dateRG').value = contenu.getAttribute("Date_RG");
		document.getElementById('orrf-dateBR').value = contenu.getAttribute("Date_BR");
		document.getElementById('orrf-commentairesFin').value = contenu.getAttribute("Commentaires_Fin");
		document.getElementById('orrf-commentairesInt').value = contenu.getAttribute("Commentaires_Int");
		document.getElementById('orrf-numeroRG').value = contenu.getAttribute("Numero_RG");
		document.getElementById('orrf-numeroBR').value = contenu.getAttribute("Numero_BR");

		document.getElementById('orrf-creation').setAttribute("label", "R\u00E9ception cr\u00E9\u00E9e le "+ contenu.getAttribute('Date_Creation') +" par "+ contenu.getAttribute('Login_Createur'));
		document.getElementById('orrf-modification').setAttribute("label", "Derni\u00E8re modification le "+ contenu.getAttribute('Date_Maj') +" par "+ contenu.getAttribute('Login_Maj'));
		document.getElementById('orrf-document').setAttribute("label", "Bon de r\u00E9ception N\u00B0 "+ contenu.getAttribute('Numero_BR'));
		document.getElementById('orrf-creation').collapsed = false;
		document.getElementById('orrf-modification').collapsed = false;

		document.getElementById('orrf-bOuvrirCommentairesCaches').disabled = false;

		orrf_aArticlesBR.initTree();

		orrf_setModified(false);

		if (orrf_etatBon!='V' && orrf_etatBon!='A') {
			orrf_aArticlesRF.setParam('Retour_Id', orrf_retourId);
			orrf_aArticlesRF.initTree();
			orrf_debloquerChamps();
			document.getElementById('orrf-bToutEnlever').disabled = false;
		}

	} catch (e) {
  	recup_erreur(e);
  }
}


function orrf_editerCommentairesInternes()  {
  try {

  	var url = "chrome://opensi/content/facturation/user/commun/popup-commentairesInternes.xul";
  	window.openDialog(url,'','chrome,modal,centerscreen', "BRR", orrf_bonRecId, false);

	} catch (e) {
  	recup_erreur(e);
  }
}


function orrf_editerCommentairesDocument() {
  try {

		var commentairesFin = document.getElementById('orrf-commentairesFin').value;
		var commentairesInt = document.getElementById('orrf-commentairesInt').value;
		var readOnly = (orrf_etatBon!="N");

		var url = "chrome://opensi/content/facturation/user/commun/popup-commentairesDocument.xul";
  	window.openDialog(url,'','chrome,modal,centerscreen', orrf_retourEditerCommentaires, "BRR", orrf_bonRecId, commentairesFin, commentairesInt, readOnly);

	} catch (e) {
    recup_erreur(e);
  }
}


function orrf_retourEditerCommentaires(commentairesFin, commentairesInt) {
  try {

		document.getElementById('orrf-commentairesFin').value = commentairesFin;
		document.getElementById('orrf-commentairesInt').value = commentairesInt;

	} catch (e) {
    recup_erreur(e);
  }
}


function orrf_enregistrerBon(rafraichir) {
  try {

		var commentairesFin = document.getElementById('orrf-commentairesFin').value;
		var commentairesInt = document.getElementById('orrf-commentairesInt').value;
		var depotId = document.getElementById('orrf-depotReception').value;

		var qSave;

		if (orrf_mode=="C") {
			qSave = new QueryHttp("Facturation/Retours_Fournisseurs/createBonReception.tmpl");
			qSave.setParam("Retour_Id", orrf_retourId);
		}
		else {
			qSave = new QueryHttp("Facturation/Retours_Fournisseurs/updateBonReception.tmpl");
			qSave.setParam("Bon_Id", orrf_bonRecId);
		}

		qSave.setParam("Depot_Id", depotId);
		qSave.setParam("Commentaires_Fin", commentairesFin);
		qSave.setParam("Commentaires_Int", commentairesInt);

		var result = qSave.execute();

		if (orrf_mode=="C") {
			orrf_bonRecId = result.responseXML.documentElement.getAttribute("Bon_Id");

			if (rafraichir) {
				orrf_chargerBon();
			}
		}
		orrf_aReceptions.initTree();

		orrf_setModified(false);

		return true;

	} catch (e) {
  	recup_erreur(e);
  }
}


function orrf_supprimerBon() {
  try {

		if (window.confirm("Confirmez-vous la suppression de la r\u00E9ception ?")) {

			var qDelete = new QueryHttp("Facturation/Retours_Fournisseurs/deleteBonReception.tmpl");
			qDelete.setParam("Bon_Id", orrf_bonRecId);
			qDelete.execute();

			showMessage("La r\u00E9ception a \u00E9t\u00E9 supprim\u00E9e avec succ\u00E8s");
			orrf_nouveauBon();
		}

	} catch (e) {
  	recup_erreur(e);
  }
}


function orrf_toutTransferer() {
  try {

  	var ok = true;
		if (orrf_mode=="C") {
			ok = orrf_enregistrerBon(true);
		}
		if (ok) {
			var qAdd = new QueryHttp('Facturation/Retours_Fournisseurs/addAllBR.tmpl');
			qAdd.setParam("Bon_Id", orrf_bonRecId);
			qAdd.setParam("Retour_Id", orrf_retourId);
			qAdd.execute();

			orrf_aArticlesRF.initTree();
			orrf_aArticlesBR.initTree();

			document.getElementById('orrf-numLot').value = "";
			document.getElementById('orrf-datePeremption').value = "";
			document.getElementById('orrf-nbPieces').value = "";
			document.getElementById('orrf-quantite').value = "";

			document.getElementById('orrf-bAjouter').disabled = true;
			document.getElementById('orrf-bEnlever').disabled = true;
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function orrf_toutEnlever() {
  try {

		var qRemove = new QueryHttp('Facturation/Retours_Fournisseurs/removeAllBR.tmpl');
		qRemove.setParam("Bon_Id", orrf_bonRecId);
		qRemove.execute();

		orrf_aArticlesRF.initTree();
		orrf_aArticlesBR.initTree();

		document.getElementById('orrf-numLot').value = "";
		document.getElementById('orrf-datePeremption').value = "";
		document.getElementById('orrf-nbPieces').value = "";
		document.getElementById('orrf-quantite').value = "";

		document.getElementById('orrf-bAjouter').disabled = true;
		document.getElementById('orrf-bEnlever').disabled = true;

		document.getElementById("orrf-bConsultSerieLigne").disabled = true;

	} catch (e) {
  	recup_erreur(e);
	}
}


function orrf_ajouter() {
  try {

		if (orrf_aArticlesRF.isSelected()) {

			var articleId = orrf_aArticlesRF.getSelectedCellText('orrf-colArticleIdRF');
			var ligneRF = orrf_aArticlesRF.getSelectedCellText('orrf-colLigneIdRF');
			var isSuiviLot = orrf_aArticlesRF.getSelectedCellText('orrf-colSuiviLotRF')=="true";
			var isSuiviDLC = orrf_aArticlesRF.getSelectedCellText('orrf-colSuiviDLCRF')=="true";
			var isSuiviSerie = orrf_aArticlesRF.getSelectedCellText('orrf-colSuiviSerieRF')=="true";
			var qteRestante = orrf_aArticlesRF.getSelectedCellText('orrf-colQuantiteRF');
			var nbPiecesRestant = orrf_aArticlesRF.getSelectedCellText('orrf-colNbPiecesRF');
			if (isEmpty(nbPiecesRestant)) {	nbPiecesRestant = 0; }

			var quantite = document.getElementById('orrf-quantite').value;
			var numLot = document.getElementById('orrf-numLot').value;
			var datePeremption = document.getElementById('orrf-datePeremption').value;
			var nbPieces = document.getElementById('orrf-nbPieces').value;
			if (isEmpty(nbPieces)) { nbPieces = 0; }

			if (isEmpty(quantite)) { showWarning("Veuillez entrer une quantit\u00E9 \u00E0 transf\u00E9rer"); }
			else if (!checkQte(quantite)) { showWarning("Quantit\u00E9 incorrecte"); }
			else if (!isPositiveOrNullInteger(nbPieces)) { showWarning("Nombre de pi\u00E8ces incorrect");	}
			else if (parseFloat(qteRestante)-parseFloat(quantite)<0) { showWarning("La quantit\u00E9 \u00E0 transf\u00E9rer d\u00E9passe la quantit\u00E9 restant \u00E0 r\u00E9ceptionner"); }
			else if (parseFloat(nbPiecesRestant)-parseFloat(nbPieces)<0) { showWarning("Le nb de pi\u00E8ces \u00E0 transf\u00E9rer d\u00E9passe le nb de pi\u00E8ces restant \u00E0 r\u00E9ceptionner");	}
			else if (orrf_checkNumLotLigne(numLot, datePeremption, articleId, isSuiviLot, isSuiviDLC)) {

				var ok = true;

				if (orrf_mode=="C") {
					ok = orrf_enregistrerBon(true);
				}

				if (ok) {
					var qAdd = new QueryHttp('Facturation/Retours_Fournisseurs/addLigneBR.tmpl');
					qAdd.setParam("Bon_Id", orrf_bonRecId);
					qAdd.setParam("Ligne_RF", ligneRF);
					qAdd.setParam("Quantite", quantite);
					qAdd.setParam("Num_Lot", numLot);
					qAdd.setParam("Nb_Pieces", nbPieces);
					qAdd.setParam("Date_Peremption", datePeremption);
					var result = qAdd.execute();

					var ligneBR = result.responseXML.documentElement.getAttribute('Ligne_Id');
					var quantiteBR = parseIntBis(result.responseXML.documentElement.getAttribute('Quantite'));

					orrf_aArticlesRF.initTree();
					orrf_aArticlesBR.initTree();

					document.getElementById('orrf-numLot').value = "";
					document.getElementById('orrf-datePeremption').value = "";
					document.getElementById('orrf-nbPieces').value = "";
					document.getElementById('orrf-quantite').value = "";

					document.getElementById('orrf-bAjouter').disabled = true;

					orrf_checkNumSerieLigne(ligneBR, isSuiviSerie, quantiteBR);
				}
			}
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function orrf_enlever() {
  try {

		if (orrf_aArticlesBR.isSelected()) {

			var ligneId = orrf_aArticlesBR.getSelectedCellText('orrf-colLigneIdBR');
			var qteInit = orrf_aArticlesBR.getSelectedCellText('orrf-colQuantiteBR');
			var quantite = document.getElementById('orrf-quantite').value;
			var nbPiecesInit = orrf_aArticlesBR.getSelectedCellText('orrf-colNbPiecesBR');
			if (isEmpty(nbPiecesInit)) {
				nbPiecesInit = 0;
			}
			var nbPieces = document.getElementById('orrf-nbPieces').value;
			if (isEmpty(nbPieces)) {
				nbPieces = 0;
			}

			if (isEmpty(quantite)) {
				showWarning("Veuillez entrer une quantit\u00E9 \u00E0 enlever");
			}
			else if (!checkQte(quantite)) {
				showWarning("Quantit\u00E9 incorrecte !");
			}
			else if (parseFloat(qteInit)-parseFloat(quantite)<0) {
				showWarning("La quantit\u00E9 \u00E0 enlever ne peut d\u00E9passer la quantit\u00E9 pr\u00E9sente dans le bon de r\u00E9ception !");
			}
			else if (!isPositiveOrNullInteger(nbPieces)) {
				showWarning("Nombre de pi\u00E8ces incorrect !");
			}
			else if (parseFloat(nbPiecesInit)-parseFloat(nbPieces)<0) {
				showWarning("Le nb de pi\u00E8ces \u00E0 enlever ne peut d\u00E9passer le nb de pi\u00E8ces pr\u00E9sent dans le bon de r\u00E9ception !");
			}
			else {
				var qRemove = new QueryHttp('Facturation/Retours_Fournisseurs/removeLigneBR.tmpl');
				qRemove.setParam("Ligne_Id", ligneId);
				qRemove.setParam("Quantite", quantite);
				qRemove.setParam("Nb_Pieces", nbPieces);
				qRemove.execute();

				orrf_aArticlesRF.initTree();
				orrf_aArticlesBR.initTree();

				document.getElementById('orrf-numLot').value = "";
				document.getElementById('orrf-datePeremption').value = "";
				document.getElementById('orrf-nbPieces').value = "";
				document.getElementById('orrf-quantite').value = "";

				document.getElementById('orrf-bEnlever').disabled = true;

				document.getElementById("orrf-bConsultSerieLigne").disabled = true;
			}
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function orrf_demandeEnregistrement() {
  try {

		if (orrf_modified) {
			if (window.confirm("Voulez-vous enregistrer les modifications apport\u00E9es au bon de r\u00E9ception ?")) {
				orrf_enregistrerBon(false);
			}
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function orrf_setModified(modified) {
  try {

		orrf_modified = modified;

		if (modified) {
			document.getElementById('orrf-tabBon').setAttribute('image', 'chrome://opensi/content/design/icones/modified.png');
			document.getElementById('orrf-bGenererBR').disabled = true;
			document.getElementById('orrf-bGenererRG').disabled = true;
			document.getElementById('orrf-bEditerBR').disabled = true;
			document.getElementById('orrf-bEditerRG').disabled = true;
		}
		else {
			document.getElementById('orrf-tabBon').setAttribute('image', null);
			document.getElementById('orrf-bGenererRG').disabled = orrf_etatBon!='N';
			document.getElementById('orrf-bGenererRG').collapsed = orrf_mode=='C' || orrf_etatBon!='N' || !orrf_etapeRangement;
			document.getElementById('orrf-bGenererBR').disabled = false;
			document.getElementById('orrf-bGenererBR').collapsed = orrf_mode=='C' || (orrf_statutReception!='R' && (orrf_etapeRangement || orrf_etatBon!='N'));
			document.getElementById('orrf-bEditerRG').disabled = false;
			document.getElementById('orrf-bEditerRG').collapsed = orrf_etatBon=='N';
			document.getElementById('orrf-bEditerBR').disabled = false;
			document.getElementById('orrf-bEditerBR').collapsed = orrf_etatBon=='N' || orrf_statutReception=='R' || isEmpty(document.getElementById('orrf-dateBR').value);
		}

	} catch (e) {
  	recup_erreur(e);
	}
}


function orrf_initLangue() {
	try {

		document.getElementById('orrf-langueDefaut').value = orrf_langueDefaut;
		orrf_editerBonReception();

	} catch (e) {
		recup_erreur(e);
	}
}


function orrf_editerBonRangement() {
	try {

		document.getElementById('orrf-pdfBonReception').setAttribute("src", "");
		document.getElementById("bRetourBR").collapsed = false;
		document.getElementById("orrf-deckBonReception").selectedIndex = 1;
		document.getElementById('orrf-bEnvoyer').collapsed = true;

		var qGenPdf = new QueryHttp("Facturation/Retours_Fournisseurs/pdfBonRangement.tmpl");
		qGenPdf.setParam('Bon_Rec_Id', orrf_bonRecId);

		var result = qGenPdf.execute();
		var page = getDirPdf() + result.responseXML.documentElement.getAttribute('FichierPDF');

		document.getElementById('orrf-pdfBonReception').setAttribute("src", page);

	} catch (e) {
		recup_erreur(e);
	}
}


function orrf_editerBonReception() {
	try {

		document.getElementById('orrf-pdfBonReception').setAttribute("src", "");
		document.getElementById("bRetourBR").collapsed = false;
		document.getElementById("orrf-deckBonReception").selectedIndex = 1;
		document.getElementById('orrf-bEnvoyer').collapsed = false;

		var qGenPdf = new QueryHttp("Facturation/Retours_Fournisseurs/pdfBonReception.tmpl");
		qGenPdf.setParam('Bon_Id', orrf_bonRecId);

		var result = qGenPdf.execute();
		var page = getDirPdf() + result.responseXML.documentElement.getAttribute('FichierPDF');

		document.getElementById('orrf-pdfBonReception').setAttribute("src", page);

	} catch (e) {
		recup_erreur(e);
	}
}


function orrf_checkNumSerie() {
	try {

		var ok = true;

		var qCheck = new QueryHttp("Facturation/Retours_Fournisseurs/checkNumSerieBR.tmpl");
		qCheck.setParam("Bon_Id", orrf_bonRecId);
		var result = qCheck.execute();

		var errors = new Errors(result);
		if (errors.hasNext()) {
			ok = false;
			errors.show();
		}

		return ok;

	} catch (e) {
		recup_erreur(e);
	}
}


function orrf_checkNumLot() {
	try {

		var ok = true;

		var qCheck = new QueryHttp("Facturation/Retours_Fournisseurs/checkNumLotBR.tmpl");
		qCheck.setParam("Bon_Id", orrf_bonRecId);
		var result = qCheck.execute();

		var errors = new Errors(result);
		if (errors.hasNext()) {
			ok = false;
			errors.show();
		}

		return ok;

	} catch (e) {
		recup_erreur(e);
	}
}


function orrf_genererRG() {
  try {

		if (orrf_aArticlesBR.nbLignes()<=0) {
			showWarning("La r\u00E9ception ne contient aucune ligne");
		}
		else if ((!orrf_actSuiviSerie || orrf_checkNumSerie()) && (!orrf_actSuiviLot || orrf_checkNumLot())
							&& window.confirm("Confirmez-vous la g\u00E9n\u00E9ration du bon de rangement ?")) {

			var qValid = new QueryHttp("Facturation/Retours_Fournisseurs/generateBonRangement.tmpl");
			qValid.setParam('Bon_Rec_Id', orrf_bonRecId);
			var result = qValid.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				orrf_editerBonRangement();
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function orrf_genererBR() {
  try {

		if (orrf_aArticlesBR.nbLignes()<=0) {
			showWarning("La r\u00E9ception ne contient aucune ligne");
		}
		else if ((!orrf_actSuiviSerie || orrf_checkNumSerie()) && (orrf_statutReception=='R' || !orrf_actSuiviLot || orrf_checkNumLot())
							&& window.confirm("Confirmez-vous la g\u00E9n\u00E9ration du bon de r\u00E9ception ?\n(Attention le bon de r\u00E9ception valid\u00E9 ne pourra plus \u00EAtre modifi\u00E9 !)")) {

			var ok = true;

			if (orrf_statutReception!='R') {
				var qValid = new QueryHttp("Facturation/Retours_Fournisseurs/generateBonRangement.tmpl");
				qValid.setParam('Bon_Rec_Id', orrf_bonRecId);
				var result = qValid.execute();

				var errors = new Errors(result);
				if (errors.hasNext()) {
					ok = false;
					errors.show();
				}
			}

			if (ok) {
				var qValid = new QueryHttp("Facturation/Retours_Fournisseurs/generateBonReception.tmpl");
				qValid.setParam('Bon_Rec_Id', orrf_bonRecId);
				var result = qValid.execute();

				var errors = new Errors(result);
				if (errors.hasNext()) {
					errors.show();
				}
				else {
					orrf_editerBonReception();
				}
			}
  	}

	} catch (e) {
    recup_erreur(e);
  }
}


function orrf_annulerBon() {
  try {

		if (window.confirm("Confirmez-vous l'annulation de la r\u00E9ception ?")) {

			var qCancel = new QueryHttp("Facturation/Retours_Fournisseurs/cancelBonReception.tmpl");
			qCancel.setParam('Bon_Id', orrf_bonRecId);
			qCancel.execute();

			showMessage("La r\u00E9ception a \u00E9t\u00E9 annul\u00E9e");

			orrf_chargerBon();
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function orrf_choisirMentions() {
  try {

  	var ok = true;

  	if (orrf_mode=="C") {
			ok = orrf_enregistrerBon(true);
		}

		if (ok) {
			var url = "chrome://opensi/content/facturation/user/commun/popup-mentionsDocument.xul";
	    window.openDialog(url,'','chrome,modal,centerscreen', "BRR", orrf_bonRecId, false);
		}

	} catch (e) {
  	recup_erreur(e);
  }
}


function orrf_initVersion() {
	try {

		orrf_aVersions.setParam("Bon_Id", orrf_bonRecId);
		orrf_aVersions.initTree();

	} catch (e) {
		recup_erreur(e);
	}
}


function orrf_selectLigneBR()  {
	try {

		if (orrf_aArticlesBR.isSelected()) {
			document.getElementById('orrf-nbPieces').value = orrf_aArticlesBR.getSelectedCellText('orrf-colNbPiecesBR');
			document.getElementById('orrf-quantite').value = orrf_aArticlesBR.getSelectedCellText('orrf-colQuantiteBR');
			document.getElementById('orrf-numLot').value = "";
			document.getElementById('orrf-datePeremption').value = "";
			document.getElementById('orrf-bEnlever').disabled = false;
			document.getElementById('orrf-bAjouter').disabled = true;
			document.getElementById('orrf-bConsultSerieLigne').disabled = false;
			orrf_aArticlesRF.clearSelection();

			if (orrf_etatBon=="V" && orrf_statutReception=="R") {
				orrf_aRangement.setParam("Ligne_Id", orrf_aArticlesBR.getSelectedCellText('orrf-colLigneIdBR'));
				orrf_aRangement.initTree();
				orrf_resetTransfertRangement();
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function orrf_selectLigneRF() {
	try {

		if (orrf_aArticlesRF.isSelected()) {
			document.getElementById('orrf-nbPieces').value = orrf_aArticlesRF.getSelectedCellText('orrf-colNbPiecesRF');
			document.getElementById('orrf-quantite').value = orrf_aArticlesRF.getSelectedCellText('orrf-colQuantiteRF');
			document.getElementById('orrf-numLot').value = "";
			document.getElementById('orrf-datePeremption').value = "";
			document.getElementById('orrf-bAjouter').disabled = false;
			document.getElementById('orrf-bEnlever').disabled = true;
			orrf_aArticlesBR.clearSelection();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function orrf_checkNumSerieLigne(ligneId, isSuiviSerie, quantite) {
	try {

		if (orrf_actSuiviSerie) {
			var qNbSerie = new QueryHttp("Facturation/Retours_Fournisseurs/getNbNumSerieLigneBR.tmpl");
			qNbSerie.setParam("Ligne_Id", ligneId);
			var resNS = qNbSerie.execute();
			var nb = parseIntBis(resNS.responseXML.documentElement.getAttribute("Nombre"));
			if ((isSuiviSerie && nb!=quantite) || nb>quantite) {
				var depotId = document.getElementById('orrf-depotReception').value;
				var url = "chrome://opensi/content/facturation/user/commun/popup-numSerie.xul";
		    window.openDialog(url,'','chrome,modal,centerscreen', "S", "BRR", ligneId, depotId);
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function orrf_consulterNumSerie()  {
	try {

		if (orrf_aArticlesBR.isSelected()) {
			var ligneId = orrf_aArticlesBR.getSelectedCellText('orrf-colLigneIdBR');
			var depotId = document.getElementById('orrf-depotReception').value;
			var url = "chrome://opensi/content/facturation/user/commun/popup-numSerie.xul";
    	window.openDialog(url,'','chrome,modal,centerscreen', (orrf_etatBon=="A" || orrf_statutReception=="C"?"C":"S"), "BRR", ligneId, depotId);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function orrf_checkNumLotLigne(numero, datePeremption, articleId, isSuiviLot, isSuiviDLC) {
	try {

		var ok = true;

		if (orrf_actSuiviLot && !isEmpty(articleId)) {

			if ((isSuiviLot || !isEmpty(datePeremption)) && isEmpty(numero)) {
				ok = false;
				showWarning("N\u00B0 Lot manquant");
			}
			else if (isSuiviDLC && isEmpty(datePeremption)) {
				ok = false;
				showWarning("Date de p\u00E9remption manquante");
			}
			else if (!isEmpty(datePeremption) && !isDate(datePeremption)) {
				ok = false;
				showWarning("Date de p\u00E9remption incorrecte");
			}
		}

		return ok;

	} catch (e) {
		recup_erreur(e);
	}
}


function orrf_pressOnNumLot(ev) {
	try {

		if (ev.keyCode==13 && orrf_aArticlesRF.isSelected()) {
			var articleId = orrf_aArticlesRF.getSelectedCellText('orrf-colArticleIdRF');
			var numero = document.getElementById("orrf-numLot").value;
			var depotId = document.getElementById('orrf-depotReception').value;

			var url = "chrome://opensi/content/facturation/user/tracabilite_articles/popup-rechercheLot.xul";
			window.openDialog(url,'','chrome,modal,centerscreen', orrf_retourRechercherLot, articleId, numero, depotId, null);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function orrf_retourRechercherLot(numero, datePeremption) {
	try {

		document.getElementById("orrf-numLot").value = numero;
		document.getElementById("orrf-datePeremption").value = datePeremption;

	} catch (e) {
		recup_erreur(e);
	}
}


function orrf_updateDLC() {
	try {

		if (orrf_aArticlesRF.isSelected()) {
			var numero = document.getElementById("orrf-numLot").value;
			var articleId = orrf_aArticlesRF.getSelectedCellText('orrf-colArticleIdRF');

			if (!isEmpty(numero) && !isEmpty(articleId)) {
				var qGetDLC = new QueryHttp("Facturation/Tracabilite/getDLCNumLot.tmpl");
				qGetDLC.setParam("Article_Id", articleId);
				qGetDLC.setParam("Numero", numero);
				var result = qGetDLC.execute();
				var datePeremption = result.responseXML.documentElement.getAttribute("Date_Peremption");
				if (!isEmpty(datePeremption)) {
					document.getElementById("orrf-datePeremption").value = datePeremption;
				}
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function orrf_pressOnNumSerie(ev) {
	try {

		if (ev.keyCode==13) {
			orrf_validerSaisieBySerie();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function orrf_validerSaisieBySerie(ligneId) {
	try {

		var listLigneRF = ligneId;

		if (listLigneRF==null) {
			listLigneRF = "";
			var nbLignes = orrf_aArticlesRF.nbLignes();
			for (i=0; i<nbLignes; i++) {
				if (parseFloat(orrf_aArticlesRF.getCellText(i, 'orrf-colQuantiteRF'))>0) {
					listLigneRF += orrf_aArticlesRF.getCellText(i, 'orrf-colLigneIdRF') +",";
				}
			}
		}

		var numSerie = document.getElementById("orrf-numSerie").value;

		if (!isEmpty(numSerie)) {

			var ok = true;
			if (orrf_mode=="C") {
				ok = orrf_enregistrerBon(true);
			}
			if (ok) {
				var qAjouterNumSerie = new QueryHttp('Facturation/Retours_Fournisseurs/addNumSerieBR.tmpl');
				qAjouterNumSerie.setParam("Bon_Id", orrf_bonRecId);
				qAjouterNumSerie.setParam("Num_Serie", numSerie);
				qAjouterNumSerie.setParam("List_Ligne_RF", listLigneRF);
				var result = qAjouterNumSerie.execute();

				var errors = new Errors(result);
				if (errors.hasNext()) {
					errors.show();
				}
				else {
					var conflit = (result.responseXML.documentElement.getAttribute("Conflit")=="true");
					if (conflit) {
						var listConflit = result.responseXML.documentElement.getAttribute("List_Conflit");
						var url = "chrome://opensi/content/facturation/user/retours_fournisseurs/popup-conflitNumSerieRF.xul";
			      window.openDialog(url,'','chrome,modal,centerscreen', listConflit, orrf_retourChoixConflit);
					}
					else {
						orrf_aArticlesRF.initTree();
						orrf_aArticlesBR.initTree();
						document.getElementById("orrf-numSerie").value = "";
					}
				}
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function orrf_retourChoixConflit(ligneId) {
	try {

		orrf_validerSaisieBySerie(ligneId);

	} catch (e) {
		recup_erreur(e);
	}
}


function orrf_pressOnCodeBarre(ev) {
	try {

		if (ev.keyCode==13) {
			orrf_validerSaisieByCodeBarre();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function orrf_validerSaisieByCodeBarre() {
	try {

		var listLigneRF = "";
		var nbLignes = orrf_aArticlesRF.nbLignes();
		for (i=0; i<nbLignes; i++) {
			if (parseFloat(orrf_aArticlesRF.getCellText(i, 'orrf-colQuantiteRF'))>0) {
				listLigneRF += orrf_aArticlesRF.getCellText(i, 'orrf-colLigneIdRF') +",";
			}
		}

		var codeBarre = document.getElementById("orrf-codeBarre").value;

		if (!isEmpty(codeBarre)) {

			var ok = true;
			if (orrf_mode=="C") {
				ok = orrf_enregistrerBon(true);
			}
			if (ok) {
				var qAjouterCodeBarre = new QueryHttp('Facturation/Retours_Fournisseurs/addCodeBarreBR.tmpl');
				qAjouterCodeBarre.setParam("Bon_Id", orrf_bonRecId);
				qAjouterCodeBarre.setParam("Code_Barre", codeBarre);
				qAjouterCodeBarre.setParam("List_Ligne_RF", listLigneRF);
				var result = qAjouterCodeBarre.execute();

				var errors = new Errors(result);

				if (errors.hasNext()) {
					errors.show();
				}
				else {
					orrf_aArticlesRF.initTree();
					orrf_aArticlesBR.initTree();
					document.getElementById("orrf-codeBarre").value = "";
				}
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function orrf_envoyerMail() {
	try {

		var url = "chrome://opensi/content/popup/popup-envoyerMail.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', "BRR", orrf_bonRecId);

	} catch (e) {
		recup_erreur(e);
	}
}


// RANGEMENT


function orrf_pressOnRangement() {
	try {

		if (orrf_aRangement.isSelected()) {
			document.getElementById("orrf-quantiteRG").value = orrf_aRangement.getSelectedCellText("orrf-colQuantiteRG");
			document.getElementById("orrf-emplacementInitRG").value = orrf_aRangement.getSelectedCellText("orrf-colCodeEmplacementRG");
			document.getElementById("orrf-bValiderRG").disabled = false;
			document.getElementById("orrf-codeEmplacementRG").disabled = false;
			document.getElementById("orrf-quantiteRG").disabled = false;
			document.getElementById("orrf-bRechercherEmplacementRG").disabled = false;
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function orrf_resetTransfertRangement() {
	try {

		document.getElementById("orrf-emplacementInitRG").value = "";
		document.getElementById("orrf-codeEmplacementRG").value = "";
		document.getElementById("orrf-quantiteRG").value = "";

		document.getElementById("orrf-bValiderRG").disabled = true;
		document.getElementById("orrf-codeEmplacementRG").disabled = true;
		document.getElementById("orrf-quantiteRG").disabled = true;
		document.getElementById("orrf-bRechercherEmplacementRG").disabled = true;

	} catch (e) {
		recup_erreur(e);
	}
}


function orrf_validerTransfertRangement() {
	try {

		if (orrf_aRangement.isSelected()) {
			var storeId = orrf_aRangement.getSelectedCellText("orrf-colStoreIdRG");
			var qteInit = orrf_aRangement.getSelectedCellText("orrf-colQuantiteRG");
			var emplacementInit = document.getElementById("orrf-emplacementInitRG").value;
			var codeEmplacement = document.getElementById("orrf-codeEmplacementRG").value;
			var quantite = document.getElementById("orrf-quantiteRG").value;

			if (isEmpty(codeEmplacement)) {
				showWarning("Emplacement incorrect");
			}
			else if (codeEmplacement==emplacementInit) {
				showWarning("Emplacement incorrect");
			}
			else if (!isPositive(quantite)) {
				showWarning("Quantit\u00E9 incorrecte");
			}
			else if (parseFloat(quantite)>parseFloat(qteInit)) {
				showWarning("Quantit\u00E9 incorrecte");
			}
			else {
				var emplacementId = orrf_getEmplacementId(codeEmplacement);

				if (isEmpty(emplacementId)) {
					showWarning("Emplacement inexistant");
				}
				else {
					var qTransfer = new QueryHttp("Facturation/Retours_Fournisseurs/transferStoreLigneBR.tmpl");
					qTransfer.setParam("Store_Id", storeId);
					qTransfer.setParam("Emplacement_Id", emplacementId);
					qTransfer.setParam("Quantite", quantite);

					var result = qTransfer.execute();

					var errors = new Errors(result);
					if (errors.hasNext()) {
						errors.show();
					}

					orrf_aRangement.initTree();
					orrf_resetTransfertRangement();
				}
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function orrf_getEmplacementId(codeEmplacement) {
	try {

		var qGet = new QueryHttp("Facturation/Emplacements/getEmplacementId.tmpl");
		qGet.setParam("Depot_Id", orrf_currentDepotId);
		qGet.setParam("Code_Emplacement", codeEmplacement);

		var result = qGet.execute();

		return result.responseXML.documentElement.getAttribute('Emplacement_Id');

	} catch (e) {
		recup_erreur(e);
	}
}


function orrf_rechercherEmplacement() {
	try {

		var reference = null;

		if (orrf_aArticlesBR.isSelected()) {
			reference = orrf_aArticlesBR.getSelectedCellText('orrf-colReferenceBR');
		}

		var url = "chrome://opensi/content/facturation/user/emplacements/popup-rechercheEmplacement.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', orrf_retourRechercherEmplacement, orrf_currentDepotId, reference);

	} catch (e) {
		recup_erreur(e);
	}
}


function orrf_retourRechercherEmplacement(codeEmplacement, emplacementId) {
	try {

  	document.getElementById('orrf-codeEmplacementRG').value = codeEmplacement;

	} catch (e) {
		recup_erreur(e);
	}
}


