/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

jsLoader.loadSubScript("chrome://opensi/content/libs/arbres.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/verif.js");


var aStocks = new Arbre('Facturation/Stocks/list-stockArticle.tmpl', 'aStocks');
var aEmplacements = new Arbre('Facturation/Articles/list-emplacementArticle.tmpl', 'listeEmplacementArticle');
var aNumerosSerie = new Arbre("Facturation/Stocks/liste-numerosSerie.tmpl", "liste_numero_serie");
var aNumerosLot = new Arbre("Facturation/Stocks/liste-numerosLot.tmpl", "listeNumLot");
var aDepots = new Arbre('ComboListe/combo-depotsStock.tmpl', 'depotTMS');

var qAjustementStock = new QueryHttp("Facturation/Stocks/ajustementStock.tmpl");
var qTransfertStock = new QueryHttp("Facturation/Stocks/transfertStock.tmpl");

var curDepotId;
var curArticleId;
var curEmplacementId = "";
var curEmplacementTo = "";
var precStocksIndex = "";
var actSuiviSerie;
var actSuiviLot;
var suiviSerie = false;
var suiviLot = false;
var gReadOnly;
var gActEmplacements;



function init() {
	try {

		var profil = getProfil();

		gReadOnly = profil.isReadOnlyGC_SIOStocks();

		document.getElementById('lblReadOnly').collapsed = !gReadOnly;

		var config = getConfig();

		actSuiviSerie = config.isActSuiviSerie();
		actSuiviLot = config.isActSuiviLot();
		gActEmplacements = config.isActEmplacements();

		document.getElementById("vboxNumSerie").collapsed = !actSuiviSerie;
		document.getElementById("vboxNumLot").collapsed = !actSuiviLot;
		document.getElementById("groupboxDetailArticle").collapsed = !(actSuiviSerie || actSuiviLot);
		
		if (!config.isActSerieDLC()) {
			document.getElementById("colDatePeremptionNS").setAttribute("hidden", true);
		}
		else {
			document.getElementById("boxDatePeremptionNS").collapsed = false;
		}

		document.getElementById("rowNumSerie").collapsed = gReadOnly;
		document.getElementById("rowNumLot").collapsed = gReadOnly;
		document.getElementById("boxAMS").collapsed = gReadOnly || !profil.isModifStockES();
		document.getElementById("boxTMS").collapsed = gReadOnly;

		document.getElementById("boxMultiEmp").collapsed = !gActEmplacements;
		document.getElementById("boxMonoEmp").collapsed = gActEmplacements;
		document.getElementById("rowCodeEmplacementAMS").collapsed = !gActEmplacements;
		document.getElementById("rowEmplacementFromTMS").collapsed = !gActEmplacements;
		document.getElementById("rowEmplacementToTMS").collapsed = !gActEmplacements;
		document.getElementById('bEnregistrerMono').collapsed = gReadOnly;

		initCriteres();

		var aMotifsAMS = new Arbre('ComboListe/combo-motifsMvtStock.tmpl', 'motifAMS');
		aMotifsAMS.initTree(initMotifAMS);

		var aMotifsTMS = new Arbre('ComboListe/combo-motifsMvtStock.tmpl', 'motifTMS');
		aMotifsTMS.initTree(initMotifTMS);

		if (!isEmpty(ParamValeur("Reference"))) {
			document.getElementById("refArticle").value = ParamValeur("Reference");
			rechercherReference();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function initCriteres() {
	try {

		document.getElementById('refArticle').value = "";

		aStocks.deleteTree();

		initIHM();

		document.getElementById('refArticle').focus();

	} catch (e) {
		recup_erreur(e);
	}
}


function initIHM() {
	try {

		document.getElementById('labelReference').value = "";
		document.getElementById('labelDesignation').value = "";

		unselectStockArticle();

	} catch (e) {
		recup_erreur(e);
	}
}


function unselectStockArticle() {
	try {

		document.getElementById('labelNomDepot').value = "";

		curEmplacementId = "";
		aEmplacements.deleteTree();
		aDepots.deleteTree();

		document.getElementById('codeEmplacementAMS').value = "";
		document.getElementById('emplacementFromTMS').value = "";
		document.getElementById('depotTMS').value = "";

		document.getElementById('bAjusterStock').disabled = true;
		document.getElementById('bTransfererStock').disabled = true;
		document.getElementById('bRechercherEmplacementTMS').disabled = true;

		document.getElementById('rowEmplacementEA').collapsed = true;
		document.getElementById('boxFleches').collapsed = true;
		document.getElementById('bEtiquetteEA').collapsed = true;

		document.getElementById('codeEmplacementMono').value = "";
		document.getElementById('codeEmplacementMono').disabled = true;
		document.getElementById('bEtiquetteMono').disabled = true;
		document.getElementById('bEnregistrerMono').disabled = true;

		if (actSuiviSerie) {
			aNumerosSerie.deleteTree();
			document.getElementById('hboxAlerteNumSerie').collapsed = true;
			document.getElementById("NouveauNumSerie").disabled = true;
			document.getElementById("ValiderNumSerie").disabled = true;
			document.getElementById("SupprimerNumSerie").disabled = true;
		}

		if (actSuiviLot) {
			aNumerosLot.deleteTree();
			document.getElementById('hboxAlerteNumLot').collapsed = true;
			document.getElementById("NouveauNumLot").disabled = true;
			document.getElementById("ValiderNumLot").disabled = true;
			document.getElementById("SupprimerNumLot").disabled = true;
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function initMotifAMS() {
	try {

		var nbMotifs = document.getElementById('motifAMS').itemCount;
		document.getElementById('motifAMS').selectedIndex = nbMotifs==2?1:0;

	} catch (e) {
		recup_erreur(e);
	}
}


function initMotifTMS() {
	try {

		var nbMotifs = document.getElementById('motifTMS').itemCount;
		document.getElementById('motifTMS').selectedIndex = nbMotifs==2?1:0;

	} catch (e) {
		recup_erreur(e);
	}
}


function listerStocks() {
	try {

		unselectStockArticle();

		aStocks.setParam("Article_Id", curArticleId);
		aStocks.initTree(initStocks);

	} catch (e) {
		recup_erreur(e);
	}
}


function initStocks() {
	try {

		if (!isEmpty(precStocksIndex)) {
			aStocks.select(precStocksIndex);
			precStocksIndex = "";
		}
		else {
			if (aStocks.nbLignes()==1) {
				aStocks.select(0);
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function reporterStockDepot() {
	try {

		if (aStocks.isSelected()) {
			curDepotId = aStocks.getSelectedCellText('colDepotId');
			document.getElementById('labelNomDepot').value = aStocks.getSelectedCellText('colIntitule');

			document.getElementById('codeEmplacementAMS').value = "";
			document.getElementById('emplacementFromTMS').value = "";
			curEmplacementId = "";

			document.getElementById('bAjusterStock').disabled = false;
			document.getElementById('bTransfererStock').disabled = gActEmplacements;

			chargerDepotTMS(curDepotId);

			document.getElementById('rowEmplacementEA').collapsed = gReadOnly;
			document.getElementById('boxFleches').collapsed = gReadOnly;
			document.getElementById('bEtiquetteEA').collapsed = false;

			if (gActEmplacements) {
				aEmplacements.setParam("Article_Id", curArticleId);
				aEmplacements.setParam("Depot_Id", curDepotId);
				aEmplacements.initTree(initEmplacements);

				nouveauEmplacement();
			}
			else {
				var qGet = new QueryHttp("Facturation/Articles/getCodeEmplacementPrincipal.tmpl");
				qGet.setParam("Depot_Id", curDepotId);
				qGet.setParam("Article_Id", curArticleId);

				var result = qGet.execute();

				document.getElementById('codeEmplacementMono').value = result.responseXML.documentElement.getAttribute('Code_Emplacement');
				document.getElementById('codeEmplacementMono').disabled = false;
				document.getElementById('bEtiquetteMono').disabled = false;
				document.getElementById('bEnregistrerMono').disabled = false;
			}

			if (actSuiviSerie) {
				aNumerosSerie.setParam('Article_Id', curArticleId);
				aNumerosSerie.setParam('Depot_Id', curDepotId);
				aNumerosSerie.initTree(retourInitNumerosSerie);
				nouveauNumSerie();
			}

			if (actSuiviLot) {
				aNumerosLot.setParam('Article_Id', curArticleId);
				aNumerosLot.setParam('Depot_Id', curDepotId);
				aNumerosLot.initTree(retourInitNumerosLot);
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function initEmplacements() {
	try {

		if (aEmplacements.nbLignes()==1) {
			aEmplacements.select(0);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function nouveauEmplacement() {
	try {

		document.getElementById("codeEmplacementEA").value = "";
		document.getElementById("seuilReassortEA").value = "0";
		document.getElementById("stockMaximumEA").value = "";
		document.getElementById("codeEmplacementEA").disabled = false;
		document.getElementById("bSupprimerEA").disabled = true;
		document.getElementById("bRechercherEmplacementEA").disabled = false;
		document.getElementById("seuilReassortEA").disabled = false;
		document.getElementById('bEtiquetteEA').disabled = true;
		document.getElementById('bFlecheHaut').disabled = true;
		document.getElementById('bFlecheBas').disabled = true;
		aEmplacements.clearSelection();

	} catch (e) {
		recup_erreur(e);
	}
}


function enregistrerEmplacement() {
	try {

		var codeEmplacement = document.getElementById("codeEmplacementEA").value;
		var seuilReassort = document.getElementById("seuilReassortEA").value;
		var stockMaximum = document.getElementById("stockMaximumEA").value;

		if (isEmpty(codeEmplacement)) {
			showWarning("Emplacement incorrect");
		}
		else if (isEmpty(seuilReassort) || !isPositiveOrNull(seuilReassort) || !checkDecimal(seuilReassort,3)) {
			showWarning("Seuil de r\u00E9assort incorrect");
		}
		else if (!isEmpty(stockMaximum) && (!isPositive(stockMaximum) || !checkDecimal(seuilReassort,3))) {
			showWarning("Stock maximum incorrect (>0)");
		}
		else {
			if (aEmplacements.isSelected()) {
				var empArtId = aEmplacements.getSelectedCellText("colEmpArtIdEA");

				var qSave = new QueryHttp("Facturation/Articles/updateEmplacementArticle.tmpl");
				qSave.setParam("Emp_Art_Id", empArtId);
				qSave.setParam("Seuil_Reassort", seuilReassort);
				qSave.setParam("Stock_Maximum", stockMaximum);

				var result = qSave.execute();

				var errors = new Errors(result);
				if (errors.hasNext()) {
					errors.show();
				}

				aEmplacements.initTree();
				nouveauEmplacement();
			}
			else {
				var emplacementId = getEmplacementId(codeEmplacement);

				if (isEmpty(emplacementId)) {
					if (window.confirm("L'emplacement n'existe pas, voulez-vous le cr\u00E9er ?")) {
						var url = "chrome://opensi/content/facturation/user/emplacements/popup-creationEmplacement.xul";
						window.openDialog(url,'','chrome,modal,centerscreen', affecterEmplacement, curDepotId, codeEmplacement);
					}
				}
				else {
					affecterEmplacement(emplacementId);
				}
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function affecterEmplacement(emplacementId) {
	try {

		var seuilReassort = document.getElementById("seuilReassortEA").value;
		var stockMaximum = document.getElementById("stockMaximumEA").value;

		var qAssign = new QueryHttp("Facturation/Articles/assignEmplacementArticle.tmpl");
		qAssign.setParam("Article_Id", curArticleId);
		qAssign.setParam("Emplacement_Id", emplacementId);
		qAssign.setParam("Seuil_Reassort", seuilReassort);
		qAssign.setParam("Stock_Maximum", stockMaximum);

		var result = qAssign.execute();

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}
		else {
			var usedBy = result.responseXML.documentElement.getAttribute("Used_By");
			if (!isEmpty(usedBy)) {
				showWarning("Attention cet emplacement est d\u00E9j\u00E0 utilis\u00E9 par un autre article (R\u00E9f: "+ usedBy +")");
			}
		}

		aEmplacements.initTree();
		nouveauEmplacement();

	} catch (e) {
		recup_erreur(e);
	}
}


function getEmplacementId(codeEmplacement) {
	try {

		var qGet = new QueryHttp("Facturation/Emplacements/getEmplacementId.tmpl");
		qGet.setParam("Depot_Id", curDepotId);
		qGet.setParam("Code_Emplacement", codeEmplacement);

		var result = qGet.execute();

		return result.responseXML.documentElement.getAttribute('Emplacement_Id');

	} catch (e) {
		recup_erreur(e);
	}
}


function supprimerEmplacement() {
	try {

		if (aEmplacements.isSelected()) {
			var empArtId = aEmplacements.getSelectedCellText("colEmpArtIdEA");

			var qDeactivate = new QueryHttp("Facturation/Articles/deactivateEmplacementArticle.tmpl");
			qDeactivate.setParam("Emp_Art_Id", empArtId);
			var result = qDeactivate.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}

			aEmplacements.initTree();
			nouveauEmplacement();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function pressOnEmplacements() {
	try {

		if (aEmplacements.isSelected()) {
			var idx = aEmplacements.getCurrentIndex();

			curEmplacementId = aEmplacements.getCellText(idx, "colEmplacementIdEA");

			document.getElementById('codeEmplacementAMS').value = aEmplacements.getCellText(idx, "colCodeEmplacementEA");
			document.getElementById('emplacementFromTMS').value = aEmplacements.getCellText(idx, "colCodeEmplacementEA");

			document.getElementById('bAjusterStock').disabled = false;
			document.getElementById('bTransfererStock').disabled = false;

			document.getElementById("codeEmplacementEA").value = aEmplacements.getCellText(idx, "colCodeEmplacementEA");
			document.getElementById("seuilReassortEA").value = aEmplacements.getCellText(idx, "colSeuilReassortEA");
			document.getElementById("stockMaximumEA").value = aEmplacements.getCellText(idx, "colStockMaximumEA");
			document.getElementById('bEtiquetteEA').disabled = isEmpty(aEmplacements.getCellText(idx, "colCodeEmplacementEA"));
			document.getElementById("bSupprimerEA").disabled = parseFloat(aEmplacements.getCellText(idx, "colStockReelEA"))!=0 || parseFloat(aEmplacements.getCellText(idx, "colStockPreparationEA"))!=0;
			document.getElementById("codeEmplacementEA").disabled = true;
			document.getElementById("bRechercherEmplacementEA").disabled = true;
			document.getElementById("seuilReassortEA").disabled = aEmplacements.getCellText(idx, "colTypeZoneEA")!="P";

			var firstIndex = 0;
			var lastIndex = aEmplacements.nbLignes()-1;

			document.getElementById('bFlecheHaut').disabled = (idx==firstIndex);
			document.getElementById('bFlecheBas').disabled = (idx==lastIndex);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function deplacerEmplacement(gap) {
	try {

		if (aEmplacements.isSelected()) {
			var empArtId = aEmplacements.getSelectedCellText("colEmpArtIdEA");

			var qMove = new QueryHttp("Facturation/Articles/moveEmplacementArticle.tmpl");
			qMove.setParam("Emp_Art_Id", empArtId);
			qMove.setParam("Gap", gap);
			qMove.execute();

			aEmplacements.initTree();
			nouveauEmplacement();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function editerEtiquetteEmplacement(emplacementId) {
	try {

		document.getElementById('pdfEtiquetteEmplacement').setAttribute("src", "");
		document.getElementById("bRetourEntreesSorties").collapsed = false;
		document.getElementById("deck").selectedIndex = 1;

		var qGenEtiq = new QueryHttp("Facturation/Emplacements/pdfEtiquetteEmplacement.tmpl");
		qGenEtiq.setParam("Emplacement_Id", emplacementId);

		var result = qGenEtiq.execute();

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}
		else {
			var page = getDirPdf() + result.responseXML.documentElement.getAttribute('FichierPDF');
			document.getElementById('pdfEtiquetteEmplacement').setAttribute("src", page);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function editerEtiquetteEmplacementMulti() {
	try {

		if (aEmplacements.isSelected()) {
			var emplacementId = aEmplacements.getSelectedCellText("colEmplacementIdEA");
			editerEtiquetteEmplacement(emplacementId);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function editerEtiquetteEmplacementMono() {
	try {

		var codeEmplacement = document.getElementById("codeEmplacementMono").value;

		var emplacementId = getEmplacementId(codeEmplacement);

		if (!isEmpty(emplacementId)) {
			editerEtiquetteEmplacement(emplacementId);
		}
		else {
			showWarning("L'emplacement n'existe pas. Vous devez d'abord l'enregistrer avant de pouvoir \u00E9diter l'\u00E9tiquette");
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function enregistrerEmplacementMono() {
	try {

		var codeEmplacement = document.getElementById("codeEmplacementMono").value;

		var qSave = new QueryHttp("Facturation/Articles/saveMonoEmplacement.tmpl");
		qSave.setParam("Article_Id", curArticleId);
		qSave.setParam("Depot_Id", curDepotId);
		qSave.setParam("Code_Emplacement", codeEmplacement);

		var result = qSave.execute();

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}
		else {
			var usedBy = result.responseXML.documentElement.getAttribute("Used_By");
			if (!isEmpty(usedBy)) {
				showWarning("Attention cet emplacement est d\u00E9j\u00E0 utilis\u00E9 par un autre article (R\u00E9f: "+ usedBy +")");
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function rechercherEmplacementEA() {
	try {

		var url = "chrome://opensi/content/facturation/user/emplacements/popup-rechercheEmplacement.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', retourRechercherEmplacementEA, curDepotId);

	} catch (e) {
		recup_erreur(e);
	}
}


function retourRechercherEmplacementEA(codeEmplacement, emplacementId) {
	try {

  	document.getElementById('codeEmplacementEA').value = codeEmplacement;

	} catch (e) {
		recup_erreur(e);
	}
}


function retourInitNumerosSerie() {
	try {

		if (actSuiviSerie && suiviSerie) {
			if (aNumerosSerie.nbLignes()!=aStocks.getSelectedCellText('colStockReel')) {
				document.getElementById('hboxAlerteNumSerie').collapsed = false;
			}
			else {
				document.getElementById('hboxAlerteNumSerie').collapsed = true;
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function retourInitNumerosLot() {
	try {

		if (actSuiviLot) {
			if (suiviLot) {
				var nbLots = 0;
				for (var i=0; i<aNumerosLot.nbLignes(); i++) {
					nbLots += parseFloat(aNumerosLot.getCellText(i, "lcColQuantite"));
				}
				if (nbLots!=aStocks.getSelectedCellText('colStockReel')) {
					document.getElementById('hboxAlerteNumLot').collapsed = false;
				}
				else {
					document.getElementById('hboxAlerteNumLot').collapsed = true;
				}
			}

			document.getElementById("NouveauNumLot").disabled = false;
			document.getElementById("ValiderNumLot").disabled = false;
			document.getElementById("SupprimerNumLot").disabled = true;

			nouveauNumLot();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function onKeyPressNumSerie(event) {
	try {

		if (event.keyCode==13) {
			validerNumSerie();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function pressOnDatePeremptionNS(ev) {
	try {

		if (ev.keyCode==13) {
			validerNumSerie();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function validerNumSerie() {
	try {

		if (aStocks.isSelected()) {
			var numero = document.getElementById('numSerie').value;
			var datePeremption = document.getElementById('datePeremptionNS').value;
			
			if (isEmpty(numero)) {
				showWarning("Le num\u00E9ro de s\u00E9rie est obligatoire");
			}
			else if (!isEmpty(datePeremption) && !isDate(datePeremption)) {
				showWarning("Date de p\u00E9remption incorrecte");
			}
			else {
				var creation = isEmpty(document.getElementById('serieId').value);				
				var quantiteReel = aStocks.getSelectedCellText('colStockReel');
				var nbSeries = aNumerosSerie.nbLignes();

				if (creation && nbSeries==quantiteReel) {
					showWarning("Nombre de num\u00E9ros de s\u00E9rie d\u00E9j\u00E0 \u00E9gal au stock r\u00E9el");
				}
				else if (creation && nbSeries>quantiteReel) {
					showWarning("Nombre de num\u00E9ros de s\u00E9rie d\u00E9j\u00E0 sup\u00E9rieur au stock r\u00E9el");
				}
				else {
					var qAdd = new QueryHttp("Facturation/Stocks/createNumeroSerie.tmpl");
					qAdd.setParam("Article_Id", curArticleId);
					qAdd.setParam("Depot_Id", curDepotId);
					qAdd.setParam("Numero_Serie", numero);
					qAdd.setParam("Date_Peremption", datePeremption);
					var result = qAdd.execute();

					var errors = new Errors(result);
					if (errors.hasNext()) {
						errors.show();
					}
				}
				
				nouveauNumSerie();
				aNumerosSerie.initTree(retourInitNumerosSerie);
			}
		}
		else {
			showWarning("Veuillez s\u00E9lectionner un d\u00E9p\u00F4t");
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function supprimerNumSerie() {
	try {

		var qDelete = new QueryHttp("Facturation/Stocks/deleteNumeroSerie.tmpl");
		qDelete.setParam("Serie_Id", document.getElementById('serieId').value);
		var result = qDelete.execute();

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}

		nouveauNumSerie();
		aNumerosSerie.initTree(retourInitNumerosSerie);

	} catch (e) {
    recup_erreur(e);
  }
}


function nouveauNumSerie() {
	try {

		document.getElementById('serieId').value = "";
		document.getElementById('numSerie').value = "";		
		document.getElementById('datePeremptionNS').value = "";
		document.getElementById('numSerie').disabled = false;		
		document.getElementById("NouveauNumSerie").disabled = false;
		document.getElementById("ValiderNumSerie").disabled = false;
		document.getElementById("SupprimerNumSerie").disabled = true;

	} catch (e) {
    recup_erreur(e);
  }
}


function selectOnListeNumSerie() {
	try {

		if (aNumerosSerie.isSelected()) {
			var i = aNumerosSerie.getCurrentIndex();
			document.getElementById('serieId').value = aNumerosSerie.getCellText(i, "lcColSerieId");
			document.getElementById('numSerie').value = aNumerosSerie.getCellText(i, "lcColNumSerie");
			document.getElementById('datePeremptionNS').value = aNumerosSerie.getCellText(i, "colDatePeremptionNS");
			document.getElementById('numSerie').disabled = true;		
			document.getElementById("NouveauNumSerie").disabled = false;
			document.getElementById("ValiderNumSerie").disabled = false;
			document.getElementById("SupprimerNumSerie").disabled = false;
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function validerNumLot() {
	try {

		var numeroLot = document.getElementById('numeroLot').value;
		var quantite = document.getElementById('quantiteLot').value;
		var datePeremption = document.getElementById('datePeremption').value;

		if (isEmpty(numeroLot)) {
			showWarning("Num\u00E9ro de lot incorrect");
		}
		else if (!isEmpty(datePeremption) && !isDate(datePeremption)) {
			showWarning("Date de p\u00E9remption incorrecte");
		}
		else if (!isPositiveOrNull(quantite)) {
			showWarning("Quantit\u00E9 incorrecte");
		}
		else {
			var qAdjustQteStock = new QueryHttp("Facturation/Stocks/adjustQteStockNumLot.tmpl");

			qAdjustQteStock.setParam("Article_Id", curArticleId);
			qAdjustQteStock.setParam("Depot_Id", curDepotId);
			qAdjustQteStock.setParam("Num_Lot", numeroLot);
			qAdjustQteStock.setParam("Date_Peremption", datePeremption);
			qAdjustQteStock.setParam("Quantite", quantite);

			var result = qAdjustQteStock.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}

			aNumerosLot.initTree(retourInitNumerosLot);
			nouveauNumLot();
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function supprimerNumLot() {
	try {

		var numeroLot = document.getElementById('numeroLot').value;

		if (!isEmpty(numeroLot)) {
			var qAdjustQteStock = new QueryHttp("Facturation/Stocks/adjustQteStockNumLot.tmpl");

			qAdjustQteStock.setParam("Article_Id", curArticleId);
			qAdjustQteStock.setParam("Depot_Id", curDepotId);
			qAdjustQteStock.setParam("Num_Lot", numeroLot);
			qAdjustQteStock.setParam("Date_Peremption", "");
			qAdjustQteStock.setParam("Quantite", 0);

			var result = qAdjustQteStock.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
		}

		aNumerosLot.initTree(retourInitNumerosLot);
		nouveauNumLot();

	} catch (e) {
    recup_erreur(e);
  }
}


function nouveauNumLot() {
	try {

		document.getElementById('numeroLot').value = "";
		document.getElementById('quantiteLot').value = "";
		document.getElementById('datePeremption').value = "";
		document.getElementById("NouveauNumLot").disabled = false;
		document.getElementById("ValiderNumLot").disabled = false;
		document.getElementById("SupprimerNumLot").disabled = true;
		document.getElementById("quantiteLot").disabled = false;
		document.getElementById("numeroLot").disabled = false;
		document.getElementById('numeroLot').select();

	} catch (e) {
    recup_erreur(e);
  }
}


function selectOnListeNumLot() {
	try {

		if (aNumerosLot.isSelected()) {
			var i = aNumerosLot.getCurrentIndex();
			document.getElementById('numeroLot').value = aNumerosLot.getCellText(i, "lcColNumLot");
			document.getElementById('quantiteLot').value = aNumerosLot.getCellText(i, "lcColQuantite");
			document.getElementById('datePeremption').value = aNumerosLot.getCellText(i, "lcColDatePeremption");
			document.getElementById("NouveauNumLot").disabled = false;
			document.getElementById("ValiderNumLot").disabled = false;
			document.getElementById("SupprimerNumLot").disabled = false;
			document.getElementById("quantiteLot").disabled = false;
			document.getElementById("numeroLot").disabled = true;
			document.getElementById('quantiteLot').select();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function onKeyPressQuantiteLot(event) {
	try {

		if (event.keyCode==13) {
			validerNumLot();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function onKeyPressDatePeremption(event) {
	try {

		if (event.keyCode==13) {
			validerNumLot();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function ajusterStock() {
	try {

		if (aStocks.isSelected() && (!gActEmplacements || aEmplacements.isSelected() || window.confirm("Confirmez-vous l'ajustement de stock sur un emplacement non localis\u00E9 ?"))) {

			var actionMvt = document.getElementById("actionAMS").value;
			var quantiteAjustement = document.getElementById("quantiteAMS").value;
			var qteReelTot = aStocks.getSelectedCellText('colStockReel');
			var qteReelEmp = gActEmplacements?(aEmplacements.isSelected()?aEmplacements.getSelectedCellText('colStockReelEA'):0):qteReelTot;
			var nbSeries = suiviSerie?aNumerosSerie.nbLignes():0;
			var motifId = document.getElementById("motifAMS").value;

			if (suiviSerie && nbSeries!=qteReelTot && qteReelTot>=0) {
				showWarning("Vous devez d'abord avoir un nombre de num\u00E9ros de s\u00E9rie correct avant de pouvoir modifier le stock !");
			}
			else if (isEmpty(quantiteAjustement) || !isPositiveOrNull(quantiteAjustement) || !checkNumber(quantiteAjustement,10,3)) {
				showWarning("Quantit\u00E9 incorrecte !");
			}
			else if (actionMvt=="A" && parseFloat(quantiteAjustement)==parseFloat(qteReelEmp)) {
				showWarning("Impossible d'ajuster le stock a la m\u00EAme valeur !");
			}
			else if (actionMvt=="D" && !isPositive(quantiteAjustement)) {
				showWarning("Impossible de d\u00E9cr\u00E9menter une quantit\u00E9 de 0 !");
			}
			else if (actionMvt=="I" && !isPositive(quantiteAjustement)) {
				showWarning("Impossible d'incr\u00E9menter une quantit\u00E9 de 0 !");
			}
			else if (actionMvt=="D" && parseFloat(quantiteAjustement)>parseFloat(qteReelEmp)) {
				showWarning("Impossible de d\u00E9cr\u00E9menter cette quantit\u00E9 !");
			}
			else if (isEmpty(motifId)) {
				showWarning("Veuillez s\u00E9lectionner un motif de mouvement de stock");
			}
			else {
				document.getElementById('bAjusterStock').disabled = true;

				var ok = true;
				if ((actionMvt=="A" && parseFloat(quantiteAjustement) > parseFloat(qteReelEmp)) || actionMvt=="I") {
					var qCheckCUMP = new QueryHttp("Facturation/Stocks/existCUMP.tmpl");
					qCheckCUMP.setParam('Article_Id', curArticleId);
					var result = qCheckCUMP.execute();
					if (result.responseXML.documentElement.getAttribute("Exist")=="false") {
						ok = false;
						var url = "chrome://opensi/content/facturation/user/stocks/popup-creerCUMP.xul";
						window.openDialog(url,'','chrome,modal,centerscreen', majStock);
					}
				}
				if (ok) { majStock(""); }
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function majStock(valUnitaire) {
	try {

		var actionMvt = document.getElementById("actionAMS").value;
		var quantiteAjustement = document.getElementById("quantiteAMS").value;
		var motifId = document.getElementById("motifAMS").value;
		var qteReelEmp = 0;
		if (!gActEmplacements) {
			qteReelEmp = aStocks.getSelectedCellText('colStockReel');
		}
		else if (aEmplacements.isSelected()) {
			qteReelEmp = aEmplacements.getSelectedCellText('colStockReelEA');
		}
		var commentaire = document.getElementById("commentaireAMS").value;

		if (gActEmplacements) {
			qAjustementStock.setParam('Emplacement_Id', curEmplacementId);
		}
		qAjustementStock.setParam('Depot_Id', curDepotId);
		qAjustementStock.setParam('Article_Id', curArticleId);
		qAjustementStock.setParam('ActionStock', actionMvt);
		qAjustementStock.setParam('Ajustement', quantiteAjustement);
		qAjustementStock.setParam('Motif_Id', motifId);
		qAjustementStock.setParam('Valeur_Unitaire', valUnitaire);
		qAjustementStock.setParam('Commentaire', commentaire);

		if (suiviSerie) {
			var quantiteDiff = quantiteAjustement;
			var actionMvtSerie = actionMvt;
			if (actionMvt=="A" && parseFloat(quantiteAjustement) > parseFloat(qteReelEmp)) {
				quantiteDiff = parseFloat(quantiteAjustement) - parseFloat(qteReelEmp);
				actionMvtSerie = "I";
			}
			else if (actionMvt=="A" && parseFloat(quantiteAjustement) < parseFloat(qteReelEmp)) {
				quantiteDiff = parseFloat(qteReelEmp) - parseFloat(quantiteAjustement);
				actionMvtSerie = "D";
			}
			var url = "chrome://opensi/content/facturation/user/commun/popup-numSerieDirect.xul";
			window.openDialog(url,'','chrome,modal,centerscreen', majStockFin, actionMvtSerie, curArticleId, curDepotId, quantiteDiff);
		}
		else {
			qAjustementStock.setParam('List_Serie_Id', "");
			var result = qAjustementStock.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}

			document.getElementById("quantiteAMS").value = "";
			document.getElementById("commentaireAMS").value = "";

			precStocksIndex = aStocks.getCurrentIndex();
			listerStocks();
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function majStockFin(listeSeries) {
	try {

		qAjustementStock.setParam('List_Serie_Id', listeSeries.toString());
	  var result = qAjustementStock.execute();

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}

	  document.getElementById("quantiteAMS").value = "";
		document.getElementById("commentaireAMS").value = "";

		precStocksIndex = aStocks.getCurrentIndex();
		listerStocks();

	} catch (e) {
    recup_erreur(e);
  }
}


function transfererStock() {
	try {

		if (aStocks.isSelected() && (!gActEmplacements || aEmplacements.isSelected())) {
			var quantite = document.getElementById("quantiteTMS").value;
			var motifId = document.getElementById("motifTMS").value;
			var commentaire = document.getElementById("commentaireTMS").value;
			var qteReelTot = aStocks.getSelectedCellText('colStockReel');
			var qteReelEmp = gActEmplacements?aEmplacements.getSelectedCellText('colStockReelEA'):qteReelTot;
			var depotTo = document.getElementById("depotTMS").value;
			var nbSeries = suiviSerie?aNumerosSerie.nbLignes():0;

			if (suiviSerie && nbSeries!=qteReelTot) {
				showWarning("Vous devez d'abord avoir un nombre de num\u00E9ros de s\u00E9rie correct avant de pouvoir modifier le stock !");
			}
			else if (isEmpty(quantite) || !isPositive(quantite) || !checkNumber(quantite,10,3)) {
				showWarning("Quantit\u00E9 incorrecte !");
			}
			else if (parseFloat(quantite)>parseFloat(qteReelEmp)) {
				showWarning("Impossible de transf\u00E9rer cette quantit\u00E9 !");
			}
			else if (gActEmplacements && !isEmpty(curEmplacementTo) && curEmplacementTo==curEmplacementId) {
				showWarning("Emplacement de destination incorrect");
			}
			else if (isEmpty(depotTo)) {
				showWarning("Veuillez s\u00E9lectionner un d\u00E9p\u00F4t de destination");
			}
			else if (isEmpty(motifId)) {
				showWarning("Veuillez s\u00E9lectionner un motif de mouvement de stock");
			}
			else if (!gActEmplacements || !isEmpty(curEmplacementTo) || window.confirm("Confirmez-vous le transfert vers un emplacement non localis\u00E9 ?")) {

				document.getElementById('bTransfererStock').disabled = true;

				if (gActEmplacements) {
					qTransfertStock.setParam('Emplacement_From', curEmplacementId);
					qTransfertStock.setParam('Emplacement_To', curEmplacementTo);
				}
				else {
					qTransfertStock.setParam('Depot_From', curDepotId);
				}
				qTransfertStock.setParam('Depot_To', depotTo);
				qTransfertStock.setParam('Article_Id', curArticleId);
				qTransfertStock.setParam('Quantite', quantite);
				qTransfertStock.setParam('Motif_Id', motifId);
				qTransfertStock.setParam('Commentaire', commentaire);

				if (suiviSerie) {
					var url = "chrome://opensi/content/facturation/user/commun/popup-numSerieDirect.xul";
					window.openDialog(url,'','chrome,modal,centerscreen', transfertStockFin, "T", curArticleId, curDepotId, quantite);
				}
				else {
					qTransfertStock.setParam('List_Serie_Id', "");
					var result = qTransfertStock.execute();
					var errors = new Errors(result);
					if (errors.hasNext()) {
						errors.show();
					}
					document.getElementById("emplacementToTMS").value = "";
					curEmplacementTo = "";
					document.getElementById("quantiteTMS").value = "";
					document.getElementById("commentaireTMS").value = "";

					precStocksIndex = aStocks.getCurrentIndex();
					listerStocks();
				}
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function transfertStockFin(listeSeries) {
	try {

		qTransfertStock.setParam('List_Serie_Id', listeSeries.toString());
		var result = qTransfertStock.execute();

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}

		document.getElementById("emplacementToTMS").value = "";
		curEmplacementTo = "";
		document.getElementById("quantiteTMS").value = "";
		document.getElementById("commentaireTMS").value = "";

		precStocksIndex = aStocks.getCurrentIndex();
		listerStocks();

	} catch (e) {
    recup_erreur(e);
  }
}


function pressOnCritere(ev) {
	try {

		if (ev.keyCode==13) {
			rechercherReference();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function chargerDepotTMS() {
	try {

		aDepots.clearSelection();
		if (!gActEmplacements) {
			aDepots.setParam("Exclusion", curDepotId);
		}
		aDepots.initTree(initDepotTMS);

	} catch (e) {
		recup_erreur(e);
	}
}


function initDepotTMS() {
	try {

		var nbDepots = document.getElementById('depotTMS').itemCount;
		document.getElementById('depotTMS').selectedIndex = nbDepots==2?1:0;
		pressOnDepotTMS();

	} catch (e) {
		recup_erreur(e);
	}
}


function pressOnDepotTMS() {
	try {

		document.getElementById('emplacementToTMS').value = "";
		curEmplacementTo = "";

		var depotTMS = document.getElementById('depotTMS').value;
		if (!isEmpty(depotTMS)) {
			document.getElementById('bRechercherEmplacementTMS').disabled = false;
		}
		else {
			document.getElementById('bRechercherEmplacementTMS').disabled = true;
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function rechercherStock(reference) {
	try {

		var url = "chrome://opensi/content/facturation/user/articles/popup-rechercheArticle.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', retourRechercherStock, null, reference, null, true);

	} catch (e) {
		recup_erreur(e);
	}
}


function retourRechercherStock(reference, articleId) {
	try {

		document.getElementById('refArticle').value = reference;
		chargerArticle(articleId);

	} catch (e) {
		recup_erreur(e);
	}
}


function rechercherReference() {
	try {

		var reference = document.getElementById('refArticle').value;

		var qSearch = new QueryHttp("Facturation/Articles/searchReference.tmpl");
		qSearch.setParam("Reference", reference);
		qSearch.setParam("No_Forfait", true);
		var result = qSearch.execute();

		var articleId = result.responseXML.documentElement.getAttribute("Article_Id");
		if (!isEmpty(articleId)) {
			document.getElementById('refArticle').value = result.responseXML.documentElement.getAttribute("Reference");
			chargerArticle(articleId);
		}
		else {
			rechercherStock(reference);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function rechercherEmplacementTMS() {
	try {

		var depotTo = document.getElementById("depotTMS").value;

		var url = "chrome://opensi/content/facturation/user/emplacements/popup-rechercheEmplacement.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', retourRechercherEmplacementTMS, depotTo);

	} catch (e) {
		recup_erreur(e);
	}
}


function retourRechercherEmplacementTMS(codeEmplacement, emplacementId) {
	try {

  	document.getElementById('emplacementToTMS').value = codeEmplacement;
		curEmplacementTo = emplacementId;

	} catch (e) {
		recup_erreur(e);
	}
}


function chargerArticle(articleId) {
	try {

		curArticleId = articleId;

		document.getElementById('labelReference').value = document.getElementById('refArticle').value;

		var qDesignation = new QueryHttp("Facturation/Articles/getDesignation.tmpl");
		qDesignation.setParam("Article_Id", articleId);
		var result = qDesignation.execute();
		document.getElementById('labelDesignation').value = result.responseXML.documentElement.getAttribute("Designation");

		if (actSuiviLot) {
			var qSuiviLotDLC = new QueryHttp("Facturation/Articles/getSuiviLotDLC.tmpl");
			qSuiviLotDLC.setParam("Article_Id", articleId);
			result = qSuiviLotDLC.execute();
			suiviLot = (result.responseXML.documentElement.getAttribute("Suivi_Lot")=="true");
		}

		if (actSuiviSerie) {
			var qSuiviSerie = new QueryHttp("Facturation/Articles/getSuiviSerie.tmpl");
			qSuiviSerie.setParam("Article_Id", articleId);
			result = qSuiviSerie.execute();
			suiviSerie = (result.responseXML.documentElement.getAttribute("Suivi_Serie")=="true");
		}

		listerStocks();

	} catch (e) {
		recup_erreur(e);
	}
}


function retourMenuPrincipal() {
	try {

		window.location = "chrome://opensi/content/facturation/user/menu_principal.xul";

	} catch (e) {
		recup_erreur(e);
	}
}


function retourEntreesSorties() {
	try {

		document.getElementById("pdfEtiquetteEmplacement").setAttribute("src", "");
		document.getElementById("deck").selectedIndex = 0;
		document.getElementById("bRetourEntreesSorties").collapsed = true;

	} catch (e) {
		recup_erreur(e);
	}
}

