/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

jsLoader.loadSubScript("chrome://opensi/content/libs/arbres.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/verif.js");


var aFamille1 = new Arbre('ComboListe/combo-famillesArticle.tmpl', 'Famille_1');
var aFamille2 = new Arbre('ComboListe/combo-famillesArticle.tmpl', 'Famille_2');
var aFamille3 = new Arbre('ComboListe/combo-famillesArticle.tmpl', 'Famille_3');
var aMarques = new Arbre('ComboListe/combo-marquesArticle.tmpl', 'Marque');
var aDepots = new Arbre('ComboListe/combo-depotsStock.tmpl', 'affichageDepot');
var aReglesDepots = new Arbre("Facturation/Stocks/list-depotsRegleSeuilsStock.tmpl", "listRegleDepots");
var aRegles = new Arbre('Facturation/Stocks/list-ReglesSeuilsStock.tmpl', 'listeRegles');
var aRuns = new Arbre('Facturation/Stocks/list-RunsSeuilsStock.tmpl', 'listeRuns');
var aLignesRun = new Arbre('Facturation/Stocks/list-LignesRunSeuilsStock.tmpl', 'listeLignesRun');
var qListLRSS = new QueryHttp("Facturation/Stocks/getDataListLRSS.tmpl");

var pageCourante;
var nbPages;

var i = 0;
var firstIndex = 0;
var lastIndex = 0;

var regleId = "";
var runId = "";
var chargerFamille1 = "";
var chargerFamille2 = "";
var chargerFamille3 = "";



function init() {
	try {

		aMarques.initTree();
		aDepots.initTree();
		aRuns.initTree();
		aRegles.initTree(nouvelleRegle);

		document.getElementById('pageDeb').value = 1;
		document.getElementById('pageFin').value = 1;
		document.getElementById('bPrec').disabled = true;
		document.getElementById('bSuiv').disabled = true;

		pageCourante = 1;
		nbPages = 1;

	} catch (e) {
		recup_erreur(e);
	}
}

function nouvelleRegle() {
	try {

		aRegles.clearSelection();

		document.getElementById('bNouvelleRegle').collapsed = true;
		document.getElementById('bSupprimerRegle').collapsed = true;

		document.getElementById('Intitule').value = "";
		document.getElementById('Famille_1').value = "";
		document.getElementById('Famille_2').value = "";
		document.getElementById('Famille_3').value = "";
		document.getElementById('Marque').value = "";
		document.getElementById('Classe_ABC').value = "";
		document.getElementById('typeArticle').value = "";
		document.getElementById('methodeSecurite').value = "N";
		document.getElementById('pourcentageSecu').value = "";
		document.getElementById('securiteMin').value = 0;
		document.getElementById('rowPourcentage').collapsed = true;
		document.getElementById('rowSecuriteMin').collapsed = true;

		document.getElementById('Reference_Fournisseur').value = "";
		document.getElementById('nReference').value = "M";
		document.getElementById('nReferenceMois').value = "";
		document.getElementById('nReferenceJours').value = "";
		document.getElementById('nReferencePeriodeDebut').value = "";
		document.getElementById('nReferencePeriodeFin').value = "";
		document.getElementById('nReferenceMoinsUnPrecedenteRadio').value = "P";
		document.getElementById('nReassort').value = "M";
		document.getElementById('nReassortMois').value = "";
		document.getElementById('nReassortJours').value = "";
		document.getElementById('alerteEvolution').value = "";
		document.getElementById('actif').checked = true;
		document.getElementById('bFlecheHaut').disabled = true;
		document.getElementById('bFlecheBas').disabled = true;

		regleId = "";
		chargerFamille1 = "";
		chargerFamille2 = "";
		chargerFamille3 = "";
		chargerFamilles1();
		aReglesDepots.setParam("Regle_Id",regleId);
		aReglesDepots.initTree();
		aLignesRun.deleteTree();
		checkNReference();
		checkNReassort();


	} catch (e) {
    recup_erreur(e);
  }
}


function chargerRegle() {
	try {

		if (aRegles.isSelected()) {
			document.getElementById('bNouvelleRegle').collapsed = false;
			document.getElementById('bSupprimerRegle').collapsed = false;

			regleId = aRegles.getSelectedCellText('colRegleId');

			var qLoad = new QueryHttp("Facturation/Stocks/getRegleSeuilsStock.tmpl");
			qLoad.setParam('Regle_Id', regleId);
			var result = qLoad.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				var contenu = result.responseXML.documentElement;
				document.getElementById('Intitule').value = contenu.getAttribute("Intitule");
				chargerFamille1 = contenu.getAttribute("Famille_1");
				chargerFamille2 = contenu.getAttribute("Famille_2");
				chargerFamille3 = contenu.getAttribute("Famille_3");
				chargerFamilles1();
				document.getElementById('Marque').value = contenu.getAttribute("Marque_Id");
				document.getElementById('Classe_ABC').value = contenu.getAttribute("Classe_ABC");
				document.getElementById('typeArticle').value = contenu.getAttribute("Type_Article");
				document.getElementById('methodeSecurite').value = contenu.getAttribute("Methode_Securite");
				document.getElementById('rowPourcentage').collapsed = document.getElementById('methodeSecurite').value!="P";
				document.getElementById('pourcentageSecu').value = contenu.getAttribute("Pourc_Minimum");
				document.getElementById('rowSecuriteMin').collapsed = document.getElementById('methodeSecurite').value=="N";
				document.getElementById('securiteMin').value = contenu.getAttribute("Securite_Min");
				document.getElementById('Reference_Fournisseur').value = contenu.getAttribute("Fournisseur");
				document.getElementById('nReference').value = contenu.getAttribute("Type_PeriodeN");
				document.getElementById('nReference1').value = contenu.getAttribute("Type_PeriodeN1");
				document.getElementById('nReassort').value = contenu.getAttribute("Type_PeriodeR");
				document.getElementById('alerteEvolution').value = contenu.getAttribute("Limite_Evol")=="0.0"?"":contenu.getAttribute("Limite_Evol");
				document.getElementById('actif').checked = contenu.getAttribute("Actif")=="true";

				document.getElementById('nReferencePeriodeDebut').value = "";
				document.getElementById('nReferencePeriodeFin').value = "";
				document.getElementById('nReferenceJours').value = "";
				document.getElementById('nReferenceMois').value = "";
				document.getElementById('nReassortJours').value = "";
				document.getElementById('nReassortMois').value = "";
				if (document.getElementById('nReference').value=="P") {
					document.getElementById('nReferencePeriodeDebut').value = contenu.getAttribute("Periode_Deb");
					document.getElementById('nReferencePeriodeFin').value = contenu.getAttribute("Periode_Fin");
				}
				else if (document.getElementById('nReference').value=="J") {
					document.getElementById('nReferenceJours').value = contenu.getAttribute("Duree_Reference");
				}
				else if (document.getElementById('nReference').value=="M") {
					document.getElementById('nReferenceMois').value = contenu.getAttribute("Duree_Reference");
				}

				if (document.getElementById('nReassort').value=="J") {
					document.getElementById('nReassortJours').value = contenu.getAttribute("Duree_Reassort");
				}
				else if (document.getElementById('nReassort').value=="M") {
					document.getElementById('nReassortMois').value = contenu.getAttribute("Duree_Reassort");
				}
				checkNReference();
				checkNReassort();

				aReglesDepots.setParam("Regle_Id",regleId);
				aReglesDepots.initTree();

				i = aRegles.getCurrentIndex();
				firstIndex = 0;
				lastIndex = aRegles.nbLignes()-1;
				document.getElementById('bFlecheHaut').disabled = aRegles.isSorted() || (i==firstIndex);
				document.getElementById('bFlecheBas').disabled = aRegles.isSorted() || (i==lastIndex);
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function changeOrdre() {
	try {

		if (aRegles.isSelected()) {
			document.getElementById('bFlecheHaut').disabled = aRegles.isSorted() || (i==firstIndex);
			document.getElementById('bFlecheBas').disabled = aRegles.isSorted() || (i==lastIndex);
			nouvelleRegle();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function chargerFamilles1() {
	try {

		aFamille1.setParam("Selection", chargerFamille1);
		aFamille1.initTree(initFamille1);

	} catch (e) {
		recup_erreur(e);
	}
}


function initFamille1() {
	try {

		document.getElementById('Famille_1').value = chargerFamille1;
		chargerFamilles2();

	} catch (e) {
		recup_erreur(e);
	}
}


function chargerFamilles2() {
	try {

		var famille1 = document.getElementById('Famille_1').value;

		if (isEmpty(famille1)) {
			aFamille2.deleteTree();
			initFamille2();
		}
		else {
			aFamille2.setParam('Parent_Id', famille1);
			aFamille2.setParam("Selection", chargerFamille2);
			aFamille2.initTree(initFamille2);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function initFamille2() {
	try {

		document.getElementById('Famille_2').value = chargerFamille2;
		chargerFamilles3();

	} catch (e) {
		recup_erreur(e);
	}
}


function chargerFamilles3() {
	try {

		var famille2 = document.getElementById('Famille_2').value;

		if (isEmpty(famille2)) {
			aFamille3.deleteTree();
			initFamille3();
		}
		else {
			aFamille3.setParam('Parent_Id', famille2);
			aFamille3.setParam("Selection", chargerFamille3);
			aFamille3.initTree(initFamille3);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function initFamille3() {
	try {

		document.getElementById('Famille_3').value = chargerFamille3;

	} catch (e) {
		recup_erreur(e);
	}
}


function pressOnFamille1() {
	try {

		chargerFamilles2();

	} catch (e) {
		recup_erreur(e);
	}
}


function pressOnFamille2() {
	try {

		chargerFamilles3();

	} catch (e) {
		recup_erreur(e);
	}
}

function checkNReference() {
	try {

		if (document.getElementById('nReference').value=="P") {
			document.getElementById('nReferencePeriodeDebut').disabled=false;
			document.getElementById('nReferencePeriodeFin').disabled=false;
			document.getElementById('nReferenceJours').disabled=true;
			document.getElementById('nReferenceMois').disabled=true;
		}
		else if (document.getElementById('nReference').value=="J") {
			document.getElementById('nReferencePeriodeDebut').disabled=true;
			document.getElementById('nReferencePeriodeFin').disabled=true;
			document.getElementById('nReferenceJours').disabled=false;
			document.getElementById('nReferenceMois').disabled=true;
		}
		else if (document.getElementById('nReference').value=="M") {
			document.getElementById('nReferencePeriodeDebut').disabled=true;
			document.getElementById('nReferencePeriodeFin').disabled=true;
			document.getElementById('nReferenceJours').disabled=true;
			document.getElementById('nReferenceMois').disabled=false;
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function checkNReassort() {
	try {

		if (document.getElementById('nReassort').value=="J") {
			document.getElementById('nReassortJours').disabled=false;
			document.getElementById('nReassortMois').disabled=true;
		}
		else if (document.getElementById('nReassort').value=="M") {
			document.getElementById('nReassortJours').disabled=true;
			document.getElementById('nReassortMois').disabled=false;
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function changeMethodeSecurite() {
	try {

		var methodeSecurite = document.getElementById('methodeSecurite').value;
		document.getElementById('rowPourcentage').collapsed = methodeSecurite!="P";
		document.getElementById('rowSecuriteMin').collapsed = methodeSecurite=="N";

	} catch (e) {
		recup_erreur(e);
	}
}

function enregistrerRegle() {
	try {

		var methodeSecurite = document.getElementById('methodeSecurite').value;
		var securiteMin = document.getElementById('securiteMin').value;

		var nbCocheDepot = 0;
		var listDepotId = "";

		for (var i=0; i<aReglesDepots.nbLignes(); i++) {
			if (aReglesDepots.getCellValue(i, "colSelectRD")=="true") {
				listDepotId += (nbCocheDepot>0?",":"") + aReglesDepots.getCellText(i, "colDepotIdRD");
				nbCocheDepot++;
			}
		}

		if (nbCocheDepot==0) {
			showWarning("Nombre de d\u00E9p\u00F4ts coch\u00E9s incorrect");
		}
		else if (document.getElementById('nReference').value=="P" && (!isPeriode(document.getElementById('nReferencePeriodeDebut').value) || !isPeriode(document.getElementById('nReferencePeriodeFin').value))) {
			showWarning("P\u00E9riode de r\u00E9f\u00E9rence incorrecte");
		}
		else if (document.getElementById('nReference').value=="J" && !isPositive(document.getElementById('nReferenceJours').value)) {
			showWarning("Le nombre de jours de r\u00E9f\u00E9rence est incorrect");
		}
		else if (document.getElementById('nReference').value=="M" && !isPositive(document.getElementById('nReferenceMois').value)) {
			showWarning("Le nombre de mois de r\u00E9f\u00E9rence est incorrect");
		}
		else if (document.getElementById('nReassort').value=="J" && !isPositive(document.getElementById('nReassortJours').value)) {
			showWarning("Le nombre de jours de r\u00E9assort est incorrect");
		}
		else if (document.getElementById('nReassort').value=="M" && !isPositive(document.getElementById('nReassortMois').value)) {
			showWarning("Le nombre de mois de r\u00E9assort est incorrect");
		}
		else if (methodeSecurite=="P" && !isTaux(document.getElementById('pourcentageSecu').value)) {
			showWarning("Le pourcentage de calcul du stock de s\u00E9curit\u00E9 est incorrect");
		}
		else if (methodeSecurite!="N" && !isPositiveOrNull(securiteMin)) {
			showWarning("Le stock de s\u00E9curit\u00E9 minimum est incorrect");
		}
		else {
			var qSave;
			if (regleId=="") {
				qSave = new QueryHttp("Facturation/Stocks/addRegleSeuilsStock.tmpl");
			}
			else {
				qSave = new QueryHttp("Facturation/Stocks/updateRegleSeuilsStock.tmpl");
				qSave.setParam("Regle_Id", regleId);
			}
			qSave.setParam('Intitule', document.getElementById('Intitule').value);
			qSave.setParam('Famille_1', document.getElementById('Famille_1').value);
			qSave.setParam('Famille_2', document.getElementById('Famille_2').value);
			qSave.setParam('Famille_3', document.getElementById('Famille_3').value);
			qSave.setParam('Marque_Id', document.getElementById('Marque').value);
			qSave.setParam('Depots_Id', listDepotId);
			qSave.setParam('Classe_ABC', document.getElementById('Classe_ABC').value);
			qSave.setParam('Type_Article', document.getElementById('typeArticle').value);
			qSave.setParam('Methode_Securite', methodeSecurite);
			qSave.setParam('Pourc_Minimum', document.getElementById('pourcentageSecu').value);
			qSave.setParam('Securite_Min', securiteMin);
			qSave.setParam('Reference_Fournisseur', document.getElementById('Reference_Fournisseur').value);
			qSave.setParam('Type_PeriodeN', document.getElementById('nReference').value);
			qSave.setParam('Type_PeriodeN1', document.getElementById('nReference1').value);
			qSave.setParam('Type_PeriodeR', document.getElementById('nReassort').value);
			qSave.setParam('Limite_Evol', document.getElementById('alerteEvolution').value==""?"0":document.getElementById('alerteEvolution').value);
			qSave.setParam('Actif', document.getElementById('actif').checked);

			if (document.getElementById('nReference').value=="P") {
				qSave.setParam('Periode_Deb',document.getElementById('nReferencePeriodeDebut').value);
				qSave.setParam('Periode_Fin',document.getElementById('nReferencePeriodeFin').value);
			}
			else if (document.getElementById('nReference').value=="J") {
				qSave.setParam('Duree_Reference',document.getElementById('nReferenceJours').value);
			}
			else if (document.getElementById('nReference').value=="M") {
				qSave.setParam('Duree_Reference',document.getElementById('nReferenceMois').value);
			}

			if (document.getElementById('nReassort').value=="J") {
				qSave.setParam('Duree_Reassort',document.getElementById('nReassortJours').value);
			}
			else if (document.getElementById('nReassort').value=="M") {
				qSave.setParam('Duree_Reassort',document.getElementById('nReassortMois').value);
			}
			var result = qSave.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				regleId = "";
				aRegles.initTree(nouvelleRegle);
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function supprimerRegle() {
	try {

		if (window.confirm("Confirmez-vous la suppression de la regle s\u00E9lectionn\u00E9 ?")) {

			var qDelete = new QueryHttp("Facturation/Stocks/deleteRegleSeuilsStock.tmpl");
			qDelete.setParam("Regle_Id", regleId);
			var result = qDelete.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				aRegles.initTree(nouvelleRegle);
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function deplacerLigneBas() {
	try {

		deplacerLigne("Bas");

	} catch (e) {
		recup_erreur(e);
	}
}


function deplacerLigneHaut() {
	try {

		deplacerLigne("Haut");

	} catch (e) {
		recup_erreur(e);
	}
}


function deplacerLigne(type) {
	try {

		if (aRegles.isSelected()) {
			var regleId = aRegles.getSelectedCellText('colRegleId');

			var qDeplacerLigne = new QueryHttp("Facturation/Stocks/deplacerRegleSeuilsStock.tmpl");
			qDeplacerLigne.setParam("Regle_Id", regleId);
			qDeplacerLigne.setParam("Deplacement", type);
			qDeplacerLigne.execute();

			aRegles.initTree();
			nouvelleRegle();

		}

	} catch (e) {
		recup_erreur(e);
	}
}

function chargerRun() {
	try {

		if (aRuns.isSelected() || runId!="") {

			pageCourante = 1;
			nbPages = 1;

			var nbLignesParPage = document.getElementById('nbLignesParPage').value;
			if (aRuns.isSelected()) {
				runId = aRuns.getSelectedCellText('colRunId');
			}
			qListLRSS.setParam("Run_Id", runId);
			qListLRSS.setParam("Only_Alerte", document.getElementById('affichageOnlyAlerte').checked);
			qListLRSS.setParam("Depot_Id", document.getElementById('affichageDepot').value);
			qListLRSS.setParam("Nb_Lignes_Par_Page", nbLignesParPage);
			qListLRSS.setParam("Current_Page", pageCourante);
			var result = qListLRSS.execute();

			var contenu = result.responseXML.documentElement;
			nbPages = contenu.getAttribute("Nb_Pages");
			var listLigneId = contenu.getAttribute("List_Ligne_Id");

			aLignesRun.setParam("List_Ligne_Id", listLigneId);
			aLignesRun.initTree(initPagination);
		}
	} catch (e) {
    recup_erreur(e);
  }
}

function initPagination() {
	try {

		document.getElementById('pageDeb').value = pageCourante;
		document.getElementById('pageFin').value = (nbPages>0?nbPages:1);
		document.getElementById('bPrec').disabled = (pageCourante==1);
		document.getElementById('bSuiv').disabled = (pageCourante>=nbPages); // peut se produire si nbPages=0

		document.getElementById('listeLignesRun').disabled = false;

	} catch (e) {
		recup_erreur(e);
	}
}

function pressOnPagePrec() {
	try {

		pageCourante--;
		majPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function pressOnPageSuiv() {
	try {

		pageCourante++;
		majPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function majPagination() {
	try {

		document.getElementById('pageDeb').value = pageCourante;
		document.getElementById('bPrec').disabled = (pageCourante==1);
		document.getElementById('bSuiv').disabled = (pageCourante==nbPages);

		document.getElementById('listeLignesRun').disabled = true;

		qListLRSS.setParam("Current_Page", pageCourante);
		var result = qListLRSS.execute();
		var listLigneId = result.responseXML.documentElement.getAttribute("List_Ligne_Id");

		aLignesRun.setParam("List_Ligne_Id", listLigneId);
		aLignesRun.initTree(afterMajPagination);

	} catch (e) {
		recup_erreur(e);
	}
}


function afterMajPagination() {
	try {

		document.getElementById('listeLignesRun').disabled = false;

	} catch (e) {
		recup_erreur(e);
	}
}



function run() {
	try {

		if (confirm("voulez vous ex\u00E9cuter le param\u00E9trage des stocks?")) {
			bloquerInterfaceRun(true);

			var qValidateParamStocks = new QueryHttp("Facturation/Stocks/execSeuilsStock.tmpl");
			qValidateParamStocks.execute(run2);
		}

	} catch (e) {
		recup_erreur(e);
	}
}

function run2(result) {
	try {
		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}
		else {
			aRegles.initTree();
			nouvelleRegle();
			aRuns.initTree();
			runId="";
			bloquerInterfaceRun(false);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function previsualiser() {
	try {

		bloquerInterfaceRun(true);
		var qCalculParamStocks = new QueryHttp("Facturation/Stocks/calculSeuilsStock.tmpl");
		qCalculParamStocks.execute(previsualiser2);


	} catch (e) {
		recup_erreur(e);
	}
}

function previsualiser2(result) {
	try {
		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}
		else {
			aRuns.initTree(previsualiser3);
		}
	} catch (e) {
		recup_erreur(e);
	}
}

function previsualiser3() {
	try {
		bloquerInterfaceRun(false);

		pageCourante = 1;
		nbPages = 1;
		aRuns.clearSelection();
		aRuns.select(0);

	} catch (e) {
		recup_erreur(e);
	}
}

function bloquerInterfaceRun(bloque) {
	try {
		document.getElementById('pmbox').collapsed = !bloque;
		if (bloque) {
			document.getElementById('pm').setAttribute('mode', 'undetermined');
		}
		else {
			document.getElementById('pm').setAttribute('mode', 'none');
		}
		document.getElementById('Panneau').disabled = bloque;
		document.getElementById('listeRuns').disabled = bloque;
		document.getElementById('listeLignesRun').disabled = bloque;
		document.getElementById('bPrevisualiser').disabled = bloque;
		document.getElementById('bRun').disabled = bloque;
		document.getElementById('bLegende').disabled = bloque;
		document.getElementById('affichageOnlyAlerte').disabled = bloque;
		document.getElementById('affichageDepot').disabled = bloque;
		document.getElementById('bPrec').disabled = bloque;
		document.getElementById('bSuiv').disabled = bloque;
		document.getElementById('nbLignesParPage').disabled = bloque;

	} catch (e) {
		recup_erreur(e);
	}
}



function rechercherFournisseur() {
	try {

		var url = "chrome://opensi/content/facturation/user/fournisseurs/popup-rechercheFournisseur.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', retourRechercherFournisseur);

	} catch (e) {
		recup_erreur(e);
	}
}


function retourRechercherFournisseur(numFournisseur) {
	try {

		document.getElementById('Reference_Fournisseur').value = numFournisseur;

	} catch (e) {
		recup_erreur(e);
	}
}


function ouvrirLegende() {
  try {

		window.openDialog("chrome://opensi/content/facturation/user/stocks/popup-legende.xul",'','chrome,modal,centerscreen');

	} catch (e) {
    recup_erreur(e);
  }
}


function retourMenuPrincipal() {
	try {
		window.location = "chrome://opensi/content/facturation/user/menu_principal.xul?" + cookie();

	} catch (e) {
		recup_erreur(e);
	}
}
