/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/

var oope_aEtablissements = new Arbre('ComboListe/combo-etablissements.tmpl', 'oope-etablissement');
var oope_aDepots = new Arbre('ComboListe/combo-depotsStock.tmpl', 'oope-depot');
var oope_aProvenances = new Arbre("ComboListe/combo-sitesWeb.tmpl","oope-provenance");
var oope_aResponsables = new Arbre("ComboListe/combo-responsables.tmpl","oope-responsable");
var oope_aModesExpedition = new Arbre("ComboListe/combo-modesExpedition.tmpl","oope-modeExpedition");
var oope_aCartons = new Arbre("ComboListe/combo-cartons.tmpl", "oope-cartonIdColis");
var oope_aPreparations = new Arbre("Facturation/Suivi_Logistique/list-bonPreparation.tmpl", "oope-listePreparations");
var oope_aApercuLigneBP = new Arbre("Facturation/Suivi_Logistique/list-apercuLigneBP.tmpl", "oope-apercuLigneBP");
var oope_aApercuColisBP = new Arbre("Facturation/Suivi_Logistique/list-apercuColisBP.tmpl", "oope-apercuColisBP");
var oope_qListBP = new QueryHttp("Facturation/Suivi_Logistique/getDataListBP.tmpl");

var oope_pageCourante;
var oope_nbPages;

var oope_currentBonId = "";
var oope_currentColisId = "";
var oope_currentCartonId = "";



function oope_initOngletPreparations() {
	try {

		oope_aProvenances.initTree();
		oope_aResponsables.initTree();
		oope_aModesExpedition.initTree();

		oope_aEtablissements.setParam('Selection', gEtablissementDefaut);
		oope_aEtablissements.initTree(oope_initEtablissement);

		if (!gSiteWeb) {
			document.getElementById('oope-colProvenance').collapsed = true;
			document.getElementById('oope-colProvenance').setAttribute("ignoreincolumnpicker", true);
		}

		if (!gEXLBacPrepa) {
			document.getElementById('oope-colNumBac').collapsed = true;
			document.getElementById('oope-colNumBac').setAttribute("ignoreincolumnpicker", true);

			document.getElementById('oope-bImprEtiqBac').collapsed = true;
			document.getElementById('oope-bEditEtiqBac').collapsed = true;
		}

		if (!gEtapePicking || gMWMModePicking!="C") {
			document.getElementById('oope-bImprEtiqBac').collapsed = true;
			document.getElementById('oope-bEditEtiqBac').collapsed = true;
		}

		if (!gEtapePicking || gMWMModePicking!="F") {
			document.getElementById('oope-colRefBac').collapsed = true;
			document.getElementById('oope-colRefBac').setAttribute("ignoreincolumnpicker", true);
		}

		if (!gAccMWM) {
			document.getElementById('oope-colLastLocalisation').collapsed = true;
			document.getElementById('oope-colLastLocalisation').setAttribute("ignoreincolumnpicker", true);
		}

		if (!gConfig.isActCrossDock()) {
			document.getElementById('oope-bImprEtiqCross').collapsed = true;
			document.getElementById('oope-bEditEtiqCross').collapsed = true;
		}

		if (!gConfig.isMWMPEXColisage() || !gConfig.isMWMPEXImpEtiq()) {
			document.getElementById("oope-bImpEtiqColis").collapsed = true;
		}

		document.getElementById('oope-boxProvenance').collapsed = !gSiteWeb;

		document.getElementById('oope-colPoids').setAttribute("label", "Poids en "+ gSymboleUnitePoids);
		document.getElementById('oope-colVolume').setAttribute("label", "Volume en "+ gSymboleUniteVolume);
		document.getElementById("oope-colVolumeColisAC").setAttribute("label", "Volume ("+ gSymboleUniteVolume +")");
		document.getElementById("oope-lblVolume").value = "Volume ("+ gSymboleUniteVolume +") :";

		document.getElementById('oope-miProvenanceHL').collapsed = !gProfil.isProvenanceHL();

	} catch (e) {
		recup_erreur(e);
  }
}


function oope_initEtablissement() {
	try {

		oope_aDepots.setParam('Selection', gDepotDefaut);
		oope_aDepots.initTree(oope_initCriteres);

	} catch (e) {
		recup_erreur(e);
	}
}


function oope_initCriteres() {
	try {

		document.getElementById('oope-numeroBP').value = "";
		document.getElementById('oope-dateBPDebut').value = "";
		document.getElementById('oope-dateBPFin').value = "";
		document.getElementById('oope-numClient').value = "";
		document.getElementById('oope-denomination').value = "";
		document.getElementById('oope-etablissement').value = gEtablissementDefaut;
		document.getElementById('oope-depot').value = gDepotDefaut;
		document.getElementById('oope-refArticle').value = "";
		document.getElementById('oope-etatBP').value = "P";
		document.getElementById('oope-modeExpedition').value = "";
		document.getElementById('oope-provenance').value = "";
		document.getElementById('oope-responsable').value = "";
		document.getElementById('oope-numCommande').value = "";
		document.getElementById('oope-numTransfert').value = "";

	} catch (e) {
		recup_erreur(e);
	}
}


function oope_listerPreparations() {
	try {

		var numeroBP = document.getElementById('oope-numeroBP').value;
		var numClient = document.getElementById('oope-numClient').value;
		var denomination = document.getElementById('oope-denomination').value;
		var etatBP = document.getElementById('oope-etatBP').value;
		var refArticle = document.getElementById('oope-refArticle').value;
		var etablissement = document.getElementById('oope-etablissement').value;
		var depot = document.getElementById('oope-depot').value;
		var provenance = document.getElementById('oope-provenance').value;
		var dateBPDebut = document.getElementById('oope-dateBPDebut').value;
		var dateBPFin = document.getElementById('oope-dateBPFin').value;
		var responsable = document.getElementById('oope-responsable').value;
		var modeExpedition = document.getElementById('oope-modeExpedition').value;
		var numCommande = document.getElementById('oope-numCommande').value;
		var numTransfert = document.getElementById('oope-numTransfert').value;
		var nbLignesParPage = document.getElementById('oope-nbLignesParPage').value;

		if (!isEmpty(dateBPDebut) && !isDate(dateBPDebut)) { showWarning("Date de d\u00E9but incorrecte"); }
		else if (!isEmpty(dateBPFin) && !isDate(dateBPFin)) { showWarning("Date de fin incorrecte"); }
		else if (!isEmpty(dateBPDebut) && !isEmpty(dateBPFin) && !isDateInterval(dateBPDebut, dateBPFin)) { showWarning("Plage de dates incorrecte"); }
		else {

			oope_pageCourante = 1;
			oope_nbPages = 1;
			document.getElementById('oope-pageDeb').value = 1;
			document.getElementById('oope-pageFin').value = 1;
			document.getElementById('oope-bPrec').disabled = true;
			document.getElementById('oope-bSuiv').disabled = true;

			document.getElementById('oope-listePreparations').disabled = true;
			document.getElementById('oope-bEditionCSV').disabled = true;
			document.getElementById('oope-bEditionDetailCSV').disabled = true;
			document.getElementById('oope-bEditionBP').disabled = true;
			document.getElementById('oope-bEditionOL').disabled = true;
			document.getElementById('oope-bEditionOL').collapsed = true;
			document.getElementById('oope-bEditionBP').collapsed = false;
			document.getElementById('oope-bImprEtiqBac').disabled = true;
			document.getElementById('oope-bEditEtiqBac').disabled = true;
			document.getElementById('oope-bImprEtiqCross').disabled = true;
			document.getElementById('oope-bEditEtiqCross').disabled = true;
			document.getElementById('oope-numBonPreparationSelect').value = "";
			document.getElementById("oope-nouveauColis").disabled = true;
			document.getElementById("oope-validerColis").disabled = true;
			document.getElementById("oope-validerNbColis").disabled = true;
			document.getElementById("oope-supprimerColis").disabled = true;
			document.getElementById("oope-nbColis").disabled = true;
			document.getElementById("oope-poidsColis").disabled = true;
			document.getElementById("oope-volumeColis").disabled = true;
			document.getElementById("oope-cartonIdColis").disabled = true;
			document.getElementById("oope-bCsvColisage").disabled = true;
			document.getElementById("oope-bPdfColisage").disabled = true;
			document.getElementById("oope-bPdfEtiqColis").disabled = true;
			document.getElementById("oope-bImpEtiqColis").disabled = true;
			oope_aApercuLigneBP.deleteTree();
			oope_aApercuColisBP.deleteTree();
			oope_aPreparations.deleteTree();

			oope_qListBP.setParam("Numero_BP", numeroBP);
			oope_qListBP.setParam("Num_Client", numClient);
			oope_qListBP.setParam("Denomination", denomination);
			oope_qListBP.setParam("Etat_BP", etatBP);
			oope_qListBP.setParam("Ref_Article", refArticle);
			oope_qListBP.setParam("Etablissement", etablissement);
			oope_qListBP.setParam("Depot", depot);
			oope_qListBP.setParam("Provenance", provenance);
			oope_qListBP.setParam("Date_BP_Debut", dateBPDebut);
			oope_qListBP.setParam("Date_BP_Fin", dateBPFin);
			oope_qListBP.setParam("Responsable", responsable);
			oope_qListBP.setParam("Mode_Expedition", modeExpedition);
			oope_qListBP.setParam("Num_Commande", numCommande);
			oope_qListBP.setParam("Num_Transfert", numTransfert);
			oope_qListBP.setParam("Nb_Lignes_Par_Page", nbLignesParPage);
			oope_qListBP.setParam("Current_Page", oope_pageCourante);

			var result = oope_qListBP.execute();

			var contenu = result.responseXML.documentElement;

			oope_nbPages = contenu.getAttribute("Nb_Pages");
			var listBonId = contenu.getAttribute("List_Bon_Id");

			oope_aPreparations.setParam("List_Bon_Id", listBonId);
			oope_aPreparations.initTree(oope_initPagination);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oope_initPagination() {
	try {

		document.getElementById('oope-pageDeb').value = oope_pageCourante;
		document.getElementById('oope-pageFin').value = (oope_nbPages>0?oope_nbPages:1);
		document.getElementById('oope-bPrec').disabled = (oope_pageCourante==1);
		document.getElementById('oope-bSuiv').disabled = (oope_pageCourante>=oope_nbPages); // peut se produire si oope_nbPages=0

		oope_afterMajPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function oope_pressOnPagePrec() {
	try {

		oope_pageCourante--;
		oope_majPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function oope_pressOnPageSuiv() {
	try {

		oope_pageCourante++;
		oope_majPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function oope_majPagination() {
	try {

		document.getElementById('oope-pageDeb').value = oope_pageCourante;
		document.getElementById('oope-bPrec').disabled = (oope_pageCourante==1);
		document.getElementById('oope-bSuiv').disabled = (oope_pageCourante==oope_nbPages);

		document.getElementById('oope-listePreparations').disabled = true;
		document.getElementById('oope-bEditionCSV').disabled = true;
		document.getElementById('oope-bEditionDetailCSV').disabled = true;
		document.getElementById('oope-bEditionBP').disabled = true;
		document.getElementById('oope-bEditionOL').disabled = true;
		document.getElementById('oope-bEditionOL').collapsed = true;
		document.getElementById('oope-bEditionBP').collapsed = false;
		document.getElementById('oope-bImprEtiqBac').disabled = true;
		document.getElementById('oope-bEditEtiqBac').disabled = true;
		document.getElementById('oope-bImprEtiqCross').disabled = true;
		document.getElementById('oope-bEditEtiqCross').disabled = true;
		document.getElementById('oope-numBonPreparationSelect').value = "";
		document.getElementById("oope-nouveauColis").disabled = true;
		document.getElementById("oope-validerColis").disabled = true;
		document.getElementById("oope-validerNbColis").disabled = true;
		document.getElementById("oope-supprimerColis").disabled = true;
		document.getElementById("oope-nbColis").disabled = true;
		document.getElementById("oope-poidsColis").disabled = true;
		document.getElementById("oope-volumeColis").disabled = true;
		document.getElementById("oope-cartonIdColis").disabled = true;
		document.getElementById("oope-bCsvColisage").disabled = true;
		document.getElementById("oope-bPdfColisage").disabled = true;
		document.getElementById("oope-bPdfEtiqColis").disabled = true;
		document.getElementById("oope-bImpEtiqColis").disabled = true;
		oope_aApercuLigneBP.deleteTree();
		oope_aApercuColisBP.deleteTree();

		oope_qListBP.setParam("Current_Page", oope_pageCourante);
		var result = oope_qListBP.execute();
		var listBonId = result.responseXML.documentElement.getAttribute("List_Bon_Id");

		oope_aPreparations.setParam("List_Bon_Id", listBonId);
		oope_aPreparations.initTree(oope_afterMajPagination);

	} catch (e) {
		recup_erreur(e);
	}
}


function oope_afterMajPagination() {
	try {

		document.getElementById('oope-listePreparations').disabled = false;
		document.getElementById('oope-bEditionCSV').disabled=(oope_aPreparations.nbLignes()==0);
		document.getElementById('oope-bEditionDetailCSV').disabled=(oope_aPreparations.nbLignes()==0);

	} catch (e) {
		recup_erreur(e);
	}
}


function oope_selectOnListePreparations() {
	try {

		if (oope_aPreparations.isSelected()) {
			oope_currentBonId = oope_aPreparations.getSelectedCellText('oope-colBonId');
			document.getElementById('oope-numBonPreparationSelect').value = oope_aPreparations.getSelectedCellText("oope-colNumeroBP");
			oope_aApercuLigneBP.setParam("Bon_Liv_Id", oope_currentBonId);
			oope_aApercuLigneBP.initTree();
			oope_aApercuColisBP.setParam("Bon_Liv_Id", oope_currentBonId);
			oope_aApercuColisBP.initTree();
			oope_nouveauColis();

			document.getElementById('oope-bEditionBP').disabled = false;
			document.getElementById('oope-bEditionOL').disabled = false;
			document.getElementById('oope-bEditionOL').collapsed = oope_aPreparations.getSelectedCellText("oope-colTypeLivraison")!="L";
			document.getElementById('oope-bEditionBP').collapsed = oope_aPreparations.getSelectedCellText("oope-colTypeLivraison")=="L";
			document.getElementById('oope-bImprEtiqBac').disabled = (oope_aPreparations.getSelectedCellText('oope-colEtat')!="V");
			document.getElementById('oope-bEditEtiqBac').disabled = (oope_aPreparations.getSelectedCellText('oope-colEtat')!="V");
			document.getElementById('oope-bImprEtiqCross').disabled = (oope_aPreparations.getSelectedCellText('oope-colEtat')!="V");
			document.getElementById('oope-bEditEtiqCross').disabled = (oope_aPreparations.getSelectedCellText('oope-colEtat')!="V");
			document.getElementById("oope-bCsvColisage").disabled = false;
			document.getElementById("oope-bPdfColisage").disabled = false;
			document.getElementById("oope-bPdfEtiqColis").disabled = false;
			document.getElementById("oope-bImpEtiqColis").disabled = false;
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oope_pressOnCritere(ev) {
  try {

		if (ev.keyCode==13) {
			oope_listerPreparations();
    }

	} catch (e) {
  	recup_erreur(e);
  }
}


function oope_pressOnEditionCSV() {
	try {

		var numeroBP = document.getElementById('oope-numeroBP').value;
		var numClient = document.getElementById('oope-numClient').value;
		var denomination = document.getElementById('oope-denomination').value;
		var etatBP = document.getElementById('oope-etatBP').value;
		var refArticle = document.getElementById('oope-refArticle').value;
		var etablissement = document.getElementById('oope-etablissement').value;
		var depot = document.getElementById('oope-depot').value;
		var provenance = document.getElementById('oope-provenance').value;
		var dateBPDebut = document.getElementById('oope-dateBPDebut').value;
		var dateBPFin = document.getElementById('oope-dateBPFin').value;
		var responsable = document.getElementById('oope-responsable').value;
		var modeExpedition = document.getElementById('oope-modeExpedition').value;
		var numCommande = document.getElementById('oope-numCommande').value;
		var numTransfert = document.getElementById('oope-numTransfert').value;

		if (!isEmpty(dateBPDebut) && !isDate(dateBPDebut)) { showWarning("Date de d\u00E9but incorrecte"); }
		else if (!isEmpty(dateBPFin) && !isDate(dateBPFin)) { showWarning("Date de fin incorrecte"); }
		else if (!isEmpty(dateBPDebut) && !isEmpty(dateBPFin) && !isDateInterval(dateBPDebut, dateBPFin)) { showWarning("Plage de dates incorrecte"); }
		else {

			var qEditionCSV = new QueryHttp("Facturation/Suivi_Logistique/csvBonPreparation.tmpl");

			qEditionCSV.setParam("Numero_BP", numeroBP);
			qEditionCSV.setParam("Num_Client", numClient);
			qEditionCSV.setParam("Denomination", denomination);
			qEditionCSV.setParam("Etat_BP", etatBP);
			qEditionCSV.setParam("Ref_Article", refArticle);
			qEditionCSV.setParam("Etablissement", etablissement);
			qEditionCSV.setParam("Depot", depot);
			qEditionCSV.setParam("Provenance", provenance);
			qEditionCSV.setParam("Date_BP_Debut", dateBPDebut);
			qEditionCSV.setParam("Date_BP_Fin", dateBPFin);
			qEditionCSV.setParam("Responsable", responsable);
			qEditionCSV.setParam("Mode_Expedition", modeExpedition);
			qEditionCSV.setParam("Num_Commande", numCommande);
			qEditionCSV.setParam("Num_Transfert", numTransfert);

			var result = qEditionCSV.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				var fichier = result.responseXML.documentElement.getAttribute('FichierCSV');

				var file = fileChooser("save", fichier);
				if (file!=null) {
					downloadFile(getDirBuffer()+ fichier, file);
				}
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oope_pressOnEditionDetailCSV() {
	try {

		var numeroBP = document.getElementById('oope-numeroBP').value;
		var numClient = document.getElementById('oope-numClient').value;
		var denomination = document.getElementById('oope-denomination').value;
		var etatBP = document.getElementById('oope-etatBP').value;
		var refArticle = document.getElementById('oope-refArticle').value;
		var etablissement = document.getElementById('oope-etablissement').value;
		var depot = document.getElementById('oope-depot').value;
		var provenance = document.getElementById('oope-provenance').value;
		var dateBPDebut = document.getElementById('oope-dateBPDebut').value;
		var dateBPFin = document.getElementById('oope-dateBPFin').value;
		var responsable = document.getElementById('oope-responsable').value;
		var modeExpedition = document.getElementById('oope-modeExpedition').value;
		var numCommande = document.getElementById('oope-numCommande').value;
		var numTransfert = document.getElementById('oope-numTransfert').value;

		if (!isEmpty(dateBPDebut) && !isDate(dateBPDebut)) { showWarning("Date de d\u00E9but incorrecte"); }
		else if (!isEmpty(dateBPFin) && !isDate(dateBPFin)) { showWarning("Date de fin incorrecte"); }
		else if (!isEmpty(dateBPDebut) && !isEmpty(dateBPFin) && !isDateInterval(dateBPDebut, dateBPFin)) { showWarning("Plage de dates incorrecte"); }
		else {

			var qEditionCSV = new QueryHttp("Facturation/Suivi_Logistique/csvDetailBonPreparation.tmpl");

			qEditionCSV.setParam("Numero_BP", numeroBP);
			qEditionCSV.setParam("Num_Client", numClient);
			qEditionCSV.setParam("Denomination", denomination);
			qEditionCSV.setParam("Etat_BP", etatBP);
			qEditionCSV.setParam("Ref_Article", refArticle);
			qEditionCSV.setParam("Etablissement", etablissement);
			qEditionCSV.setParam("Depot", depot);
			qEditionCSV.setParam("Provenance", provenance);
			qEditionCSV.setParam("Date_BP_Debut", dateBPDebut);
			qEditionCSV.setParam("Date_BP_Fin", dateBPFin);
			qEditionCSV.setParam("Responsable", responsable);
			qEditionCSV.setParam("Mode_Expedition", modeExpedition);
			qEditionCSV.setParam("Num_Commande", numCommande);
			qEditionCSV.setParam("Num_Transfert", numTransfert);

			var result = qEditionCSV.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				var fichier = result.responseXML.documentElement.getAttribute('FichierCSV');

				var file = fileChooser("save", fichier);
				if (file!=null) {
					downloadFile(getDirBuffer()+ fichier, file);
				}
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oope_editionBP() {
	try {

		if (oope_aPreparations.isSelected()) {

			var qEditionPDF = new QueryHttp("Facturation/Suivi_Logistique/pdfBonPreparation.tmpl");
			qEditionPDF.setParam('Bon_Id', oope_currentBonId);

			document.getElementById('pmbox').collapsed = false;
			document.getElementById('pm').setAttribute('mode', 'undetermined');
			document.getElementById('deck').selectedIndex = 1;

			qEditionPDF.execute(oope_editionBP_2);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oope_editionBP_2(result) {
	try {

		document.getElementById('pmbox').collapsed = true;
		document.getElementById('pm').setAttribute('mode', 'none');

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
			retourSuiviLogistique();
		}
		else {
			var page = getDirPdf() + result.responseXML.documentElement.getAttribute('FichierPDF');
			document.getElementById('pdf').setAttribute("src", page);

			document.getElementById('bRetourSuiviLogistique').collapsed = false;
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oope_editionOL() {
	try {

		var qEditionPDF = new QueryHttp("Facturation/Suivi_Logistique/pdfOrdreLivraison.tmpl");
		qEditionPDF.setParam('Bon_Id', oope_currentBonId);

		document.getElementById('pmbox').collapsed = false;
		document.getElementById('pm').setAttribute('mode', 'undetermined');
		document.getElementById('deck').selectedIndex = 1;

		qEditionPDF.execute(oope_editionOL_2);

	} catch (e) {
		recup_erreur(e);
	}
}


function oope_editionOL_2(result) {
	try {

		document.getElementById('pmbox').collapsed = true;
		document.getElementById('pm').setAttribute('mode', 'none');

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
			retourSuiviLogistique();
		}
		else {
			var page = getDirPdf() + result.responseXML.documentElement.getAttribute('FichierPDF');
			document.getElementById('pdf').setAttribute("src", page);

			document.getElementById('bRetourSuiviLogistique').collapsed = false;
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oope_imprimerEtiquettesBacs() {
	try {

		if (oope_aPreparations.isSelected()) {
			var qPrint = new QueryHttp("Facturation/Suivi_Logistique/printEtiquetteBacBonPreparation.tmpl");
			qPrint.setParam("Bon_Liv_Id", oope_currentBonId);
			var result = qPrint.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				showMessage("Les \u00E9tiquettes ont \u00E9t\u00E9 envoy\u00E9es en impression");
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oope_editerEtiquettesBacs() {
	try {

		if (oope_aPreparations.isSelected()) {
			var qEtiq = new QueryHttp("Facturation/Suivi_Logistique/pdfEtiquetteBacBonPreparation.tmpl");
			qEtiq.setParam("Bon_Liv_Id", oope_currentBonId);

			document.getElementById('pmbox').collapsed = false;
			document.getElementById('pm').setAttribute('mode', 'undetermined');
			document.getElementById('deck').selectedIndex = 1;

			qEtiq.execute(oope_editerEtiquettesBacs_2);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oope_editerEtiquettesBacs_2(result) {
	try {

		document.getElementById('pmbox').collapsed = true;
		document.getElementById('pm').setAttribute('mode', 'none');

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
			retourSuiviLogistique();
		}
		else {
			var page = getDirPdf() + result.responseXML.documentElement.getAttribute('FichierPDF');
			document.getElementById('pdf').setAttribute("src", page);

			document.getElementById('bRetourSuiviLogistique').collapsed = false;
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oope_imprimerEtiquettesCrossDock() {
	try {

		if (oope_aPreparations.isSelected()) {
			var qPrint = new QueryHttp("Facturation/Suivi_Logistique/printEtiquetteCrossDockBonPreparation.tmpl");
			qPrint.setParam("Bon_Liv_Id", oope_currentBonId);
			var result = qPrint.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				showMessage("Les \u00E9tiquettes ont \u00E9t\u00E9 envoy\u00E9es en impression");
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oope_editerEtiquettesCrossDock() {
	try {

		if (oope_aPreparations.isSelected()) {
			var qEtiq = new QueryHttp("Facturation/Suivi_Logistique/pdfEtiquetteCrossDockBonPreparation.tmpl");
			qEtiq.setParam("Bon_Liv_Id", oope_currentBonId);

			document.getElementById('pmbox').collapsed = false;
			document.getElementById('pm').setAttribute('mode', 'undetermined');
			document.getElementById('deck').selectedIndex = 1;

			qEtiq.execute(oope_editerEtiquettesCrossDock_2);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oope_editerEtiquettesCrossDock_2(result) {
	try {

		document.getElementById('pmbox').collapsed = true;
		document.getElementById('pm').setAttribute('mode', 'none');

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
			retourSuiviLogistique();
		}
		else {
			var page = getDirPdf() + result.responseXML.documentElement.getAttribute('FichierPDF');
			document.getElementById('pdf').setAttribute("src", page);

			document.getElementById('bRetourSuiviLogistique').collapsed = false;
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oope_rechercherClient() {
	try {

		var url = "chrome://opensi/content/facturation/user/clients/popup-rechercheClient.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', oope_retourRechercherClient);

	} catch (e) {
		recup_erreur(e);
	}
}


function oope_retourRechercherClient(numClient) {
	try {

  	document.getElementById('oope-numClient').value = numClient;
  	oope_listerPreparations();

	} catch (e) {
		recup_erreur(e);
	}
}


function oope_rechercherArticle() {
	try {

		var url = "chrome://opensi/content/facturation/user/articles/popup-rechercheArticle.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', oope_retourRechercherArticle);

	} catch (e) {
		recup_erreur(e);
	}
}


function oope_retourRechercherArticle(reference, articleId) {
	try {

  	document.getElementById('oope-refArticle').value = reference;
  	oope_listerPreparations();

	} catch (e) {
		recup_erreur(e);
	}
}


function oope_chargerCartons(selection) {
	try {

		oope_currentCartonId = selection;
		oope_aCartons.setParam("Selection", oope_currentCartonId);
		oope_aCartons.initTree(oope_initCarton);

	} catch (e) {
		recup_erreur(e);
	}
}


function oope_initCarton() {
	try {

		document.getElementById('oope-cartonIdColis').value = oope_currentCartonId;

	} catch (e) {
		recup_erreur(e);
	}
}


function oope_validerColis() {
	try {

		var poids = document.getElementById('oope-poidsColis').value;
		var volume = document.getElementById('oope-volumeColis').value;
		var cartonId = document.getElementById('oope-cartonIdColis').value;

		if (isEmpty(volume)) {
			volume = 0;
		}

		if (!isPositiveOrNull(poids) || !checkNumber(poids,10,3)) {
			showWarning("Poids du colis incorrect");
		}
		else if (!isPositiveOrNull(volume) || !checkNumber(volume,9,3)) {
			showWarning("Volume du colis incorrect");
		}
		else {
			var qSave;

			if (isEmpty(oope_currentColisId)) {
				qSave = new QueryHttp("Facturation/Suivi_Logistique/createColis.tmpl");
				qSave.setParam("Bon_Liv_Id", oope_currentBonId);
			}
			else {
				qSave = new QueryHttp("Facturation/Suivi_Logistique/updateColis.tmpl");
				qSave.setParam("Colis_Id", oope_currentColisId);
			}

			qSave.setParam("Poids", poids);
			qSave.setParam("Volume", volume);
			qSave.setParam("Carton_Id", cartonId);
			var result = qSave.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}

			oope_aApercuColisBP.initTree();
			oope_nouveauColis();
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oope_supprimerColis() {
	try {

		var qDelete = new QueryHttp("Facturation/Suivi_Logistique/deleteColis.tmpl");
		qDelete.setParam("Colis_Id", oope_currentColisId);
		var result = qDelete.execute();

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
		}

		oope_aApercuColisBP.initTree();
		oope_nouveauColis();

	} catch (e) {
    recup_erreur(e);
  }
}


function oope_nouveauColis() {
	try {

		oope_currentColisId = "";
		document.getElementById('oope-numInterneColis').value = "";
		document.getElementById('oope-poidsColis').value = "";
		document.getElementById('oope-volumeColis').value = "";
		document.getElementById('oope-nbColis').value = "";
		document.getElementById("oope-nouveauColis").disabled = false;
		document.getElementById("oope-validerColis").disabled = false;
		document.getElementById("oope-validerNbColis").disabled = false;
		document.getElementById("oope-supprimerColis").disabled = true;
		document.getElementById("oope-nbColis").disabled = false;
		document.getElementById("oope-poidsColis").disabled = false;
		document.getElementById("oope-volumeColis").disabled = false;
		document.getElementById("oope-cartonIdColis").disabled = false;
		oope_chargerCartons("");

	} catch (e) {
    recup_erreur(e);
  }
}


function oope_selectOnApercuColisBP() {
	try {

		if (oope_aApercuColisBP.isSelected()) {
			oope_currentColisId = oope_aApercuColisBP.getSelectedCellText("oope-colColisIdAC");
			document.getElementById('oope-numInterneColis').value = oope_aApercuColisBP.getSelectedCellText("oope-colNumInterneAC");
			document.getElementById('oope-poidsColis').value = oope_aApercuColisBP.getSelectedCellText("oope-colPoidsColisAC");
			document.getElementById('oope-volumeColis').value = oope_aApercuColisBP.getSelectedCellText("oope-colVolumeColisAC");
			document.getElementById("oope-nouveauColis").disabled = false;
			document.getElementById("oope-validerColis").disabled = false;
			document.getElementById("oope-validerNbColis").disabled = false;
			document.getElementById("oope-supprimerColis").disabled = false;
			document.getElementById("oope-nbColis").disabled = false;
			document.getElementById("oope-poidsColis").disabled = false;
			document.getElementById("oope-volumeColis").disabled = false;
			document.getElementById("oope-cartonIdColis").disabled = false;
			document.getElementById('oope-poidsColis').select();
			oope_chargerCartons(oope_aApercuColisBP.getSelectedCellText("oope-colCartonIdAC"));
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oope_validerNbColis() {
	try {

		var nbColis = document.getElementById('oope-nbColis').value;

		if (!isPositiveOrNullInteger(nbColis)) {
			showWarning("Veuillez v\u00E9rifier la quantit\u00E9 saisie");
		}
		else {
			var qAdd = new QueryHttp("Facturation/Suivi_Logistique/createNbColis.tmpl");
			qAdd.setParam("Bon_Liv_Id", oope_currentBonId);
			qAdd.setParam("Nb_Colis", nbColis);
			var result = qAdd.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}

			oope_aApercuColisBP.initTree();
			oope_nouveauColis();
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oope_editerColisageCSV() {
  try {

		if (oope_aApercuColisBP.nbLignes()<=0) {
			showWarning("L'exp\u00E9dition ne contient pas de colis");
		}
		else {
			var qEditionCsv = new QueryHttp("Facturation/Suivi_Logistique/csvColisageBL.tmpl");
			qEditionCsv.setParam("Bon_Liv_Id", oope_currentBonId);

			var result = qEditionCsv.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				var fichier = result.responseXML.documentElement.getAttribute('FichierCSV');
				var file = fileChooser("save", fichier);
				if (file!=null) {
					downloadFile(getDirBuffer()+ fichier, file);
				}
			}
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oope_editerColisagePDF() {
  try {

		if (oope_aApercuColisBP.nbLignes()<=0) {
			showWarning("L'exp\u00E9dition ne contient pas de colis");
		}
		else {
			var qEditionPdf = new QueryHttp("Facturation/Suivi_Logistique/pdfColisageBL.tmpl");
			qEditionPdf.setParam("Bon_Liv_Id", oope_currentBonId);

			document.getElementById('pmbox').collapsed = false;
			document.getElementById('pm').setAttribute('mode', 'undetermined');
			document.getElementById('deck').selectedIndex = 1;

			qEditionPdf.execute(oope_editerColisagePDF_2);
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oope_editerColisagePDF_2(result) {
  try {

		document.getElementById('pmbox').collapsed = true;
		document.getElementById('pm').setAttribute('mode', 'none');

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
			retourSuiviLogistique();
		}
		else {
			var page = getDirPdf() + result.responseXML.documentElement.getAttribute('FichierPDF');
			document.getElementById('pdf').setAttribute("src", page);

			document.getElementById('bRetourSuiviLogistique').collapsed = false;
		}

	} catch (e) {
    recup_erreur(e);
  }
}


function oope_editerEtiquettesColisage() {
	try {

		if (oope_aApercuColisBP.nbLignes()<=0) {
			showWarning("L'exp\u00E9dition ne contient pas de colis");
		}
		else {
			var qEdit = new QueryHttp("Facturation/Suivi_Logistique/pdfEtiquetteColisage.tmpl");
			qEdit.setParam("Bon_Liv_Id", oope_currentBonId);

			document.getElementById('pmbox').collapsed = false;
			document.getElementById('pm').setAttribute('mode', 'undetermined');
			document.getElementById('deck').selectedIndex = 1;

			qEdit.execute(oope_editerEtiquettesColisage_2);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oope_editerEtiquettesColisage_2(result) {
	try {

		document.getElementById('pmbox').collapsed = true;
		document.getElementById('pm').setAttribute('mode', 'none');

		var errors = new Errors(result);
		if (errors.hasNext()) {
			errors.show();
			retourSuiviLogistique();
		}
		else {
			var page = getDirPdf() + result.responseXML.documentElement.getAttribute('FichierPDF');
			document.getElementById('pdf').setAttribute("src", page);

			document.getElementById('bRetourSuiviLogistique').collapsed = false;
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oope_imprimerEtiquettesColisage() {
	try {

		if (oope_aApercuColisBP.nbLignes()<=0) {
			showWarning("L'exp\u00E9dition ne contient pas de colis");
		}
		else {
			var qPrint = new QueryHttp("Facturation/Suivi_Logistique/printEtiquetteColisage.tmpl");
			qPrint.setParam("Bon_Liv_Id", oope_currentBonId);
			var result = qPrint.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				showMessage("Les \u00E9tiquettes ont \u00E9t\u00E9 envoy\u00E9es en impression");
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oope_pressOnNbColis(ev) {
	try {

		if (ev.keyCode==13) {
			oope_validerNbColis();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oope_pressOnPoidsColis(ev) {
	try {

		if (ev.keyCode==13) {
			oope_validerColis();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function oope_pressOnVolumeColis(ev) {
	try {

		if (ev.keyCode==13) {
			oope_validerColis();
		}

	} catch (e) {
		recup_erreur(e);
	}
}
