/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/
/*
 * Arguments :
 * 0 -> Type (R -> remboursement unique ; B -> Boucle)
 * 1 -> Id du remboursement
 */


jsLoader.loadSubScript("chrome://opensi/content/libs/arbres.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/verif.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/query.js");
jsLoader.loadSubScript("chrome://opensi/content/libs/formatter.js");

var aReglements = new Arbre("Facturation/Suivi_Reglements_Clients/list-affectationReglement.tmpl", "listeReglements");

var remboursementId;
var montantTotal = 0;
var montantImpute = 0;
var montantRestant = 0;
var boucler;
var creation;

var listeRemboursements;
var currentIndex = 0;
var validationOk = false;

var nf = new NumberFormat("0.00", false);


function init() {
	try {

		window.parent.addEventListener("close",alertExit,false);
		window.resizeTo(1000,750);
		boucler = (window.arguments[0]=="B");
		remboursementId = window.arguments[1];
		creation = window.arguments[3];

		if (boucler) {
			var qListePieces = new QueryHttp("Facturation/Suivi_Reglements_Clients/getListRemboursementAImputer.tmpl");
			var result = qListePieces.execute();
			listeRemboursements = result.responseXML.documentElement.getAttribute("List_Remboursement_Id")

			if (isEmpty(listeRemboursements)) {
				showWarning("Il n'y a aucun r\u00E8glement \u00E0 imputer.");
				window.close();
			}
			else {
				var reg=new RegExp("[,]+", "g");
				listeRemboursements = listeRemboursements.split(reg);
				remboursementId = listeRemboursements[0];
				currentIndex++;
				reinitialiser();
			}
		}
		else {
			reinitialiser();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function reinitialiser() {
	try {

		var qLoad = new QueryHttp("Facturation/Suivi_Reglements_Clients/loadRemboursementClient.tmpl");
		qLoad.setParam("Remboursement_Id", remboursementId);
		var result = qLoad.execute();

		montantTotal = parseFloat(result.responseXML.documentElement.getAttribute("Montant_Restant"));
		document.getElementById('modeReglement').value = result.responseXML.documentElement.getAttribute("Mode_Reglement");
		document.getElementById('datePiece').value = result.responseXML.documentElement.getAttribute("Date_Remboursement");
		document.getElementById('numPiece').value = result.responseXML.documentElement.getAttribute("Num_Piece");
		document.getElementById('numClient').value = result.responseXML.documentElement.getAttribute("Num_Client");
		document.getElementById('raisonSociale').value = result.responseXML.documentElement.getAttribute("Denomination");

		document.getElementById("nouveauMontant").value = "";
		document.getElementById("montantTotal").value = nf.format(montantTotal);

		document.getElementById('bIgnorer').collapsed=!boucler;
		document.getElementById('bValider').setAttribute("tooltiptext", !boucler?"valider et quitter":"valider et passer \u00E0 l'imputation suivante");
		document.getElementById('bValider').disabled=true;

		aReglements.setParam("Client_Id", result.responseXML.documentElement.getAttribute("Client_Id"));
		aReglements.setParam("Denomination", document.getElementById('raisonSociale').value);
		aReglements.setParam("Montant", montantTotal);
		aReglements.initTree(initListeReglements);

	} catch (e) {
		recup_erreur(e);
	}
}


function initListeReglements() {
	try {

		calculTotaux();

		if (aReglements.nbLignes()==0) {
			if (boucler) {
				imputationSuivante();
			}
			else {
				showWarning("Il n'y a aucun r\u00E8glement \u00E0 imputer.");
				window.close();
			}
		}
		else {
			checkValidationPossible();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function calculTotaux() {
	try {

		montantImpute = 0;

		for (var i=0; i<aReglements.nbLignes(); i++) {
			if (aReglements.getCellValue(i, "colSelReglement")=="true") {
				montantImpute += parseFloat(aReglements.getCellText(i, "colMontantImpute"));
			}
		}

		montantImpute = parseFloat(nf.format(montantImpute));
		montantRestant = montantTotal - montantImpute;

		document.getElementById("montantImpute").value = nf.format(montantImpute);
		document.getElementById("montantRestant").value = nf.format(montantRestant);

		document.getElementById("lblMontantRestant").style.color = (montantRestant==0?"green":"red");
		document.getElementById("montantRestant").style.color = (montantRestant==0?"green":"red");

	} catch (e) {
		recup_erreur(e);
	}
}


function checkValidationPossible() {
	try {

		var existeCoche = false;
		var i = 0;

		while (i<aReglements.nbLignes() && !existeCoche) {
			if (aReglements.getCellValue(i, "colSelReglement")=="true" && parseFloat(aReglements.getCellText(i, "colMontantImpute"))>0) {
				existeCoche = true;
			}
			i++;
		}

		document.getElementById('bValider').disabled = (!existeCoche);

	} catch (e) {
		recup_erreur(e);
	}
}


function changeSelReglement(i) {
	try {

		if (aReglements.getCellValue(i, "colSelReglement")=="true") {
			var montantRestant = parseFloat(aReglements.getCellText(i, "colMontantRestant"));
			var totalRestant = parseFloat(document.getElementById("montantRestant").value);

			var montant = totalRestant<=montantRestant?totalRestant:montantRestant;
			if (montant<0) {
				montant = 0;
			}

			aReglements.setCellText(i, "colMontantImpute", nf.format(montant));
		}
		else {
			aReglements.setCellText(i, "colMontantImpute", nf.format(0));
			aReglements.setCellValue(i, "colSelReglement", false);
		}

		checkValidationPossible();
		calculTotaux();

	} catch (e) {
		recup_erreur(e);
	}
}


function clickOnReglement(ev) {
	try {

		var col = aReglements.getClickedCol(ev);

		if (col!=null && col.id=="colSelReglement") {
			changeSelReglement(aReglements.getClickedRowIndex(ev));
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function selectOnListeReglements() {
	try {

		if (aReglements.isSelected()) {
			document.getElementById("nouveauMontant").value = aReglements.getSelectedCellText("colMontantImpute");
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function pressOnListeReglements(ev) {
	try {

		if (ev.keyCode==32 && aReglements.isSelected()) {
			aReglements.setSelectedCellValue("colSelReglement", aReglements.getSelectedCellValue("colSelReglement")=="false");

			changeSelReglement(aReglements.getCurrentIndex());

			document.getElementById("nouveauMontant").value = aReglements.getSelectedCellText("colMontantImpute");
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function toutDecocher() {
	try {

		for (var i=0; i<aReglements.nbLignes(); i++) {
			aReglements.setCellValue(i, "colSelReglement", false);
			aReglements.setCellText(i, "colMontantImpute", nf.format(0));
		}

		checkValidationPossible();
		calculTotaux();

	} catch (e) {
		recup_erreur(e);
	}
}


function onKeyPress(e) {
	try {
		if (e.keyCode==13) {
		 	changerMontant();
		}
	} catch (e) {
		recup_erreur(e);
	}
}


function changerMontant() {
	try {

		var montant = document.getElementById("nouveauMontant").value;

		if (!aReglements.isSelected()) { showWarning("Veuillez s\u00E9lectionner un r\u00E8glement ou un avoir"); }
		else if (!isPositiveOrNull(montant)) { showWarning("Montant incorrect !"); }
		else {
			montant = parseFloat(montant);
			var montantRestant = parseFloat(aReglements.getSelectedCellText("colMontantRestant"));
			if (montant > montantRestant) { showWarning("Le montant doit \u00EAtre inf\u00E9rieur au montant restant"); }
			else {
				aReglements.setSelectedCellText("colMontantImpute", nf.format(montant));
				aReglements.setSelectedCellValue("colSelReglement", isPositive(montant));
				aReglements.clearSelection();
				document.getElementById("nouveauMontant").value = "";

				calculTotaux();
				checkValidationPossible();
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function verifierMontantMax() {
	try {

		var continuer = true;
		var i = 0;

		while (i<aReglements.nbLignes() && continuer) {
			if (aReglements.getCellValue(i, "colSelReglement")=="true") {
				var impute = parseFloat(aReglements.getSelectedCellText("colMontantImpute"));
				var restant = parseFloat(aReglements.getSelectedCellText("colMontantRestant"));
				if (impute != restant) {
					continuer = false;
				}
			}
			else {
				continuer = false;
			}
			i++;
		}

		return continuer;

	} catch (e) {
		recup_erreur(e);
	}

}


function imputationSuivante() {
	try {

		if (boucler) {
			if (currentIndex==listeRemboursements.length) {
				majListeParente();
			} else {
				remboursementId = listeRemboursements[currentIndex];
				currentIndex++;

				reinitialiser();
			}
		} else {
			majListeParente();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function majListeParente() {
	try {

		if (validationOk && (window.arguments[2]!="")) { window.arguments[2](); }
		window.close();

	} catch (e) {
		recup_erreur(e);
	}
}


function checkAvoirAffCde() {
	try {

		var check = true;
		var i = 0;

		while (i<aReglements.nbLignes() && check) {
			if (aReglements.getCellValue(i, "colSelReglement")=="true" && aReglements.getCellText(i, "colType")=="A" && !isEmpty(aReglements.getCellText(i, "colNumCommande")) && parseFloat(aReglements.getCellText(i, "colMontantImpute"))>0
					&& !window.confirm("L'avoir N\u00B0"+ aReglements.getCellText(i, "colNumPiece") +" est affect\u00E9 \u00E0 une commande, \u00EAtes-vous s\u00FBr de vouloir continuer ?")) {
				check = false;
			}
			i++;
		}

		return check;

	} catch (e) {
		recup_erreur(e);
	}

}


function valider() {
	try {

		var ok = false;
		if (montantRestant > 0) {
			if (verifierMontantMax()) {
				ok = window.confirm("Un surplus sera cr\u00E9\u00E9 ! Etes-vous s\u00FBr de vouloir continuer ?");
			} else {
				ok = true;
			}
		}
		else if (montantRestant < 0) {
			showWarning("Vous ne pouvez pas affecter plus que le montant du remboursement !");
		}
		else {
			ok = true;
		}

		if (ok && checkAvoirAffCde()) {
			document.getElementById('bValider').disabled=true;
			document.getElementById('bIgnorer').disabled=true;
			document.getElementById('bQuitter').disabled=true;

			for (var i=0; i<aReglements.nbLignes(); i++) {
				if (aReglements.getCellValue(i, "colSelReglement")=="true") {
					var qAffecterRemboursement;
					if (aReglements.getCellText(i, "colType")=="R") {
						qAffecterRemboursement = new QueryHttp("Facturation/Suivi_Reglements_Clients/imputeReglementByRemboursement.tmpl");
						qAffecterRemboursement.setParam("Reglement_Id", aReglements.getCellText(i, "colReglementId"));
					}
					else {
						qAffecterRemboursement = new QueryHttp("Facturation/Suivi_Reglements_Clients/imputeAvoirByRemboursement.tmpl");
						qAffecterRemboursement.setParam("Avoir_Id", aReglements.getCellText(i, "colReglementId"));
					}

					qAffecterRemboursement.setParam("Montant_Imputation", aReglements.getCellText(i, "colMontantImpute"));
					qAffecterRemboursement.setParam("Remboursement_Id", remboursementId);
					var result = qAffecterRemboursement.execute();

					var errors = new Errors(result);
					if (errors.hasNext()) {
						errors.show();
					}
				}
			}

			validationOk = true;
			imputationSuivante();

			document.getElementById('bValider').disabled=false;
			document.getElementById('bIgnorer').disabled=false;
			document.getElementById('bQuitter').disabled=false;
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function quitter() {
	try {

		if (!creation || window.confirm("Attention, le remboursement a \u00E9t\u00E9 cr\u00E9\u00E9 mais pas encore imput\u00E9.\nVoulez-vous vraiment quitter ?")) {
			window.close();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function alertExit() {
	try {

		if (creation) { showWarning("Attention, le remboursement a \u00E9t\u00E9 cr\u00E9\u00E9 mais pas encore imput\u00E9."); }

	} catch (e) {
		recup_erreur(e);
	}
}


function desinit() {
	try {

		window.parent.removeEventListener("close",alertExit,false);

	} catch (e) {
  	recup_erreur(e);
  }
}
