/**********************************************************************************************/
/* OpenSi : Logiciel SaaS de gestion commerciale et comptabilit spcialis dans l'e-commerce */
/* Copyright (c) - Tous droits rservs - SAS Speedinfo Evolution                             */
/**********************************************************************************************/


var org_aReglements = new Arbre("Facturation/Suivi_Reglements_Fournisseurs/list-reglementFournisseur.tmpl", "org-listeReglements");
var org_aImputations = new Arbre("Facturation/Suivi_Reglements_Fournisseurs/list-imputationReglementFournisseur.tmpl", "org-listeEcheances");
var org_aFiltreModesReglements = new Arbre('ComboListe/combo-modesReglement.tmpl', 'org-filtreModeReglement');
var org_aBanques = new Arbre('ComboListe/combo-banques.tmpl', 'org-banqueRetrait');
var org_aFournisseurs = new Arbre('Facturation/Suivi_Reglements_Fournisseurs/combo-fournisseurs.tmpl', 'org-fournisseurId');
var org_aBanquesFournisseur = new Arbre('ComboListe/combo-banquesFournisseur.tmpl', 'org-banqueFournisseur');
var org_aModesReglements = new Arbre('ComboListe/combo-modesReglement.tmpl', 'org-modeReglement');
var org_aEtablissements = new Arbre('ComboListe/combo-etablissements.tmpl', 'org-etablissement');

var org_qListRF = new QueryHttp("Facturation/Suivi_Reglements_Fournisseurs/getDataListRF.tmpl");

var org_chargerModeReg;
var org_chargerBanqueFournisseur = "";
var org_chargerFournisseur;
var org_chargerDenominationFournisseur;
var org_selBanqueId = "";
var org_currentReglementId;
var org_currentType;

var org_pageCourante;
var org_nbPages;



function org_init() {
  try {

  	document.getElementById('org-etat').value = "N";
  	document.getElementById('org-rechDenomination').value = "";
  	document.getElementById('org-rechNumPiece').value = "";
		document.getElementById('org-nbLignesParPage').selectedIndex = 0;
  	org_aFiltreModesReglements.initTree(org_initFiltreModeReglement);

		var aFamilles = new Arbre('ComboListe/combo-famillesFournisseur.tmpl', 'org-famille');
		aFamilles.initTree();

	} catch (e) {
  	recup_erreur(e);
	}
}

function org_initFiltreModeReglement() {
	try {

		document.getElementById('org-filtreModeReglement').selectedIndex = 0;
		org_aEtablissements.setParam('Selection', etablissementDefaut);
		org_aEtablissements.initTree(org_initEtablissement);

	} catch (e) {
		recup_erreur(e);
	}
}


function org_initEtablissement() {
	try {

		document.getElementById('org-etablissement').value = etablissementDefaut;
		org_initListeReglements();

	} catch (e) {
    recup_erreur(e);
  }
}


function org_chargerFournisseurs(selection, denomination) {
	try {
		org_chargerFournisseur = selection;
		org_chargerDenominationFournisseur = denomination;
		org_aFournisseurs.setParam("Fournisseur_Id", selection);
		org_aFournisseurs.setParam("Reglement_Id", org_currentReglementId);
		org_aFournisseurs.setParam("Type", "RG");
    org_aFournisseurs.initTree(org_selectFournisseur);
	} catch (e) {
		recup_erreur(e);
	}
}


function org_chargerBanquesFournisseur() {
	try {
		var fournisseurId = document.getElementById('org-fournisseurId').value;
		if (isEmpty(fournisseurId) || fournisseurId=="0") {
			org_aBanquesFournisseur.deleteTree();
			org_initBanqueFournisseur();
		} else {
			org_aBanquesFournisseur.setParam("Fournisseur_Id", fournisseurId);
			org_aBanquesFournisseur.initTree(org_initBanqueFournisseur);
		}
	} catch (e) {
		recup_erreur(e);
	}
}


function org_initBanqueFournisseur() {
	try {
		document.getElementById('org-banqueFournisseur').setAttribute("label", org_chargerBanqueFournisseur);
		document.getElementById('org-banqueFournisseur').value = org_chargerBanqueFournisseur;
	} catch (e) {
		recup_erreur(e);
	}
}


function org_chargerBanques(selection) {
	try {

		org_selBanqueId = selection;
		org_aBanques.setParam("Selection", org_selBanqueId);
		org_aBanques.initTree(org_initBanque);

	} catch (e) {
		recup_erreur(e);
	}
}


function org_initBanque() {
  try {

		document.getElementById('org-banqueRetrait').value = org_selBanqueId;

	} catch (e) {
  	recup_erreur(e);
	}
}


function org_chargerModesReglements(selection) {
	try {
		org_chargerModeReg = selection;
		org_aModesReglements.setParam("Selection", org_chargerModeReg);
		org_aModesReglements.initTree(org_initModeReglement);
	} catch (e) {
		recup_erreur(e);
	}
}


function org_initModeReglement() {
	try {

    document.getElementById('org-modeReglement').value=org_chargerModeReg;

	} catch (e) {
    recup_erreur(e);
  }
}


function org_initListeReglements() {
	try {

		var numFournisseur = document.getElementById('org-numFournisseur').value;
		var dateDebut = document.getElementById('org-dateDebut').value;
		var dateFin = document.getElementById('org-dateFin').value;
		var etat = document.getElementById('org-etat').value;
		var denomination = document.getElementById('org-rechDenomination').value;
		var numPiece = document.getElementById('org-rechNumPiece').value;
		var modeReglement = document.getElementById('org-filtreModeReglement').value;
		var etablissement = document.getElementById('org-etablissement').value;
		var famille = document.getElementById('org-famille').value;
		var montant = document.getElementById('org-rechMontant').value;
		var nbLignesParPage = document.getElementById('org-nbLignesParPage').value;

		if (!isEmpty(dateDebut) && !isDate(dateDebut)) { showWarning("Date de d\u00E9but incorrecte !"); }
		else if (!isEmpty(dateFin) && !isDate(dateFin)) { showWarning("Date de fin incorrecte !"); }
		else if (!isEmpty(dateDebut) && !isEmpty(dateFin) && !isDateInterval(dateDebut, dateFin)) { showWarning("La date de fin doit \u00EAtre sup\u00E9rieure \u00E0 la date de d\u00E9but !"); }
		else if (!isEmpty(montant) && !isPositive(montant)) { showWarning("Montant incorrect"); }
		else {

			org_pageCourante = 1;
			org_nbPages = 1;
			document.getElementById('org-pageDeb').value = 1;
			document.getElementById('org-pageFin').value = 1;
			document.getElementById('org-bPrec').disabled = true;
			document.getElementById('org-bSuiv').disabled = true;

			document.getElementById('org-bDesaffecter').disabled = true;
			document.getElementById('org-bAffecterRegl').disabled = true;
			document.getElementById('org-bEditerPdf').disabled = true;
			document.getElementById('org-bEditionCsv').disabled = true;
			document.getElementById('org-listeReglements').disabled = true;

			org_aReglements.deleteTree();
			org_aImputations.deleteTree();
			org_nouveauReglement();

			org_qListRF.setParam("Num_Fournisseur", numFournisseur);
			org_qListRF.setParam("Date_Debut", dateDebut);
			org_qListRF.setParam("Date_Fin", dateFin);
			org_qListRF.setParam("Etat", etat);
			org_qListRF.setParam("Denomination", denomination);
			org_qListRF.setParam("Num_Piece", numPiece);
			org_qListRF.setParam("Mode_Reglement", modeReglement);
			org_qListRF.setParam("Etablissement", etablissement);
			org_qListRF.setParam("Famille", famille);
			org_qListRF.setParam("Montant", montant);
			org_qListRF.setParam("Nb_Lignes_Par_Page", nbLignesParPage);
			org_qListRF.setParam("Current_Page", org_pageCourante);

			var result = org_qListRF.execute();

			var contenu = result.responseXML.documentElement;

			document.getElementById('org-totalReglement').value = contenu.getAttribute("Total");
			document.getElementById('org-totalRestant').value = contenu.getAttribute("Restant");

			org_nbPages = contenu.getAttribute("Nb_Pages");
			var listReglementId = contenu.getAttribute("List_Reglement_Id");
			var listAvoirId = contenu.getAttribute("List_Avoir_Id");

			org_aReglements.setParam("List_Reglement_Id", listReglementId);
			org_aReglements.setParam("List_Avoir_Id", listAvoirId);
			org_aReglements.initTree(org_initPagination);
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function org_initPagination() {
	try {

		document.getElementById('org-pageDeb').value = org_pageCourante;
		document.getElementById('org-pageFin').value = (org_nbPages>0?org_nbPages:1);
		document.getElementById('org-bPrec').disabled = (org_pageCourante==1);
		document.getElementById('org-bSuiv').disabled = (org_pageCourante>=org_nbPages); // peut se produire si nbPages=0

		org_afterMajPagination();

	} catch (e) {
		recup_erreur(e);
	}
}


function org_pressOnPagePrec() {
	try {
		org_pageCourante--;
		org_majPagination();
	} catch (e) {
		recup_erreur(e);
	}
}


function org_pressOnPageSuiv() {
	try {
		org_pageCourante++;
		org_majPagination();
	} catch (e) {
		recup_erreur(e);
	}
}


function org_majPagination() {
	try {

		document.getElementById('org-pageDeb').value = org_pageCourante;
		document.getElementById('org-bPrec').disabled = (org_pageCourante==1);
		document.getElementById('org-bSuiv').disabled = (org_pageCourante==org_nbPages);

		document.getElementById('org-listeReglements').disabled = true;
		document.getElementById('org-bDesaffecter').disabled = true;
		org_aImputations.deleteTree();
		org_nouveauReglement();

		org_qListRF.setParam("Current_Page", org_pageCourante);
		var result = org_qListRF.execute();
		var listReglementId = result.responseXML.documentElement.getAttribute("List_Reglement_Id");
		var listAvoirId = result.responseXML.documentElement.getAttribute("List_Avoir_Id");

		org_aReglements.setParam("List_Reglement_Id", listReglementId);
		org_aReglements.setParam("List_Avoir_Id", listAvoirId);
		org_aReglements.initTree(org_afterMajPagination);

	} catch (e) {
		recup_erreur(e);
	}
}


function org_afterMajPagination() {
	try {

		document.getElementById('org-listeReglements').disabled = false;
		document.getElementById('org-bEditerPdf').disabled = (org_aReglements.nbLignes()==0);
		document.getElementById('org-bEditionCsv').disabled = (org_aReglements.nbLignes()==0);
		document.getElementById('org-bAffecterRegl').disabled = false;

	} catch (e) {
		recup_erreur(e);
	}
}


function org_reinitialiser() {
	try {

		document.getElementById('org-numFournisseur').value = "";
		document.getElementById('org-dateDebut').value = "";
		document.getElementById('org-dateFin').value = "";
		document.getElementById('org-etat').value = "N";
		document.getElementById('org-rechDenomination').value = "";
		document.getElementById('org-rechNumPiece').value = "";
		document.getElementById('org-filtreModeReglement').selectedIndex = 0;
		document.getElementById('org-famille').value = "";
		document.getElementById('org-rechMontant').value = "";

		org_initListeReglements();

	} catch (e) {
		recup_erreur(e);
	}
}


function org_rechercherFournisseur() {
	try {

		var url = "chrome://opensi/content/facturation/user/fournisseurs/popup-rechercheFournisseur.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', org_retourRechercherFournisseur);

	} catch (e) {
		recup_erreur(e);
	}
}


function org_retourRechercherFournisseur(codeFournisseur) {
	try {
  	document.getElementById('org-numFournisseur').value = codeFournisseur;
  	org_initListeReglements();
	} catch (e) {
		recup_erreur(e);
	}
}


function org_ajouterFournisseurListe() {
	try {

		var url = "chrome://opensi/content/facturation/user/fournisseurs/popup-rechercheFournisseur.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', org_retourAjouterFournisseurListe);

	} catch (e) {
		recup_erreur(e);
	}
}


function org_retourAjouterFournisseurListe(numFournisseur, fournisseurId) {
	try {

		org_chargerFournisseurs(fournisseurId, "");

	} catch (e) {
		recup_erreur(e);
	}
}


function org_onKeyPress(event) {
	try {
		document.getElementById('org-bEditerPdf').disabled = true;
		document.getElementById('org-bEditionCsv').disabled = true;
		if (event.keyCode==13) {
			org_initListeReglements();
		}
	} catch (e) {
		recup_erreur(e);
	}
}


function org_selectOnListeReglements() {
	try {
		if (org_aReglements.isSelected()) {
			var i = org_aReglements.getCurrentIndex();
			org_currentReglementId = org_aReglements.getCellText(i, 'org-colReglementId');
			org_currentType = org_aReglements.getCellText(i, 'org-colType');
			org_aImputations.setParam("Reglement_Id", org_currentReglementId);
			org_aImputations.setParam("Type", org_currentType);
			org_aImputations.initTree();
			document.getElementById('org-bRegulariser').disabled = (org_aReglements.getCellText(i, 'org-colEtat')=="T");

			var typeSuppression = org_aReglements.getCellText(i, 'org-colTypeSuppression');
			// 0 -> aucune interaction possible ; 1 -> suppression possible ; 2 -> annulation possible

			document.getElementById('org-bSupprimer').disabled = (org_currentType=="A" || typeSuppression!="1");
			document.getElementById('org-bSupprimer').collapsed = (org_currentType=="A" || typeSuppression=="2");
			document.getElementById('org-bAnnuler').collapsed = (org_currentType=="A" || typeSuppression!="2");

			if (org_currentType=="A") {
				org_chargerBanqueFournisseur = "";
				org_chargerModesReglements("");
				org_chargerBanques("");
				document.getElementById('org-dateReglement').value = "";
				org_chargerFournisseurs("","");
				document.getElementById('org-montant').value = "";
				document.getElementById('org-commentaires').value = "";
				document.getElementById('org-numPiece').value = "";
				document.getElementById('org-dateReglement').disabled = true;
				document.getElementById('org-banqueRetrait').disabled = true;
				document.getElementById('org-fournisseurId').disabled = true;
				document.getElementById('org-banqueFournisseur').disabled = true;
				document.getElementById('org-modeReglement').disabled = true;
				document.getElementById('org-numPiece').disabled = true;
				document.getElementById('org-montant').disabled = true;
				document.getElementById('org-recFournisseur').disabled = true;


				document.getElementById('org-commentaires').disabled = true;
				document.getElementById('org-bEnregistrerReglement').disabled = true;
			} else {

				org_chargerBanqueFournisseur = org_aReglements.getCellText(i, 'org-colBanqueFournisseur');

				var fournisseurId = org_aReglements.getCellText(i, 'org-colFournisseurId');
				var denomination = "";

				if (fournisseurId=="") { denomination = org_aReglements.getCellText(i, 'org-colDenomination'); }

				org_chargerFournisseurs(fournisseurId, denomination);

				org_chargerModesReglements(org_aReglements.getCellText(i, 'org-colModeRegId'));
				org_chargerBanques(org_aReglements.getCellText(i, 'org-colBanqueRetrait'));
				document.getElementById('org-dateReglement').value = org_aReglements.getCellText(i, 'org-colDateReglement');
				document.getElementById('org-montant').value = org_aReglements.getCellText(i, 'org-colMontant');
				document.getElementById('org-commentaires').value = org_aReglements.getCellText(i, 'org-colCommentaires');
				document.getElementById('org-numPiece').value = org_aReglements.getCellText(i, 'org-colNumPiece');

				var typeModification = org_aReglements.getCellText(i, 'org-colTypeModification');
				// 0 -> aucune interaction possible ; 1 -> modification totale possible ; 2 -> modification possible sauf pour le montant

				document.getElementById('org-dateReglement').disabled = (typeModification=="0");
				document.getElementById('org-banqueRetrait').disabled = (typeModification=="0");
				document.getElementById('org-fournisseurId').disabled = (typeModification=="0");
				document.getElementById('org-banqueFournisseur').disabled = (typeModification=="0");
				document.getElementById('org-modeReglement').disabled = (typeModification=="0");
				document.getElementById('org-numPiece').disabled = (typeModification=="0");
				document.getElementById('org-montant').disabled = (typeModification!="1");
				document.getElementById('org-fournisseurId').disabled = (typeModification!="1");
				document.getElementById('org-recFournisseur').disabled = (typeModification!="1");
				document.getElementById('org-commentaires').disabled = (typeModification=="0");
				document.getElementById('org-bEnregistrerReglement').disabled = (typeModification=="0");
			}
		}
	} catch (e) {
		recup_erreur(e);
	}
}


function org_pressOnListeReglements() {
	try {
		if (org_currentReglementId != "") {
			var url="chrome://opensi/content/facturation/user/suivi_reglements_fournisseurs/popup-imputationReglement.xul?"+ cookie();
			window.openDialog(url,'','chrome,modal,centerscreen',org_currentType,org_currentReglementId,org_initListeReglements,false);
		}
	} catch (e) {
		recup_erreur(e);
	}
}


function org_selectOnListeImputations() {
	try {
		document.getElementById('org-bDesaffecter').disabled = !org_aImputations.isSelected();
	} catch (e) {
		recup_erreur(e);
	}
}


function org_pressOnDesaffecter() {
	try {

		if (org_aImputations.isSelected() && window.confirm("Voulez-vous d\u00E9saffecter les imputations s\u00E9lectionn\u00E9es ?")) {

			var qImpEchAvoir = new QueryHttp("Facturation/Suivi_Reglements_Fournisseurs/deleteImputationEcheanceAvoirFournisseur.tmpl");
			var qImpEchReg = new QueryHttp("Facturation/Suivi_Reglements_Fournisseurs/deleteImputationEcheanceReglementFournisseur.tmpl");

			var qImpRbtAvoir = new QueryHttp("Facturation/Suivi_Reglements_Fournisseurs/deleteImputationAvoirRemboursementFournisseur.tmpl");
			var qImpRbtReg = new QueryHttp("Facturation/Suivi_Reglements_Fournisseurs/deleteImputationReglementRemboursementFournisseur.tmpl");

			var qRegulAvoir = new QueryHttp("Facturation/Suivi_Reglements_Fournisseurs/cancelRegularisationAvoirFournisseur.tmpl");
			var qRegulReg = new QueryHttp("Facturation/Suivi_Reglements_Fournisseurs/cancelRegularisationReglementFournisseur.tmpl");

			for (var i=0; i<org_aImputations.getRangeCount(); i++) {
				var start = {};
				var end = {};
				org_aImputations.getRangeAt(i,start,end);

				for (var c=start.value; c<=end.value; c++) {
					var result;

					if (org_currentType=="A" && org_aImputations.getCellText(c, 'org-colTypeImputation')=="R") {
						qRegulAvoir.setParam("Imputation_Id", org_aImputations.getCellText(c, 'org-colImputationId'));
						result = qRegulAvoir.execute();
					}
					else if (org_currentType=="A" && org_aImputations.getCellText(c, 'org-colTypeImputation')=="RB") {
						qImpRbtAvoir.setParam("Imputation_Id", org_aImputations.getCellText(c, 'org-colImputationId'));
						result = qImpRbtAvoir.execute();
					}
					else if (org_currentType=="A") {
						qImpEchAvoir.setParam("Imputation_Id", org_aImputations.getCellText(c, 'org-colImputationId'));
						result = qImpEchAvoir.execute();
					}
					else if (org_currentType=="R" && org_aImputations.getCellText(c, 'org-colTypeImputation')=="R") {
						qRegulReg.setParam("Imputation_Id", org_aImputations.getCellText(c, 'org-colImputationId'));
						result = qRegulReg.execute();
					}
					else if (org_currentType=="R" && org_aImputations.getCellText(c, 'org-colTypeImputation')=="RB") {
						qImpRbtReg.setParam("Imputation_Id", org_aImputations.getCellText(c, 'org-colImputationId'));
						result = qImpRbtReg.execute();
					}
					else if (org_currentType=="R") {
						qImpEchReg.setParam("Imputation_Id", org_aImputations.getCellText(c, 'org-colImputationId'));
						result = qImpEchReg.execute();
					}

					var errors = new Errors(result);
					if (errors.hasNext()) {
						errors.show();
					}
				}
			}

			org_initListeReglements();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function org_selectFournisseur() {
	try {

		if (isEmpty(org_chargerFournisseur) && isEmpty(org_chargerDenominationFournisseur)) {
			document.getElementById('org-fournisseurId').value = "0";
		}
		else {
			var selected = false;
			var i=0;
			var menulist = document.getElementById('org-fournisseurId');
			var items = menulist.getElementsByTagName("menuitem");
			while (!selected && i<items.length) {
				if (items[i].getAttribute(org_chargerFournisseur!=""?"value":"label").toUpperCase()==(org_chargerFournisseur!=""?org_chargerFournisseur:org_chargerDenominationFournisseur).toUpperCase()) {
					menulist.selectedIndex = i;
					selected = true;
				}
				i++;
			}
		}

		org_chargerBanquesFournisseur();

	} catch (e) {
		recup_erreur(e);
	}
}


function org_affecterReglements() {
	try {
		document.getElementById('org-bAffecterRegl').disabled = true;
		var url="chrome://opensi/content/facturation/user/suivi_reglements_fournisseurs/popup-imputationReglement.xul?"+ cookie();
		window.openDialog(url,'','chrome,modal,centerscreen','B','','',false);
		org_initListeReglements();
	} catch (e) {
		recup_erreur(e);
	}
}


function org_importerReglements() {
	try {

		var url = "chrome://opensi/content/facturation/user/suivi_reglements_fournisseurs/popup-importReglements.xul";
		window.openDialog(url,'','chrome,modal,centerscreen', org_initListeReglements);

	} catch (e) {
		recup_erreur(e);
	}
}


function org_pressOnRegulariser() {
	try {

		var message = "Voulez-vous solder "+ (org_currentType=="R"?"ce r\u00E8glement":"cet avoir") + " en perte et profit ?";
		if (window.confirm(message)) {

			var qRegulariser;

			if (org_currentType=="R") {
				qRegulariser = new QueryHttp("Facturation/Suivi_Reglements_Fournisseurs/settleReglementFournisseur.tmpl");
				qRegulariser.setParam("Reglement_Id", org_currentReglementId);
			}
			else {
				qRegulariser = new QueryHttp("Facturation/Suivi_Reglements_Fournisseurs/settleAvoirFournisseur.tmpl");
				qRegulariser.setParam("Avoir_Id", org_currentReglementId);
			}

			var result = qRegulariser.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}

			org_initListeReglements();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function org_nouveauReglement() {
	try {
		if (org_aReglements.isSelected()) {
			org_aReglements.clearSelection();
			org_aImputations.deleteTree();
		}
		document.getElementById('org-bRegulariser').disabled = true;
		document.getElementById('org-bSupprimer').disabled = true;
		document.getElementById('org-bSupprimer').collapsed = false;
		document.getElementById('org-bAnnuler').collapsed = true;
		org_currentReglementId = "";
		org_currentType = "";

		org_chargerBanqueFournisseur = "";
		document.getElementById('org-dateReglement').value = "";
		org_aBanquesFournisseur.deleteTree();
		org_chargerFournisseurs("","");
		org_chargerModesReglements("");
		org_chargerBanques("");
		document.getElementById('org-numPiece').value = "";
		document.getElementById('org-montant').value = "";
		document.getElementById('org-commentaires').value = "";
		document.getElementById('org-dateReglement').disabled = false;
		document.getElementById('org-banqueRetrait').disabled = false;
		document.getElementById('org-fournisseurId').disabled = false;
		document.getElementById('org-banqueFournisseur').disabled = false;
		document.getElementById('org-modeReglement').disabled = false;
		document.getElementById('org-numPiece').disabled = false;
		document.getElementById('org-montant').disabled = false;
		document.getElementById('org-recFournisseur').disabled = false;
		document.getElementById('org-commentaires').disabled = false;
		document.getElementById('org-bEnregistrerReglement').disabled = false;

	} catch (e) {
		recup_erreur(e);
	}
}


function org_enregistrerReglement() {
	try {
		var dateReglement = document.getElementById('org-dateReglement').value;
		var banqueRetrait = document.getElementById('org-banqueRetrait').value;
		var fournisseurId = document.getElementById('org-fournisseurId').value;
		var denomination = (isEmpty(fournisseurId)?document.getElementById('org-fournisseurId').getAttribute("label"):"");
		var banqueFournisseur = document.getElementById('org-banqueFournisseur').value;
		var modeReglement = document.getElementById('org-modeReglement').value;
		var numPiece = document.getElementById('org-numPiece').value;
		var montant = document.getElementById('org-montant').value;
		var commentaires = document.getElementById('org-commentaires').value;

		if (isEmpty(dateReglement) || !isDate(dateReglement)) { showWarning("Date incorrecte !"); }
		else if (fournisseurId=="0") { showWarning("Veuillez choisir un fournisseur !"); }
		else if (modeReglement=="") { showWarning("Veuillez choisir un mode de r\u00E8glement !"); }
		else if (isEmpty(montant) || !isPositive(montant)) { showWarning("Montant incorrect !"); }
		else if (commentaires.length>100) { showWarning("Le commentaire ne doit pas d\u00E9passer 100 caract\u00E8res !"); }
		else if (banqueFournisseur.length>30) { showWarning("La banque fournisseur ne doit pas d\u00E9passer 30 caract\u00E8res !"); }
		else if (banqueRetrait=="") { showWarning("Veuillez choisir une banque de retrait"); }
		else {

			var qEnregistrer;
			if (org_currentReglementId!="" && org_currentType=="R") {
				qEnregistrer = new QueryHttp("Facturation/Suivi_Reglements_Fournisseurs/updateReglementFournisseur.tmpl");
				qEnregistrer.setParam("Reglement_Id", org_currentReglementId);
			} else {
				qEnregistrer = new QueryHttp("Facturation/Suivi_Reglements_Fournisseurs/createReglementFournisseur.tmpl");
			}
			qEnregistrer.setParam("Date_Reglement", dateReglement);
			qEnregistrer.setParam("Banque_Retrait", banqueRetrait);
			qEnregistrer.setParam("Fournisseur_Id", fournisseurId);
			qEnregistrer.setParam("Denomination", denomination);
			qEnregistrer.setParam("Banque_Fournisseur", banqueFournisseur);
			qEnregistrer.setParam("Mode_Reglement", modeReglement);
			qEnregistrer.setParam("Num_Piece", numPiece);
			if (!document.getElementById('org-montant').disabled) { qEnregistrer.setParam("Montant", montant); }
			qEnregistrer.setParam("Commentaires", commentaires);

			var result = qEnregistrer.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else if (org_currentReglementId=="" || org_currentType!="R") {
				var reglementId = result.responseXML.documentElement.getAttribute("Reglement_Id");

				var url = "chrome://opensi/content/facturation/user/suivi_reglements_fournisseurs/popup-imputationReglement.xul?"+ cookie();
				window.openDialog(url,'','chrome,modal,centerscreen','R',reglementId,'',true);
			}

			org_initListeReglements();
			orbt_nouveauRemboursement();
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function org_pressOnSupprimer() {
	try {

		if (org_currentReglementId!="" && window.confirm("Voulez-vous supprimer le r\u00E8glement s\u00E9lectionn\u00E9 ?")) {

			var qSupprimer = new QueryHttp("Facturation/Suivi_Reglements_Fournisseurs/deleteReglementFournisseur.tmpl");
			qSupprimer.setParam("Reglement_Id", org_currentReglementId);
			var result = qSupprimer.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				showWarning("Le r\u00E8glement a \u00E9t\u00E9 supprim\u00E9");
				orbt_nouveauRemboursement();
				org_initListeReglements();
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function org_pressOnAnnuler() {
	try {

		if (org_currentReglementId!="" && window.confirm("Voulez-vous annuler le r\u00E8glement s\u00E9lectionn\u00E9 ?")) {

			var qAnnuler = new QueryHttp("Facturation/Suivi_Reglements_Fournisseurs/cancelReglementFournisseur.tmpl");
			qAnnuler.setParam("Reglement_Id", org_currentReglementId);
			var result = qAnnuler.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				showWarning("Le r\u00E8glement a \u00E9t\u00E9 annul\u00E9");
				orbt_nouveauRemboursement();
				org_initListeReglements();
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}


function org_editerPdf() {
	try {
		document.getElementById('chkDetailReg').checked = false;
		document.getElementById('triReglements').value = "Date";
		document.getElementById('chkSousTotauxReg').checked = true;
		org_rafraichirPdf();
	} catch (e) {
		recup_erreur(e);
	}
}


function org_rafraichirPdf() {
	try {
		var numFournisseur = document.getElementById('org-numFournisseur').value;
		var dateDebut = document.getElementById('org-dateDebut').value;
		var dateFin = document.getElementById('org-dateFin').value;
		var etat = document.getElementById('org-etat').value;
		var denomination = document.getElementById('org-rechDenomination').value;
		var numPiece = document.getElementById('org-rechNumPiece').value;
		var modeReglement = document.getElementById('org-filtreModeReglement').value;
		var etablissement = document.getElementById('org-etablissement').value;
		var famille = document.getElementById('org-famille').value;
		var montant = document.getElementById('org-rechMontant').value;

		if (!isEmpty(dateDebut) && !isDate(dateDebut)) { showWarning("Date de d\u00E9but incorrecte !"); }
		else if (!isEmpty(dateFin) && !isDate(dateFin)) { showWarning("Date de fin incorrecte !"); }
		else if (!isEmpty(dateDebut) && !isEmpty(dateFin) && !isDateInterval(dateDebut, dateFin)) { showWarning("La date de fin doit \u00EAtre sup\u00E9rieure \u00E0 la date de d\u00E9but !"); }
		else if (!isEmpty(montant) && !isPositive(montant)) { showWarning("Montant incorrect"); }
		else {
			var detail = document.getElementById('chkDetailReg').checked;
			var triReglements = document.getElementById('triReglements').value;
			var sousTotaux = document.getElementById('chkSousTotauxReg').checked;

			var qGenPdf = new QueryHttp("Facturation/Suivi_Reglements_Fournisseurs/pdfListeReglements.tmpl");
			qGenPdf.setParam("Etat", etat);
			qGenPdf.setParam("Denomination", denomination);
			qGenPdf.setParam("Num_Piece", numPiece);
      qGenPdf.setParam("Date_Debut", dateDebut);
      qGenPdf.setParam("Date_Fin", dateFin);
      qGenPdf.setParam("Mode_Reglement", modeReglement);
      qGenPdf.setParam("Num_Fournisseur", numFournisseur);
			qGenPdf.setParam("Etablissement", etablissement);
      qGenPdf.setParam("Famille", famille);
			qGenPdf.setParam("Montant", montant);
      qGenPdf.setParam("Detail", detail);
      qGenPdf.setParam("Tri", triReglements);
      qGenPdf.setParam("Sous_Totaux", sousTotaux);
      var result = qGenPdf.execute();
      var page = getDirPdf() + result.responseXML.documentElement.getAttribute('fichier');
			switchPdf(page);
		}
	} catch (e) {
		recup_erreur(e);
	}
}


function org_pressOnEditionCsv() {
	try {

		var numFournisseur = document.getElementById('org-numFournisseur').value;
		var dateDebut = document.getElementById('org-dateDebut').value;
		var dateFin = document.getElementById('org-dateFin').value;
		var etat = document.getElementById('org-etat').value;
		var denomination = document.getElementById('org-rechDenomination').value;
		var numPiece = document.getElementById('org-rechNumPiece').value;
		var modeReglement = document.getElementById('org-filtreModeReglement').value;
		var etablissement = document.getElementById('org-etablissement').value;
		var famille = document.getElementById('org-famille').value;
		var montant = document.getElementById('org-rechMontant').value;

		if (!isEmpty(dateDebut) && !isDate(dateDebut)) { showWarning("Date de d\u00E9but incorrecte !"); }
		else if (!isEmpty(dateFin) && !isDate(dateFin)) { showWarning("Date de fin incorrecte !"); }
		else if (!isEmpty(dateDebut) && !isEmpty(dateFin) && !isDateInterval(dateDebut, dateFin)) { showWarning("La date de fin doit \u00EAtre sup\u00E9rieure \u00E0 la date de d\u00E9but !"); }
		else if (!isEmpty(montant) && !isPositive(montant)) { showWarning("Montant incorrect"); }
		else {

			var qEditionCsv = new QueryHttp("Facturation/Suivi_Reglements_Fournisseurs/csvReglementFournisseur.tmpl");

			qEditionCsv.setParam("Num_Fournisseur", numFournisseur);
			qEditionCsv.setParam("Denomination", denomination);
			qEditionCsv.setParam("Etat", etat);
			qEditionCsv.setParam("Date_Debut", dateDebut);
			qEditionCsv.setParam("Date_Fin", dateFin);
			qEditionCsv.setParam("Num_Piece", numPiece);
			qEditionCsv.setParam("Mode_Reglement", modeReglement);
			qEditionCsv.setParam("Etablissement", etablissement);
			qEditionCsv.setParam("Famille", famille);
			qEditionCsv.setParam("Montant", montant);

			var result = qEditionCsv.execute();

			var errors = new Errors(result);
			if (errors.hasNext()) {
				errors.show();
			}
			else {
				var fichier = result.responseXML.documentElement.getAttribute('FichierCSV');

				var file = fileChooser("save", fichier);
				if (file!=null) {
					downloadFile(getDirBuffer()+ fichier, file);
				}
			}
		}

	} catch (e) {
		recup_erreur(e);
	}
}
